// Persistence of Vision Raytracer Version 3.0
//
// file: orion7.pov     autor: -- jd --     version: 301198
// The fast cruiser Orion 7(a) near MZ4, hunted by the aliens

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"

camera {
    location  < 0.66, -0.2,  0.4>
    direction <0, 0, 1>
    up        <0, 1, 0>
    right   <4/3, 0, 0>
    look_at   <0, 0, 0>
//  panoramic angle 120
//  look_at <-350, 200, -80>
}

// The next Sun
object {
    sphere { 0, 4
        pigment { color rgbt <1, 1, 1, 1> }
        halo {
          emitting
          spherical_mapping
          linear
          color_map {
            [ 0 color rgbt <1, 1, 0.5, 1> ]
            [ 1 color rgbt <1, 1, 0.8, -2> ]
          }
          scale 1
          samples 20
        }
        hollow
    }
    translate <20, 0, -20>
}
light_source { < 20, 0, -20> color White }

#declare orion7 =
union
{
    union
    {
        difference
        {
            cone { <0,0.05, 0>, 2, <0,0.20, 0>, 0.45 }
            difference
            {
                cylinder { <0,  0.065, 0>, <0,  0.25, 0>, 2 }
                cylinder { <0,  0.30, 0>, <0,  0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*45
            }
            difference
            {
                cylinder { <0,  0.065, 0>, <0,  0.25, 0>, 2 }
                cylinder { <0,  0.30, 0>, <0,  0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*135
            }
            difference
            {
                cylinder { <0,  0.065, 0>, <0,  0.25, 0>, 2 }
                cylinder { <0,  0.30, 0>, <0,  0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*225
            }
            difference
            {
                cylinder { <0,  0.065, 0>, <0,  0.25, 0>, 2 }
                cylinder { <0,  0.30, 0>, <0,  0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*315
            }
        }
        difference
        {
            cone { <0,-0.05, 0>, 1.95, <0,-0.25, 0>, 0.45 }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*45
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*90
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*135
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*180
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*225
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*270
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
                rotate y*315
            }
            difference
            {
                cylinder { <0, -0.065, 0>, <0, -0.25, 0>, 2 }
                cylinder { <0, -0.30, 0>, <0, -0.05, 0>, 1.5 }
                box { < 3, -1, 0>, <-3, 1, -3> rotate y*-22.2 }
                box { <-3, -1, 0>, < 3, 1,  3> rotate y*22.2 }
            }
        }
        cone { <0,-0.266, 0>, 0.5 , <0,-0.3, 0>, 0.2 }
        pigment { Silver }
        texture { T_Silver_2C }
    }
    
    union
    {
        triangle { <1,-0.1,0>, < 2.2, 0.2, 0>, <0, 0.1, 0> }
        cone { <2.4, 0.215, 0>, 0.005, <0, 0.1, 0>, 0.025 }
        triangle { <1,-0.1,0>, < 2.2, 0.2, 0>, <0, 0.1, 0> rotate y*90 }
        cone { <2.4, 0.215, 0>, 0.005, <0, 0.1, 0>, 0.025 rotate y*90 }
        triangle { <1,-0.1,0>, < 2.2, 0.2, 0>, <0, 0.1, 0> rotate y*180 }
        cone { <2.4, 0.215, 0>, 0.005, <0, 0.1, 0>, 0.025 rotate y*180 }
        triangle { <1,-0.1,0>, < 2.2, 0.2, 0>, <0, 0.1, 0> rotate y*270 }
        cone { <2.4, 0.215, 0>, 0.005, <0, 0.1, 0>, 0.025 rotate y*270 }
    
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*45 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*45 }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*90 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*90 }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*135 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*135 }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*180 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*180 }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*225 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*225 }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*270 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*270 }
        triangle { <1.94,-0.05,0>, < 2.1,-0.1, 0>, <0.2,-0.295, 0> rotate y*315 }
        triangle { <1.94,-0.05,0>, <0.2,-0.295, 0>, <0.0,-0.05, 0> rotate y*315 }
        pigment { color rgb <0.4, 0.4, 0.4> }
        texture { T_Chrome_4D }
    }
    
    union
    {
        difference
        {
            cylinder { <0,0.20, 0>, <0,0.21, 0>, 0.4 }
            cylinder { <0, 0.2, 0>, <0, 0.3, 0>, 0.39 }
        }
        difference
        {
            cylinder { <0,0.20, 0>, <0,0.21, 0>, 0.4 }
            cylinder { <0, 0.2, 0>, <0, 0.275, 0>, 0.39 }
        }
        pigment { color rgb <0.2, 0.2, 0.2> }
        finish { diffuse 0.8 }
    }
    
    union
    {
        cylinder {   <0,0.05,0>, <0,-0.05,0>, 1.85 }
        cone { <0, 0.2, 0>, 0.39, <0, 0.35, 0>, 0 }
        cylinder { <0,-0.266, 0>, <0, -0.308, 0>, 0.195 }

        pigment { Red }
        normal { bumps 0.2 scale 0.2 }
        finish { brilliance 3 diffuse 0.5 roughness 0.005 ambient 0.95 }
    }

    scale <0.2, 0.2, 0.2>
}

#declare frog =
union
{
    union
    {   box { <0.25, 0.25, 0.25>, <-0.25, -0.25, -0.25> }
        mesh
        {
            triangle { <0.25, 0.25, 0>, <0.25,-0.25, 0>, <0.25, 0.25, 1.75> }
            triangle { <0.25, 0.25, 0>, <-0.25,0.25, 0>, <0.25, 0.25, 1.75> }
            triangle { <0.25,-0.25, 0>, <-0.25,0.25, 0>, <0.25, 0.25, 1.75> }
            rotate x*-25
            rotate y*25
        }
        mesh
        {
            triangle { <0.25, 0.25, 0>, <0.25,-0.25, 0>, <0.25, 0.25, 1.75> }
            triangle { <0.25, 0.25, 0>, <-0.25,0.25, 0>, <0.25, 0.25, 1.75> }
            triangle { <0.25,-0.25, 0>, <-0.25,0.25, 0>, <0.25, 0.25, 1.75> }
            rotate  z*90
            rotate x*-25
            rotate y*-25
        }
        pigment { color rgb <0.9, 0.9, 0.9> }
//      normal { dents 0.5 scale 0.1 }
        texture { T_Chrome_5B }
    }
    cone
    {
        <0, 0, 0>, 0.075, <0, 0, -1>, 0
        pigment { color rgb <0.5, 0.5, 0.5> }
        texture { T_Silver_1A }
    }
    scale <0.2, 0.2, 0.2>
}


#declare universe =
sphere
{   <0,0,0> 1000 hollow
    texture
    {   pigment
        {   granite
            color_map
            {
                [ 0.000  0.190 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                [ 0.190  0.200 color rgb <.5,.7,.9> color rgb <.6,.8, 1> ]
                [ 0.200  0.490 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                [ 0.490  0.500 color rgb <.7,.7,.5> color rgb < 1, 1,.7> ]
                [ 0.500  0.690 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                [ 0.690  0.700 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
                [ 0.700  0.800 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                [ 0.800  0.810 color rgb <.7,.5,.5> color rgb < 1,.9,.9> ]
                [ 0.710  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            }
            turbulence 1
            sine_wave
            scale 200
        }
        finish { diffuse 0 ambient 1 }
    }
}

// MZ4
sphere { <0,0,0> 3 texture { pigment { image_map { gif "somecrater.gif" map_type 1 } } } finish { ambient 0.25 } rotate y*210 scale <1, 0.9, 1> translate -11*x }

// A star
object {
    sphere { 0, 1
        pigment { color rgbt <1, 1, 1, 1> }
        halo {
          emitting
          spherical_mapping
          linear
          color_map {
            [ 0 color rgbt <1, 0.5, 0.2, 1> ]
            [ 1 color rgbt <1, 0, 0, 0> ]
          }
          scale 0.6
          samples 20
        }
        hollow
    }
    translate <-50, -10, -30>
}

// A star
object {
    sphere { 0, 1
        pigment { color rgbt <1, 1, 1, 1> }
        halo {
          emitting
          spherical_mapping
          linear
          color_map {
            [ 0 color rgbt <1, 1, 1, 1> ]
            [ 1 color rgbt <1, 1, 0.5, -0.3> ]
          }
          scale 0.66
          samples 20
        }
        hollow
    }
    translate <-50, 50, -50>
}

orion7
object { frog rotate y*205 translate <-10.5,-1.5, -15> }
object { frog rotate y*205 translate <-10,  -1,  -14> }
object { frog rotate y*200 translate <-9.5, -0.5, -13 > }
object { frog rotate y*200 translate <-9,   0, -12 > }
object { frog rotate y*200 translate <-9.5, -0.5, -12 > }
object { frog rotate y*200 translate <-10,  -1, -13 > }
object { frog rotate y*205 translate <-10.5,-1.5, -14> }
universe
