/*
 *  Author: Jeffrey Anderson
 *  Name  : Roach.pov
 *  Title : Through another's eyes.
 *  
 *  For IRTC topic "First Encounter"
 *
 */

#include "colors.inc"
#include "floor.pov"
#include "skirting.pov"
#include "powerpnt.pov"
#include "antennae.pov"
#include "foot.pov"
#include "shoelace.pov"
#include "lead.pov"
#include "basket.pov"
#include "drawer.pov"

camera {
  location <-7, 0, 3>
  look_at <0, 0, 0>
  up <0, 1, 0>
}

light_source {
  <1, 5, 7> color White
}

#declare pair = union {
                  object {
                    antennae1
                    scale 0.5
                    rotate <00, -20, -60>
                    translate <0, -7, -3>
                  }

                  object {
                    antennae1
                    scale 0.5
                    rotate <0, 20, -50>
                    translate <0, -7, 3>
                  }
                }

object {
  pair  // of antennae
  scale 0.2
  rotate y * 20
  translate <-5, 0.5, 2.2>
}

object {
  shoe
  rotate <90, 0, 70>
  translate <-5, 1, 5>
}

object {
  shoe_lace
  scale 0.2
  rotate x * -30
  translate <-5, 0.85, 2.9>
}

object {
  lead
  scale 0.4
  rotate <0, 90, -5>
  translate <1, -2, 1>
}

object {
  drawers
  scale 1.2
  translate <20, 4.2, 7.5>
}

object {
  basket
  pigment { Tan }
  scale 0.2
  translate <14, -2, 6>
}

object {
  wood_floor
  rotate z * -90
  translate <-3.5, -2, 0>
}

union {
  object {skirting_board translate x * -10}

  object {skirting_board rotate y * -90 translate <20, 0, -5>}

  translate <0, -2.2, -2.1>
}


plane { x, 24
  pigment {
    bumps
    color_map {
      [0 rgb <1, 1, 1>]
      [0.5 rgb <0.9, 0.9, 0.9>]
      [1 rgb <1, 1, 1>]
    }
    scale 0.2
  }
}

plane { z, -4.7
  pigment {
    bumps
    color_map {
      [0 rgb <1, 1, 1>]
      [0.5 rgb <0.9, 0.9, 0.9>]
      [1 rgb <1, 1, 1>]
    }
    scale 0.2
  }
}

object {
  power_point
  rotate y * 90
  scale 0.8
  translate <2, 2, -4.75>
}
