
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 1
  distance    15.0
  color <0.654902,0.694118,0.819608,0.101961,0.498039>
  scattering   0.3
  samples      10
  jitter       0.0
  aa_threshold 1.0
  aa_level     3
}

camera {
  location  <-7.864, 15.856, 7.081>
  direction <0.0,     0.0,  2.4629>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.537, 1.349, -0.439>
}


light_source {
  <-9.195, -6.068, 9.396>
    color  rgb <1.052, 1.100, 1.100>
    spotlight
  //  point_at  <-8.642, -5.555, 8.740>
    point_at  <-8.542, -5.555, 8.740>
    falloff   13.00  // outer radius (in deg)
    radius    11.00  // inner radius
  fade_distance  10.0
  fade_power 2.0
}


light_source
  { <5,100,200>
     //color <0.7,0.7,1>
     color <1,1,1>
    fade_distance 120
    fade_power 1
    shadowless
  }


#include "botte.inc"
#include "milou_concours_1.inc"
#include "milou_concours_2.inc"

#declare solsol=
  height_field {
    //tga "Output.tga"
    //gif "solune11.gif"
    tga "solune5.tga"
    water_level 0.0
    smooth
    rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
    /* texture {
              pigment {
                        image_map { tga "solune2.tga"}
                       }
              finish {ambient 0.15
                      specular 0.2
                      }
             }
     */
    scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
    translate < -1,-1,-1> // Center around origin
    scale <10.0, 10.0, 0.3>
    translate  <2.5, -2.9, -1.6>
   }
#declare bigsol=
 union { object {solsol}
         object {solsol translate 20*x}
         object {solsol translate <20,-20,0>}
         object {solsol translate -20*y}
         texture {
          //Asteroid
          Asteroid2
          //bete_blanc
           }
        }
object{bigsol}

/*
object {
  Botte // arrire droite
  texture {
    orange_body
  }
  scale 0.135902
  rotate <90.13475, 3.039814, 81.881859>
  translate  <1.31474, -0.893787, -1.65>
}

object {
  Botte // avant gauche
  texture {
    orange_body
  }
  scale 0.135902
  rotate <84.454872, -3.970041, 90.146584>
  translate  <1.292408, 1.963113, -1.8>
}

object {
  Botte // arrire gauche
  texture {
    orange_body
  }
  scale 0.135902
  rotate <92.209335, -1.708624, 107.070747>
  translate  <-1.122085, -0.790271, -1.68>
}

#declare queue = union {
  sphere { 
    <0,0,0>,1
    scale 0.15
    translate  0.5*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.15, 0.15, 0.5>
  }
  texture {
    orange_body
  }
  rotate 29.909872*x
  translate  <0.0, -0.516728, 0.721015>
}
#declare bague_casque = union {
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Copper_Metal
    }
    scale <1.0, 1.0, 0.3>
    rotate -90.0*x
    translate  2.34*y
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal1
    }
    scale <1.05, 1.05, 0.1>
    rotate -90.0*x
    translate  2.43*y
  }
  rotate 3.711861*x
  translate  -0.184877*z
}
#declare coque = union {
  sphere { 
    <0,0,0>,1
    scale <1.0, 1.211691, 1.026461>
    translate  1.817536*y
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.026461, 1.817536>
    rotate -90.0*x
  }
  sphere { 
    <0,0,0>,1
    texture {
      orange_body
    }
    scale <1.0, 0.95, 1.026461>
  }
  object { queue }
  object { bague_casque }
  texture {
    orange_body
  }
}
#declare corps_etape_1 = difference {
  object { coque }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Copper_Metal
    }
    scale <0.8, 0.8, 1.264998>
    rotate -90.0*x
    translate  <-0.089531, 1.752281, 0.0>
  }
}
union { 
  object { corps_etape_1 }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      noir_mat
    }
    scale <0.93, 0.93, 0.17>
    rotate -86.575264*x
    translate  <0.0, 2.404681, -0.03193>
  }
}

object {
  chien
  texture {
    orange_body
  }
  scale 1.217263
  rotate -60.353157*x
  translate  <0.0, 2.971756, 1.281614>
}


#declare CSG8 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.274405, 0.327848, 0.367066>
  rotate <-13.370742, 6.178062, 12.17206>
  translate  <-0.98333, -0.388101, -0.358751>
}
union { 
  object { CSG8 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.177413, 0.184045, 0.236209>
    rotate <-25.329811, -4.111715, 13.401926>
    translate  <-1.025236, -0.539372, -0.804657>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.213525, 0.196022, 0.262245>
    rotate <-17.707054, 1.347245, 17.92252>
    translate  <-1.009255, -0.411189, -0.464214>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.169452, 0.155701, 0.20766>
    rotate <-25.411369, -7.280098, 12.007298>
    translate  <-1.006105, -0.667539, -1.123373>
  }
  texture {
    orange_body
  }
  rotate <33.619442, 23.489645, 149.058365>
  translate  <0.0, -0.039807, -0.225575>
}


#declare CSG7 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.274405, 0.327848, 0.367066>
  rotate <-13.370742, 6.178062, 12.17206>
  translate  <-0.98333, -0.388101, -0.358751>
}
union { 
  object { CSG7 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.177413, 0.184045, 0.236209>
    rotate <-9.245589, 7.223684, 10.576549>
    translate  <-1.084698, -0.569241, -0.705614>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.169452, 0.155701, 0.20766>
    rotate <-7.194753, 2.712145, 10.747312>
    translate  <-1.141579, -0.657442, -1.051224>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.213525, 0.196022, 0.262245>
    rotate <-15.526152, 16.805201, 9.290883>
    translate  <-1.004277, -0.417531, -0.389532>
  }
  texture {
    orange_body
  }
}


#declare CSG5 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.305084, 0.384851, 0.384851>
  translate  <-3.756858, 1.701913, -0.634782>
}
union { 
  object { CSG5 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.205371, 0.224908, 0.258579>
    rotate <5.232771, 6.871511, 0.249985>
    translate  <-3.805149, 1.736155, -1.089572>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.196144, 0.190117, 0.227524>
    rotate <6.988806, 7.113812, 0.3612>
    translate  <-3.851661, 1.788216, -1.481039>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.232038, 0.224908, 0.26916>
    rotate <3.684261, 5.235925, 0.227685>
    translate  <-3.739079, 1.709018, -0.67697>
  }
  texture {
    orange_body
  }
  scale <0.863098, 0.817464, 0.915251>
  rotate 7.275306*x
  translate  <2.207662, 0.287857, 0.060697>
}

object {
  Botte
  texture {
    orange_body
  }
  scale 0.135902
  rotate <93.88723, -1.203086, 107.171089>
  translate  <-1.151861, 1.888668, -1.753369>
}


#declare CSG002 = difference {
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat
    }
    scale <0.3, 0.154, 0.1>
    translate  <0.0, 1.76, 1.2>
  }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat
    }
    scale <0.28, 0.14, 0.3>
    translate  <0.0, 1.76, 1.2>
  }
  texture {
    noir_mat
  }
}
union { 
  object { CSG002 }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      Chrome_Metal1
    }
    scale <0.28, 0.14, 0.1>
    translate  <0.0, 1.76, 1.192>
  }
}


#declare CSG004 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.305084, 0.384851, 0.384851>
  translate  <-3.756858, 1.701913, -0.634782>
}
union { 
  object { CSG004 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.231833, 0.2249, 0.269407>
    rotate <3.841117, 8.664001, 0.92664>
    translate  <-3.739079, 1.709018, -0.67697>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.205165, 0.225114, 0.258603>
    rotate <1.846054, 10.058365, 0.336305>
    translate  <-3.820311, 1.734332, -1.080344>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.196209, 0.190428, 0.227078>
    rotate <2.311018, 5.746266, -0.535494>
    translate  <-3.944616, 1.749715, -1.477994>
  }
  texture {
    orange_body
  }
  scale <0.863098, 0.817464, 0.915251>
  rotate <-11.830271, 0.469743, -178.622391>
  translate  <-2.234231, 2.942368, 0.497893>
}


cylinder { 
  <0,0,1>, <0,0,0>, 1
  texture {
    Chrome_Metal1
  }
  scale <1.07, 1.07, 0.15>
  rotate -90.0*x
  translate  0.864813*y
}


cylinder { 
  <0,0,1>, <0,0,0>, 1
  texture {
    Copper_Metal
  }
  scale <1.05, 1.05, 0.3>
  rotate -90.0*x
  translate  0.79*y
}


union { 
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 1.0>
    rotate 13.089097*x
    translate  <0.0, 0.469695, 4.364611>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.02, 0.02, 2.0>
    rotate 3.207835*x
    translate  <0.0, 0.7, 1.4>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.012, 0.012, 1.0>
    rotate 6.856761*x
    translate  <0.0, 0.586978, 3.384304>
  }
  sphere { 
    <0,0,0>,1
    scale <0.02, 0.02, 0.01>
    rotate 13.585766*x
    translate  <0.000157, 0.241404, 5.344363>
  }
  texture {
    Chrome_Metal1
  }
}

difference { 
  superellipsoid { 
    <1.0, 0.117>
    texture {
      noir_mat
    }
    scale <0.21, 0.21, 0.2>
    translate  <0.0, 0.29, 1.3>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal1
    }
    scale <0.16, 0.16, 0.3>
    translate  <0.0, 0.29, 1.3>
  }
}


superellipsoid { 
  <1.0, 0.117>
  texture {
    rouge_lampe
  }
  scale <0.19, 0.19, 0.2>
  translate  <0.0, 0.29, 1.32>
}


cylinder { 
  <0,0,1>, <0,0,0>, 1
  texture {
    gris
  }
  scale <0.19, 0.19, 0.2>
  translate  <0.0, 1.25, 1.11>
}


#declare CSG4 = difference {
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat
    }
    scale <0.3, 0.154, 0.1>
    translate  <0.0, 1.76, 1.2>
  }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat
    }
    scale <0.28, 0.14, 0.3>
    translate  <0.0, 1.76, 1.2>
  }
  texture {
    noir_mat
  }
}
union { 
  object { CSG4 }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      Chrome_Metal1
    }
    scale <0.28, 0.14, 0.1>
    translate  <0.0, 1.76, 1.192>
  }
  scale <0.45, 0.35, 1.0>
  rotate -90.0*z
  translate  <-0.949, 0.7, 0.19>
}


#declare CSG3 = difference {
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat
    }
    scale <0.3, 0.154, 0.1>
    translate  <0.0, 1.76, 1.2>
  }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat
    }
    scale <0.28, 0.14, 0.3>
    translate  <0.0, 1.76, 1.2>
  }
  texture {
    noir_mat
  }
}
union { 
  object { CSG3 }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      Chrome_Metal1
    }
    scale <0.28, 0.14, 0.1>
    translate  <0.0, 1.76, 1.192>
  }
  scale <0.45, 0.35, 1.0>
  rotate -90.0*z
  translate  <-0.28, 0.7, 0.19>
}


superellipsoid { 
  <0.05, 0.05>
  texture {
    beige_sacoche
  }
  scale <0.49, 1.03, 0.2282>
  translate  <0.0, 0.971, 1.05>
}


superellipsoid { 
  <0.05, 0.05>
  texture {
    beige_sacoche
  }
  scale <0.49, 0.48, 0.521>
  translate  <0.0, 0.421, 0.95>
}


union { // bombonne_gauche
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
    translate  1.3*z
  }
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 1.3>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.05>
    translate  1.71*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 0.16>
    translate  1.567675*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  -0.0*x
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  <-0.0, 0.0, 1.15>
  }
  texture {
    bleu_bombonne
  }
  scale <1.0, 1.0, 1.19>
  rotate -90.0*x
  translate  <-0.85, 0.2, 1.03>
}


union { // bombonne_droite
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
    translate  1.3*z
  }
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 1.3>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.05>
    translate  1.71*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 0.16>
    translate  1.567675*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  -0.0*x
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  <-0.0, 0.0, 1.15>
  }
  texture {
    bleu_bombonne
  }
  scale <1.0, 1.0, 1.19>
  rotate -90.0*x
  translate  <0.85, 0.2, 1.03>
}


difference { // casque_verre
  sphere { 
    <0,0,0>,1
    translate  <0.0, 3.07, 0.0>
  }
  sphere { 
    <0,0,0>,1
    scale 0.99
    translate  3.07*y
  }
  texture {
    NBglass
  }
  scale <1.2, 1.2, 1.25>
  rotate -2.877241*x
  translate  <0.0, -0.361, 0.3293>
}

*/
#declare tube_droite = difference {
  torus { 
    1.05, 0.05  rotate -x*90
    sturm
    scale <0.298065, 0.883011, 1.0>
    rotate -90.0*x
    translate  <0.583114, 2.185715, 0.467957>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <0.197788, 0.231214, 0.799447>
    translate  <0.850025, 2.172298, 0.250691>
  }
  texture {
    rouge_anneau_1
  }
  rotate <-0.0, 0.0, 168.663208>
  translate  <0.375872, 4.146712, -0.024001>
}
#declare tube_gauche = difference {
  torus { 
    1.05, 0.05  rotate -x*90
    sturm
    scale <0.298065, 0.883011, 1.0>
    rotate -90.0*x
    translate  <0.583114, 2.185715, 0.467957>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <0.197788, 0.231214, 0.799447>
    translate  <0.850025, 2.172298, 0.250691>
  }
  texture {
    rouge_anneau_1
  }
  rotate <-0.0, 0.0, 14.58559>
  translate  <0.599046, -0.13784, 0.033425>
}
#declare boucle_ceinture = difference {
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.030968, -0.115269, -0.086022>
    rotate -180.0*x
    translate  <0.0, 0.935914, 0.146237>
  }
  box { 
    <-1, -1, -1>, <1, 1, 1>
    scale <-0.126021, -0.07871, -0.042151>
    rotate -180.0*x
    translate  <0.0, 0.935914, 0.146237>
  }
  texture {
    Copper_Metal_1
  }
  translate  <-1.043763, 0.007312, -0.043871>
}
#declare ceinture = union {
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal1_1
    }
    scale <1.07, 1.07, 0.15>
    rotate -90.0*x
    translate  0.864813*y
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Copper_Metal_1
    }
    scale <1.05, 1.05, 0.3>
    rotate -90.0*x
    translate  0.79*y
  }
  object { boucle_ceinture }
}
#declare sac_a_dos = union {
  superellipsoid { 
    <0.05, 0.05>
    texture {
      beige_sacoche_1
    }
    scale <0.49, 1.03, 0.2282>
    translate  <0.0, 0.971, 1.05>
  }
  superellipsoid { 
    <0.05, 0.05>
    texture {
      beige_sacoche_1
    }
    scale <0.49, 0.48, 0.521>
    translate  <0.0, 0.421, 0.95>
  }
}
#declare CSG10 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.305084, 0.384851, 0.384851>
  translate  <-3.756858, 1.701913, -0.634782>
}
#declare CSG11 = union {
  object { CSG10 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.205371, 0.224908, 0.258579>
    rotate <5.232771, 6.871511, 0.249985>
    translate  <-3.805149, 1.736155, -1.089572>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.196144, 0.190117, 0.227524>
    rotate <6.988806, 7.113812, 0.3612>
    translate  <-3.851661, 1.788216, -1.481039>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.232038, 0.224908, 0.26916>
    rotate <3.684261, 5.235925, 0.227685>
    translate  <-3.739079, 1.709018, -0.67697>
  }
  texture {
    orange_body_1
  }
  scale <0.863098, 0.817464, 0.915251>
  rotate 7.275306*x
  translate  <2.207662, 0.287857, 0.060697>
}
#declare Botte4_Ref = object {
  Botte
  texture {
    orange_body_1
  }
  scale 0.135902
  rotate <93.88723, -1.203086, 107.171089>
  translate  <-1.151861, 1.888668, -1.753369>
}
#declare jambe_avant_droite = union {
  object { CSG11 }
  object { Botte4_Ref }
}
#declare Botte5_Ref = object {
  Botte
  texture {
    orange_body_1
  }
  scale 0.135902
  rotate <92.209335, -1.708624, 107.070747>
  translate  <-1.122085, -0.790271, -1.740107>
}
#declare CSG12 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder {
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.274405, 0.327848, 0.367066>
  rotate <-13.370742, 6.178062, 12.17206>
  translate  <-0.98333, -0.388101, -0.358751>
}
#declare CSG13 = union {
  object { CSG12 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.177413, 0.184045, 0.236209>
    rotate <-9.245589, 7.223684, 10.576549>
    translate  <-1.084698, -0.569241, -0.705614>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.169452, 0.155701, 0.20766>
    rotate <-7.194753, 2.712145, 10.747312>
    translate  <-1.141579, -0.657442, -1.051224>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.213525, 0.196022, 0.262245>
    rotate <-15.526152, 16.805201, 9.290883>
    translate  <-1.004277, -0.417531, -0.389532>
  }
  texture {
    orange_body_1
  }
}
#declare jambe_arriere_droite = union {
  object { Botte5_Ref }
  object { CSG13 }
}
#declare Botte6_Ref = object {
  Botte
  texture {
    orange_body_1
  }
  scale 0.135902
  rotate <90.13475, 3.039814, 81.881859>
  translate  <1.31474, -0.893787, -1.713583>
}
#declare CSG14 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.274405, 0.327848, 0.367066>
  rotate <-13.370742, 6.178062, 12.17206>
  translate  <-0.98333, -0.388101, -0.358751>
}
#declare CSG15 = union {
  object { CSG14 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.177413, 0.184045, 0.236209>
    rotate <-25.329811, -4.111715, 13.401926>
    translate  <-1.025236, -0.539372, -0.804657>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.213525, 0.196022, 0.262245>
    rotate <-17.707054, 1.347245, 17.92252>
    translate  <-1.009255, -0.411189, -0.464214>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.169452, 0.155701, 0.20766>
    rotate <-25.411369, -7.280098, 12.007298>
    translate  <-1.006105, -0.667539, -1.123373>
  }
  texture {
    orange_body_1
  }
  rotate <33.619442, 23.489645, 149.058365>
  translate  <0.0, -0.039807, -0.225575>
}
#declare jambe_arriere_gauche = union {
  object { Botte6_Ref }
  object { CSG15 }
}
#declare CSG16 = union {
  sphere { 
    <0,0,0>,1
    translate  1.0*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    rotate 90.0*y
    translate  1.0*z
  }
  scale <0.305084, 0.384851, 0.384851>
  translate  <-3.756858, 1.701913, -0.634782>
}
#declare CSG17 = union {
  object { CSG16 }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.231833, 0.2249, 0.269407>
    rotate <3.841117, 8.664001, 0.92664>
    translate  <-3.739079, 1.709018, -0.67697>
  }
  torus {
    1.1555, 0.8445  rotate -x*90
    scale <0.205165, 0.225114, 0.258603>
    rotate <1.846054, 10.058365, 0.336305>
    translate  <-3.820311, 1.734332, -1.080344>
  }
  torus { 
    1.1555, 0.8445  rotate -x*90
    scale <0.196209, 0.190428, 0.227078>
    rotate <2.311018, 5.746266, -0.535494>
    translate  <-3.944616, 1.749715, -1.477994>
  }
  texture {
    orange_body_1
  }
  scale <0.863098, 0.817464, 0.915251>
  rotate <-11.830271, 0.469743, -178.622391>
  translate  <-2.234231, 2.942368, 0.497893>
}
#declare Botte7_Ref = object {
  Botte
  texture {
    orange_body_1
  }
  scale 0.135902
  rotate <84.454872, -3.970041, 90.146584>
  translate  <1.292408, 1.963113, -1.728471>
}
#declare jambe_avant_gauche = union {
  object { CSG17 }
  object { Botte7_Ref }
}
#declare queue1 = union {
  sphere { 
    <0,0,0>,1
    scale 0.15
    translate  0.5*z
  }
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    scale <0.15, 0.15, 0.5>
  }
  texture {
    orange_body_1
  }
  rotate 29.909872*x
  translate  <0.0, -0.516728, 0.721015>
}
#declare bague_casque1 = union {
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Copper_Metal_1
    }
    scale <1.0, 1.0, 0.3>
    rotate -90.0*x
    translate  2.34*y
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal1_1
    }
    scale <1.05, 1.05, 0.1>
    rotate -90.0*x
    translate  2.43*y
  }
  rotate 8.739368*x
  translate  <0.0, 0.033543, -0.30787>
}
#declare coque1 = union {
  sphere { 
    <0,0,0>,1
    scale <1.0, 1.211691, 1.026461>
    translate  1.817536*y
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.026461, 1.817536>
    rotate -90.0*x
  }
  sphere { 
    <0,0,0>,1
    texture {
      orange_body_1
    }
    scale <1.0, 0.95, 1.026461>
  }
  object { queue1 }
  object { bague_casque1 }
  texture {
    orange_body_1
  }
}
#declare corps_etape_3 = difference {
  object { coque1 }
  cylinder { // creux1
    <0,0,1>, <0,0,0>, 1
    texture {
      Copper_Metal_1
    }
    scale <0.8, 0.8, 1.264998>
    rotate -90.0*x
    translate  <-0.089531, 1.752281, 0.0>
  }
}
#declare corps_etape_4 = union {
  object { corps_etape_3 }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      noir_mat_1
    }
    scale <0.93, 0.93, 0.17>
    rotate -81.161461*x
    translate  <0.0, 2.39909, 0.046338>
  }
}
#declare chien2_Ref = object {
  chien
  texture {
    orange_body_1
  }
  scale 1.217263
  rotate -60.353157*x
  translate  <0.0, 2.971756, 1.281614>
}
#declare CSG18 = difference {
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat_1
    }
    scale <0.3, 0.154, 0.1>
    translate  <0.0, 1.76, 1.2>
  }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat_1
    }
    scale <0.28, 0.14, 0.3>
    translate  <0.0, 1.76, 1.2>
  }
  texture {
    noir_mat_1
  }
}
#declare plaquette_1 = union {
  object { CSG18 }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      Chrome_Metal1_1
    }
    scale <0.28, 0.14, 0.1>
    translate  <0.0, 1.76, 1.192>
  }
}
#declare antenne1 = union {
  cylinder { 
    <0,0,1>, <0,0,0>, 0.03
    scale <1, 1, 1.80>
    rotate 9*x
    translate  <0.0, 0.7, 1.4>
  }
  /*
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.01, 0.01, 1.0>
    rotate 13.089097*x
    translate  <0.0, 0.469695, 4.364611>
  }
    cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.012, 0.012, 1.0>
    rotate 6.856761*x
    translate  <0.0, 0.586978, 3.384304>
  } 
  sphere { 
    <0,0,0>,1
    scale <0.02, 0.02, 0.01>
    rotate 13.585766*x
    translate  <0.000157, 0.241404, 5.344363>
  } 
  */
  texture {
    Chrome_Metal1_1
  }
}
#declare lampe_rouge = difference {
  superellipsoid { 
    <1.0, 0.117>
    texture {
      noir_mat_1
    }
    scale <0.21, 0.21, 0.2>
    translate  <0.0, 0.29, 1.3>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      Chrome_Metal1_1
    }
    scale <0.16, 0.16, 0.3>
    translate  <0.0, 0.29, 1.3>
  }
}
#declare CSG19 = difference {
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat_1
    }
    scale <0.3, 0.154, 0.1>
    translate  <0.0, 1.76, 1.2>
  }
  superellipsoid {
    <0.272, 0.03>
    texture {
      noir_mat_1
    }
    scale <0.28, 0.14, 0.3>
    translate  <0.0, 1.76, 1.2>
  }
  texture {
    noir_mat_1
  }
}
#declare plaquette_4 = union {
  object { CSG19 }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      Chrome_Metal1_1
    }
    scale <0.28, 0.14, 0.1>
    translate  <0.0, 1.76, 1.192>
  }
  scale <0.45, 0.35, 1.0>
  rotate -90.0*z
  translate  <-0.949, 0.7, 0.19>
}
#declare CSG20 = difference {
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat_1
    }
    scale <0.3, 0.154, 0.1>
    translate  <0.0, 1.76, 1.2>
  }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      noir_mat_1
    }
    scale <0.28, 0.14, 0.3>
    translate  <0.0, 1.76, 1.2>
  }
  texture {
    noir_mat_1
  }
}
#declare plaquette_5 = union {
  object { CSG20 }
  superellipsoid { 
    <0.272, 0.03>
    texture {
      Chrome_Metal1_1
    }
    scale <0.28, 0.14, 0.1>
    translate  <0.0, 1.76, 1.192>
  }
  scale <0.45, 0.35, 1.0>
  rotate -90.0*z
  translate  <-0.28, 0.7, 0.19>
}
#declare bombonne_gauche1 = union {
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
    translate  1.3*z
  }
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 1.3>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.05>
    translate  1.71*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 0.16>
    translate  1.567675*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau_1
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  -0.0*x
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau_1
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  <-0.0, 0.0, 1.15>
  }
  texture {
    bleu_bombonne_1
  }
  scale <1.0, 1.0, 1.19>
  rotate -90.0*x
  translate  <-0.85, 0.2, 1.03>
}
#declare bombonne_droite1 = union {
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
    translate  1.3*z
  }
  sphere { 
    <0,0,0>,1
    scale <0.3, 0.3, 0.33>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 1.3>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.05>
    translate  1.71*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    scale <0.03, 0.03, 0.16>
    translate  1.567675*z
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau_1
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  -0.0*x
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      rouge_anneau_1
    }
    scale <0.35, 0.35, 0.15>
    rotate 0.0*x
    translate  <-0.0, 0.0, 1.15>
  }
  texture {
    bleu_bombonne_1
  }
  scale <1.0, 1.0, 1.19>
  rotate -90.0*x
  translate  <0.85, 0.2, 1.03>
}
#declare casque_verre1 = difference {
  sphere { 
    <0,0,0>,1
    translate  <0.0, 3.07, 0.0>
  }
  sphere { 
    <0,0,0>,1
    scale 0.99
    translate  3.07*y
  }
  texture {
    NBglass_1
  }
  scale <1.201152, 1.201152, 1.2512>
  rotate 6.60567*x
  translate  <0.0, -0.267722, -0.159987>
}
union { // milou_complet
  object { tube_droite }
  object { tube_gauche }
  object { ceinture }
  object { sac_a_dos }
  object { jambe_avant_droite }
  object { jambe_arriere_droite }
  object { jambe_arriere_gauche }
  object { jambe_avant_gauche }
  object { corps_etape_4 }
  object { chien2_Ref }
  object { plaquette_1 }
  object { antenne1 }
  object { lampe_rouge }
  superellipsoid { 
    <1.0, 0.117>
    texture {
      rouge_lampe_1
    }
    scale <0.19, 0.19, 0.2>
    translate  <0.0, 0.29, 1.32>
  }
  cylinder { 
    <0,0,1>, <0,0,0>, 1
    texture {
      gris_1
    }
    scale <0.19, 0.19, 0.2>
    translate  <0.0, 1.25, 1.11>
  }
  object { plaquette_4 }
  object { plaquette_5 }
  object { bombonne_gauche1 }
  object { bombonne_droite1 }
  object { casque_verre1 }
}

#include "os.inc"


