#include "colors.inc"
#include "textures.inc"

#declare final = 1
camera {
        location  <0, 3,-7>
        look_at   <0, 3, 0.01>
#ifdef (final)
        aperture 0.1
        blur_samples 6
        focal_point <0, 0, 3>
#end
//    location  <-7, 3, 0>
// look_at   <0, 3, 0.01>

}

// Bright light to left and above main screen
light_source {<-30, 25, -30> color White}

fog
{
  fog_type 1
  turbulence 0.3
  distance 100
  color Gray90
}


// ---------------------------------------
// sky

plane {z, 50
hollow
texture {
         pigment {
                  gradient y
                  color_map {
                  [0.0 color rgb <0.427, 0.58, 0.741>]
                  [1.0 color rgb <0.125, 0.286, 0.537>] }
                  scale 40
         }
}
texture {
         pigment {
                  bozo
                  turbulence 0.7
                  color_map{
                  [0.0 color Gray80]
                  [0.3 color Clear]
                  [1.0 color Clear] }
                  scale <30, 20, 1>
         }
}
}

// ---------------------------------------------
// trees shrubs etc
#declare Bark = texture {
pigment {granite
         color_map {
         [0.0 color DarkBrown]
         [0.5 color DarkGreen]
         [1.0 color Tan] }
        }
normal {granite
        scale 0.2}
}
#declare Bark1 = texture {
pigment {bozo
         color_map {
         [0.0 color DarkBrown]
         [1.0 color Tan] }
        }
normal {marble
        turbulence 0.2
        scale 0.2}
}
#declare Bark2 = texture {
pigment {bozo
         turbulence 0.3
         color_map {
         [0.0 color Wheat]
         [1.0 color DarkGreen]}
         }
normal {dents 0.8
        scale 0.1}
}

#declare Fern_text = texture {
pigment {marble
         color_map {
         [0.0 color DarkGreen]
         [1.0 color rgb <0.486, 0.6, 0.482>]}
         rotate <0, 90, 0>
         scale 0.1
         }
normal {marble rotate <0, 90, 0> scale 0.1}
}


#declare R1 = seed(2525)

#declare Fern_Leaf = union {

#declare Count = 1
#while (Count < 15)
sphere {<0.05, 0, 0>, 0.05
        texture {Fern_text}
        scale <10, 0.5, 2>
        rotate <0, Count * (5+rand(R1)), rand(R1)*20 - 10>
        translate <3 - Count/5, 0, 0>
}
sphere {<0.05, 0, 0>, 0.05
        texture {Fern_text}
        scale <10, 0.5, 2>
        rotate <0, -Count * (5+rand(R1)), rand(R1)*20 - 10>
        translate <3 - Count/5, 0, 0>
}
#declare Count = Count + 1.2
#end

cone {<3.5, 0, 0>, 0
      <0, 0, 0>, 0.05
      pigment {color DarkGreen}
}

} // end Fern_Leaf union

#declare Fern_Leaf1 = union {
#declare Count = 1
#while (Count < 15)
sphere {<0.05, 0, 0>, 0.05
        scale <10, 0.5, 2>
        rotate <0, Count * (5+rand(R1)), rand(R1)*20 - 10>
        translate <3 - Count/5, 0, 0>
}
sphere {<0.05, 0, 0>, 0.05
        scale <10, 0.5, 2>
        rotate <0, -Count * (5+rand(R1)), rand(R1)*20 - 10>
        translate <3 - Count/5, 0, 0>
}
#declare Count = Count + 1.2
#end

cone {<3.5, 0, 0>, 0
      <0, 0, 0>, 0.05
      pigment {color Tan}
}

} // end Fern_Leaf union


#declare Count = -10
#while (Count < 10)
cylinder {<0, -3, 0>, <0, 15, 0>, rand(R1)*0.2
         #declare R = rand(R1)
         #if (R < 0.3) texture {Bark2 translate rand(R1)*2}
         #end
         #if ((R < 0.6) & (R >=0.3)) texture {Bark1 translate rand(R1)*2}
         #end
         #if (R >= 0.6) texture {Bark1}
         #end
         rotate <0, 0, 20-rand(R1)*40>
         translate <Count, 0, 3 + rand(R1)*4>
}
cylinder {<0, -3, 0>, <0, 15, 0>, rand(R1)*0.2
         #declare R = rand(R1)
         #if (R < 0.3) texture {Bark}
         #end
         #if ((R < 0.6) & (R >=0.3)) texture {Bark1}
         #end
         #if (R >= 0.6) texture {Bark2}
         #end
         rotate <0, 0, 20-rand(R1)*40>
         translate <Count, 0, 5 + rand(R1)*4>
}
cylinder {<0, -3, 0>, <0, 15, 0>, rand(R1)*0.2
         #declare R = rand(R1)
         #if (R < 0.3) texture {Bark}
         #end
         #if ((R < 0.6) & (R >=0.3)) texture {Bark1}
         #end
         #if (R >= 0.6) texture {Bark2}
         #end
         rotate <0, 0, 20-rand(R1)*40>
         translate <Count, 0, 7 + rand(R1)*4>
}

object {Fern_Leaf
       rotate <rand(R1) * 360, rand(R1) * 180, rand(R1) * 360>
       translate <Count, 3 + rand(R1) * 4, 3.5>
}

#declare Count=Count + 0.3
#end

object {Fern_Leaf
        rotate <70, 0, 50>
        translate <-2.4, 2, -5>
}

// ---------------------------------------------
// statue
#declare Stone =
texture {
        pigment {
                marble
                turbulence 1
                color_map {
                [0.0 color Gray70]
                [0.3 color Gray70]
                [0.6 color rgb <0.9, 0.75, 0.65>]
                [1.0 color rgb <0.9, 0.75, 0.65>] }
                scale 0.2
                }
        normal {granite 0.2}
       finish {Dull
               crand 0.3}
}
texture {
        pigment {bozo
                 turbulence 0.3
                 color_map {
                 [0.0 color Clear]
                 [0.6 color Clear]
                 [0.85 color White]
                 [1.0 color Orange]}
                 scale 0.3
                 }
        normal {granite scale 0.1}
}

#declare Toe = difference {
superellipsoid {<0.5, 1.0>}
plane {y, 0}
scale 0.2
}

#declare Ear =
union {
  difference {
    cylinder {<0, 0, 0.2>, <0, 0, -0.1>, 0.4
              scale <0.5, 1.1, 1>}
    cylinder {<0, 0, 0>, <0, 0, -0.2>, 0.3
              scale <0.5, 1.1, 1>}
  }
  difference {
    cylinder {<0, -0.6, 0>, <0, -0.6, -0.2>, 0.25}
    cone {<0, -0.6, -0.1>, 0.1
          <0, -0.6, -0.21>, 0.25
          open
    }
  }
  cylinder {<0, -0.6, -0.1>, <0, -0.6, -0.07>, 0.1}
} // end union

#declare H_Part = union {
difference {
  box {<-1, -0.4, 0.2>, <0, 0.4, 0.8> }
  box {<-0.9, -0.3, 0.3>, <0, 0.3, 0.1> pigment{color Red}}
} // end diff
box {<-0.8, -0.2, 0.2>, <0, 0.2, 0.5>}
} // end union

#declare Statue = union {
// headdress
#declare Count = 0
#while (Count < 10)
object {H_Part
        translate <-0.8, 0, 0>
        rotate <0, 0, -20*Count>
        translate <0, 4, 0>
}

#declare Count=Count + 1
#end

// head
superellipsoid {<0.8, 0.4>
                clipped_by {plane {y, 0.25 inverse} }
                scale <1, 1.1, 0.5>
                translate <0, 4, 0.4>
}

difference {
  superellipsoid {<0.8, 0.4>
                  clipped_by {plane {y, 0.25} }
                  scale <0.9, 1.1, 0.4>
                 translate <0, 4, 0.4>
  }
  sphere {<0, 0, 0>, 0.1
          scale <2, 1, 0.5>
          translate <-0.3, 4, 0>
  }
  sphere {<0, 0, 0>, 0.1
          scale <2, 1, 0.5>
          translate <0.3, 4, 0>
  }
  superellipsoid {<0.3, 0.5>
                  scale <0.4, 0.1, 0.1>
                  translate<0, 3.4, 0>
  }
}

// eyes
sphere {<0.3, 4, 0.1>, 0.12}
sphere {<-0.3, 4, 0.1>, 0.12}

// nose
blob {
     threshold 0.7
     sphere {<0, 3.7, 0>, 0.4, 1}
     cylinder {<0, 4.1, 0>, <0, 3.7, 0>, 0.2, 1}
     sphere {<-0.2, 3.7, 0>, 0.2, 1}
     sphere {<0.2, 3.7, 0>, 0.2, 1}
     scale <1, 1, 0.5>
}

object {Ear
       rotate <0, 0, 5>
       translate <-1, 3.9, 0.2>
}
object {Ear
       rotate <0, 0, -5>
       translate <1, 3.9, 0.2>
}

// necklace
sphere {<0, 2.6, 0.1>, 0.1}
sphere {<-0.25, 2.65, 0.1>, 0.1}
sphere {<-0.5, 2.8, 0.1>, 0.1}
sphere {<-0.7, 3, 0.1>, 0.1}
sphere {<0.25, 2.65, 0.1>, 0.1}
sphere {<0.5, 2.8, 0.1>, 0.1}
sphere {<0.7, 3, 0.1>, 0.1}

// body
superellipsoid {<0.5, 0.5>
                scale <1.45, 1, 0.4>
                translate <0, 2.1, 0.5>
}
// arms
union {
superellipsoid {<0.3, 0.5>
                scale <0.6, 0.4, 0.5>
                translate <-0.6, 1.8, 0>}
superellipsoid {<0.5, 0.3>
                scale <0.4, 0.85, 0.5>
                translate <-0.9, 2.25, 0>}
rotate <0.7, 12, 0>
translate <-0.21, 0, 0.3>
}

union {
superellipsoid {<0.3, 0.5>
                scale <0.6, 0.4, 0.5>
                translate <0.6, 1.8, 0>}
superellipsoid {<0.5, 0.3>
                scale <0.4, 0.85, 0.5>
                translate <0.9, 2.25, 0>}
rotate <0.7, -12, 0>
translate <0.21, 0, 0.3>
}

// skirt
superellipsoid {<0.2, 0.2>
               scale <0.1, 0.33, 0.1>
               translate <0, 1, 0>}
superellipsoid {<0.2, 0.2>
               scale <0.1, 0.22, 0.1>
               translate <-0.2, 1.1, 0>}
superellipsoid {<0.2, 0.2>
               scale <0.1, 0.11, 0.1>
               translate <-0.4, 1.2, 0>}
superellipsoid {<0.2, 0.2>
               scale <0.1, 0.22, 0.1>
               translate <0.2, 1.1, 0>}
superellipsoid {<0.2, 0.2>
               scale <0.1, 0.11, 0.1>
               translate <0.4, 1.2, 0>}
superellipsoid {<0.2, 0.2>
               scale <0.1, 0.11, 0.1>
               translate <0.4, 1.2, 0>}
superellipsoid {<0.2, 0.2>
               scale <1.3, 0.14, 0.6>
               translate <0, 1.4, 0.5>}
// legs
superellipsoid {<0.1, 0.2>
                scale <0.6, 0.35, 0.5>
                rotate <-5, 0, 0>
                translate <-0.7, 0.4, 0.5>
}
superellipsoid {<0.1, 0.2>
                scale <0.6, 0.35, 0.5>
                rotate <5, 0, 0>
                translate <-0.7, 0.85, 0.5>
}
superellipsoid {<0.1, 0.2>
                scale <0.6, 0.35, 0.5>
                rotate <-5, 0, 0>
                translate <0.7, 0.4, 0.5>
}
superellipsoid {<0.1, 0.2>
                scale <0.6, 0.35, 0.5>
                rotate <5, 0, 0>
                translate <0.7, 0.85, 0.5>
}

box {<-0.25, 0, 0.1>, <0.25, 1.3, 1>}
object {Toe translate <-1, 0, 0>}
object {Toe translate <-0.7, 0, 0>}
object {Toe translate <-0.4, 0, 0>}
object {Toe translate <1, 0, 0>}
object {Toe translate <0.7, 0, 0>}
object {Toe translate <0.4, 0, 0>}

texture {Stone}
} // end statue union

object {Statue}

// --------------------------------------------
// basic ground
plane {y, 0
hollow
texture {Bark scale 3}
}

superellipsoid {<0.5, 0.5>
                scale <1.5, 1, 1>
                rotate <-20, 40, -30>
                translate <3, 0, 1>
                texture {Stone}
}

// ground texturing

#declare Count = -10
#while (Count < 10)

object {Fern_Leaf1
        rotate <rand(R1) * 20, rand(R1) * 360, 0>
        translate <Count, 0, rand(R1) * 5 - 1>
        pigment {color rgb <0.8 + rand(R1)*0.1, 0.6+rand(R1)*0.1, 0.5>}
}
cylinder {<0, 0, 0>, <1+rand(R1)*2, 0, 0>, rand(R1)*0.08
          rotate <0, rand(R1)*360, 0>
          translate <Count, 0.1, rand(R1) * 5 - 2>
          pigment {color rgb <0.6 + rand(R1)*0.2, 0.5+rand(R1)*0.1, 0.4>}
}
cylinder {<0, 0, 0>, <1+rand(R1)*2, 0, 0>, rand(R1)*0.08
          rotate <0, rand(R1)*360, 0>
          translate <Count, 0.1, rand(R1) * 5 - 2>
          pigment {color rgb <0.6 + rand(R1)*0.2, 0.5+rand(R1)*0.1, 0.4>}
}
#declare Count=Count + 1
#end
