
// POV-Ray Object File - Buildings
// created 26-Nov-98
// last update 27-Dec-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "Buildings.inc" in another .pov file
// Required #include files: "GUnits.inc"
//
// Objects:
// RandomBuildings
// WhiteDockBuilding
// FarawayRandomBuildings
// FarawayRandomTrees
// Warehouse
// AdminBuilding
// SigBuilding (with copyright label)
// BigOilTank (camoflaged)
// OilTankGroup
// IslandBuilding
// Trees
//
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#macro Stripe(Direction,Thickness,Scale,Color)
pigment {
	gradient Direction
		color_map {
			[ Thickness/Scale color Color ]
			[ Thickness/Scale color rgbt<1,1,1,1> ]
		}
		scale Scale
}
#end

#declare WhitePaint =
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare AdminBldgPaint =
	texture {
		pigment { color rgb<1.38,1.32,1.22> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .42 diffuse .6 specular .6 roughness .05 crand .014 }
	}
#declare AdminInteriorPaint =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 color rgb<.98,.98,.98> ]
				[ 1.0 color rgb<.43,.39,.22> ]
			}
			scale 9*Feet
		}
		finish { ambient .4 diffuse .5 }
	}
#declare SigPaint = // for signature
	texture {
		pigment { color rgb<.34,.34,.30> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .99 roughness .08 }
	}
#declare DarkGlass =
	texture {
		pigment { color rgb<.29,.28,.22> }
//		pigment { color rgb<1.29,1.28,.22> }
		normal { bumps .02 scale 20*cm }
		finish { ambient .1 diffuse .7 specular .96 roughness .0008 reflection .16 }
//		finish { ambient .1 diffuse .7 specular .96 roughness .0008 }
//		finish { ambient .8 diffuse .7 specular .96 roughness .0008 }
	}
#declare LBConcrete =
	texture {
		pigment { color rgb<.90,.88,.85> }
		normal { bumps .15 scale 11*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .12 crand .3 }
	}
#declare GreyRoofTex =
	texture {
		pigment { color rgb<.45,.48,.42> }
		normal { bumps .2 scale 1*cm }
		finish { ambient .06 diffuse .7 specular .4 roughness .3 }
	}
#declare DarkWoodTex =
	texture {
		pigment { color rgb<.73,.62,.40> }
		normal { bumps .2 scale 1*cm }
		finish { ambient .1 diffuse .7 specular .7 roughness .05 }
	}
#declare DullPaint =
	texture {
		pigment { color rgb<.09,.08,.02> }
		normal { bumps .02 scale 5*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare PalletTex =
	texture {
		pigment { color rgb<.73,.82,.69> }
		normal { bumps .2 scale 1*cm }
		finish { ambient .1 diffuse .7 specular .7 roughness .05 }
	}
#declare AlumTex =
	texture {
		pigment { color rgb<.75,.78,.72> }
		normal { bumps .13 scale 16*cm }
		finish { ambient .12 diffuse .7 metallic specular .94 roughness .13 reflection .3 }
	}
#declare OilTankCamoflage =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 color rgb<.13,.13,.05> ]
				[ 0.4 color rgb<.13,.13,.05> ]
				[ 0.4 color rgb<.903,.863,.678> ]
			}
		}
		finish { ambient .12 diffuse .7 metallic specular .94 roughness .13 reflection .3 }
	}
#declare BrownWood =
	texture {
		pigment { color rgb<.502,.278,.141> }
		normal { bumps .2 scale 1*cm }
		finish { ambient .1 diffuse .7 specular .4 roughness .12 crand .2 }
	}
#declare GreenTreeTex = // for faraway trees
	texture {
		pigment { color rgb<.072,.538,.141> }
		normal { bumps .12 scale 24*cm }
		finish { ambient .1 diffuse .3 specular .2 roughness .02 crand .02 }
	}
#declare GreyBuildingTex = // for faraway random buildings
	texture {
		pigment {
			bozo
			color_map {
				[ 0.0 color rgb<.29,.28,.22> ]
				[ 0.4 color rgb<.59,.58,.52> ]
			}
			scale <5*Feet,1*Feet,5*Feet>
		}
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .3 specular .3 roughness .05 }
	}

//===============================================
//						 Objects
//===============================================

#macro WindowFrameCutout(Height,Width) // creates the hole
	box { // frame
		<-Width/2,0,-1>,<Width/2,Height,24*Inches>
		texture { DarkWoodTex }
	}
#end
#macro WindowFrame(Height,Width) // window in Z plane
//	union {
		difference {
			box { // frame
				<-Width/2,0,0>,<Width/2,Height,8*Inches>
				texture { DarkWoodTex }
			}
			box { // glass cutout
				<-Width/2+2.0*Inches,2*Inches,-1>,<Width/2-2.0*Inches,Height-2*Inches,8*Inches+1>
				texture { DarkWoodTex }
			}
		} // end difference
/*
		box { // glass
			<-Width/2,0,4*Inches>,<Width/2,Height,4.1*Inches>
			texture { DarkGlass }
		}
*/
//	}
#end

//-------------- White Dock Building ------------------

#declare WhiteDockBuilding =
	union {
		difference {
			box { // main
				<0,0,0>,<60*Feet,18*Feet,40*Feet>
				texture { WhitePaint }
			}
			box { // roof
				<3*Feet,16*Feet,3*Feet>,<57*Feet,20*Feet,37*Feet>
				texture { GreyRoofTex }
			}
			object { WindowFrameCutout(8*Feet,4*Feet) translate < 6*Feet,5*Feet,-4.5*Inches> }
			object { WindowFrameCutout(8*Feet,4*Feet) translate <14*Feet,5*Feet,-4.5*Inches> }
			object { WindowFrameCutout(8*Feet,4*Feet) translate <34*Feet,5*Feet,-4.5*Inches> }
			object { WindowFrameCutout(8*Feet,4*Feet) translate <42*Feet,5*Feet,-4.5*Inches> }
		} // end difference 
			object { WindowFrame(8*Feet,4*Feet) translate < 6*Feet,5*Feet,-4.5*Inches> }
			object { WindowFrame(8*Feet,4*Feet) translate <14*Feet,5*Feet,-4.5*Inches> }
			object { WindowFrame(8*Feet,4*Feet) translate <34*Feet,5*Feet,-4.5*Inches> }
			object { WindowFrame(8*Feet,4*Feet) translate <42*Feet,5*Feet,-4.5*Inches> }
		box { // roof box
			<0,0,0>,<36*inches,21*inches,29*inches>
			translate <14*Feet,16*Feet,21*Feet>
			texture { GreyRoofTex }
		}
	} // end union

//-------------- Misc Buildings ------------------

#declare FarawayRandomBuildings =
	union {
		#declare RS = seed(24653);
		#declare ACount=0;
		#while ( ACount < 148 ) // dense group
			box {
				<0,-1,0>,<1,1,1>
				scale <14*Feet+rand(RS)*22*Feet,8*Feet+rand(RS)*14*Feet,16*Feet+rand(RS)*30*Feet>
				rotate y*rand(RS)*360
				translate <100*Meters+rand(RS)*700*Meters,rand(RS)*3*Meters,rand(RS)*1400*Meters>
			}
			#declare ACount = ACount + 1;
		#end
		#declare BCount=0;
		#while ( BCount < 50 ) // scattered group
			box {
				<0,-1,0>,<1,1,1>
				scale <18*Feet+rand(RS)*30*Feet,7*Feet+rand(RS)*8*Feet,22*Feet+rand(RS)*30*Feet>
				rotate y*rand(RS)*360
				translate <-700*Meters+rand(RS)*2400*Meters,rand(RS)*3*Meters,rand(RS)*1400*Meters>
			}
			#declare BCount = BCount + 1;
		#end
		rotate x*-1 // align to sloping landscape
		texture { GreyBuildingTex }
	}
#declare FarawayRandomTrees =
	union {
		#declare RS = seed(39872);
		#declare Count=0;
		#while ( Count < 184 )
			sphere {
				<0,0,0>,.5
				#declare TreeScale = 8*Feet+rand(RS)*28*Feet;
				scale <TreeScale,TreeScale+rand(RS)*18*Feet,TreeScale>
				translate <-200*Meters+rand(RS)*1700*Meters,10*Meters+rand(RS)*4*Meters,rand(RS)*1400*Meters>
			}
			#declare Count = Count + 1;
		#end
		rotate x*-1 // align to sloping landscape
		texture { GreenTreeTex }
	}

#declare SignalTower =
	union {
		box { <-20*Feet,0,-20*Feet>,<20*Feet,140*Feet,20*Feet>
			//#macro Stripe(Direction,Thickness,Scale,Color)
			texture { Stripe(y,2*Feet,10*Feet,<.1,.1,.1>) }
		}
		cylinder { <0,0,0>,<0,140*Feet,0>,5*Feet }
		box { <-14*Feet,0,-14*Feet>,<14*Feet,21*Feet,14*Feet> translate <0,140*Feet,0> }
		texture { WhitePaint }
	}

#declare Warehouse =
	union {
		difference {
			box {
				<0,0,0>,<240*Feet,50*Feet,55*Feet>
			}
			box {
				<-1,0,-1>,<241*Feet,30*Feet,80*Feet>
				rotate x*-24
				translate <0,36*Feet,0>
			}
			texture { WhitePaint }
			texture { Stripe(x,8*inch,14*Feet,rgb<.25,.215,.254> ) }
		} // end difference
		box { // roof
			<-3*Feet,0,-3*Feet>,<243*Feet,2*Feet,74*Feet>
			rotate x*-24
			translate <0,36*Feet,0>
			texture { GreyRoofTex }
		}
	}

#declare LowBuilding =
	box {
		<0,0,0>,<140*Feet,18*Feet,40*Feet>
		texture { LBConcrete }
	}

//-------------- Adminstration Building ------------------

#declare CVent =
	union {
		torus { 1.8*Feet,6*Inches translate <0,16*Inches,0> }
		cylinder { <0,0,0>,<0,16*Inches,0>,1.0*Feet }
		sphere { <0,0,0>,1.1*Feet scale <1,.6,1> translate <0,21*Inches,0> }
		texture { AlumTex }
	}

#declare AdminBuilding =
	union {
		difference {
			box { // main
				<0,0,0>,<160*Feet,29*Feet,68*Feet>
				texture { AdminBldgPaint }
			}
			box { // roof
				<3*Feet,27*Feet,3*Feet>,<157*Feet,30*Feet,65*Feet>
				texture { GreyRoofTex }
			}
			box { // interior lower floor
				<.6*Feet,3*Feet,.6*Feet>,<159.4*Feet,12*Feet,64.4*Feet>
				texture { AdminInteriorPaint }
			}
			box { // interior upper floor
				<.6*Feet,13*Feet,.6*Feet>,<159.4*Feet,26*Feet,64.4*Feet>
				texture { AdminInteriorPaint }
			}
			#local WCount = 0;
			#while ( WCount < 19 )
				object { WindowFrameCutout(5*Feet,2.6*Feet) translate <10*Feet+WCount*14*Feet,6*Feet,0> }
				object { WindowFrameCutout(5*Feet,2.6*Feet) translate <10*Feet+WCount*14*Feet,16*Feet,0> }
				object { WindowFrameCutout(5*Feet,2.6*Feet) translate <15*Feet+WCount*14*Feet,6*Feet,0> }
				object { WindowFrameCutout(5*Feet,2.6*Feet) translate <15*Feet+WCount*14*Feet,16*Feet,0> }
				#local WCount = WCount + 1;
			#end
		} // end difference 
		#local WCount = 0;

		#while ( WCount < 10 )
			object { WindowFrame(5*Feet,2.6*Feet) translate <10*Feet+WCount*14*Feet,6*Feet,0> }
			object { WindowFrame(5*Feet,2.6*Feet) translate <10*Feet+WCount*14*Feet,16*Feet,0> }
			object { WindowFrame(5*Feet,2.6*Feet) translate <15*Feet+WCount*14*Feet,6*Feet,0> }
			object { WindowFrame(5*Feet,2.6*Feet) translate <15*Feet+WCount*14*Feet,16*Feet,0> }
			#local WCount = WCount + 1;
		#end

		box { // roof box
			<0,0,0>,<36*inches,9*inches,22*Feet>
			translate <14*Feet,27*Feet,21*Feet>
			texture { WhitePaint }
		}
		cylinder { <0,0,0>,<0,5*Feet,0>,3*Inches translate <109*Feet,27*Feet,26*Feet> texture { DarkGlass } }// pipe
		cylinder { <0,0,0>,<0,5*Feet,0>,3*Inches translate <109*Feet,27*Feet,56*Feet> texture { DarkGlass } }// pipe
		object { CVent translate <60*Feet,27*Feet,24*Feet> }
		object { CVent translate <60*Feet,27*Feet,44*Feet> }
		object { CVent translate <120*Feet,27*Feet,24*Feet> }
		object { CVent translate <120*Feet,27*Feet,44*Feet> }
	} // end union

#declare SigBuilding =
	union {
		text {
			ttf "ARIAL.TTF",
			" 1998",
			3*Feet,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { SigPaint }
			scale <8*Feet,7*Feet,1>
			translate <8*Feet,18*Feet,-2*Feet>
		}
		text {
			ttf "ARIAL.TTF",
			"N.B. & G.M.",
			3*Feet,     // THICKNESS_FLOAT
			0       //OFFSET_VECTOR
			texture { SigPaint }
			scale <10*Feet,9*Feet,1>
			translate <8*Feet,7*Feet,-2*Feet>
		}
		object { AdminBuilding }
		box { <0,0,-1>,<75*Feet,24*Feet,1> texture { AdminBldgPaint } } // covers windows
	}

//-------------- Oil Tanks ------------------

#declare BigOilTank =
	union {
		cylinder { <0,0,0>,<0,66*Feet,0>,36*Feet }
		cone { <0,0,0>,36*Feet,<0,8*Feet,0>,3*Feet translate <0,66*Feet,0> }
	}
#local OTSpacing = 200*Feet;
#declare OilTankGroup =
	union {
		object { BigOilTank }
		object { BigOilTank translate <-OTSpacing*1,0,0> }
		object { BigOilTank translate <-OTSpacing*2,0,0> }
		object { BigOilTank translate <-OTSpacing*3,0,0> }
		object { BigOilTank translate <-OTSpacing*4,0,0> }
		texture { OilTankCamoflage scale 26*Feet }
	}

//-------------- Island Building ------------------

#declare IBFloor =
	difference { // cutout windows
		union {
			box {
				<0,0,0>,<120*Feet,14*Feet,60*Feet>
			}
			box {
				<30*Feet,0,-20*Feet>,<90*Feet,14*Feet,1*Feet>
			}
			object { WindowFrameCutout(4*Feet,8*Feet) translate <15*Feet,3*Feet,0> }
			object { WindowFrameCutout(4*Feet,8*Feet) translate <15*Feet,3*Feet,0> }
			object { WindowFrameCutout(4*Feet,12*Feet) translate <40*Feet,3*Feet,-20*Feet> }
			object { WindowFrameCutout(4*Feet,12*Feet) translate <50*Feet,3*Feet,-20*Feet> }
		} // end union
		object { WindowFrame(4*Feet,8*Feet) translate <15*Feet,3*Feet,0> }
		object { WindowFrame(4*Feet,8*Feet) translate <15*Feet,3*Feet,0> }
		object { WindowFrame(4*Feet,12*Feet) translate <40*Feet,3*Feet,-20*Feet> }
		object { WindowFrame(4*Feet,12*Feet) translate <50*Feet,3*Feet,-20*Feet> }
		texture { BrownWood }
	}
#declare IBRoof =
	union {
		box { <-2*Feet,0,-42*Feet>,<122*Feet,8*Inches,0> rotate x*-18 translate <0,41*Feet,20*Feet> }
		box { <-2*Feet,0,-42*Feet>,<122*Feet,8*Inches,0> rotate <-18,180,0> translate <122*Feet,41*Feet,20*Feet> }
		texture { GreyRoofTex }
	}
#declare IslandBuilding =
	union {
		object { IBFloor }
		object { IBFloor translate <0,14.7*Feet,0> }
		object { IBRoof }
	}

#declare Tree1 =
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Trees11c.png"
					once
				}
			}
			finish { ambient .10 diffuse .25 }
		}
		scale <54*Feet,80*Feet,1*Feet>
	}
#declare Tree3Group =
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // image is always projected from -z, with front facing +z, top to +Y
					png "Trees11b.png"
					once
				}
			}
			finish { ambient .10 diffuse .25 }
		}
		scale <140*Feet,60*Feet,1*Feet>
	}

#declare AllTrees =
	union {
		object { Tree1 scale <1.2,1.3,1.2> rotate y*-28 translate <-1450*Feet,12*Feet,4500*Feet> } // big on left
		object { Tree1 scale <1,1,1> rotate y*-20 translate <-1320*Feet,12*Feet,4380*Feet> } // closest on left
		object { Tree3Group rotate y*-15 translate <-700*Feet,12*Feet,5700*Feet> } // far building
		object { Tree3Group scale .78 rotate y*-5 translate <-1000*Feet,12*Feet,5300*Feet> } // center small
		object { Tree3Group scale <2.4,1.6,1.6> rotate y*-20 translate <-1400*Feet,12*Feet,5200*Feet> } // oil tanks
		object { Tree1 scale <1,.85,1> rotate y*-13 translate <-1200*Feet,12*Feet,5300*Feet> } // oil tanks
		object { Tree3Group scale <1.8,0.8,1.3> rotate y*-16 translate <-1150*Feet,12*Feet,7000*Feet> } // far side
		object { Tree3Group scale <2.2,1.3,1.6> rotate y*-20 translate <-1200*Feet,12*Feet,6900*Feet> } // far side
		object { Tree1 scale <1,1.2,1> rotate y*-08 translate <-1150*Feet,12*Feet,6800*Feet> } // far side forest
		object { Tree1 scale <.65,.65,.65> rotate y*-18 translate <-900*Feet,30*Feet,6100*Feet> } // far side nearer
		object { Tree1 scale <.76.76,.76> rotate y*-13 translate <-1350*Feet,30*Feet,6600*Feet> } // far side left
	}

