
// POV-Ray Object File - Cranes
// created 26-Nov-98
// last update 21-Dec-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "Crane.inc" in another .pov file
// Required #include files: "GUnits.inc"
//
// Objects:
// Crane(YRot,XLiftAng,HookDrop) // where XExtensionAng is angle from horizontal
// CraneRails(Length,CraneXOffset)
//
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)
// Origin is directly under center of crane.
// Unrotated crane and rails face -Z


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare AmbientYellow = // for testing
	texture {
		pigment { color rgb<.99,.99,.33> }
		finish { ambient .7 diffuse .7 specular .7 roughness .04 }
	}

#declare WindowTex =
	texture {
		pigment { color rgb<.29,.27,.13> }
		finish { ambient .10 diffuse .7 specular .7 roughness .04 }
	}
#declare CraneTex =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.0 color rgb<.72,.75,.82> ]
					[ 0.80 color rgb<.72,.75,.82> ]
					[ 0.95 color rgb<.59,.52,.36> ] // rusty dirt
					[ 1.0 color rgb<.59,.52,.36> ]
				}
			scale 2*Feet
		}
		normal { bumps .13 scale 24*cm }
		finish { ambient .10 diffuse .7 specular .7 roughness .04 }
	}

#declare CraneArmTex =
	texture {
		pigment {
			bozo
				color_map {
					[ 0.0 color rgb<.42,.45,.52> ]
					[ 0.5 color rgb<.12,.15,.12> ]
					[ 1.0 color rgb<.42,.45,.52> ]
				}
				scale 1*Meter
			}
		normal { bumps .13 scale 14*cm }
		finish { ambient .10 diffuse .7 specular .7 roughness .04 }
	}

#declare LightSteelTex =
	texture {
		pigment { color rgb<.84,.87,.93> }
		normal { bumps .08 scale 16*cm }
		finish { ambient .19 diffuse .7 specular .4 roughness .06 }
	}
#declare DullSteelTex =
	texture {
		pigment { color rgb<.52,.55,.58> }
		normal { bumps .08 scale 1*cm }
		finish { ambient .08 diffuse .7 specular .4 crand .1 roughness .06 }
	}

#declare ScaffoldTex =
	texture {
		pigment {
//color rgbt<1,1,1,1.0> // test

			gradient y
			color_map {
				[ 0.0 color rgb<.52,.55,.58> ]
				[ 0.06 color rgb<.52,.55,.58> ]
				[ 0.06 color rgbt<1,1,1,1.0> ]
			}

			scale 8*Feet
		}
		normal { bumps .08 scale 10*cm }
		finish { ambient .08 diffuse .7 specular .4 roughness .06 }
	}

#macro Stripe(Direction,Thickness,Scale,Color)
pigment {
	gradient Direction
		color_map {
			[ Thickness/Scale color Color ]
			[ Thickness/Scale color rgbt<1,1,1,1> ]
		}
		scale Scale
}
#end

#declare RailTex =
	texture {
		pigment { color rgb<.72,.53,.64> }
		normal { bumps .08 scale 40*cm }
		finish { ambient .08 diffuse .7 specular .8 roughness .06 }
	}
#declare RailFoundationTex =
	texture {
		pigment { color rgb<.96,.97,.93> }
		normal { bumps .08 scale 40*cm }
		finish { ambient .08 diffuse .7 specular .8 roughness .06 }
	}
#declare RailStripeTex =
	texture {
		Stripe(z,8*inch,40*Feet,rgb<.25,.215,.254> )
		normal { bumps .08 scale 40*cm }
		finish { ambient .08 diffuse .7 specular .8 roughness .06 }
	}


//===============================================
//						 Objects
//===============================================

//---------------- Crane -------------------

#declare CBH = 30*Feet; // Crane Base Height (top of legs)
#declare CLeg =
	union {
		box { // main
			<-2*Feet,0,-3*Feet>,<2*Feet,CBH,3*Feet>
		}
		box { // foot
			<-3*Feet,1.3*Feet,-6*Feet>,<3*Feet,5.2*Feet,6*Feet>
		}
		box {
			<0,0,0>,<16*Feet,16*Inches,12*Inches>
			rotate z*55
			translate <0,CBH-10*Feet,-14*Inches>
		}
		box {
			<0,0,0>,<18*Inches,18*Inches,36*Feet>
			rotate x*-45
			translate <-9*Inches,CBH-28*Feet,2.5*Feet>

		}
		texture { CraneTex }
	}
#declare CPlatform =
	union {
		box { // underside
			<-19*Feet,0,-25*Feet>,<19*Feet,6*Feet,25*Feet>
			translate <0,CBH,0>
		}
		box { // plaque
			<-4*Feet,-2*Feet,-25.5*Feet>,<4*Feet,2*Feet,-23*Feet>
			translate <0,CBH,0>
			texture { LightSteelTex }
		}
		box { // top rail
			<-18*Feet,6*Feet,-24*Feet>,<18*Feet,7*Feet,-23*Feet>
			translate <0,CBH,0>
		}
		box { // top rail
			<-18*Feet,6*Feet, 24*Feet>,<18*Feet,7*Feet, 23*Feet>
			translate <0,CBH,0>
		}
		box { // top rail
			<-18*Feet,6*Feet,-24*Feet>,<-17*Feet,7*Feet, 24*Feet>
			translate <0,CBH,0>
		}
		box { // top rail
			< 18*Feet,6*Feet,-24*Feet>,< 17*Feet,7*Feet, 24*Feet>
			translate <0,CBH,0>
		}
		cylinder { // pivot
			<0,0,0>,<0,6*Feet,0>,12*Feet
			translate <0,CBH+6*Feet,0>
		}
		cylinder { // pivot base ring
			<0,0,0>,<0,1.6*Feet,0>,14*Feet
			translate <0,CBH+6*Feet,0>
			texture { DullSteelTex }
		}
		texture { CraneTex }
	}
#declare BackArm =
	union {
		box { // main
			<-6*Feet,0,-4*Feet>,<6*Feet,40*Feet,4*Feet>
			texture { ScaffoldTex }
		}
		box {
			<-5*inch,0,-7*inch>,<5*inch,40*Feet,7*inch>
			translate <7*Feet,0,-4*Feet>
			rotate z*12
			texture { DullSteelTex }
		}
		box {
			<-5*inch,0,-7*inch>,<5*inch,40*Feet,7*inch>
			translate <-7*Feet,0,-4*Feet>
			rotate z*-12
			texture { DullSteelTex }
		}
		cylinder { // axle
			<-6*Feet,0,0>,<6*Feet,0,0>,6*inch
			translate <0,30*Feet,0>
			texture { DullSteelTex }
		}
		cylinder { // pulley
			<-2*inch,0,0>,<2*inch,0,0>,3*Feet
			translate <-2*Feet,30*Feet,0>
			texture { LightSteelTex }
		}
		cylinder { // pulley
			<-2*inch,0,0>,<2*inch,0,0>,3*Feet
			translate < 2*Feet,30*Feet,0>
			texture { LightSteelTex }
		}
	}
#declare MainArmT =
	box {
		<-6*Feet,0,-6*Feet>,<6*Feet,180*Feet,6*Feet>
		texture { ScaffoldTex }
	}
#declare MainArmHF =
	height_field {
		png "CraneArm.png"
		texture { CraneArmTex }
		water_level .001 // only keep the steel
		scale <20*Feet,6*Inches,140*Feet>
		translate <-10*Feet,10*Feet,0>
		rotate <4,180,0>
	}

#declare MainArm =
	union {
		object { MainArmHF }
		object { MainArmHF rotate z*90 }
		object { MainArmHF rotate z*180 }
		object { MainArmHF rotate z*270 }
	}

#declare CHook =
	union {
		difference {
			torus {
				1.2*Feet,4*inch
				rotate z*90
			}
			box {
				<-8*Inch,0,-4*Feet>,<8*Inch,.4*Feet,0>
			}
//			translate <0,0,0>
		} // end difference
		cylinder { <0,0,0>,<0,2*Feet,0>,4*inch }
		cylinder { // pulley
			<-5*Inch,0,0>,<5*Inch,0>,5*Inch
			translate <0,2*Feet,0>
		}
		texture { DullSteelTex }
	} // end union
#macro CableGroup(DownLength)
	union {
	cylinder { <0,-1-DownLength,0>,<0,0,0>,1*cm translate < 3*Inch,0, 5*inch> }
	cylinder { <0,-1-DownLength,0>,<0,0,0>,1*cm translate < 3*Inch,0,-5*inch> }
	cylinder { <0,-1-DownLength,0>,<0,0,0>,1*cm translate <-3*Inch,0, 5*inch> }
	cylinder { <0,-1-DownLength,0>,<0,0,0>,1*cm translate <-3*Inch,0,-5*inch> }
	object { CHook translate <0,-DownLength,0> }
		texture { DullSteelTex }
	}
#end
#declare Cabin =
	union {
		difference {
			box { // main
				<-12*Feet,0,-24*Feet>,<12*Feet,16*Feet,24*Feet>
			}
			box { // front cutout
				<-9*Feet,3*Feet,-30*Feet>,<9*Feet,20*Feet,-11*Feet>
			}
			box { // window
				<-20*Feet,5*Feet,-9*Feet>,<20*Feet,11*Feet,-5*Feet>
				texture { WindowTex }
			}
			box { // window
				<-20*Feet,5*Feet,13*Feet>,<20*Feet,8*Feet,16*Feet>
				texture { WindowTex }
			}
			texture { CraneTex }
		} // end difference
		cylinder { <0,0,0>,<0,22.5*Feet,0>,1.6*Feet translate <8*Feet,0,13*Feet> texture { DullSteelTex } } // pipe
		box { <0,0,0>,<8.5*Feet,1.5*Feet,24*Feet> translate <-4*Feet,16*Feet,-6*Feet> texture { DullSteelTex } } // roof
		box { <-8*Feet,2*Feet,-19*Feet>,<8*Feet,9*Feet,12*Feet> texture { LightSteelTex } } // machine
	}

#macro Crane(YRot,XLiftAng,HookDrop)
	union {
		object { CLeg translate <-16*Feet,0,-23*Feet> }
		object { CLeg scale <1,1,-1> translate < -16*Feet,0,23*Feet> }
		object { CLeg scale <1,1,-1> rotate y*180 translate < 16*Feet,0, -23*Feet> }
		object { CLeg rotate y*180 translate < 16*Feet,0, 23*Feet> }
		object { CPlatform }
		object { Cabin rotate y*YRot translate <0,CBH+11*Feet,0> }
		object { BackArm rotate x*40 translate <0,CBH+11*Feet+10*Feet,24*Feet> rotate y*YRot }
		object { MainArm rotate x*XLiftAng translate <0,CBH+11*Feet+10*Feet,-24*Feet> rotate y*YRot }
		object { CableGroup(HookDrop)
			rotate x*-XLiftAng
			translate <0,0,-130*Feet>
			rotate x*XLiftAng
			translate <0,CBH+11*Feet+10*Feet,-24*Feet>
			rotate y*YRot
		}
		object { CHook translate <0,CBH+11*Feet+10*Feet,-120*Feet> rotate y*YRot }
	}
#end

//---------------- Rails -------------------

#macro CraneRails(Length,CraneZOffset)
	#local CRail =
		box {
			<-1.5*inch,0,0>,<1.5*Inch,4*inch,Length>
			texture { RailTex }
		}
	#local CFoundation =
		box {
			<-4.5*Feet,0,0>,<4.5*Feet,2*inch,Length>
			texture { RailFoundationTex }
			texture { RailStripeTex }
		}
	union {
		object { CRail translate <-16*Feet+2*Feet,0,-CraneZOffset> }
		object { CRail translate <-16*Feet-2*Feet,0,-CraneZOffset> }
		object { CRail translate < 16*Feet+2*Feet,0,-CraneZOffset> }
		object { CRail translate < 16*Feet-2*Feet,0,-CraneZOffset> }
		object { CFoundation translate <-16*Feet,0,-CraneZOffset> }
		object { CFoundation translate < 16*Feet,0,-CraneZOffset> }
		object { CRail translate <+1.7*Feet,0,-CraneZOffset> }
		object { CRail translate <-1.7*Feet,0,-CraneZOffset> }
	}
#end
