
// POV-Ray Object File - Equipment
// created 26-Nov-98
// last update 27-Dec-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "Equipment.inc" in another .pov file
// Required #include files: "GUnits.inc"
//
// Objects:
// WhiteDockBuildingJunk
// CargoGroup
// PipeGroup
// WaterTankVert
// OilTank
// GasTank
// WaterTankVertGroup
// FarGroup
// CachalotGroup
//
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#macro Stripe(Direction,Thickness,Scale,Color)
pigment {
	gradient Direction
		color_map {
			[ Thickness/Scale color Color ]
			[ Thickness/Scale color rgbt<1,1,1,1> ]
		}
		scale Scale
}
#end


#declare WhitePaint =
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare BrightWhitePaint = // water tank
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .33 diffuse .7 specular .8 roughness .05 }
	}
#declare PalletTex =
	texture {
		pigment { color rgb<.73,.82,.69> }
		normal { bumps .2 scale 1*cm }
		finish { ambient .1 diffuse .7 specular .7 roughness .05 }
	}
#declare SilverPaint =
	texture {
		pigment { color rgb<.83,.82,.87> }
		normal { bumps .03 scale 12*cm }
		finish { ambient .1 diffuse .7 metallic brilliance 3 specular .9 roughness .015 }
	}


//===============================================
//						 Objects
//===============================================


#declare WhiteDockBuildingJunk =
	union {
		cylinder { // barrel
			<0,0,0>,<0,4*Feet,0>,16*Inch
			translate <4*Feet,0,-6*Feet>
			texture { WhitePaint }
		}
		cylinder { // another barrel
			<0,0,0>,<0,4*Feet,0>,16*Inch
			translate <7.3*Feet,0,-6.3*Feet>
			texture { WhitePaint }
		}
		cylinder { // another barrel
			<0,6*Inch,0>,<21.6*Feet,6*Inch,0>,6*Inch
			rotate y*18
			translate <33*Feet,0,-4*Feet>
			texture { GreyRoofTex }
		}
	}

#declare CargoPallet =
	superellipsoid {
		<.3,.3>
		scale <11*Feet,6*Feet,9*Feet>
		translate <0,7*Feet,0>
		texture { PalletTex }
	}
#declare CargoGroup =
	union {
		object { CargoPallet translate <0,0,0> }
		object { CargoPallet translate <-32*Feet,0,0> }
		object { CargoPallet translate <0,0,32*Feet> }
		object { CargoPallet translate <-32*Feet,0,32*Feet> }
	}

#declare LPipe =
	difference {
		union {
 			cylinder { < 0,6*inches,0>,<50*Feet,6*inches,0>,5*inches }
 			cylinder { < 0,6*inches,0>,<1.6*Feet,6*inches,0>,6.8*inches }
		}
		cylinder { <-1,6*inches,0>,<50*Feet+1,6*inches,0>,4*inches }
		texture { pigment { color rgb<.26,.56,.84> } }
	}
#declare PipeGroup =
	union {
		box { // underneath
			<1.8*Feet,0,0>,<50*Feet-1.8*Feet,8*inches,12*Feet>
			texture { GreyRoofTex }
		}
		object { LPipe translate <0,9*Inches,1.3*Feet> }
		object { LPipe rotate y*4 translate <0,9*Inches,2.6*Feet> }
		object { LPipe translate <0,9*Inches,4.2*Feet> }
		object { LPipe translate <0,9*Inches,6.7*Feet> }
		object { LPipe rotate y*-2 translate <0,9*Inches,15.1*Feet> }
	}

#declare SmallBox =
	box {
		<-3*Feet,0,-3*Feet>,<3*Feet,3*Feet,3*Feet>
		texture { WhitePaint }
	}
#declare VFlagPole =
	union {
		cylinder { <0,0,0>,<0,4*Feet,0>,6.5*Inches }
		cone { <0,0,0>,5*Inches,<0,40*Feet,0>,1.3*Inches }
		sphere { <0,40*Feet,0>,2.5*Inches }
		texture { WhitePaint }
	}

#local WTR = 4*Feet;
#declare WaterTankVert =
	union {
		cylinder { // main
			<0,0,0>,<0,14*Feet,0>,WTR
			translate <0,7*Feet,0>
		}
		sphere { // top
			<0,0,0>,WTR
			scale <1,.16,1>
			translate <0,21*Feet,0>
		}
		cone { // bottom
			<0,0,0>,WTR-6*inches,<0,-4*Feet,0>,3*inches
			translate <0,7*Feet,0>
		}
		cylinder { <0,0,0>,<0,22*Feet,0>,5.6*inches translate <-WTR-8*inches,0,-WTR-8*inches> }
		cylinder { <0,0,0>,<0,22*Feet,0>,5.6*inches translate <-WTR-8*inches,0, WTR+8*inches> }
		cylinder { <0,0,0>,<0,22*Feet,0>,5.6*inches translate < WTR+8*inches,0,-WTR-8*inches> }
		cylinder { <0,0,0>,<0,22*Feet,0>,5.6*inches translate < WTR+8*inches,0, WTR+8*inches> }
		texture { BrightWhitePaint }
	}

#declare OilTank =
	union {
		cylinder { <0,0,0>,<14*Feet,0,0>,2*Feet translate <0,3*Feet,0> } // lower
		cylinder { <0,0,0>,<14*Feet,0,0>,2*Feet translate <0,6*Feet,0> } // upper
		box { <0,0,-2*Feet>,<14*Feet,3*Feet,2*Feet> translate <0,3*Feet,0> } // middle
		cylinder { <0,0,0>,<0,2*Feet,0>,9*Inches translate <3*Feet,7*Feet,0> } // pipe
		cylinder { <0,0,0>,<0,3*Feet,0>,3*Inches translate <3*Feet,7*Feet,0> } // pipe
		texture { SilverPaint }
	}

#declare GasTank =
	union {
		cylinder { <0,0,0>,<0,0,9*Feet>,3*Feet scale <1,1,.6> translate <0,4*Feet,0> }
		sphere { <0,0,0>,3*Feet scale <1,1,.6> translate <0,4*Feet,0> }
		sphere { <0,0,0>,3*Feet scale <1,1,.6> translate <9*Feet,4*Feet,0> }
		box { <-3*Inches,0,-3*Inches>,<3*Inches,3*Feet,3*Inches> translate <1*Feet,0,-3*Feet> }
		box { <-3*Inches,0,-3*Inches>,<3*Inches,3*Feet,3*Inches> translate <1*Feet,0, 3*Feet> }
		box { <-3*Inches,0,-3*Inches>,<3*Inches,3*Feet,3*Inches> translate <8*Feet,0,-3*Feet> }
		box { <-3*Inches,0,-3*Inches>,<3*Inches,3*Feet,3*Inches> translate <8*Feet,0, 3*Feet> }
		texture { BrightWhitePaint }
	}

#declare WaterTankVertGroup =
	union {
		object { WaterTankVert }
		object { OilTank translate <14*Feet,0,-8*Feet> }
		object { OilTank translate <14*Feet,0,-22*Feet> }
		object { GasTank rotate y*90 translate <-9*Feet,0,-21*Feet> }
		// #macro Stripe(Direction,Thickness,Scale,Color)
		box { <0,2*Feet,0>,<40*Feet,11*Feet,18*Feet>
			texture { Stripe(x,2*Feet,8*Feet,<.34,.29,.16>) }
			translate <-16*Feet,0,-78*Feet>
		}
		box { <0,2*Feet,0>,<24*Feet,6*Feet,38*Feet>
			texture { Stripe(z,1*Feet,6*Feet,<.34,.29,.16>) }
			translate <46*Feet,0,-78*Feet>
		}
	}

#declare CachalotGroup = // objects near Cachalot and Helena
	union {
		object { WaterTankVert scale <1,.6,1> } // Cachalot
		object { CargoGroup scale <.5,.7,.6> rotate y*6 translate <0,0,30*Feet> }
		object { OilTank translate <-5*Feet,0,-16*Feet> }

		object { CargoGroup scale <.5,.9,.6> rotate y*-3 translate <0,0,700*Feet> } // Helena
		object { GasTank scale <1,.9,1> rotate y*-0 translate <-6*Feet,0,750*Feet> }

		object { CargoGroup scale <.6,.6,.6> translate <-40*Feet,0,-360*Feet> } // nearby corner
		object { CargoGroup scale <.6,1.4,.6> translate <30*Feet,0,-560*Feet> } // in shadow

		object { SmallBox translate <55*Feet,0,-280*Feet> } // small building on right
		object { VFlagPole translate <62*Feet,0,-280*Feet> } // small building on right
	}

#declare FarGroup = // objects on far dock
	union {
		object { WaterTankVert }
		object { PipeGroup translate <12*Feet,0,-120*Feet> }
		object { CargoGroup scale .5 translate <22*Feet,0,76*Feet> }
		object { OilTank rotate y*90 translate <-6*Feet,0,-44*Feet> }
		object { OilTank rotate y*90 translate < 6*Feet,0,-44*Feet> }
	}
