
// POV-Ray Object File - Ships
// created 26-Nov-98
// last update 27-Dec-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "Ships.inc" in another .pov file
// Required #include files: "GUnits.inc", "ShipHull1.pov", "NeoshoHull.pov", "OglalaHull.pov"
//
// Objects:
// Cachalot_Sub
// Battleship (dummy)
// Cruisership (dummy)
// Neosho oiler
// Oglala minelayer
// Tender for destroyers
// Solace hospital ship
// Argonne auxiliary
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)
// Ships lie in XZ plane, origin under bow at waterline, ship extends into +X

#include "ShipHull1.pov"
#include "NeoshoHull.pov"
#include "OglalaHull.pov"


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare BattleshipTex =
	texture {
		pigment { color rgb<.6,.6,.6> }
		finish { ambient .1 diffuse .7 specular .8 roughness .05 }
	}
#declare NeoshoHullTex =
	texture {
		pigment {
//			color rgb<.23,.19,.16>
//			color rgb <0.416,0.200,0.141> // rusty deep red
				color rgb<.36,.35,.38>
		}
		normal { bumps .1 scale 5*Feet }
		finish { ambient .1 diffuse .7 specular .5 roughness .05 }
	}
#declare NeoshoCabinTex =
	texture {
		pigment { color rgb<.93,.93,.96> }
		finish { ambient .26 diffuse .4 specular .8 roughness .05 }
	}
#declare OglalaTex =
	texture {
		pigment {
				color rgb<.56,.64,.68>
		}
		normal { bumps .1 scale 5*Feet }
		finish { ambient <.07,.10,.13> diffuse .7 specular .5 roughness .05 }
	}
#declare SolaceTex =
	texture {
		pigment {
				color rgb<.96,.95,.98>
		}
		finish { ambient .2 diffuse .6 specular .9 roughness .05 }
	}
#macro Stripe(Direction,Thickness,Scale,Color)
pigment {
	gradient Direction
		color_map {
			[ Thickness/Scale color Color ]
			[ Thickness/Scale color rgbt<1,1,1,1> ]
		}
		scale Scale
}
#end

#declare SubmarineTex =
	texture {
		pigment { color rgb<.3,.3,.4> }
		finish { ambient .1 diffuse .7 specular .8 roughness .05 }
	}
#declare MachineGunTex =
	texture {
		pigment { color rgb<.61,.61,.83> }
		finish { ambient .08 diffuse .7 specular .94 roughness .01 }
	}
#declare FiringTex =
	texture {
		pigment { color rgb<.93,.89,.47> }
		finish { ambient .68 diffuse .3 specular .1 roughness .06 }
	}

#declare ShinyHullTex = // for testing only
	texture {
		pigment { color rgb<.3,.3,.3> }
		finish { ambient .1 diffuse .7 specular .8 roughness .05 reflection .58 }
	}


//===============================================
//						 Objects
//===============================================

//---------------- Test Objects --------------------
#macro TestShip(Length,Width,HeightOverWaterline)
	box {
		<0,0,-Width/2>,<Length,HeightOverWaterline,Width/2>
		texture { WhitePaint }
	}
#end


//---------------- Cachalot Submarine --------------------

#declare SMachineGunGroup =
	union {
		box { <-28*Inches,0,-7*Inches>,<24*Inches,14*Inches,7*Inches> } // main
		box { <-16*Inches,0,-4*Inches>,<28*Inches,17*Inches,4*Inches> } // align
		box { < 4*Inches,4*Inches,-7*Inches>,<18*Inches,8*Inches,-12*Inches> } // magazine
		cylinder { <-58*Inches,0,0>,<0,0,0>,3.4*Inches translate <0,5*Inches,0> } // barrel
		sphere { <0,0,0>,6*inches scale <3,1,1> texture { FiringTex } translate <-65*Inches,5*Inches,0> } // firing flash
		texture { MachineGunTex }
	}
#macro SMachineGun(ElevAngle)
	union {
		object { SMachineGunGroup rotate z*-ElevAngle translate <0,54*Inches,0> }
		cylinder { <0,0,0>,<0,4*Inches,0>,2.4*Feet } // base
		cylinder { <0,0,0>,<0,54*Inches,0>,7*Inches translate <0,0, 1.8*Feet> } // support
		cylinder { <0,0,0>,<0,54*Inches,0>,7*Inches translate <0,0,-1.8*Feet> } // support
		texture { MachineGunTex }
	}
#end
#declare Cachalot_Sub =
	union {
		difference {
			union {
				cylinder { // main hull
					<0,0,0>,<240*Feet,0,0>,18*Feet
				}
				sphere { <0,0,0>,18*Feet scale <2,1,1> }
				sphere { <0,0,0>,18*Feet scale <3,1,1> translate <240*Feet,0,0> }
				scale <1,1,.7>
			} // end union
			box { <-30*Feet,12*Feet,-30*Feet>,<300*Feet,30*Feet,30*Feet> } // top deck
		} // end difference
		box { <2*Feet,11*Feet,-3*Feet>,<200*Feet,13*Feet,3*Feet> } // deck
		cylinder { <0,11*Feet,0>,<0,13*Feet,0>,3*Feet scale <2,1,1> translate <2*Feet,0,0> } // deck front
		box { // holes
			<0,12*Feet,-.6*Feet>,<240*Feet,12.1*Feet,.6*Feet>
			translate <0,0,-5*Feet>
			texture {
				//Stripe(Direction,Thickness,Scale,Color)
				Stripe(x,1*Feet,10*Feet,<.2,.2,.2>)
			}
		}
		box { // holes
			<0,12*Feet,-.6*Feet>,<240*Feet,12.1*Feet,.6*Feet>
			translate <0,0, 5*Feet>
			texture {
				//Stripe(Direction,Thickness,Scale,Color)
				Stripe(x,1*Feet,10*Feet,<.2,.2,.2>)
			}
		}
		union { // conning tower
			difference {
				union {
					cylinder { // main tower
						<0,0,0>,<0,25*Feet,0>,32*Feet
						scale <1,1,.2>
					}
					sphere { // top surf
						<0,0,0>,32*Feet
						scale <1,.1,.2>
						translate <0,25*Feet,0>
					}
				} // end union
				cylinder { <0,0,0>,<0,30*Feet,0>,3*Feet scale <1.4,1,1> translate <-18*Feet,0,0> } // top hole
				cylinder { <-40*Feet,0,0>,<0,0,0>,1.4*Feet translate <0,19*Feet,-3*Feet> } // front hole
			} // end difference
			cylinder { <0,0,0>,<0,50*Feet,0>,2.8*Feet scale <1,1,.6> translate <11*Feet,0,0> }
			cylinder { <0,0,0>,<0,70*Feet,0>,0.5*Feet scale <1,1,.6> translate <11*Feet,0,0> }
			cylinder { <0,0,0>,<0,45*Feet,0>,1.9*Feet scale <1,1,.6> translate <6*Feet,0,0> }
			cylinder { <0,0,0>,<0,36*Feet,0>,2.9*Feet translate <3*Feet,0,-2*Feet> } // off to the side
			translate <100*Feet,0,0> // align to ship
		} // end union
		object { SMachineGun(24) rotate y*5 translate <47*Feet,13*Feet,0> }
		rotate z*-1 // settle rear in water
		texture { SubmarineTex }
	} // end union

//---------------- Battleship --------------------

// BattleshipArizona origin at sea level under tip of bow, extends into +X
#macro BGunBarrel(GunElevAngle)
	cylinder { // barrel
		<0,0,-4*Feet>,<0,0,45*Feet>,21*inch
		rotate x*-GunElevAngle
		translate <0,8*Feet,7*Feet>
	}
#end
#macro BTurret(GunElevAngle)
	union {
		box {
			<-12*Feet,2*Feet,-21*Feet>,<12*Feet,18*Feet,21*Feet>
		}
		cylinder { <0,-40*Feet,0>,<0,4*Feet,0>,16*Feet } // swivel base
		object { BGunBarrel(GunElevAngle) translate <-8*Feet,0,0> }
		object { BGunBarrel(GunElevAngle) translate < 0*Feet,0,0> }
		object { BGunBarrel(GunElevAngle) translate < 8*Feet,0,0> }
	}
#end
#declare SuperstructureGroup =
	union {
		box { // wide base
			<-60*Feet,0,-33*Feet>,<60*Feet,80*Feet,33*Feet>
		}
		box { // tall base
			<-40*Feet,0,-32*Feet>,<40*Feet,110*Feet,32*Feet>
		}
		cylinder { <0,0,0>,<0,200*Feet,0>,6*Feet translate <-20*Feet,0,0> }
		cylinder { <0,0,0>,<0,200*Feet,0>,6*Feet translate < 12*Feet,0,-12*Feet> }
		cylinder { <0,0,0>,<0,200*Feet,0>,6*Feet translate < 12*Feet,0, 12*Feet> }
		box { // crows nest 1
			<-30*Feet,130*Feet,-20*Feet>,<30*Feet,160*Feet,20*Feet>
		}
		cylinder { // crows nest 2
			<0,170*Feet,0>,<0,190*Feet,0>,18*Feet
		}
		cylinder { // antenna
			<0,190*Feet,6*Feet>,<0,240*Feet,6*Feet>,2.8*Feet
		}
	} // end union
#declare Battleship =
	union {
//		#include "ShipHull1.pov" // sPatch file
		object { BattleshipHull }
		object { SuperstructureGroup translate <150*Feet,0,0> }
		object { BTurret(4) rotate y*-90 translate <-50*Feet,50*Feet,0> }
		object { BTurret(16) rotate y*-90 translate <30*Feet,60*Feet,0> }
		object { BTurret(4) rotate y*90 translate <230*Feet,30*Feet,0> }
		texture { BattleshipTex }
	}
#declare Cruisership =
	union {
//		#include "ShipHull1.pov" // sPatch file
		object { BattleshipHull }
		object { SuperstructureGroup scale <1,.7,.8> translate <150*Feet,0,0> }
		object { BTurret(4) rotate y*-90 translate <-50*Feet,50*Feet,0> }
		object { BTurret(4) rotate y*90 translate <180*Feet,30*Feet,0> }
		texture { BattleshipTex }
	}

//---------------- Oiler Neosho --------------------

#declare SmokeStack =
	cylinder { // stack
		<0,0,0>,<0,45*Feet,0>,9*Feet
		rotate z*-4
	}

#declare NCabin =
	union {
		box { // lower
			<0,20*Feet,-28*Feet>,<105*Feet,35*Feet,28*Feet>
		}
		box { // lower windows
			<0,28*Feet,-28.1*Feet>,<105*Feet,32*Feet,28.1*Feet>
			texture {
				//Stripe(Direction,Thickness,Scale,Color)
				Stripe(x,2*Feet,8*Feet,<.10,.10,.20>)
			}
		}
		box { // upper
			<24*Feet,34*Feet,-22*Feet>,<80*Feet,44*Feet,22*Feet>
		}
		box { // roof
			<24*Feet,44*Feet,-28*Feet>,<80*Feet,44.7*Feet,28*Feet>
		}
		box { // bridge
			<12*Feet,36*Feet,-35*Feet>,<24*Feet,46*Feet,35*Feet>
		}
		object { SmokeStack translate <63*Feet,30*Feet,0> }
	}
#declare NEquipment =
	union {
		box {
			<0,0,-24*Feet>,<33*Feet,28*Feet,24*Feet>
		}
		box {
			<4*Feet,0,-20*Feet>,<29*Feet,52*Feet,20*Feet>
		}
		box {
			<-120*Feet,0,-6*Feet>,<260*Feet,12*Feet,6*Feet>
			texture {
				//Stripe(Direction,Thickness,Scale,Color)
				Stripe(x,1*Feet,10*Feet,<.8,.8,.8>)
			}
			translate <0,30*Feet,0>
		}
		box {
			<-120*Feet,4.5*Feet,-2*Feet>,<260*Feet,7.5*Feet,2*Feet>
			texture {
				//Stripe(Direction,Thickness,Scale,Color)
				Stripe(x,2*Feet,6*Feet,<.6,.6,.6>)
			}
			translate <0,30*Feet,0>
		}
		cylinder {
			<0,0,0>,<0,72*Feet,0>,7*Feet
			translate <6*Feet,0,0>
		}
		cylinder {
			<0,0,0>,<0,88*Feet,0>,3*Feet
			translate <18*Feet,0,0>
		}
		cylinder {
			<0,0,0>,<0,38*Feet,0>,6*Feet
			translate <78*Feet,0,0>
		}
		cylinder {
			<0,0,0>,<0,36*Feet,0>,11*Feet
			translate <138*Feet,0,0>
		}
	}
#declare NMast =
	union {
		cylinder {
			<0,0,0>,<0,90*Feet,0>,2.4*Feet
		}
		cylinder {
			<0,0,0>,<0,120*Feet,0>,1.2*Feet
		}
		box {
			<0,0,-18*Feet>,<1.8*Feet,1.8*Feet,18*Feet>
			translate <0,80*Feet,0>
		}
	}
#declare Neosho =
	union {
		object { NeoshoHull texture { NeoshoHullTex } }
		object { NCabin translate <450*Feet,0,0> }
		object { NEquipment translate <200*Feet,0,0> }
		object { NMast translate <150*Feet,0,0> }
		object { NMast translate <360*Feet,0,0> }
		texture { NeoshoCabinTex }
	}

//---------------- Minelayer Oglala --------------------

#declare CrowsNest =
	union {
		cylinder {
			<0,0,0>,<0,8*Feet,0>,6*Feet
			scale <.6,1,1>
		}
		cone {
			<0,9.5*Feet,0>,6*Feet,<0,13.5*Feet,0>,13*inches
			scale <.6,1,1>
		}
	}
#declare OMast =
	union {
		cylinder {
			<0,0,0>,<0,90*Feet,0>,2.4*Feet
		}
		cylinder {
			<0,0,0>,<0,120*Feet,0>,1.2*Feet
		}
		cylinder {
			<0,0,-18*Feet>,<0,0,18*Feet>,.9*Feet
			translate <0,94*Feet,0>
		}
	}
#declare OCabin =
	union {
		box {
			<4*Feet,0,-9*Feet>,<68*Feet,9*Feet,9*Feet>
		}
		box {
			<0,0,-15*Feet>,<44*Feet,9*Feet,15*Feet>
			translate <0,9*Feet,0>
		}
	}
#declare Oglala =
	union {
		object { OglalaHull }
		object { NCabin scale <1,1,.58> translate <88*Feet,0,0> }
		object { OCabin translate <88*Feet,44*Feet,0> }
		object { NMast translate <50*Feet,0,0> }
		object { CrowsNest translate <45*Feet,78*Feet,0> }
		object { NMast translate <260*Feet,0,0> }
		texture { OglalaTex }
	}

#declare Tender =
	union {
		object { Oglala scale <1.6,1.1,1.4> }
		object { SmokeStack scale <1.6,1.1,1.4> translate <280*Feet,30*Feet,0> }
		box { <0,0,-24*Feet>,<200*Feet,30*Feet,24*Feet> translate <300*Feet,20*Feet,0> }
		texture { OglalaTex }
	}

#declare Solace =
	union {
		object { OglalaHull scale <1.5,1.6,1.1> }
		object { NCabin translate <220*Feet,30*Feet,0> }
		object { SmokeStack translate <400*Feet,50*Feet,0> }
		object { NMast translate <150*Feet,0,0> }
		object { NMast translate <400*Feet,0,0> }
		box { <0,0,-27*Feet>,<300*Feet,7*Feet,27*Feet> rotate z*-1 translate <100*Feet,46*Feet,0> }
		box { <0,0,-27*Feet>,<300*Feet,7*Feet,27*Feet> rotate z*-1 translate <100*Feet,60*Feet,0> }
		box { // hull windows
			<150*Feet,33*Feet,-32*Feet>,<440*Feet,37*Feet,32*Feet>
			texture {
				//Stripe(Direction,Thickness,Scale,Color)
				Stripe(x,1*Feet,10*Feet,<.10,.10,.20>)
			}
			rotate z*-1
		}
		texture { SolaceTex }
	}

#declare AMast =
	cylinder {
		<0,0,0>,<0,70*Feet,0>,1.4*Feet
		texture { OglalaTex }
	}
#declare Argonne =
	union {
		object { OglalaHull scale <1,.76,.92> }
		object { NCabin scale <1,1,.58> translate <88*Feet,-9*Feet,0> }
		object { NMast translate <50*Feet,0,0> }
		object { CrowsNest translate <45*Feet,78*Feet,0> }
		object { NMast translate <260*Feet,0,0> }
		object { AMast rotate x*18 translate <50*Feet,30*Feet,3*Feet> }
		object { AMast rotate x*-18 translate <50*Feet,30*Feet,3*Feet> }
		object { AMast rotate x*18 translate <260*Feet,30*Feet,3*Feet> }
		object { AMast rotate x*-18 translate <260*Feet,30*Feet,3*Feet> }
		texture { OglalaTex }
	}


