
// POV-Ray Object File - Smoke & Fire
// created 26-Nov-98
// last update 21-Dec-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "SmokeFire.inc" in another .pov file
// Required #include files: (none)
//
// Objects:
// Smoke - a ball of thick, choking smoke
// SmokeGroup - towering smoke
// LtSmoke - lighter, whispy smoke
// FireGroup - a ball of flame
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)


//===============================================
//             Variables
//===============================================

// Put the following line in the main scene:
//#declare GoodSmoke = 1; // 1 turns on real smoke and fire, otherwise use simple spheres

// Use this function to apply a random rotation to any object
#declare RSeed = seed(52053);
#macro RandRot()
	<rand(RSeed)*360,rand(RSeed)*360,rand(RSeed)*360>
#end

//===============================================
//             Textures
//===============================================

#declare WhitePaint = // for quick fire
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare BlackPaint = // for quick smoke
	texture {
		pigment { color rgb<.03,.04,.05> }
		normal { bumps .12 scale 4*cm }
		finish { ambient .08 diffuse .7 specular .1 roughness .25 }
	}

#declare SmokeTestTex = // for testing only
	texture {
		pigment { color rgb<.5,.5,.5> }
		normal { bumps .3 scale .3 }
		finish { ambient .1 diffuse .7 specular .5 roughness .2 }
	}
#declare SmokeInt =
	interior {
		media {
//			scattering { 1, <.02,.02,.02,> extinction 1.0 } // stinking choking black
			scattering { 3, <.01,.01,.01,> extinction 1.0 } // charcoal grey with fuzzy fur
//			scattering { 1, <.002,.002,.002,> extinction 1.0 } // soft fluffy grey
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.4 color rgb <0,0,0> ] // this prevents it from reaching the container
					[1.0 color rgb <1,1,1> ] // inside is opaque
				}
			turbulence .18
			omega 0.835 // default 0.5, higher = rougher
    	}
		}
	}
#declare SmokeSurfTex =
	texture {
		pigment { color rgbf<1,1,1,1> }
		finish { ambient .1 diffuse 0.7 }
	}
#declare SmokeMaterial =
	material {
		texture { SmokeSurfTex }
		interior { SmokeInt }
	}
#declare LtSmokeInt = // lighter version
	interior {
		media {
			scattering { 1, <.002,.002,.002,> extinction 1.0 } // thicker fluffy grey
//			scattering { 1, <.001,.001,.001,> extinction 1.0 } // medium fluffy grey
//			scattering { 1, <.0001,.0001,.0001,> extinction 1.0 } // thin fluffy grey
	    density { spherical
				color_map{
					[0.0 color rgb <0.0,0.0,0.0> ] // outside is transparent
					[0.3 color rgb <0,0,0> ] // this prevents it from reaching the container
//					[1.0 color rgb <.15,.15,.15> ] // inside is almost transparent
					[1.0 color rgb <.95,.95,.95> ] // inside is almost opaque
				}
				scale .6
			turbulence .8
			omega 0.835 // default 0.5, higher = rougher
    	}
		}
	}
#declare LtSmokeMaterial =
	material {
		texture { SmokeSurfTex }
		interior { LtSmokeInt }
	}

#declare FlameInt =
	interior {
		media {
			emission <.0005,.0005,.0005,>
	    density { spherical
				color_map{
					[0.00 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.40 color rgb<0.00,0.00,0.00> ] // outside is transparent
					[0.45 color rgb<0.00,0.00,0.06> ] // blue tinge
					[0.50 color rgb<0.70,0.02,0.00> ]
					[0.80 color rgb<0.60,0.30,0.00> ]
					[0.90 color rgb<1.30,1.30,1.15> ] // inside is opaque
				}
				scale .6
			turbulence <.08,1.2,.08>
			omega 0.835 // default 0.5 higher = rougher
	    }
		}
	}
#declare FlameMaterial =
	material {
		texture { SmokeSurfTex }
		interior { FlameInt }
	}

//===============================================
//						 Objects
//===============================================

//------------- Smoke --------------------

#declare Smoke =
	#switch ( GoodSmoke )
	#case (0)
		sphere { <0,0,0>,1 texture { BlackPaint } scale 80*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material { SmokeMaterial } scale 130*Feet } // render
	#break
	#end
#declare SmokeGroup =
	union {
		object { Smoke rotate RandRot() scale 1.0 translate <0,0*Meters,0*Meters> }
		object { Smoke rotate RandRot() scale 1.5 translate <10*Meters,40*Meters,20*Meters> }
		object { Smoke rotate RandRot() scale 1.7 translate <35*Meters,90*Meters,0*Meters> }
		object { Smoke rotate RandRot() scale 2.0 translate <85*Meters,140*Meters,-40*Meters> }
		object { Smoke rotate RandRot() scale 2.6 translate <100*Meters,180*Meters,-100*Meters> }
		bounded_by { cylinder{<0,-15*Meters,0>,<0,260*Meters,0>,240*Meters} }
	}
#declare LtSmoke = // for Oglala ship
	#switch ( GoodSmoke )
	#case (0)
		sphere { <0,0,0>,1 texture { BlackPaint } scale 60*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material { LtSmokeMaterial } scale 80*Feet } // render
	#break
#end


//------------- Fire --------------------

#declare Flame =
	#switch ( GoodSmoke )
	#case (0)
		sphere { <0,0,0>,1 texture { WhitePaint } scale 80*Feet } // quick test
	#break
	#case (1)
		sphere { <0,0,0>,1 hollow material { FlameMaterial } scale 130*Feet } // render
	#break
	#end
#declare FireGroup =
	object { Flame }
