
// POV-Ray Object File - Vehicles
// created 3-Dec-98
// last update 22-Dec-98
// 1998 Glenn McCarter and N.B.
// This file does not render.  #include "Vehicles.inc" in another .pov file
// Required #include files: "GUnits.inc"
//
// Objects:
// Vehicles
//
//
// Intended scale is metric system (centimeters)
// Uses LH coordinate reference system (Y=up)



//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare WhitePaint =
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare BrightWhitePaint =
	texture {
		pigment { color rgb<.99,.98,.92> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .33 diffuse .7 specular .6 roughness .05 }
	}
#declare NavyBluePaint =
	texture {
		pigment { color rgb <0.431,0.424,0.584> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}
#declare OliveDrabPaint =
	texture {
		pigment { color rgb<.004,.427,.005> }
		normal { bumps .02 scale 1*cm }
		finish { ambient .2 diffuse .7 specular .6 roughness .05 }
	}

#declare TireTex =
	texture {
		pigment { color rgb<.12,.12,.12> } // more dark grey
		normal { bumps .1 scale .03}
		finish { phong .3 phong_size 12 }
	}

#declare SkinTex =
	texture {
		pigment { color rgb<.9,.8,.5> }
		finish { ambient .12 specular .1 roughness .1 }
	}
#declare BluePantsTex =
	texture {
		pigment { color rgb <0.41,0.48,0.73> }
		normal { bumps .2 scale 6*cm }
		finish { ambient .10 diffuse .7 specular .3 roughness .13 }
	}
#declare WhiteShirtTex =
	texture {
		pigment { color rgb <0.93,0.98,0.95> }
		normal { bumps .2 scale 6*cm }
		finish { ambient .10 diffuse .7 specular .5 roughness .13 }
	}


//===============================================
//						 Objects
//===============================================

#declare JTire =
	torus {
		22*inches/2,4*inches
		rotate x*90
		scale <1,1,2>
		texture { TireTex }
		translate <0,15*inches,4*inches> // set above ground
	}
#declare TTire =
	torus {
		38*inches/2,4*inches
		rotate x*90
		scale <1,1,2>
		texture { TireTex }
		translate <0,23*inches,4*inches> // set above ground
	}

#declare JeepShape =
	union {
		superellipsoid { <.2,.2> scale <5.6*Feet,18*Inches,2.2*Feet> translate <0,28*Inches,0> }
		box { <-3.8*Feet,10*inches,-3.0*Feet>,< 3.2*Feet,44*inches,3.0*Feet> } // body
		box { <-5.8*Feet,10*inches,-3.5*Feet>,<-2.9*Feet,36*inches,3.5*Feet> } // Ffender
		box { < 4.8*Feet,10*inches,-3.5*Feet>,< 1.1*Feet,36*inches,3.5*Feet> } // Rfender
		box { <-1.2*Feet,44*inches,-2.5*Feet>,<-1.3*Feet,66*inches,2.5*Feet> } // windshield
		object { JTire translate <-4.6*Feet,0,-3.5*Feet> }
		object { JTire translate < 3.1*Feet,0,-3.5*Feet> }
		object { JTire rotate y*180 translate <-4.6*Feet,0, 3.5*Feet> }
		object { JTire rotate y*180 translate < 3.1*Feet,0, 3.5*Feet> }
//		texture { BrightWhitePaint }
	}
#declare WhiteJeep =
	object { JeepShape texture { BrightWhitePaint } }

#declare BlueJeep =
	object { JeepShape texture { NavyBluePaint } }

#declare WhiteTruck =
	union {
		box { <0,0,-3*Feet>,<27*Feet,4*Feet,3*Feet> translate <0,18*Inches,0> texture { WhitePaint } } // hood
		difference {
			box { <5*Feet,0,-3.5*Feet>,<10*Feet,7*Feet,3.5*Feet> translate <0,18*Inches,0> } // cab
			box { <5.5*Feet,4*Feet,-4*Feet>,<7.5*Feet,6.7*Feet,4*Feet> translate <0,18*Inches,0> } // side windows
		}
		box { <11*Feet,18*Inches,-4*Feet>,<31*Feet,10*Feet,4*Feet> translate <0,18*Inches,0> } // box
		object { TTire translate <2.6*Feet,0,-3.5*Feet> }
		object { TTire translate < 21*Feet,0,-3.5*Feet> }
		object { TTire translate < 25*Feet,0,-3.5*Feet> }
		object { TTire rotate y*180 translate <2.6*Feet,0, 3.5*Feet> }
		object { TTire rotate y*180 translate < 21*Feet,0, 3.5*Feet> }
		object { TTire rotate y*180 translate < 25*Feet,0, 3.5*Feet> }
		texture { BrightWhitePaint }
	}

#declare Vehicles =
	union {
		object { BlueJeep rotate y*85 translate <-130*Feet,0,590*Feet> } // left dock
		object { WhiteTruck rotate y*-40 translate <-132*Feet,0,624*Feet> } // left dock

		object { WhiteJeep rotate y*90 translate <320*Feet,0,1370*Feet> } // right parked
		object { WhiteTruck rotate y*94 translate <336*Feet,0,1370*Feet> } // right parked
		object { WhiteJeep rotate y*82 translate <360*Feet,0,1370*Feet> } // right parked

		object { WhiteTruck rotate y*98 translate <197*Feet,0,658*Feet> } // right near driving

		object { WhiteTruck rotate y*90 translate <277*Feet,0,2250*Feet> } // right far driving
	}


#declare PantLeg =
	cone { <0,-28*Inches,0>,2*Inches,<0,4*Inches,0>,4.5*Inches texture { BluePantsTex } }
#declare SArm =
	union {
		cylinder { <0,-10*Inches,0>,<0,0,0>,2.5*Inches texture { WhiteShirtTex } }
		cylinder { <0,-24*Inches,0>,<0,-10*Inches,0>,1.5*Inches texture { SkinTex } }
	}
#declare Sailor = // faces +X
	union {
		sphere { <0,0,0>,5.7*Inches scale <.95,.95,.78> texture { SkinTex } translate <0,5.2*Feet,0> } // head
		cylinder { <0,0,0>,<0,24*Inches,0>,10*Inches scale <.4,1,1> texture { WhiteShirtTex } translate <0,36*Inches,0> } // chest
		object { SArm rotate <12,0,0> translate <0,4.8*Feet,-8*Inches> }
		object { SArm rotate <-12,0,0> translate <0,4.8*Feet, 8*Inches> }
		cylinder { <0,0,0>,<0,8*Inches,0>,10*Inches scale <.34,1,1> texture { BluePantsTex } translate <0,28*Inches,0> } // waist
		object { PantLeg rotate <14,0,0> translate <0,28*Inches,-5*Inches> }
		object { PantLeg rotate <-14,0,0> translate <0,28*Inches,5*Inches> }
	}

#declare People =
	union {
		object { Sailor scale 1 rotate <9,45,0> translate <-120*Feet,0,582*Feet> } // left dock nearest
		object { Sailor scale 1 rotate <0,53,12> translate <-123*Feet,0,599*Feet> } // left dock near
		object { Sailor scale 1.06 rotate <8,32,0> translate <-133*Feet,0,610*Feet> } // left dock shadow
		object { Sailor scale <1,.91,1> rotate y*78 translate <-143*Feet,0,648*Feet> } // left dock around corner
		object { Sailor scale <1,1,1> rotate z*-88 rotate y*48 translate <133*Feet,0,720*Feet> } // near crane
		object { Sailor scale <1,1,1> rotate y*100 translate <137*Feet,0,723*Feet> } // near crane
		object { Sailor scale <1,1,1> rotate y*92 translate <207*Feet,0,760*Feet> } // near building shadow
		object { Sailor scale <1,1,1> rotate y*100 translate <212*Feet,0,780*Feet> } // near building sun

		object { Sailor scale <1,1,1> rotate y*70 translate <33*Feet,13*Feet,840*Feet> } // on Pennsylvania
		object { Sailor scale <1,1,1> rotate y*88 translate <22*Feet,23*Feet,890*Feet> } // on Pennsylvania
	}