// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: Battleship: detailed model of BB-38 Pennsylvania and less detailed other ships
// Date: 18.12.1998
// Auth: copyright 1998 N.B.(n_B_@geocities.com) & Glenn McCarter (gmccarter@hotmail.com)

// This file requires:
// "metals.inc",
// "bturret2g.inc", "bturret3g.inc",
// "bhull01.inc", "bhull02.inc", "b4xhull.inc",
// "flag01.inc", "flag02.inc", "flag02_01.gif", "flag02_02.gif", "flag02_03.gif",
// "flag02_04.gif", "us01.gif"  
// Units are feet, use "GUnits.inc" to convert to other units.
// Note:
// Make a backup of all the triangular meshes: POV-Ray is known to damage these type of files.
// If POV-Ray gives a message "color expression ..." with respect to a triangular mesh file -
// restart POV-Ray.
// If this does not help - restore the triangular mesh in question from backup.
// Don't try to fix a triangular mesh manually.

// Example of all objects are at the end of the file.

//===============================================
//					Textures
//===============================================

#declare BB_TEX =
texture {
	pigment { color rgb <121, 140, 150>/255 }
	finish {
		ambient <.5,.77,1>*.1
		diffuse .6
		//reflection .02
		phong .5
		phong_size 10
	}
	normal { bumps .07 scale 7 }
}

#declare Airplane_TEX =
texture {
	pigment { color rgb <1, .7, .2> }
	finish {
		ambient <.5,.77,1>*.1
		diffuse .6
		phong .5
		phong_size 10
	}
}

#declare Flag_TEX =
texture {
	finish {
		ambient <.5,.77,1>*.2
		diffuse 1
		phong .1
		phong_size 2
	}
}

//===============================================
//					Includes
//===============================================

#include "metals.inc"
#include "bturret2g.inc"
#include "bturret3g.inc"
#include "bhull01.inc"
#include "bhull02.inc"
#include "bhull4x.inc"
#include "flag01.inc"
#include "flag02.inc"

//===============================================
//					Misc. shapes
//===============================================

#macro Polygon ( OuterRad, Height, NoSides )
	#declare Ang0i = 2*pi/NoSides;
	prism { linear_sweep linear_spline
		0, Height, NoSides+1,

		#while( NoSides >= 0)
			#declare Ang01 = Ang0i * NoSides;
			< OuterRad * cos ( Ang01 ), OuterRad * sin ( Ang01 ) >
			#if (NoSides > 0 )
				,
			#end
			#declare NoSides = NoSides - 1;
		#end
	}
#end

//===============================================
//					Objects
//===============================================


#declare BBoat01 =
union{
	#declare Boat01_01=
	intersection{
		union{
			cylinder { <0, -1, 0> <0, 2, 0> 1 scale < 17, 1, 6 > }
			sphere { <0, 0, 0> 1 scale < 17, 5, 6 > translate y*-1 }
		}
		box { <-17, -5, -8> < 15, 2, -1 > }
	}
	#declare Boat01_02=
	difference{
		object { Boat01_01 translate z*1 }
        cylinder { <0, 0, 10> <0, 0, -10> 1 scale < 17, 1.7, 1 > translate < 0, 2, 0 >}
	}
	object { Boat01_02 }
	object { Boat01_02 scale < 1, 1, -1> }
	translate <2, -2, 0 >
}

#declare BMount=
union{
	cylinder { <0, 0, 0> <0, 10, 0>.5 }
	sphere { <0, 10, 0>.5 }
	intersection{
		torus { 9, .4 }
		box { < 0, 1, 0 > <10, -1, 10 > }
		rotate x*-90
		rotate y*-90
		translate < 0, 10, -9 >
	}
	sphere { <0, 19, -9>.4 } 
}

#macro BFence_Elm ( XX1, ZZ1, XX2, ZZ2,)
	union{
		cylinder { < XX2, 0, ZZ2 > < XX2, 4, ZZ2 > .2 }
		cylinder { < XX1, 3.9, ZZ1 > < XX2, 3.9, ZZ2 > .1 }
		cylinder { < XX1, 8/3, ZZ1 > < XX2, 8/3, ZZ2 > .1 }
		cylinder { < XX1, 4/3, ZZ1 > < XX2, 4/3, ZZ2 > .1 }
	}
#end

// 14" gun
#macro BGunBarrel14(BGunElevAngle14)
	lathe { linear_spline 7
		< 14/24, -3 >, < 1.7, -3>, < 1.5, 14 >, < 1.4, 14 >,
		< .95, 35 >, < 14/24, 35 >, < 14/24, -3 >
		rotate z*90
		translate <2, 0, 0>
		rotate z*-BGunElevAngle14
	}
#end

// with 3 guns:
#macro BTurret14_3g( BGunElevAngle14, BTurretRotAngle14 )
	union {
		cylinder { < 0, 0, 0 > <0, -1, 0> 17 }
		cylinder { < 0, -1, 0 > <0, -16, 0> 15.5 }
		union{
			object { BTurret_01 }
			object { BTurret_01 scale < 1, 1, -1> }
			box { <-3, -1.5, -14 > <3, 1.5, 14 > translate <22, 7, 0> }
		}	
		union{
			object { BGunBarrel14 ( BGunElevAngle14 ) translate <-11, 5, 0> }
			object { BGunBarrel14 ( BGunElevAngle14 ) translate <-11, 5, 5> }
			object { BGunBarrel14 ( BGunElevAngle14 ) translate <-11, 5, -5> }
		}
		rotate y*BTurretRotAngle14
	}
#end

// with 2 guns:
#macro BTurret14_2g( BGunElevAngle14, BTurretRotAngle14 )
	union {
		cylinder { < 0, 0, 0 > <0, -1, 0> 17 }
		cylinder { < 0, -1, 0 > <0, -16, 0> 15.5 }
		union{
			object { BTurret_02 }
			object { BTurret_02 scale < 1, 1, -1> }
			box { <-3, -1.5, -14 > <3, 1.5, 14 > translate <22, 7, 0> }
		}	
		union{
			object { BGunBarrel14 ( BGunElevAngle14 ) translate <-11, 5, -4> }
			object { BGunBarrel14 ( BGunElevAngle14 ) translate <-11, 5, 4> }
		}
		rotate y*BTurretRotAngle14
	}
#end

// 5" gun01

#declare BGunBarrel5 =
lathe { linear_spline 5
	< 5/24, -3 >, < 0.6, -3>, < .35, 13 >, < 5/24, 13 >, < 5/24, -3 >
	rotate z*90
	translate <-3, 0, 0>
}

#macro BTurret5( BTurretRotAngle5 )
	union {
		lathe { linear_spline 8
			< 0, 0 >, < 5.5, 0 >, < 5.5, 2 >, < 6, 2.5 >,
			< 6, 7.5 >, < 5.5, 7 >, < 5.5, 9 >, < 0, 9 >
		}
		object { BGunBarrel5 translate <0, 4.5, 0> }
		rotate y*BTurretRotAngle5
	}
#end

// 5" gun01
#macro BGun5 ( BGunElevAngle5, BGunRotAngle5 )
	union{
		union{
			torus { 3.3, .2  translate < 0, 4, 0 > }
    		torus { 3.3, .1  translate < 0, 8/3, 0 > }
			torus { 3.3, .1  translate < 0, 4/3, 0 > }
			cylinder { < 0, 0, 0 > < 0, -.5, 0 > 3.3 }
			#declare Count01 = 4;
			#while (Count01 >= 0 )
				 cylinder { < 0, 0, 3.5 > < 0, 4, 3.3 > .1
					rotate y*-180/4*Count01
				}
				#declare Count01 = Count01 -1;
			#end
			translate < -1.5, 2, 0 > 
		}
		cylinder { < 0, 0, 0 > < 0, 2, 0 > 3 }
		box { < -1, 2, -2.5> < 4, 6.5, 2.5 > }
		cylinder { < -1, 6, -3 > < -1, 6, 3 > .75 }
		union{
			object { BGunBarrel5 translate x*3 }
			box { < -1, -1, -1 >  < 5, 1, 1 > }
			cylinder { < -2, -.5, -1.3 > < -2, 2, -1.3 > .4 }
			cylinder { < -2, -.5, 1.3 > < -2, 2, 1.3 > .4 }
			rotate z*-BGunElevAngle5
			translate y*6
		}
		rotate y*-BGunRotAngle5
	}
#end

#declare BRadar=
union{
	cone { < 0, 6, -2.5 >1.9 < 0, 6, -10 > 1.2 scale < .7, 1, 1 > }
	cone { < 0, 6, 2.5 >1.9 < 0, 6, 10 > 1.2 scale < .7, 1, 1 > }
	cylinder { < 0, 6, -2.5 > < 0, 6, 2.5 > 2.2 }
	box { < -2.2, 0, -2.5 > < 2.2, 6, 2.5 > }
}

#declare BB_Deck01_01=
prism { linear_sweep linear_spline 0, 9, 17
	<-82, 0>,
	<-82, 22>, <-76, 22>, <-70, 27>, <-65, 27 >, <-56, 35>, <-48, 35>, <-42, 41>,
	<-17, 41>, <-11, 47 >, <10, 47>, <16, 41>, <44, 41>, <50, 35>, < 73, 35 >,
	<73, 0>, <-82, 0>
}

// BTRA5sx = Battleship Turret Rotation Angle 5", s = side (left, right), x = number

#macro BB_Deck01 (	
		BTRA5l1, BTRA5l2, BTRA5l3, BTRA5l4, BTRA5l5,
		BTRA5r1, BTRA5r2, BTRA5r3, BTRA5r4, BTRA5r5 )
union{
	object { BB_Deck01_01 }
	object { BB_Deck01_01 scale <1, 1, -1> }
	box { < -24.5, 0, -49 > < 23.5, -2, 49 > }
	union{
		object { BTurret5( BTRA5r1 ) translate < -76.5, 0, 21 > }
		object { BTurret5( BTRA5r2 ) translate < -48, 0, 35 > }
		object { BTurret5( BTRA5r3 ) translate < -17, 0, 41 > }
		object { BTurret5( -BTRA5r4 ) rotate y*180 translate < 16, 0, 41 > }
		object { BTurret5( -BTRA5r5 ) rotate y*180 translate < 50, 0, 35 > }
		translate < 0, 0, 2 >
	}
	union {
		object { BTurret5( BTRA5l1 ) translate < -76.5, 0, 21 > }
		object { BTurret5( BTRA5l2 ) translate < -48, 0, 35 > }
		object { BTurret5( BTRA5l3 ) translate < -17, 0, 41 > }
		object { BTurret5( -BTRA5l4 ) rotate y*180 translate < 16, 0, 41 > }
		object { BTurret5( -BTRA5l5 ) rotate y*180 translate < 50, 0, 35 > }
		translate < 0, 0, 2 >
		scale < 1, 1, -1 >
	}
}
#end

#declare BB_Deck02=
union{
	cylinder { < 56, 0, -34.8 > < 56, 4, -34.8 > .2 }
		object { BFence_Elm ( 56, -34.8, 50, -40.8 ) }
	object { BFence_Elm ( 50, -40.8, 43, -40.8 ) }
	object { BFence_Elm ( 43, -40.8, 36, -40.8 ) }
	object { BFence_Elm ( 36, -40.8, 29, -40.8 ) }
	object { BFence_Elm ( 29, -40.8, 22, -40.8 ) }
		object { BFence_Elm ( 22, -40.8, 16, -46.8 ) }
	object { BFence_Elm ( 16, -46.8, 10, -46.8 ) }
	object { BFence_Elm ( 10, -46.8, 3, -46.8 ) }
	object { BFence_Elm ( 3, -46.8, -4, -46.8 ) }
	object { BFence_Elm ( -4, -46.8, -11, -46.8 ) }
	object { BFence_Elm ( -11, -46.8, -19, -46.8 ) }
		object { BFence_Elm ( -19, -46.8, -23, -40.8 ) }
	object { BFence_Elm ( -23, -40.8, -30, -40.8 ) }
	object { BFence_Elm ( -30, -40.8, -36, -40.8 ) }
	object { BFence_Elm ( -36, -40.8, -42, -40.8 ) }
	object { BFence_Elm ( -42, -40.8, -50, -40.8 ) }
		object { BFence_Elm ( -50, -40.8, -54, -34.8 ) }
		object { BFence_Elm ( -54, -34.8, -60, -30.8 ) }
		object { BFence_Elm ( -60, -30.8, -65, -26.8 ) }
	object { BFence_Elm ( -65, -26.8, -71, -26.8 ) }
	object { BFence_Elm ( -71, -26.8, -77, -26.8 ) }
		object { BFence_Elm ( -77, -26.8, -81.8, -21.8 ) }
	object { BFence_Elm ( -81.8, -21.8, -81.8, -15 ) }
	object { BFence_Elm ( -81.8, -15, -81.8, -7.5 ) }
	object { BFence_Elm ( -81.8, -7.5, -81.8, 0 ) }
}

#declare Crane_01 =
prism { linear_sweep linear_spline 0, .75, 7
	<0, .6>, <-30, 1.3>, <-40, .6>,
	<-40, -.6 >, <-30, -1.3>, <0, -.6>,
	<0, .6>
}

#macro Crane ( CraneRotAngle, CraneHgt )
union{
	union{
		object { Crane_01 rotate x*-90 translate < 0, 0, -1 > }
		object { Crane_01 rotate x*90 translate < 0, 0, 1 > }
		cylinder { <0, 0, 2> <0, 0, -2 > 1 }
		cylinder { <-41, 1, 1> <-41, 1, -1 > 1.5 }
		cylinder { <-40, 0, 1.75> <-40, 0, -1.75 > .6 }
		cylinder { vrotate ( <-20, .2, 0> <0, 0, 32 > ) <-2, 2, 0 > .1
			translate x*-40
		}
		#declare Count01 = 9;
		#while ( Count01 > 0 )
			cylinder { <0, 0, 1> <0, 0, -1 > .5 translate x*-4*Count01 }
            #declare Count01 = Count01 - 1;
		#end
		union{
			prism { linear_sweep linear_spline -1.2, 1.2, 5
				<0, .6>, <-20, .3 >, <-20, -.3>,
				<0, -.6 >,
				<0, .6>
			}
			cylinder { <-20, -1.2, 0> <-20, 1.2, 0 > .35 }
			cylinder { <0, -1.2, 0> <0, 1.2, 0 > .7 }
			rotate x*90
			rotate z*32
			translate x*-40
		}
		union{
			cylinder { < 1, 0, 0 > < 1, -CraneHgt, 0 > .1 }
			cylinder { < -1, 0, 0 > < -1, -CraneHgt, 0 > .1 }
			cylinder { < 0, -CraneHgt, -1 > < 0, -CraneHgt, 1 > 1 }
			cylinder { < 0, -CraneHgt, 0 > < 0, -CraneHgt-2, 0 > .6 }
			rotate z*(-32 +36)
			translate x*-12
			rotate z*32
			translate x*-40
		}
		rotate z*-36
		translate < 0, 34, 0 >
	}
	lathe { linear_spline 5
		< 0, 0 >, < 1.5, 0 >, < 1.5, 35>, < 1, 52 >, < 0, 52 >
	}
	cylinder { ( vrotate ( < -30, 0, -2 > < 0, 0, -36 > ) + < 0, 34, 0 > )
				< 0, 52, -2 > .5 }
	cylinder { ( vrotate ( < -30, 0, 2 > < 0, 0, -36 > ) + < 0, 34, 0 > )
				< 0, 52, 2 > .5 }
	cylinder { < -30, 0, -2.5 > < -30, 0, 2.5 > .5
		rotate z*-36
		translate < 0, 34, 0 >
	}
	cylinder { < 0, 52, -2.5 > < 0, 52, 2.5 > .75 }
	cylinder { <0, 53.5, 1> <0, 53.5, -1 > 1.5 }
	cylinder { ( vrotate ( <-41, 2.5, 0> < 0, 0, -36 > ) + < 0, 34, 0 > )
				<0, 54.5, 1> .1 }
	cylinder { ( vrotate ( <-41, .5, 0> < 0, 0, -36 > ) + < 0, 34, 0 > )
				<0, 52.5, 1> .1 }
	cylinder { < 3, 32, 0 > < 3, 34, 0 > 4.5 }
	cylinder { < -4, 41, 0 > < -4, 41.75, 0 > 5.5 }
	box { < -2.5, 0, 2 >, < 3, 3, -2 > translate < -6, 41.75, 0 > }
	box { < -3, 0, 1.5 >, < 0, 5, -1.5 > translate < -2, 41.75, 0 > }
	
	rotate y*CraneRotAngle
}
#end


// tripod mast
#declare BB_SStructure00_01=
union{
	union{
		cylinder { < 0, 0, 0 > < 0, 3, 0 > 6 }
		object { Polygon ( 5.8, 3, 12 ) texture { T_Chrome_2C } translate < 0, 3, 0 > }
		cylinder { < 0, 6, 0 > < 0, 6.5, 0 > 6 }
		#declare Count01 = 11;
		#while ( Count01 >= 0 )
			cylinder { < 5.8, 3, 0 > < 5.8, 6, 0 > .2 rotate y* 360/12*Count01}
			#declare Count01 = Count01 -1;
		#end
		rotate y*360/24
		translate < 0, 88, 0 >
	}
    union{
		prism { linear_sweep linear_spline 0, 4, 9
			<-8, 2>, <-3, 10>, <3, 10>, <8, 2>,
			<8, -2>, <3, -10>, <-3, -10>, <-8, -2>, <-8, 2>
		}
		prism { linear_sweep linear_spline 0, 2.5, 9
			<-7.8, 1.8>, <-2.8, 9.8>, <2.8, 9.8>, <7.8, 1.8>,
			<7.8, -1.8>, <2.8, -9.8>, <-2.8, -9.8>, <-7.8, -1.8>, <-7.8, 1.8>
			texture { T_Chrome_2C }
			translate < 0, 4, 0 >
		}    
		prism { linear_sweep linear_spline -.5, .01, 9
			<-8, 2>, <-3, 10>, <3, 10>, <8, 2>,
			<8, -2>, <3, -10>, <-3, -10>, <-8, -2>, <-8, 2>
			translate < 0, 7, 0 >
		}
		#declare Win01=
			union{
				cylinder { < -7.8, 0, 2 > < -7.8, 2.5, 2 > .2 }
				cylinder { < -2.8, 0, 9.8 > < -2.8, 2.5, 9.8 > .2 }
				cylinder { < -0.9, 0, 9.8 > < -0.9, 2.5, 9.8 > .2 }
				#declare Count01 = 3;
				union{
					#while ( Count01 > 0 )
						cylinder { < 0, 0, 0 > < 0, 2.5, 0 > .2
							translate < 0, 0, sqrt ( pow ( 8, 2 ) + pow ( 5, 2 ) ) / 4 *Count01 > 
						}
						#declare Count01 = Count01 -1;
					#end
					rotate y*( degrees( atan2( 5, 8) ) )
					translate < -7.8, 0, 2 >
				}
				translate < 0, 4, 0 >
			}
		object { Win01 }
		object { Win01 scale < 1, 1, -1 > }
		object { Win01 scale < -1, 1, 1 > }
		object { Win01 scale < -1, 1, -1 > }
		translate < 0, 74, 0 >
	}
	union{
		prism { linear_sweep linear_spline 0, 4.5, 9
			<-8, 2>, <-4, 8>, <4, 8>, <8, 2>,
			<8, -2>, <4, -8>, <-4, -8>, <-8, -2>, <-8, 2>
		}
		prism { linear_sweep linear_spline 0, 2, 9
			<-7.8, 1.8>, <-3.8, 7.8>, <3.8, 7.8>, <7.8, 1.8>,
			<7.8, -1.8>, <3.8, -7.8>, <-3.8, -7.8>, <-7.8, -1.8>, <-7.8, 1.8>
			texture { T_Chrome_2C }
			translate < 0, 4.5, 0 >
		}
		prism { linear_sweep linear_spline -.5, .01, 9
			<-8, 2>, <-4, 8>, <4, 8>, <8, 2>,
			<8, -2>, <4, -8>, <-4, -8>, <-8, -2>, <-8, 2>
			translate < 0, 7, 0 >
		}
		#declare Win01=
			union{
				cylinder { < -7.8, 0, 2 > < -7.8, 2, 2 > .2 }
				cylinder { < -3.8, 0, 7.8 > < -3.8, 2, 7.8 > .2 }
				cylinder { < -1.9, 0, 7.8 > < -1.9, 2, 7.8 > .2 }
				#declare Count01 = 2;
				union{
					#while ( Count01 > 0 )
						cylinder { < 0, 0, 0 > < 0, 2, 0 > .2
							translate < 0, 0, sqrt ( pow ( 6, 2 ) + pow ( 4, 2 ) ) / 3 *Count01 > 
						}
						#declare Count01 = Count01 -1;
					#end
					rotate y*( degrees( atan2( 4, 6) ) )
					translate < -7.8, 0, 2 >
				}
				translate < 0, 4.5, 0 >
			}
		object { Win01 }
		object { Win01 scale < 1, 1, -1 > }
		object { Win01 scale < -1, 1, 1 > }
		object { Win01 scale < -1, 1, -1 > }
		cylinder { < 0, 4.5, 7.8 > < 0, 2+4.5, 7.8 > .2 }
		cylinder { < 0, 4.5, -7.8 > < 0, 2+4.5, -7.8 > .2 }
		translate < 0, 81, 0 >
	}
}

#declare BB_SStructure00=
union{
	object { BB_SStructure00_01 }
	union{
		cone { < 0, 75, 0 > 1.5 < 0, 0, 0 > 2.5 scale < 1, 1, .7 > translate < -2, 0, 0 > }
		cone { < 0, 0, 0 > 1.5 < 0, -75, 0 > 3 scale < 1, 1, .7 >
			rotate z*12
			rotate x*5
			translate < 3, 75, -3 >
		}
		cone { < 0, 0, 0 > 1.5 < 0, -75, 0 > 3 scale < 1, 1, .7 >
			rotate z*12
			rotate x*-5
			translate < 3, 75, 3 >
		}
	}
}

#declare BB_SStructure01_01=
union{
	cylinder { < 0, 0, 0 > < 0, 0, 25 > .25 rotate y* -3 } 
	cylinder { < 0, 0, 0 > < 0, 0, 25 > .25 rotate y* 3 }
	cylinder { < 0, 0, 0 > < 0, 0, 25 > .25 rotate x* -6 }
	sphere { 0, .25 }
	sphere { < 0, 0, 25 > .25 rotate y* -3 } 
	sphere { < 0, 0, 25 > .25 rotate y* 3 }
	sphere { < 0, 0, 25 > .25 rotate x* -6 }
    
	cylinder { < 0, 0, 0 > < 0, 0, 25 > .1
		rotate x* -15
		translate < 0, 0, 25/3>
		rotate x* -6
	}
	#declare Count01 = 4;
	#while ( Count01 > 0)
		union{
			cylinder {	vrotate ( < 0, 0, 5*Count01 > < 0, -3, 0 > )
						vrotate ( < 0, 0, 5*Count01 > < 0, 3, 0 > )
						.2
			}
			cylinder {	vrotate ( < 0, 0, 5*Count01 > < 0, -3, 0 > )
						vrotate ( < 0, 0, 5*Count01 > < -6, 0, 0 > )
						.2
			}
			cylinder {	vrotate ( < 0, 0, 5*Count01 > < 0, 3, 0 > )
						vrotate ( < 0, 0, 5*Count01 > < -6, 0, 0 > )
						.2
			}
		}
		#declare Count01 = Count01 -1;
	#end 
}
 
#declare BB_SStructure01_02=
union{
	#declare Count01 = 3;
	#while ( Count01 >= 0 )
		union{
			difference {
				union{
					cylinder { < 10, 0, 0 > < 10, 4, 0 > 4 }
					box { < 4, 0, 4 > < 10, 4, -4 > }
				}
				cylinder { < 10, 1, 0 > < 10, 5, 0 > 3.8 }
				box { < 0, 1, 3.8 > < 10, 5, -3.8 > }
			}
			cylinder { < 4, 0, 3.9 > < 4, 4, 3.9 > .1 }
			rotate y*90*Count01
		}
		#declare Count01 = Count01 -1;
	#end
	box { < 4, 0, 4 > < -4, 1, -4 > }
	rotate y*45
}

#declare BB_Bridge01 =
union {
	difference {
		prism { linear_sweep linear_spline -8, 4, 7
			<0, 4>, <23, 17 >, <31, 17>,
			<31, -17 >, <23, -17>, <0, -4>, <0, 4>
		}
		prism { linear_sweep linear_spline 0, 4, 7
			<.2, 3.8>, <23.28, 16.8 >, <30.8, 16.8>,
			<30.8, -16.8 >, <23.2, -16.8>, <.2, -3.8>, <.2, 3.8>
			translate y*1
		}
		prism { linear_sweep linear_spline -10, 0, 7
			<.2, 3.8>, <23.2, 16.8 >, <35, 16.8>,
			<35, -16.8 >, <23.2, -16.8>, <.2, -3.8>, <.2, 3.8>
		}
		cylinder { < 0, -8, 0 > < 35, -8, 0 > 8 scale < 1, 1, .3 > translate z*-10 }
		box { < 0, 0, 0 > < 35, -16, -20 > translate z*-10 }

		cylinder { < 0, -8, 0 > < 35, -8, 0 > 8 scale < 1, 1, .3 > translate z*10 }
		box { < 0, 0, 0 > < 35, -16, 20 > translate z*10 }

		box { < -5, 0, 5 > < 35, -16, -5 > }
	}
	cylinder { < 30.8, 4, -16.8 > < 30.8, 8, -16.8 > .2 }
	cylinder { < 23.2, 4, -16.8 > < 23.2, 8, -16.8 > .2 }
	cylinder { < 30.8, 4, 16.8 > < 30.8, 8, 16.8 > .2 }
	cylinder { < 23.2, 4, 16.8 > < 23.2, 8, 16.8 > .2 }

	prism { linear_sweep linear_spline 0, 7, 5
		<.2, 3.8>,
		<sin ( atan2 (23,13))*10, cos ( atan2 (23,13))*10 +4>,
		<sin ( atan2 (23,13))*10, -cos ( atan2 (23,13))*10 -4>,
		<.2, -3.8>, <.2, 3.8>
		texture { T_Chrome_2C }
		translate y*1
	}
	cylinder { < .2, 4, 4/3 > < .2, 8, 4/3 > .2 }
	cylinder { < .2, 4, -4/3 > < .2, 8, -4/3 > .2 }
	#declare Count01 = 4;
	#while ( Count01 >= 0 )
		cylinder { < .2, 4, 0 > < .2, 8, 0 > .2
			translate x*10/4*Count01
			rotate y*-( 90 -degrees ( atan2 (23,13) ))
			translate < .2, 0, 3.8 >
		}
		cylinder { < .2, 4, 0 > < .2, 8, 0 > .2
			translate x*10/4*Count01
			rotate y*(90-degrees ( atan2 (23,13) ))
			translate < .2, 0, -3.8 >
		}
		#declare Count01 = Count01 -1;
	#end
	difference {
		union{
			prism { linear_sweep linear_spline 0, 4, 7
				<-3, 5.5>, <22.5, 17.5 >, <31.5, 17.5>,
				<31.5, -17.5 >, <22.5, -17.5>, <-3, -5.5>, <-3, 5.5>
			}
			cylinder { < 0, 0, 0 > <0, 4, 0 > (31.5 - 22.5)/2
				translate < (31.5 - 22.5)/2 +22.5, 0, -17.5 >
			}
			cylinder { < 0, 0, 0 > <0, 4, 0 > (31.5 - 22.5)/2
				translate < (31.5 - 22.5)/2 +22.5, 0, 17.5 >
			}
			
		}
		prism { linear_sweep linear_spline 0, 4, 7
			<-2.8, 5.3>, <22.7, 17.3 >, <31.3, 17.3>,
			<31.3, -17.3 >, <22.7, -17.3>, <-2.8, -5.3>, <-2.8, 5.3>
			translate y*1
		}
		cylinder { < 0, 1, 0 > <0, 5, 0 > (31.5 - 22.5)/2 -.5
			translate < (31.5 - 22.5)/2 +22.5, 0, 17.5 >
		}
		cylinder { < 0, 1, 0 > <0, 5, 0 > (31.5 - 22.5)/2 -.5
			translate < (31.5 - 22.5)/2 +22.5, 0, -17.5 >
		}
		translate y*8
	}
	cylinder { < 0, 2, 0 > < 0, 6, 0 > 2 translate < (31.5 - 22.5)/2 +22.5, 8, -17.5 > }
	sphere { < 0, 6, 0 > 2 translate < (31.5 - 22.5)/2 +22.5, 8, -17.5 > }
	cylinder { < 0, 6, -4 > < 0, 6, 4 > .7
		translate < (31.5 - 22.5)/2 +22.5, 8, -17.5 >
	}

	cylinder { < 0, 2, 0 > < 0, 6, 0 > 2 translate < (31.5 - 22.5)/2 +22.5, 8, 17.5 > }
	sphere { < 0, 6, 0 > 2 translate < (31.5 - 22.5)/2 +22.5, 8, 17.5 > }
	cylinder { < 0, 6, -4 > < 0, 6, 4 > .7
		translate < (31.5 - 22.5)/2 +22.5, 8, 17.5 >
	}

	cylinder { < 0, 3, 0 > <0, 4, 0 > 6 translate < -3, 8, 0 > }
	cone { < 0, 0, 0 >.5 <0, 3, 0 > 3 translate < -3, 8, 0 > }
	torus { 5.8, .2  translate < -3, 12 +4, 0 > }
    torus { 5.8, .1  translate < -3, 12 +8/3, 0 > }
	torus { 5.8, .1  translate < -3, 12 +4/3, 0 > }
	#declare Count01 = 5;
	#while (Count01 >= 0 )
		cylinder { < 5.8, 0, 0 > < 5.8, 4, 0 > .1
			rotate y*60*Count01
			translate < -3, 12, 0 >
		}
		#declare Count01 = Count01 -1;
	#end
	
	object { BRadar translate < -3, 12, 0 > }
	cylinder { < 20, 8, 0 > < 20, 11, 0 > 5 }
}

#declare BB_SStructure01_03 =
union{
	difference {
		union{
			box { < 0, 0, -20 > < 40, 18, 20 > }
			cylinder { < 0, 0, 0 > < 0, 18, 0 > 1 scale < 9, 1, 20 > }
			cylinder { < 40, 0, 13 > < 40, 18, 13 > 7 }
			cylinder { < 40, 0, -13 > < 40, 18, -13 > 7 }
		}
		box { < 40, -1, -25 > < 50, 9, 25 > }
		box { < 42, 8, -25 > < 50, 11, 25 > }
        cylinder { < 42, 9, -25 > < 42, 9, 25 > 2 }

		box { < 31, -1, -25 > < 37, 9, 25 > }
		box { < 33, 8, -25 > < 35, 11, 25 > } 
		cylinder { < 33, 9, -25 > < 33, 9, 25 > 2 }
		cylinder { < 35, 9, -25 > < 35, 9, 25 > 2 }

		box { < -10, -1, -25 > < 28, 9, 25 > }
		box { < -10, 8, -25 > < 26, 11, 25 > }
		cylinder { < 26, 9, -25 > < 26, 9, 25 > 2 } 
	}
	difference {
		box { < 0, 0, -17 > < 30, 18, 17 > }

		box { < 17, -1, -20 > < 28, 8, 20 > }
		box { < 19, 7, -20 > < 26, 10, 20 > }
		cylinder { < 19, 8, -20 > < 19, 8, 20 > 2 }
		cylinder { < 26, 8, -20 > < 26, 8, 20 > 2 }

		box { < -1, -1, -20 > < 14, 8, 20 > }
		box { < -1, 7, -20 > < 12, 10, 20 > }
		cylinder { < 12, 8, -20 > < 12, 8, 20 > 2 }
	}
	box { < 0, 0, -13 > < 47, 18, 13 > }
	cylinder { < 0, 0, 0 > < 0, 28, 0 > 1 scale < 8, 1, 10 > }
	cylinder { < -9, 26, 0 > < 0, 26, 0 > 1.5 }
	torus { 1.5 -.2, .2 rotate z*90 translate < -9, 26, 0 > }
    
	cylinder { < -8.8, 21, 0 > < -8.8, 25, 0 > .2 }
	#declare BFence01=
	union{
		object { BFence_Elm ( -8.8, 0, -7.7, -8 ) }
		object { BFence_Elm ( -7.7, -8, -5, -14 ) }
		object { BFence_Elm ( -5, -14, 0, -17.8 ) }

		#declare Count01 = 5;
		#while ( Count01 > 0 )
			object { BFence_Elm ( (Count01-1)*7, 0, Count01*7, 0 )
			translate z*-17.8
			}
			#declare Count01 = Count01 -1;
		#end
		translate y*21
	}
    object { BFence01 }
	object { BFence01 scale < 1, 1, -1 >}
	union{
		box { < 0, 20, -18 > < 35, 21, 18 > }
		box { < 10, 17, -13 > < 40, 21, 13 > }
		cylinder { < 0, 20, 0 > < 0, 21, 0 > 1 scale < 9, 1, 18 > }
		cylinder { < 35, 20, 13 > < 35, 21, 13 > 5 }
		cylinder { < 35, 20, -13 > < 35, 21, -13 > 5 }
		#declare Count01 = 8;
		#while ( Count01 >= 0 )
			cylinder { < 0, 18, -17.7 > < 0, 20, -17.7 > .3 translate x*35/8*Count01 }
			cylinder { < 0, 18, 17.7 > < 0, 20, 17.7 > .3 translate x*35/8*Count01 }
			#declare Count01 = Count01 - 1;
		#end 
    }
	box { < 15, 21, -7 > < 35, 29, 7 > }
	cylinder { < 36, 21, 14 > < 36, 29 +8, 14 > 1.25 }
	cylinder { < 36, 21, -14 > < 36, 29 +8, -14 > 1.25 }

	object { BB_Bridge01  translate < 9, 29, 0 > }
}

#declare BB_SStructure01 =
union{
	object { BB_SStructure00 }
	object { BB_SStructure01_01
			rotate y*-2
			translate <2, 74, -34>
	}
	object { BB_SStructure01_01
			rotate y*-2
			translate <2, 74, -34>
			scale < 1, 1, -1 >
	}
	object { BB_SStructure01_02 translate < 2, 65, 0 > }
	object { BB_SStructure01_03 translate < -32, 9, 0 > }
	union{
		cylinder { <0, -5, 0> <0, 5, 0> .25 translate < 0, 94.5, 0 > }
		cylinder { <0, -5, 0> <0, 20, 0> .3 translate < 7, 88, 0 > }
	}
	union{
		cylinder { <-1, 0, 0> <1, 0,  0> 3 }
		torus { 3-.2, .2 rotate z*90 translate x*-1}
		translate < -5, 60, 0 >
	} 
}

#declare BB_SStructure02_01=
difference{
	union{
		cylinder { < 25/2-4, 0, 0 > < 25/2-4, 4, 0 > 4 }
		box { < -4, 0, 4 > < 25/2-4, 4, -4 > }
		cylinder { < 25/2-4, 0, 0 > < 25/2-4, 4, 0 > 4 rotate y*-130 translate x*-2}
		box { < -2, 0, 4 > < 25/2-4, 4, -4 > rotate y*-130 translate x*-2 }
		cylinder { < 25/2-4, 0, 0 > < 25/2-4, 4, 0 > 4 rotate y*130 translate x*-2 }
		box { < -2, 0, 4 > < 25/2-4, 4, -4 > rotate y*130 translate x*-2 }
	}

	cylinder { < 25/2-4, 1, 0 > < 25/2-4, 5, 0 > 3.8 }
	box { < -4, 1, 3.8 > < 25/2-4, 5, -3.8 > }
	cylinder { < 25/2-4, 1, 0 > < 25/2-4, 5, 0 > 3.8 rotate y*-130 translate x*-2}
	box { < -2, 1.000001, 3.8 > < 25/2-4, 6, -3.8 > rotate y*-130 translate x*-2 }
	cylinder { < 25/2-4, 1, 0 > < 25/2-4, 5, 0 > 3.8 rotate y*130 translate x*-2 }
	box { < -2, .999999, 3.8 > < 25/2-4, 7, -3.8 > rotate y*130 translate x*-2 }

}

#declare BB_SStructure02 =
union{
	object { BB_SStructure00 rotate y*180 }
	union{
		cylinder { < 0, 94.5, -3 > ( <0, 20, 0> + < -7, 88, 0 > ) .1 }
        cylinder { < 0, 94.5, -3 > ( <0, 20, 0> + < -7, 88, 0 > ) .1 }
		cylinder { <0, 20, -7> <0, 20 + 7*2/3, 0> .1 translate < -7, 88, 0 > }
		cylinder { <0, 20, 7> <0, 20 + 7*2/3, 0> .1 translate < -7, 88, 0 > }
		cylinder { <0, 20, -7> <0, 20/3, 0> .1 translate < -7, 88, 0 > }
		cylinder { <0, 20, 7> <0, 20/3, 0> .1 translate < -7, 88, 0 > }

		cylinder { <0, -5, 0> <0, 27, 0> .3 translate < -7, 88, 0 > }
		cylinder { <0, 20, -7> <0, 20, 7> .3 translate < -7, 88, 0 > }
	}
	prism { linear_sweep linear_spline 0, 1, 7
		<0, 2>, <-12, 7 >, <-15, 5>,
		<-15, -5 >, <-12, -7>, <0, -2>, <0, 2>
		translate < 9, 58, 0 >
	}
	object { BB_SStructure02_01 translate < 0, 48, 0 > }
	object { BB_SStructure02_01 translate < 0, 35, 0 > }
	object { BRadar translate < 25/2-4, 36, 0 > } 
}

#declare BB_Funnel01_01 =
union{
	difference {
		union{
			prism { linear_sweep linear_spline 0, 4, 9
				<-6.5, 0>, <-6.5, 5 >, <-3.5, 5>, <-3.5, 8>,
				<3.5, 8>, <3.5, 5>, <6.5, 5>, <6.5, 0>, <-6.5, 0> 
			}
			cylinder { < -3.5, 0, 5> <-3.5, 4, 5> 3 }
			cylinder { < 3.5, 0, 5> <3.5, 4, 5> 3 }
		}
		prism { linear_sweep linear_spline 0, 4, 9
			<-6.3, -1>, <-6.3, 5 >, <-3.5, 5.01>, <-3.5, 7.8>,
			<3.5, 7.8>, <3.5, 5.01>, <6.3, 5>, <6.3, 0>, <-6.3, -1>
			translate y*1 
		}
		cylinder { < -3.5, 1, 5> <-3.5, 5, 5> 2.8 }
		cylinder { < 3.5, 1, 5> <3.5, 5, 5> 2.8 }
	}
	cylinder { < -2.5, 0, 1> <-2.5, -5, 1> 4 }
	cylinder { < 2.5, 0, 1> <2.5, -5, 1> 4 }
	box { < -2.5, 0, 0 > < 2.5, -5, 5 > }

	cylinder { < -2.5, -12, 1> <-2.5, -8, 1> 4 }
	cylinder { < 2.5, -12, 1> <2.5, -8, 1> 4 }
	box { < -2.5, -12, 0 > < 2.5, -8, 5 > }

	cylinder { < 2.6, -8, 4.8> <2.6, -5, 4.8> .2 }
	cylinder { < -2.6, -8, 4.8> <-2.6, -5, 4.8> .2 }

	#declare BB_Funnel01_02 =
	union{
		cylinder { < -1.5, 0, 0> <1.5, 0, 0> 2 }
		cylinder { < -.5, 0, 0> <.5, 0, 0> 2.2 }
		sphere { 0 2 scale <.5, 1, 1> translate <1.5, 0, 0> }
		torus { 1.8, .2 rotate z*90 translate <-1.5, 0, 0> }
	}
	object { BB_Funnel01_02 translate <-3.5, 6, 5> }
	object { BB_Funnel01_02 translate <-3.5, 6, 5> scale <-1, 1, 1> }

	lathe { linear_spline 8
		< 0, 1 >,
		< 4.8, 1 >, < 4.8, 4.5 >, < 5, 4.5 >, < 5, 0 >,
		< 2, -2 >, < 2, -20 >, < 0, -20 >
		translate < 4, -12, -18 >
	}

	translate < 0, 35, 4 >	
}

#declare BB_Funnel01 =
union{
	lathe { linear_spline 12
		< 5, 0 >, < 8, 0 >, < 8, 40 >, < 8.5, 40 >,
		< 8.5, 43 >, < 8, 43 >, < 8, 44.5 >, < 8.5, 44.5 >,
		< 8.5, 45 >, < 8, 46 >, < 5, 46 >, < 5, 0 >
		scale < 1, 1, .8 >
	}
	cylinder { < -7.5, 45, 0 > < -7.5, 51, 0 > .5 }
	cylinder { < -6, 45, 0 > < -6, 48, 0 > .5 }
	object { BB_Funnel01_01 }
	object { BB_Funnel01_01 scale <1, 1, -1> }
	box { < -6.5, 39, -5 > < 6.5, 30, 5 > }
	box { < -6.5, 27, -5 > < 6.5, 23, 5 > }
}

#declare Count01 = 4;
#declare Lenght01 = 16;
#declare Width01 = 2;
#declare Dist01 = sqrt ( pow ( Lenght01, 2 ) + pow ( Width01/2, 2 ) );
#declare Dist02 = sqrt ( pow ( Dist01, 2 ) + pow ( Width01/2, 2 ) );
#declare Angle01 = atan2 ( Width01/2, Dist02 );
#declare Dist03 = Dist01/ (Count01 + 1);
#declare Dist04 = Dist02/ (Count01 + 1);
#declare Crane02_01 =
union{
    cylinder { < 0, Width01/2, Width01/2 > < Lenght01, 0, 0 > .25 }
	cylinder { < 0, Width01/2, -Width01/2 > < Lenght01, 0, 0 > .25 }
	cylinder { < 0, -Width01/2, Width01/2 > < Lenght01, 0, 0 > .25 }
	cylinder { < 0, -Width01/2, -Width01/2 > < Lenght01, 0, 0 > .25 }

	cylinder { < 0, Width01/2, Width01/2 > < 0, -Width01/2, Width01/2 > .25 }
	cylinder { < 0, Width01/2, -Width01/2 > < 0, -Width01/2, -Width01/2 > .25 }
	cylinder { < 0, Width01/2, -Width01/2 > < 0, Width01/2, Width01/2 > .25 }
	cylinder { < 0, -Width01/2, -Width01/2 > < 0, -Width01/2, Width01/2 > .25 }

    sphere { < 0, Width01/2, Width01/2 > .25 }
	sphere { < 0, -Width01/2, Width01/2 > .25 }
	sphere { < 0, Width01/2, -Width01/2 > .25 }
	sphere { < 0, -Width01/2, -Width01/2 > .25 }

	cylinder { < Lenght01, 0, .5 > < Lenght01, 0, -.5 > .5 }

	#while ( Count01 > 0)
	    #declare Crane01_02=
		union{
			cylinder {	<-Dist03*Count01, -sin(Angle01)*Dist04*Count01, 0>
						<-Dist03*Count01, sin(Angle01)*Dist04*Count01, 0> .15
			rotate y*-degrees ( Angle01 )
			translate x*Dist01
			}
			cylinder {	<-Dist03*(Count01 + 1), -sin(Angle01)*Dist04*(Count01 + 1), 0>
						<-Dist03*Count01, sin(Angle01)*Dist04*Count01, 0> .15
			rotate y*-degrees ( Angle01 )
			translate x*Dist01
			}
		}
		object { Crane01_02 }
		object { Crane01_02 rotate x*90 }
		object { Crane01_02 rotate x*180 }
		object { Crane01_02 rotate x*270 }
		#declare Count01 = Count01 -1;
	#end
	cylinder { <0, Width01/2 +1.25, -.3> <0, Width01/2 +1.25, .3> 1  }
	cylinder { <Dist01, .4, 0> <0, Width01/2 +2.25 -.1, 0> .1  }
	rotate z*-25
}

#declare Count01 = 5;
#declare Lenght01 = 19;
#declare Width01 = 2;
#declare Width02 = 2.5;
#declare Dist01 = sqrt ( pow ( Lenght01, 2 ) + pow ( Width01/2, 2 ) );
#declare Angle01 = atan2 ( Width01/2, Dist01 );
#declare Dist03 = Dist01/ (Count01 + 1);

#declare Crane02=
union{
    cylinder { < 0, Width01/2, Width02/2 > < -Lenght01, 0, Width02/2 > .25 }
	cylinder { < 0, Width01/2, -Width02/2 > < -Lenght01, 0, -Width02/2 > .25 }
	cylinder { < 0, -Width01/2, Width02/2 > < -Lenght01, 0, Width02/2 > .25 }
	cylinder { < 0, -Width01/2, -Width02/2 > < -Lenght01, 0, -Width02/2 > .25 }

	cylinder { < -Lenght01, 0, Width02/2 +.5> < -Lenght01, 0, -Width02/2 -.5 > 1 }

	cylinder { < 0, 5, -.3> < 0, 5, .3 > .75
		rotate z*10
		translate <-Lenght01, 0, 0 >
	}
	cylinder { < 0, 0, 0> < 0, 5, 0 > .3
		rotate z*10
		translate <-Lenght01, 0, 0 >
	}
	cylinder { < 0, 8, -.3> < 0, 8, .3 > 1
		rotate z*-30
		translate <-Lenght01, 0, 0 >
	}
	cylinder { < 0, 0, 0> < 0, 8, 0 > .3 
		rotate z*-30
		translate <-Lenght01, 0, 0 >
	}
	cylinder {	( vrotate ( < 0, 8.9, 0 > < 0, 0, -30 > ) + <-Lenght01, 0, 0 > )
				( vrotate ( < 0, 5.65, 0 > < 0, 0, 10 > ) + <-Lenght01, 0, 0 > )
				.1 }

	cylinder {	( vrotate ( < 0, 8.9, 0 > < 0, 0, -30 > ) + <-Lenght01, 0, 0 > )
				( vrotate ( <0, Width01/2 +2.25 -.1, 0> < 0, 0, -25 > ) )
				.1 }

	cylinder { < 0, Width01/2, Width02/2 > < 0, -Width01/2, Width02/2 > .25 }
	cylinder { < 0, Width01/2, -Width02/2 > < 0, -Width01/2, -Width02/2 > .25 }

	sphere { < 0, Width01/2, Width02/2 >.25 }
	sphere { < 0, Width01/2, -Width02/2 > .25 }
	sphere { < 0, -Width01/2, Width02/2 > .25 }
	sphere { < 0, -Width01/2, -Width02/2 > .25 }

	#while ( Count01 > 0)
	    #declare Crane01_02=
		union{
			cylinder {	<-Dist03*Count01, -sin(Angle01)*Dist03*Count01, -Width02/2>
						<-Dist03*Count01, sin(Angle01)*Dist03*Count01, -Width02/2> .15
			}
			cylinder {	<-Dist03*(Count01 + 1), -sin(Angle01)*Dist03*(Count01 + 1), -Width02/2>
						<-Dist03*Count01, sin(Angle01)*Dist03*Count01, -Width02/2> .15
			}
			cylinder {	<-Dist03*Count01, -sin(Angle01)*Dist03*Count01, -Width02/2>
						<-Dist03*Count01, -sin(Angle01)*Dist03*Count01, Width02/2> .15
			}
			cylinder {	<-Dist03*(Count01 + 1), -sin(Angle01)*Dist03*(Count01 + 1), -Width02/2>
						<-Dist03*Count01, -sin(Angle01)*Dist03*Count01, Width02/2> .15
			}
			translate x*Dist01
			scale < -1, 1, 1 >
		}
		object { Crane01_02 }
		object { Crane01_02 rotate x*180 }
		#declare Count01 = Count01 -1;
	#end
	object { Crane02_01 }
	translate x*Lenght01
	rotate z*60 
}

#declare Catapult_01 =
union{
	cylinder { < -35, 0, -1.5 > < -17, -7, -1.5 > .4 }
	sphere { < -17, -7, -1.5 > .4 }
	#declare Count01 = 4;
	#while (Count01 >= 0)
		cylinder {	< (35-17)*Count01/4, 1, -1.5 >
					< (35-17)*Count01/4, -7*Count01/4, -1.5 > .4
					translate x*-35
		}
		#declare Count01 = Count01 -1;
	#end 
}		

#declare Catapult =
union{
	box { < -35.5, 0, -2 > < 35.5, 2, 2 > }
	box { < -17, 0, -1.5 > < 17, -7, 1.5 > }
	object { Catapult_01 }
	object { Catapult_01 scale < 1, 1, -1>}
	object { Catapult_01 scale < -1, 1, 1>}
	object { Catapult_01 scale < -1, 1, -1>}
}

#declare Airplane_01 =
union {
	cylinder { < 0, 0, 11.5 > < 0, 0, -11.5 > 2.5 }
	sphere { < 0, 0, 11.5 > 2.5 }
	sphere { < 0, 0, -11.5 > 2.5 }
	scale < 1, .2, 1 >
}

#declare Airplane_02 =
intersection {
	sphere { 0, 1 scale < 17, 2.6, 2.4 > translate < 8, 0, 0 > }
	box { < 4, -4, -4 > < 26, 4, 4 > }
}

#declare Airplane_03 =
union{
	cone { < 0, 0, 0 >2.8 < 0, 4.5, 0 > 2 }
	#declare Ang01 =  pi/2 - atan2 ( 4.5, ( 2.8-2 ) );
	#declare Rad01 = sqrt ( pow ( tan ( Ang01 ), 2 ) + pow ( 2, 2 ) );
	sphere { 0 Rad01  translate < 0, 4.5 - tan ( Ang01 )*2, 0 > }
	matrix < 1, 0, 0,
			.2, 1, 0,
			0, 0, 1,
			0, 0, 0 >
	scale < 1, 1, .2 >
}

#declare Airplane =
union{
	object { Airplane_01 translate < 7.5, 3, 0 > }
    object { Airplane_01 translate < 7.5, -3, 0 > }
	cylinder { < 7.5, -3, -10 > < 7.5, 3, -10 > .3 }
	cylinder { < 7.5, -3, -10 > < 7.5, 3, -10 > .3 }
	torus { 2.3, .5 rotate z*90 translate < 0, -1, 0 >}
	cylinder { < 0, 0, 0 > < 4, 0, 0 > 2.8 translate < 0, -1, 0 >}
	object { Airplane_02 translate < 0, -1, 0 >}
	object { Airplane_03 translate < 21, -1, 0 > }
	object { Airplane_03 rotate x*90 translate < 21, -1, 0 > }
	object { Airplane_03 rotate x*-90 translate < 21, -1, 0 > }
	sphere { 0, 1 scale < 10, 1.5, 1.4 > translate < 8, -7, 0 > }
	cylinder { < 7.5, -7, 0 > < 7.5, -3, 7 > .4 }
	cylinder { < 7.5, -7, 0 > < 7.5, -3, -7 > .4 }
	union{
		cylinder { < 0, 0, 0 > < 1, 0, 0> .4 }
		sphere { < 0, 1, 0 > 1 scale < .2, 2, .2 > }
		sphere { < 0, -1, 0 > 1 scale < .2, 2, .2 > }
		rotate x*35
		translate < -1, -1, 0 > 
	}
	texture { Airplane_TEX }
	translate < 0, 8.5, 0 >
}

#declare Anchor01_01 =
lathe { linear_spline 9
	< 0, 0 >,
	< 3, 0 >, < 3, .5 >, < 2.5, .5 >, < 2.5, 3.5 >,
	< 4, 3.5 >, < 4, 5 >, < 0, 5.3 >
	< 0, 0 >
}

#declare Anchor01_02 =
union{
	torus { 1.5, .3 translate < 7, 24, 4 > }
	object { Anchor01_01 translate < 105, 24, 15 >}
	cylinder { < 0, 0, 1 > < 0, 0, -1 > 4 scale < 1, .3, 1 > rotate y*10 translate < 30, 24, 9 > }
	cylinder { < 0, 0, 1 > < 0, 0, -1 > 4 scale < 1, .3, 1 > rotate y*10 translate < 40, 24, 13 > }

	cylinder { < 7, 24, 4 > < 105, 25, 2 > .3 }
	cylinder { < 30, 24, 9 > < 105, 26, 17 > .5 }
	cylinder { < 40, 24, 13 > < 105, 27, 17 > .5 }
	cylinder { < 30, 24, 9 > < 105, 26, 2 > .5 }
	cylinder { < 40, 24, 13 > < 105, 27, 2 > .5 }
}

#declare Anchor01 =
union{
	object { Anchor01_01 translate < 105, 24, 0 > }
	object { Anchor01_02 }
	object { Anchor01_02 scale < 1, 1, -1 > }
	cylinder { < 0, 0, 0 > < 0, 3, 0 > 2 translate < 55, 24, 0 > }
	cylinder { < 0, 0, 0 > < 0, 3, 0 > 2 translate < 60, 24, 0 > }  
}

#declare Anchor02=
union{
	torus { 2.5, .4 }
	union{
		sphere { < 0, 0, 0 >, 1.2 }
		cylinder { < 0, 0, -1.5 > < 0, 0, 1.5 > .75 }
		cylinder { < -.25, 0, 0 > < .25, 0, 0 > 1 scale < 1, .75, 3 > }
		cylinder { < -.25, 0, 0 > < .25, 0, 0 > 1 scale < 1, 1.5, .75 > translate < 0, 0, -3 >}
		cylinder { < -.25, 0, 0 > < .25, 0, 0 > 1 scale < 1, 1.5, .75 > translate < 0, 0, 3 >}
		cylinder { < 0, 0, -3 > < 2, 0, -3 > .5 }
		cylinder { < 0, 0, 3 > < 2, 0, 3 > .5 }
		sphere { 0, 1 scale < 1.5, .4, .75 >*1.4 translate  < 3, 0, -3 > }
		sphere { 0, 1 scale < 1.5, .4, .75 >*1.4 translate  < 3, 0, 3 > }
		rotate z*-5
		rotate y*-30
		translate y*1
	}

}

#declare Flag02_01=
object { Flag02
	texture{ Flag_TEX
		pigment {
			image_map { gif "flag02_01.gif" once }
				translate < -1, -.5, 0 >
				scale < 10, 5.3, 1 >
				rotate x*90
		}
	}
}
#declare Flag02_02=
object { Flag02	scale < 1, -1, 1 >
	texture{ Flag_TEX
		pigment {
			image_map { gif "flag02_02.gif" once }
				translate < -1, -.5, 0 >
				scale < 10, 5.3, 1 >
				rotate x*90
		}
	}
}
#declare Flag02_03=
object { Flag02	scale < 1, 1, -1 >
	texture{ Flag_TEX
		pigment {
			image_map { gif "flag02_03.gif" once }
				translate < -1, -.5, 0 >
				scale < 10, 5.3, 1 >
				rotate x*90
		}
	}
}
#declare Flag02_04=
object { Flag02
	texture{ Flag_TEX
		pigment {
			image_map { gif "flag02_04.gif" once }
				translate < -1, -.5, 0 >
				scale < 10, 5.3, 1 >
				rotate x*90
		}
	}
}
 
#declare Flag01_01=
object { Flag01
	texture{ Flag_TEX
		pigment {
			image_map { gif "us01.gif" once }
				translate < -1, -.56, 0 >
				scale < 10, 9.5, 1 >
				rotate x*90
		}
	}
}

#declare Flags02=
union{
	object { Flag02_01 rotate z*-5 }
	object { Flag02_02 rotate z*-12 translate < 0, 0, -7 >}
	object { Flag02_03 rotate z*-10 translate < 0, 0, -14 > }
	object { Flag02_04 rotate z*7 translate < 0, 0, -21 > }
}

#declare USFlag=
union{
	object { Flag01_01 scale 1.5 rotate z*-12 translate  < 0, 0, 15 >}
	union {
		cylinder { < 0, 0, 0 > < 0, 0, 20.5 > .2 }
		sphere { < 0, 0, 20.5 > .3 }
	}
}

// This is a mast for B-43 Tennessee, B-44 California, BB-46 Maryland, BB-48 West Virginia:

#declare TowerHeight = 75;
#declare TowerBase01 = 8;
#declare TowerBase02 = 5;
#declare TowerCountRad = 20;
#declare TowerCountHgt = 17;
#declare Rad01 = .4;

// approximated with log , natural logarithm
#declare TowerCountHgt00 = TowerCountHgt;
#declare E01 = (exp ( 1 ) -1);
#declare dHgt = E01/(TowerCountHgt +1);
#declare dBs = TowerBase01 - TowerBase02;
#declare Angle = 360/TowerCountRad;

#declare Tower_01=
union{
#while ( TowerCountHgt >= 0 )
	cylinder {	< log (dHgt*TowerCountHgt +1)*dBs -TowerBase01,
					dHgt*TowerCountHgt*TowerHeight/E01, 0 >
				< log (dHgt*(TowerCountHgt + 1) +1)*dBs -TowerBase01,
					dHgt*(TowerCountHgt + 1)*TowerHeight/E01, 0 >
				Rad01
			}
	sphere {	< log (dHgt*TowerCountHgt +1)*dBs -TowerBase01,
					dHgt*TowerCountHgt*TowerHeight/E01, 0 >
				Rad01
			}
	cylinder {	< log (dHgt*TowerCountHgt + 1)*dBs  -TowerBase01,
					dHgt*TowerCountHgt*TowerHeight/E01, 0 >
				vrotate ( < log (dHgt*TowerCountHgt + 1)*dBs  -TowerBase01,
					dHgt*TowerCountHgt*TowerHeight/E01, 0 > < 0, Angle, 0 > )
				Rad01
			}
	#if (TowerCountHgt = TowerCountHgt00 )
		sphere {	< log (dHgt*(TowerCountHgt +1) +1)*dBs -TowerBase01,
						dHgt*(TowerCountHgt +1)*TowerHeight/E01, 0 >
					Rad01
			}
		cylinder {	< log (dHgt*(TowerCountHgt + 1) +1)*dBs  -TowerBase01,
						dHgt*(TowerCountHgt + 1)*TowerHeight/E01, 0 >
					vrotate ( < log (dHgt*(TowerCountHgt +1 ) + 1)*dBs  -TowerBase01,
						dHgt*(TowerCountHgt + 1)*TowerHeight/E01, 0 > < 0, Angle, 0 > )
					Rad01
			}
	#end 
	#declare TowerCountHgt = TowerCountHgt -1;
#end
}

#declare Tower=
union{
#while ( TowerCountRad > 0 )
	object { Tower_01 rotate y*Angle*TowerCountRad }
	#declare TowerCountRad = TowerCountRad -1;
#end
}
 

#declare BB_SStructure03 =
union{
	object { BB_SStructure00_01 }
	object { Tower }
	object { BB_SStructure01_01
			rotate y*-2
			translate <2, 74, -34>
	}
	object { BB_SStructure01_01
			rotate y*-2
			translate <2, 74, -34>
			scale < 1, 1, -1 >
	}

	object { BB_SStructure01_03 translate < -32, 9, 0 > }

	union{
		cylinder { <0, -5, 0> <0, 5, 0> .25 translate < 0, 94.5, 0 > }
		cylinder { <0, -5, 0> <0, 20, 0> .3 translate < 7, 88, 0 > }
	}
	union{
		cylinder { <-1, 0, 0> <1, 0,  0> 3 }
		torus { 3-.2, .2 rotate z*90 translate x*-1}
		translate < -5, 60, 0 >
	} 
}

#declare BB_SStructure04 =
union{
	object { BB_SStructure00_01 }
	object { Tower }
	object { BB_SStructure01_01
			rotate y*-2
			translate <2, 74, -34>
	}
	object { BB_SStructure01_01
			rotate y*-2
			translate <2, 74, -34>
			scale < 1, 1, -1 >
	}
	object { BB_SStructure01_02 translate < 2, 45, 0 > }
	union{
		cylinder { < 0, 94.5, -3 > ( <0, 20, 0> + < -7, 88, 0 > ) .1 }
        cylinder { < 0, 94.5, -3 > ( <0, 20, 0> + < -7, 88, 0 > ) .1 }
		cylinder { <0, 20, -7> <0, 20 + 7*2/3, 0> .1 translate < -7, 88, 0 > }
		cylinder { <0, 20, 7> <0, 20 + 7*2/3, 0> .1 translate < -7, 88, 0 > }
		cylinder { <0, 20, -7> <0, 20/3, 0> .1 translate < -7, 88, 0 > }
		cylinder { <0, 20, 7> <0, 20/3, 0> .1 translate < -7, 88, 0 > }

		cylinder { <0, -5, 0> <0, 27, 0> .3 translate < -7, 88, 0 > }
		cylinder { <0, 20, -7> <0, 20, 7> .3 translate < -7, 88, 0 > }
	}
}


#declare BB_Funnel02 =

lathe { linear_spline 12
	< 5, 0 >, < 8, 0 >, < 8, 40 >, < 8.5, 40 >,
	< 8.5, 43 >, < 8, 43 >, < 8, 44.5 >, < 8.5, 44.5 >,
	< 8.5, 45 >, < 8, 46 >, < 5, 46 >, < 5, 0 >
	scale < 1, 1, .8 >
}

//===============================================
//					Ships
//===============================================

// BB-38 Pennsylvania.
// This is the only accurate ship object in this file.
// All other battleship objects are based on this one.

// Since all other battleships appear on the background in our scene,
// more accurate modeling was not justified.
 
#declare Pennsylvania=
union{
	object { Anchor01 }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > scale <1, 1, -1> }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > scale <1, 1, -1> }    
    
	union{
    	object { BB_Hull01 }
		object { BB_Hull01 scale <1, 1, -1> }
		texture { BB_TEX
			pigment{
				gradient y
				color_map {
					[ 0 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <108, 79, 63>/255 ]
					[ .91 color rgb <108, 79, 63>/255 ]
					[ .95 color rgb <57, 57, 47>/255 ]
					[ 1 color rgb <57, 57, 47>/255 ]
				}
				translate y*-50
				scale 50
			}
		}
	}                   
	object { BHull_Fence01 }
	object { BHull_Fence01 scale <1, 1, -1> }

	object { BB_Deck01 ( 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 ) translate < 346-73, 24, 0 >}
	object { BB_Deck02 translate < 346-73, 33, 0 > }
	object { BB_Deck02 translate < 346-73, 33, 0 > scale < 1, 1, -1> }

	object { BTurret14_3g (0, 0) translate < 136, 24+4, 0> }
	object { BTurret14_3g (0, 0) translate < 180, 24+15, 0> }
	union{
		#declare Angle01 = 0;
		object { BTurret14_3g (0, Angle01) }
		object { Catapult translate <10, 15, -5 > rotate y*Angle01 }
		rotate y*180
		translate < 428, 13+15, 0>
	}
	object { BTurret14_3g (0, 0) rotate y*180 translate < 475, 13+4, 0> }

	object { BGun5 (30,30)  translate < 222, 33, -30 > }
	object { BGun5 (30,30)  translate < 251, 33, -35 > }
	object { BGun5 (30,30)  translate < 280, 33, -38 > }
	object { BGun5 (30,30)  translate < 309, 33, -30 > }
	object { BGun5 (30,-30)  translate < 222, 33, 30 > }
	object { BGun5 (30,-30)  translate < 251, 33, 35 > }
	object { BGun5 (30,-30)  translate < 280, 33, 38 > }
	object { BGun5 (30,-30)  translate < 309, 33, 30 > }
	
                 
	object { BB_SStructure01 translate < 249, 23, 0 > }     
	object { BB_SStructure02 translate < 373, 23, 0 > }       

	object { Crane ( 98, 5 ) translate < 349, 13, 26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, 26 > }
	object { Crane ( -86, 20 ) translate < 349, 13, -26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, -26 > }

	object { Crane02 rotate y*223 translate < 588, 13, 0 > }

	object { BB_Funnel01 translate < 284, 24, 0 > }
    
	object { BBoat01 translate < 385, 22, -42 > }
	object { BBoat01 translate < 385, 22, 42 > }
	object { BBoat01 translate < 330, 40, -33 > }
	object { BBoat01 translate < 330, 40, 33 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.75 translate < 320, 43, -15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.75 translate < 320, 43, 15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 > translate < 320, 49, 0 > }
    
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
	}
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
		scale < 1, 1, -1 >
	} 

	box { < 340, 10, -20 > < 380, 23, 20 > }

	object { Airplane rotate y*-45 translate < 551, 13, -12 > }
	object { Airplane rotate y*-44 translate < 525, 13, -17 > }
	object { USFlag rotate x*-90 rotate y*108 translate <2.788019, 24, 0.0> }
	object { Flags02 rotate y*90 rotate x*-5 rotate z*63 rotate x*14 translate < 240, 80, 30 >}
 
	texture { BB_TEX }
}

// BB-39 Arizona

#declare Arizona=
union{
	union{
    	object { BB_Hull01 }
		object { BB_Hull01 scale <1, 1, -1> }
		texture { BB_TEX
			pigment{
				gradient y
				color_map {
					[ 0 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <108, 79, 63>/255 ]
					[ .91 color rgb <108, 79, 63>/255 ]
					[ .95 color rgb <57, 57, 47>/255 ]
					[ 1 color rgb <57, 57, 47>/255 ]
				}
				translate y*-50
				scale 50
			}
		}
	}

	object { BB_Deck01 ( 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 ) translate < 346-73, 24, 0 >}

	object { BTurret14_3g (0, 0) translate < 136, 24+4, 0> }
	object { BTurret14_3g (0, 0) translate < 180, 24+15, 0> }
	object { BTurret14_3g (0, 0) translate < 428, 13+15, 0> }
	object { BTurret14_3g (0, 00) rotate y*180 translate < 475, 13+4, 0> }

	object { BB_SStructure01 translate < 249, 23, 0 > }
	object { BB_SStructure02 translate < 373, 23, 0 > }

	object { Crane ( 6, 5 ) translate < 349, 13, 26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, 26 > }
	object { Crane ( 12, 3 ) translate < 349, 13, -26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, -26 > }

	object { BB_Funnel01 translate < 284, 24, 0 > } 

	box { < 340, 10, -20 > < 380, 23, 20 > }
 
	texture { BB_TEX }
}

// Oklahoma & Nevada

#declare BB_36_37 =
union{
	object { Anchor01 }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > scale <1, 1, -1> }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > scale <1, 1, -1> }    
    
	union{
    	object { BB_Hull01 }
		object { BB_Hull01 scale <1, 1, -1> }
		texture { BB_TEX
			pigment{
				gradient y
				color_map {
					[ 0 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <108, 79, 63>/255 ]
					[ .91 color rgb <108, 79, 63>/255 ]
					[ .95 color rgb <57, 57, 47>/255 ]
					[ 1 color rgb <57, 57, 47>/255 ]
				}
				translate y*-50
				scale 50
			}
		}
	}

	object { BB_Deck01 ( 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 ) translate < 346-73, 24, 0 >}

	object { BTurret14_3g (0, 0) translate < 136, 24+4, 0> }
	object { BTurret14_2g (0, 0) translate < 180, 24+15, 0> }
	union{
		#declare Angle01 = 0;
		object { BTurret14_2g (0, Angle01) }
		object { Catapult translate <10, 15, -5 > rotate y*Angle01 }
		rotate y*180
		translate < 428, 13+15, 0>
	}
	object { BTurret14_3g (0, 0) rotate y*180 translate < 475, 13+4, 0> }

	object { BGun5 (30,30)  translate < 222, 33, -30 > }
	object { BGun5 (30,30)  translate < 251, 33, -35 > }
	object { BGun5 (30,30)  translate < 280, 33, -38 > }
	object { BGun5 (30,30)  translate < 309, 33, -30 > }
	object { BGun5 (30,-30)  translate < 222, 33, 30 > }
	object { BGun5 (30,-30)  translate < 251, 33, 35 > }
	object { BGun5 (30,-30)  translate < 280, 33, 38 > }
	object { BGun5 (30,-30)  translate < 309, 33, 30 > }
	

	object { BB_SStructure01 translate < 249, 23, 0 > }
	object { BB_SStructure02 translate < 373, 23, 0 > }

	object { Crane ( 0, 5 ) translate < 349, 13, 26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, 26 > }
	object { Crane ( 0, 20 ) translate < 349, 13, -26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, -26 > }

	object { Crane02 rotate y*223 translate < 588, 13, 0 > }

	object { BB_Funnel01 translate < 284, 24, 0 > }
    
	object { BBoat01 translate < 385, 22, -42 > }
	object { BBoat01 translate < 385, 22, 42 > }
	object { BBoat01 translate < 330, 40, -33 > }
	object { BBoat01 translate < 330, 40, 33 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.75 translate < 320, 43, -15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.75 translate < 320, 43, 15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 > translate < 320, 49, 0 > }
    
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
	}
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
		scale < 1, 1, -1 >
	} 

	box { < 340, 10, -20 > < 380, 23, 20 > }
	texture { BB_TEX }
}

// Tennesee & California

#declare BB_43_44 =
union{
	object { Anchor01 }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > scale <1, 1, -1> }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > scale <1, 1, -1> }    
    
	union{
    	object { BB_Hull4x01 }
		object { BB_Hull4x01 scale <1, 1, -1> }
		texture { BB_TEX
			pigment{
				gradient y
				color_map {
					[ 0 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <108, 79, 63>/255 ]
					[ .91 color rgb <108, 79, 63>/255 ]
					[ .95 color rgb <57, 57, 47>/255 ]
					[ 1 color rgb <57, 57, 47>/255 ]
				}
				translate y*-60
				scale 60
			}
		}
		translate x*-7
	}

	object { BB_Deck01 ( 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 ) translate < 346-73, 24, 0 >}

	object { BTurret14_3g (0, 0) translate < 136, 24+4, 0> }
	object { BTurret14_3g (0, 0) translate < 180, 24+15, 0> }
	union{
		#declare Angle01 = 0;
		object { BTurret14_3g (0, Angle01) }
		object { Catapult translate <10, 15, -5 > rotate y*Angle01 }
		rotate y*180
		translate < 428, 13+15, 0>
	}
	object { BTurret14_3g (0, 0) rotate y*180 translate < 475, 13+4, 0> }

	object { BGun5 (30,30)  translate < 222, 33, -30 > }
	object { BGun5 (30,30)  translate < 251, 33, -35 > }
	object { BGun5 (30,30)  translate < 280, 33, -38 > }
	object { BGun5 (30,30)  translate < 309, 33, -30 > }
	object { BGun5 (30,-30)  translate < 222, 33, 30 > }
	object { BGun5 (30,-30)  translate < 251, 33, 35 > }
	object { BGun5 (30,-30)  translate < 280, 33, 38 > }
	object { BGun5 (30,-30)  translate < 309, 33, 30 > }
	

	object { BB_SStructure03 translate < 249, 23, 0 > }
	object { BB_SStructure04 translate < 373, 23, 0 > }

	object { Crane ( 180, 5 ) translate < 275, 13, 26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, 26 > }
	object { Crane ( 180, 20 ) translate < 275, 13, -26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, -26 > }

	object { Crane02 rotate y*223 translate < 588, 13, 0 > }

	object { BB_Funnel02 translate < 275, 24, 0 > }
	object { BB_Funnel02 translate < 345, 24, 0 > }
    
	object { BBoat01 translate < 385, 22, -42 > }
	object { BBoat01 translate < 385, 22, 42 > }
	object { BBoat01 translate < 330, 40, -33 > }
	object { BBoat01 translate < 330, 40, 33 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.7 translate < 310, 43, -15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.7 translate < 310, 43, 15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.75 translate < 310, 49, 0 > }
    
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
	}
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
		scale < 1, 1, -1 >
	} 

	box { < 320, 10, -25 > < 380, 23, 25 > }
	texture { BB_TEX }
	translate x*7
}

// Maryland & West Virginia

#declare BB_46_48 =
union{
	object { Anchor01 }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > }
	object { Anchor02 rotate x*-131 rotate y*7 translate < 15, 18, -10 > scale <1, 1, -1> }
	object { Anchor02 rotate x*-129 translate < 25, 18, -13 > scale <1, 1, -1> }    
    
	union{
    	object { BB_Hull4x01 }
		object { BB_Hull4x01 scale <1, 1, -1> }
		texture { BB_TEX
			pigment{
				gradient y
				color_map {
					[ 0 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <108, 79, 63>/255 ]
					[ .91 color rgb <108, 79, 63>/255 ]
					[ .95 color rgb <57, 57, 47>/255 ]
					[ 1 color rgb <57, 57, 47>/255 ]
				}
				translate y*-60
				scale 60
			}
		}
		translate x*-7
	}

	object { BB_Deck01 ( 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 ) translate < 346-73, 24, 0 >}

	object { BTurret14_2g (0, 0) translate < 136, 24+4, 0> }
	object { BTurret14_2g (0, 0) translate < 180, 24+15, 0> }
	union{
		#declare Angle01 = 0;
		object { BTurret14_2g (0, Angle01) }
		object { Catapult translate <10, 15, -5 > rotate y*Angle01 }
		rotate y*180
		translate < 428, 13+15, 0>
	}
	object { BTurret14_2g (0, 0) rotate y*180 translate < 475, 13+4, 0> }

	object { BGun5 (30,30)  translate < 222, 33, -30 > }
	object { BGun5 (30,30)  translate < 251, 33, -35 > }
	object { BGun5 (30,30)  translate < 280, 33, -38 > }
	object { BGun5 (30,30)  translate < 309, 33, -30 > }
	object { BGun5 (30,-30)  translate < 222, 33, 30 > }
	object { BGun5 (30,-30)  translate < 251, 33, 35 > }
	object { BGun5 (30,-30)  translate < 280, 33, 38 > }
	object { BGun5 (30,-30)  translate < 309, 33, 30 > }
	

	object { BB_SStructure03 translate < 249, 23, 0 > }
	object { BB_SStructure04 translate < 373, 23, 0 > }

	object { Crane ( 180, 5 ) translate < 275, 13, 26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, 26 > }
	object { Crane ( 180, 20 ) translate < 275, 13, -26 > }
	cylinder { <0, 0, 0> < 0, -1, 0> 7  translate < 349, 24, -26 > }

	object { Crane02 rotate y*223 translate < 588, 13, 0 > }

	object { BB_Funnel02 translate < 275, 24, 0 > }
	object { BB_Funnel02 translate < 345, 24, 0 > }
    
	object { BBoat01 translate < 385, 22, -42 > }
	object { BBoat01 translate < 385, 22, 42 > }
	object { BBoat01 translate < 330, 40, -33 > }
	object { BBoat01 translate < 330, 40, 33 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.7 translate < 310, 43, -15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.7 translate < 310, 43, 15 > }
	object { BBoat01 scale < 2, 1.5, 1.5 >*.75 translate < 310, 49, 0 > }
    
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
	}
	union{
		object { BBoat01 translate < 429, 23, -49 > }
		object { BMount translate < 429-7, 12, -42 > }
		object { BMount translate < 429+7, 12, -42 > }
		scale < 1, 1, -1 >
	} 

	box { < 320, 10, -25 > < 380, 23, 25 > }
	texture { BB_TEX }
	translate x*7
}

// Examples:

// object { Pennsylvania  scale 1*Feet }	// Pennsylvania
// object { Arizona } scale 1*Feet }		// Arizona
// object { BB_36_37 scale 1*Feet }			// Nevada, Oklahoma
// object { BB_43_44 scale 1*Feet }			// Tennesee, California
// object { BB_46_48 scale 1*Feet }			// Maryland, West Virginia

// I'll add comments for each part later. N.B.