// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: Destroyer ship: DD-372 Cassin, DD-375 Downes
// Date: 18.12.1998
// Auth: copyright 1998 N.B.(n_B_@geocities.com) & Glenn McCarter (gmccarter@hotmail.com)

// This file requires "dhull01_1.inc" and "dhull02.inc" 
// Units are feet, use "GUnits.inc" to convert to other units.
// Note:
// Make a backup of all the triangular meshes: POV-Ray is known to damage these type of files.
// If POV-Ray gives a message "color expression ..." with respect to a triangular mesh file -
// restart POV-Ray.
// If this does not help - restore the triangular mesh in question from backup.
// Don't try to fix a triangular mesh manually.

//===============================================
//					Textures
//===============================================

#declare D_TEX =
texture {
	pigment { color rgb <121, 140, 150>/255 /*<.6, .55, .5>*/ }
	finish {
		ambient <.4,.7,1>*.1
		diffuse .7
		phong .3
		phong_size 2
	}
	normal { bumps .1 scale 5 }
}

#include "metals.inc"

//===============================================
//					Objects
//===============================================

#include "dhull01_1.inc"
#include "dhull02.inc"

#macro DGunBarrel(GunElevAngle)
	union{
		lathe { linear_spline 5
			< .6, 0 >, < .8, 0>, < .75, 15 >, < .6, 15 >, < .6, 0 >
			rotate z*90
		}
		superellipsoid { < .3, .3 > scale < 6, 1.7, 1.5 > translate < 3, 0, 0> }

		translate <-4, 3, 0>
		rotate z*-GunElevAngle
	}
#end

#macro DTurret( GunElevAngle, TurretRotAngle )
	union {
		cylinder { <0,-2,0>,<0,2,0>,4 }
		intersection {
			union{
				superellipsoid { < .5, .5 > scale < 8, 3.3, 7 > translate < -1, 4.2, 0> }
				superellipsoid { < .7, .3 > scale < 7, 5, 6 > rotate z*7 translate < -1, 5, 0> }
				box { < -10, -5, -6.1 > < 10, 3, 6.1 > }
			}
				prism { linear_sweep linear_spline -10, 10, 6
				< 3, 1 >, <3, 10>, <-5, 12>, <-7, 4 >, <-7, 1>, < 3, 1 >
				rotate x*-90
			}
		translate x*1
		}
		object { DGunBarrel ( GunElevAngle ) translate <-1, 2, 0> }
		rotate y*TurretRotAngle
	}
#end

#macro Fence_Elm ( XX1, ZZ1, XX2, ZZ2,)
	union{
		cylinder { < XX1, 0, ZZ1 > < XX1, 4, ZZ1 > .2 }
		cylinder { < XX1, 3.9, ZZ1 > < XX2, 3.9, ZZ2 > .1 }
		cylinder { < XX1, 8/3, ZZ1 > < XX2, 8/3, ZZ2 > .1 }
		cylinder { < XX1, 4/3, ZZ1 > < XX2, 4/3, ZZ2 > .1 }
	}
#end

#declare Boat01 =
union{
	#declare Boat_Prt01=
	intersection{
		union{
			cylinder { <0, -1, 0> <0, 2, 0> 1 scale < 17, 1, 6 > }
			sphere { <0, 0, 0> 1 scale < 17, 5, 6 > translate y*-1 }
		}
		box { <-17, -5, -8> < 12, 2, -1 > }
	}
	#declare Boat_Prt02=
	difference{
		object { Boat_Prt01 translate z*1 }
        cylinder { <0, 0, 10> <0, 0, -10> 1 scale < 17, 1.7, 1 > translate < 0, 2, 0 >}
	}
	object { Boat_Prt02 }
	object { Boat_Prt02 scale < 1, 1, -1> }
	translate <2, -2, 0 >
}


#declare Boat02 =
union{
	difference {
		torus { 3-.7, .7 }
		box { < 0, 2, -10 > < 10, -2, 10 > }
		translate < -2.5, 0, 0 >
	}
	difference {
		torus { 3-.7, .7 }
		box { < 0, 2, -10 > < -10, -2, 10 > }
		translate < 2.5, 0, 0 >
	}
	cylinder { < -2.5, 0, 3-.7 > < 2.5, 0, 3-.7 > .7 }
	cylinder { < -2.5, 0, -3+.7 > < 2.5, 0, -3+.7 > .7 }

	sphere { < -2.5, 0, 3-.7 > .7 }
	sphere { < 2.5, 0, 3-.7 > .7 }
	sphere { < -2.5, 0, -3+.7 > .7 }
	sphere { < 2.5, 0, -3+.7 > .7 }

	box { < -2.5, -.3, 3-.7 > < 2.5, -.7, -3+.7 > }
	cylinder { < -2.5, -.7, 0 > < -2.5, -.3, 0 > 3-.7 }
    cylinder { < 2.5, -.7, 0 > < 2.5, -.3, 0 > 3-.7 }
    
	translate y*.7

	rotate x*-90
	
}


#declare Boat03 =
union{
	difference {
		torus { 3.5, 1 }
		box { < 0, 2, -10 > < -10, -2, 10 > }
		translate x*5
	}

	cylinder { < -6.5, 0, 3.5 > < 5, 0, 3.5 > 1 }
	cylinder { < -6.5, 0, -3.5 > < 5, 0, -3.5 > 1 }

	sphere { < 5, 0, 3.5 > 1 }
	sphere { < 5, 0, -3.5 > 1 }
	sphere { < -6.5, 0, 3.5 > 1 }
	sphere { < -6.5, 0, -3.5 > 1 }

	box { < -6.5, -.7, 3.5 > < 5, 0, -3.5 > }
	cylinder { < 5, -.7, 0 > < 5, 0, 0 > 3.5 }
	cylinder { < -6.5, 0, 3.5 > < -6.5, 0, -3.5 > .7 }
    cone { < -6.5, 0, 3.5 >1 < -13.5, 0, 3.5 > .5 }
    cone { < -6.5, 0, -3.5 >1 < -13.5, 0, -3.5 > .5 }
}
 
#declare Boat03a =
union{
	object { Boat03 }
	cylinder { < 1, 0, 0 > < 1, 3, 0 > 1.5 }
	sphere { 0 1.5 scale < 1, .5, 1 > translate < 1, 3, 0 > }
	translate y*1
	
}

#declare Boat03b =
union{
	object { Boat03 }
	cylinder { < 1, 0, 0 > < 1, 5, 0 > 3 }
	sphere { 0 3 scale < 1, .5, 1 > translate < 1, 5, 0 > }
	translate y*1
	
}

#declare Mount02=
union{
	cylinder { <0, 0, 0> <0, 10, 0>.5 }
	sphere { <0, 10, 0>.5 }
	intersection{
		torus { 9, .4 }
		box { < 0, 1, 0 > <10, -1, 10 > }
		rotate x*-90
		rotate y*-90
		translate < 0, 10, -9 >
	}
	sphere { <0, 19, -9>.4 }

	 
}

#declare Mount02a=
union{
	object { Mount02 }
    intersection{
		torus { 15, .4 }
		box { < 0, 1, 0 > <22, -1, 22 > }
		rotate x*-90
		rotate y*-90
		translate < 0, 0, -15 >
		rotate x*-160
		translate < 0, 19, -9 >
	}
	 
}

#declare SStructure01=
union{
	intersection {
		
		union{
			box { < -36, -1, -14> <34, 16, 14 >}
			superellipsoid { < 1.3, .1 >
				rotate x*90
				translate y*1
				scale < 24, 17, 14 >
				translate x*-36
			}
		}
		prism { linear_sweep linear_spline -20, 20, 7
			< 0, 0 >, <0, 15>, <30.5, 15>, <36, 10.5 >, <59, 10.5>, <59, 0>, <0, 0>
			translate x*-59
			rotate x*-90
		}
	}
	difference{
		union{
			union{
				prism { linear_sweep linear_spline 0, 1, 6
					< 0, 0 >, <0, 16>, <-23, 3>, <-23, -3>, <0, -16>, <0, 0>
				}
				prism { conic_sweep linear_spline 0, 1, 6
					< 0, 0 >, <0, 15>, <-23, 3>, <-23, -3>, <0, -15>, <0, 0>
					scale < 1, 10, 1>
					translate y*-10
				}
				matrix < 1, -.2, 0,
						0, 1, 0,
						0, 0, 1,
						0, 0, 0 >
			}
			box { <0, 0, -16> <7, 1, 16> }
		}
        prism { conic_sweep linear_spline 0, 1, 8
			< 5, 0 >, < 5, 16 >, <0, 16>, <-23, 3>, <-23, -3>, <0, -16>, < 5, -16 >, <5, 0>
			scale < 1, 3, 1>
			translate y*-3
			matrix < 1, -.2, 0,
					0, 1, 0,
					0, 0, 1,
					0, 0, 0 >
			translate <-1, 1.5, 0>
		}
		translate < -43, 14, 0 >
	}
	#declare Fence01=
	union{
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <58.5, 10.5, -13.8> }
			cylinder { <58.5, 10.5 +3.9, -13.8> <51, 10.5 +3.9, -13.8> .1 }
			cylinder { <58.5, 10.5 +8/3, -13.8> <51, 10.5 +8/3, -13.8> .1 }
			cylinder { <58.5, 10.5 +4/3, -13.8> <51, 10.5 +4/3, -13.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <51, 10.5, -13.8> }
			cylinder { <51, 10.5 +3.9, -13.8> <44, 10.5 +3.9, -13.8> .1 }
			cylinder { <51, 10.5 +8/3, -13.8> <44, 10.5 +8/3, -13.8> .1 }
			cylinder { <51, 10.5 +4/3, -13.8> <44, 10.5 +4/3, -13.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <44, 10.5, -13.8> }
			cylinder { <44, 10.5 +3.9, -13.8> <37, 10.5 +3.9, -13.8> .1 }
			cylinder { <44, 10.5 +8/3, -13.8> <37, 10.5 +8/3, -13.8> .1 }
			cylinder { <44, 10.5 +4/3, -13.8> <37, 10.5 +4/3, -13.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <37, 10.5, -13.8> }
			cylinder { <37, 10.5 +3.9, -13.8> <30.3, 15 +3.9, -13.8> .1 }
			cylinder { <37, 10.5 +8/3, -13.8> <30.3, 15 +8/3, -13.8> .1 }
			cylinder { <37, 10.5 +4/3, -13.8> <30.3, 15 +4/3, -13.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <30.3, 15, -13.8> }
			cylinder { <30.3, 15 +3.9, -13.8> <23.3, 15 +3.9, -13.8> .1 }
			cylinder { <30.3, 15 +8/3, -13.8> <23.3, 15 +8/3, -13.8> .1 }
			cylinder { <30.3, 15 +4/3, -13.8> <23.3, 15 +4/3, -13.8> .1 }
        cylinder { <0, 0, 0> <0, 4, 0> .2 translate <23.3, 15, -13.8> }
			cylinder { <23.3, 15 +3.9, -13.8> <16.3, 15 +3.9, -15> .1 }
			cylinder { <23.3, 15 +8/3, -13.8> <16.3, 15 +8/3, -15> .1 }
			cylinder { <23.3, 15 +4/3, -13.8> <16.3, 15 +4/3, -15> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <16.3, 15, -15> }
		
		translate x*-59
	}
	object { Fence01 }
	object { Fence01 scale <1, 1, -1> }
	
	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > rotate y*18 translate < -52, 8.5, -7.5> }
	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > rotate y*-18 translate < -52, 8.5, 7> }
	
	
	translate < 133.8, -2, 0 >
}


#declare SStructure02=

union{
    box { < -6.5, 0, -5 > < 0, 8, 5 > }
	box { < 3, 0, -3 > < 0, 6, 3 > }
	difference{
		prism { linear_sweep linear_spline 0, 4, 12
			< 9, 0 >, < 9, 2 >, < 3, 2 >, <3, 11>, <0, 11>, <-6.5, 5 >,
			<-6.5, -5>, <0, -11>, <3, -11>, <3, -2>, <9, -2>, < 9, 0>
			translate y*8
		}
		prism { linear_sweep linear_spline 0, 5, 12
			< 10, 0 >, < 10, 1.8 >, < 2.8, 1.8 >, <2.8, 10.8>, <0, 10.8>, <-6.3, 5 >,
			<-6.3, -5>, <0, -10.8>, <2.8, -10.8>, <2.8, -1.8>, <10, -1.8>, < 10, 0>
			translate y*8
		}
	}
	
	translate < 133.8 -22, 8.5, 0 >
}


#declare SStructure03=
union {
	box { <10, 0, -12> <0, 10.5, 12> }
	box { <16, 2, -12> <0, -10, 12> }
	box { <9.3, 1.3, -18.5> <10, -10, 18.5> }
	prism { linear_sweep linear_spline -.7, 0, 8
		< 0, 0 >, < 0, 14 >, < 7, 14 >, <10, 12>, <10, -12>, <7, -14>,
		<0, -14>, <0, 0>
		translate y*10.5
	}

	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > rotate y*90 translate < 8.8, 5, 0> }

	prism { linear_sweep linear_spline -.7, 0, 16
		<-2, 0>, <-2, 18>, <9, 18>, <13, 16>, <17, 16>, <20, 13>, <20, 10>, <17, 7 >,
		<17, -7 >, <20, -10>, <20, -13>, <17, -16>, <13, -16>, <9, -18>, <-2, -18>,<-2, 0>
	translate y*2
	}
    #declare Fence02=
	union{
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <6.8, 10.5, -13.8> }
			cylinder { <-2, 10.5 +3.9, -13.8> <6.8, 10.5 +3.9, -13.8> .1 }
			cylinder { <-2, 10.5 +8/3, -13.8> <6.8, 10.5 +8/3, -13.8> .1 }
			cylinder { <-2, 10.5 +4/3, -13.8> <6.8, 10.5 +4/3, -13.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <9.8, 10.5, -11.8> }
			cylinder { <6.8, 10.5 +3.9, -13.8> <9.8, 10.5 +3.9, -11.8> .1 }
			cylinder { <6.8, 10.5 +8/3, -13.8> <9.8, 10.5 +8/3, -11.8> .1 }
			cylinder { <6.8, 10.5 +4/3, -13.8> <9.8, 10.5 +4/3, -11.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <8, 10.5, -8> }
			cylinder { <8, 10.5 +3.9, -8> <8, 10.5 +3.9, -5> .1 }
			cylinder { <8, 10.5 +8/3, -8> <8, 10.5 +8/3, -5> .1 }
			cylinder { <8, 10.5 +4/3, -8> <8, 10.5 +4/3, -5> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <8, 10.5, -5> }
			cylinder { <8, 10.5 +4, -8> <12, 2 +4, -5> .2 }
				sphere { <8, 10.5 +4, -8> .2 }
				sphere { <12, 2 +4, -5> .2 }
			cylinder { <9.8, 10.5 +4, -11.8> <14, 2 +4, -8> .2 }
				sphere { <9.8, 10.5 +4, -11.8> .2 }
				sphere { <14, 2 +4, -8> .2 }
			cylinder { <8, 10.5, -8> <12, 2, -5> .2 }
			cylinder { <9.8, 10.5, -11.8> <14, 2, -8> .2 }	
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <12, 2, -5> }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <14, 2, -8> }

		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <0, 2, -17.8> }
			cylinder { <0, 2 +3.9, -17.8> <9, 2 +3.9, -17.8> .1 }
			cylinder { <0, 2 +8/3, -17.8> <9, 2 +8/3, -17.8> .1 }
			cylinder { <0, 2 +4/3, -17.8> <9, 2 +4/3, -17.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <9, 2, -17.8> }
			cylinder { <9, 2 +3.9, -17.8> <13, 2 +3.9, -15.8> .1 }
			cylinder { <9, 2 +8/3, -17.8> <13, 2 +8/3, -15.8> .1 }
			cylinder { <9, 2 +4/3, -17.8> <13, 2 +4/3, -15.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <13, 2, -15.8> }
			cylinder { <13, 2 +3.9, -15.8> <17, 2 +3.9, -15.8> .1 }
			cylinder { <13, 2 +8/3, -15.8> <17, 2 +8/3, -15.8> .1 }
			cylinder { <13, 2 +4/3, -15.8> <17, 2 +4/3, -15.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <17, 2, -15.8> }
			cylinder { <17, 2 +4, -15.8> <20, -10, -17> .2 }
				sphere { <17, 2 +4, -15.8> .2 }
			cylinder { <19.8, 2 +4, -12.8> <23, -10, -14> .2 }
				sphere { <19.8, 2 +4, -12.8> .2 }
			cylinder { <17, 2 +4, -15.8> <20, -10, -17> .2 translate y*-4 }
			cylinder { <19.8, 2 +4, -12.8> <23, -10, -14> .2 translate y*-4 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <19.8, 2, -12.8> }
			cylinder { <19.8, 2 +3.9, -12.8> <19.8, 2 +3.9, -9.8> .1 }
			cylinder { <19.8, 2 +8/3, -12.8> <19.8, 2 +8/3, -9.8> .1 }
			cylinder { <19.8, 2 +4/3, -12.8> <19.8, 2 +4/3, -9.8> .1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <19.8, 2, -9.8> }
			cylinder { <19.8, 2 +3.9, -9.8> <17, 2 +3.9, -6.8>.1 }
			cylinder { <19.8, 2 +8/3, -9.8> <17, 2 +8/3, -6.8>.1 }
			cylinder { <19.8, 2 +4/3, -9.8> <17, 2 +4/3, -6.8>.1 }
		cylinder { <0, 0, 0> <0, 4, 0> .2 translate <17, 2, -6.8> }
	}
    object { Fence02 }
	object { Fence02 scale <1, 1, -1> }

	
	translate < 133.8, -2, 0 >
}


#declare SStructure04 =
union {
	box { <0, 0, -6> <22, 9, 6> }
	box { <4, 9, -6> <22, 17.5, 6> }
		difference{
		prism { linear_sweep linear_spline 0, 5, 10
			< 23, 0 >, < 23, 6 >, < 22, 19 >, <7, 19>, <0, 6>,
			<0, -6>, <7, -19>, < 22, -19 >, < 23, -6 >, < 23, 0 >
			translate y*9
		}
		prism { linear_sweep linear_spline 0, 5, 10
			< 22.8, 0 >, < 22.8, 5.8 >, < 21.8, 18.8 >, <7.2, 18.8>, <.2, 5.8>,
			<.2, -5.8>, <7.2, -18.8>, < 21.8, -18.8 >, < 22.8, -5.8 >, < 22.8, 0 >
			translate y*11
		}
	}
	difference{
		prism { linear_sweep linear_spline 0, 3.5, 10
			< 23.5, 0 >, < 23.5, 6 >, < 22.5, 13.5 >, <4, 13.5>, <-.5, 6>,
			<-.5, -6>, <4, -13.5>, < 22.5, -13.5 >, < 23.5, -6 >, < 23.5, 0 >
			translate y*17.5
		}
		prism { linear_sweep linear_spline 0, 3.5, 10
			< 23.3, 0 >, < 23.3, 5.8 >, < 22.3, 13.3 >, <4.3, 13.3>, <-.3, 5.8>,
			<-.3, -5.8>, <4.3, -13.3>, < 22.3, -13.3 >, < 23.3, -5.8 >, < 23.3, 0 >
			translate y*18.5
		}
	}
	#declare Structure01 =
	union{
		cylinder { < 4.7, 0, -13 > < 4.7, 9, -13 > .4 }
    	cylinder { < 22.5, 0, -13 > < 22.5, 9, -13 > .4 }
    	cylinder { < 8.5, 0, -13 > < 8.5, 9, -13 > .4 }
    	cylinder { < 20.5, 0, -13 > < 20.5, 9, -13 > .4 }

    	cylinder { < 7.5, 0, -13 > < 7.5, 9, -18.5 > .4 }
    	cylinder { < 21.5, 0, -13 > < 21.5, 9, -18.5 > .4 }

    	cylinder { < 8.5, 0, -13 > < 20.5, 9, -18.5 > .4 }
    	cylinder { < 20.5, 0, -13 > < 8.5, 9, -18.5 > .4 }

		sphere { < 20.5, 0, -13 > .4 }
		sphere { < 8.5, 0, -13 > .4 }
		sphere { < 20.5, 9, -18.5 > .4 }
		sphere { < 8.5, 9, -18.5 > .4 }
	}
	object { Structure01 }
	object { Structure01 scale < 1, 1, -1 > }

	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > translate < 8, 4.5, -5> }
    superellipsoid { < .2, 1 > scale < 7.5, 1.5, .5 > translate < 14.5, 10.5, -19> }
	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > translate < 8, 4.5, 5> }
    superellipsoid { < .2, 1 > scale < 7.5, 1.5, .5 > translate < 14.5, 10.5, 19> }
	
	#declare Bridge_Thk = .25;
	#declare Bridge_Nmb = 4;
	#declare Bridge_Dst = (12 - Bridge_Thk*2)/(Bridge_Nmb +1);
	#declare Bridge01 =
	union{
		#while ( Bridge_Nmb >= 0 )
			box { <0, 0, Bridge_Thk> < 0.3, 3.5, -Bridge_Thk >
				translate <0, 14, (Bridge_Nmb*Bridge_Dst -6)>
			}
			#declare Bridge_Nmb = Bridge_Nmb -1;
		#end
	}
	#declare Bridge_Nmb = 3;
	#declare Bridge02 =
	union{
		#while ( Bridge_Nmb >= 0 )
			box { <0, 0, Bridge_Thk> < 0.3, 3.5, -Bridge_Thk >
				translate <0, 14, (Bridge_Nmb*Bridge_Dst )>
			}
			#declare Bridge_Nmb = Bridge_Nmb -1;
		#end
	}
	object { Bridge01 }
	object { Bridge02 rotate y*( 90- degrees( atan2(13,7))) translate z*6}
	object { Bridge02 rotate y*( 90- degrees( atan2(13,7))) translate z*6 scale <1, 1, -1> }
    
	prism { linear_sweep linear_spline 0, 3.5, 5
		< .2, 6 >, < 3.5, 12.1 >, < 3.5, -12.1 >, <.2, -6>, < .2, 6 >
		texture { T_Chrome_2C }
		translate <0, 14, 0>
	}
	#declare SObj01=
	union{
		cylinder { <0, 0, 0> <0, 3, 0> 2 }
		box { < -4, 3, -4 > < 4, 7, 4 > }
        superellipsoid { < 1.5, .5 > rotate z* 90 scale < 6, 4, 4.2 > translate < 0, 7.5, 0> }
		cylinder { < -3, 7, -4 > < 3, 7, -4 > .7 }
		sphere { < -3, 7, -4 > .7 }
		sphere { < 3, 7, -4 > .7 }
		cylinder { < -3, 7, 4 > < 3, 7, 4 > .7 }
		sphere { < -3, 7, 4 > .7 }
		sphere { < 3, 7, 4 > .7 }
	}
	#declare SObj02=
	union {
		cylinder { <0, 0, -10> <0, 3, -10> 1 }
		cylinder { <-1, 4.5, 0> <1, 4.5, 0> 1.5 scale < 1, 1, .7 > translate z*-10 }
		prism { linear_sweep linear_spline .7, -.7, 5
			< -4.5, .7 >, < 4.5, .7 >, < 2.5, -.7 >, < -2.5, -.7>, < -4.5, .7 >
			rotate x*-90
			translate <0, 4.5, -10>
		}
	}
	union{
		object { SObj01 }
		object { SObj02 }
		object { SObj02 scale < 1, 1, -1 > }

		translate < 12, 18.5, 0 >
	} 
	
	translate < 133.8 -14, 8.5, 0 >
}

#declare SStructure05 =

cylinder { < 0, -2, 0> < 0, 5, 0 > 11

	translate < 133.8 -76, 0, 0 >
}

#declare SStructure06 =
union{
	box { < -61, 0, 9> < 0, 7.5, -9 > }
	intersection {
		superellipsoid { < 1.6, .1 >
			rotate x*90
			scale < 18, 8, 9 >
		}
		box { < -2, 0, 10> < 16, 7.5, -10 > }
	}
	prism { linear_sweep linear_spline 0, 1, 7
			< -61, -11 >, <0, -11>, <8, -5>, <8, 5>, <0, 11>, <-61, 11>, < -61, -11 > 
	translate y*7.5
	}
    difference{
		union{
			prism { linear_sweep linear_spline 0, 1, 6
				< 0, 0 >, <0, 11>, <-22, 3>, <-22, -3>, <0, -11>, <0, 0>
			}
			prism { conic_sweep linear_spline 0, 1, 6
				< 0, 0 >, <0, 10>, <-22, 3>, <-22, -3>, <0, -10>, <0, 0>
				scale < 1, 14, 1>
				translate y*-14
			}
			matrix < 1, -.2, 0,
					0, 1, 0,
					0, 0, 1,
					0, 0, 0 >
		}
        prism { conic_sweep linear_spline 0, 1, 8
			< 5, 0 >, < 5, 11 >, <0, 11>, <-22, 3>, <-22, -3>, <0, -11>, < 5, -11 >, <5, 0>
			scale < 1, 3, 1>
			translate y*-3
			matrix < 1, -.2, 0,
					0, 1, 0,
					0, 0, 1,
					0, 0, 0 >
			translate <-1, 1.5, 0>
		}
		rotate y*180
		translate <0, 7.5, 0>
	}
	union{
		prism { linear_sweep linear_spline 0, 8, 7
			< 0, -7 >, <10, -7>, <14, -4>, <14, 4>, <10, 7>, <0, 7>, < 0, -7 >
		}
		difference {
			union {
				box { < 0, 0, -7 > < 10, 5, 7 > }
				box { < 9, 0, -5 > < 14, 5, 5 > }
				cylinder { < 10, 0, -5 > < 10, 5, -5 > 4 }
				cylinder { < 10, 0, 5 > < 10, 5, 5 > 4 }
			}
			union {
				box { < .2, 1, -6.8 > < 10, 6, 6.8 > }
				box { < 9.99999, 1, -5 > < 13.8, 6, 5 > }
				cylinder { < 10, 1, -5 > < 10, 6, -5 > 3.8 }
				cylinder { < 10, 1, 5 > < 10, 6, 5 > 3.8 }
			}
			translate y*8
		}
		superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > translate < 4.5, 4, -6> } 
	translate < -36, 8.5, 0 >
	}
	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > rotate y*-25 translate < 9, 4.5, -4> }
	superellipsoid { < .4, .2 > scale < 1.75, 3.5, 2 > rotate y*25 translate < 9, 4.5, 4> }

	#declare Fence_Num01 = 6;
	#declare Fence_Int01 = 7;
	#declare Fence03=
	union{
		#while ( Fence_Num01 > 0 )
			object { Fence_Elm ( -Fence_Num01*Fence_Int01, -10.8,
				-(Fence_Num01-1)*Fence_Int01, -10.8 )
			}
			#declare Fence_Num01 = Fence_Num01 -1;
		#end
		cylinder { < 0, 0, -10.8 > <0, 4, -10.8 > .2 }
		translate y*8.5
	}
	object { Fence03 }
	object { Fence03 scale <1, 1, -1> }

	#declare Crane01=
	union {
		cylinder { <0, 1, -1> <0, 1, 1> 1 }
		box { < -1, 1, -.7> <1, 0, .7> }
        cylinder { <0, 1, -1.5> <0, 1, 1.5> .5 }
        sphere { <0, 1, -1.5> .5 }
		sphere { <0, 1, 1.5> .5 }

        cylinder { <-14, 20, 0> <0, 1, 1.5> .3 }
        cylinder { <-14, 20, 0> <0, 1, -1.5> .3 }
		cylinder { <-14, 20, .5> <-14, 20, -.5> .5 }
        cone { <-14, 20, 0>.3 <-14, 10, 0> .2 }
        sphere { <-14, 10, 0> .2 }
		cylinder { <-14, 10, 0> <-11.5, 5, -2.5> .15 }
		cylinder { <-14, 10, 0> <-11.5, 5, 2.5> .15 }
		cylinder { <-14, 10, 0> <-16.5, 5, -2.5> .15 }
		cylinder { <-14, 10, 0> <-16.5, 5, 2.5> .15 }

		cylinder { <20, 1, -1> <20, 1, 1> 1 }
		box { < 19, 1, -.7> <21, 0, .7> }
		cylinder { <-14, 20, 0> <20, 2, 0> .2 }
		cylinder { <-14, 20, 0> <5, 10, 5> .2 }
	}
	object { Crane01 translate < -38, 8.5, -9> }
	object { Crane01 scale <1, 1, -1> translate < -38, 8.5, 9> }

	#declare Mount01=
	union{
		cylinder { < .5, 0, -16 > < .5, 8, -16 > .5 }
		cylinder { < .5, 8, -11 > < .5, 8, -16 > .5 }
		sphere { < .5, 8, -16 > .5 }
		cylinder { < 14.5, 0, -16 > < 14.5, 8, -16 > .5 }
		cylinder { < 14.5, 8, -11 > < 14.5, 8, -16 > .5 }
		sphere { < 14.5, 8, -16 > .5 }
		box { < 0, 6, -14> < 15, 10, -9 > }
	}
	object { Mount01 translate <-61, 0, 0 > }
	object { Mount01 scale <1, 1, -1> translate <-61, 0, 0 > }

	object { Boat01 scale .8 translate <-61+7, 15, -10 > }
	object { Boat01 scale .8 translate <-61+7, 15, 10 > } 
	translate < 133.8 + 147, -10, 0 >
}

#declare Mast01 =
union{
	cylinder { < -7, 0, 0 > < -2, 42, 0 > .75 }
	cylinder { < -7, 0, 0 > < -2, 42, 0 > .75 rotate y*120 }
	cylinder { < -7, 0, 0 > < -2, 42, 0 > .75 rotate y*-120 }

	cylinder { < -7, 0, 0 > < -8, -12, 0 > .75 rotate y*120 }
	cylinder { < -7, 0, 0 > < -8, -12, 0 > .75 rotate y*-120 }

	cylinder { < -5*30/42-2, 12, 0 > vrotate ( < -5*30/42-2, 12, 0 > <0, 120, 0> ) .5 }
    cylinder { < -5*30/42-2, 12, 0 > vrotate ( < -5*30/42-2, 12, 0 > <0, -120, 0> ) .5 }
	cylinder { vrotate ( < -5*30/42-2, 12, 0 > <0, 120, 0> )
		vrotate ( < -5*30/42-2, 12, 0 > <0, -120, 0> ) .5
	}
	cylinder { <0, 28, 0 > < 0, 27.3, 0 > 5*14/42+2 }
	torus { 5*14/42+2-.2 .1 translate y*29.5 }
	torus { 5*14/42+2-.2 .1 translate y*31 }
	#declare Count01 = 6;
	#declare Angle01 = 360 / 7;
	#while ( Count01 >= 0 )
		cylinder { <5*14/42+2-.2, 28, 0 > < 5*14/42+2-.2, 31, 0 > .1
			rotate y*Count01*Angle01
		}
		#declare Count01 = Count01 -1;
	#end

	cylinder { <0, 42.5, 0 > < 0, 41.5, 0 > 5 }
	torus { 5-.2 .1 translate y*44 }
	torus { 5-.2 .1 translate y*45.5 }
	#declare Count01 = 11;
	#declare Angle01 = 360 / 12;
	#while ( Count01 >= 0 )
		cylinder { <5-.2, 42.5, 0 > < 5-.2, 45.5, 0 > .1
			rotate y*Count01*Angle01
		}
		#declare Count01 = Count01 -1;
	#end
	cylinder { < -10, 42, 0 > < 10, 42, 0 > .3 }
	cylinder { < 0, 42, -10 > < 0, 42, 10 > .3 }

	cylinder { < 0, 42, -10 > < 0, 28, -5*14/42-2 > .1 }
	cylinder { < 0, 42, 10 > < 0, 28, 5*14/42+2 > .1 }

	union{
		cone { <0, 0, 0>.5 <0, 46, 0 >.3 }
		cylinder { < 0, 31, -15 > < 0, 31, 15 > .3 }
		sphere { < 0, 31, -15 > .3 }
		sphere { < 0, 31, 15 > .3 }

		cylinder { < 0, 0, -.5 > < 0, 31, -15 > .1 }
		cylinder { < 0, 0, -.5 > < 0, 31, -7.5 > .1 }
        cylinder { < 0, 0, .5 > < 0, 31, 15 > .1 }
        cylinder { < 0, 0, .5 > < 0, 31, 7.5 > .1 }
		cylinder { < 0, 7.5 +31, 0 > < 0, 31, -15 > .1 }
		cylinder { < 0, 7.5 +31, 0 > < 0, 31, -7.5 > .1 }
		cylinder { < 0, 7.5 +31, 0 > < 0, 31, 15 > .1 }
		cylinder { < 0, 7.5 +31, 0 > < 0, 31, 7.5 > .1 }

		cylinder { < 0, 0, -10 > < 0, 31*2/3, 0 > .1 }
		cylinder { < 0, 0, -10 > < 0, 31*1/3, 0 > .1 }
		cylinder { < 0, 0, 10 > < 0, 31*2/3, 0 > .1 }
		cylinder { < 0, 0, 10 > < 0, 31*1/3, 0 > .1 }

		rotate z*-5
		translate y*42
	}
	
	translate < 148, 0, 0 >
}

#declare Mast02=
union{
    box { < 0, 0, -3 > < 5, 15, 3 > }
	superellipsoid { < .2, .1 >  rotate x*90 scale <3, 4.5, 3.5> translate < 5.5, 19, 0> }
    union{
		cylinder { <0, 23.5, 0 > < 0, 24.5, 0 > 6 }
		torus { 6-.2 .1 translate y*26 }
		torus { 6-.2 .1 translate y*27.5 }
    	#declare Count01 = 11;
		#declare Angle01 = 360 / 12;
		#while ( Count01 >= 0 )
			cylinder { <6-.2, 23.5, 0 > < 6-.2, 27.5, 0 > .1
				rotate y*Count01*Angle01
			}
			#declare Count01 = Count01 -1;
		#end
		cylinder { <0, 24, 0 > < 10, 24, 0 > .3 }
		cylinder { <0, 24, -10 > < 0, 24, 10 > .3 }
		translate < 5, 0, 0>
	}
	union{
		cylinder { < 0, -2, -6.5> <0, 24, -.5 > .6 }
		cylinder { < 0, -2, 6.5> <0, 24, .5 > .6 }
        sphere { <0, 24, -.5 > .6 }
		sphere { <0, 24, .5 > .6 }

        union{
			cone { <0, 0, 0>.5 <0, 43, 0 >.3 }
			cylinder { < 0, 35, -12 > < 0, 35, 12 > .3 }
			sphere { < 0, 35, -12 > .3 }
			sphere { < 0, 35, 12 > .3 }

			cylinder { < 0, 35, 12> <0, (43-35)/2+35, 0 > .1 }
			cylinder { < 0, 35, -12> <0, (43-35)/2+35, 0 > .1 }

			cylinder { < 0, 35*1/3, 0> <0, 35, 12 > .1 }
            cylinder { < 0, 35*1/3, 0> <0, 35, -12 > .1 }

			translate < 0, 24, 0 >
		}
        
		rotate z*-5
		translate < -2, 0, 0>
	}
	translate < 204, -10, 0 >
}

#declare Funnel01=
union{
	union{
		lathe { linear_spline 5
			< 4.5, -5 >, < 5, -5>, < 5, 30 >, < 4.5, 30 >, < 4.5, -5 >
		}
		torus { 4.75, .25 translate y*30 }
        cylinder { <-5.5, -10, 0 > < -5.5, 32, 0 > .5 }
		cylinder { <-5.5, 32, 0 > < -5.5, 33, 0 > .7 }
		#declare Count01 = 5;
		#while ( Count01 >= 0 )
			torus { 5, .2 translate y*30/6*Count01 }
			#declare Count01 = Count01 -1;
		#end
		rotate z*-5
		translate y*5
	}
	superellipsoid { < .2, 1.5 >  rotate x*90 scale <10, 7.5, 6.5> translate < 0, 0, 0> }
	superellipsoid { < .2, .1 >  rotate x*90 scale <10, 7, 6.5> translate < 0, -6.5, 0> }
	
	translate < 160, -8.5, 0 >
}

#declare Boat01a=
union{
	object { Mount02 translate < 10, 0, 0 > }
	object { Mount02a translate < 23, 0, 0 > }
	object { Boat01 scale .7 translate < 15, 15, -5 > }

	translate < 133.8, -10, -16 >
}

#declare DAnchor01=
union{
	torus { 1.5, .3 }
	union{
		sphere { 0, 1 }
		cylinder { < 0, 0, -2 > < 0, 0, 2 > .4 }
		sphere { < 0, 0, -2 > .6 }
		sphere { < 0, 0, 2 > .6 }
		cylinder { < 0, 0, -2 > < 2, 0, -2 > .4 }
		cylinder { < 0, 0, 2 > < 2, 0, 2 > .4 }
		sphere { 0, 1 scale < 1.5, .4, .75 > translate  < 2.5, 0, -2 > }
		sphere { 0, 1 scale < 1.5, .4, .75 > translate  < 2.5, 0, 2 > }
		rotate z*10
		rotate y*-30
		translate y*.5
	}
	rotate x*-93
}

// Main object is assembled in the following macro with guns elevations and turret rotations
// as parameters. See example after the macro.
// GEA01 = Gun Elevation Angle 01; TRA01 = Turret Rotation Angle 01

#macro Destroyer01 ( GEA01, TRA01, GEA02, TRA02, GEA03, TRA03, GEA04, TRA04 ) 

union {    
	union{
		object { DHull01 translate x*-1.86 }
		object { DHull01 translate x*-1.86 scale <1, 1, -1> }

		texture { D_TEX
			pigment{
				gradient y
				color_map {
					[ 0 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <57, 57, 47>/255 ]
					[ .01 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <121, 140, 150>/255 ]
					[ .5 color rgb <108, 79, 63>/255 ]
					[ .91 color rgb <108, 79, 63>/255 ]
					[ .95 color rgb <57, 57, 47>/255 ]
					[ 1 color rgb <57, 57, 47>/255 ]
				}
				translate y*-50
				scale 50
			}
		}
	}

	object { DAnchor01 translate < 14, 16.5, -7 > }
	object { DAnchor01 translate < 14, 16.5, -7 > scale <1, 1, -1> }
    
	union{
		object { DHull_Fence01 translate x*-1.86 }
		object { DHull_Fence01 translate x*-1.86 scale <1, 1, -1> }
	}

	union{
		object { SStructure01 }
		object { SStructure02 }
		object { SStructure03 }
    	object { SStructure04 }
		object { SStructure05 }
		object { SStructure06 }
		object { Mast01 }
		object { Mast02 }
		object { Funnel01 }
		union{
			object { Funnel01 }
			cylinder { <0, 0, 0> <0, 1, 0> 7 translate < 160, -1, 0 > }
			box { < -13, -10, -5 > < 0, -3, 5 > translate < 160, 0, 0 >}
			translate < 37, -3, 0 > 
		}

    	union{
			object { Boat03a }
			cylinder { <0, 0, 0> <0, -12 0 > 3 }
			translate < 133.8+45, 0, 0 >
		}

		union{
			object { Boat03b }
			cylinder { <0, 0, 0> <0, -6 0 > 3 }
			translate < 133.8+76, -5, -12 >
		}

		union{
			object { Boat03b }
			cylinder { <0, 0, 0> <0, -6 0 > 3 }
			translate < 133.8+76, -5, 12 >
		}
	
		object { Boat02 translate < 133.8+15.5, -5, -17 > }
		object { Boat02 translate < 133.8+15.5, -5, -17 > scale <1, 1, -1> }

		object { Boat01a }
		object { Boat01a scale <1, 1, -1> }

		object { DTurret ( GEA01, TRA01 ) translate < 133.8 -76, 5, 0 > }
		object { DTurret ( GEA02, TRA02 ) translate < 133.8 -40, 12.5, 0 > }
    	object { DTurret ( GEA03, TRA03 ) rotate y*180 translate < 133.8 +144, -1.5, 0 > }
		object { DTurret ( GEA03, TRA03 ) rotate y*180 translate < 133.8 +175, -10, 0 > }
		
		translate y*17
	}
	texture { D_TEX }
    translate < 0, 1, 0>
}

#end

// Example:
// object { Destroyer01 ( 10, -30, 12, -29, 10, 43, 15, 32 ) scale 1*Feet } 