//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 1 lights, 36 textures and 193 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  Moray V3.01 For Windows (c) 1991-1998 Lutz + Kretzschmar
//

//  Date : 12/13/1998    (13.12.1998)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-0.306, -26.409, 30.133>
  direction <0.0,     0.0,  1.8317>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <0.005, 0.399, 0.355>
}

//
// *******  L I G H T S *******
//

light_source {   // CameraLight
  <0.000, -25.968, 28.953>
  color rgb <0.100, 0.100, 0.100>
}

light_source {   // LampLight
  <0.565, 6.496, 7.270>
  color rgb <1.000, 1.000, 0.750>
}


//
// ********  TEXTURES  *******
//

#include "surveillance.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare bUMP1 = object {
  sphere { // bUMP1
    <0,0,0>,1
    scale 0.03
    translate  <-1.082803, -0.108328, 0.193364>
  }
}
#declare SpoolDone = union {
  cylinder { // Spool1
    <0,0,1>, <0,0,0>, 1 
    texture {
      White_Plaster
    }
    scale <0.2, 0.2, 0.41>
    translate  <-1.0, 0.0, -0.2>
  }
  object { bUMP1 }
  object { // bUMP2->bUMP1
    bUMP1
    rotate -0.0*z
    translate  <0.064968, 0.252654, -0.0>
  }
  object { // bUMP3->bUMP1
    bUMP1
    rotate -0.0*z
    translate  <-0.043312, 0.144374, -0.0>
  }
  object { // bUMP4->bUMP1
    bUMP1
    rotate -0.0*z
    translate  <0.144374, -0.014437, -0.0>
  }
  texture {
    White_Plaster
  }
}
#declare SpoolCutUp = difference {
  object { SpoolDone }
  cylinder { // SpoolCut
    <0,0,1>, <0,0,0>, 1 
    texture {
      White_Plaster
    }
    scale <0.1, 0.1, 0.45>
    translate  <-1.0, 0.0, -0.22>
  }
}


#declare Link1 = object {
  superellipsoid { // Link1
    <0.1, 0.1>
    scale <2.0, 2.0, 0.75>
    rotate -10.0*x
  }
}
#declare Link73 = object {
  superellipsoid { // Link73
    <0.1, 0.1>
    scale <2.0, 2.0, 0.75>
    translate  <0.0, -0.381115, -1.9818>
  }
}
#declare LeftDown = union {
  object { Link73 }
  object { // Link74->Link73
    Link73
    translate  -2.0*z
  }
  object { // Link75->Link73
    Link73
    translate  -4.0*z
  }
  object { // Link76->Link73
    Link73
    translate  -6.0*z
  }
  object { // Link77->Link73
    Link73
    translate  -8.0*z
  }
  object { // Link78->Link73
    Link73
    translate  -10.0*z
  }
  object { // Link79->Link73
    Link73
    translate  -12.0*z
  }
  object { // Link80->Link73
    Link73
    translate  -14.0*z
  }
  object { // Link81->Link73
    Link73
    translate  -16.0*z
  }
  object { // Link82->Link73
    Link73
    translate  -18.0*z
  }
  object { // Link83->Link73
    Link73
    translate  -20.0*z
  }
  object { // Link84->Link73
    Link73
    translate  -22.0*z
  }
  object { // Link85->Link73
    Link73
    translate  -24.0*z
  }
  object { // Link86->Link73
    Link73
    translate  -26.0*z
  }
  object { // Link87->Link73
    Link73
    translate  -28.0*z
  }
  rotate -10.0*x
}
#declare ChainLeft = union {
  object { Link1 }
  object { // Link2->Link1
    Link1
    rotate -0.0*x
    translate  <0.086824, 0.492404, 2.0>
  }
  object { // Link3->Link1
    Link1
    rotate -0.0*x
    translate  <0.257834, 0.96225, 4.0>
  }
  object { // Link4->Link1
    Link1
    rotate -0.0*x
    translate  <0.507834, 1.395263, 6.0>
  }
  object { // Link5->Link1
    Link1
    rotate -0.0*x
    translate  <0.829228, 1.778285, 8.0>
  }
  object { // Link6->Link1
    Link1
    rotate -0.0*x
    translate  <1.21225, 2.099679, 10.0>
  }
  object { // Link7->Link1
    Link1
    rotate -0.0*x
    translate  <1.645263, 2.349679, 12.0>
  }
  object { // Link8->Link1
    Link1
    rotate -0.0*x
    translate  <2.115109, 2.520689, 14.0>
  }
  object { // Link9->Link1
    Link1
    rotate -0.0*x
    translate  <2.607513, 2.607513, 16.0>
  }
  object { // Link10->Link1
    Link1
    rotate -0.0*x
    translate  <3.107513, 2.607513, 18.0>
  }
  object { // Link11->Link1
    Link1
    rotate -0.0*x
    translate  <3.599917, 2.520689, 20.0>
  }
  object { // Link12->Link1
    Link1
    rotate -0.0*x
    translate  <4.069763, 2.349679, 22.0>
  }
  object { // Link13->Link1
    Link1
    rotate -0.0*x
    translate  <4.502776, 2.099679, 24.0>
  }
  object { // Link14->Link1
    Link1
    rotate -0.0*x
    translate  <4.885798, 1.778285, 26.0>
  }
  object { // Link15->Link1
    Link1
    rotate -0.0*x
    translate  <5.207192, 1.395263, 28.0>
  }
  object { // Link16->Link1
    Link1
    rotate -0.0*x
    translate  <5.457192, 0.96225, 30.0>
  }
  object { // Link17->Link1
    Link1
    rotate -0.0*x
    translate  <5.628202, 0.492404, 32.0>
  }
  object { // Link18->Link1
    Link1
    rotate -0.0*x
    translate  <5.715026, -0.0, 34.0>
  }
  object { // Link19->Link1
    Link1
    rotate -0.0*x
    translate  <5.715026, -0.5, 36.0>
  }
  object { // Link20->Link1
    Link1
    rotate -0.0*x
    translate  <5.628202, -0.992404, 38.0>
  }
  object { // Link21->Link1
    Link1
    rotate -0.0*x
    translate  <5.457192, -1.46225, 40.0>
  }
  object { // Link22->Link1
    Link1
    rotate -0.0*x
    translate  <5.207192, -1.895263, 42.0>
  }
  object { // Link23->Link1
    Link1
    rotate -0.0*x
    translate  <4.885798, -2.278285, 44.0>
  }
  object { // Link24->Link1
    Link1
    rotate -0.0*x
    translate  <4.502776, -2.599679, 46.0>
  }
  object { // Link25->Link1
    Link1
    rotate -0.0*x
    translate  <4.069763, -2.849679, 48.0>
  }
  object { // Link26->Link1
    Link1
    rotate -0.0*x
    translate  <3.599917, -3.020689, 50.0>
  }
  object { // Link27->Link1
    Link1
    rotate -0.0*x
    translate  <3.107513, -3.107513, 52.0>
  }
  object { // Link28->Link1
    Link1
    rotate -0.0*x
    translate  <2.607513, -3.107513, 54.0>
  }
  object { // Link29->Link1
    Link1
    rotate -0.0*x
    translate  <2.115109, -3.020689, 56.0>
  }
  object { // Link30->Link1
    Link1
    rotate -0.0*x
    translate  <1.645263, -2.849679, 58.0>
  }
  object { // Link31->Link1
    Link1
    rotate -0.0*x
    translate  <1.21225, -2.599679, 60.0>
  }
  object { // Link32->Link1
    Link1
    rotate -0.0*x
    translate  <0.829228, -2.278285, 62.0>
  }
  object { // Link33->Link1
    Link1
    rotate -0.0*x
    translate  <0.507834, -1.895263, 64.0>
  }
  object { // Link34->Link1
    Link1
    rotate -0.0*x
    translate  <0.257834, -1.46225, 66.0>
  }
  object { // Link35->Link1
    Link1
    rotate -0.0*x
    translate  <0.086824, -0.992404, 68.0>
  }
  object { // Link36->Link1
    Link1
    rotate -0.0*x
    translate  <-0.0, -0.5, 70.0>
  }
  object { // Link37->Link1
    Link1
    rotate -0.0*x
    translate  <0.0, 0.0, 72.0>
  }
  object { // Link38->Link1
    Link1
    rotate -0.0*x
    translate  <0.086824, 0.492404, 74.0>
  }
  object { // Link39->Link1
    Link1
    rotate -0.0*x
    translate  <0.257834, 0.96225, 76.0>
  }
  object { // Link40->Link1
    Link1
    rotate -0.0*x
    translate  <0.507834, 1.395263, 78.0>
  }
  object { // Link41->Link1
    Link1
    rotate -0.0*x
    translate  <0.829228, 1.778285, 80.0>
  }
  object { // Link42->Link1
    Link1
    rotate -0.0*x
    translate  <1.21225, 2.099679, 82.0>
  }
  object { // Link43->Link1
    Link1
    rotate -0.0*x
    translate  <1.645263, 2.349679, 84.0>
  }
  object { // Link44->Link1
    Link1
    rotate -0.0*x
    translate  <2.115109, 2.520689, 86.0>
  }
  object { // Link45->Link1
    Link1
    rotate -0.0*x
    translate  <2.607513, 2.607513, 88.0>
  }
  object { // Link46->Link1
    Link1
    rotate -0.0*x
    translate  <3.107513, 2.607513, 90.0>
  }
  object { // Link47->Link1
    Link1
    rotate -0.0*x
    translate  <3.599917, 2.520689, 92.0>
  }
  object { // Link48->Link1
    Link1
    rotate -0.0*x
    translate  <4.069763, 2.349679, 94.0>
  }
  object { // Link49->Link1
    Link1
    rotate -0.0*x
    translate  <4.502776, 2.099679, 96.0>
  }
  object { // Link50->Link1
    Link1
    rotate -0.0*x
    translate  <4.885798, 1.778285, 98.0>
  }
  object { // Link51->Link1
    Link1
    rotate -0.0*x
    translate  <5.207192, 1.395263, 100.0>
  }
  object { // Link52->Link1
    Link1
    rotate -0.0*x
    translate  <5.457192, 0.96225, 102.0>
  }
  object { // Link53->Link1
    Link1
    rotate -0.0*x
    translate  <5.628202, 0.492404, 104.0>
  }
  object { // Link54->Link1
    Link1
    rotate -0.0*x
    translate  <5.715026, -0.0, 106.0>
  }
  object { // Link55->Link1
    Link1
    rotate -0.0*x
    translate  <5.715026, -0.5, 108.0>
  }
  object { // Link56->Link1
    Link1
    rotate -0.0*x
    translate  <5.628202, -0.992404, 110.0>
  }
  object { // Link57->Link1
    Link1
    rotate -0.0*x
    translate  <5.457192, -1.46225, 112.0>
  }
  object { // Link58->Link1
    Link1
    rotate -0.0*x
    translate  <5.207192, -1.895263, 114.0>
  }
  object { // Link59->Link1
    Link1
    rotate -0.0*x
    translate  <4.885798, -2.278285, 116.0>
  }
  object { // Link60->Link1
    Link1
    rotate -0.0*x
    translate  <4.502776, -2.599679, 118.0>
  }
  object { // Link61->Link1
    Link1
    rotate -0.0*x
    translate  <4.069763, -2.849679, 120.0>
  }
  object { // Link62->Link1
    Link1
    rotate -0.0*x
    translate  <3.599917, -3.020689, 122.0>
  }
  object { // Link63->Link1
    Link1
    rotate -0.0*x
    translate  <3.107513, -3.107513, 124.0>
  }
  object { // Link64->Link1
    Link1
    rotate -0.0*x
    translate  <2.607513, -3.107513, 126.0>
  }
  object { // Link65->Link1
    Link1
    rotate -0.0*x
    translate  <2.115109, -3.020689, 128.0>
  }
  object { // Link66->Link1
    Link1
    rotate -0.0*x
    translate  <1.645263, -2.849679, 130.0>
  }
  object { // Link67->Link1
    Link1
    rotate -0.0*x
    translate  <1.21225, -2.599679, 132.0>
  }
  object { // Link68->Link1
    Link1
    rotate -0.0*x
    translate  <0.829228, -2.278285, 134.0>
  }
  object { // Link69->Link1
    Link1
    rotate -0.0*x
    translate  <0.507834, -1.895263, 136.0>
  }
  object { // Link70->Link1
    Link1
    rotate -0.0*x
    translate  <0.257834, -1.46225, 138.0>
  }
  object { // Link71->Link1
    Link1
    rotate -0.0*x
    translate  <0.086824, -0.992404, 140.0>
  }
  object { // Link72->Link1
    Link1
    rotate -0.0*x
    translate  <-0.0, -0.5, 142.0>
  }
  object { LeftDown }
}




//
// ********  OBJECTS  *******
//

difference { // MugCut
  cylinder { // OuterMug
    <0,0,1>, <0,0,0>, 1 
    texture {
      PhotoMug
      scale <1.75, 1.1, 0.8>
      rotate <90.0, 0.0, -18.541384>
      translate <-0.901278, -0.065041, 0.000000>
    }
    scale <2.35, 2.35, 5.5>
    translate  <10.10102, 11.844976, 1.188>
  }
  cylinder { // InnerMug
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_White
      scale <1.75, 1.1, 0.8>
      rotate <90.0, 0.0, -18.541384>
      translate <-0.901278, -0.065041, 0.000000>
    }
    scale <2.175, 2.175, 5.75>
    translate  <10.10102, 11.844976, 1.188>
  }
}


torus { // MugLip
  1.925, 0.075  rotate -x*90
  texture {
    Shiny_White
  }
  scale <1.175, 1.175, 1.0>
  translate  <10.104425, 11.83711, 6.694186>
}


union { // Pen
  cylinder { // PenBody
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.25, 0.25, 3.7>
    rotate 89.955864*y
  }
  cylinder { // PenBodyBtm
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.25, 0.25, 0.2>
    rotate 89.955864*y
    translate  -0.206999*x
  }
  cylinder { // PenCapBtm
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.3, 0.3, 0.15>
    rotate 89.955864*y
    translate  3.657245*x
  }
  torus { // PenCapBtmTip
    1.9, 0.1  rotate -x*90
    texture {
      Shiny_Gold1
    }
    scale 0.15
    rotate -90.0*y
    translate  3.65703*x
  }
  cylinder { // PenCap
    <0,0,1>, <0,0,0>, 1 
    texture {
      Aluminum
    }
    scale <0.3, 0.3, 1.2>
    rotate 89.955864*y
    translate  3.814714*x
  }
  cylinder { // PenCapTop
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Gold1
    }
    scale <0.3, 0.3, 0.15>
    rotate 89.955864*y
    translate  5.020509*x
  }
  cone { // PenClip
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Shiny_Gold1
    }
    scale <0.025, 0.1, 1.35>
    rotate <180.0, 88.670212, 180.0>
    translate  <3.805983, 0.0, 0.352321>
  }
  sphere { // ClipEnd
    <0,0,0>,1
    texture {
      Shiny_Gold1
    }
    scale 0.05
    translate  <3.815651, 0.0, 0.352604>
  }
  rotate <118.0, 0.0, -30.0>
  translate  <7.872283, -3.662455, 1.61>
}


box { // FamilyPhoto6
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PhotoAlienShip2
    scale <1.995896, 1.99884, 1.0>
    translate <-0.995896, -0.998840, -0.456545>
  }
  scale <3.783599, 2.270159, 0.01>
  rotate <-0.0, -0.0, -36.289082>
  translate  <-6.493066, -7.648599, 1.15851>
}


box { // FamilyPhoto5
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PhotoSleep
    scale <1.995896, 1.99884, 1.0>
    translate <-0.995896, -0.998840, -0.456545>
  }
  scale <2.5, 1.5, 0.025>
  rotate <0.0, -0.0, 11.074175>
  translate  <5.162616, -8.515916, 1.15851>
}


box { // FamilyPhoto4
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PhotoCouch
    scale <1.995896, 1.99884, 1.0>
    translate <-0.995896, -0.998840, -0.456545>
  }
  scale <2.5, 1.5, 0.025>
  rotate <0.0, -0.0, 2.629167>
  translate  <10.269233, -6.775024, 1.15851>
}


union { // Alien_Photo3
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>, 
      <-1.536950, 0.735356, -0.047225>, <-1.536950, 0.646120, -0.033755>, <-1.536950, 0.528253, -0.009136>, <-1.536950, 0.439495, 0.007188>, 
      <-1.636950, 0.735356, -0.047225>, <-1.636950, 0.646120, -0.033755>, <-1.636950, 0.528253, -0.009136>, <-1.636950, 0.439495, 0.007188>, 
      <-1.711950, 0.735356, -0.047225>, <-1.711950, 0.646120, -0.033755>, <-1.711950, 0.528253, -0.009136>, <-1.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.040285, -0.083501>, <-1.461950, 0.948161, -0.083501>, <-1.461950, 0.826448, -0.060976>, <-1.461950, 0.735356, -0.047225>, 
      <-1.536950, 1.040285, -0.083501>, <-1.536950, 0.948161, -0.083501>, <-1.536950, 0.826448, -0.060976>, <-1.536950, 0.735356, -0.047225>, 
      <-1.636950, 1.040285, -0.083501>, <-1.636950, 0.948161, -0.083501>, <-1.636950, 0.826448, -0.060976>, <-1.636950, 0.735356, -0.047225>, 
      <-1.711950, 1.040285, -0.083501>, <-1.711950, 0.948161, -0.083501>, <-1.711950, 0.826448, -0.060976>, <-1.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.461950, 1.254064, -0.060582>, <-1.461950, 1.132409, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.536950, 1.345215, -0.047225>, <-1.536950, 1.254064, -0.060582>, <-1.536950, 1.132409, -0.083501>, <-1.536950, 1.040285, -0.083501>, 
      <-1.636950, 1.345215, -0.047225>, <-1.636950, 1.254064, -0.060582>, <-1.636950, 1.132409, -0.083501>, <-1.636950, 1.040285, -0.083501>, 
      <-1.711950, 1.345215, -0.047225>, <-1.711950, 1.254064, -0.060582>, <-1.711950, 1.132409, -0.083501>, <-1.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.536950, 1.345215, -0.047225>, <-1.636950, 1.345215, -0.047225>, <-1.711950, 1.345215, -0.047225>, 
      <-1.461950, 1.439808, -0.033365>, <-1.536950, 1.439808, -0.033365>, <-1.636950, 1.439808, -0.033365>, <-1.711950, 1.439808, -0.033365>, 
      <-1.461950, 1.565014, -0.009136>, <-1.536950, 1.565014, -0.009136>, <-1.636950, 1.565014, -0.009136>, <-1.711950, 1.565014, -0.009136>, 
      <-1.461950, 1.659213, 0.007188>, <-1.536950, 1.659213, 0.007188>, <-1.636950, 1.659213, 0.007188>, <-1.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>, 
      <-1.211950, 1.439808, -0.033365>, <-1.286950, 1.439808, -0.033365>, <-1.386950, 1.439808, -0.033365>, <-1.461950, 1.439808, -0.033365>, 
      <-1.211950, 1.565014, -0.009136>, <-1.286950, 1.565014, -0.009136>, <-1.386950, 1.565014, -0.009136>, <-1.461950, 1.565014, -0.009136>, 
      <-1.211950, 1.659213, 0.007188>, <-1.286950, 1.659213, 0.007188>, <-1.386950, 1.659213, 0.007188>, <-1.461950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.211950, 1.132409, -0.083501>, <-1.286950, 1.132409, -0.083501>, <-1.386950, 1.132409, -0.083501>, <-1.461950, 1.132409, -0.083501>, 
      <-1.211950, 1.254064, -0.060582>, <-1.286950, 1.254064, -0.060582>, <-1.386950, 1.254064, -0.060582>, <-1.461950, 1.254064, -0.060582>, 
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>, 
      <-1.286950, 0.735356, -0.047225>, <-1.286950, 0.646120, -0.033755>, <-1.286950, 0.528253, -0.009136>, <-1.286950, 0.439495, 0.007188>, 
      <-1.386950, 0.735356, -0.047225>, <-1.386950, 0.646120, -0.033755>, <-1.386950, 0.528253, -0.009136>, <-1.386950, 0.439495, 0.007188>, 
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.286950, 0.735356, -0.047225>, <-1.386950, 0.735356, -0.047225>, <-1.461950, 0.735356, -0.047225>, 
      <-1.211950, 0.826448, -0.060976>, <-1.286950, 0.826448, -0.060976>, <-1.386950, 0.826448, -0.060976>, <-1.461950, 0.826448, -0.060976>, 
      <-1.211950, 0.948161, -0.083501>, <-1.286950, 0.948161, -0.083501>, <-1.386950, 0.948161, -0.083501>, <-1.461950, 0.948161, -0.083501>, 
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.961950, 0.646120, -0.033755>, <-0.961950, 0.528253, -0.009136>, <-0.961950, 0.439495, 0.007188>, 
      <-1.036950, 0.735356, -0.047225>, <-1.036950, 0.646120, -0.033755>, <-1.036950, 0.528253, -0.009136>, <-1.036950, 0.439495, 0.007188>, 
      <-1.136950, 0.735356, -0.047225>, <-1.136950, 0.646120, -0.033755>, <-1.136950, 0.528253, -0.009136>, <-1.136950, 0.439495, 0.007188>, 
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>, 
      <-0.961950, 0.646120, -0.033755>, <-0.886950, 0.646120, -0.033755>, <-0.786950, 0.646120, -0.033755>, <-0.711950, 0.646120, -0.033755>, 
      <-0.961950, 0.528253, -0.009136>, <-0.886950, 0.528253, -0.009136>, <-0.786950, 0.528253, -0.009136>, <-0.711950, 0.528253, -0.009136>, 
      <-0.961950, 0.439495, 0.007188>, <-0.886950, 0.439495, 0.007188>, <-0.786950, 0.439495, 0.007188>, <-0.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>, 
      <-0.961950, 0.948161, -0.083501>, <-0.886950, 0.948161, -0.083501>, <-0.786950, 0.948161, -0.083501>, <-0.711950, 0.948161, -0.083501>, 
      <-0.961950, 0.826448, -0.060976>, <-0.886950, 0.826448, -0.060976>, <-0.786950, 0.826448, -0.060976>, <-0.711950, 0.826448, -0.060976>, 
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.961950, 0.948161, -0.083501>, <-0.961950, 0.826448, -0.060976>, <-0.961950, 0.735356, -0.047225>, 
      <-1.036950, 1.040285, -0.083501>, <-1.036950, 0.948161, -0.083501>, <-1.036950, 0.826448, -0.060976>, <-1.036950, 0.735356, -0.047225>, 
      <-1.136950, 1.040285, -0.083501>, <-1.136950, 0.948161, -0.083501>, <-1.136950, 0.826448, -0.060976>, <-1.136950, 0.735356, -0.047225>, 
      <-1.211950, 1.040285, -0.083501>, <-1.211950, 0.948161, -0.083501>, <-1.211950, 0.826448, -0.060976>, <-1.211950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.439808, -0.033365>, <-0.961950, 1.565014, -0.009136>, <-0.961950, 1.659213, 0.007188>, 
      <-0.886950, 1.345215, -0.047225>, <-0.886950, 1.439808, -0.033365>, <-0.886950, 1.565014, -0.009136>, <-0.886950, 1.659213, 0.007188>, 
      <-0.786950, 1.345215, -0.047225>, <-0.786950, 1.439808, -0.033365>, <-0.786950, 1.565014, -0.009136>, <-0.786950, 1.659213, 0.007188>, 
      <-0.711950, 1.345215, -0.047225>, <-0.711950, 1.439808, -0.033365>, <-0.711950, 1.565014, -0.009136>, <-0.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-1.036950, 1.345215, -0.047225>, <-1.136950, 1.345215, -0.047225>, <-1.211950, 1.345215, -0.047225>, 
      <-0.961950, 1.439808, -0.033365>, <-1.036950, 1.439808, -0.033365>, <-1.136950, 1.439808, -0.033365>, <-1.211950, 1.439808, -0.033365>, 
      <-0.961950, 1.565014, -0.009136>, <-1.036950, 1.565014, -0.009136>, <-1.136950, 1.565014, -0.009136>, <-1.211950, 1.565014, -0.009136>, 
      <-0.961950, 1.659213, 0.007188>, <-1.036950, 1.659213, 0.007188>, <-1.136950, 1.659213, 0.007188>, <-1.211950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.886950, 1.345215, -0.047225>, <-0.786950, 1.345215, -0.047225>, <-0.711950, 1.345215, -0.047225>, 
      <-0.961950, 1.254064, -0.060582>, <-0.886950, 1.254064, -0.060582>, <-0.786950, 1.254064, -0.060582>, <-0.711950, 1.254064, -0.060582>, 
      <-0.961950, 1.132409, -0.083501>, <-0.886950, 1.132409, -0.083501>, <-0.786950, 1.132409, -0.083501>, <-0.711950, 1.132409, -0.083501>, 
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.254064, -0.060582>, <-0.961950, 1.132409, -0.083501>, <-0.961950, 1.040285, -0.083501>, 
      <-1.036950, 1.345215, -0.047225>, <-1.036950, 1.254064, -0.060582>, <-1.036950, 1.132409, -0.083501>, <-1.036950, 1.040285, -0.083501>, 
      <-1.136950, 1.345215, -0.047225>, <-1.136950, 1.254064, -0.060582>, <-1.136950, 1.132409, -0.083501>, <-1.136950, 1.040285, -0.083501>, 
      <-1.211950, 1.345215, -0.047225>, <-1.211950, 1.254064, -0.060582>, <-1.211950, 1.132409, -0.083501>, <-1.211950, 1.040285, -0.083501>
    }
  }
  texture {
    PhotoAlienShip4
    scale <1.216817, 0.999724, 1.0>
    rotate <0.0, -0.0, -90.0>
    translate <-1.710006, 1.660085, 0.000000>
  }
  scale <5.0, 6.0, 0.2>
  rotate <0.0, -0.0, 105.076668>
  translate  <-7.984941, 0.274527, 1.222053>
}


union { // Alien_Photo2
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>, 
      <-1.536950, 0.735356, -0.047225>, <-1.536950, 0.646120, -0.033755>, <-1.536950, 0.528253, -0.009136>, <-1.536950, 0.439495, 0.007188>, 
      <-1.636950, 0.735356, -0.047225>, <-1.636950, 0.646120, -0.033755>, <-1.636950, 0.528253, -0.009136>, <-1.636950, 0.439495, 0.007188>, 
      <-1.711950, 0.735356, -0.047225>, <-1.711950, 0.646120, -0.033755>, <-1.711950, 0.528253, -0.009136>, <-1.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.040285, -0.083501>, <-1.461950, 0.948161, -0.083501>, <-1.461950, 0.826448, -0.060976>, <-1.461950, 0.735356, -0.047225>, 
      <-1.536950, 1.040285, -0.083501>, <-1.536950, 0.948161, -0.083501>, <-1.536950, 0.826448, -0.060976>, <-1.536950, 0.735356, -0.047225>, 
      <-1.636950, 1.040285, -0.083501>, <-1.636950, 0.948161, -0.083501>, <-1.636950, 0.826448, -0.060976>, <-1.636950, 0.735356, -0.047225>, 
      <-1.711950, 1.040285, -0.083501>, <-1.711950, 0.948161, -0.083501>, <-1.711950, 0.826448, -0.060976>, <-1.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.461950, 1.254064, -0.060582>, <-1.461950, 1.132409, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.536950, 1.345215, -0.047225>, <-1.536950, 1.254064, -0.060582>, <-1.536950, 1.132409, -0.083501>, <-1.536950, 1.040285, -0.083501>, 
      <-1.636950, 1.345215, -0.047225>, <-1.636950, 1.254064, -0.060582>, <-1.636950, 1.132409, -0.083501>, <-1.636950, 1.040285, -0.083501>, 
      <-1.711950, 1.345215, -0.047225>, <-1.711950, 1.254064, -0.060582>, <-1.711950, 1.132409, -0.083501>, <-1.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.536950, 1.345215, -0.047225>, <-1.636950, 1.345215, -0.047225>, <-1.711950, 1.345215, -0.047225>, 
      <-1.461950, 1.439808, -0.033365>, <-1.536950, 1.439808, -0.033365>, <-1.636950, 1.439808, -0.033365>, <-1.711950, 1.439808, -0.033365>, 
      <-1.461950, 1.565014, -0.009136>, <-1.536950, 1.565014, -0.009136>, <-1.636950, 1.565014, -0.009136>, <-1.711950, 1.565014, -0.009136>, 
      <-1.461950, 1.659213, 0.007188>, <-1.536950, 1.659213, 0.007188>, <-1.636950, 1.659213, 0.007188>, <-1.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>, 
      <-1.211950, 1.439808, -0.033365>, <-1.286950, 1.439808, -0.033365>, <-1.386950, 1.439808, -0.033365>, <-1.461950, 1.439808, -0.033365>, 
      <-1.211950, 1.565014, -0.009136>, <-1.286950, 1.565014, -0.009136>, <-1.386950, 1.565014, -0.009136>, <-1.461950, 1.565014, -0.009136>, 
      <-1.211950, 1.659213, 0.007188>, <-1.286950, 1.659213, 0.007188>, <-1.386950, 1.659213, 0.007188>, <-1.461950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.211950, 1.132409, -0.083501>, <-1.286950, 1.132409, -0.083501>, <-1.386950, 1.132409, -0.083501>, <-1.461950, 1.132409, -0.083501>, 
      <-1.211950, 1.254064, -0.060582>, <-1.286950, 1.254064, -0.060582>, <-1.386950, 1.254064, -0.060582>, <-1.461950, 1.254064, -0.060582>, 
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>, 
      <-1.286950, 0.735356, -0.047225>, <-1.286950, 0.646120, -0.033755>, <-1.286950, 0.528253, -0.009136>, <-1.286950, 0.439495, 0.007188>, 
      <-1.386950, 0.735356, -0.047225>, <-1.386950, 0.646120, -0.033755>, <-1.386950, 0.528253, -0.009136>, <-1.386950, 0.439495, 0.007188>, 
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.286950, 0.735356, -0.047225>, <-1.386950, 0.735356, -0.047225>, <-1.461950, 0.735356, -0.047225>, 
      <-1.211950, 0.826448, -0.060976>, <-1.286950, 0.826448, -0.060976>, <-1.386950, 0.826448, -0.060976>, <-1.461950, 0.826448, -0.060976>, 
      <-1.211950, 0.948161, -0.083501>, <-1.286950, 0.948161, -0.083501>, <-1.386950, 0.948161, -0.083501>, <-1.461950, 0.948161, -0.083501>, 
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.961950, 0.646120, -0.033755>, <-0.961950, 0.528253, -0.009136>, <-0.961950, 0.439495, 0.007188>, 
      <-1.036950, 0.735356, -0.047225>, <-1.036950, 0.646120, -0.033755>, <-1.036950, 0.528253, -0.009136>, <-1.036950, 0.439495, 0.007188>, 
      <-1.136950, 0.735356, -0.047225>, <-1.136950, 0.646120, -0.033755>, <-1.136950, 0.528253, -0.009136>, <-1.136950, 0.439495, 0.007188>, 
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>, 
      <-0.961950, 0.646120, -0.033755>, <-0.886950, 0.646120, -0.033755>, <-0.786950, 0.646120, -0.033755>, <-0.711950, 0.646120, -0.033755>, 
      <-0.961950, 0.528253, -0.009136>, <-0.886950, 0.528253, -0.009136>, <-0.786950, 0.528253, -0.009136>, <-0.711950, 0.528253, -0.009136>, 
      <-0.961950, 0.439495, 0.007188>, <-0.886950, 0.439495, 0.007188>, <-0.786950, 0.439495, 0.007188>, <-0.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>, 
      <-0.961950, 0.948161, -0.083501>, <-0.886950, 0.948161, -0.083501>, <-0.786950, 0.948161, -0.083501>, <-0.711950, 0.948161, -0.083501>, 
      <-0.961950, 0.826448, -0.060976>, <-0.886950, 0.826448, -0.060976>, <-0.786950, 0.826448, -0.060976>, <-0.711950, 0.826448, -0.060976>, 
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.961950, 0.948161, -0.083501>, <-0.961950, 0.826448, -0.060976>, <-0.961950, 0.735356, -0.047225>, 
      <-1.036950, 1.040285, -0.083501>, <-1.036950, 0.948161, -0.083501>, <-1.036950, 0.826448, -0.060976>, <-1.036950, 0.735356, -0.047225>, 
      <-1.136950, 1.040285, -0.083501>, <-1.136950, 0.948161, -0.083501>, <-1.136950, 0.826448, -0.060976>, <-1.136950, 0.735356, -0.047225>, 
      <-1.211950, 1.040285, -0.083501>, <-1.211950, 0.948161, -0.083501>, <-1.211950, 0.826448, -0.060976>, <-1.211950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.439808, -0.033365>, <-0.961950, 1.565014, -0.009136>, <-0.961950, 1.659213, 0.007188>, 
      <-0.886950, 1.345215, -0.047225>, <-0.886950, 1.439808, -0.033365>, <-0.886950, 1.565014, -0.009136>, <-0.886950, 1.659213, 0.007188>, 
      <-0.786950, 1.345215, -0.047225>, <-0.786950, 1.439808, -0.033365>, <-0.786950, 1.565014, -0.009136>, <-0.786950, 1.659213, 0.007188>, 
      <-0.711950, 1.345215, -0.047225>, <-0.711950, 1.439808, -0.033365>, <-0.711950, 1.565014, -0.009136>, <-0.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-1.036950, 1.345215, -0.047225>, <-1.136950, 1.345215, -0.047225>, <-1.211950, 1.345215, -0.047225>, 
      <-0.961950, 1.439808, -0.033365>, <-1.036950, 1.439808, -0.033365>, <-1.136950, 1.439808, -0.033365>, <-1.211950, 1.439808, -0.033365>, 
      <-0.961950, 1.565014, -0.009136>, <-1.036950, 1.565014, -0.009136>, <-1.136950, 1.565014, -0.009136>, <-1.211950, 1.565014, -0.009136>, 
      <-0.961950, 1.659213, 0.007188>, <-1.036950, 1.659213, 0.007188>, <-1.136950, 1.659213, 0.007188>, <-1.211950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.886950, 1.345215, -0.047225>, <-0.786950, 1.345215, -0.047225>, <-0.711950, 1.345215, -0.047225>, 
      <-0.961950, 1.254064, -0.060582>, <-0.886950, 1.254064, -0.060582>, <-0.786950, 1.254064, -0.060582>, <-0.711950, 1.254064, -0.060582>, 
      <-0.961950, 1.132409, -0.083501>, <-0.886950, 1.132409, -0.083501>, <-0.786950, 1.132409, -0.083501>, <-0.711950, 1.132409, -0.083501>, 
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.254064, -0.060582>, <-0.961950, 1.132409, -0.083501>, <-0.961950, 1.040285, -0.083501>, 
      <-1.036950, 1.345215, -0.047225>, <-1.036950, 1.254064, -0.060582>, <-1.036950, 1.132409, -0.083501>, <-1.036950, 1.040285, -0.083501>, 
      <-1.136950, 1.345215, -0.047225>, <-1.136950, 1.254064, -0.060582>, <-1.136950, 1.132409, -0.083501>, <-1.136950, 1.040285, -0.083501>, 
      <-1.211950, 1.345215, -0.047225>, <-1.211950, 1.254064, -0.060582>, <-1.211950, 1.132409, -0.083501>, <-1.211950, 1.040285, -0.083501>
    }
  }
  texture {
    PhotoAlienShip3
    scale <1.216817, 0.999724, 1.0>
    rotate <0.0, -0.0, -90.0>
    translate <-1.710006, 1.660085, 0.000000>
  }
  scale <5.0, 7.0, 0.01>
  rotate 77.852318*z
  translate  <2.355883, 12.296135, 1.185>
}


union { // Alien_Photo1
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>, 
      <-1.536950, 0.735356, -0.047225>, <-1.536950, 0.646120, -0.033755>, <-1.536950, 0.528253, -0.009136>, <-1.536950, 0.439495, 0.007188>, 
      <-1.636950, 0.735356, -0.047225>, <-1.636950, 0.646120, -0.033755>, <-1.636950, 0.528253, -0.009136>, <-1.636950, 0.439495, 0.007188>, 
      <-1.711950, 0.735356, -0.047225>, <-1.711950, 0.646120, -0.033755>, <-1.711950, 0.528253, -0.009136>, <-1.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.040285, -0.083501>, <-1.461950, 0.948161, -0.083501>, <-1.461950, 0.826448, -0.060976>, <-1.461950, 0.735356, -0.047225>, 
      <-1.536950, 1.040285, -0.083501>, <-1.536950, 0.948161, -0.083501>, <-1.536950, 0.826448, -0.060976>, <-1.536950, 0.735356, -0.047225>, 
      <-1.636950, 1.040285, -0.083501>, <-1.636950, 0.948161, -0.083501>, <-1.636950, 0.826448, -0.060976>, <-1.636950, 0.735356, -0.047225>, 
      <-1.711950, 1.040285, -0.083501>, <-1.711950, 0.948161, -0.083501>, <-1.711950, 0.826448, -0.060976>, <-1.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.461950, 1.254064, -0.060582>, <-1.461950, 1.132409, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.536950, 1.345215, -0.047225>, <-1.536950, 1.254064, -0.060582>, <-1.536950, 1.132409, -0.083501>, <-1.536950, 1.040285, -0.083501>, 
      <-1.636950, 1.345215, -0.047225>, <-1.636950, 1.254064, -0.060582>, <-1.636950, 1.132409, -0.083501>, <-1.636950, 1.040285, -0.083501>, 
      <-1.711950, 1.345215, -0.047225>, <-1.711950, 1.254064, -0.060582>, <-1.711950, 1.132409, -0.083501>, <-1.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.536950, 1.345215, -0.047225>, <-1.636950, 1.345215, -0.047225>, <-1.711950, 1.345215, -0.047225>, 
      <-1.461950, 1.439808, -0.033365>, <-1.536950, 1.439808, -0.033365>, <-1.636950, 1.439808, -0.033365>, <-1.711950, 1.439808, -0.033365>, 
      <-1.461950, 1.565014, -0.009136>, <-1.536950, 1.565014, -0.009136>, <-1.636950, 1.565014, -0.009136>, <-1.711950, 1.565014, -0.009136>, 
      <-1.461950, 1.659213, 0.007188>, <-1.536950, 1.659213, 0.007188>, <-1.636950, 1.659213, 0.007188>, <-1.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>, 
      <-1.211950, 1.439808, -0.033365>, <-1.286950, 1.439808, -0.033365>, <-1.386950, 1.439808, -0.033365>, <-1.461950, 1.439808, -0.033365>, 
      <-1.211950, 1.565014, -0.009136>, <-1.286950, 1.565014, -0.009136>, <-1.386950, 1.565014, -0.009136>, <-1.461950, 1.565014, -0.009136>, 
      <-1.211950, 1.659213, 0.007188>, <-1.286950, 1.659213, 0.007188>, <-1.386950, 1.659213, 0.007188>, <-1.461950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.211950, 1.132409, -0.083501>, <-1.286950, 1.132409, -0.083501>, <-1.386950, 1.132409, -0.083501>, <-1.461950, 1.132409, -0.083501>, 
      <-1.211950, 1.254064, -0.060582>, <-1.286950, 1.254064, -0.060582>, <-1.386950, 1.254064, -0.060582>, <-1.461950, 1.254064, -0.060582>, 
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>, 
      <-1.286950, 0.735356, -0.047225>, <-1.286950, 0.646120, -0.033755>, <-1.286950, 0.528253, -0.009136>, <-1.286950, 0.439495, 0.007188>, 
      <-1.386950, 0.735356, -0.047225>, <-1.386950, 0.646120, -0.033755>, <-1.386950, 0.528253, -0.009136>, <-1.386950, 0.439495, 0.007188>, 
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.286950, 0.735356, -0.047225>, <-1.386950, 0.735356, -0.047225>, <-1.461950, 0.735356, -0.047225>, 
      <-1.211950, 0.826448, -0.060976>, <-1.286950, 0.826448, -0.060976>, <-1.386950, 0.826448, -0.060976>, <-1.461950, 0.826448, -0.060976>, 
      <-1.211950, 0.948161, -0.083501>, <-1.286950, 0.948161, -0.083501>, <-1.386950, 0.948161, -0.083501>, <-1.461950, 0.948161, -0.083501>, 
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.961950, 0.646120, -0.033755>, <-0.961950, 0.528253, -0.009136>, <-0.961950, 0.439495, 0.007188>, 
      <-1.036950, 0.735356, -0.047225>, <-1.036950, 0.646120, -0.033755>, <-1.036950, 0.528253, -0.009136>, <-1.036950, 0.439495, 0.007188>, 
      <-1.136950, 0.735356, -0.047225>, <-1.136950, 0.646120, -0.033755>, <-1.136950, 0.528253, -0.009136>, <-1.136950, 0.439495, 0.007188>, 
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>, 
      <-0.961950, 0.646120, -0.033755>, <-0.886950, 0.646120, -0.033755>, <-0.786950, 0.646120, -0.033755>, <-0.711950, 0.646120, -0.033755>, 
      <-0.961950, 0.528253, -0.009136>, <-0.886950, 0.528253, -0.009136>, <-0.786950, 0.528253, -0.009136>, <-0.711950, 0.528253, -0.009136>, 
      <-0.961950, 0.439495, 0.007188>, <-0.886950, 0.439495, 0.007188>, <-0.786950, 0.439495, 0.007188>, <-0.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>, 
      <-0.961950, 0.948161, -0.083501>, <-0.886950, 0.948161, -0.083501>, <-0.786950, 0.948161, -0.083501>, <-0.711950, 0.948161, -0.083501>, 
      <-0.961950, 0.826448, -0.060976>, <-0.886950, 0.826448, -0.060976>, <-0.786950, 0.826448, -0.060976>, <-0.711950, 0.826448, -0.060976>, 
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.961950, 0.948161, -0.083501>, <-0.961950, 0.826448, -0.060976>, <-0.961950, 0.735356, -0.047225>, 
      <-1.036950, 1.040285, -0.083501>, <-1.036950, 0.948161, -0.083501>, <-1.036950, 0.826448, -0.060976>, <-1.036950, 0.735356, -0.047225>, 
      <-1.136950, 1.040285, -0.083501>, <-1.136950, 0.948161, -0.083501>, <-1.136950, 0.826448, -0.060976>, <-1.136950, 0.735356, -0.047225>, 
      <-1.211950, 1.040285, -0.083501>, <-1.211950, 0.948161, -0.083501>, <-1.211950, 0.826448, -0.060976>, <-1.211950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.439808, -0.033365>, <-0.961950, 1.565014, -0.009136>, <-0.961950, 1.659213, 0.007188>, 
      <-0.886950, 1.345215, -0.047225>, <-0.886950, 1.439808, -0.033365>, <-0.886950, 1.565014, -0.009136>, <-0.886950, 1.659213, 0.007188>, 
      <-0.786950, 1.345215, -0.047225>, <-0.786950, 1.439808, -0.033365>, <-0.786950, 1.565014, -0.009136>, <-0.786950, 1.659213, 0.007188>, 
      <-0.711950, 1.345215, -0.047225>, <-0.711950, 1.439808, -0.033365>, <-0.711950, 1.565014, -0.009136>, <-0.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-1.036950, 1.345215, -0.047225>, <-1.136950, 1.345215, -0.047225>, <-1.211950, 1.345215, -0.047225>, 
      <-0.961950, 1.439808, -0.033365>, <-1.036950, 1.439808, -0.033365>, <-1.136950, 1.439808, -0.033365>, <-1.211950, 1.439808, -0.033365>, 
      <-0.961950, 1.565014, -0.009136>, <-1.036950, 1.565014, -0.009136>, <-1.136950, 1.565014, -0.009136>, <-1.211950, 1.565014, -0.009136>, 
      <-0.961950, 1.659213, 0.007188>, <-1.036950, 1.659213, 0.007188>, <-1.136950, 1.659213, 0.007188>, <-1.211950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.886950, 1.345215, -0.047225>, <-0.786950, 1.345215, -0.047225>, <-0.711950, 1.345215, -0.047225>, 
      <-0.961950, 1.254064, -0.060582>, <-0.886950, 1.254064, -0.060582>, <-0.786950, 1.254064, -0.060582>, <-0.711950, 1.254064, -0.060582>, 
      <-0.961950, 1.132409, -0.083501>, <-0.886950, 1.132409, -0.083501>, <-0.786950, 1.132409, -0.083501>, <-0.711950, 1.132409, -0.083501>, 
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.254064, -0.060582>, <-0.961950, 1.132409, -0.083501>, <-0.961950, 1.040285, -0.083501>, 
      <-1.036950, 1.345215, -0.047225>, <-1.036950, 1.254064, -0.060582>, <-1.036950, 1.132409, -0.083501>, <-1.036950, 1.040285, -0.083501>, 
      <-1.136950, 1.345215, -0.047225>, <-1.136950, 1.254064, -0.060582>, <-1.136950, 1.132409, -0.083501>, <-1.136950, 1.040285, -0.083501>, 
      <-1.211950, 1.345215, -0.047225>, <-1.211950, 1.254064, -0.060582>, <-1.211950, 1.132409, -0.083501>, <-1.211950, 1.040285, -0.083501>
    }
  }
  texture {
    PhotoAlienShip5
    scale <1.216817, 0.999724, 1.0>
    rotate <0.0, -0.0, -90.0>
    translate <-1.710006, 1.660085, 0.000000>
  }
  scale <5.0, 5.0, 1.0>
  rotate 123.500481*z
  translate  <-11.685408, 14.286355, 1.288045>
}


#declare Fluid3 = union {
  cylinder { // FluidBody3
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 7.1>
  }
  sphere { // FluidBtm3
    <0,0,0>,1
    scale 0.35
  }
  scale 0.8
}
#declare FluidwBubble3 = difference {
  object { Fluid3 }
  sphere { // Bubble3
    <0,0,0>,1
    scale <0.282282, 0.066967, 0.354054>
    translate  <0.0, 0.279291, 4.548626>
  }
  texture {
    SmokyFluid
  }
}
#declare TestTube3 = merge {
  sphere { // TubeBtn3
    <0,0,0>,1
    scale 0.35
  }
  cylinder { // TubeBody3
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 5.8>
  }
  torus { // tubeLip3
    1.825, 0.175  rotate -x*90
    scale <0.2, 0.2, 0.35>
    translate  5.8*z
  }
  texture {
    TransGlass
  }
}
union { // TestTubeDone3
  object { FluidwBubble3 }
  cone { // PlasticCork3
    <0,0,0>, 0.6, <0,0,1>, 1.0
    texture {
      Plastic_Black
    }
    scale <0.4, 0.4, 0.571429>
    translate  5.488153*z
  }
  object { TestTube3 }
  scale <1.25, 1.25, 1.0>
  rotate <89.469795, -0.136822, 168.826981>
  translate  <4.118573, 2.760115, 1.529824>
}


box { // LetterPage2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PhotoPresidentLtr
    scale <2.00197, 1.999122, 1.0>
    translate <-1.001970, -0.999122, 0.000000>
  }
  scale <6.181818, 8.0, 0.01>
  rotate <-0.0, 0.0, 16.191593>
  translate  <-1.004297, -1.224043, 1.1893>
}


#declare Fluid2 = union {
  cylinder { // FluidBody2
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 7.1>
  }
  sphere { // FluidBtm2
    <0,0,0>,1
    scale 0.35
  }
  scale 0.8
}
#declare FluidwBubble2 = difference {
  object { Fluid2 }
  sphere { // Bubble2
    <0,0,0>,1
    scale <0.282282, 0.067, 1.2>
    translate  <0.0, 0.279291, 3.0>
  }
  texture {
    SmokyGreenFluid
  }
}
#declare TestTube2 = merge {
  sphere { // TubeBtn2
    <0,0,0>,1
    scale 0.35
  }
  cylinder { // TubeBody2
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 5.8>
  }
  torus { // tubeLip2
    1.825, 0.175  rotate -x*90
    scale <0.2, 0.2, 0.35>
    translate  5.8*z
  }
  texture {
    TransGlass
  }
}
union { // TestTubeDone2
  object { FluidwBubble2 }
  cone { // PlasticCork2
    <0,0,0>, 0.6, <0,0,1>, 1.0
    texture {
      Plastic_Black
    }
    scale <0.4, 0.4, 0.571429>
    translate  5.488153*z
  }
  object { TestTube2 }
  scale <1.25, 1.25, 1.0>
  rotate <89.5, -0.1, 151.523056>
  translate  <5.249965, 2.665894, 1.529824>
}


#declare Fluid = union {
  cylinder { // FluidBody
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 7.1>
  }
  sphere { // FluidBtm
    <0,0,0>,1
    scale 0.35
  }
  scale 0.8
}
#declare FluidwBubble = difference {
  object { Fluid }
  sphere { // Bubble
    <0,0,0>,1
    scale <0.282282, 0.07, 1.2>
    translate  <0.0, 0.279291, 3.0>
  }
  texture {
    Shiny_Bluish
  }
}
#declare TestTube = merge {
  sphere { // TubeBtn
    <0,0,0>,1
    scale 0.35
  }
  cylinder { // TubeBody
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 5.8>
  }
  torus { // tubeLip
    1.825, 0.175  rotate -x*90
    scale <0.2, 0.2, 0.35>
    translate  5.8*z
  }
  texture {
    TransGlass
  }
}
union { // TestTubeDone
  object { FluidwBubble }
  cone { // PlasticCork
    <0,0,0>, 0.6, <0,0,1>, 1.0
    texture {
      Plastic_Black
    }
    scale <0.4, 0.4, 0.571429>
    translate  5.488153*z
  }
  object { TestTube }
  scale <1.25, 1.25, 1.0>
  rotate <90.0, -0.0, -166.42244>
  translate  <7.004529, -5.442258, 1.610365>
}


box { // FamilyPhoto3
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PhotoJuliaLaugh
    scale <1.995896, 1.99884, 1.0>
    translate <-0.995896, -0.998840, -0.456545>
  }
  scale <2.5, 1.5, 0.025>
  rotate -10.028728*z
  translate  <8.704793, -3.138758, 1.15851>
}


union { // Alien_Photo
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>, 
      <-1.536950, 0.735356, -0.047225>, <-1.536950, 0.646120, -0.033755>, <-1.536950, 0.528253, -0.009136>, <-1.536950, 0.439495, 0.007188>, 
      <-1.636950, 0.735356, -0.047225>, <-1.636950, 0.646120, -0.033755>, <-1.636950, 0.528253, -0.009136>, <-1.636950, 0.439495, 0.007188>, 
      <-1.711950, 0.735356, -0.047225>, <-1.711950, 0.646120, -0.033755>, <-1.711950, 0.528253, -0.009136>, <-1.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.040285, -0.083501>, <-1.461950, 0.948161, -0.083501>, <-1.461950, 0.826448, -0.060976>, <-1.461950, 0.735356, -0.047225>, 
      <-1.536950, 1.040285, -0.083501>, <-1.536950, 0.948161, -0.083501>, <-1.536950, 0.826448, -0.060976>, <-1.536950, 0.735356, -0.047225>, 
      <-1.636950, 1.040285, -0.083501>, <-1.636950, 0.948161, -0.083501>, <-1.636950, 0.826448, -0.060976>, <-1.636950, 0.735356, -0.047225>, 
      <-1.711950, 1.040285, -0.083501>, <-1.711950, 0.948161, -0.083501>, <-1.711950, 0.826448, -0.060976>, <-1.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.461950, 1.254064, -0.060582>, <-1.461950, 1.132409, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.536950, 1.345215, -0.047225>, <-1.536950, 1.254064, -0.060582>, <-1.536950, 1.132409, -0.083501>, <-1.536950, 1.040285, -0.083501>, 
      <-1.636950, 1.345215, -0.047225>, <-1.636950, 1.254064, -0.060582>, <-1.636950, 1.132409, -0.083501>, <-1.636950, 1.040285, -0.083501>, 
      <-1.711950, 1.345215, -0.047225>, <-1.711950, 1.254064, -0.060582>, <-1.711950, 1.132409, -0.083501>, <-1.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.461950, 1.345215, -0.047225>, <-1.536950, 1.345215, -0.047225>, <-1.636950, 1.345215, -0.047225>, <-1.711950, 1.345215, -0.047225>, 
      <-1.461950, 1.439808, -0.033365>, <-1.536950, 1.439808, -0.033365>, <-1.636950, 1.439808, -0.033365>, <-1.711950, 1.439808, -0.033365>, 
      <-1.461950, 1.565014, -0.009136>, <-1.536950, 1.565014, -0.009136>, <-1.636950, 1.565014, -0.009136>, <-1.711950, 1.565014, -0.009136>, 
      <-1.461950, 1.659213, 0.007188>, <-1.536950, 1.659213, 0.007188>, <-1.636950, 1.659213, 0.007188>, <-1.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>, 
      <-1.211950, 1.439808, -0.033365>, <-1.286950, 1.439808, -0.033365>, <-1.386950, 1.439808, -0.033365>, <-1.461950, 1.439808, -0.033365>, 
      <-1.211950, 1.565014, -0.009136>, <-1.286950, 1.565014, -0.009136>, <-1.386950, 1.565014, -0.009136>, <-1.461950, 1.565014, -0.009136>, 
      <-1.211950, 1.659213, 0.007188>, <-1.286950, 1.659213, 0.007188>, <-1.386950, 1.659213, 0.007188>, <-1.461950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>, 
      <-1.211950, 1.132409, -0.083501>, <-1.286950, 1.132409, -0.083501>, <-1.386950, 1.132409, -0.083501>, <-1.461950, 1.132409, -0.083501>, 
      <-1.211950, 1.254064, -0.060582>, <-1.286950, 1.254064, -0.060582>, <-1.386950, 1.254064, -0.060582>, <-1.461950, 1.254064, -0.060582>, 
      <-1.211950, 1.345215, -0.047225>, <-1.286950, 1.345215, -0.047225>, <-1.386950, 1.345215, -0.047225>, <-1.461950, 1.345215, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>, 
      <-1.286950, 0.735356, -0.047225>, <-1.286950, 0.646120, -0.033755>, <-1.286950, 0.528253, -0.009136>, <-1.286950, 0.439495, 0.007188>, 
      <-1.386950, 0.735356, -0.047225>, <-1.386950, 0.646120, -0.033755>, <-1.386950, 0.528253, -0.009136>, <-1.386950, 0.439495, 0.007188>, 
      <-1.461950, 0.735356, -0.047225>, <-1.461950, 0.646120, -0.033755>, <-1.461950, 0.528253, -0.009136>, <-1.461950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.211950, 0.735356, -0.047225>, <-1.286950, 0.735356, -0.047225>, <-1.386950, 0.735356, -0.047225>, <-1.461950, 0.735356, -0.047225>, 
      <-1.211950, 0.826448, -0.060976>, <-1.286950, 0.826448, -0.060976>, <-1.386950, 0.826448, -0.060976>, <-1.461950, 0.826448, -0.060976>, 
      <-1.211950, 0.948161, -0.083501>, <-1.286950, 0.948161, -0.083501>, <-1.386950, 0.948161, -0.083501>, <-1.461950, 0.948161, -0.083501>, 
      <-1.211950, 1.040285, -0.083501>, <-1.286950, 1.040285, -0.083501>, <-1.386950, 1.040285, -0.083501>, <-1.461950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.961950, 0.646120, -0.033755>, <-0.961950, 0.528253, -0.009136>, <-0.961950, 0.439495, 0.007188>, 
      <-1.036950, 0.735356, -0.047225>, <-1.036950, 0.646120, -0.033755>, <-1.036950, 0.528253, -0.009136>, <-1.036950, 0.439495, 0.007188>, 
      <-1.136950, 0.735356, -0.047225>, <-1.136950, 0.646120, -0.033755>, <-1.136950, 0.528253, -0.009136>, <-1.136950, 0.439495, 0.007188>, 
      <-1.211950, 0.735356, -0.047225>, <-1.211950, 0.646120, -0.033755>, <-1.211950, 0.528253, -0.009136>, <-1.211950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>, 
      <-0.961950, 0.646120, -0.033755>, <-0.886950, 0.646120, -0.033755>, <-0.786950, 0.646120, -0.033755>, <-0.711950, 0.646120, -0.033755>, 
      <-0.961950, 0.528253, -0.009136>, <-0.886950, 0.528253, -0.009136>, <-0.786950, 0.528253, -0.009136>, <-0.711950, 0.528253, -0.009136>, 
      <-0.961950, 0.439495, 0.007188>, <-0.886950, 0.439495, 0.007188>, <-0.786950, 0.439495, 0.007188>, <-0.711950, 0.439495, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>, 
      <-0.961950, 0.948161, -0.083501>, <-0.886950, 0.948161, -0.083501>, <-0.786950, 0.948161, -0.083501>, <-0.711950, 0.948161, -0.083501>, 
      <-0.961950, 0.826448, -0.060976>, <-0.886950, 0.826448, -0.060976>, <-0.786950, 0.826448, -0.060976>, <-0.711950, 0.826448, -0.060976>, 
      <-0.961950, 0.735356, -0.047225>, <-0.886950, 0.735356, -0.047225>, <-0.786950, 0.735356, -0.047225>, <-0.711950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.040285, -0.083501>, <-0.961950, 0.948161, -0.083501>, <-0.961950, 0.826448, -0.060976>, <-0.961950, 0.735356, -0.047225>, 
      <-1.036950, 1.040285, -0.083501>, <-1.036950, 0.948161, -0.083501>, <-1.036950, 0.826448, -0.060976>, <-1.036950, 0.735356, -0.047225>, 
      <-1.136950, 1.040285, -0.083501>, <-1.136950, 0.948161, -0.083501>, <-1.136950, 0.826448, -0.060976>, <-1.136950, 0.735356, -0.047225>, 
      <-1.211950, 1.040285, -0.083501>, <-1.211950, 0.948161, -0.083501>, <-1.211950, 0.826448, -0.060976>, <-1.211950, 0.735356, -0.047225>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.439808, -0.033365>, <-0.961950, 1.565014, -0.009136>, <-0.961950, 1.659213, 0.007188>, 
      <-0.886950, 1.345215, -0.047225>, <-0.886950, 1.439808, -0.033365>, <-0.886950, 1.565014, -0.009136>, <-0.886950, 1.659213, 0.007188>, 
      <-0.786950, 1.345215, -0.047225>, <-0.786950, 1.439808, -0.033365>, <-0.786950, 1.565014, -0.009136>, <-0.786950, 1.659213, 0.007188>, 
      <-0.711950, 1.345215, -0.047225>, <-0.711950, 1.439808, -0.033365>, <-0.711950, 1.565014, -0.009136>, <-0.711950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-1.036950, 1.345215, -0.047225>, <-1.136950, 1.345215, -0.047225>, <-1.211950, 1.345215, -0.047225>, 
      <-0.961950, 1.439808, -0.033365>, <-1.036950, 1.439808, -0.033365>, <-1.136950, 1.439808, -0.033365>, <-1.211950, 1.439808, -0.033365>, 
      <-0.961950, 1.565014, -0.009136>, <-1.036950, 1.565014, -0.009136>, <-1.136950, 1.565014, -0.009136>, <-1.211950, 1.565014, -0.009136>, 
      <-0.961950, 1.659213, 0.007188>, <-1.036950, 1.659213, 0.007188>, <-1.136950, 1.659213, 0.007188>, <-1.211950, 1.659213, 0.007188>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.886950, 1.345215, -0.047225>, <-0.786950, 1.345215, -0.047225>, <-0.711950, 1.345215, -0.047225>, 
      <-0.961950, 1.254064, -0.060582>, <-0.886950, 1.254064, -0.060582>, <-0.786950, 1.254064, -0.060582>, <-0.711950, 1.254064, -0.060582>, 
      <-0.961950, 1.132409, -0.083501>, <-0.886950, 1.132409, -0.083501>, <-0.786950, 1.132409, -0.083501>, <-0.711950, 1.132409, -0.083501>, 
      <-0.961950, 1.040285, -0.083501>, <-0.886950, 1.040285, -0.083501>, <-0.786950, 1.040285, -0.083501>, <-0.711950, 1.040285, -0.083501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.961950, 1.345215, -0.047225>, <-0.961950, 1.254064, -0.060582>, <-0.961950, 1.132409, -0.083501>, <-0.961950, 1.040285, -0.083501>, 
      <-1.036950, 1.345215, -0.047225>, <-1.036950, 1.254064, -0.060582>, <-1.036950, 1.132409, -0.083501>, <-1.036950, 1.040285, -0.083501>, 
      <-1.136950, 1.345215, -0.047225>, <-1.136950, 1.254064, -0.060582>, <-1.136950, 1.132409, -0.083501>, <-1.136950, 1.040285, -0.083501>, 
      <-1.211950, 1.345215, -0.047225>, <-1.211950, 1.254064, -0.060582>, <-1.211950, 1.132409, -0.083501>, <-1.211950, 1.040285, -0.083501>
    }
  }
  texture {
    PhotoAlienShip
    scale <1.216817, 0.999724, 1.0>
    rotate <0.0, -0.0, -90.0>
    translate <-1.710006, 1.660085, 0.000000>
  }
  scale <6.0, 6.0, 0.1>
  rotate 79.086891*z
  translate  <-3.929697, 5.842638, 1.182>
}


box { // LetterPage1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    PhotoPresidentLtr
    scale <2.00197, 1.999122, 1.0>
    translate <-1.001970, -0.999122, 0.000000>
  }
  scale <6.181818, 8.0, 0.01>
  rotate 11.65226*z
  translate  <-1.181939, -0.91804, 1.191762>
}


#declare VideoEdge1Done = difference {
  box { // Edge1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.3, 0.1, 0.7>
    translate  <10.631307, 1.949839, 1.864626>
  }
  box { // EdgeCutter1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.2, 1.3>
    rotate <-0.0, 44.89946, -0.0>
    translate  <8.396434, 1.949839, 2.427203>
  }
  texture {
    Plastic_Black
  }
}
#declare VidEdge = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.0, -1.0>,
  <-0.7, -1.0>,
  <-0.699777, -0.840764>,
  <0.798301, 0.369427>,
  <0.968153, 0.551231>,
  <1.0, 0.8>,
  <0.893843, 0.978769>,
  <0.7, 1.0>,
  <0.36, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    Shiny_Black
  }
  scale <0.555073, 0.7, 0.168708>
  rotate <90.0, -0.0, 0.0>
  translate  <8.900381, 2.019382, 1.864891>
}
#declare VideoTapeDone = union {
  object { VideoEdge1Done }
  box { // VideoBody
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Shiny_Black
    }
    scale <0.155, 4.15, 0.7>
    translate  <8.5, 6.0, 1.864626>
  }
  object { VidEdge }
  scale <1.15, 1.3, 1.0>
  translate  <-1.430429, 0.9, 0.0>
}
#declare Fluid1 = union {
  cylinder { // FluidBody1
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 7.1>
  }
  sphere { // FluidBtm1
    <0,0,0>,1
    scale 0.35
  }
  scale 0.8
}
#declare FluidwBubble1 = difference {
  object { Fluid1 }
  sphere { // Bubble1
    <0,0,0>,1
    scale <0.282282, 0.066967, 0.354054>
    translate  <0.0, 0.279291, 4.548626>
  }
  texture {
    Shiny_Bluish
  }
}
#declare TestTube1 = merge {
  sphere { // TubeBtn1
    <0,0,0>,1
    scale 0.35
  }
  cylinder { // TubeBody1
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.35, 5.8>
  }
  torus { // tubeLip1
    1.825, 0.175  rotate -x*90
    scale <0.2, 0.2, 0.35>
    translate  5.8*z
  }
  texture {
    TransGlass
  }
  scale <1.25, 1.25, 1.0>
}
#declare TestTubeDone1 = union {
  object { FluidwBubble1 }
  cone { // PlasticCork1
    <0,0,0>, 0.6, <0,0,1>, 1.0
    texture {
      Plastic_Black
    }
    scale <0.4, 0.4, 0.571429>
    translate  5.488153*z
  }
  object { TestTube1 }
  rotate <89.5, -0.1, -38.924686>
  translate  <12.387482, 10.155325, 3.019233>
}
#declare CutTape = union {
  cylinder { // CutFaceCurve
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 1.0, 2.0>
    translate  <-0.5, 0.0, -1.0>
  }
  box { // CutFace1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 1.0, 1.0>
    translate  0.2*x
  }
  cylinder { // CutFaceCurve1
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 1.0, 2.0>
    translate  <6.0, 0.0, -1.0>
  }
  box { // CutFace2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.7, 1.0, 1.0>
    translate  5.3*x
  }
  box { // LabelGloss
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Shiny_Black
    }
    scale <1.65, 1.0, 0.1>
    translate  <2.75, 0.0, 0.558589>
  }
  texture {
    Plastic_Black
  }
  scale 0.5
  translate  -1.379406*x
}
#declare TapeCutting = difference {
  box { // TapeBody
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Plastic_Black
    }
    scale <2.0, 0.93, 0.3>
    translate  -0.05*y
  }
  object { CutTape }
}
#declare VideoDone = union {
  cylinder { // SpoolMiddle
    <0,0,1>, <0,0,0>, 1 
    texture {
      White_Plaster
    }
    scale <0.08, 0.08, 0.45>
    translate  <1.0, 0.0, -0.22>
  }
  cylinder { // SpoolMiddle2
    <0,0,1>, <0,0,0>, 1 
    texture {
      White_Plaster
    }
    scale <0.08, 0.08, 0.45>
    translate  <-1.0, 0.0, -0.22>
  }
  object { // SpoolCutUp1->SpoolCutUp
    SpoolCutUp
    rotate 180.0*z
  }
  object { SpoolCutUp }
  cylinder { // Tape1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Red
    }
    scale <0.35, 0.35, 0.4>
    translate  <1.0, 0.0, -0.2>
  }
  cylinder { // Tape
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Red
    }
    scale <0.55, 0.55, 0.4>
    translate  <-1.0, 0.0, -0.2>
  }
  object { TapeCutting }
  box { // GlassFace
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TransGlass
    }
    scale <1.8, 0.62, 0.03>
    translate  0.271337*z
  }
  scale <2.64, 2.64, 2.1>
  rotate 90.0*z
  translate  <10.82518, 8.8, 1.937093>
}
union { // FolderDone
  object { VideoTapeDone }
  object { TestTubeDone1 }
  object { VideoDone }
  rotate -61.5*z
  translate  <-0.623746, 7.565029, 0.0>
}


#declare BlotterEdgeDone = intersection {
  cylinder { // RoundEdge1
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 5.0, 15.0>
    rotate <45.0, -90.0, 0.0>
    translate  <-12.473381, 16.182086, 0.0>
  }
  superellipsoid { // BlotterEdge1
    <0.1, 1.0>
    scale <4.0, 4.0, 0.35>
    translate  <-14.692851, 7.321971, 0.0>
  }
  texture {
    BrwnLeather
  }
  scale 0.65
  translate  <-6.563878, 3.81946, 1.075748>
}
#declare BlotterEdgeDone1 = intersection {
  cylinder { // RoundEdge2
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 5.0, 15.0>
    rotate <45.0, -90.0, 0.0>
    translate  <-12.473381, 16.182086, 0.0>
  }
  superellipsoid { // BlotterEdge2
    <0.1, 1.0>
    scale <4.0, 4.0, 0.35>
    translate  <-14.692851, 7.321971, 0.0>
  }
  texture {
    BrwnLeather
  }
  scale 0.65
  rotate -90.0*z
  translate  <11.123909, -0.972042, 1.075748>
}
#declare BlotterEdgeDone2 = intersection {
  cylinder { // RoundEdge3
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 5.0, 15.0>
    rotate <45.0, -90.0, 0.0>
    translate  <-12.473381, 16.182086, 0.0>
  }
  superellipsoid { // BlotterEdge3
    <0.1, 1.0>
    scale <4.0, 4.0, 0.35>
    translate  <-14.692851, 7.321971, 0.0>
  }
  texture {
    BrwnLeather
  }
  scale 0.65
  rotate 90.0*z
  translate  <-11.205943, 0.975915, 1.075748>
}
#declare BlotterEdgeDone3 = intersection {
  cylinder { // RoundEdge4
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 5.0, 15.0>
    rotate <45.0, -90.0, 0.0>
    translate  <-12.473381, 16.182086, 0.0>
  }
  superellipsoid { // BlotterEdge4
    <0.1, 1.0>
    scale <4.0, 4.0, 0.35>
    translate  <-14.692851, 7.321971, 0.0>
  }
  texture {
    BrwnLeather
  }
  scale 0.65
  rotate -180.0*z
  translate  <6.480837, -4.004032, 1.075748>
}
union { // BlotterDone
  box { // BlotterGreen
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Dark_Green
    }
    scale <17.333, 10.0, 0.05>
    translate  1.1*z
  }
  box { // BlotterRedBack
    <-1, -1, -1>, <1, 1, 1>
    texture {
      FireCape
    }
    scale <18.333336, 11.0, 0.1>
    translate  1.042156*z
  }
  object { BlotterEdgeDone }
  object { BlotterEdgeDone1 }
  object { BlotterEdgeDone2 }
  object { BlotterEdgeDone3 }
}


box { // Desk
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DoorOak
    rotate -90.0*y
  }
  scale <30.0, 18.0, 1.0>
  translate  0.137045*z
}




#declare Armature = union {
  cylinder { // Base4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.46>
    rotate <-90.0, 0.0, 0.0>
    translate  <-3.95, -1.55, 10.15>
  }
  cylinder { // Joint3
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.3>
    rotate -90.0*y
    translate  <-3.8, -1.6, 10.15>
  }
  cylinder { // Base3
    <0,0,1>, <0,0,0>, 1 
    scale 0.1
    rotate 136.721222*x
    translate  <-3.95, -1.634605, 10.121192>
  }
  cylinder { // Joint2
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.3>
    rotate -90.0*y
    translate  <-3.8, -1.05, 10.15>
  }
  cone { // Base
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 0.25>
    rotate <-180.0, 0.0, -180.0>
    translate  <-3.95, 0.0, 8.3>
  }
  cylinder { // Joint1
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.3>
    rotate -90.0*y
    translate  <-3.8, 0.0, 9.05>
  }
  cylinder { // Base2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.5>
    rotate <43.49482, 0.0, 0.0>
    translate  <-3.95, 0.0, 9.05>
  }
  cylinder { // Base1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    translate  <-3.95, 0.0, 8.05>
  }
  texture {
    Gold_Metal
  }
  translate  -0.15*x
}
#declare shade_sides = difference {
  cylinder { // Shade_out
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.55, 4.0>
    rotate -90.0*y
    translate  <-2.1, -0.95, 10.1>
  }
  cylinder { // Shade_in
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.5, 3.95>
    rotate -90.0*y
    translate  <-2.1, -0.95, 10.1>
  }
}
#declare ShadeDone = difference {
  object { shade_sides }
  box { // ShadeMinus
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.7, 0.7>
    translate  <-3.8, -1.0, 9.35>
  }
  texture {
    ShinyGreen
  }
  rotate -38.0*x
  translate  <0.0, -7.47705, 1.245349>
}
#declare StickyNote = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060811, 1.993044, -0.009542>, <-0.060811, 1.954875, 0.013143>, <-0.060811, 1.922446, 0.066283>, <-0.060811, 1.892189, 0.098780>, 
      <-0.135811, 1.993044, -0.009542>, <-0.135811, 1.954875, 0.013143>, <-0.135811, 1.922446, 0.066283>, <-0.135811, 1.892189, 0.098780>, 
      <-0.235811, 1.993044, -0.009542>, <-0.235811, 1.954875, 0.013143>, <-0.235811, 1.922446, 0.066283>, <-0.235811, 1.892189, 0.098780>, 
      <-0.310811, 1.993044, -0.009542>, <-0.310811, 1.954875, 0.013143>, <-0.310811, 1.922446, 0.066283>, <-0.310811, 1.892189, 0.098780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060811, 2.090090, -0.018837>, <-0.060811, 2.060843, -0.018850>, <-0.060811, 2.018186, -0.024484>, <-0.060811, 1.993044, -0.009542>, 
      <-0.135811, 2.090090, -0.018837>, <-0.135811, 2.060843, -0.018850>, <-0.135811, 2.018186, -0.024484>, <-0.135811, 1.993044, -0.009542>, 
      <-0.235811, 2.090090, -0.018837>, <-0.235811, 2.060843, -0.018850>, <-0.235811, 2.018186, -0.024484>, <-0.235811, 1.993044, -0.009542>, 
      <-0.310811, 2.090090, -0.018837>, <-0.310811, 2.060843, -0.018850>, <-0.310811, 2.018186, -0.024484>, <-0.310811, 1.993044, -0.009542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060811, 2.260344, -0.009419>, <-0.057706, 2.209890, -0.017264>, <-0.060811, 2.141244, -0.018814>, <-0.060811, 2.090090, -0.018837>, 
      <-0.135811, 2.260344, -0.009419>, <-0.132706, 2.209890, -0.017264>, <-0.135811, 2.141244, -0.018814>, <-0.135811, 2.090090, -0.018837>, 
      <-0.235811, 2.260344, -0.009419>, <-0.235811, 2.209268, -0.012245>, <-0.235811, 2.141244, -0.018814>, <-0.235811, 2.090090, -0.018837>, 
      <-0.310811, 2.260344, -0.009419>, <-0.310811, 2.209268, -0.012245>, <-0.310811, 2.141244, -0.018814>, <-0.310811, 2.090090, -0.018837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.060811, 2.260344, -0.009419>, <-0.135811, 2.260344, -0.009419>, <-0.235811, 2.260344, -0.009419>, <-0.310811, 2.260344, -0.009419>, 
      <-0.063518, 2.304328, -0.002580>, <-0.138518, 2.304328, -0.002580>, <-0.235811, 2.311420, -0.006594>, <-0.310811, 2.311420, -0.006594>, 
      <-0.074266, 2.359819, 0.017986>, <-0.144094, 2.365768, 0.012262>, <-0.241577, 2.371077, 0.006093>, <-0.310811, 2.379520, -0.002826>, 
      <-0.080032, 2.402451, 0.029730>, <-0.149861, 2.408400, 0.024006>, <-0.241577, 2.422153, 0.008919>, <-0.310811, 2.430596, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.189189, 2.260344, -0.009419>, <0.114189, 2.260344, -0.009419>, <0.014189, 2.260344, -0.009419>, <-0.060811, 2.260344, -0.009419>, 
      <0.186946, 2.301222, -0.001432>, <0.111947, 2.301222, -0.001432>, <0.011482, 2.304328, -0.002580>, <-0.063518, 2.304328, -0.002580>, 
      <0.177696, 2.350682, 0.024923>, <0.101747, 2.353038, 0.023446>, <0.001208, 2.353390, 0.024172>, <-0.074266, 2.359819, 0.017986>, 
      <0.172770, 2.389399, 0.039641>, <0.096821, 2.391754, 0.038164>, <-0.004558, 2.396022, 0.035917>, <-0.080032, 2.402451, 0.029730>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.189189, 2.090090, -0.018837>, <0.114189, 2.090090, -0.018837>, <0.014189, 2.090090, -0.018837>, <-0.060811, 2.090090, -0.018837>, 
      <0.189189, 2.141244, -0.018814>, <0.114189, 2.141244, -0.018814>, <0.014189, 2.141244, -0.018814>, <-0.060811, 2.141244, -0.018814>, 
      <0.191939, 2.210212, -0.019214>, <0.116939, 2.210212, -0.019214>, <0.017294, 2.209890, -0.017264>, <-0.057706, 2.209890, -0.017264>, 
      <0.189189, 2.260344, -0.009419>, <0.114189, 2.260344, -0.009419>, <0.014189, 2.260344, -0.009419>, <-0.060811, 2.260344, -0.009419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.189189, 1.993044, -0.009542>, <0.189189, 1.954875, 0.013143>, <0.189189, 1.922446, 0.066283>, <0.189189, 1.892189, 0.098780>, 
      <0.114189, 1.993044, -0.009542>, <0.114189, 1.954875, 0.013143>, <0.114189, 1.922446, 0.066283>, <0.114189, 1.892189, 0.098780>, 
      <0.014189, 1.993044, -0.009542>, <0.014189, 1.954875, 0.013143>, <0.014189, 1.922446, 0.066283>, <0.014189, 1.892189, 0.098780>, 
      <-0.060811, 1.993044, -0.009542>, <-0.060811, 1.954875, 0.013143>, <-0.060811, 1.922446, 0.066283>, <-0.060811, 1.892189, 0.098780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.189189, 1.993044, -0.009542>, <0.114189, 1.993044, -0.009542>, <0.014189, 1.993044, -0.009542>, <-0.060811, 1.993044, -0.009542>, 
      <0.189189, 2.018186, -0.024484>, <0.114189, 2.018186, -0.024484>, <0.014189, 2.018186, -0.024484>, <-0.060811, 2.018186, -0.024484>, 
      <0.189189, 2.060843, -0.018850>, <0.114189, 2.060843, -0.018850>, <0.014189, 2.060843, -0.018850>, <-0.060811, 2.060843, -0.018850>, 
      <0.189189, 2.090090, -0.018837>, <0.114189, 2.090090, -0.018837>, <0.014189, 2.090090, -0.018837>, <-0.060811, 2.090090, -0.018837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 1.993044, -0.009542>, <0.439189, 1.954875, 0.013143>, <0.439189, 1.922446, 0.066283>, <0.439189, 1.892189, 0.098780>, 
      <0.364189, 1.993044, -0.009542>, <0.364189, 1.954875, 0.013143>, <0.364189, 1.922446, 0.066283>, <0.364189, 1.892189, 0.098780>, 
      <0.264189, 1.993044, -0.009542>, <0.264189, 1.954875, 0.013143>, <0.264189, 1.922446, 0.066283>, <0.264189, 1.892189, 0.098780>, 
      <0.189189, 1.993044, -0.009542>, <0.189189, 1.954875, 0.013143>, <0.189189, 1.922446, 0.066283>, <0.189189, 1.892189, 0.098780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 1.993044, -0.009542>, <0.514189, 1.993044, -0.009542>, <0.614189, 1.993044, -0.009542>, <0.689189, 1.993044, -0.009542>, 
      <0.439189, 1.954875, 0.013143>, <0.514189, 1.954875, 0.013143>, <0.614189, 1.954875, 0.013143>, <0.689189, 1.954875, 0.013143>, 
      <0.439189, 1.922446, 0.066283>, <0.514189, 1.922446, 0.066283>, <0.614189, 1.922446, 0.066283>, <0.689189, 1.922446, 0.066283>, 
      <0.439189, 1.892189, 0.098780>, <0.514189, 1.892189, 0.098780>, <0.614189, 1.892189, 0.098780>, <0.689189, 1.892189, 0.098780>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 2.090090, -0.018837>, <0.514189, 2.090090, -0.018837>, <0.614189, 2.090090, -0.018837>, <0.689189, 2.090090, -0.018837>, 
      <0.439189, 2.060843, -0.018850>, <0.514189, 2.060843, -0.018850>, <0.614189, 2.060843, -0.018850>, <0.689189, 2.060843, -0.018850>, 
      <0.439189, 2.018186, -0.024484>, <0.514189, 2.018186, -0.024484>, <0.614189, 2.018186, -0.024484>, <0.689189, 2.018186, -0.024484>, 
      <0.439189, 1.993044, -0.009542>, <0.514189, 1.993044, -0.009542>, <0.614189, 1.993044, -0.009542>, <0.689189, 1.993044, -0.009542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 2.090090, -0.018837>, <0.439189, 2.060843, -0.018850>, <0.439189, 2.018186, -0.024484>, <0.439189, 1.993044, -0.009542>, 
      <0.364189, 2.090090, -0.018837>, <0.364189, 2.060843, -0.018850>, <0.364189, 2.018186, -0.024484>, <0.364189, 1.993044, -0.009542>, 
      <0.264189, 2.090090, -0.018837>, <0.264189, 2.060843, -0.018850>, <0.264189, 2.018186, -0.024484>, <0.264189, 1.993044, -0.009542>, 
      <0.189189, 2.090090, -0.018837>, <0.189189, 2.060843, -0.018850>, <0.189189, 2.018186, -0.024484>, <0.189189, 1.993044, -0.009542>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 2.260344, -0.009419>, <0.437907, 2.300303, -0.001540>, <0.432530, 2.348756, 0.024923>, <0.429677, 2.386646, 0.039641>, 
      <0.514189, 2.260344, -0.009419>, <0.512907, 2.300303, -0.001540>, <0.503655, 2.346865, 0.039763>, <0.500802, 2.384755, 0.054481>, 
      <0.614189, 2.260344, -0.009419>, <0.607364, 2.310629, 0.018321>, <0.595775, 2.344778, 0.064776>, <0.584104, 2.379686, 0.109384>, 
      <0.689189, 2.260344, -0.009419>, <0.682364, 2.310629, 0.018321>, <0.661958, 2.341795, 0.094666>, <0.650288, 2.376703, 0.139274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 2.260344, -0.009419>, <0.364189, 2.260344, -0.009419>, <0.264189, 2.260344, -0.009419>, <0.189189, 2.260344, -0.009419>, 
      <0.437907, 2.300303, -0.001540>, <0.362907, 2.300303, -0.001540>, <0.261947, 2.301222, -0.001432>, <0.186946, 2.301222, -0.001432>, 
      <0.432530, 2.348756, 0.024923>, <0.357104, 2.350761, 0.009185>, <0.254721, 2.348294, 0.026420>, <0.177696, 2.350682, 0.024923>, 
      <0.429677, 2.386646, 0.039641>, <0.354251, 2.388652, 0.023903>, <0.249795, 2.387011, 0.041138>, <0.172770, 2.389399, 0.039641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 2.260344, -0.009419>, <0.514189, 2.260344, -0.009419>, <0.614189, 2.260344, -0.009419>, <0.689189, 2.260344, -0.009419>, 
      <0.440798, 2.210181, -0.019311>, <0.515798, 2.210181, -0.019311>, <0.620226, 2.215866, -0.033955>, <0.695226, 2.215866, -0.033955>, 
      <0.439189, 2.141244, -0.018814>, <0.514189, 2.141244, -0.018814>, <0.614189, 2.141244, -0.018814>, <0.689189, 2.141244, -0.018814>, 
      <0.439189, 2.090090, -0.018837>, <0.514189, 2.090090, -0.018837>, <0.614189, 2.090090, -0.018837>, <0.689189, 2.090090, -0.018837>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.439189, 2.260344, -0.009419>, <0.440798, 2.210181, -0.019311>, <0.439189, 2.141244, -0.018814>, <0.439189, 2.090090, -0.018837>, 
      <0.364189, 2.260344, -0.009419>, <0.365798, 2.210181, -0.019311>, <0.364189, 2.141244, -0.018814>, <0.364189, 2.090090, -0.018837>, 
      <0.264189, 2.260344, -0.009419>, <0.266939, 2.210212, -0.019214>, <0.264189, 2.141244, -0.018814>, <0.264189, 2.090090, -0.018837>, 
      <0.189189, 2.260344, -0.009419>, <0.191939, 2.210212, -0.019214>, <0.189189, 2.141244, -0.018814>, <0.189189, 2.090090, -0.018837>
    }
  }
  texture {
    PhotoSticky
    scale <0.958715, 0.619494, 0.612569>
    rotate -180.0*z
    translate <0.659663, 2.460019, 0.051637>
  }
  scale 0.857143
  rotate <-23.186808, -6.907879, 178.024689>
  translate  <-2.5, -0.935659, 10.732547>
}
#declare BtmLinkDone = difference {
  torus { // BtmChain
    1.5, 0.5  rotate -x*90
    scale <4.2, 4.2, 4.0>
    rotate -90.0*y
    translate  <3.378526, 0.044318, -31.754954>
  }
  box { // ChainCutter
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 5.0, 4.0>
    translate  <3.589684, 0.158292, -26.039568>
  }
  rotate -28.137209*z
  translate  <-0.071445, 1.559406, 0.0>
}
#declare S = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-0.796048, 0.827066>,
  <1.874436, 0.827066>,
  <2.002762, 0.989691>,
  <-1.203952, 0.991502>,
  <0.291832, -1.001309>,
  <-1.232212, -1.001046>,
  <-1.232212, -1.195709>,
  <0.55527, -1.193236>,
  <0.55527, -1.007308>,
  <-0.796048, 0.827066>
  rotate -x*90
  texture {
    Shiny_Green1
  }
}
#declare L = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <0.570468, -0.994428>,
  <2.002762, 0.990662>,
  <2.2229, 0.992573>,
  <0.787993, -1.000238>,
  <2.192197, -0.999975>,
  <2.192197, -1.195699>,
  <0.569425, -1.193236>,
  <0.570468, -0.994428>
  rotate -x*90
  texture {
    Shiny_Red1
  }
}
#declare Signature = union {
  object { S }
  object { L }
  scale <15.0, 15.0, 6.0>
  rotate <90.0, -0.0, -30.0>
  translate  <-3.234064, 6.831022, -57.685497>
}
#declare Chaindone = union {
  torus { // BtmChain1
    1.9, 0.1  rotate -x*90
    scale <2.5, 4.2, 4.0>
    rotate <-60.0, -90.0, 0.0>
    translate  <2.744957, 0.0, -40.047632>
  }
  object { BtmLinkDone }
  object { // ChainLeft1->ChainLeft
    ChainLeft
    rotate 180.0*z
    translate  6.0*x
  }
  object { ChainLeft }
  object { Signature }
  texture {
    Shiny_Gold1
  }
  scale 0.008571
  rotate <-0.0, -0.0, 54.17366>
  translate  <-4.179749, -1.460787, 8.860514>
}
union { // LampDone
  object { Armature }
  object { ShadeDone }
  cylinder { // LIght
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightbulb
    }
    no_shadow
    hollow
    scale <0.1, 0.2, 3.0>
    rotate <-90.0, 53.0, -90.0>
    translate  <-5.675986, -2.0, 9.8>
  }
  sphere { // lightend1
    <0,0,0>,1
    texture {
      Lightbulb
    }
    no_shadow
    hollow
    scale <0.1, 0.1, 0.2>
    rotate 53.0*x
    translate  <-2.676994, -2.0, 9.8>
  }
  sphere { // lightend2
    <0,0,0>,1
    texture {
      Lightbulb
    }
    no_shadow
    hollow
    scale <0.1, 0.1, 0.2>
    rotate 53.0*x
    translate  <-5.674094, -2.0, 9.8>
  }
  object { StickyNote }
  object { Chaindone }
  scale 3.5
  translate  <14.41256, 13.496308, -27.03>
}


union { // CoffeeHandle
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.217764, 0.000000, 3.250000>, <-3.203860, -0.000182, 3.169011>, <-3.109795, -0.002041, 3.046253>, <-3.027867, -0.002041, 3.052609>, 
      <-3.217764, 0.000000, 3.250000>, <-3.203860, 0.210294, 3.169011>, <-3.109795, 0.160010, 3.046253>, <-3.027867, 0.160010, 3.052609>, 
      <-3.217764, 0.000000, 3.250000>, <-3.203860, 0.210294, 3.169011>, <-3.215098, 0.405372, 3.102271>, <-3.005253, 0.405372, 3.118552>, 
      <-3.217764, 0.000000, 3.250000>, <-3.217764, 0.210476, 3.250000>, <-3.209846, 0.500000, 3.233720>, <-3.000000, 0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.217764, 0.000000, 3.250000>, <-3.203860, -0.000182, 3.169011>, <-3.109795, -0.002041, 3.046253>, <-3.027867, -0.002041, 3.052609>, 
      <-3.217764, 0.000000, 3.250000>, <-3.203860, -0.210659, 3.169011>, <-3.109795, -0.162955, 3.046253>, <-3.027867, -0.162955, 3.052609>, 
      <-3.217764, 0.000000, 3.250000>, <-3.203860, -0.210659, 3.169011>, <-3.215076, -0.406542, 3.102832>, <-3.005230, -0.406542, 3.119112>, 
      <-3.217764, 0.000000, 3.250000>, <-3.217764, -0.210476, 3.250000>, <-3.209846, -0.500000, 3.233720>, <-3.000000, -0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.217764, 0.000000, 3.250000>, <-3.217764, 0.210476, 3.250000>, <-3.209846, 0.500000, 3.233720>, <-3.000000, 0.500000, 3.250000>, 
      <-3.217764, -0.210476, 3.250000>, <-3.217764, 0.000000, 3.250000>, <-3.215098, 0.405372, 3.102271>, <-3.005253, 0.405372, 3.118552>, 
      <-3.209846, -0.500000, 3.233720>, <-3.215076, -0.406542, 3.102832>, <-3.027867, -0.000904, 3.052609>, <-3.027867, 0.160010, 3.052609>, 
      <-3.000000, -0.500000, 3.250000>, <-3.005230, -0.406542, 3.119112>, <-3.027867, -0.162955, 3.052609>, <-3.027867, -0.002041, 3.052609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.056340, 0.000000, 3.262524>, <-3.071263, -0.000175, 3.200747>, <-2.964503, -0.002041, 3.057525>, <-3.027867, -0.002041, 3.052609>, 
      <-3.056340, 0.000000, 3.262524>, <-3.071263, -0.194426, 3.200747>, <-2.964503, -0.162955, 3.057525>, <-3.027867, -0.162955, 3.052609>, 
      <-3.056340, 0.000000, 3.262524>, <-3.071263, -0.194426, 3.200747>, <-2.811562, -0.406542, 3.134138>, <-3.005230, -0.406542, 3.119112>, 
      <-3.056340, 0.000000, 3.262524>, <-3.056340, -0.194250, 3.262524>, <-2.806332, -0.500000, 3.265026>, <-3.000000, -0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.056340, 0.000000, 3.262524>, <-3.056340, -0.194250, 3.262524>, <-2.806332, -0.500000, 3.265026>, <-3.000000, -0.500000, 3.250000>, 
      <-3.071263, -0.000175, 3.200747>, <-3.071263, -0.194426, 3.200747>, <-3.016177, -0.500000, 3.248745>, <-3.209846, -0.500000, 3.233720>, 
      <-2.964503, -0.002041, 3.057525>, <-3.046431, -0.002041, 3.051169>, <-3.203860, -0.210659, 3.169011>, <-3.217764, -0.210476, 3.250000>, 
      <-3.027867, -0.002041, 3.052609>, <-3.109795, -0.002041, 3.046253>, <-3.203860, -0.000182, 3.169011>, <-3.217764, 0.000000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.056340, 0.000000, 3.262524>, <-3.071263, -0.000175, 3.200747>, <-2.964503, -0.002041, 3.057525>, <-3.027867, -0.002041, 3.052609>, 
      <-3.056340, 0.000000, 3.262524>, <-3.071263, 0.194075, 3.200747>, <-2.964503, 0.160010, 3.057525>, <-3.027867, 0.160010, 3.052609>, 
      <-3.056340, 0.000000, 3.262524>, <-3.071263, 0.194075, 3.200747>, <-2.811584, 0.405372, 3.133578>, <-3.005253, 0.405372, 3.118552>, 
      <-3.056340, 0.000000, 3.262524>, <-3.056340, 0.194250, 3.262524>, <-2.806332, 0.500000, 3.265026>, <-3.000000, 0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.056340, 0.000000, 3.262524>, <-3.056340, -0.194250, 3.262524>, <-2.806332, -0.500000, 3.265026>, <-3.000000, -0.500000, 3.250000>, 
      <-3.056340, 0.194250, 3.262524>, <-3.056340, 0.000000, 3.262524>, <-2.811562, -0.406542, 3.134138>, <-3.005230, -0.406542, 3.119112>, 
      <-2.806332, 0.500000, 3.265026>, <-2.811584, 0.405372, 3.133578>, <-3.027867, -0.000904, 3.052609>, <-3.027867, -0.162955, 3.052609>, 
      <-3.000000, 0.500000, 3.250000>, <-3.005253, 0.405372, 3.118552>, <-3.027867, 0.160010, 3.052609>, <-3.027867, -0.002041, 3.052609>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.056340, 0.000000, 3.262524>, <-3.071263, -0.000175, 3.200747>, <-2.964503, -0.002041, 3.057525>, <-3.027867, -0.002041, 3.052609>, 
      <-3.056340, 0.194250, 3.262524>, <-3.071263, 0.194075, 3.200747>, <-3.046431, -0.002041, 3.051169>, <-3.109795, -0.002041, 3.046253>, 
      <-2.806332, 0.500000, 3.265026>, <-3.016177, 0.500000, 3.248745>, <-3.203860, 0.210294, 3.169011>, <-3.203860, -0.000182, 3.169011>, 
      <-3.000000, 0.500000, 3.250000>, <-3.209846, 0.500000, 3.233720>, <-3.217764, 0.210476, 3.250000>, <-3.217764, 0.000000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.854116, 0.000000, 3.771882>, <-2.854116, -0.201192, 3.771882>, <-2.825317, -0.500000, 3.650180>, <-3.000000, -0.500000, 3.750000>, 
      <-2.959917, 0.000000, 3.646038>, <-2.959917, -0.201192, 3.646038>, <-2.893020, -0.500000, 3.516328>, <-3.067703, -0.500000, 3.616148>, 
      <-3.017735, 0.000454, 3.422336>, <-3.017735, -0.193797, 3.422336>, <-2.801456, -0.587119, 3.387036>, <-2.995125, -0.587119, 3.372010>, 
      <-3.056340, 0.000000, 3.262524>, <-3.056340, -0.194250, 3.262524>, <-2.806332, -0.500000, 3.265026>, <-3.000000, -0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.000000, 0.500000, 3.750000>, <-2.825317, 0.500000, 3.650180>, <-2.854116, 0.201192, 3.771882>, <-2.854116, 0.000000, 3.771882>, 
      <-3.071276, 0.497723, 3.618036>, <-2.896593, 0.497723, 3.518216>, <-2.959917, 0.201192, 3.646038>, <-2.959917, 0.000000, 3.646038>, 
      <-2.995138, 0.587590, 3.371673>, <-2.801470, 0.587590, 3.386699>, <-3.017735, 0.194704, 3.422336>, <-3.017735, 0.000454, 3.422336>, 
      <-3.000000, 0.500000, 3.250000>, <-2.806332, 0.500000, 3.265026>, <-3.056340, 0.194250, 3.262524>, <-3.056340, 0.000000, 3.262524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.183685, 0.000000, 3.960210>, <-3.183685, 0.221008, 3.960210>, <-3.191888, 0.500000, 3.859652>, <-3.000000, 0.500000, 3.750000>, 
      <-3.290656, 0.000000, 3.775663>, <-3.290656, 0.221008, 3.775663>, <-3.263164, 0.497723, 3.727688>, <-3.071276, 0.497723, 3.618036>, 
      <-3.253857, 0.000473, 3.460232>, <-3.253857, 0.210949, 3.460232>, <-3.204984, 0.587590, 3.355392>, <-2.995138, 0.587590, 3.371673>, 
      <-3.217764, 0.000000, 3.250000>, <-3.217764, 0.210476, 3.250000>, <-3.209846, 0.500000, 3.233720>, <-3.000000, 0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.183685, 0.000000, 3.960210>, <-3.290656, 0.000000, 3.775663>, <-3.253857, 0.000473, 3.460232>, <-3.217764, 0.000000, 3.250000>, 
      <-3.183685, -0.221008, 3.960210>, <-3.290656, -0.221008, 3.775663>, <-3.253857, -0.210004, 3.460232>, <-3.217764, -0.210476, 3.250000>, 
      <-3.191888, -0.500000, 3.859652>, <-3.259591, -0.500000, 3.725800>, <-3.204970, -0.587119, 3.355730>, <-3.209846, -0.500000, 3.233720>, 
      <-3.000000, -0.500000, 3.750000>, <-3.067703, -0.500000, 3.616148>, <-2.995125, -0.587119, 3.372010>, <-3.000000, -0.500000, 3.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.520270, 0.000000, 3.900150>, <-2.529466, -0.207210, 3.894020>, <-2.513139, -0.500000, 3.892044>, <-2.575075, -0.500000, 4.090090>, 
      <-2.626931, 0.000398, 3.888538>, <-2.636127, -0.206812, 3.882408>, <-2.672854, -0.500000, 3.858114>, <-2.734789, -0.500000, 4.056159>, 
      <-2.785072, 0.000000, 3.854006>, <-2.785072, -0.201192, 3.854006>, <-2.751620, -0.500000, 3.795881>, <-2.926303, -0.500000, 3.895701>, 
      <-2.854116, 0.000000, 3.771882>, <-2.854116, -0.201192, 3.771882>, <-2.825317, -0.500000, 3.650180>, <-3.000000, -0.500000, 3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.530030, 0.515015, 4.120120>, <-2.465509, 0.515015, 3.913806>, <-2.510690, 0.215861, 3.906536>, <-2.520270, 0.000000, 3.900150>, 
      <-2.705632, 0.515015, 4.082814>, <-2.641111, 0.515015, 3.876500>, <-2.617351, 0.216259, 3.894925>, <-2.626931, 0.000398, 3.888538>, 
      <-2.914696, 0.502725, 3.907935>, <-2.740013, 0.502725, 3.808115>, <-2.785072, 0.201192, 3.854006>, <-2.785072, 0.000000, 3.854006>, 
      <-3.000000, 0.500000, 3.750000>, <-2.825317, 0.500000, 3.650180>, <-2.854116, 0.201192, 3.771882>, <-2.854116, 0.000000, 3.771882>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.632640, 0.000000, 4.259465>, <-2.623348, 0.209387, 4.265660>, <-2.592616, 0.515015, 4.320246>, <-2.530030, 0.515015, 4.120120>, 
      <-2.818617, 0.000000, 4.231164>, <-2.809325, 0.209387, 4.237359>, <-2.768218, 0.515015, 4.282940>, <-2.705632, 0.515015, 4.082814>, 
      <-3.089347, 0.000000, 4.122964>, <-3.089347, 0.221008, 4.122964>, <-3.106583, 0.502725, 4.017587>, <-2.914696, 0.502725, 3.907935>, 
      <-3.183685, 0.000000, 3.960210>, <-3.183685, 0.221008, 3.960210>, <-3.191888, 0.500000, 3.859652>, <-3.000000, 0.500000, 3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.632640, 0.000000, 4.259465>, <-2.818617, 0.000000, 4.231164>, <-3.089347, 0.000000, 4.122964>, <-3.183685, 0.000000, 3.960210>, 
      <-2.641722, -0.204657, 4.253410>, <-2.827699, -0.204657, 4.225109>, <-3.089347, -0.221008, 4.122964>, <-3.183685, -0.221008, 3.960210>, 
      <-2.636247, -0.500000, 4.285696>, <-2.795962, -0.500000, 4.251765>, <-3.118191, -0.500000, 4.005353>, <-3.191888, -0.500000, 3.859652>, 
      <-2.575075, -0.500000, 4.090090>, <-2.734789, -0.500000, 4.056159>, <-2.926303, -0.500000, 3.895701>, <-3.000000, -0.500000, 3.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045796, -0.500000, 4.165165>, <-0.911882, -0.497298, 4.322388>, <-0.916265, -0.206541, 4.305255>, <-0.916265, 0.000000, 4.305255>, 
      <-1.498369, -0.500000, 4.243697>, <-1.364455, -0.497298, 4.400920>, <-1.420933, -0.206541, 4.408374>, <-1.420933, 0.000000, 4.408374>, 
      <-2.125766, -0.500000, 4.185544>, <-2.186939, -0.500000, 4.381150>, <-2.132489, -0.204657, 4.330903>, <-2.123407, 0.000000, 4.336958>, 
      <-2.575075, -0.500000, 4.090090>, <-2.636247, -0.500000, 4.285696>, <-2.641722, -0.204657, 4.253410>, <-2.632640, 0.000000, 4.259465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045796, -0.500000, 4.165165>, <-1.498369, -0.500000, 4.243697>, <-2.125766, -0.500000, 4.185544>, <-2.575075, -0.500000, 4.090090>, 
      <-1.187401, -0.502857, 3.998912>, <-1.639974, -0.502857, 4.077444>, <-2.063831, -0.500000, 3.987498>, <-2.513139, -0.500000, 3.892044>, 
      <-1.218935, -0.224510, 3.949902>, <-1.606935, -0.224510, 3.995672>, <-2.141073, -0.208660, 3.936303>, <-2.529466, -0.207210, 3.894020>, 
      <-1.218935, -0.006106, 3.949902>, <-1.606935, -0.006106, 3.995672>, <-2.131878, -0.001450, 3.942434>, <-2.520270, 0.000000, 3.900150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045796, 0.500000, 4.165165>, <-1.190076, 0.497089, 3.995772>, <-1.218935, 0.216423, 3.949902>, <-1.218935, -0.006106, 3.949902>, 
      <-1.482987, 0.503841, 4.250709>, <-1.627266, 0.500930, 4.081316>, <-1.606935, 0.216423, 3.995672>, <-1.606935, -0.006106, 3.995672>, 
      <-2.094258, 0.515015, 4.212698>, <-2.029736, 0.515015, 4.006385>, <-2.122298, 0.214410, 3.948820>, <-2.131878, -0.001450, 3.942434>, 
      <-2.530030, 0.515015, 4.120120>, <-2.465509, 0.515015, 3.913806>, <-2.510690, 0.215861, 3.906536>, <-2.520270, 0.000000, 3.900150>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.045796, 0.500000, 4.165165>, <-1.482987, 0.503841, 4.250709>, <-2.094258, 0.515015, 4.212698>, <-2.530030, 0.515015, 4.120120>, 
      <-0.911882, 0.502702, 4.322388>, <-1.349073, 0.506542, 4.407932>, <-2.156844, 0.515015, 4.412825>, <-2.592616, 0.515015, 4.320246>, 
      <-0.916265, 0.206541, 4.305255>, <-1.420933, 0.206541, 4.408374>, <-2.114114, 0.209387, 4.343153>, <-2.623348, 0.209387, 4.265660>, 
      <-0.916265, 0.000000, 4.305255>, <-1.420933, 0.000000, 4.408374>, <-2.123407, 0.000000, 4.336958>, <-2.632640, 0.000000, 4.259465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820859, -0.500000, 3.785691>, <-0.849986, -0.495586, 3.914710>, <-0.915405, -0.500000, 4.142539>, <-1.045796, -0.500000, 4.165165>, 
      <-1.030218, -0.500000, 3.735522>, <-1.059345, -0.495586, 3.864541>, <-1.057010, -0.502857, 3.976286>, <-1.187401, -0.502857, 3.998912>, 
      <-1.061376, -0.215286, 3.728055>, <-1.076712, -0.215581, 3.808253>, <-1.137845, -0.224510, 3.940336>, <-1.218935, -0.224510, 3.949902>, 
      <-1.061376, 0.000000, 3.728055>, <-1.076712, -0.000295, 3.808253>, <-1.137845, -0.006106, 3.940336>, <-1.218935, -0.006106, 3.949902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820859, -0.500000, 3.785691>, <-0.612721, -0.500000, 3.835568>, <-0.587565, -0.214031, 3.841596>, <-0.587565, 0.000000, 3.841596>, 
      <-0.849986, -0.495586, 3.914710>, <-0.641848, -0.495586, 3.964587>, <-0.634185, -0.214031, 4.005604>, <-0.634185, 0.000000, 4.005604>, 
      <-0.915405, -0.500000, 4.142539>, <-0.781491, -0.497298, 4.299762>, <-0.749211, -0.206541, 4.271121>, <-0.749211, 0.000000, 4.271121>, 
      <-1.045796, -0.500000, 4.165165>, <-0.911882, -0.497298, 4.322388>, <-0.916265, -0.206541, 4.305255>, <-0.916265, 0.000000, 4.305255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820859, 0.500000, 3.785691>, <-0.849986, 0.495586, 3.914710>, <-0.915924, 0.498859, 4.139753>, <-1.045796, 0.500000, 4.165165>, 
      <-0.612721, 0.500000, 3.835568>, <-0.641848, 0.495586, 3.964587>, <-0.782010, 0.501561, 4.296976>, <-0.911882, 0.502702, 4.322388>, 
      <-0.587565, 0.214031, 3.841596>, <-0.634185, 0.214031, 4.005604>, <-0.749211, 0.206541, 4.271121>, <-0.916265, 0.206541, 4.305255>, 
      <-0.587565, 0.000000, 3.841596>, <-0.634185, 0.000000, 4.005604>, <-0.749211, 0.000000, 4.271121>, <-0.916265, 0.000000, 4.305255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820859, 0.500000, 3.785691>, <-1.030218, 0.500000, 3.735522>, <-1.061376, 0.215286, 3.728055>, <-1.061376, 0.000000, 3.728055>, 
      <-0.849986, 0.495586, 3.914710>, <-1.059345, 0.495586, 3.864541>, <-1.076712, 0.214992, 3.808253>, <-1.076712, -0.000295, 3.808253>, 
      <-0.915924, 0.498859, 4.139753>, <-1.060204, 0.495948, 3.970360>, <-1.137845, 0.216423, 3.940336>, <-1.137845, -0.006106, 3.940336>, 
      <-1.045796, 0.500000, 4.165165>, <-1.190076, 0.497089, 3.995772>, <-1.218935, 0.216423, 3.949902>, <-1.218935, -0.006106, 3.949902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.343299, 0.000000, 2.289573>, <-0.355820, 0.000000, 2.760745>, <-0.458691, 0.000000, 3.388218>, <-0.587565, 0.000000, 3.841596>, 
      <-0.343299, -0.242917, 2.289573>, <-0.355820, -0.242917, 2.760745>, <-0.458691, -0.214031, 3.388218>, <-0.587565, -0.214031, 3.841596>, 
      <-0.379451, -0.564171, 2.289573>, <-0.395244, -0.564171, 2.742475>, <-0.512980, -0.515116, 3.393761>, <-0.612721, -0.500000, 3.835568>, 
      <-0.622368, -0.564171, 2.289573>, <-0.638161, -0.564171, 2.742475>, <-0.721118, -0.515116, 3.343884>, <-0.820859, -0.500000, 3.785691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.622368, 0.564171, 2.289573>, <-0.638161, 0.564171, 2.742475>, <-0.721118, 0.515116, 3.343884>, <-0.820859, 0.500000, 3.785691>, 
      <-0.379451, 0.564171, 2.289573>, <-0.395244, 0.564171, 2.742475>, <-0.512980, 0.515116, 3.393761>, <-0.612721, 0.500000, 3.835568>, 
      <-0.343299, 0.242917, 2.289573>, <-0.355820, 0.242917, 2.760745>, <-0.458691, 0.214031, 3.388218>, <-0.587565, 0.214031, 3.841596>, 
      <-0.343299, 0.000000, 2.289573>, <-0.355820, 0.000000, 2.760745>, <-0.458691, 0.000000, 3.388218>, <-0.587565, 0.000000, 3.841596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.901437, 0.000000, 2.289573>, <-0.921839, 0.000000, 2.723297>, <-0.979823, 0.001568, 3.301581>, <-1.061376, 0.000000, 3.728055>, 
      <-0.901437, 0.242917, 2.289573>, <-0.921839, 0.242917, 2.723297>, <-0.979823, 0.216855, 3.301581>, <-1.061376, 0.215286, 3.728055>, 
      <-0.865285, 0.564171, 2.289573>, <-0.881078, 0.564171, 2.742475>, <-0.930477, 0.515116, 3.293715>, <-1.030218, 0.500000, 3.735522>, 
      <-0.622368, 0.564171, 2.289573>, <-0.638161, 0.564171, 2.742475>, <-0.721118, 0.515116, 3.343884>, <-0.820859, 0.500000, 3.785691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.901437, 0.000000, 2.289573>, <-0.901437, -0.242917, 2.289573>, <-0.865285, -0.564171, 2.289573>, <-0.622368, -0.564171, 2.289573>, 
      <-0.921839, 0.000000, 2.723297>, <-0.921839, -0.242917, 2.723297>, <-0.881078, -0.564171, 2.742475>, <-0.638161, -0.564171, 2.742475>, 
      <-0.979823, 0.001568, 3.301581>, <-0.979823, -0.213718, 3.301581>, <-0.930477, -0.515116, 3.293715>, <-0.721118, -0.515116, 3.343884>, 
      <-1.061376, 0.000000, 3.728055>, <-1.061376, -0.215286, 3.728055>, <-1.030218, -0.500000, 3.735522>, <-0.820859, -0.500000, 3.785691>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.507504, 0.000000, 0.828823>, <-0.383519, 0.000000, 1.252020>, <-0.331585, 0.000000, 1.848743>, <-0.343299, 0.000000, 2.289573>, 
      <-0.507504, -0.215286, 0.828823>, <-0.383519, -0.215286, 1.252020>, <-0.331585, -0.242917, 1.848743>, <-0.343299, -0.242917, 2.289573>, 
      <-0.535297, -0.500000, 0.844765>, <-0.438010, -0.514259, 1.235461>, <-0.365411, -0.564171, 1.886939>, <-0.379451, -0.564171, 2.289573>, 
      <-0.722041, -0.500000, 0.951886>, <-0.624755, -0.514259, 1.342582>, <-0.608328, -0.564171, 1.886939>, <-0.622368, -0.564171, 2.289573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.722041, 0.500000, 0.951886>, <-0.624755, 0.514259, 1.342582>, <-0.608328, 0.564171, 1.886939>, <-0.622368, 0.564171, 2.289573>, 
      <-0.535297, 0.500000, 0.844765>, <-0.438010, 0.514259, 1.235461>, <-0.365411, 0.564171, 1.886939>, <-0.379451, 0.564171, 2.289573>, 
      <-0.507504, 0.215286, 0.828823>, <-0.383519, 0.215286, 1.252020>, <-0.331585, 0.242917, 1.848743>, <-0.343299, 0.242917, 2.289573>, 
      <-0.507504, 0.000000, 0.828823>, <-0.383519, 0.000000, 1.252020>, <-0.331585, 0.000000, 1.848743>, <-0.343299, 0.000000, 2.289573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.936577, 0.000000, 1.074949>, <-0.866491, 0.000000, 1.432688>, <-0.884308, 0.000000, 1.925436>, <-0.901437, 0.000000, 2.289573>, 
      <-0.936577, 0.215286, 1.074949>, <-0.866491, 0.215286, 1.432688>, <-0.884308, 0.242917, 1.925436>, <-0.901437, 0.242917, 2.289573>, 
      <-0.908785, 0.500000, 1.059007>, <-0.811499, 0.514259, 1.449703>, <-0.851244, 0.564171, 1.886939>, <-0.865285, 0.564171, 2.289573>, 
      <-0.722041, 0.500000, 0.951886>, <-0.624755, 0.514259, 1.342582>, <-0.608328, 0.564171, 1.886939>, <-0.622368, 0.564171, 2.289573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.936577, 0.000000, 1.074949>, <-0.936577, -0.215286, 1.074949>, <-0.908785, -0.500000, 1.059007>, <-0.722041, -0.500000, 0.951886>, 
      <-0.866491, 0.000000, 1.432688>, <-0.866491, -0.215286, 1.432688>, <-0.811499, -0.514259, 1.449703>, <-0.624755, -0.514259, 1.342582>, 
      <-0.884308, 0.000000, 1.925436>, <-0.884308, -0.242917, 1.925436>, <-0.851244, -0.564171, 1.886939>, <-0.608328, -0.564171, 1.886939>, 
      <-0.901437, 0.000000, 2.289573>, <-0.901437, -0.242917, 2.289573>, <-0.865285, -0.564171, 2.289573>, <-0.622368, -0.564171, 2.289573>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.906880, 0.000000, 0.365914>, <-0.738762, 0.000000, 0.439242>, <-0.559072, 0.000000, 0.652807>, <-0.507504, 0.000000, 0.828823>, 
      <-0.906880, -0.211687, 0.365914>, <-0.738762, -0.211687, 0.439242>, <-0.559072, -0.215286, 0.652807>, <-0.507504, -0.215286, 0.828823>, 
      <-0.916274, -0.500000, 0.376047>, <-0.770752, -0.500000, 0.447013>, <-0.574393, -0.494270, 0.687757>, <-0.535297, -0.500000, 0.844765>, 
      <-1.060196, -0.500000, 0.531282>, <-0.914673, -0.500000, 0.602248>, <-0.761137, -0.494270, 0.794877>, <-0.722041, -0.500000, 0.951886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.060196, 0.500000, 0.531282>, <-0.914673, 0.500000, 0.602248>, <-0.761137, 0.494270, 0.794877>, <-0.722041, 0.500000, 0.951886>, 
      <-0.916274, 0.500000, 0.376047>, <-0.770752, 0.500000, 0.447013>, <-0.574393, 0.494270, 0.687757>, <-0.535297, 0.500000, 0.844765>, 
      <-0.906880, 0.211687, 0.365914>, <-0.738762, 0.211687, 0.439242>, <-0.559072, 0.215286, 0.652807>, <-0.507504, 0.215286, 0.828823>, 
      <-0.906880, 0.000000, 0.365914>, <-0.738762, 0.000000, 0.439242>, <-0.559072, 0.000000, 0.652807>, <-0.507504, 0.000000, 0.828823>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.213511, 0.000000, 0.696649>, <-1.090973, 0.000000, 0.765690>, <-0.963618, 0.000000, 0.936923>, <-0.936577, 0.000000, 1.074949>, 
      <-1.213511, 0.211687, 0.696649>, <-1.090973, 0.211687, 0.765690>, <-0.963618, 0.215286, 0.936923>, <-0.936577, 0.215286, 1.074949>, 
      <-1.204118, 0.500000, 0.686517>, <-1.058595, 0.500000, 0.757483>, <-0.947882, 0.494270, 0.901998>, <-0.908785, 0.500000, 1.059007>, 
      <-1.060196, 0.500000, 0.531282>, <-0.914673, 0.500000, 0.602248>, <-0.761137, 0.494270, 0.794877>, <-0.722041, 0.500000, 0.951886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.213511, 0.000000, 0.696649>, <-1.213511, -0.211687, 0.696649>, <-1.204118, -0.500000, 0.686517>, <-1.060196, -0.500000, 0.531282>, 
      <-1.090973, 0.000000, 0.765690>, <-1.090973, -0.211687, 0.765690>, <-1.058595, -0.500000, 0.757483>, <-0.914673, -0.500000, 0.602248>, 
      <-0.963618, 0.000000, 0.936923>, <-0.963618, -0.215286, 0.936923>, <-0.947882, -0.494270, 0.901998>, <-0.761137, -0.494270, 0.794877>, 
      <-0.936577, 0.000000, 1.074949>, <-0.936577, -0.215286, 1.074949>, <-0.908785, -0.500000, 1.059007>, <-0.722041, -0.500000, 0.951886>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.772772, 0.000000, 0.276952>, <-1.511677, 0.000000, 0.281534>, <-1.146238, 0.000000, 0.261514>, <-0.906880, 0.000000, 0.365914>, 
      <-1.772772, -0.202281, 0.276952>, <-1.511677, -0.202281, 0.281534>, <-1.146238, -0.211687, 0.261514>, <-0.906880, -0.211687, 0.365914>, 
      <-1.769367, -0.500000, 0.231992>, <-1.550288, -0.500000, 0.241780>, <-1.113383, -0.500000, 0.279924>, <-0.916274, -0.500000, 0.376047>, 
      <-1.784645, -0.500000, 0.433695>, <-1.565566, -0.500000, 0.443483>, <-1.257305, -0.500000, 0.435160>, <-1.060196, -0.500000, 0.531282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.784645, 0.500000, 0.433695>, <-1.565566, 0.500000, 0.443483>, <-1.257305, 0.500000, 0.435160>, <-1.060196, 0.500000, 0.531282>, 
      <-1.769367, 0.500000, 0.231992>, <-1.550288, 0.500000, 0.241780>, <-1.113383, 0.500000, 0.279924>, <-0.916274, 0.500000, 0.376047>, 
      <-1.772772, 0.202281, 0.276952>, <-1.511677, 0.202281, 0.281534>, <-1.146238, 0.211687, 0.261514>, <-0.906880, 0.211687, 0.365914>, 
      <-1.772772, 0.000000, 0.276952>, <-1.511677, 0.000000, 0.281534>, <-1.146238, 0.000000, 0.261514>, <-0.906880, 0.000000, 0.365914>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.796517, 0.000000, 0.590437>, <-1.619345, 0.000000, 0.605138>, <-1.368399, 0.000000, 0.609381>, <-1.213511, 0.000000, 0.696649>, 
      <-1.796517, 0.202281, 0.590437>, <-1.619345, 0.202281, 0.605138>, <-1.368399, 0.211687, 0.609381>, <-1.213511, 0.211687, 0.696649>, 
      <-1.799923, 0.500000, 0.635398>, <-1.580844, 0.500000, 0.645185>, <-1.401226, 0.500000, 0.590395>, <-1.204118, 0.500000, 0.686517>, 
      <-1.784645, 0.500000, 0.433695>, <-1.565566, 0.500000, 0.443483>, <-1.257305, 0.500000, 0.435160>, <-1.060196, 0.500000, 0.531282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.796517, 0.000000, 0.590437>, <-1.796517, -0.202281, 0.590437>, <-1.799923, -0.500000, 0.635398>, <-1.784645, -0.500000, 0.433695>, 
      <-1.619345, 0.000000, 0.605138>, <-1.619345, -0.202281, 0.605138>, <-1.580844, -0.500000, 0.645185>, <-1.565566, -0.500000, 0.443483>, 
      <-1.368399, 0.000000, 0.609381>, <-1.368399, -0.211687, 0.609381>, <-1.401226, -0.500000, 0.590395>, <-1.257305, -0.500000, 0.435160>, 
      <-1.213511, 0.000000, 0.696649>, <-1.213511, -0.211687, 0.696649>, <-1.204118, -0.500000, 0.686517>, <-1.060196, -0.500000, 0.531282>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.718364, 0.000000, 0.334121>, <-2.448822, 0.000000, 0.244042>, <-2.056924, 0.000000, 0.271965>, <-1.772772, 0.000000, 0.276952>, 
      <-2.718364, -0.203745, 0.334121>, <-2.448822, -0.203745, 0.244042>, <-2.056924, -0.202281, 0.271965>, <-1.772772, -0.202281, 0.276952>, 
      <-2.740844, -0.500000, 0.308177>, <-2.506785, -0.500000, 0.229340>, <-2.016101, -0.500000, 0.220969>, <-1.769367, -0.500000, 0.231992>, 
      <-2.607419, -0.500000, 0.462157>, <-2.373360, -0.500000, 0.383320>, <-2.031379, -0.500000, 0.422672>, <-1.784645, -0.500000, 0.433695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.607419, 0.500000, 0.462157>, <-2.373360, 0.500000, 0.383320>, <-2.031379, 0.500000, 0.422672>, <-1.784645, 0.500000, 0.433695>, 
      <-2.740844, 0.500000, 0.308177>, <-2.506785, 0.500000, 0.229340>, <-2.016101, 0.500000, 0.220969>, <-1.769367, 0.500000, 0.231992>, 
      <-2.718364, 0.203745, 0.334121>, <-2.448822, 0.203745, 0.244042>, <-2.056924, 0.202281, 0.271965>, <-1.772772, 0.202281, 0.276952>, 
      <-2.718364, 0.000000, 0.334121>, <-2.448822, 0.000000, 0.244042>, <-2.056924, 0.000000, 0.271965>, <-1.772772, 0.000000, 0.276952>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.496476, 0.000000, 0.590193>, <-2.289940, 0.000000, 0.552275>, <-2.005785, 0.000000, 0.573073>, <-1.796517, 0.000000, 0.590437>, 
      <-2.496476, 0.203745, 0.590193>, <-2.289940, 0.203745, 0.552275>, <-2.005785, 0.202281, 0.573073>, <-1.796517, 0.202281, 0.590437>, 
      <-2.473994, 0.500000, 0.616137>, <-2.239935, 0.500000, 0.537300>, <-2.046657, 0.500000, 0.624374>, <-1.799923, 0.500000, 0.635398>, 
      <-2.607419, 0.500000, 0.462157>, <-2.373360, 0.500000, 0.383320>, <-2.031379, 0.500000, 0.422672>, <-1.784645, 0.500000, 0.433695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.496476, 0.000000, 0.590193>, <-2.496476, -0.203745, 0.590193>, <-2.473994, -0.500000, 0.616137>, <-2.607419, -0.500000, 0.462157>, 
      <-2.289940, 0.000000, 0.552275>, <-2.289940, -0.203745, 0.552275>, <-2.239935, -0.500000, 0.537300>, <-2.373360, -0.500000, 0.383320>, 
      <-2.005785, 0.000000, 0.573073>, <-2.005785, -0.202281, 0.573073>, <-2.046657, -0.500000, 0.624374>, <-2.031379, -0.500000, 0.422672>, 
      <-1.796517, 0.000000, 0.590437>, <-1.796517, -0.202281, 0.590437>, <-1.799923, -0.500000, 0.635398>, <-1.784645, -0.500000, 0.433695>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.223786, 0.000000, 0.761872>, <-3.124891, 0.000000, 0.589600>, <-2.906762, 0.000000, 0.397083>, <-2.718364, 0.000000, 0.334121>, 
      <-3.223786, -0.211466, 0.761872>, <-3.124891, -0.211466, 0.589600>, <-2.906762, -0.203745, 0.397083>, <-2.718364, -0.203745, 0.334121>, 
      <-3.227569, -0.500000, 0.826856>, <-3.104620, -0.500000, 0.710843>, <-2.901044, -0.500000, 0.362136>, <-2.740844, -0.500000, 0.308177>, 
      <-3.017252, -0.500000, 0.848867>, <-2.894302, -0.500000, 0.732854>, <-2.767619, -0.500000, 0.516116>, <-2.607419, -0.500000, 0.462157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.017252, 0.500000, 0.848867>, <-2.894302, 0.500000, 0.732854>, <-2.767619, 0.500000, 0.516116>, <-2.607419, 0.500000, 0.462157>, 
      <-3.227569, 0.500000, 0.826856>, <-3.104620, 0.500000, 0.710843>, <-2.901044, 0.500000, 0.362136>, <-2.740844, 0.500000, 0.308177>, 
      <-3.223786, 0.211466, 0.761872>, <-3.124891, 0.211466, 0.589600>, <-2.906762, 0.203745, 0.397083>, <-2.718364, 0.203745, 0.334121>, 
      <-3.223786, 0.000000, 0.761872>, <-3.124891, 0.000000, 0.589600>, <-2.906762, 0.000000, 0.397083>, <-2.718364, 0.000000, 0.334121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.017252, 0.500000, 0.848867>, <-3.017252, 0.200000, 0.848867>, <-3.017252, -0.200000, 0.848867>, <-3.017252, -0.500000, 0.848867>, 
      <-3.017252, 0.500000, 0.848867>, <-3.227569, 0.200000, 0.826856>, <-3.227569, -0.200000, 0.826856>, <-3.227569, -0.500000, 0.826856>, 
      <-3.017252, 0.500000, 0.848867>, <-3.227569, 0.200000, 0.826856>, <-3.223786, 0.000000, 0.761872>, <-3.223786, -0.211466, 0.761872>, 
      <-3.017252, 0.500000, 0.848867>, <-3.227569, 0.500000, 0.826856>, <-3.223786, 0.211466, 0.761872>, <-3.223786, 0.000000, 0.761872>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.909486, 0.000000, 0.794766>, <-2.810847, 0.000000, 0.697871>, <-2.632473, 0.000000, 0.615161>, <-2.496476, 0.000000, 0.590193>, 
      <-2.909486, 0.198501, 0.794766>, <-2.810847, 0.198501, 0.697871>, <-2.632473, 0.203745, 0.615161>, <-2.496476, 0.203745, 0.590193>, 
      <-2.819829, 0.500000, 0.869529>, <-2.696879, 0.500000, 0.753516>, <-2.634194, 0.500000, 0.670096>, <-2.473994, 0.500000, 0.616137>, 
      <-3.017252, 0.500000, 0.848867>, <-2.894302, 0.500000, 0.732854>, <-2.767619, 0.500000, 0.516116>, <-2.607419, 0.500000, 0.462157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.909486, 0.000000, 0.794766>, <-2.909486, -0.198501, 0.794766>, <-2.819829, -0.500000, 0.869529>, <-3.017252, -0.500000, 0.848867>, 
      <-2.810847, 0.000000, 0.697871>, <-2.810847, -0.198501, 0.697871>, <-2.696879, -0.500000, 0.753516>, <-2.894302, -0.500000, 0.732854>, 
      <-2.632473, 0.000000, 0.615161>, <-2.632473, -0.203745, 0.615161>, <-2.634194, -0.500000, 0.670096>, <-2.767619, -0.500000, 0.516116>, 
      <-2.496476, 0.000000, 0.590193>, <-2.496476, -0.203745, 0.590193>, <-2.473994, -0.500000, 0.616137>, <-2.607419, -0.500000, 0.462157>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.909486, 0.000000, 0.794766>, <-2.909486, -0.198501, 0.794766>, <-2.819829, -0.500000, 0.869529>, <-3.017252, -0.500000, 0.848867>, 
      <-2.909486, 0.000000, 0.794766>, <-2.909486, 0.000000, 0.794766>, <-2.819829, -0.200000, 0.869529>, <-3.017252, -0.200000, 0.848867>, 
      <-2.909486, 0.000000, 0.794766>, <-2.909486, 0.000000, 0.794766>, <-2.819829, 0.200000, 0.869529>, <-3.017252, 0.200000, 0.848867>, 
      <-2.909486, 0.000000, 0.794766>, <-2.909486, 0.198501, 0.794766>, <-2.819829, 0.500000, 0.869529>, <-3.017252, 0.500000, 0.848867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.221565, 0.000000, 1.210684>, <-3.201968, -0.000822, 1.287627>, <-3.135824, -0.007009, 1.424955>, <-3.056755, -0.007009, 1.417671>, 
      <-3.221565, 0.000000, 1.210684>, <-3.201968, -0.206687, 1.287627>, <-3.135824, -0.166469, 1.424955>, <-3.056755, -0.166469, 1.417671>, 
      <-3.221565, 0.000000, 1.210684>, <-3.201968, -0.206687, 1.287627>, <-3.247206, -0.352103, 1.298217>, <-3.042209, -0.352103, 1.279334>, 
      <-3.221565, 0.000000, 1.210684>, <-3.221565, -0.205865, 1.210684>, <-3.240972, -0.500000, 1.238930>, <-3.035975, -0.500000, 1.220046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.221565, 0.000000, 1.210684>, <-3.254796, 0.001394, 1.080211>, <-3.290820, 0.000000, 0.878644>, <-3.223786, 0.000000, 0.761872>, 
      <-3.221565, -0.205865, 1.210684>, <-3.254796, -0.204471, 1.080211>, <-3.290820, -0.211466, 0.878644>, <-3.223786, -0.211466, 0.761872>, 
      <-3.240972, -0.500000, 1.238930>, <-3.235355, -0.500000, 1.127576>, <-3.233186, -0.500000, 0.938209>, <-3.227569, -0.500000, 0.826856>, 
      <-3.035975, -0.500000, 1.220046>, <-3.030358, -0.500000, 1.108692>, <-3.022869, -0.500000, 0.960221>, <-3.017252, -0.500000, 0.848867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.221565, 0.000000, 1.210684>, <-3.254796, 0.001394, 1.080211>, <-3.290820, 0.000000, 0.878644>, <-3.223786, 0.000000, 0.761872>, 
      <-3.221565, 0.205865, 1.210684>, <-3.254796, 0.207260, 1.080211>, <-3.290820, 0.211466, 0.878644>, <-3.223786, 0.211466, 0.761872>, 
      <-3.240972, 0.500000, 1.238930>, <-3.235355, 0.500000, 1.127576>, <-3.233186, 0.500000, 0.938209>, <-3.227569, 0.500000, 0.826856>, 
      <-3.035975, 0.500000, 1.220046>, <-3.030358, 0.500000, 1.108692>, <-3.022869, 0.500000, 0.960221>, <-3.017252, 0.500000, 0.848867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.221565, 0.000000, 1.210684>, <-3.221565, -0.205865, 1.210684>, <-3.240972, -0.500000, 1.238930>, <-3.035975, -0.500000, 1.220046>, 
      <-3.221565, 0.205865, 1.210684>, <-3.221565, 0.000000, 1.210684>, <-3.247206, -0.352103, 1.298217>, <-3.042209, -0.352103, 1.279334>, 
      <-3.240972, 0.500000, 1.238930>, <-3.247206, 0.347897, 1.298217>, <-3.056755, -0.003101, 1.417671>, <-3.056755, -0.166469, 1.417671>, 
      <-3.035975, 0.500000, 1.220046>, <-3.042209, 0.347897, 1.279334>, <-3.056755, 0.156359, 1.417671>, <-3.056755, -0.007009, 1.417671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.221565, 0.000000, 1.210684>, <-3.201968, -0.000822, 1.287627>, <-3.135824, -0.007009, 1.424955>, <-3.056755, -0.007009, 1.417671>, 
      <-3.221565, 0.000000, 1.210684>, <-3.201968, 0.205043, 1.287627>, <-3.135824, 0.156359, 1.424955>, <-3.056755, 0.156359, 1.417671>, 
      <-3.221565, 0.000000, 1.210684>, <-3.201968, 0.205043, 1.287627>, <-3.247206, 0.347897, 1.298217>, <-3.042209, 0.347897, 1.279334>, 
      <-3.221565, 0.000000, 1.210684>, <-3.221565, 0.205865, 1.210684>, <-3.240972, 0.500000, 1.238930>, <-3.035975, 0.500000, 1.220046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.086926, 0.001501, 1.067772>, <-3.007292, 0.000000, 0.890842>, <-2.909486, 0.000000, 0.794766>, 
      <-3.118468, 0.195713, 1.201187>, <-3.086926, 0.197214, 1.067772>, <-3.007292, 0.198501, 0.890842>, <-2.909486, 0.198501, 0.794766>, 
      <-2.841087, 0.500000, 1.202093>, <-2.835470, 0.500000, 1.090740>, <-2.825446, 0.500000, 0.980883>, <-2.819829, 0.500000, 0.869529>, 
      <-3.035975, 0.500000, 1.220046>, <-3.030358, 0.500000, 1.108692>, <-3.022869, 0.500000, 0.960221>, <-3.017252, 0.500000, 0.848867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.134012, -0.000740, 1.266936>, <-2.989475, -0.007009, 1.411474>, <-3.056755, -0.007009, 1.417671>, 
      <-3.118468, 0.000000, 1.201187>, <-3.134012, 0.194973, 1.266936>, <-2.989475, 0.156359, 1.411474>, <-3.056755, 0.156359, 1.417671>, 
      <-3.118468, 0.000000, 1.201187>, <-3.134012, 0.194973, 1.266936>, <-2.847321, 0.347897, 1.261381>, <-3.042209, 0.347897, 1.279334>, 
      <-3.118468, 0.000000, 1.201187>, <-3.118468, 0.195713, 1.201187>, <-2.841087, 0.500000, 1.202093>, <-3.035975, 0.500000, 1.220046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.134012, -0.000740, 1.266936>, <-2.989475, -0.007009, 1.411474>, <-3.056755, -0.007009, 1.417671>, 
      <-3.118468, 0.195713, 1.201187>, <-3.134012, 0.194973, 1.266936>, <-3.068544, -0.007009, 1.418757>, <-3.135824, -0.007009, 1.424955>, 
      <-2.841087, 0.500000, 1.202093>, <-3.046084, 0.500000, 1.220977>, <-3.201968, 0.205043, 1.287627>, <-3.201968, -0.000822, 1.287627>, 
      <-3.035975, 0.500000, 1.220046>, <-3.240972, 0.500000, 1.238930>, <-3.221565, 0.205865, 1.210684>, <-3.221565, 0.000000, 1.210684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.134012, -0.000740, 1.266936>, <-2.989475, -0.007009, 1.411474>, <-3.056755, -0.007009, 1.417671>, 
      <-3.118468, -0.195713, 1.201187>, <-3.134012, -0.196453, 1.266936>, <-3.068544, -0.007009, 1.418757>, <-3.135824, -0.007009, 1.424955>, 
      <-2.841087, -0.500000, 1.202093>, <-3.046084, -0.500000, 1.220977>, <-3.201968, -0.206687, 1.287627>, <-3.201968, -0.000822, 1.287627>, 
      <-3.035975, -0.500000, 1.220046>, <-3.240972, -0.500000, 1.238930>, <-3.221565, -0.205865, 1.210684>, <-3.221565, 0.000000, 1.210684>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.118468, 0.195713, 1.201187>, <-2.841087, 0.500000, 1.202093>, <-3.035975, 0.500000, 1.220046>, 
      <-3.118468, -0.195713, 1.201187>, <-3.118468, 0.000000, 1.201187>, <-2.847321, 0.347897, 1.261381>, <-3.042209, 0.347897, 1.279334>, 
      <-2.841087, -0.500000, 1.202093>, <-2.847321, -0.352103, 1.261381>, <-3.056755, -0.003101, 1.417671>, <-3.056755, 0.156359, 1.417671>, 
      <-3.035975, -0.500000, 1.220046>, <-3.042209, -0.352103, 1.279334>, <-3.056755, -0.166469, 1.417671>, <-3.056755, -0.007009, 1.417671>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.134012, -0.000740, 1.266936>, <-2.989475, -0.007009, 1.411474>, <-3.056755, -0.007009, 1.417671>, 
      <-3.118468, 0.000000, 1.201187>, <-3.134012, -0.196453, 1.266936>, <-2.989475, -0.166469, 1.411474>, <-3.056755, -0.166469, 1.417671>, 
      <-3.118468, 0.000000, 1.201187>, <-3.134012, -0.196453, 1.266936>, <-2.847321, -0.352103, 1.261381>, <-3.042209, -0.352103, 1.279334>, 
      <-3.118468, 0.000000, 1.201187>, <-3.118468, -0.195713, 1.201187>, <-2.841087, -0.500000, 1.202093>, <-3.035975, -0.500000, 1.220046>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.118468, 0.000000, 1.201187>, <-3.118468, -0.195713, 1.201187>, <-2.841087, -0.500000, 1.202093>, <-3.035975, -0.500000, 1.220046>, 
      <-3.086926, 0.001501, 1.067772>, <-3.086926, -0.194212, 1.067772>, <-2.835470, -0.500000, 1.090740>, <-3.030358, -0.500000, 1.108692>, 
      <-3.007292, 0.000000, 0.890842>, <-3.007292, -0.198501, 0.890842>, <-2.825446, -0.500000, 0.980883>, <-3.022869, -0.500000, 0.960221>, 
      <-2.909486, 0.000000, 0.794766>, <-2.909486, -0.198501, 0.794766>, <-2.819829, -0.500000, 0.869529>, <-3.017252, -0.500000, 0.848867>
    }
  }
  texture {
    Shiny_White
  }
  scale <0.8, 1.0, 1.0>
  rotate -19.0*z
  translate  <14.60039, 10.155044, 2.295744>
}


