#include "fish02a.pov"
#include "hfield1.pov"


#declare blobnum01 = 100;
#declare counter = 0;
#declare blobadd = .2;
#local   see01 = seed (123);

#declare bloby =
blob {
   threshold 1
   #while (counter < blobnum01 )
      #declare randmovy = rand (see01);
      #declare randmovz = rand (see01)*(counter/100);
      
      #declare counter2 = 0;
      #declare sdetails = 0.2;
      #declare bsize = 0.1; 
      
      #while ( counter2<1 )
         #if ( randmovy < counter2 )
            #declare bsize = 1-(counter2/4); 
         #end
         #declare counter2 = counter2 + sdetails;
      #end
      
      sphere {
         <0,0,0>,bsize/3,0.2/0.5
         translate <0,randmovy,1+(randmovz*1.2)>
         rotate y*(counter*3.6)
         rotate -20*z
         translate <0.3,-0.1,0>
      }
      
      sphere {
         <0,0,0>,bsize/4,0.2/0.5
         translate <0,randmovz,1+(randmovz*1.6)>
         rotate y*(counter*3.6)
         rotate -20*z
         translate <0.3,-0.1,0>
      }
      
      #if (counter < blobadd )
         #declare counter3 = 0;
         #declare blobdet3 = 0.2;
         #declare maxcyl03 = 6;
         #while ( counter3 < maxcyl03 )
            cylinder {
               <-3,0,-3> <-3,0,3> ,1 ,0.5
               translate <counter3,-.5,0>
            }
            #declare counter3 = counter3 + blobdet3;
         #end
      #end
      
      #declare counter = counter + blobadd;
   #end

   translate <0,-0.1,0>
   scale <2,2,1>
   scale 0.8
   translate <14,0,-4>
}

#declare wat01 = plane { y,0 }  

#declare wattex =
texture {
   pigment {
      bumps 
      color_map {
         [ 0 color rgbt <0.1,0.1,0.15,.99> ]  /// dodano /2 i ovje i ispod
         [ 1 color rgbt <0.1,0.1,0.15,.97> ]
      }
      scale 2
   } 
   normal {
      granite 0.40/2
      turbulence .5
      octaves 6
      lambda 1.5
      omega .6
      scale 2*2
   }
      finish {
         ambient 0.1
         diffuse 0.1
         phong 1
         phong_size 100
         reflection 0.6
      }
   }
   texture {
   pigment { color rgbt <0.2,0.2,0.25,0.9>   }
   normal {
      granite 0.2*4/2
      turbulence .2
      octaves 6
      lambda 2
      omega .2
      scale <5,2,2>*2
   }
}

merge {
   object { bloby }
   object { wat01 
      scale 1.5
   }
   texture { wattex scale 2.5}
     interior {
        refraction 1
        ior 1.33
        caustics 0.2
     }
   hollow
} 