//===================================================================================
//== textures from stones1.inc:
//==
// >>> T_Stone1 (from File "stones1.inc") <<<

// Constants from file "stones1.inc"
#declare T_Grnt7 = texture {
  pigment {
    granite
    turbulence 0.5
    color_map {
      [0.000, 0.153 color rgbf <0.439, 0.310, 0.282, 0.000>
      color rgbf <0.463, 0.369, 0.259, 0.000>]
      [0.153, 0.398 color rgbf <0.463, 0.369, 0.259, 0.000>
      color rgbf <0.541, 0.369, 0.298, 0.000>]
      [0.398, 0.559 color rgbf <0.541, 0.369, 0.298, 0.000>
      color rgbf <0.573, 0.424, 0.286, 0.000>]
      [0.559, 0.729 color rgbf <0.573, 0.424, 0.286, 0.000>
      color rgbf <0.494, 0.396, 0.306, 0.000>]
      [0.729, 1.001 color rgbf <0.494, 0.396, 0.306, 0.000>
      color rgbf <0.439, 0.310, 0.282, 0.000>]
    }
  }
}
#declare T_Grnt0a = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.153 color rgbf <0.729, 0.502, 0.451, 0.306>
      color rgbf <0.769, 0.686, 0.592, 0.792>]
      [0.153, 0.398 color rgbf <0.769, 0.686, 0.592, 0.792>
      color rgbf <0.843, 0.753, 0.718, 0.396>]
      [0.398, 0.559 color rgbf <0.843, 0.753, 0.718, 0.396>
      color rgbf <0.780, 0.667, 0.561, 0.976>]
      [0.559, 0.729 color rgbf <0.780, 0.667, 0.561, 0.976>
      color rgbf <0.741, 0.659, 0.576, 0.820>]
      [0.729, 1.001 color rgbf <0.741, 0.659, 0.576, 0.820>
      color rgbf <0.729, 0.502, 0.451, 0.306>]
    }
  }
}

#declare T_Stone1 = texture {
  T_Grnt7 scale <2, 3, 2> rotate <0, 0, 40>
}
texture {
  T_Grnt0a scale <2, 3, 2> rotate <0, 0,-30>
  finish {
    phong 1 phong_size 90
  }
}
// >>> T_Grnt28 (from File "stones1.inc") <<<
#declare T_Grnt28 = texture {
  pigment {
    marble
    turbulence 0.7
    color_map {
      [0.000, 0.155 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
      [0.155, 0.328 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.494, 0.243, 0.294, 0.000>]
      [0.328, 0.474 color rgbf <0.494, 0.243, 0.294, 0.000>
      color rgbf <0.769, 0.329, 0.373, 0.000>]
      [0.474, 0.647 color rgbf <0.769, 0.329, 0.373, 0.000>
      color rgbf <0.769, 0.329, 0.373, 0.000>]
      [0.647, 0.810 color rgbf <0.769, 0.329, 0.373, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
      [0.810, 0.922 color rgbf <0.686, 0.235, 0.282, 0.000>
      color rgbf <0.792, 0.388, 0.427, 0.000>]
      [0.922, 1.001 color rgbf <0.792, 0.388, 0.427, 0.000>
      color rgbf <0.686, 0.235, 0.282, 0.000>]
    }
  }
  finish {
    crand 0.03
  }
}
// >>> T_Grnt20 (from File "stones1.inc") <<<

// Constants from file "colors.inc"
#declare Black = rgb 0;
#declare Mica = color Black;
#declare White = rgb 1;

#declare T_Grnt20 = texture {
  pigment {
    granite
    turbulence 0.0
    color_map {
      [0.0, 0.3 color Mica color White]
      [0.3, 0.4 color White color White]
      [0.4, 0.6 color White color White]
      [0.6, 1.0 color White color White]
    }
  }
  finish {
    crand 0.02
  }
}
// >>> T_Grnt13 (from File "stones1.inc") <<<
#declare T_Grnt13 = texture {
  pigment {
    granite
    turbulence 0.6
    color_map {
      [0.000, 0.154 color rgbf <0.996, 0.824, 0.780, 0.000>
      color rgbf <0.996, 0.698, 0.624, 0.000>]
      [0.154, 0.308 color rgbf <0.996, 0.698, 0.624, 0.000>
      color rgbf <0.906, 0.675, 0.553, 0.000>]
      [0.308, 0.444 color rgbf <0.906, 0.675, 0.553, 0.000>
      color rgbf <0.996, 0.682, 0.604, 0.000>]
      [0.444, 0.615 color rgbf <0.996, 0.682, 0.604, 0.000>
      color rgbf <0.996, 0.824, 0.780, 0.000>]
      [0.615, 0.812 color rgbf <0.996, 0.824, 0.780, 0.000>
      color rgbf <0.973, 0.627, 0.627, 0.000>]
      [0.812, 1.001 color rgbf <0.973, 0.627, 0.627, 0.000>
      color rgbf <0.996, 0.824, 0.780, 0.000>]
    }
  }
}
// >>> T_Grnt23 (from File "stones1.inc") <<<
#declare T_Grnt23 = texture {
  pigment {
    marble
    turbulence 0.5
    color_map {
      [0.000, 0.178 color rgbf <0.831, 0.631, 0.569, 0.000>
      color rgbf <0.925, 0.831, 0.714, 0.000>]
      [0.178, 0.356 color rgbf <0.925, 0.831, 0.714, 0.000>
      color rgbf <0.871, 0.702, 0.659, 0.000>]
      [0.356, 0.525 color rgbf <0.871, 0.702, 0.659, 0.000>
      color rgbf <0.831, 0.631, 0.569, 0.000>]
      [0.525, 0.729 color rgbf <0.831, 0.631, 0.569, 0.000>
      color rgbf <0.937, 0.882, 0.820, 0.000>]
      [0.729, 1.001 color rgbf <0.937, 0.882, 0.820, 0.000>
      color rgbf <0.831, 0.631, 0.569, 0.000>]
    }
  }
}
// >>> T_Grnt26 (from File "stones1.inc") <<<
#declare T_Grnt26 = texture {
  pigment {
    granite
    color_map {
      [0.000, 0.241 color rgbf <0.973, 0.973, 0.976, 0.000>
      color rgbf <0.973, 0.973, 0.976, 0.000>]
      [0.241, 0.284 color rgbf <0.973, 0.973, 0.976, 0.000>
      color rgbf <0.600, 0.741, 0.608, 0.000>]
      [0.284, 0.336 color rgbf <0.600, 0.741, 0.608, 0.000>
      color rgbf <0.820, 0.643, 0.537, 0.000>]
      [0.336, 0.474 color rgbf <0.820, 0.643, 0.537, 0.000>
      color rgbf <0.886, 0.780, 0.714, 0.000>]
      [0.474, 0.810 color rgbf <0.886, 0.780, 0.714, 0.000>
      color rgbf <0.996, 0.643, 0.537, 0.000>]
      [0.810, 0.836 color rgbf <0.996, 0.643, 0.537, 0.000>
      color rgbf <0.973, 0.973, 0.976, 0.000>]
      [0.836, 1.001 color rgbf <0.973, 0.973, 0.976, 0.000>
      color rgbf <0.973, 0.973, 0.976, 0.000>]
    }
  }
  finish {
    crand 0.02
  }
}
//==
//===================================================================================

//===================================================================================
//== textures:
//==
#declare My_China_txtr_10 =
texture{ 
   pigment{ color rgb <0.7,0.7,0.7> }
   finish{ ambient 0.3
           diffuse 0.6
           brilliance 0.6
           specular 0.5
           roughness 0.001
           reflection 0.2
           reflection_exponent 0.3 }}
//==
//===================================================================================

//===================================================================================
//== Sky pigments
//==
#declare cv=3;
#declare Sky_pig1=
   pigment { 
      granite
      color_map {
         [ 0.000 0.470 color rgb < 0, 0, 0>*cv color rgb < 0, 0, 0> ]
         [ 0.470 0.480 color rgb <.4,.4,.5>*cv color rgb < 1, 1, 1>*cv ]
         [ 0.480 1.000 color rgb < 0, 0, 0>*cv color rgb < 0, 0, 0> ]
      }
      turbulence 1
      sine_wave
      scale 0.4
   }

#declare Sky_col1 = color rgbft <0.309804,0.184314,0.184314,0.6,0>;
#declare Sky_col2 = color rgbft <0.309804,0.184314,0.309804,0.1,0>;

#declare Sky_pig2=
   pigment {
      gradient y
      color_map {
         [ 0.5  color Sky_col1 ]
         [ 1.0  color 1.5*Sky_col2 ]
      }
      rotate 45*z
      translate -1
   }
//==
//===================================================================================

//===================================================================================
//== Red tree texture
//==
#declare Red_tree_xt=
   texture{ T_Grnt28
      scale 0.04
      normal{
         wood
         bump_size 0.5 
         turbulence 0.2
         scale 0.08
      }
   }
//==
//===================================================================================

//===================================================================================
//== CaHead textures
//==
#declare coef1 = 0.7;
#declare Leg_xt    =
 texture {
  pigment {
    granite
    turbulence 0.0
    color_map {
      [0.0, 0.3 color Mica color coef1*White]
      [0.3, 0.4 color coef1*White color coef1*White]
      [0.4, 0.6 color coef1*White color coef1*White]
      [0.6, 1.0 color coef1*White color coef1*White]
    }
  }
  finish {
    crand 0.02
  }
  normal{granite bump_size 0.2 scale 0.5 }
}

#declare Body_xt    = texture{ Leg_xt }
   
#declare Head_xt    =
   texture {
      gradient y
      texture_map {
         [0.2  T_Grnt20 normal{granite bump_size 0.2 scale 0.5 } translate -0.4*y]
         [0.6  T_Grnt20 normal{granite bump_size 0.2 scale 0.5 } translate -0.4*y]
         [0.7  T_Grnt28 normal{bumps   bump_size 0.5 scale 0.2 }                 ]//13
         [0.9  T_Grnt28 normal{bumps   bump_size 0.5 scale 0.2 }                 ]//13
      }
   }
  
#declare Chelicer_xt =
   texture {
      gradient z
      texture_map {
         [0.2  T_Grnt20        ]
         [0.3  T_Grnt20        ]
         [0.5  My_China_txtr_10]
         [0.9  My_China_txtr_10]
      }
   }
  
#declare Facet1_xt =
   texture{ T_Grnt26//T_Grnt23
      finish{
         specular 0.3
         roughness 0.004
         reflection 0.1
         reflection_exponent 0.5
         irid{ 0.15 thickness 2 turbulence 0.5
         }
      }
   }
   
#declare Feeler_xt  = texture{ T_Grnt20 }
//==
//===================================================================================
