//===================================================================================
//== Facet
//==
//===================================================================================
#macro B_ring( Number_of_elem, Big_R, param1, param2 )
   #local Small_r  = Big_R*sin(pi/Number_of_elem)/cos(radians(param1));
   #local Angle = 360/Number_of_elem;
   #local counter = 0;
   union{
      #while( counter < Number_of_elem/2 )
         sphere{ <Big_R,0,0>, Small_r 
            rotate (counter+(1-param2)*0.25)*Angle*z }
         #local counter = counter + 1;
      #end }
#end
//===================================================================================
//===================================================================================
#macro Facet1( Number_of_elem, Big_R, B, param1 )
   #local Bound = radians(B);
   #local k     = sin(pi/Number_of_elem)/cos(radians(param1));
   #local Alph  = 0;
   #local CC    = 1;
   union{
      #while( Alph < Bound )
         #if( Alph = 0 )
            object{ B_ring( Number_of_elem, Big_R*cos(Alph), param1, CC )}
         #else
            object{ B_ring( Number_of_elem, Big_R*cos(Alph), param1, CC ) translate  Big_R*sin(Alph)*z}
            object{ B_ring( Number_of_elem, Big_R*cos(Alph), param1, CC ) translate -Big_R*sin(Alph)*z}
         #end
         #local Alph = Alph + k*cos(Alph)*(1+sin(pi/4))/(1+cos(Alph));
         #local CC = CC*(-1);
      #end
   }
#end
//===================================================================================
//==
//== End Facet
//===================================================================================
