//===================================================================================
//== Element of feeler
//==
#declare Feelersel = 
   union{
      sor{
         13,
      	<0.000000,0.000000>,
      	<0.000010,0.000001>,
      	<0.132138,0.018877>,
      	<0.223826,0.107868>,
      	<0.258883,0.248096>,
      	<0.256186,0.431472>,
      	<0.256186,0.517766>,
      	<0.269670,0.644511>,
      	<0.269670,0.784739>,
      	<0.215736,0.900697>,
      	<0.110565,0.986991>,
      	<0.000010,1.000474>,
      	<0.000000,1.000475>
      	sturm
      }
      union{
         cylinder{<0,0,0>, <0,1,0>, 0.03 rotate 30*z }
         cylinder{<0,0,0>, <0,1,0>, 0.03 rotate 30*z rotate  90*y }
         cylinder{<0,0,0>, <0,1,0>, 0.03 rotate 30*z rotate 180*y }
         cylinder{<0,0,0>, <0,1,0>, 0.03 rotate 30*z rotate 270*y }
         translate 0.8*y
      }
   }
//== End element of feeler
//===================================================================================

//===================================================================================
//== Campodeoid's feeler:
//== Arguments:
//==   Number_of_elem -- Number of feeler elements.
//==   Curvature      -- This parameter affects shape of feeler. It should be >= 1.
//==
#macro Feeler1( Number_of_elem, Curvature )
   #local length  = 0.8/Curvature;
   #local Sf      = pow(0.1,1/Number_of_elem);
   #local curx    = 1;
   #local cury    = 0;
   #local counter = 0;
   merge{
      #while( counter < Number_of_elem )
         #local Angle = atan2( cury, sqrt( cury*cury + 1 ));
         object{ Feelersel
	         translate -0.1*y
            scale     <pow(Sf,counter)/Curvature,1/Curvature,pow(Sf,counter)/Curvature>
            rotate    -degrees(Angle)*z
            translate <curx,cury,0>
         }
         #local curx    = curx + sin(Angle)*length;
         #local cury    = cury + cos(Angle)*length;
         #local counter = counter + 1;
      #end
   translate -1*x
   scale Curvature
   }
#end
//== End of Campodeoid's feeler
//===================================================================================
