
 //  FILE NAME: fuselage.inc
 //    Bicubic patches for use with POV-Ray scene file - x1mach1.pov
 //    (see x1mach1.pov for additional information)
 //    Copyright 1998 David C. Hamilton
  
 //  FILE TYPE: .inc - POV-Ray Include File
 //    POV-Ray is a trademark of the POV-Team
 
 //    Bicubic patches were generated using sPatch
 //    sPatch is Copyright 1996-1998 by Mike Clifton
 
 /*  SPECIAL NOTES: Type 0 patches are used in this file. They can be changed to Type 1 if you
                    have sufficient memory available for rendering a lot of Type 1 patches.
                     
                    For a faster rendering X-1 image, reduce u_steps and v_steps in this file to 1.
                    They have already been reduced to 1 or 2 between Line 1228 & Line 1632 and to 1
                    from Line 2836 to the end of the file. This was done to avoid patch cracks in
                    the highly curved area of the aircraft nose (rather than playing around with the
                    flatness value). Reducing all u_steps and v_steps, however, will have a noticeable
                    affect on the curvature of the fuselage shape.  
 */
 
  #declare BasicFuselage =

    union {
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3265, -0.3020> <-0.0750, 0.3265, -0.3020> <-0.1778, 0.2838, -0.3020> <-0.2308, 0.2308, -0.3020>
		<0.0000, 0.3269, -0.3809> <-0.0750, 0.3269, -0.3809> <-0.1781, 0.2841, -0.3809> <-0.2311, 0.2311, -0.3809>
		<0.0000, 0.3266, -0.4860> <-0.0750, 0.3266, -0.4860> <-0.1779, 0.2839, -0.4860> <-0.2309, 0.2309, -0.4860>
		<0.0000, 0.3265, -0.5648> <-0.0750, 0.3265, -0.5648> <-0.1778, 0.2838, -0.5648> <-0.2308, 0.2308, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3265, -0.3020> <0.0000, 0.3260, -0.2114> <0.0000, 0.3249, -0.0906> <0.0000, 0.3236, 0.0000>
		<-0.0750, 0.3265, -0.3020> <-0.0750, 0.3260, -0.2114> <-0.0743, 0.3249, -0.0906> <-0.0743, 0.3236, 0.0000>
		<-0.1778, 0.2838, -0.3020> <-0.1775, 0.2835, -0.2114> <-0.1772, 0.2822, -0.0906> <-0.1762, 0.2813, 0.0000>
		<-0.2308, 0.2308, -0.3020> <-0.2305, 0.2305, -0.2114> <-0.2297, 0.2297, -0.0906> <-0.2288, 0.2288, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3265, -0.3020> <0.0000, 0.3269, -0.3809> <0.0000, 0.3266, -0.4860> <0.0000, 0.3265, -0.5648>
		<0.0750, 0.3265, -0.3020> <0.0750, 0.3269, -0.3809> <0.0750, 0.3266, -0.4860> <0.0750, 0.3265, -0.5648>
		<0.1778, 0.2838, -0.3020> <0.1781, 0.2841, -0.3809> <0.1779, 0.2839, -0.4860> <0.1778, 0.2838, -0.5648>
		<0.2308, 0.2308, -0.3020> <0.2311, 0.2311, -0.3809> <0.2309, 0.2309, -0.4860> <0.2308, 0.2308, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3265, -0.3020> <0.0750, 0.3265, -0.3020> <0.1778, 0.2838, -0.3020> <0.2308, 0.2308, -0.3020>
		<0.0000, 0.3260, -0.2114> <0.0750, 0.3260, -0.2114> <0.1775, 0.2835, -0.2114> <0.2305, 0.2305, -0.2114>
		<0.0000, 0.3249, -0.0906> <0.0743, 0.3249, -0.0906> <0.1772, 0.2822, -0.0906> <0.2297, 0.2297, -0.0906>
		<0.0000, 0.3236, 0.0000> <0.0743, 0.3236, 0.0000> <0.1762, 0.2813, 0.0000> <0.2288, 0.2288, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2308, 0.2308, -0.3020> <0.2311, 0.2311, -0.3809> <0.2309, 0.2309, -0.4860> <0.2308, 0.2308, -0.5648>
		<0.2838, 0.1778, -0.3020> <0.2841, 0.1781, -0.3809> <0.2839, 0.1779, -0.4860> <0.2838, 0.1778, -0.5648>
		<0.3265, 0.0750, -0.3020> <0.3269, 0.0750, -0.3809> <0.3266, 0.0750, -0.4860> <0.3265, 0.0750, -0.5648>
		<0.3265, 0.0000, -0.3020> <0.3269, 0.0000, -0.3809> <0.3266, 0.0000, -0.4860> <0.3265, 0.0000, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2308, 0.2308, -0.3020> <0.2838, 0.1778, -0.3020> <0.3265, 0.0750, -0.3020> <0.3265, 0.0000, -0.3020>
		<0.2305, 0.2305, -0.2114> <0.2835, 0.1775, -0.2114> <0.3260, 0.0750, -0.2114> <0.3260, 0.0000, -0.2114>
		<0.2297, 0.2297, -0.0906> <0.2822, 0.1772, -0.0906> <0.3249, 0.0743, -0.0906> <0.3249, 0.0000, -0.0906>
		<0.2288, 0.2288, 0.0000> <0.2813, 0.1762, 0.0000> <0.3236, 0.0743, 0.0000> <0.3236, 0.0000, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3265, 0.0000, -0.3020> <0.3269, 0.0000, -0.3809> <0.3266, 0.0000, -0.4860> <0.3265, 0.0000, -0.5648>
		<0.3265, -0.0750, -0.3020> <0.3269, -0.0750, -0.3809> <0.3266, -0.0750, -0.4860> <0.3265, -0.0750, -0.5648>
		<0.2838, -0.1778, -0.3020> <0.2841, -0.1781, -0.3809> <0.2839, -0.1779, -0.4860> <0.2838, -0.1778, -0.5648>
		<0.2308, -0.2308, -0.3020> <0.2311, -0.2311, -0.3809> <0.2309, -0.2309, -0.4860> <0.2308, -0.2308, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3265, 0.0000, -0.3020> <0.3265, -0.0750, -0.3020> <0.2838, -0.1778, -0.3020> <0.2308, -0.2308, -0.3020>
		<0.3260, 0.0000, -0.2114> <0.3260, -0.0750, -0.2114> <0.2835, -0.1775, -0.2114> <0.2305, -0.2305, -0.2114>
		<0.3249, 0.0000, -0.0906> <0.3249, -0.0743, -0.0906> <0.2822, -0.1772, -0.0906> <0.2297, -0.2297, -0.0906>
		<0.3236, 0.0000, 0.0000> <0.3236, -0.0743, 0.0000> <0.2813, -0.1762, 0.0000> <0.2288, -0.2288, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2308, -0.2308, -0.3020> <0.2311, -0.2311, -0.3809> <0.2309, -0.2309, -0.4860> <0.2308, -0.2308, -0.5648>
		<0.1778, -0.2838, -0.3020> <0.1781, -0.2841, -0.3809> <0.1779, -0.2839, -0.4860> <0.1778, -0.2838, -0.5648>
		<0.0750, -0.3265, -0.3020> <0.0750, -0.3269, -0.3809> <0.0750, -0.3266, -0.4860> <0.0750, -0.3265, -0.5648>
		<0.0000, -0.3265, -0.3020> <0.0000, -0.3269, -0.3809> <0.0000, -0.3266, -0.4860> <0.0000, -0.3265, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2308, -0.2308, -0.3020> <0.1778, -0.2838, -0.3020> <0.0750, -0.3265, -0.3020> <0.0000, -0.3265, -0.3020>
		<0.2305, -0.2305, -0.2114> <0.1775, -0.2835, -0.2114> <0.0750, -0.3260, -0.2114> <0.0000, -0.3260, -0.2114>
		<0.2297, -0.2297, -0.0906> <0.1772, -0.2822, -0.0906> <0.0743, -0.3249, -0.0906> <0.0000, -0.3249, -0.0906>
		<0.2288, -0.2288, 0.0000> <0.1762, -0.2813, 0.0000> <0.0743, -0.3236, 0.0000> <0.0000, -0.3236, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3265, -0.3020> <0.0000, -0.3269, -0.3809> <0.0000, -0.3266, -0.4860> <0.0000, -0.3265, -0.5648>
		<-0.0750, -0.3265, -0.3020> <-0.0750, -0.3269, -0.3809> <-0.0750, -0.3266, -0.4860> <-0.0750, -0.3265, -0.5648>
		<-0.1778, -0.2838, -0.3020> <-0.1781, -0.2841, -0.3809> <-0.1779, -0.2839, -0.4860> <-0.1778, -0.2838, -0.5648>
		<-0.2308, -0.2308, -0.3020> <-0.2311, -0.2311, -0.3809> <-0.2309, -0.2309, -0.4860> <-0.2308, -0.2308, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3265, -0.3020> <-0.0750, -0.3265, -0.3020> <-0.1778, -0.2838, -0.3020> <-0.2308, -0.2308, -0.3020>
		<0.0000, -0.3260, -0.2114> <-0.0750, -0.3260, -0.2114> <-0.1775, -0.2835, -0.2114> <-0.2305, -0.2305, -0.2114>
		<0.0000, -0.3249, -0.0906> <-0.0743, -0.3249, -0.0906> <-0.1772, -0.2822, -0.0906> <-0.2297, -0.2297, -0.0906>
		<0.0000, -0.3236, 0.0000> <-0.0743, -0.3236, 0.0000> <-0.1762, -0.2813, 0.0000> <-0.2288, -0.2288, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2308, -0.2308, -0.3020> <-0.2311, -0.2311, -0.3809> <-0.2309, -0.2309, -0.4860> <-0.2308, -0.2308, -0.5648>
		<-0.2838, -0.1778, -0.3020> <-0.2841, -0.1781, -0.3809> <-0.2839, -0.1779, -0.4860> <-0.2838, -0.1778, -0.5648>
		<-0.3265, -0.0750, -0.3020> <-0.3269, -0.0750, -0.3809> <-0.3266, -0.0750, -0.4860> <-0.3265, -0.0750, -0.5648>
		<-0.3265, 0.0000, -0.3020> <-0.3269, 0.0000, -0.3809> <-0.3266, 0.0000, -0.4860> <-0.3265, 0.0000, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2308, -0.2308, -0.3020> <-0.2838, -0.1778, -0.3020> <-0.3265, -0.0750, -0.3020> <-0.3265, 0.0000, -0.3020>
		<-0.2305, -0.2305, -0.2114> <-0.2835, -0.1775, -0.2114> <-0.3260, -0.0750, -0.2114> <-0.3260, 0.0000, -0.2114>
		<-0.2297, -0.2297, -0.0906> <-0.2822, -0.1772, -0.0906> <-0.3249, -0.0743, -0.0906> <-0.3249, 0.0000, -0.0906>
		<-0.2288, -0.2288, 0.0000> <-0.2813, -0.1762, 0.0000> <-0.3236, -0.0743, 0.0000> <-0.3236, 0.0000, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3265, 0.0000, -0.3020> <-0.3269, 0.0000, -0.3809> <-0.3266, 0.0000, -0.4860> <-0.3265, 0.0000, -0.5648>
		<-0.3265, 0.0750, -0.3020> <-0.3269, 0.0750, -0.3809> <-0.3266, 0.0750, -0.4860> <-0.3265, 0.0750, -0.5648>
		<-0.2838, 0.1778, -0.3020> <-0.2841, 0.1781, -0.3809> <-0.2839, 0.1779, -0.4860> <-0.2838, 0.1778, -0.5648>
		<-0.2308, 0.2308, -0.3020> <-0.2311, 0.2311, -0.3809> <-0.2309, 0.2309, -0.4860> <-0.2308, 0.2308, -0.5648>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3265, 0.0000, -0.3020> <-0.3265, 0.0750, -0.3020> <-0.2838, 0.1778, -0.3020> <-0.2308, 0.2308, -0.3020>
		<-0.3260, 0.0000, -0.2114> <-0.3260, 0.0750, -0.2114> <-0.2835, 0.1775, -0.2114> <-0.2305, 0.2305, -0.2114>
		<-0.3249, 0.0000, -0.0906> <-0.3249, 0.0743, -0.0906> <-0.2822, 0.1772, -0.0906> <-0.2297, 0.2297, -0.0906>
		<-0.3236, 0.0000, 0.0000> <-0.3236, 0.0743, 0.0000> <-0.2813, 0.1762, 0.0000> <-0.2288, 0.2288, 0.0000>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3265, -0.5648> <-0.0750, 0.3265, -0.5648> <-0.1778, 0.2838, -0.5648> <-0.2308, 0.2308, -0.5648>
		<0.0000, 0.3263, -0.6295> <-0.0750, 0.3263, -0.6295> <-0.1777, 0.2837, -0.6295> <-0.2307, 0.2307, -0.6295>
		<0.0000, 0.3277, -0.7157> <-0.0747, 0.3277, -0.7157> <-0.1788, 0.2845, -0.7157> <-0.2317, 0.2317, -0.7157>
		<0.0000, 0.3255, -0.7803> <-0.0747, 0.3255, -0.7803> <-0.1773, 0.2830, -0.7803> <-0.2301, 0.2301, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3265, -0.5648> <0.0000, 0.3263, -0.6295> <0.0000, 0.3277, -0.7157> <0.0000, 0.3255, -0.7803>
		<0.0750, 0.3265, -0.5648> <0.0750, 0.3263, -0.6295> <0.0747, 0.3277, -0.7157> <0.0747, 0.3255, -0.7803>
		<0.1778, 0.2838, -0.5648> <0.1777, 0.2837, -0.6295> <0.1788, 0.2845, -0.7157> <0.1773, 0.2830, -0.7803>
		<0.2308, 0.2308, -0.5648> <0.2307, 0.2307, -0.6295> <0.2317, 0.2317, -0.7157> <0.2301, 0.2301, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2308, 0.2308, -0.5648> <0.2307, 0.2307, -0.6295> <0.2317, 0.2317, -0.7157> <0.2301, 0.2301, -0.7803>
		<0.2838, 0.1778, -0.5648> <0.2837, 0.1777, -0.6295> <0.2845, 0.1788, -0.7157> <0.2830, 0.1773, -0.7803>
		<0.3265, 0.0750, -0.5648> <0.3263, 0.0750, -0.6295> <0.3277, 0.0747, -0.7157> <0.3255, 0.0747, -0.7803>
		<0.3265, 0.0000, -0.5648> <0.3263, 0.0000, -0.6295> <0.3277, 0.0000, -0.7157> <0.3255, 0.0000, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3265, 0.0000, -0.5648> <0.3263, 0.0000, -0.6295> <0.3277, 0.0000, -0.7157> <0.3255, 0.0000, -0.7803>
		<0.3265, -0.0750, -0.5648> <0.3263, -0.0750, -0.6295> <0.3277, -0.0747, -0.7157> <0.3255, -0.0747, -0.7803>
		<0.2838, -0.1778, -0.5648> <0.2837, -0.1777, -0.6295> <0.2845, -0.1788, -0.7157> <0.2830, -0.1773, -0.7803>
		<0.2308, -0.2308, -0.5648> <0.2307, -0.2307, -0.6295> <0.2317, -0.2317, -0.7157> <0.2301, -0.2301, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2308, -0.2308, -0.5648> <0.2307, -0.2307, -0.6295> <0.2317, -0.2317, -0.7157> <0.2301, -0.2301, -0.7803>
		<0.1778, -0.2838, -0.5648> <0.1777, -0.2837, -0.6295> <0.1788, -0.2845, -0.7157> <0.1773, -0.2830, -0.7803>
		<0.0750, -0.3265, -0.5648> <0.0750, -0.3263, -0.6295> <0.0747, -0.3277, -0.7157> <0.0747, -0.3255, -0.7803>
		<0.0000, -0.3265, -0.5648> <0.0000, -0.3263, -0.6295> <0.0000, -0.3277, -0.7157> <0.0000, -0.3255, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3265, -0.5648> <0.0000, -0.3263, -0.6295> <0.0000, -0.3277, -0.7157> <0.0000, -0.3255, -0.7803>
		<-0.0750, -0.3265, -0.5648> <-0.0750, -0.3263, -0.6295> <-0.0747, -0.3277, -0.7157> <-0.0747, -0.3255, -0.7803>
		<-0.1778, -0.2838, -0.5648> <-0.1777, -0.2837, -0.6295> <-0.1788, -0.2845, -0.7157> <-0.1773, -0.2830, -0.7803>
		<-0.2308, -0.2308, -0.5648> <-0.2307, -0.2307, -0.6295> <-0.2317, -0.2317, -0.7157> <-0.2301, -0.2301, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2308, -0.2308, -0.5648> <-0.2307, -0.2307, -0.6295> <-0.2317, -0.2317, -0.7157> <-0.2301, -0.2301, -0.7803>
		<-0.2838, -0.1778, -0.5648> <-0.2837, -0.1777, -0.6295> <-0.2845, -0.1788, -0.7157> <-0.2830, -0.1773, -0.7803>
		<-0.3265, -0.0750, -0.5648> <-0.3263, -0.0750, -0.6295> <-0.3277, -0.0747, -0.7157> <-0.3255, -0.0747, -0.7803>
		<-0.3265, 0.0000, -0.5648> <-0.3263, 0.0000, -0.6295> <-0.3277, 0.0000, -0.7157> <-0.3255, 0.0000, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3265, 0.0000, -0.5648> <-0.3263, 0.0000, -0.6295> <-0.3277, 0.0000, -0.7157> <-0.3255, 0.0000, -0.7803>
		<-0.3265, 0.0750, -0.5648> <-0.3263, 0.0750, -0.6295> <-0.3277, 0.0747, -0.7157> <-0.3255, 0.0747, -0.7803>
		<-0.2838, 0.1778, -0.5648> <-0.2837, 0.1777, -0.6295> <-0.2845, 0.1788, -0.7157> <-0.2830, 0.1773, -0.7803>
		<-0.2308, 0.2308, -0.5648> <-0.2307, 0.2307, -0.6295> <-0.2317, 0.2317, -0.7157> <-0.2301, 0.2301, -0.7803>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3255, -0.7803> <-0.0747, 0.3255, -0.7803> <-0.1773, 0.2830, -0.7803> <-0.2301, 0.2301, -0.7803>
		<0.0000, 0.3237, -0.8345> <-0.0747, 0.3237, -0.8345> <-0.1760, 0.2817, -0.8345> <-0.2288, 0.2288, -0.8345>
		<0.0000, 0.3178, -0.9065> <-0.0719, 0.3178, -0.9065> <-0.1739, 0.2755, -0.9065> <-0.2247, 0.2247, -0.9065>
		<0.0000, 0.3131, -0.9604> <-0.0719, 0.3131, -0.9604> <-0.1705, 0.2722, -0.9604> <-0.2213, 0.2213, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3255, -0.7803> <0.0000, 0.3237, -0.8345> <0.0000, 0.3178, -0.9065> <0.0000, 0.3131, -0.9604>
		<0.0747, 0.3255, -0.7803> <0.0747, 0.3237, -0.8345> <0.0719, 0.3178, -0.9065> <0.0719, 0.3131, -0.9604>
		<0.1773, 0.2830, -0.7803> <0.1760, 0.2817, -0.8345> <0.1739, 0.2755, -0.9065> <0.1705, 0.2722, -0.9604>
		<0.2301, 0.2301, -0.7803> <0.2288, 0.2288, -0.8345> <0.2247, 0.2247, -0.9065> <0.2213, 0.2213, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2301, 0.2301, -0.7803> <0.2288, 0.2288, -0.8345> <0.2247, 0.2247, -0.9065> <0.2213, 0.2213, -0.9604>
		<0.2830, 0.1773, -0.7803> <0.2817, 0.1760, -0.8345> <0.2755, 0.1739, -0.9065> <0.2722, 0.1705, -0.9604>
		<0.3255, 0.0747, -0.7803> <0.3237, 0.0747, -0.8345> <0.3178, 0.0719, -0.9065> <0.3131, 0.0719, -0.9604>
		<0.3255, 0.0000, -0.7803> <0.3237, 0.0000, -0.8345> <0.3178, 0.0000, -0.9065> <0.3131, 0.0000, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3255, 0.0000, -0.7803> <0.3237, 0.0000, -0.8345> <0.3178, 0.0000, -0.9065> <0.3131, 0.0000, -0.9604>
		<0.3255, -0.0747, -0.7803> <0.3237, -0.0747, -0.8345> <0.3178, -0.0719, -0.9065> <0.3131, -0.0719, -0.9604>
		<0.2830, -0.1773, -0.7803> <0.2817, -0.1760, -0.8345> <0.2755, -0.1739, -0.9065> <0.2722, -0.1705, -0.9604>
		<0.2301, -0.2301, -0.7803> <0.2288, -0.2288, -0.8345> <0.2247, -0.2247, -0.9065> <0.2213, -0.2213, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2301, -0.2301, -0.7803> <0.2288, -0.2288, -0.8345> <0.2247, -0.2247, -0.9065> <0.2213, -0.2213, -0.9604>
		<0.1773, -0.2830, -0.7803> <0.1760, -0.2817, -0.8345> <0.1739, -0.2755, -0.9065> <0.1705, -0.2722, -0.9604>
		<0.0747, -0.3255, -0.7803> <0.0747, -0.3237, -0.8345> <0.0719, -0.3178, -0.9065> <0.0719, -0.3131, -0.9604>
		<0.0000, -0.3255, -0.7803> <0.0000, -0.3237, -0.8345> <0.0000, -0.3178, -0.9065> <0.0000, -0.3131, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3255, -0.7803> <0.0000, -0.3237, -0.8345> <0.0000, -0.3178, -0.9065> <0.0000, -0.3131, -0.9604>
		<-0.0747, -0.3255, -0.7803> <-0.0747, -0.3237, -0.8345> <-0.0719, -0.3178, -0.9065> <-0.0719, -0.3131, -0.9604>
		<-0.1773, -0.2830, -0.7803> <-0.1760, -0.2817, -0.8345> <-0.1739, -0.2755, -0.9065> <-0.1705, -0.2722, -0.9604>
		<-0.2301, -0.2301, -0.7803> <-0.2288, -0.2288, -0.8345> <-0.2247, -0.2247, -0.9065> <-0.2213, -0.2213, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2301, -0.2301, -0.7803> <-0.2288, -0.2288, -0.8345> <-0.2247, -0.2247, -0.9065> <-0.2213, -0.2213, -0.9604>
		<-0.2830, -0.1773, -0.7803> <-0.2817, -0.1760, -0.8345> <-0.2755, -0.1739, -0.9065> <-0.2722, -0.1705, -0.9604>
		<-0.3255, -0.0747, -0.7803> <-0.3237, -0.0747, -0.8345> <-0.3178, -0.0719, -0.9065> <-0.3131, -0.0719, -0.9604>
		<-0.3255, 0.0000, -0.7803> <-0.3237, 0.0000, -0.8345> <-0.3178, 0.0000, -0.9065> <-0.3131, 0.0000, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3255, 0.0000, -0.7803> <-0.3237, 0.0000, -0.8345> <-0.3178, 0.0000, -0.9065> <-0.3131, 0.0000, -0.9604>
		<-0.3255, 0.0747, -0.7803> <-0.3237, 0.0747, -0.8345> <-0.3178, 0.0719, -0.9065> <-0.3131, 0.0719, -0.9604>
		<-0.2830, 0.1773, -0.7803> <-0.2817, 0.1760, -0.8345> <-0.2755, 0.1739, -0.9065> <-0.2722, 0.1705, -0.9604>
		<-0.2301, 0.2301, -0.7803> <-0.2288, 0.2288, -0.8345> <-0.2247, 0.2247, -0.9065> <-0.2213, 0.2213, -0.9604>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3131, -0.9604> <-0.0719, 0.3131, -0.9604> <-0.1705, 0.2722, -0.9604> <-0.2213, 0.2213, -0.9604>
		<0.0000, 0.3102, -0.9924> <-0.0719, 0.3102, -0.9924> <-0.1685, 0.2702, -0.9924> <-0.2193, 0.2193, -0.9924>
		<0.0000, 0.3042, -1.0349> <-0.0689, 0.3042, -1.0349> <-0.1664, 0.2638, -1.0349> <-0.2151, 0.2151, -1.0349>
		<0.0000, 0.3002, -1.0667> <-0.0689, 0.3002, -1.0667> <-0.1635, 0.2610, -1.0667> <-0.2122, 0.2122, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3131, -0.9604> <0.0000, 0.3102, -0.9924> <0.0000, 0.3042, -1.0349> <0.0000, 0.3002, -1.0667>
		<0.0719, 0.3131, -0.9604> <0.0719, 0.3102, -0.9924> <0.0689, 0.3042, -1.0349> <0.0689, 0.3002, -1.0667>
		<0.1705, 0.2722, -0.9604> <0.1685, 0.2702, -0.9924> <0.1664, 0.2638, -1.0349> <0.1635, 0.2610, -1.0667>
		<0.2213, 0.2213, -0.9604> <0.2193, 0.2193, -0.9924> <0.2151, 0.2151, -1.0349> <0.2122, 0.2122, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2213, 0.2213, -0.9604> <0.2193, 0.2193, -0.9924> <0.2151, 0.2151, -1.0349> <0.2122, 0.2122, -1.0667>
		<0.2722, 0.1705, -0.9604> <0.2702, 0.1685, -0.9924> <0.2638, 0.1664, -1.0349> <0.2610, 0.1635, -1.0667>
		<0.3131, 0.0719, -0.9604> <0.3102, 0.0719, -0.9924> <0.3042, 0.0689, -1.0349> <0.3002, 0.0689, -1.0667>
		<0.3131, 0.0000, -0.9604> <0.3102, 0.0000, -0.9924> <0.3042, 0.0000, -1.0349> <0.3002, 0.0000, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3131, 0.0000, -0.9604> <0.3102, 0.0000, -0.9924> <0.3042, 0.0000, -1.0349> <0.3002, 0.0000, -1.0667>
		<0.3131, -0.0719, -0.9604> <0.3102, -0.0719, -0.9924> <0.3042, -0.0689, -1.0349> <0.3002, -0.0689, -1.0667>
		<0.2722, -0.1705, -0.9604> <0.2702, -0.1685, -0.9924> <0.2638, -0.1664, -1.0349> <0.2610, -0.1635, -1.0667>
		<0.2213, -0.2213, -0.9604> <0.2193, -0.2193, -0.9924> <0.2151, -0.2151, -1.0349> <0.2122, -0.2122, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2213, -0.2213, -0.9604> <0.2193, -0.2193, -0.9924> <0.2151, -0.2151, -1.0349> <0.2122, -0.2122, -1.0667>
		<0.1705, -0.2722, -0.9604> <0.1685, -0.2702, -0.9924> <0.1664, -0.2638, -1.0349> <0.1635, -0.2610, -1.0667>
		<0.0719, -0.3131, -0.9604> <0.0719, -0.3102, -0.9924> <0.0689, -0.3042, -1.0349> <0.0689, -0.3002, -1.0667>
		<0.0000, -0.3131, -0.9604> <0.0000, -0.3102, -0.9924> <0.0000, -0.3042, -1.0349> <0.0000, -0.3002, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3131, -0.9604> <0.0000, -0.3102, -0.9924> <0.0000, -0.3042, -1.0349> <0.0000, -0.3002, -1.0667>
		<-0.0719, -0.3131, -0.9604> <-0.0719, -0.3102, -0.9924> <-0.0689, -0.3042, -1.0349> <-0.0689, -0.3002, -1.0667>
		<-0.1705, -0.2722, -0.9604> <-0.1685, -0.2702, -0.9924> <-0.1664, -0.2638, -1.0349> <-0.1635, -0.2610, -1.0667>
		<-0.2213, -0.2213, -0.9604> <-0.2193, -0.2193, -0.9924> <-0.2151, -0.2151, -1.0349> <-0.2122, -0.2122, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2213, -0.2213, -0.9604> <-0.2193, -0.2193, -0.9924> <-0.2151, -0.2151, -1.0349> <-0.2122, -0.2122, -1.0667>
		<-0.2722, -0.1705, -0.9604> <-0.2702, -0.1685, -0.9924> <-0.2638, -0.1664, -1.0349> <-0.2610, -0.1635, -1.0667>
		<-0.3131, -0.0719, -0.9604> <-0.3102, -0.0719, -0.9924> <-0.3042, -0.0689, -1.0349> <-0.3002, -0.0689, -1.0667>
		<-0.3131, 0.0000, -0.9604> <-0.3102, 0.0000, -0.9924> <-0.3042, 0.0000, -1.0349> <-0.3002, 0.0000, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3131, 0.0000, -0.9604> <-0.3102, 0.0000, -0.9924> <-0.3042, 0.0000, -1.0349> <-0.3002, 0.0000, -1.0667>
		<-0.3131, 0.0719, -0.9604> <-0.3102, 0.0719, -0.9924> <-0.3042, 0.0689, -1.0349> <-0.3002, 0.0689, -1.0667>
		<-0.2722, 0.1705, -0.9604> <-0.2702, 0.1685, -0.9924> <-0.2638, 0.1664, -1.0349> <-0.2610, 0.1635, -1.0667>
		<-0.2213, 0.2213, -0.9604> <-0.2193, 0.2193, -0.9924> <-0.2151, 0.2151, -1.0349> <-0.2122, 0.2122, -1.0667>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3002, -1.0667> <-0.0689, 0.3002, -1.0667> <-0.1635, 0.2610, -1.0667> <-0.2122, 0.2122, -1.0667>
		<0.0000, 0.2975, -1.0880> <-0.0689, 0.2975, -1.0880> <-0.1616, 0.2590, -1.0880> <-0.2103, 0.2103, -1.0880>
		<0.0000, 0.2936, -1.1163> <-0.0667, 0.2936, -1.1163> <-0.1604, 0.2547, -1.1163> <-0.2076, 0.2076, -1.1163>
		<0.0000, 0.2905, -1.1376> <-0.0667, 0.2905, -1.1376> <-0.1582, 0.2525, -1.1376> <-0.2054, 0.2054, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3002, -1.0667> <0.0000, 0.2975, -1.0880> <0.0000, 0.2936, -1.1163> <0.0000, 0.2905, -1.1376>
		<0.0689, 0.3002, -1.0667> <0.0689, 0.2975, -1.0880> <0.0667, 0.2936, -1.1163> <0.0667, 0.2905, -1.1376>
		<0.1635, 0.2610, -1.0667> <0.1616, 0.2590, -1.0880> <0.1604, 0.2547, -1.1163> <0.1582, 0.2525, -1.1376>
		<0.2122, 0.2122, -1.0667> <0.2103, 0.2103, -1.0880> <0.2076, 0.2076, -1.1163> <0.2054, 0.2054, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2122, 0.2122, -1.0667> <0.2103, 0.2103, -1.0880> <0.2076, 0.2076, -1.1163> <0.2054, 0.2054, -1.1376>
		<0.2610, 0.1635, -1.0667> <0.2590, 0.1616, -1.0880> <0.2547, 0.1604, -1.1163> <0.2525, 0.1582, -1.1376>
		<0.3002, 0.0689, -1.0667> <0.2975, 0.0689, -1.0880> <0.2936, 0.0667, -1.1163> <0.2905, 0.0667, -1.1376>
		<0.3002, 0.0000, -1.0667> <0.2975, 0.0000, -1.0880> <0.2936, 0.0000, -1.1163> <0.2905, 0.0000, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3002, 0.0000, -1.0667> <0.2975, 0.0000, -1.0880> <0.2936, 0.0000, -1.1163> <0.2905, 0.0000, -1.1376>
		<0.3002, -0.0689, -1.0667> <0.2975, -0.0689, -1.0880> <0.2936, -0.0667, -1.1163> <0.2905, -0.0667, -1.1376>
		<0.2610, -0.1635, -1.0667> <0.2590, -0.1616, -1.0880> <0.2547, -0.1604, -1.1163> <0.2525, -0.1582, -1.1376>
		<0.2122, -0.2122, -1.0667> <0.2103, -0.2103, -1.0880> <0.2076, -0.2076, -1.1163> <0.2054, -0.2054, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2122, -0.2122, -1.0667> <0.2103, -0.2103, -1.0880> <0.2076, -0.2076, -1.1163> <0.2054, -0.2054, -1.1376>
		<0.1635, -0.2610, -1.0667> <0.1616, -0.2590, -1.0880> <0.1604, -0.2547, -1.1163> <0.1582, -0.2525, -1.1376>
		<0.0689, -0.3002, -1.0667> <0.0689, -0.2975, -1.0880> <0.0667, -0.2936, -1.1163> <0.0667, -0.2905, -1.1376>
		<0.0000, -0.3002, -1.0667> <0.0000, -0.2975, -1.0880> <0.0000, -0.2936, -1.1163> <0.0000, -0.2905, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3002, -1.0667> <0.0000, -0.2975, -1.0880> <0.0000, -0.2936, -1.1163> <0.0000, -0.2905, -1.1376>
		<-0.0689, -0.3002, -1.0667> <-0.0689, -0.2975, -1.0880> <-0.0667, -0.2936, -1.1163> <-0.0667, -0.2905, -1.1376>
		<-0.1635, -0.2610, -1.0667> <-0.1616, -0.2590, -1.0880> <-0.1604, -0.2547, -1.1163> <-0.1582, -0.2525, -1.1376>
		<-0.2122, -0.2122, -1.0667> <-0.2103, -0.2103, -1.0880> <-0.2076, -0.2076, -1.1163> <-0.2054, -0.2054, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2122, -0.2122, -1.0667> <-0.2103, -0.2103, -1.0880> <-0.2076, -0.2076, -1.1163> <-0.2054, -0.2054, -1.1376>
		<-0.2610, -0.1635, -1.0667> <-0.2590, -0.1616, -1.0880> <-0.2547, -0.1604, -1.1163> <-0.2525, -0.1582, -1.1376>
		<-0.3002, -0.0689, -1.0667> <-0.2975, -0.0689, -1.0880> <-0.2936, -0.0667, -1.1163> <-0.2905, -0.0667, -1.1376>
		<-0.3002, 0.0000, -1.0667> <-0.2975, 0.0000, -1.0880> <-0.2936, 0.0000, -1.1163> <-0.2905, 0.0000, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3002, 0.0000, -1.0667> <-0.2975, 0.0000, -1.0880> <-0.2936, 0.0000, -1.1163> <-0.2905, 0.0000, -1.1376>
		<-0.3002, 0.0689, -1.0667> <-0.2975, 0.0689, -1.0880> <-0.2936, 0.0667, -1.1163> <-0.2905, 0.0667, -1.1376>
		<-0.2610, 0.1635, -1.0667> <-0.2590, 0.1616, -1.0880> <-0.2547, 0.1604, -1.1163> <-0.2525, 0.1582, -1.1376>
		<-0.2122, 0.2122, -1.0667> <-0.2103, 0.2103, -1.0880> <-0.2076, 0.2076, -1.1163> <-0.2054, 0.2054, -1.1376>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2905, -1.1376> <-0.0667, 0.2905, -1.1376> <-0.1582, 0.2525, -1.1376> <-0.2054, 0.2054, -1.1376>
		<0.0000, 0.2889, -1.1482> <-0.0667, 0.2889, -1.1482> <-0.1571, 0.2514, -1.1482> <-0.2042, 0.2042, -1.1482>
		<0.0000, 0.2862, -1.1624> <-0.0653, 0.2862, -1.1624> <-0.1562, 0.2485, -1.1624> <-0.2024, 0.2024, -1.1624>
		<0.0000, 0.2845, -1.1730> <-0.0653, 0.2845, -1.1730> <-0.1549, 0.2473, -1.1730> <-0.2011, 0.2011, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2905, -1.1376> <0.0000, 0.2889, -1.1482> <0.0000, 0.2862, -1.1624> <0.0000, 0.2845, -1.1730>
		<0.0667, 0.2905, -1.1376> <0.0667, 0.2889, -1.1482> <0.0653, 0.2862, -1.1624> <0.0653, 0.2845, -1.1730>
		<0.1582, 0.2525, -1.1376> <0.1571, 0.2514, -1.1482> <0.1562, 0.2485, -1.1624> <0.1549, 0.2473, -1.1730>
		<0.2054, 0.2054, -1.1376> <0.2042, 0.2042, -1.1482> <0.2024, 0.2024, -1.1624> <0.2011, 0.2011, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2054, 0.2054, -1.1376> <0.2042, 0.2042, -1.1482> <0.2024, 0.2024, -1.1624> <0.2011, 0.2011, -1.1730>
		<0.2525, 0.1582, -1.1376> <0.2514, 0.1571, -1.1482> <0.2485, 0.1562, -1.1624> <0.2473, 0.1549, -1.1730>
		<0.2905, 0.0667, -1.1376> <0.2889, 0.0667, -1.1482> <0.2862, 0.0653, -1.1624> <0.2845, 0.0653, -1.1730>
		<0.2905, 0.0000, -1.1376> <0.2889, 0.0000, -1.1482> <0.2862, 0.0000, -1.1624> <0.2845, 0.0000, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2905, 0.0000, -1.1376> <0.2889, 0.0000, -1.1482> <0.2862, 0.0000, -1.1624> <0.2845, 0.0000, -1.1730>
		<0.2905, -0.0667, -1.1376> <0.2889, -0.0667, -1.1482> <0.2862, -0.0653, -1.1624> <0.2845, -0.0653, -1.1730>
		<0.2525, -0.1582, -1.1376> <0.2514, -0.1571, -1.1482> <0.2485, -0.1562, -1.1624> <0.2473, -0.1549, -1.1730>
		<0.2054, -0.2054, -1.1376> <0.2042, -0.2042, -1.1482> <0.2024, -0.2024, -1.1624> <0.2011, -0.2011, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2054, -0.2054, -1.1376> <0.2042, -0.2042, -1.1482> <0.2024, -0.2024, -1.1624> <0.2011, -0.2011, -1.1730>
		<0.1582, -0.2525, -1.1376> <0.1571, -0.2514, -1.1482> <0.1562, -0.2485, -1.1624> <0.1549, -0.2473, -1.1730>
		<0.0667, -0.2905, -1.1376> <0.0667, -0.2889, -1.1482> <0.0653, -0.2862, -1.1624> <0.0653, -0.2845, -1.1730>
		<0.0000, -0.2905, -1.1376> <0.0000, -0.2889, -1.1482> <0.0000, -0.2862, -1.1624> <0.0000, -0.2845, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2905, -1.1376> <0.0000, -0.2889, -1.1482> <0.0000, -0.2862, -1.1624> <0.0000, -0.2845, -1.1730>
		<-0.0667, -0.2905, -1.1376> <-0.0667, -0.2889, -1.1482> <-0.0653, -0.2862, -1.1624> <-0.0653, -0.2845, -1.1730>
		<-0.1582, -0.2525, -1.1376> <-0.1571, -0.2514, -1.1482> <-0.1562, -0.2485, -1.1624> <-0.1549, -0.2473, -1.1730>
		<-0.2054, -0.2054, -1.1376> <-0.2042, -0.2042, -1.1482> <-0.2024, -0.2024, -1.1624> <-0.2011, -0.2011, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2054, -0.2054, -1.1376> <-0.2042, -0.2042, -1.1482> <-0.2024, -0.2024, -1.1624> <-0.2011, -0.2011, -1.1730>
		<-0.2525, -0.1582, -1.1376> <-0.2514, -0.1571, -1.1482> <-0.2485, -0.1562, -1.1624> <-0.2473, -0.1549, -1.1730>
		<-0.2905, -0.0667, -1.1376> <-0.2889, -0.0667, -1.1482> <-0.2862, -0.0653, -1.1624> <-0.2845, -0.0653, -1.1730>
		<-0.2905, 0.0000, -1.1376> <-0.2889, 0.0000, -1.1482> <-0.2862, 0.0000, -1.1624> <-0.2845, 0.0000, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2905, 0.0000, -1.1376> <-0.2889, 0.0000, -1.1482> <-0.2862, 0.0000, -1.1624> <-0.2845, 0.0000, -1.1730>
		<-0.2905, 0.0667, -1.1376> <-0.2889, 0.0667, -1.1482> <-0.2862, 0.0653, -1.1624> <-0.2845, 0.0653, -1.1730>
		<-0.2525, 0.1582, -1.1376> <-0.2514, 0.1571, -1.1482> <-0.2485, 0.1562, -1.1624> <-0.2473, 0.1549, -1.1730>
		<-0.2054, 0.2054, -1.1376> <-0.2042, 0.2042, -1.1482> <-0.2024, 0.2024, -1.1624> <-0.2011, 0.2011, -1.1730>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2845, -1.1730> <-0.0653, 0.2845, -1.1730> <-0.1549, 0.2473, -1.1730> <-0.2011, 0.2011, -1.1730>
		<0.0000, 0.2832, -1.1810> <-0.0653, 0.2832, -1.1810> <-0.1540, 0.2464, -1.1810> <-0.2002, 0.2002, -1.1810>
		<0.0000, 0.2817, -1.1916> <-0.0644, 0.2817, -1.1916> <-0.1536, 0.2446, -1.1916> <-0.1991, 0.1991, -1.1916>
		<0.0000, 0.2803, -1.1996> <-0.0644, 0.2803, -1.1996> <-0.1527, 0.2437, -1.1996> <-0.1982, 0.1982, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2845, -1.1730> <0.0000, 0.2832, -1.1810> <0.0000, 0.2817, -1.1916> <0.0000, 0.2803, -1.1996>
		<0.0653, 0.2845, -1.1730> <0.0653, 0.2832, -1.1810> <0.0644, 0.2817, -1.1916> <0.0644, 0.2803, -1.1996>
		<0.1549, 0.2473, -1.1730> <0.1540, 0.2464, -1.1810> <0.1536, 0.2446, -1.1916> <0.1527, 0.2437, -1.1996>
		<0.2011, 0.2011, -1.1730> <0.2002, 0.2002, -1.1810> <0.1991, 0.1991, -1.1916> <0.1982, 0.1982, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2011, 0.2011, -1.1730> <0.2002, 0.2002, -1.1810> <0.1991, 0.1991, -1.1916> <0.1982, 0.1982, -1.1996>
		<0.2473, 0.1549, -1.1730> <0.2464, 0.1540, -1.1810> <0.2446, 0.1536, -1.1916> <0.2437, 0.1527, -1.1996>
		<0.2845, 0.0653, -1.1730> <0.2832, 0.0653, -1.1810> <0.2817, 0.0644, -1.1916> <0.2803, 0.0644, -1.1996>
		<0.2845, 0.0000, -1.1730> <0.2832, 0.0000, -1.1810> <0.2817, 0.0000, -1.1916> <0.2803, 0.0000, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2845, 0.0000, -1.1730> <0.2832, 0.0000, -1.1810> <0.2817, 0.0000, -1.1916> <0.2803, 0.0000, -1.1996>
		<0.2845, -0.0653, -1.1730> <0.2832, -0.0653, -1.1810> <0.2817, -0.0644, -1.1916> <0.2803, -0.0644, -1.1996>
		<0.2473, -0.1549, -1.1730> <0.2464, -0.1540, -1.1810> <0.2446, -0.1536, -1.1916> <0.2437, -0.1527, -1.1996>
		<0.2011, -0.2011, -1.1730> <0.2002, -0.2002, -1.1810> <0.1991, -0.1991, -1.1916> <0.1982, -0.1982, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2011, -0.2011, -1.1730> <0.2002, -0.2002, -1.1810> <0.1991, -0.1991, -1.1916> <0.1982, -0.1982, -1.1996>
		<0.1549, -0.2473, -1.1730> <0.1540, -0.2464, -1.1810> <0.1536, -0.2446, -1.1916> <0.1527, -0.2437, -1.1996>
		<0.0653, -0.2845, -1.1730> <0.0653, -0.2832, -1.1810> <0.0644, -0.2817, -1.1916> <0.0644, -0.2803, -1.1996>
		<0.0000, -0.2845, -1.1730> <0.0000, -0.2832, -1.1810> <0.0000, -0.2817, -1.1916> <0.0000, -0.2803, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2845, -1.1730> <0.0000, -0.2832, -1.1810> <0.0000, -0.2817, -1.1916> <0.0000, -0.2803, -1.1996>
		<-0.0653, -0.2845, -1.1730> <-0.0653, -0.2832, -1.1810> <-0.0644, -0.2817, -1.1916> <-0.0644, -0.2803, -1.1996>
		<-0.1549, -0.2473, -1.1730> <-0.1540, -0.2464, -1.1810> <-0.1536, -0.2446, -1.1916> <-0.1527, -0.2437, -1.1996>
		<-0.2011, -0.2011, -1.1730> <-0.2002, -0.2002, -1.1810> <-0.1991, -0.1991, -1.1916> <-0.1982, -0.1982, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2011, -0.2011, -1.1730> <-0.2002, -0.2002, -1.1810> <-0.1991, -0.1991, -1.1916> <-0.1982, -0.1982, -1.1996>
		<-0.2473, -0.1549, -1.1730> <-0.2464, -0.1540, -1.1810> <-0.2446, -0.1536, -1.1916> <-0.2437, -0.1527, -1.1996>
		<-0.2845, -0.0653, -1.1730> <-0.2832, -0.0653, -1.1810> <-0.2817, -0.0644, -1.1916> <-0.2803, -0.0644, -1.1996>
		<-0.2845, 0.0000, -1.1730> <-0.2832, 0.0000, -1.1810> <-0.2817, 0.0000, -1.1916> <-0.2803, 0.0000, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2845, 0.0000, -1.1730> <-0.2832, 0.0000, -1.1810> <-0.2817, 0.0000, -1.1916> <-0.2803, 0.0000, -1.1996>
		<-0.2845, 0.0653, -1.1730> <-0.2832, 0.0653, -1.1810> <-0.2817, 0.0644, -1.1916> <-0.2803, 0.0644, -1.1996>
		<-0.2473, 0.1549, -1.1730> <-0.2464, 0.1540, -1.1810> <-0.2446, 0.1536, -1.1916> <-0.2437, 0.1527, -1.1996>
		<-0.2011, 0.2011, -1.1730> <-0.2002, 0.2002, -1.1810> <-0.1991, 0.1991, -1.1916> <-0.1982, 0.1982, -1.1996>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2803, -1.1996> <-0.0644, 0.2803, -1.1996> <-0.1527, 0.2437, -1.1996> <-0.1982, 0.1982, -1.1996>
		<0.0000, 0.2728, -1.2435> <-0.0644, 0.2728, -1.2435> <-0.1473, 0.2384, -1.2435> <-0.1929, 0.1929, -1.2435>
		<0.0000, 0.2642, -1.3023> <-0.0585, 0.2642, -1.3023> <-0.1454, 0.2281, -1.3023> <-0.1868, 0.1868, -1.3023>
		<0.0000, 0.2548, -1.3459> <-0.0585, 0.2548, -1.3459> <-0.1388, 0.2215, -1.3459> <-0.1802, 0.1802, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2803, -1.1996> <0.0000, 0.2728, -1.2435> <0.0000, 0.2642, -1.3023> <0.0000, 0.2548, -1.3459>
		<0.0644, 0.2803, -1.1996> <0.0644, 0.2728, -1.2435> <0.0585, 0.2642, -1.3023> <0.0585, 0.2548, -1.3459>
		<0.1527, 0.2437, -1.1996> <0.1473, 0.2384, -1.2435> <0.1454, 0.2281, -1.3023> <0.1388, 0.2215, -1.3459>
		<0.1982, 0.1982, -1.1996> <0.1929, 0.1929, -1.2435> <0.1868, 0.1868, -1.3023> <0.1802, 0.1802, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1982, 0.1982, -1.1996> <0.1929, 0.1929, -1.2435> <0.1868, 0.1868, -1.3023> <0.1802, 0.1802, -1.3459>
		<0.2437, 0.1527, -1.1996> <0.2384, 0.1473, -1.2435> <0.2281, 0.1454, -1.3023> <0.2215, 0.1388, -1.3459>
		<0.2803, 0.0644, -1.1996> <0.2728, 0.0644, -1.2435> <0.2642, 0.0585, -1.3023> <0.2548, 0.0585, -1.3459>
		<0.2803, 0.0000, -1.1996> <0.2728, 0.0000, -1.2435> <0.2642, 0.0000, -1.3023> <0.2548, 0.0000, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2803, 0.0000, -1.1996> <0.2728, 0.0000, -1.2435> <0.2642, 0.0000, -1.3023> <0.2548, 0.0000, -1.3459>
		<0.2803, -0.0644, -1.1996> <0.2728, -0.0644, -1.2435> <0.2642, -0.0585, -1.3023> <0.2548, -0.0585, -1.3459>
		<0.2437, -0.1527, -1.1996> <0.2384, -0.1473, -1.2435> <0.2281, -0.1454, -1.3023> <0.2215, -0.1388, -1.3459>
		<0.1982, -0.1982, -1.1996> <0.1929, -0.1929, -1.2435> <0.1868, -0.1868, -1.3023> <0.1802, -0.1802, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1982, -0.1982, -1.1996> <0.1929, -0.1929, -1.2435> <0.1868, -0.1868, -1.3023> <0.1802, -0.1802, -1.3459>
		<0.1527, -0.2437, -1.1996> <0.1473, -0.2384, -1.2435> <0.1454, -0.2281, -1.3023> <0.1388, -0.2215, -1.3459>
		<0.0644, -0.2803, -1.1996> <0.0644, -0.2728, -1.2435> <0.0585, -0.2642, -1.3023> <0.0585, -0.2548, -1.3459>
		<0.0000, -0.2803, -1.1996> <0.0000, -0.2728, -1.2435> <0.0000, -0.2642, -1.3023> <0.0000, -0.2548, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2803, -1.1996> <0.0000, -0.2728, -1.2435> <0.0000, -0.2642, -1.3023> <0.0000, -0.2548, -1.3459>
		<-0.0644, -0.2803, -1.1996> <-0.0644, -0.2728, -1.2435> <-0.0585, -0.2642, -1.3023> <-0.0585, -0.2548, -1.3459>
		<-0.1527, -0.2437, -1.1996> <-0.1473, -0.2384, -1.2435> <-0.1454, -0.2281, -1.3023> <-0.1388, -0.2215, -1.3459>
		<-0.1982, -0.1982, -1.1996> <-0.1929, -0.1929, -1.2435> <-0.1868, -0.1868, -1.3023> <-0.1802, -0.1802, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1982, -0.1982, -1.1996> <-0.1929, -0.1929, -1.2435> <-0.1868, -0.1868, -1.3023> <-0.1802, -0.1802, -1.3459>
		<-0.2437, -0.1527, -1.1996> <-0.2384, -0.1473, -1.2435> <-0.2281, -0.1454, -1.3023> <-0.2215, -0.1388, -1.3459>
		<-0.2803, -0.0644, -1.1996> <-0.2728, -0.0644, -1.2435> <-0.2642, -0.0585, -1.3023> <-0.2548, -0.0585, -1.3459>
		<-0.2803, 0.0000, -1.1996> <-0.2728, 0.0000, -1.2435> <-0.2642, 0.0000, -1.3023> <-0.2548, 0.0000, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2803, 0.0000, -1.1996> <-0.2728, 0.0000, -1.2435> <-0.2642, 0.0000, -1.3023> <-0.2548, 0.0000, -1.3459>
		<-0.2803, 0.0644, -1.1996> <-0.2728, 0.0644, -1.2435> <-0.2642, 0.0585, -1.3023> <-0.2548, 0.0585, -1.3459>
		<-0.2437, 0.1527, -1.1996> <-0.2384, 0.1473, -1.2435> <-0.2281, 0.1454, -1.3023> <-0.2215, 0.1388, -1.3459>
		<-0.1982, 0.1982, -1.1996> <-0.1929, 0.1929, -1.2435> <-0.1868, 0.1868, -1.3023> <-0.1802, 0.1802, -1.3459>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2548, -1.3459> <-0.0585, 0.2548, -1.3459> <-0.1388, 0.2215, -1.3459> <-0.1802, 0.1802, -1.3459>
		<0.0000, 0.2432, -1.4000> <-0.0585, 0.2432, -1.4000> <-0.1306, 0.2133, -1.4000> <-0.1720, 0.1720, -1.4000>
		<0.0000, 0.2264, -1.4719> <-0.0483, 0.2264, -1.4719> <-0.1259, 0.1942, -1.4719> <-0.1601, 0.1601, -1.4719>
		<0.0000, 0.2105, -1.5249> <-0.0483, 0.2105, -1.5249> <-0.1147, 0.1830, -1.5249> <-0.1488, 0.1488, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2548, -1.3459> <0.0000, 0.2432, -1.4000> <0.0000, 0.2264, -1.4719> <0.0000, 0.2105, -1.5249>
		<0.0585, 0.2548, -1.3459> <0.0585, 0.2432, -1.4000> <0.0483, 0.2264, -1.4719> <0.0483, 0.2105, -1.5249>
		<0.1388, 0.2215, -1.3459> <0.1306, 0.2133, -1.4000> <0.1259, 0.1942, -1.4719> <0.1147, 0.1830, -1.5249>
		<0.1802, 0.1802, -1.3459> <0.1720, 0.1720, -1.4000> <0.1601, 0.1601, -1.4719> <0.1488, 0.1488, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1802, 0.1802, -1.3459> <0.1720, 0.1720, -1.4000> <0.1601, 0.1601, -1.4719> <0.1488, 0.1488, -1.5249>
		<0.2215, 0.1388, -1.3459> <0.2133, 0.1306, -1.4000> <0.1942, 0.1259, -1.4719> <0.1830, 0.1147, -1.5249>
		<0.2548, 0.0585, -1.3459> <0.2432, 0.0585, -1.4000> <0.2264, 0.0483, -1.4719> <0.2105, 0.0483, -1.5249>
		<0.2548, 0.0000, -1.3459> <0.2432, 0.0000, -1.4000> <0.2264, 0.0000, -1.4719> <0.2105, 0.0000, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2548, 0.0000, -1.3459> <0.2432, 0.0000, -1.4000> <0.2264, 0.0000, -1.4719> <0.2105, 0.0000, -1.5249>
		<0.2548, -0.0585, -1.3459> <0.2432, -0.0585, -1.4000> <0.2264, -0.0483, -1.4719> <0.2105, -0.0483, -1.5249>
		<0.2215, -0.1388, -1.3459> <0.2133, -0.1306, -1.4000> <0.1942, -0.1259, -1.4719> <0.1830, -0.1147, -1.5249>
		<0.1802, -0.1802, -1.3459> <0.1720, -0.1720, -1.4000> <0.1601, -0.1601, -1.4719> <0.1488, -0.1488, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1802, -0.1802, -1.3459> <0.1720, -0.1720, -1.4000> <0.1601, -0.1601, -1.4719> <0.1488, -0.1488, -1.5249>
		<0.1388, -0.2215, -1.3459> <0.1306, -0.2133, -1.4000> <0.1259, -0.1942, -1.4719> <0.1147, -0.1830, -1.5249>
		<0.0585, -0.2548, -1.3459> <0.0585, -0.2432, -1.4000> <0.0483, -0.2264, -1.4719> <0.0483, -0.2105, -1.5249>
		<0.0000, -0.2548, -1.3459> <0.0000, -0.2432, -1.4000> <0.0000, -0.2264, -1.4719> <0.0000, -0.2105, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2548, -1.3459> <0.0000, -0.2432, -1.4000> <0.0000, -0.2264, -1.4719> <0.0000, -0.2105, -1.5249>
		<-0.0585, -0.2548, -1.3459> <-0.0585, -0.2432, -1.4000> <-0.0483, -0.2264, -1.4719> <-0.0483, -0.2105, -1.5249>
		<-0.1388, -0.2215, -1.3459> <-0.1306, -0.2133, -1.4000> <-0.1259, -0.1942, -1.4719> <-0.1147, -0.1830, -1.5249>
		<-0.1802, -0.1802, -1.3459> <-0.1720, -0.1720, -1.4000> <-0.1601, -0.1601, -1.4719> <-0.1488, -0.1488, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1802, -0.1802, -1.3459> <-0.1720, -0.1720, -1.4000> <-0.1601, -0.1601, -1.4719> <-0.1488, -0.1488, -1.5249>
		<-0.2215, -0.1388, -1.3459> <-0.2133, -0.1306, -1.4000> <-0.1942, -0.1259, -1.4719> <-0.1830, -0.1147, -1.5249>
		<-0.2548, -0.0585, -1.3459> <-0.2432, -0.0585, -1.4000> <-0.2264, -0.0483, -1.4719> <-0.2105, -0.0483, -1.5249>
		<-0.2548, 0.0000, -1.3459> <-0.2432, 0.0000, -1.4000> <-0.2264, 0.0000, -1.4719> <-0.2105, 0.0000, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2548, 0.0000, -1.3459> <-0.2432, 0.0000, -1.4000> <-0.2264, 0.0000, -1.4719> <-0.2105, 0.0000, -1.5249>
		<-0.2548, 0.0585, -1.3459> <-0.2432, 0.0585, -1.4000> <-0.2264, 0.0483, -1.4719> <-0.2105, 0.0483, -1.5249>
		<-0.2215, 0.1388, -1.3459> <-0.2133, 0.1306, -1.4000> <-0.1942, 0.1259, -1.4719> <-0.1830, 0.1147, -1.5249>
		<-0.1802, 0.1802, -1.3459> <-0.1720, 0.1720, -1.4000> <-0.1601, 0.1601, -1.4719> <-0.1488, 0.1488, -1.5249>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2105, -1.5249> <-0.0483, 0.2105, -1.5249> <-0.1147, 0.1830, -1.5249> <-0.1488, 0.1488, -1.5249>
		<0.0000, 0.1940, -1.5801> <-0.0483, 0.1940, -1.5801> <-0.1030, 0.1713, -1.5801> <-0.1371, 0.1371, -1.5801>
		<0.0000, 0.1670, -1.6521> <-0.0337, 0.1670, -1.6521> <-0.0942, 0.1419, -1.6521> <-0.1181, 0.1181, -1.6521>
		<0.0000, 0.1469, -1.7061> <-0.0337, 0.1469, -1.7061> <-0.0800, 0.1277, -1.7061> <-0.1039, 0.1039, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2105, -1.5249> <0.0000, 0.1940, -1.5801> <0.0000, 0.1670, -1.6521> <0.0000, 0.1469, -1.7061>
		<0.0483, 0.2105, -1.5249> <0.0483, 0.1940, -1.5801> <0.0337, 0.1670, -1.6521> <0.0337, 0.1469, -1.7061>
		<0.1147, 0.1830, -1.5249> <0.1030, 0.1713, -1.5801> <0.0942, 0.1419, -1.6521> <0.0800, 0.1277, -1.7061>
		<0.1488, 0.1488, -1.5249> <0.1371, 0.1371, -1.5801> <0.1181, 0.1181, -1.6521> <0.1039, 0.1039, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1488, 0.1488, -1.5249> <0.1371, 0.1371, -1.5801> <0.1181, 0.1181, -1.6521> <0.1039, 0.1039, -1.7061>
		<0.1830, 0.1147, -1.5249> <0.1713, 0.1030, -1.5801> <0.1419, 0.0942, -1.6521> <0.1277, 0.0800, -1.7061>
		<0.2105, 0.0483, -1.5249> <0.1940, 0.0483, -1.5801> <0.1670, 0.0337, -1.6521> <0.1469, 0.0337, -1.7061>
		<0.2105, 0.0000, -1.5249> <0.1940, 0.0000, -1.5801> <0.1670, 0.0000, -1.6521> <0.1469, 0.0000, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2105, 0.0000, -1.5249> <0.1940, 0.0000, -1.5801> <0.1670, 0.0000, -1.6521> <0.1469, 0.0000, -1.7061>
		<0.2105, -0.0483, -1.5249> <0.1940, -0.0483, -1.5801> <0.1670, -0.0337, -1.6521> <0.1469, -0.0337, -1.7061>
		<0.1830, -0.1147, -1.5249> <0.1713, -0.1030, -1.5801> <0.1419, -0.0942, -1.6521> <0.1277, -0.0800, -1.7061>
		<0.1488, -0.1488, -1.5249> <0.1371, -0.1371, -1.5801> <0.1181, -0.1181, -1.6521> <0.1039, -0.1039, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1488, -0.1488, -1.5249> <0.1371, -0.1371, -1.5801> <0.1181, -0.1181, -1.6521> <0.1039, -0.1039, -1.7061>
		<0.1147, -0.1830, -1.5249> <0.1030, -0.1713, -1.5801> <0.0942, -0.1419, -1.6521> <0.0800, -0.1277, -1.7061>
		<0.0483, -0.2105, -1.5249> <0.0483, -0.1940, -1.5801> <0.0337, -0.1670, -1.6521> <0.0337, -0.1469, -1.7061>
		<0.0000, -0.2105, -1.5249> <0.0000, -0.1940, -1.5801> <0.0000, -0.1670, -1.6521> <0.0000, -0.1469, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2105, -1.5249> <0.0000, -0.1940, -1.5801> <0.0000, -0.1670, -1.6521> <0.0000, -0.1469, -1.7061>
		<-0.0483, -0.2105, -1.5249> <-0.0483, -0.1940, -1.5801> <-0.0337, -0.1670, -1.6521> <-0.0337, -0.1469, -1.7061>
		<-0.1147, -0.1830, -1.5249> <-0.1030, -0.1713, -1.5801> <-0.0942, -0.1419, -1.6521> <-0.0800, -0.1277, -1.7061>
		<-0.1488, -0.1488, -1.5249> <-0.1371, -0.1371, -1.5801> <-0.1181, -0.1181, -1.6521> <-0.1039, -0.1039, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1488, -0.1488, -1.5249> <-0.1371, -0.1371, -1.5801> <-0.1181, -0.1181, -1.6521> <-0.1039, -0.1039, -1.7061>
		<-0.1830, -0.1147, -1.5249> <-0.1713, -0.1030, -1.5801> <-0.1419, -0.0942, -1.6521> <-0.1277, -0.0800, -1.7061>
		<-0.2105, -0.0483, -1.5249> <-0.1940, -0.0483, -1.5801> <-0.1670, -0.0337, -1.6521> <-0.1469, -0.0337, -1.7061>
		<-0.2105, 0.0000, -1.5249> <-0.1940, 0.0000, -1.5801> <-0.1670, 0.0000, -1.6521> <-0.1469, 0.0000, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2105, 0.0000, -1.5249> <-0.1940, 0.0000, -1.5801> <-0.1670, 0.0000, -1.6521> <-0.1469, 0.0000, -1.7061>
		<-0.2105, 0.0483, -1.5249> <-0.1940, 0.0483, -1.5801> <-0.1670, 0.0337, -1.6521> <-0.1469, 0.0337, -1.7061>
		<-0.1830, 0.1147, -1.5249> <-0.1713, 0.1030, -1.5801> <-0.1419, 0.0942, -1.6521> <-0.1277, 0.0800, -1.7061>
		<-0.1488, 0.1488, -1.5249> <-0.1371, 0.1371, -1.5801> <-0.1181, 0.1181, -1.6521> <-0.1039, 0.1039, -1.7061>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1469, -1.7061> <-0.0337, 0.1469, -1.7061> <-0.0800, 0.1277, -1.7061> <-0.1039, 0.1039, -1.7061>
		<0.0000, 0.1392, -1.7268> <-0.0337, 0.1392, -1.7268> <-0.0746, 0.1223, -1.7268> <-0.0984, 0.0984, -1.7268>
		<0.0000, 0.1268, -1.7535> <-0.0270, 0.1268, -1.7535> <-0.0705, 0.1088, -1.7535> <-0.0896, 0.0896, -1.7535>
		<0.0000, 0.1178, -1.7736> <-0.0270, 0.1178, -1.7736> <-0.0642, 0.1024, -1.7736> <-0.0833, 0.0833, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1469, -1.7061> <0.0000, 0.1392, -1.7268> <0.0000, 0.1268, -1.7535> <0.0000, 0.1178, -1.7736>
		<0.0337, 0.1469, -1.7061> <0.0337, 0.1392, -1.7268> <0.0270, 0.1268, -1.7535> <0.0270, 0.1178, -1.7736>
		<0.0800, 0.1277, -1.7061> <0.0746, 0.1223, -1.7268> <0.0705, 0.1088, -1.7535> <0.0642, 0.1024, -1.7736>
		<0.1039, 0.1039, -1.7061> <0.0984, 0.0984, -1.7268> <0.0896, 0.0896, -1.7535> <0.0833, 0.0833, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1039, 0.1039, -1.7061> <0.0984, 0.0984, -1.7268> <0.0896, 0.0896, -1.7535> <0.0833, 0.0833, -1.7736>
		<0.1277, 0.0800, -1.7061> <0.1223, 0.0746, -1.7268> <0.1088, 0.0705, -1.7535> <0.1024, 0.0642, -1.7736>
		<0.1469, 0.0337, -1.7061> <0.1392, 0.0337, -1.7268> <0.1268, 0.0270, -1.7535> <0.1178, 0.0270, -1.7736>
		<0.1469, 0.0000, -1.7061> <0.1392, 0.0000, -1.7268> <0.1268, 0.0000, -1.7535> <0.1178, 0.0000, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1469, 0.0000, -1.7061> <0.1392, 0.0000, -1.7268> <0.1268, 0.0000, -1.7535> <0.1178, 0.0000, -1.7736>
		<0.1469, -0.0337, -1.7061> <0.1392, -0.0337, -1.7268> <0.1268, -0.0270, -1.7535> <0.1178, -0.0270, -1.7736>
		<0.1277, -0.0800, -1.7061> <0.1223, -0.0746, -1.7268> <0.1088, -0.0705, -1.7535> <0.1024, -0.0642, -1.7736>
		<0.1039, -0.1039, -1.7061> <0.0984, -0.0984, -1.7268> <0.0896, -0.0896, -1.7535> <0.0833, -0.0833, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1039, -0.1039, -1.7061> <0.0984, -0.0984, -1.7268> <0.0896, -0.0896, -1.7535> <0.0833, -0.0833, -1.7736>
		<0.0800, -0.1277, -1.7061> <0.0746, -0.1223, -1.7268> <0.0705, -0.1088, -1.7535> <0.0642, -0.1024, -1.7736>
		<0.0337, -0.1469, -1.7061> <0.0337, -0.1392, -1.7268> <0.0270, -0.1268, -1.7535> <0.0270, -0.1178, -1.7736>
		<0.0000, -0.1469, -1.7061> <0.0000, -0.1392, -1.7268> <0.0000, -0.1268, -1.7535> <0.0000, -0.1178, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1469, -1.7061> <0.0000, -0.1392, -1.7268> <0.0000, -0.1268, -1.7535> <0.0000, -0.1178, -1.7736>
		<-0.0337, -0.1469, -1.7061> <-0.0337, -0.1392, -1.7268> <-0.0270, -0.1268, -1.7535> <-0.0270, -0.1178, -1.7736>
		<-0.0800, -0.1277, -1.7061> <-0.0746, -0.1223, -1.7268> <-0.0705, -0.1088, -1.7535> <-0.0642, -0.1024, -1.7736>
		<-0.1039, -0.1039, -1.7061> <-0.0984, -0.0984, -1.7268> <-0.0896, -0.0896, -1.7535> <-0.0833, -0.0833, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1039, -0.1039, -1.7061> <-0.0984, -0.0984, -1.7268> <-0.0896, -0.0896, -1.7535> <-0.0833, -0.0833, -1.7736>
		<-0.1277, -0.0800, -1.7061> <-0.1223, -0.0746, -1.7268> <-0.1088, -0.0705, -1.7535> <-0.1024, -0.0642, -1.7736>
		<-0.1469, -0.0337, -1.7061> <-0.1392, -0.0337, -1.7268> <-0.1268, -0.0270, -1.7535> <-0.1178, -0.0270, -1.7736>
		<-0.1469, 0.0000, -1.7061> <-0.1392, 0.0000, -1.7268> <-0.1268, 0.0000, -1.7535> <-0.1178, 0.0000, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1469, 0.0000, -1.7061> <-0.1392, 0.0000, -1.7268> <-0.1268, 0.0000, -1.7535> <-0.1178, 0.0000, -1.7736>
		<-0.1469, 0.0337, -1.7061> <-0.1392, 0.0337, -1.7268> <-0.1268, 0.0270, -1.7535> <-0.1178, 0.0270, -1.7736>
		<-0.1277, 0.0800, -1.7061> <-0.1223, 0.0746, -1.7268> <-0.1088, 0.0705, -1.7535> <-0.1024, 0.0642, -1.7736>
		<-0.1039, 0.1039, -1.7061> <-0.0984, 0.0984, -1.7268> <-0.0896, 0.0896, -1.7535> <-0.0833, 0.0833, -1.7736>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1178, -1.7736> <-0.0270, 0.1178, -1.7736> <-0.0642, 0.1024, -1.7736> <-0.0833, 0.0833, -1.7736>
		<0.0000, 0.1110, -1.7888> <-0.0270, 0.1110, -1.7888> <-0.0594, 0.0976, -1.7888> <-0.0785, 0.0785, -1.7888>
		<0.0000, 0.1015, -1.8089> <-0.0217, 0.1015, -1.8089> <-0.0564, 0.0871, -1.8089> <-0.0717, 0.0717, -1.8089>
		<0.0000, 0.0943, -1.8240> <-0.0217, 0.0943, -1.8240> <-0.0514, 0.0820, -1.8240> <-0.0667, 0.0667, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1178, -1.7736> <0.0000, 0.1110, -1.7888> <0.0000, 0.1015, -1.8089> <0.0000, 0.0943, -1.8240>
		<0.0270, 0.1178, -1.7736> <0.0270, 0.1110, -1.7888> <0.0217, 0.1015, -1.8089> <0.0217, 0.0943, -1.8240>
		<0.0642, 0.1024, -1.7736> <0.0594, 0.0976, -1.7888> <0.0564, 0.0871, -1.8089> <0.0514, 0.0820, -1.8240>
		<0.0833, 0.0833, -1.7736> <0.0785, 0.0785, -1.7888> <0.0717, 0.0717, -1.8089> <0.0667, 0.0667, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0833, 0.0833, -1.7736> <0.0785, 0.0785, -1.7888> <0.0717, 0.0717, -1.8089> <0.0667, 0.0667, -1.8240>
		<0.1024, 0.0642, -1.7736> <0.0976, 0.0594, -1.7888> <0.0871, 0.0564, -1.8089> <0.0820, 0.0514, -1.8240>
		<0.1178, 0.0270, -1.7736> <0.1110, 0.0270, -1.7888> <0.1015, 0.0217, -1.8089> <0.0943, 0.0217, -1.8240>
		<0.1178, 0.0000, -1.7736> <0.1110, 0.0000, -1.7888> <0.1015, 0.0000, -1.8089> <0.0943, 0.0000, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1178, 0.0000, -1.7736> <0.1110, 0.0000, -1.7888> <0.1015, 0.0000, -1.8089> <0.0943, 0.0000, -1.8240>
		<0.1178, -0.0270, -1.7736> <0.1110, -0.0270, -1.7888> <0.1015, -0.0217, -1.8089> <0.0943, -0.0217, -1.8240>
		<0.1024, -0.0642, -1.7736> <0.0976, -0.0594, -1.7888> <0.0871, -0.0564, -1.8089> <0.0820, -0.0514, -1.8240>
		<0.0833, -0.0833, -1.7736> <0.0785, -0.0785, -1.7888> <0.0717, -0.0717, -1.8089> <0.0667, -0.0667, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0833, -0.0833, -1.7736> <0.0785, -0.0785, -1.7888> <0.0717, -0.0717, -1.8089> <0.0667, -0.0667, -1.8240>
		<0.0642, -0.1024, -1.7736> <0.0594, -0.0976, -1.7888> <0.0564, -0.0871, -1.8089> <0.0514, -0.0820, -1.8240>
		<0.0270, -0.1178, -1.7736> <0.0270, -0.1110, -1.7888> <0.0217, -0.1015, -1.8089> <0.0217, -0.0943, -1.8240>
		<0.0000, -0.1178, -1.7736> <0.0000, -0.1110, -1.7888> <0.0000, -0.1015, -1.8089> <0.0000, -0.0943, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1178, -1.7736> <0.0000, -0.1110, -1.7888> <0.0000, -0.1015, -1.8089> <0.0000, -0.0943, -1.8240>
		<-0.0270, -0.1178, -1.7736> <-0.0270, -0.1110, -1.7888> <-0.0217, -0.1015, -1.8089> <-0.0217, -0.0943, -1.8240>
		<-0.0642, -0.1024, -1.7736> <-0.0594, -0.0976, -1.7888> <-0.0564, -0.0871, -1.8089> <-0.0514, -0.0820, -1.8240>
		<-0.0833, -0.0833, -1.7736> <-0.0785, -0.0785, -1.7888> <-0.0717, -0.0717, -1.8089> <-0.0667, -0.0667, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0833, -0.0833, -1.7736> <-0.0785, -0.0785, -1.7888> <-0.0717, -0.0717, -1.8089> <-0.0667, -0.0667, -1.8240>
		<-0.1024, -0.0642, -1.7736> <-0.0976, -0.0594, -1.7888> <-0.0871, -0.0564, -1.8089> <-0.0820, -0.0514, -1.8240>
		<-0.1178, -0.0270, -1.7736> <-0.1110, -0.0270, -1.7888> <-0.1015, -0.0217, -1.8089> <-0.0943, -0.0217, -1.8240>
		<-0.1178, 0.0000, -1.7736> <-0.1110, 0.0000, -1.7888> <-0.1015, 0.0000, -1.8089> <-0.0943, 0.0000, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1178, 0.0000, -1.7736> <-0.1110, 0.0000, -1.7888> <-0.1015, 0.0000, -1.8089> <-0.0943, 0.0000, -1.8240>
		<-0.1178, 0.0270, -1.7736> <-0.1110, 0.0270, -1.7888> <-0.1015, 0.0217, -1.8089> <-0.0943, 0.0217, -1.8240>
		<-0.1024, 0.0642, -1.7736> <-0.0976, 0.0594, -1.7888> <-0.0871, 0.0564, -1.8089> <-0.0820, 0.0514, -1.8240>
		<-0.0833, 0.0833, -1.7736> <-0.0785, 0.0785, -1.7888> <-0.0717, 0.0717, -1.8089> <-0.0667, 0.0667, -1.8240>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.0943, -1.8240> <-0.0217, 0.0943, -1.8240> <-0.0514, 0.0820, -1.8240> <-0.0667, 0.0667, -1.8240>
		<0.0000, 0.0871, -1.8392> <-0.0217, 0.0871, -1.8392> <-0.0462, 0.0769, -1.8392> <-0.0616, 0.0616, -1.8392>
		<0.0000, 0.0774, -1.8594> <-0.0160, 0.0774, -1.8594> <-0.0434, 0.0661, -1.8594> <-0.0547, 0.0547, -1.8594>
		<0.0000, 0.0698, -1.8744> <-0.0160, 0.0698, -1.8744> <-0.0380, 0.0607, -1.8744> <-0.0493, 0.0493, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.0943, -1.8240> <0.0000, 0.0871, -1.8392> <0.0000, 0.0774, -1.8594> <0.0000, 0.0698, -1.8744>
		<0.0217, 0.0943, -1.8240> <0.0217, 0.0871, -1.8392> <0.0160, 0.0774, -1.8594> <0.0160, 0.0698, -1.8744>
		<0.0514, 0.0820, -1.8240> <0.0462, 0.0769, -1.8392> <0.0434, 0.0661, -1.8594> <0.0380, 0.0607, -1.8744>
		<0.0667, 0.0667, -1.8240> <0.0616, 0.0616, -1.8392> <0.0547, 0.0547, -1.8594> <0.0493, 0.0493, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0667, 0.0667, -1.8240> <0.0616, 0.0616, -1.8392> <0.0547, 0.0547, -1.8594> <0.0493, 0.0493, -1.8744>
		<0.0820, 0.0514, -1.8240> <0.0769, 0.0462, -1.8392> <0.0661, 0.0434, -1.8594> <0.0607, 0.0380, -1.8744>
		<0.0943, 0.0217, -1.8240> <0.0871, 0.0217, -1.8392> <0.0774, 0.0160, -1.8594> <0.0698, 0.0160, -1.8744>
		<0.0943, 0.0000, -1.8240> <0.0871, 0.0000, -1.8392> <0.0774, 0.0000, -1.8594> <0.0698, 0.0000, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0943, 0.0000, -1.8240> <0.0871, 0.0000, -1.8392> <0.0774, 0.0000, -1.8594> <0.0698, 0.0000, -1.8744>
		<0.0943, -0.0217, -1.8240> <0.0871, -0.0217, -1.8392> <0.0774, -0.0160, -1.8594> <0.0698, -0.0160, -1.8744>
		<0.0820, -0.0514, -1.8240> <0.0769, -0.0462, -1.8392> <0.0661, -0.0434, -1.8594> <0.0607, -0.0380, -1.8744>
		<0.0667, -0.0667, -1.8240> <0.0616, -0.0616, -1.8392> <0.0547, -0.0547, -1.8594> <0.0493, -0.0493, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0667, -0.0667, -1.8240> <0.0616, -0.0616, -1.8392> <0.0547, -0.0547, -1.8594> <0.0493, -0.0493, -1.8744>
		<0.0514, -0.0820, -1.8240> <0.0462, -0.0769, -1.8392> <0.0434, -0.0661, -1.8594> <0.0380, -0.0607, -1.8744>
		<0.0217, -0.0943, -1.8240> <0.0217, -0.0871, -1.8392> <0.0160, -0.0774, -1.8594> <0.0160, -0.0698, -1.8744>
		<0.0000, -0.0943, -1.8240> <0.0000, -0.0871, -1.8392> <0.0000, -0.0774, -1.8594> <0.0000, -0.0698, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.0943, -1.8240> <0.0000, -0.0871, -1.8392> <0.0000, -0.0774, -1.8594> <0.0000, -0.0698, -1.8744>
		<-0.0217, -0.0943, -1.8240> <-0.0217, -0.0871, -1.8392> <-0.0160, -0.0774, -1.8594> <-0.0160, -0.0698, -1.8744>
		<-0.0514, -0.0820, -1.8240> <-0.0462, -0.0769, -1.8392> <-0.0434, -0.0661, -1.8594> <-0.0380, -0.0607, -1.8744>
		<-0.0667, -0.0667, -1.8240> <-0.0616, -0.0616, -1.8392> <-0.0547, -0.0547, -1.8594> <-0.0493, -0.0493, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0667, -0.0667, -1.8240> <-0.0616, -0.0616, -1.8392> <-0.0547, -0.0547, -1.8594> <-0.0493, -0.0493, -1.8744>
		<-0.0820, -0.0514, -1.8240> <-0.0769, -0.0462, -1.8392> <-0.0661, -0.0434, -1.8594> <-0.0607, -0.0380, -1.8744>
		<-0.0943, -0.0217, -1.8240> <-0.0871, -0.0217, -1.8392> <-0.0774, -0.0160, -1.8594> <-0.0698, -0.0160, -1.8744>
		<-0.0943, 0.0000, -1.8240> <-0.0871, 0.0000, -1.8392> <-0.0774, 0.0000, -1.8594> <-0.0698, 0.0000, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0943, 0.0000, -1.8240> <-0.0871, 0.0000, -1.8392> <-0.0774, 0.0000, -1.8594> <-0.0698, 0.0000, -1.8744>
		<-0.0943, 0.0217, -1.8240> <-0.0871, 0.0217, -1.8392> <-0.0774, 0.0160, -1.8594> <-0.0698, 0.0160, -1.8744>
		<-0.0820, 0.0514, -1.8240> <-0.0769, 0.0462, -1.8392> <-0.0661, 0.0434, -1.8594> <-0.0607, 0.0380, -1.8744>
		<-0.0667, 0.0667, -1.8240> <-0.0616, 0.0616, -1.8392> <-0.0547, 0.0547, -1.8594> <-0.0493, 0.0493, -1.8744>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.0698, -1.8744> <-0.0160, 0.0698, -1.8744> <-0.0380, 0.0607, -1.8744> <-0.0493, 0.0493, -1.8744>
		<0.0000, 0.0666, -1.8807> <-0.0160, 0.0666, -1.8807> <-0.0357, 0.0584, -1.8807> <-0.0471, 0.0471, -1.8807>
		<0.0000, 0.0619, -1.8888> <-0.0134, 0.0619, -1.8888> <-0.0343, 0.0532, -1.8888> <-0.0438, 0.0438, -1.8888>
		<0.0000, 0.0582, -1.8949> <-0.0134, 0.0582, -1.8949> <-0.0317, 0.0506, -1.8949> <-0.0412, 0.0412, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2 ///
		v_steps 2 ///
		<0.0000, 0.0698, -1.8744> <0.0000, 0.0666, -1.8807> <0.0000, 0.0619, -1.8888> <0.0000, 0.0582, -1.8949>
		<0.0160, 0.0698, -1.8744> <0.0160, 0.0666, -1.8807> <0.0134, 0.0619, -1.8888> <0.0134, 0.0582, -1.8949>
		<0.0380, 0.0607, -1.8744> <0.0357, 0.0584, -1.8807> <0.0343, 0.0532, -1.8888> <0.0317, 0.0506, -1.8949>
		<0.0493, 0.0493, -1.8744> <0.0471, 0.0471, -1.8807> <0.0438, 0.0438, -1.8888> <0.0412, 0.0412, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0493, 0.0493, -1.8744> <0.0471, 0.0471, -1.8807> <0.0438, 0.0438, -1.8888> <0.0412, 0.0412, -1.8949>
		<0.0607, 0.0380, -1.8744> <0.0584, 0.0357, -1.8807> <0.0532, 0.0343, -1.8888> <0.0506, 0.0317, -1.8949>
		<0.0698, 0.0160, -1.8744> <0.0666, 0.0160, -1.8807> <0.0619, 0.0134, -1.8888> <0.0582, 0.0134, -1.8949>
		<0.0698, 0.0000, -1.8744> <0.0666, 0.0000, -1.8807> <0.0619, 0.0000, -1.8888> <0.0582, 0.0000, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0698, 0.0000, -1.8744> <0.0666, 0.0000, -1.8807> <0.0619, 0.0000, -1.8888> <0.0582, 0.0000, -1.8949>
		<0.0698, -0.0160, -1.8744> <0.0666, -0.0160, -1.8807> <0.0619, -0.0134, -1.8888> <0.0582, -0.0134, -1.8949>
		<0.0607, -0.0380, -1.8744> <0.0584, -0.0357, -1.8807> <0.0532, -0.0343, -1.8888> <0.0506, -0.0317, -1.8949>
		<0.0493, -0.0493, -1.8744> <0.0471, -0.0471, -1.8807> <0.0438, -0.0438, -1.8888> <0.0412, -0.0412, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0493, -0.0493, -1.8744> <0.0471, -0.0471, -1.8807> <0.0438, -0.0438, -1.8888> <0.0412, -0.0412, -1.8949>
		<0.0380, -0.0607, -1.8744> <0.0357, -0.0584, -1.8807> <0.0343, -0.0532, -1.8888> <0.0317, -0.0506, -1.8949>
		<0.0160, -0.0698, -1.8744> <0.0160, -0.0666, -1.8807> <0.0134, -0.0619, -1.8888> <0.0134, -0.0582, -1.8949>
		<0.0000, -0.0698, -1.8744> <0.0000, -0.0666, -1.8807> <0.0000, -0.0619, -1.8888> <0.0000, -0.0582, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2 ///
		v_steps 2 ///
		<0.0000, -0.0698, -1.8744> <0.0000, -0.0666, -1.8807> <0.0000, -0.0619, -1.8888> <0.0000, -0.0582, -1.8949>
		<-0.0160, -0.0698, -1.8744> <-0.0160, -0.0666, -1.8807> <-0.0134, -0.0619, -1.8888> <-0.0134, -0.0582, -1.8949>
		<-0.0380, -0.0607, -1.8744> <-0.0357, -0.0584, -1.8807> <-0.0343, -0.0532, -1.8888> <-0.0317, -0.0506, -1.8949>
		<-0.0493, -0.0493, -1.8744> <-0.0471, -0.0471, -1.8807> <-0.0438, -0.0438, -1.8888> <-0.0412, -0.0412, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0493, -0.0493, -1.8744> <-0.0471, -0.0471, -1.8807> <-0.0438, -0.0438, -1.8888> <-0.0412, -0.0412, -1.8949>
		<-0.0607, -0.0380, -1.8744> <-0.0584, -0.0357, -1.8807> <-0.0532, -0.0343, -1.8888> <-0.0506, -0.0317, -1.8949>
		<-0.0698, -0.0160, -1.8744> <-0.0666, -0.0160, -1.8807> <-0.0619, -0.0134, -1.8888> <-0.0582, -0.0134, -1.8949>
		<-0.0698, 0.0000, -1.8744> <-0.0666, 0.0000, -1.8807> <-0.0619, 0.0000, -1.8888> <-0.0582, 0.0000, -1.8949>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0698, 0.0000, -1.8744> <-0.0666, 0.0000, -1.8807> <-0.0619, 0.0000, -1.8888> <-0.0582, 0.0000, -1.8949>
		<-0.0698, 0.0160, -1.8744> <-0.0666, 0.0160, -1.8807> <-0.0619, 0.0134, -1.8888> <-0.0582, 0.0134, -1.8949>
		<-0.0607, 0.0380, -1.8744> <-0.0584, 0.0357, -1.8807> <-0.0532, 0.0343, -1.8888> <-0.0506, 0.0317, -1.8949>
		<-0.0493, 0.0493, -1.8744> <-0.0471, 0.0471, -1.8807> <-0.0438, 0.0438, -1.8888> <-0.0412, 0.0412, -1.8949>
	}
	
    // Line 1228 ############################################################################
    // u and v steps are 1 or 2 from here to line 1627
      
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, 0.0582, -1.8949> <-0.0134, 0.0582, -1.8949> <-0.0317, 0.0506, -1.8949> <-0.0412, 0.0412, -1.8949>
		<0.0000, 0.0545, -1.9011> <-0.0134, 0.0545, -1.9011> <-0.0290, 0.0480, -1.9011> <-0.0385, 0.0385, -1.9011>
		<0.0000, 0.0490, -1.9092> <-0.0103, 0.0490, -1.9092> <-0.0273, 0.0419, -1.9092> <-0.0346, 0.0346, -1.9092>
		<0.0000, 0.0450, -1.9153> <-0.0103, 0.0450, -1.9153> <-0.0245, 0.0391, -1.9153> <-0.0318, 0.0318, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, 0.0582, -1.8949> <0.0000, 0.0545, -1.9011> <0.0000, 0.0490, -1.9092> <0.0000, 0.0450, -1.9153>
		<0.0134, 0.0582, -1.8949> <0.0134, 0.0545, -1.9011> <0.0103, 0.0490, -1.9092> <0.0103, 0.0450, -1.9153>
		<0.0317, 0.0506, -1.8949> <0.0290, 0.0480, -1.9011> <0.0273, 0.0419, -1.9092> <0.0245, 0.0391, -1.9153>
		<0.0412, 0.0412, -1.8949> <0.0385, 0.0385, -1.9011> <0.0346, 0.0346, -1.9092> <0.0318, 0.0318, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0412, 0.0412, -1.8949> <0.0385, 0.0385, -1.9011> <0.0346, 0.0346, -1.9092> <0.0318, 0.0318, -1.9153>
		<0.0506, 0.0317, -1.8949> <0.0480, 0.0290, -1.9011> <0.0419, 0.0273, -1.9092> <0.0391, 0.0245, -1.9153>
		<0.0582, 0.0134, -1.8949> <0.0545, 0.0134, -1.9011> <0.0490, 0.0103, -1.9092> <0.0450, 0.0103, -1.9153>
		<0.0582, 0.0000, -1.8949> <0.0545, 0.0000, -1.9011> <0.0490, 0.0000, -1.9092> <0.0450, 0.0000, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0582, 0.0000, -1.8949> <0.0545, 0.0000, -1.9011> <0.0490, 0.0000, -1.9092> <0.0450, 0.0000, -1.9153>
		<0.0582, -0.0134, -1.8949> <0.0545, -0.0134, -1.9011> <0.0490, -0.0103, -1.9092> <0.0450, -0.0103, -1.9153>
		<0.0506, -0.0317, -1.8949> <0.0480, -0.0290, -1.9011> <0.0419, -0.0273, -1.9092> <0.0391, -0.0245, -1.9153>
		<0.0412, -0.0412, -1.8949> <0.0385, -0.0385, -1.9011> <0.0346, -0.0346, -1.9092> <0.0318, -0.0318, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0412, -0.0412, -1.8949> <0.0385, -0.0385, -1.9011> <0.0346, -0.0346, -1.9092> <0.0318, -0.0318, -1.9153>
		<0.0317, -0.0506, -1.8949> <0.0290, -0.0480, -1.9011> <0.0273, -0.0419, -1.9092> <0.0245, -0.0391, -1.9153>
		<0.0134, -0.0582, -1.8949> <0.0134, -0.0545, -1.9011> <0.0103, -0.0490, -1.9092> <0.0103, -0.0450, -1.9153>
		<0.0000, -0.0582, -1.8949> <0.0000, -0.0545, -1.9011> <0.0000, -0.0490, -1.9092> <0.0000, -0.0450, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, -0.0582, -1.8949> <0.0000, -0.0545, -1.9011> <0.0000, -0.0490, -1.9092> <0.0000, -0.0450, -1.9153>
		<-0.0134, -0.0582, -1.8949> <-0.0134, -0.0545, -1.9011> <-0.0103, -0.0490, -1.9092> <-0.0103, -0.0450, -1.9153>
		<-0.0317, -0.0506, -1.8949> <-0.0290, -0.0480, -1.9011> <-0.0273, -0.0419, -1.9092> <-0.0245, -0.0391, -1.9153>
		<-0.0412, -0.0412, -1.8949> <-0.0385, -0.0385, -1.9011> <-0.0346, -0.0346, -1.9092> <-0.0318, -0.0318, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<-0.0412, -0.0412, -1.8949> <-0.0385, -0.0385, -1.9011> <-0.0346, -0.0346, -1.9092> <-0.0318, -0.0318, -1.9153>
		<-0.0506, -0.0317, -1.8949> <-0.0480, -0.0290, -1.9011> <-0.0419, -0.0273, -1.9092> <-0.0391, -0.0245, -1.9153>
		<-0.0582, -0.0134, -1.8949> <-0.0545, -0.0134, -1.9011> <-0.0490, -0.0103, -1.9092> <-0.0450, -0.0103, -1.9153>
		<-0.0582, 0.0000, -1.8949> <-0.0545, 0.0000, -1.9011> <-0.0490, 0.0000, -1.9092> <-0.0450, 0.0000, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<-0.0582, 0.0000, -1.8949> <-0.0545, 0.0000, -1.9011> <-0.0490, 0.0000, -1.9092> <-0.0450, 0.0000, -1.9153>
		<-0.0582, 0.0134, -1.8949> <-0.0545, 0.0134, -1.9011> <-0.0490, 0.0103, -1.9092> <-0.0450, 0.0103, -1.9153>
		<-0.0506, 0.0317, -1.8949> <-0.0480, 0.0290, -1.9011> <-0.0419, 0.0273, -1.9092> <-0.0391, 0.0245, -1.9153>
		<-0.0412, 0.0412, -1.8949> <-0.0385, 0.0385, -1.9011> <-0.0346, 0.0346, -1.9092> <-0.0318, 0.0318, -1.9153>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, 0.0450, -1.9153> <-0.0103, 0.0450, -1.9153> <-0.0245, 0.0391, -1.9153> <-0.0318, 0.0318, -1.9153>
		<0.0000, 0.0413, -1.9209> <-0.0103, 0.0413, -1.9209> <-0.0219, 0.0365, -1.9209> <-0.0292, 0.0292, -1.9209>
		<0.0000, 0.0363, -1.9284> <-0.0075, 0.0363, -1.9284> <-0.0203, 0.0310, -1.9284> <-0.0257, 0.0257, -1.9284>
		<0.0000, 0.0327, -1.9341> <-0.0075, 0.0327, -1.9341> <-0.0178, 0.0284, -1.9341> <-0.0231, 0.0231, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, 0.0450, -1.9153> <0.0000, 0.0413, -1.9209> <0.0000, 0.0363, -1.9284> <0.0000, 0.0327, -1.9341>
		<0.0103, 0.0450, -1.9153> <0.0103, 0.0413, -1.9209> <0.0075, 0.0363, -1.9284> <0.0075, 0.0327, -1.9341>
		<0.0245, 0.0391, -1.9153> <0.0219, 0.0365, -1.9209> <0.0203, 0.0310, -1.9284> <0.0178, 0.0284, -1.9341>
		<0.0318, 0.0318, -1.9153> <0.0292, 0.0292, -1.9209> <0.0257, 0.0257, -1.9284> <0.0231, 0.0231, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0318, 0.0318, -1.9153> <0.0292, 0.0292, -1.9209> <0.0257, 0.0257, -1.9284> <0.0231, 0.0231, -1.9341>
		<0.0391, 0.0245, -1.9153> <0.0365, 0.0219, -1.9209> <0.0310, 0.0203, -1.9284> <0.0284, 0.0178, -1.9341>
		<0.0450, 0.0103, -1.9153> <0.0413, 0.0103, -1.9209> <0.0363, 0.0075, -1.9284> <0.0327, 0.0075, -1.9341>
		<0.0450, 0.0000, -1.9153> <0.0413, 0.0000, -1.9209> <0.0363, 0.0000, -1.9284> <0.0327, 0.0000, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0450, 0.0000, -1.9153> <0.0413, 0.0000, -1.9209> <0.0363, 0.0000, -1.9284> <0.0327, 0.0000, -1.9341>
		<0.0450, -0.0103, -1.9153> <0.0413, -0.0103, -1.9209> <0.0363, -0.0075, -1.9284> <0.0327, -0.0075, -1.9341>
		<0.0391, -0.0245, -1.9153> <0.0365, -0.0219, -1.9209> <0.0310, -0.0203, -1.9284> <0.0284, -0.0178, -1.9341>
		<0.0318, -0.0318, -1.9153> <0.0292, -0.0292, -1.9209> <0.0257, -0.0257, -1.9284> <0.0231, -0.0231, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0318, -0.0318, -1.9153> <0.0292, -0.0292, -1.9209> <0.0257, -0.0257, -1.9284> <0.0231, -0.0231, -1.9341>
		<0.0245, -0.0391, -1.9153> <0.0219, -0.0365, -1.9209> <0.0203, -0.0310, -1.9284> <0.0178, -0.0284, -1.9341>
		<0.0103, -0.0450, -1.9153> <0.0103, -0.0413, -1.9209> <0.0075, -0.0363, -1.9284> <0.0075, -0.0327, -1.9341>
		<0.0000, -0.0450, -1.9153> <0.0000, -0.0413, -1.9209> <0.0000, -0.0363, -1.9284> <0.0000, -0.0327, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, -0.0450, -1.9153> <0.0000, -0.0413, -1.9209> <0.0000, -0.0363, -1.9284> <0.0000, -0.0327, -1.9341>
		<-0.0103, -0.0450, -1.9153> <-0.0103, -0.0413, -1.9209> <-0.0075, -0.0363, -1.9284> <-0.0075, -0.0327, -1.9341>
		<-0.0245, -0.0391, -1.9153> <-0.0219, -0.0365, -1.9209> <-0.0203, -0.0310, -1.9284> <-0.0178, -0.0284, -1.9341>
		<-0.0318, -0.0318, -1.9153> <-0.0292, -0.0292, -1.9209> <-0.0257, -0.0257, -1.9284> <-0.0231, -0.0231, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<-0.0318, -0.0318, -1.9153> <-0.0292, -0.0292, -1.9209> <-0.0257, -0.0257, -1.9284> <-0.0231, -0.0231, -1.9341>
		<-0.0391, -0.0245, -1.9153> <-0.0365, -0.0219, -1.9209> <-0.0310, -0.0203, -1.9284> <-0.0284, -0.0178, -1.9341>
		<-0.0450, -0.0103, -1.9153> <-0.0413, -0.0103, -1.9209> <-0.0363, -0.0075, -1.9284> <-0.0327, -0.0075, -1.9341>
		<-0.0450, 0.0000, -1.9153> <-0.0413, 0.0000, -1.9209> <-0.0363, 0.0000, -1.9284> <-0.0327, 0.0000, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<-0.0450, 0.0000, -1.9153> <-0.0413, 0.0000, -1.9209> <-0.0363, 0.0000, -1.9284> <-0.0327, 0.0000, -1.9341>
		<-0.0450, 0.0103, -1.9153> <-0.0413, 0.0103, -1.9209> <-0.0363, 0.0075, -1.9284> <-0.0327, 0.0075, -1.9341>
		<-0.0391, 0.0245, -1.9153> <-0.0365, 0.0219, -1.9209> <-0.0310, 0.0203, -1.9284> <-0.0284, 0.0178, -1.9341>
		<-0.0318, 0.0318, -1.9153> <-0.0292, 0.0292, -1.9209> <-0.0257, 0.0257, -1.9284> <-0.0231, 0.0231, -1.9341>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, 0.0327, -1.9341> <-0.0075, 0.0327, -1.9341> <-0.0178, 0.0284, -1.9341> <-0.0231, 0.0231, -1.9341>
		<0.0000, 0.0291, -1.9397> <-0.0075, 0.0291, -1.9397> <-0.0153, 0.0259, -1.9397> <-0.0206, 0.0206, -1.9397>
		<0.0000, 0.0243, -1.9472> <-0.0049, 0.0243, -1.9472> <-0.0138, 0.0206, -1.9472> <-0.0172, 0.0172, -1.9472>
		<0.0000, 0.0211, -1.9530> <-0.0049, 0.0211, -1.9530> <-0.0115, 0.0184, -1.9530> <-0.0149, 0.0149, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 2
		v_steps 2
		<0.0000, 0.0327, -1.9341> <0.0000, 0.0291, -1.9397> <0.0000, 0.0243, -1.9472> <0.0000, 0.0211, -1.9530>
		<0.0075, 0.0327, -1.9341> <0.0075, 0.0291, -1.9397> <0.0049, 0.0243, -1.9472> <0.0049, 0.0211, -1.9530>
		<0.0178, 0.0284, -1.9341> <0.0153, 0.0259, -1.9397> <0.0138, 0.0206, -1.9472> <0.0115, 0.0184, -1.9530>
		<0.0231, 0.0231, -1.9341> <0.0206, 0.0206, -1.9397> <0.0172, 0.0172, -1.9472> <0.0149, 0.0149, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0231, 0.0231, -1.9341> <0.0206, 0.0206, -1.9397> <0.0172, 0.0172, -1.9472> <0.0149, 0.0149, -1.9530>
		<0.0284, 0.0178, -1.9341> <0.0259, 0.0153, -1.9397> <0.0206, 0.0138, -1.9472> <0.0184, 0.0115, -1.9530>
		<0.0327, 0.0075, -1.9341> <0.0291, 0.0075, -1.9397> <0.0243, 0.0049, -1.9472> <0.0211, 0.0049, -1.9530>
		<0.0327, 0.0000, -1.9341> <0.0291, 0.0000, -1.9397> <0.0243, 0.0000, -1.9472> <0.0211, 0.0000, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0327, 0.0000, -1.9341> <0.0291, 0.0000, -1.9397> <0.0243, 0.0000, -1.9472> <0.0211, 0.0000, -1.9530>
		<0.0327, -0.0075, -1.9341> <0.0291, -0.0075, -1.9397> <0.0243, -0.0049, -1.9472> <0.0211, -0.0049, -1.9530>
		<0.0284, -0.0178, -1.9341> <0.0259, -0.0153, -1.9397> <0.0206, -0.0138, -1.9472> <0.0184, -0.0115, -1.9530>
		<0.0231, -0.0231, -1.9341> <0.0206, -0.0206, -1.9397> <0.0172, -0.0172, -1.9472> <0.0149, -0.0149, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0231, -0.0231, -1.9341> <0.0206, -0.0206, -1.9397> <0.0172, -0.0172, -1.9472> <0.0149, -0.0149, -1.9530>
		<0.0178, -0.0284, -1.9341> <0.0153, -0.0259, -1.9397> <0.0138, -0.0206, -1.9472> <0.0115, -0.0184, -1.9530>
		<0.0075, -0.0327, -1.9341> <0.0075, -0.0291, -1.9397> <0.0049, -0.0243, -1.9472> <0.0049, -0.0211, -1.9530>
		<0.0000, -0.0327, -1.9341> <0.0000, -0.0291, -1.9397> <0.0000, -0.0243, -1.9472> <0.0000, -0.0211, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, -0.0327, -1.9341> <0.0000, -0.0291, -1.9397> <0.0000, -0.0243, -1.9472> <0.0000, -0.0211, -1.9530>
		<-0.0075, -0.0327, -1.9341> <-0.0075, -0.0291, -1.9397> <-0.0049, -0.0243, -1.9472> <-0.0049, -0.0211, -1.9530>
		<-0.0178, -0.0284, -1.9341> <-0.0153, -0.0259, -1.9397> <-0.0138, -0.0206, -1.9472> <-0.0115, -0.0184, -1.9530>
		<-0.0231, -0.0231, -1.9341> <-0.0206, -0.0206, -1.9397> <-0.0172, -0.0172, -1.9472> <-0.0149, -0.0149, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0231, -0.0231, -1.9341> <-0.0206, -0.0206, -1.9397> <-0.0172, -0.0172, -1.9472> <-0.0149, -0.0149, -1.9530>
		<-0.0284, -0.0178, -1.9341> <-0.0259, -0.0153, -1.9397> <-0.0206, -0.0138, -1.9472> <-0.0184, -0.0115, -1.9530>
		<-0.0327, -0.0075, -1.9341> <-0.0291, -0.0075, -1.9397> <-0.0243, -0.0049, -1.9472> <-0.0211, -0.0049, -1.9530>
		<-0.0327, 0.0000, -1.9341> <-0.0291, 0.0000, -1.9397> <-0.0243, 0.0000, -1.9472> <-0.0211, 0.0000, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0327, 0.0000, -1.9341> <-0.0291, 0.0000, -1.9397> <-0.0243, 0.0000, -1.9472> <-0.0211, 0.0000, -1.9530>
		<-0.0327, 0.0075, -1.9341> <-0.0291, 0.0075, -1.9397> <-0.0243, 0.0049, -1.9472> <-0.0211, 0.0049, -1.9530>
		<-0.0284, 0.0178, -1.9341> <-0.0259, 0.0153, -1.9397> <-0.0206, 0.0138, -1.9472> <-0.0184, 0.0115, -1.9530>
		<-0.0231, 0.0231, -1.9341> <-0.0206, 0.0206, -1.9397> <-0.0172, 0.0172, -1.9472> <-0.0149, 0.0149, -1.9530>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, 0.0211, -1.9530> <-0.0049, 0.0211, -1.9530> <-0.0115, 0.0184, -1.9530> <-0.0149, 0.0149, -1.9530>
		<0.0000, 0.0187, -1.9575> <-0.0049, 0.0187, -1.9575> <-0.0098, 0.0166, -1.9575> <-0.0132, 0.0132, -1.9575>
		<0.0000, 0.0158, -1.9639> <-0.0032, 0.0158, -1.9639> <-0.0089, 0.0134, -1.9639> <-0.0112, 0.0112, -1.9639>
		<0.0000, 0.0138, -1.9686> <-0.0032, 0.0138, -1.9686> <-0.0075, 0.0120, -1.9686> <-0.0097, 0.0097, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, 0.0211, -1.9530> <0.0000, 0.0187, -1.9575> <0.0000, 0.0158, -1.9639> <0.0000, 0.0138, -1.9686>
		<0.0049, 0.0211, -1.9530> <0.0049, 0.0187, -1.9575> <0.0032, 0.0158, -1.9639> <0.0032, 0.0138, -1.9686>
		<0.0115, 0.0184, -1.9530> <0.0098, 0.0166, -1.9575> <0.0089, 0.0134, -1.9639> <0.0075, 0.0120, -1.9686>
		<0.0149, 0.0149, -1.9530> <0.0132, 0.0132, -1.9575> <0.0112, 0.0112, -1.9639> <0.0097, 0.0097, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0149, 0.0149, -1.9530> <0.0132, 0.0132, -1.9575> <0.0112, 0.0112, -1.9639> <0.0097, 0.0097, -1.9686>
		<0.0184, 0.0115, -1.9530> <0.0166, 0.0098, -1.9575> <0.0134, 0.0089, -1.9639> <0.0120, 0.0075, -1.9686>
		<0.0211, 0.0049, -1.9530> <0.0187, 0.0049, -1.9575> <0.0158, 0.0032, -1.9639> <0.0138, 0.0032, -1.9686>
		<0.0211, 0.0000, -1.9530> <0.0187, 0.0000, -1.9575> <0.0158, 0.0000, -1.9639> <0.0138, 0.0000, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0211, 0.0000, -1.9530> <0.0187, 0.0000, -1.9575> <0.0158, 0.0000, -1.9639> <0.0138, 0.0000, -1.9686>
		<0.0211, -0.0049, -1.9530> <0.0187, -0.0049, -1.9575> <0.0158, -0.0032, -1.9639> <0.0138, -0.0032, -1.9686>
		<0.0184, -0.0115, -1.9530> <0.0166, -0.0098, -1.9575> <0.0134, -0.0089, -1.9639> <0.0120, -0.0075, -1.9686>
		<0.0149, -0.0149, -1.9530> <0.0132, -0.0132, -1.9575> <0.0112, -0.0112, -1.9639> <0.0097, -0.0097, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0149, -0.0149, -1.9530> <0.0132, -0.0132, -1.9575> <0.0112, -0.0112, -1.9639> <0.0097, -0.0097, -1.9686>
		<0.0115, -0.0184, -1.9530> <0.0098, -0.0166, -1.9575> <0.0089, -0.0134, -1.9639> <0.0075, -0.0120, -1.9686>
		<0.0049, -0.0211, -1.9530> <0.0049, -0.0187, -1.9575> <0.0032, -0.0158, -1.9639> <0.0032, -0.0138, -1.9686>
		<0.0000, -0.0211, -1.9530> <0.0000, -0.0187, -1.9575> <0.0000, -0.0158, -1.9639> <0.0000, -0.0138, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, -0.0211, -1.9530> <0.0000, -0.0187, -1.9575> <0.0000, -0.0158, -1.9639> <0.0000, -0.0138, -1.9686>
		<-0.0049, -0.0211, -1.9530> <-0.0049, -0.0187, -1.9575> <-0.0032, -0.0158, -1.9639> <-0.0032, -0.0138, -1.9686>
		<-0.0115, -0.0184, -1.9530> <-0.0098, -0.0166, -1.9575> <-0.0089, -0.0134, -1.9639> <-0.0075, -0.0120, -1.9686>
		<-0.0149, -0.0149, -1.9530> <-0.0132, -0.0132, -1.9575> <-0.0112, -0.0112, -1.9639> <-0.0097, -0.0097, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0149, -0.0149, -1.9530> <-0.0132, -0.0132, -1.9575> <-0.0112, -0.0112, -1.9639> <-0.0097, -0.0097, -1.9686>
		<-0.0184, -0.0115, -1.9530> <-0.0166, -0.0098, -1.9575> <-0.0134, -0.0089, -1.9639> <-0.0120, -0.0075, -1.9686>
		<-0.0211, -0.0049, -1.9530> <-0.0187, -0.0049, -1.9575> <-0.0158, -0.0032, -1.9639> <-0.0138, -0.0032, -1.9686>
		<-0.0211, 0.0000, -1.9530> <-0.0187, 0.0000, -1.9575> <-0.0158, 0.0000, -1.9639> <-0.0138, 0.0000, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0211, 0.0000, -1.9530> <-0.0187, 0.0000, -1.9575> <-0.0158, 0.0000, -1.9639> <-0.0138, 0.0000, -1.9686>
		<-0.0211, 0.0049, -1.9530> <-0.0187, 0.0049, -1.9575> <-0.0158, 0.0032, -1.9639> <-0.0138, 0.0032, -1.9686>
		<-0.0184, 0.0115, -1.9530> <-0.0166, 0.0098, -1.9575> <-0.0134, 0.0089, -1.9639> <-0.0120, 0.0075, -1.9686>
		<-0.0149, 0.0149, -1.9530> <-0.0132, 0.0132, -1.9575> <-0.0112, 0.0112, -1.9639> <-0.0097, 0.0097, -1.9686>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, 0.0138, -1.9686> <-0.0032, 0.0138, -1.9686> <-0.0075, 0.0120, -1.9686> <-0.0097, 0.0097, -1.9686>
		<0.0000, 0.0121, -1.9726> <-0.0032, 0.0121, -1.9726> <-0.0063, 0.0108, -1.9726> <-0.0085, 0.0085, -1.9726>
		<0.0000, 0.0094, -1.9778> <-0.0020, 0.0094, -1.9778> <-0.0053, 0.0081, -1.9778> <-0.0067, 0.0067, -1.9778>
		<0.0000, 0.0087, -1.9820> <-0.0020, 0.0087, -1.9820> <-0.0048, 0.0076, -1.9820> <-0.0062, 0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, 0.0138, -1.9686> <0.0000, 0.0121, -1.9726> <0.0000, 0.0094, -1.9778> <0.0000, 0.0087, -1.9820>
		<0.0032, 0.0138, -1.9686> <0.0032, 0.0121, -1.9726> <0.0020, 0.0094, -1.9778> <0.0020, 0.0087, -1.9820>
		<0.0075, 0.0120, -1.9686> <0.0063, 0.0108, -1.9726> <0.0053, 0.0081, -1.9778> <0.0048, 0.0076, -1.9820>
		<0.0097, 0.0097, -1.9686> <0.0085, 0.0085, -1.9726> <0.0067, 0.0067, -1.9778> <0.0062, 0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0097, 0.0097, -1.9686> <0.0085, 0.0085, -1.9726> <0.0067, 0.0067, -1.9778> <0.0062, 0.0062, -1.9820>
		<0.0120, 0.0075, -1.9686> <0.0108, 0.0063, -1.9726> <0.0081, 0.0053, -1.9778> <0.0076, 0.0048, -1.9820>
		<0.0138, 0.0032, -1.9686> <0.0121, 0.0032, -1.9726> <0.0094, 0.0020, -1.9778> <0.0087, 0.0020, -1.9820>
		<0.0138, 0.0000, -1.9686> <0.0121, 0.0000, -1.9726> <0.0094, 0.0000, -1.9778> <0.0087, 0.0000, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0138, 0.0000, -1.9686> <0.0121, 0.0000, -1.9726> <0.0094, 0.0000, -1.9778> <0.0087, 0.0000, -1.9820>
		<0.0138, -0.0032, -1.9686> <0.0121, -0.0032, -1.9726> <0.0094, -0.0020, -1.9778> <0.0087, -0.0020, -1.9820>
		<0.0120, -0.0075, -1.9686> <0.0108, -0.0063, -1.9726> <0.0081, -0.0053, -1.9778> <0.0076, -0.0048, -1.9820>
		<0.0097, -0.0097, -1.9686> <0.0085, -0.0085, -1.9726> <0.0067, -0.0067, -1.9778> <0.0062, -0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0097, -0.0097, -1.9686> <0.0085, -0.0085, -1.9726> <0.0067, -0.0067, -1.9778> <0.0062, -0.0062, -1.9820>
		<0.0075, -0.0120, -1.9686> <0.0063, -0.0108, -1.9726> <0.0053, -0.0081, -1.9778> <0.0048, -0.0076, -1.9820>
		<0.0032, -0.0138, -1.9686> <0.0032, -0.0121, -1.9726> <0.0020, -0.0094, -1.9778> <0.0020, -0.0087, -1.9820>
		<0.0000, -0.0138, -1.9686> <0.0000, -0.0121, -1.9726> <0.0000, -0.0094, -1.9778> <0.0000, -0.0087, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, -0.0138, -1.9686> <0.0000, -0.0121, -1.9726> <0.0000, -0.0094, -1.9778> <0.0000, -0.0087, -1.9820>
		<-0.0032, -0.0138, -1.9686> <-0.0032, -0.0121, -1.9726> <-0.0020, -0.0094, -1.9778> <-0.0020, -0.0087, -1.9820>
		<-0.0075, -0.0120, -1.9686> <-0.0063, -0.0108, -1.9726> <-0.0053, -0.0081, -1.9778> <-0.0048, -0.0076, -1.9820>
		<-0.0097, -0.0097, -1.9686> <-0.0085, -0.0085, -1.9726> <-0.0067, -0.0067, -1.9778> <-0.0062, -0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0097, -0.0097, -1.9686> <-0.0085, -0.0085, -1.9726> <-0.0067, -0.0067, -1.9778> <-0.0062, -0.0062, -1.9820>
		<-0.0120, -0.0075, -1.9686> <-0.0108, -0.0063, -1.9726> <-0.0081, -0.0053, -1.9778> <-0.0076, -0.0048, -1.9820>
		<-0.0138, -0.0032, -1.9686> <-0.0121, -0.0032, -1.9726> <-0.0094, -0.0020, -1.9778> <-0.0087, -0.0020, -1.9820>
		<-0.0138, 0.0000, -1.9686> <-0.0121, 0.0000, -1.9726> <-0.0094, 0.0000, -1.9778> <-0.0087, 0.0000, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0138, 0.0000, -1.9686> <-0.0121, 0.0000, -1.9726> <-0.0094, 0.0000, -1.9778> <-0.0087, 0.0000, -1.9820>
		<-0.0138, 0.0032, -1.9686> <-0.0121, 0.0032, -1.9726> <-0.0094, 0.0020, -1.9778> <-0.0087, 0.0020, -1.9820>
		<-0.0120, 0.0075, -1.9686> <-0.0108, 0.0063, -1.9726> <-0.0081, 0.0053, -1.9778> <-0.0076, 0.0048, -1.9820>
		<-0.0097, 0.0097, -1.9686> <-0.0085, 0.0085, -1.9726> <-0.0067, 0.0067, -1.9778> <-0.0062, 0.0062, -1.9820>
	}
	 
  // Line 1632 #######################################################################
  
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3236, 0.0000> <0.0000, 0.3226, 0.0714> <0.0000, 0.3226, 0.1666> <0.0000, 0.3188, 0.2378>
		<-0.0743, 0.3236, 0.0000> <-0.0743, 0.3226, 0.0714> <-0.0732, 0.3226, 0.1666> <-0.0732, 0.3188, 0.2378>
		<-0.1762, 0.2813, 0.0000> <-0.1755, 0.2806, 0.0714> <-0.1763, 0.2798, 0.1666> <-0.1736, 0.2771, 0.2378>
		<-0.2288, 0.2288, 0.0000> <-0.2281, 0.2281, 0.0714> <-0.2280, 0.2280, 0.1666> <-0.2254, 0.2254, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3236, 0.0000> <0.0743, 0.3236, 0.0000> <0.1762, 0.2813, 0.0000> <0.2288, 0.2288, 0.0000>
		<0.0000, 0.3226, 0.0714> <0.0743, 0.3226, 0.0714> <0.1755, 0.2806, 0.0714> <0.2281, 0.2281, 0.0714>
		<0.0000, 0.3226, 0.1666> <0.0732, 0.3226, 0.1666> <0.1763, 0.2798, 0.1666> <0.2280, 0.2280, 0.1666>
		<0.0000, 0.3188, 0.2378> <0.0732, 0.3188, 0.2378> <0.1736, 0.2771, 0.2378> <0.2254, 0.2254, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2288, 0.2288, 0.0000> <0.2813, 0.1762, 0.0000> <0.3236, 0.0743, 0.0000> <0.3236, 0.0000, 0.0000>
		<0.2281, 0.2281, 0.0714> <0.2806, 0.1755, 0.0714> <0.3226, 0.0743, 0.0714> <0.3226, 0.0000, 0.0714>
		<0.2280, 0.2280, 0.1666> <0.2798, 0.1763, 0.1666> <0.3226, 0.0732, 0.1666> <0.3226, 0.0000, 0.1666>
		<0.2254, 0.2254, 0.2378> <0.2771, 0.1736, 0.2378> <0.3188, 0.0732, 0.2378> <0.3188, 0.0000, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3236, 0.0000, 0.0000> <0.3236, -0.0743, 0.0000> <0.2813, -0.1762, 0.0000> <0.2288, -0.2288, 0.0000>
		<0.3226, 0.0000, 0.0714> <0.3226, -0.0743, 0.0714> <0.2806, -0.1755, 0.0714> <0.2281, -0.2281, 0.0714>
		<0.3226, 0.0000, 0.1666> <0.3226, -0.0732, 0.1666> <0.2798, -0.1763, 0.1666> <0.2280, -0.2280, 0.1666>
		<0.3188, 0.0000, 0.2378> <0.3188, -0.0732, 0.2378> <0.2771, -0.1736, 0.2378> <0.2254, -0.2254, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2288, -0.2288, 0.0000> <0.1762, -0.2813, 0.0000> <0.0743, -0.3236, 0.0000> <0.0000, -0.3236, 0.0000>
		<0.2281, -0.2281, 0.0714> <0.1755, -0.2806, 0.0714> <0.0743, -0.3226, 0.0714> <0.0000, -0.3226, 0.0714>
		<0.2280, -0.2280, 0.1666> <0.1763, -0.2798, 0.1666> <0.0732, -0.3226, 0.1666> <0.0000, -0.3226, 0.1666>
		<0.2254, -0.2254, 0.2378> <0.1736, -0.2771, 0.2378> <0.0732, -0.3188, 0.2378> <0.0000, -0.3188, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3236, 0.0000> <-0.0743, -0.3236, 0.0000> <-0.1762, -0.2813, 0.0000> <-0.2288, -0.2288, 0.0000>
		<0.0000, -0.3226, 0.0714> <-0.0743, -0.3226, 0.0714> <-0.1755, -0.2806, 0.0714> <-0.2281, -0.2281, 0.0714>
		<0.0000, -0.3226, 0.1666> <-0.0732, -0.3226, 0.1666> <-0.1763, -0.2798, 0.1666> <-0.2280, -0.2280, 0.1666>
		<0.0000, -0.3188, 0.2378> <-0.0732, -0.3188, 0.2378> <-0.1736, -0.2771, 0.2378> <-0.2254, -0.2254, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2288, -0.2288, 0.0000> <-0.2813, -0.1762, 0.0000> <-0.3236, -0.0743, 0.0000> <-0.3236, 0.0000, 0.0000>
		<-0.2281, -0.2281, 0.0714> <-0.2806, -0.1755, 0.0714> <-0.3226, -0.0743, 0.0714> <-0.3226, 0.0000, 0.0714>
		<-0.2280, -0.2280, 0.1666> <-0.2798, -0.1763, 0.1666> <-0.3226, -0.0732, 0.1666> <-0.3226, 0.0000, 0.1666>
		<-0.2254, -0.2254, 0.2378> <-0.2771, -0.1736, 0.2378> <-0.3188, -0.0732, 0.2378> <-0.3188, 0.0000, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3236, 0.0000, 0.0000> <-0.3236, 0.0743, 0.0000> <-0.2813, 0.1762, 0.0000> <-0.2288, 0.2288, 0.0000>
		<-0.3226, 0.0000, 0.0714> <-0.3226, 0.0743, 0.0714> <-0.2806, 0.1755, 0.0714> <-0.2281, 0.2281, 0.0714>
		<-0.3226, 0.0000, 0.1666> <-0.3226, 0.0732, 0.1666> <-0.2798, 0.1763, 0.1666> <-0.2280, 0.2280, 0.1666>
		<-0.3188, 0.0000, 0.2378> <-0.3188, 0.0732, 0.2378> <-0.2771, 0.1736, 0.2378> <-0.2254, 0.2254, 0.2378>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3188, 0.2378> <0.0000, 0.3146, 0.3163> <0.0000, 0.3041, 0.4205> <0.0000, 0.2972, 0.4987>
		<-0.0732, 0.3188, 0.2378> <-0.0732, 0.3146, 0.3163> <-0.0682, 0.3041, 0.4205> <-0.0682, 0.2972, 0.4987>
		<-0.1736, 0.2771, 0.2378> <-0.1707, 0.2742, 0.3163> <-0.1667, 0.2632, 0.4205> <-0.1619, 0.2584, 0.4987>
		<-0.2254, 0.2254, 0.2378> <-0.2225, 0.2225, 0.3163> <-0.2150, 0.2150, 0.4205> <-0.2101, 0.2101, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.3188, 0.2378> <0.0732, 0.3188, 0.2378> <0.1736, 0.2771, 0.2378> <0.2254, 0.2254, 0.2378>
		<0.0000, 0.3146, 0.3163> <0.0732, 0.3146, 0.3163> <0.1707, 0.2742, 0.3163> <0.2225, 0.2225, 0.3163>
		<0.0000, 0.3041, 0.4205> <0.0682, 0.3041, 0.4205> <0.1667, 0.2632, 0.4205> <0.2150, 0.2150, 0.4205>
		<0.0000, 0.2972, 0.4987> <0.0682, 0.2972, 0.4987> <0.1619, 0.2584, 0.4987> <0.2101, 0.2101, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2254, 0.2254, 0.2378> <0.2771, 0.1736, 0.2378> <0.3188, 0.0732, 0.2378> <0.3188, 0.0000, 0.2378>
		<0.2225, 0.2225, 0.3163> <0.2742, 0.1707, 0.3163> <0.3146, 0.0732, 0.3163> <0.3146, 0.0000, 0.3163>
		<0.2150, 0.2150, 0.4205> <0.2632, 0.1667, 0.4205> <0.3041, 0.0682, 0.4205> <0.3041, 0.0000, 0.4205>
		<0.2101, 0.2101, 0.4987> <0.2584, 0.1619, 0.4987> <0.2972, 0.0682, 0.4987> <0.2972, 0.0000, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.3188, 0.0000, 0.2378> <0.3188, -0.0732, 0.2378> <0.2771, -0.1736, 0.2378> <0.2254, -0.2254, 0.2378>
		<0.3146, 0.0000, 0.3163> <0.3146, -0.0732, 0.3163> <0.2742, -0.1707, 0.3163> <0.2225, -0.2225, 0.3163>
		<0.3041, 0.0000, 0.4205> <0.3041, -0.0682, 0.4205> <0.2632, -0.1667, 0.4205> <0.2150, -0.2150, 0.4205>
		<0.2972, 0.0000, 0.4987> <0.2972, -0.0682, 0.4987> <0.2584, -0.1619, 0.4987> <0.2101, -0.2101, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2254, -0.2254, 0.2378> <0.1736, -0.2771, 0.2378> <0.0732, -0.3188, 0.2378> <0.0000, -0.3188, 0.2378>
		<0.2225, -0.2225, 0.3163> <0.1707, -0.2742, 0.3163> <0.0732, -0.3146, 0.3163> <0.0000, -0.3146, 0.3163>
		<0.2150, -0.2150, 0.4205> <0.1667, -0.2632, 0.4205> <0.0682, -0.3041, 0.4205> <0.0000, -0.3041, 0.4205>
		<0.2101, -0.2101, 0.4987> <0.1619, -0.2584, 0.4987> <0.0682, -0.2972, 0.4987> <0.0000, -0.2972, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.3188, 0.2378> <-0.0732, -0.3188, 0.2378> <-0.1736, -0.2771, 0.2378> <-0.2254, -0.2254, 0.2378>
		<0.0000, -0.3146, 0.3163> <-0.0732, -0.3146, 0.3163> <-0.1707, -0.2742, 0.3163> <-0.2225, -0.2225, 0.3163>
		<0.0000, -0.3041, 0.4205> <-0.0682, -0.3041, 0.4205> <-0.1667, -0.2632, 0.4205> <-0.2150, -0.2150, 0.4205>
		<0.0000, -0.2972, 0.4987> <-0.0682, -0.2972, 0.4987> <-0.1619, -0.2584, 0.4987> <-0.2101, -0.2101, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2254, -0.2254, 0.2378> <-0.2771, -0.1736, 0.2378> <-0.3188, -0.0732, 0.2378> <-0.3188, 0.0000, 0.2378>
		<-0.2225, -0.2225, 0.3163> <-0.2742, -0.1707, 0.3163> <-0.3146, -0.0732, 0.3163> <-0.3146, 0.0000, 0.3163>
		<-0.2150, -0.2150, 0.4205> <-0.2632, -0.1667, 0.4205> <-0.3041, -0.0682, 0.4205> <-0.3041, 0.0000, 0.4205>
		<-0.2101, -0.2101, 0.4987> <-0.2584, -0.1619, 0.4987> <-0.2972, -0.0682, 0.4987> <-0.2972, 0.0000, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.3188, 0.0000, 0.2378> <-0.3188, 0.0732, 0.2378> <-0.2771, 0.1736, 0.2378> <-0.2254, 0.2254, 0.2378>
		<-0.3146, 0.0000, 0.3163> <-0.3146, 0.0732, 0.3163> <-0.2742, 0.1707, 0.3163> <-0.2225, 0.2225, 0.3163>
		<-0.3041, 0.0000, 0.4205> <-0.3041, 0.0682, 0.4205> <-0.2632, 0.1667, 0.4205> <-0.2150, 0.2150, 0.4205>
		<-0.2972, 0.0000, 0.4987> <-0.2972, 0.0682, 0.4987> <-0.2584, 0.1619, 0.4987> <-0.2101, 0.2101, 0.4987>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2972, 0.4987> <0.0000, 0.2913, 0.5658> <0.0000, 0.2829, 0.6551> <0.0000, 0.2762, 0.7221>
		<-0.0682, 0.2972, 0.4987> <-0.0682, 0.2913, 0.5658> <-0.0634, 0.2829, 0.6551> <-0.0634, 0.2762, 0.7221>
		<-0.1619, 0.2584, 0.4987> <-0.1577, 0.2542, 0.5658> <-0.1552, 0.2449, 0.6551> <-0.1505, 0.2402, 0.7221>
		<-0.2101, 0.2101, 0.4987> <-0.2060, 0.2060, 0.5658> <-0.2000, 0.2000, 0.6551> <-0.1953, 0.1953, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2972, 0.4987> <0.0682, 0.2972, 0.4987> <0.1619, 0.2584, 0.4987> <0.2101, 0.2101, 0.4987>
		<0.0000, 0.2913, 0.5658> <0.0682, 0.2913, 0.5658> <0.1577, 0.2542, 0.5658> <0.2060, 0.2060, 0.5658>
		<0.0000, 0.2829, 0.6551> <0.0634, 0.2829, 0.6551> <0.1552, 0.2449, 0.6551> <0.2000, 0.2000, 0.6551>
		<0.0000, 0.2762, 0.7221> <0.0634, 0.2762, 0.7221> <0.1505, 0.2402, 0.7221> <0.1953, 0.1953, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2101, 0.2101, 0.4987> <0.2584, 0.1619, 0.4987> <0.2972, 0.0682, 0.4987> <0.2972, 0.0000, 0.4987>
		<0.2060, 0.2060, 0.5658> <0.2542, 0.1577, 0.5658> <0.2913, 0.0682, 0.5658> <0.2913, 0.0000, 0.5658>
		<0.2000, 0.2000, 0.6551> <0.2449, 0.1552, 0.6551> <0.2829, 0.0634, 0.6551> <0.2829, 0.0000, 0.6551>
		<0.1953, 0.1953, 0.7221> <0.2402, 0.1505, 0.7221> <0.2762, 0.0634, 0.7221> <0.2762, 0.0000, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2972, 0.0000, 0.4987> <0.2972, -0.0682, 0.4987> <0.2584, -0.1619, 0.4987> <0.2101, -0.2101, 0.4987>
		<0.2913, 0.0000, 0.5658> <0.2913, -0.0682, 0.5658> <0.2542, -0.1577, 0.5658> <0.2060, -0.2060, 0.5658>
		<0.2829, 0.0000, 0.6551> <0.2829, -0.0634, 0.6551> <0.2449, -0.1552, 0.6551> <0.2000, -0.2000, 0.6551>
		<0.2762, 0.0000, 0.7221> <0.2762, -0.0634, 0.7221> <0.2402, -0.1505, 0.7221> <0.1953, -0.1953, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2101, -0.2101, 0.4987> <0.1619, -0.2584, 0.4987> <0.0682, -0.2972, 0.4987> <0.0000, -0.2972, 0.4987>
		<0.2060, -0.2060, 0.5658> <0.1577, -0.2542, 0.5658> <0.0682, -0.2913, 0.5658> <0.0000, -0.2913, 0.5658>
		<0.2000, -0.2000, 0.6551> <0.1552, -0.2449, 0.6551> <0.0634, -0.2829, 0.6551> <0.0000, -0.2829, 0.6551>
		<0.1953, -0.1953, 0.7221> <0.1505, -0.2402, 0.7221> <0.0634, -0.2762, 0.7221> <0.0000, -0.2762, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2972, 0.4987> <-0.0682, -0.2972, 0.4987> <-0.1619, -0.2584, 0.4987> <-0.2101, -0.2101, 0.4987>
		<0.0000, -0.2913, 0.5658> <-0.0682, -0.2913, 0.5658> <-0.1577, -0.2542, 0.5658> <-0.2060, -0.2060, 0.5658>
		<0.0000, -0.2829, 0.6551> <-0.0634, -0.2829, 0.6551> <-0.1552, -0.2449, 0.6551> <-0.2000, -0.2000, 0.6551>
		<0.0000, -0.2762, 0.7221> <-0.0634, -0.2762, 0.7221> <-0.1505, -0.2402, 0.7221> <-0.1953, -0.1953, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2101, -0.2101, 0.4987> <-0.2584, -0.1619, 0.4987> <-0.2972, -0.0682, 0.4987> <-0.2972, 0.0000, 0.4987>
		<-0.2060, -0.2060, 0.5658> <-0.2542, -0.1577, 0.5658> <-0.2913, -0.0682, 0.5658> <-0.2913, 0.0000, 0.5658>
		<-0.2000, -0.2000, 0.6551> <-0.2449, -0.1552, 0.6551> <-0.2829, -0.0634, 0.6551> <-0.2829, 0.0000, 0.6551>
		<-0.1953, -0.1953, 0.7221> <-0.2402, -0.1505, 0.7221> <-0.2762, -0.0634, 0.7221> <-0.2762, 0.0000, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2972, 0.0000, 0.4987> <-0.2972, 0.0682, 0.4987> <-0.2584, 0.1619, 0.4987> <-0.2101, 0.2101, 0.4987>
		<-0.2913, 0.0000, 0.5658> <-0.2913, 0.0682, 0.5658> <-0.2542, 0.1577, 0.5658> <-0.2060, 0.2060, 0.5658>
		<-0.2829, 0.0000, 0.6551> <-0.2829, 0.0634, 0.6551> <-0.2449, 0.1552, 0.6551> <-0.2000, 0.2000, 0.6551>
		<-0.2762, 0.0000, 0.7221> <-0.2762, 0.0634, 0.7221> <-0.2402, 0.1505, 0.7221> <-0.1953, 0.1953, 0.7221>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2762, 0.7221> <0.0000, 0.2712, 0.7726> <0.0000, 0.2636, 0.8399> <0.0000, 0.2583, 0.8903>
		<-0.0634, 0.2762, 0.7221> <-0.0634, 0.2712, 0.7726> <-0.0593, 0.2636, 0.8399> <-0.0593, 0.2583, 0.8903>
		<-0.1505, 0.2402, 0.7221> <-0.1469, 0.2366, 0.7726> <-0.1445, 0.2283, 0.8399> <-0.1407, 0.2245, 0.8903>
		<-0.1953, 0.1953, 0.7221> <-0.1918, 0.1918, 0.7726> <-0.1864, 0.1864, 0.8399> <-0.1826, 0.1826, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2762, 0.7221> <0.0634, 0.2762, 0.7221> <0.1505, 0.2402, 0.7221> <0.1953, 0.1953, 0.7221>
		<0.0000, 0.2712, 0.7726> <0.0634, 0.2712, 0.7726> <0.1469, 0.2366, 0.7726> <0.1918, 0.1918, 0.7726>
		<0.0000, 0.2636, 0.8399> <0.0593, 0.2636, 0.8399> <0.1445, 0.2283, 0.8399> <0.1864, 0.1864, 0.8399>
		<0.0000, 0.2583, 0.8903> <0.0593, 0.2583, 0.8903> <0.1407, 0.2245, 0.8903> <0.1826, 0.1826, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1953, 0.1953, 0.7221> <0.2402, 0.1505, 0.7221> <0.2762, 0.0634, 0.7221> <0.2762, 0.0000, 0.7221>
		<0.1918, 0.1918, 0.7726> <0.2366, 0.1469, 0.7726> <0.2712, 0.0634, 0.7726> <0.2712, 0.0000, 0.7726>
		<0.1864, 0.1864, 0.8399> <0.2283, 0.1445, 0.8399> <0.2636, 0.0593, 0.8399> <0.2636, 0.0000, 0.8399>
		<0.1826, 0.1826, 0.8903> <0.2245, 0.1407, 0.8903> <0.2583, 0.0593, 0.8903> <0.2583, 0.0000, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2762, 0.0000, 0.7221> <0.2762, -0.0634, 0.7221> <0.2402, -0.1505, 0.7221> <0.1953, -0.1953, 0.7221>
		<0.2712, 0.0000, 0.7726> <0.2712, -0.0634, 0.7726> <0.2366, -0.1469, 0.7726> <0.1918, -0.1918, 0.7726>
		<0.2636, 0.0000, 0.8399> <0.2636, -0.0593, 0.8399> <0.2283, -0.1445, 0.8399> <0.1864, -0.1864, 0.8399>
		<0.2583, 0.0000, 0.8903> <0.2583, -0.0593, 0.8903> <0.2245, -0.1407, 0.8903> <0.1826, -0.1826, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1953, -0.1953, 0.7221> <0.1505, -0.2402, 0.7221> <0.0634, -0.2762, 0.7221> <0.0000, -0.2762, 0.7221>
		<0.1918, -0.1918, 0.7726> <0.1469, -0.2366, 0.7726> <0.0634, -0.2712, 0.7726> <0.0000, -0.2712, 0.7726>
		<0.1864, -0.1864, 0.8399> <0.1445, -0.2283, 0.8399> <0.0593, -0.2636, 0.8399> <0.0000, -0.2636, 0.8399>
		<0.1826, -0.1826, 0.8903> <0.1407, -0.2245, 0.8903> <0.0593, -0.2583, 0.8903> <0.0000, -0.2583, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2762, 0.7221> <-0.0634, -0.2762, 0.7221> <-0.1505, -0.2402, 0.7221> <-0.1953, -0.1953, 0.7221>
		<0.0000, -0.2712, 0.7726> <-0.0634, -0.2712, 0.7726> <-0.1469, -0.2366, 0.7726> <-0.1918, -0.1918, 0.7726>
		<0.0000, -0.2636, 0.8399> <-0.0593, -0.2636, 0.8399> <-0.1445, -0.2283, 0.8399> <-0.1864, -0.1864, 0.8399>
		<0.0000, -0.2583, 0.8903> <-0.0593, -0.2583, 0.8903> <-0.1407, -0.2245, 0.8903> <-0.1826, -0.1826, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1953, -0.1953, 0.7221> <-0.2402, -0.1505, 0.7221> <-0.2762, -0.0634, 0.7221> <-0.2762, 0.0000, 0.7221>
		<-0.1918, -0.1918, 0.7726> <-0.2366, -0.1469, 0.7726> <-0.2712, -0.0634, 0.7726> <-0.2712, 0.0000, 0.7726>
		<-0.1864, -0.1864, 0.8399> <-0.2283, -0.1445, 0.8399> <-0.2636, -0.0593, 0.8399> <-0.2636, 0.0000, 0.8399>
		<-0.1826, -0.1826, 0.8903> <-0.2245, -0.1407, 0.8903> <-0.2583, -0.0593, 0.8903> <-0.2583, 0.0000, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2762, 0.0000, 0.7221> <-0.2762, 0.0634, 0.7221> <-0.2402, 0.1505, 0.7221> <-0.1953, 0.1953, 0.7221>
		<-0.2712, 0.0000, 0.7726> <-0.2712, 0.0634, 0.7726> <-0.2366, 0.1469, 0.7726> <-0.1918, 0.1918, 0.7726>
		<-0.2636, 0.0000, 0.8399> <-0.2636, 0.0593, 0.8399> <-0.2283, 0.1445, 0.8399> <-0.1864, 0.1864, 0.8399>
		<-0.2583, 0.0000, 0.8903> <-0.2583, 0.0593, 0.8903> <-0.2245, 0.1407, 0.8903> <-0.1826, 0.1826, 0.8903>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2583, 0.8903> <0.0000, 0.2530, 0.9398> <0.0000, 0.2463, 1.0057> <0.0000, 0.2408, 1.0551>
		<-0.0593, 0.2583, 0.8903> <-0.0593, 0.2530, 0.9398> <-0.0553, 0.2463, 1.0057> <-0.0553, 0.2408, 1.0551>
		<-0.1407, 0.2245, 0.8903> <-0.1369, 0.2208, 0.9398> <-0.1350, 0.2132, 1.0057> <-0.1311, 0.2093, 1.0551>
		<-0.1826, 0.1826, 0.8903> <-0.1789, 0.1789, 0.9398> <-0.1741, 0.1741, 1.0057> <-0.1702, 0.1702, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2583, 0.8903> <0.0593, 0.2583, 0.8903> <0.1407, 0.2245, 0.8903> <0.1826, 0.1826, 0.8903>
		<0.0000, 0.2530, 0.9398> <0.0593, 0.2530, 0.9398> <0.1369, 0.2208, 0.9398> <0.1789, 0.1789, 0.9398>
		<0.0000, 0.2463, 1.0057> <0.0553, 0.2463, 1.0057> <0.1350, 0.2132, 1.0057> <0.1741, 0.1741, 1.0057>
		<0.0000, 0.2408, 1.0551> <0.0553, 0.2408, 1.0551> <0.1311, 0.2093, 1.0551> <0.1702, 0.1702, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1826, 0.1826, 0.8903> <0.2245, 0.1407, 0.8903> <0.2583, 0.0593, 0.8903> <0.2583, 0.0000, 0.8903>
		<0.1789, 0.1789, 0.9398> <0.2208, 0.1369, 0.9398> <0.2530, 0.0593, 0.9398> <0.2530, 0.0000, 0.9398>
		<0.1741, 0.1741, 1.0057> <0.2132, 0.1350, 1.0057> <0.2463, 0.0553, 1.0057> <0.2463, 0.0000, 1.0057>
		<0.1702, 0.1702, 1.0551> <0.2093, 0.1311, 1.0551> <0.2408, 0.0553, 1.0551> <0.2408, 0.0000, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2583, 0.0000, 0.8903> <0.2583, -0.0593, 0.8903> <0.2245, -0.1407, 0.8903> <0.1826, -0.1826, 0.8903>
		<0.2530, 0.0000, 0.9398> <0.2530, -0.0593, 0.9398> <0.2208, -0.1369, 0.9398> <0.1789, -0.1789, 0.9398>
		<0.2463, 0.0000, 1.0057> <0.2463, -0.0553, 1.0057> <0.2132, -0.1350, 1.0057> <0.1741, -0.1741, 1.0057>
		<0.2408, 0.0000, 1.0551> <0.2408, -0.0553, 1.0551> <0.2093, -0.1311, 1.0551> <0.1702, -0.1702, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1826, -0.1826, 0.8903> <0.1407, -0.2245, 0.8903> <0.0593, -0.2583, 0.8903> <0.0000, -0.2583, 0.8903>
		<0.1789, -0.1789, 0.9398> <0.1369, -0.2208, 0.9398> <0.0593, -0.2530, 0.9398> <0.0000, -0.2530, 0.9398>
		<0.1741, -0.1741, 1.0057> <0.1350, -0.2132, 1.0057> <0.0553, -0.2463, 1.0057> <0.0000, -0.2463, 1.0057>
		<0.1702, -0.1702, 1.0551> <0.1311, -0.2093, 1.0551> <0.0553, -0.2408, 1.0551> <0.0000, -0.2408, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2583, 0.8903> <-0.0593, -0.2583, 0.8903> <-0.1407, -0.2245, 0.8903> <-0.1826, -0.1826, 0.8903>
		<0.0000, -0.2530, 0.9398> <-0.0593, -0.2530, 0.9398> <-0.1369, -0.2208, 0.9398> <-0.1789, -0.1789, 0.9398>
		<0.0000, -0.2463, 1.0057> <-0.0553, -0.2463, 1.0057> <-0.1350, -0.2132, 1.0057> <-0.1741, -0.1741, 1.0057>
		<0.0000, -0.2408, 1.0551> <-0.0553, -0.2408, 1.0551> <-0.1311, -0.2093, 1.0551> <-0.1702, -0.1702, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1826, -0.1826, 0.8903> <-0.2245, -0.1407, 0.8903> <-0.2583, -0.0593, 0.8903> <-0.2583, 0.0000, 0.8903>
		<-0.1789, -0.1789, 0.9398> <-0.2208, -0.1369, 0.9398> <-0.2530, -0.0593, 0.9398> <-0.2530, 0.0000, 0.9398>
		<-0.1741, -0.1741, 1.0057> <-0.2132, -0.1350, 1.0057> <-0.2463, -0.0553, 1.0057> <-0.2463, 0.0000, 1.0057>
		<-0.1702, -0.1702, 1.0551> <-0.2093, -0.1311, 1.0551> <-0.2408, -0.0553, 1.0551> <-0.2408, 0.0000, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2583, 0.0000, 0.8903> <-0.2583, 0.0593, 0.8903> <-0.2245, 0.1407, 0.8903> <-0.1826, 0.1826, 0.8903>
		<-0.2530, 0.0000, 0.9398> <-0.2530, 0.0593, 0.9398> <-0.2208, 0.1369, 0.9398> <-0.1789, 0.1789, 0.9398>
		<-0.2463, 0.0000, 1.0057> <-0.2463, 0.0553, 1.0057> <-0.2132, 0.1350, 1.0057> <-0.1741, 0.1741, 1.0057>
		<-0.2408, 0.0000, 1.0551> <-0.2408, 0.0553, 1.0551> <-0.2093, 0.1311, 1.0551> <-0.1702, 0.1702, 1.0551>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2408, 1.0551> <0.0000, 0.2372, 1.0871> <0.0000, 0.2318, 1.1296> <0.0000, 0.2280, 1.1615>
		<-0.0553, 0.2408, 1.0551> <-0.0553, 0.2372, 1.0871> <-0.0524, 0.2318, 1.1296> <-0.0524, 0.2280, 1.1615>
		<-0.1311, 0.2093, 1.0551> <-0.1286, 0.2068, 1.0871> <-0.1268, 0.2009, 1.1296> <-0.1242, 0.1982, 1.1615>
		<-0.1702, 0.1702, 1.0551> <-0.1677, 0.1677, 1.0871> <-0.1639, 0.1639, 1.1296> <-0.1612, 0.1612, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2408, 1.0551> <0.0553, 0.2408, 1.0551> <0.1311, 0.2093, 1.0551> <0.1702, 0.1702, 1.0551>
		<0.0000, 0.2372, 1.0871> <0.0553, 0.2372, 1.0871> <0.1286, 0.2068, 1.0871> <0.1677, 0.1677, 1.0871>
		<0.0000, 0.2318, 1.1296> <0.0524, 0.2318, 1.1296> <0.1268, 0.2009, 1.1296> <0.1639, 0.1639, 1.1296>
		<0.0000, 0.2280, 1.1615> <0.0524, 0.2280, 1.1615> <0.1242, 0.1982, 1.1615> <0.1612, 0.1612, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1702, 0.1702, 1.0551> <0.2093, 0.1311, 1.0551> <0.2408, 0.0553, 1.0551> <0.2408, 0.0000, 1.0551>
		<0.1677, 0.1677, 1.0871> <0.2068, 0.1286, 1.0871> <0.2372, 0.0553, 1.0871> <0.2372, 0.0000, 1.0871>
		<0.1639, 0.1639, 1.1296> <0.2009, 0.1268, 1.1296> <0.2318, 0.0524, 1.1296> <0.2318, 0.0000, 1.1296>
		<0.1612, 0.1612, 1.1615> <0.1982, 0.1242, 1.1615> <0.2280, 0.0524, 1.1615> <0.2280, 0.0000, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2408, 0.0000, 1.0551> <0.2408, -0.0553, 1.0551> <0.2093, -0.1311, 1.0551> <0.1702, -0.1702, 1.0551>
		<0.2372, 0.0000, 1.0871> <0.2372, -0.0553, 1.0871> <0.2068, -0.1286, 1.0871> <0.1677, -0.1677, 1.0871>
		<0.2318, 0.0000, 1.1296> <0.2318, -0.0524, 1.1296> <0.2009, -0.1268, 1.1296> <0.1639, -0.1639, 1.1296>
		<0.2280, 0.0000, 1.1615> <0.2280, -0.0524, 1.1615> <0.1982, -0.1242, 1.1615> <0.1612, -0.1612, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1702, -0.1702, 1.0551> <0.1311, -0.2093, 1.0551> <0.0553, -0.2408, 1.0551> <0.0000, -0.2408, 1.0551>
		<0.1677, -0.1677, 1.0871> <0.1286, -0.2068, 1.0871> <0.0553, -0.2372, 1.0871> <0.0000, -0.2372, 1.0871>
		<0.1639, -0.1639, 1.1296> <0.1268, -0.2009, 1.1296> <0.0524, -0.2318, 1.1296> <0.0000, -0.2318, 1.1296>
		<0.1612, -0.1612, 1.1615> <0.1242, -0.1982, 1.1615> <0.0524, -0.2280, 1.1615> <0.0000, -0.2280, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2408, 1.0551> <-0.0553, -0.2408, 1.0551> <-0.1311, -0.2093, 1.0551> <-0.1702, -0.1702, 1.0551>
		<0.0000, -0.2372, 1.0871> <-0.0553, -0.2372, 1.0871> <-0.1286, -0.2068, 1.0871> <-0.1677, -0.1677, 1.0871>
		<0.0000, -0.2318, 1.1296> <-0.0524, -0.2318, 1.1296> <-0.1268, -0.2009, 1.1296> <-0.1639, -0.1639, 1.1296>
		<0.0000, -0.2280, 1.1615> <-0.0524, -0.2280, 1.1615> <-0.1242, -0.1982, 1.1615> <-0.1612, -0.1612, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1702, -0.1702, 1.0551> <-0.2093, -0.1311, 1.0551> <-0.2408, -0.0553, 1.0551> <-0.2408, 0.0000, 1.0551>
		<-0.1677, -0.1677, 1.0871> <-0.2068, -0.1286, 1.0871> <-0.2372, -0.0553, 1.0871> <-0.2372, 0.0000, 1.0871>
		<-0.1639, -0.1639, 1.1296> <-0.2009, -0.1268, 1.1296> <-0.2318, -0.0524, 1.1296> <-0.2318, 0.0000, 1.1296>
		<-0.1612, -0.1612, 1.1615> <-0.1982, -0.1242, 1.1615> <-0.2280, -0.0524, 1.1615> <-0.2280, 0.0000, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2408, 0.0000, 1.0551> <-0.2408, 0.0553, 1.0551> <-0.2093, 0.1311, 1.0551> <-0.1702, 0.1702, 1.0551>
		<-0.2372, 0.0000, 1.0871> <-0.2372, 0.0553, 1.0871> <-0.2068, 0.1286, 1.0871> <-0.1677, 0.1677, 1.0871>
		<-0.2318, 0.0000, 1.1296> <-0.2318, 0.0524, 1.1296> <-0.2009, 0.1268, 1.1296> <-0.1639, 0.1639, 1.1296>
		<-0.2280, 0.0000, 1.1615> <-0.2280, 0.0524, 1.1615> <-0.1982, 0.1242, 1.1615> <-0.1612, 0.1612, 1.1615>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2280, 1.1615> <0.0000, 0.2245, 1.1914> <0.0000, 0.2203, 1.2312> <0.0000, 0.2167, 1.2611>
		<-0.0524, 0.2280, 1.1615> <-0.0524, 0.2245, 1.1914> <-0.0498, 0.2203, 1.2312> <-0.0498, 0.2167, 1.2611>
		<-0.1242, 0.1982, 1.1615> <-0.1217, 0.1958, 1.1914> <-0.1206, 0.1910, 1.2312> <-0.1180, 0.1884, 1.2611>
		<-0.1612, 0.1612, 1.1615> <-0.1588, 0.1588, 1.1914> <-0.1558, 0.1558, 1.2312> <-0.1532, 0.1532, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2280, 1.1615> <0.0524, 0.2280, 1.1615> <0.1242, 0.1982, 1.1615> <0.1612, 0.1612, 1.1615>
		<0.0000, 0.2245, 1.1914> <0.0524, 0.2245, 1.1914> <0.1217, 0.1958, 1.1914> <0.1588, 0.1588, 1.1914>
		<0.0000, 0.2203, 1.2312> <0.0498, 0.2203, 1.2312> <0.1206, 0.1910, 1.2312> <0.1558, 0.1558, 1.2312>
		<0.0000, 0.2167, 1.2611> <0.0498, 0.2167, 1.2611> <0.1180, 0.1884, 1.2611> <0.1532, 0.1532, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1612, 0.1612, 1.1615> <0.1982, 0.1242, 1.1615> <0.2280, 0.0524, 1.1615> <0.2280, 0.0000, 1.1615>
		<0.1588, 0.1588, 1.1914> <0.1958, 0.1217, 1.1914> <0.2245, 0.0524, 1.1914> <0.2245, 0.0000, 1.1914>
		<0.1558, 0.1558, 1.2312> <0.1910, 0.1206, 1.2312> <0.2203, 0.0498, 1.2312> <0.2203, 0.0000, 1.2312>
		<0.1532, 0.1532, 1.2611> <0.1884, 0.1180, 1.2611> <0.2167, 0.0498, 1.2611> <0.2167, 0.0000, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2280, 0.0000, 1.1615> <0.2280, -0.0524, 1.1615> <0.1982, -0.1242, 1.1615> <0.1612, -0.1612, 1.1615>
		<0.2245, 0.0000, 1.1914> <0.2245, -0.0524, 1.1914> <0.1958, -0.1217, 1.1914> <0.1588, -0.1588, 1.1914>
		<0.2203, 0.0000, 1.2312> <0.2203, -0.0498, 1.2312> <0.1910, -0.1206, 1.2312> <0.1558, -0.1558, 1.2312>
		<0.2167, 0.0000, 1.2611> <0.2167, -0.0498, 1.2611> <0.1884, -0.1180, 1.2611> <0.1532, -0.1532, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1612, -0.1612, 1.1615> <0.1242, -0.1982, 1.1615> <0.0524, -0.2280, 1.1615> <0.0000, -0.2280, 1.1615>
		<0.1588, -0.1588, 1.1914> <0.1217, -0.1958, 1.1914> <0.0524, -0.2245, 1.1914> <0.0000, -0.2245, 1.1914>
		<0.1558, -0.1558, 1.2312> <0.1206, -0.1910, 1.2312> <0.0498, -0.2203, 1.2312> <0.0000, -0.2203, 1.2312>
		<0.1532, -0.1532, 1.2611> <0.1180, -0.1884, 1.2611> <0.0498, -0.2167, 1.2611> <0.0000, -0.2167, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2280, 1.1615> <-0.0524, -0.2280, 1.1615> <-0.1242, -0.1982, 1.1615> <-0.1612, -0.1612, 1.1615>
		<0.0000, -0.2245, 1.1914> <-0.0524, -0.2245, 1.1914> <-0.1217, -0.1958, 1.1914> <-0.1588, -0.1588, 1.1914>
		<0.0000, -0.2203, 1.2312> <-0.0498, -0.2203, 1.2312> <-0.1206, -0.1910, 1.2312> <-0.1558, -0.1558, 1.2312>
		<0.0000, -0.2167, 1.2611> <-0.0498, -0.2167, 1.2611> <-0.1180, -0.1884, 1.2611> <-0.1532, -0.1532, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1612, -0.1612, 1.1615> <-0.1982, -0.1242, 1.1615> <-0.2280, -0.0524, 1.1615> <-0.2280, 0.0000, 1.1615>
		<-0.1588, -0.1588, 1.1914> <-0.1958, -0.1217, 1.1914> <-0.2245, -0.0524, 1.1914> <-0.2245, 0.0000, 1.1914>
		<-0.1558, -0.1558, 1.2312> <-0.1910, -0.1206, 1.2312> <-0.2203, -0.0498, 1.2312> <-0.2203, 0.0000, 1.2312>
		<-0.1532, -0.1532, 1.2611> <-0.1884, -0.1180, 1.2611> <-0.2167, -0.0498, 1.2611> <-0.2167, 0.0000, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2280, 0.0000, 1.1615> <-0.2280, 0.0524, 1.1615> <-0.1982, 0.1242, 1.1615> <-0.1612, 0.1612, 1.1615>
		<-0.2245, 0.0000, 1.1914> <-0.2245, 0.0524, 1.1914> <-0.1958, 0.1217, 1.1914> <-0.1588, 0.1588, 1.1914>
		<-0.2203, 0.0000, 1.2312> <-0.2203, 0.0498, 1.2312> <-0.1910, 0.1206, 1.2312> <-0.1558, 0.1558, 1.2312>
		<-0.2167, 0.0000, 1.2611> <-0.2167, 0.0498, 1.2611> <-0.1884, 0.1180, 1.2611> <-0.1532, 0.1532, 1.2611>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2167, 1.2611> <0.0000, 0.2116, 1.3033> <0.0000, 0.2043, 1.3596> <0.0000, 0.1990, 1.4018>
		<-0.0498, 0.2167, 1.2611> <-0.0498, 0.2116, 1.3033> <-0.0457, 0.2043, 1.3596> <-0.0457, 0.1990, 1.4018>
		<-0.1180, 0.1884, 1.2611> <-0.1144, 0.1848, 1.3033> <-0.1122, 0.1768, 1.3596> <-0.1084, 0.1730, 1.4018>
		<-0.1532, 0.1532, 1.2611> <-0.1496, 0.1496, 1.3033> <-0.1445, 0.1445, 1.3596> <-0.1407, 0.1407, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.2167, 1.2611> <0.0498, 0.2167, 1.2611> <0.1180, 0.1884, 1.2611> <0.1532, 0.1532, 1.2611>
		<0.0000, 0.2116, 1.3033> <0.0498, 0.2116, 1.3033> <0.1144, 0.1848, 1.3033> <0.1496, 0.1496, 1.3033>
		<0.0000, 0.2043, 1.3596> <0.0457, 0.2043, 1.3596> <0.1122, 0.1768, 1.3596> <0.1445, 0.1445, 1.3596>
		<0.0000, 0.1990, 1.4018> <0.0457, 0.1990, 1.4018> <0.1084, 0.1730, 1.4018> <0.1407, 0.1407, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1532, 0.1532, 1.2611> <0.1884, 0.1180, 1.2611> <0.2167, 0.0498, 1.2611> <0.2167, 0.0000, 1.2611>
		<0.1496, 0.1496, 1.3033> <0.1848, 0.1144, 1.3033> <0.2116, 0.0498, 1.3033> <0.2116, 0.0000, 1.3033>
		<0.1445, 0.1445, 1.3596> <0.1768, 0.1122, 1.3596> <0.2043, 0.0457, 1.3596> <0.2043, 0.0000, 1.3596>
		<0.1407, 0.1407, 1.4018> <0.1730, 0.1084, 1.4018> <0.1990, 0.0457, 1.4018> <0.1990, 0.0000, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.2167, 0.0000, 1.2611> <0.2167, -0.0498, 1.2611> <0.1884, -0.1180, 1.2611> <0.1532, -0.1532, 1.2611>
		<0.2116, 0.0000, 1.3033> <0.2116, -0.0498, 1.3033> <0.1848, -0.1144, 1.3033> <0.1496, -0.1496, 1.3033>
		<0.2043, 0.0000, 1.3596> <0.2043, -0.0457, 1.3596> <0.1768, -0.1122, 1.3596> <0.1445, -0.1445, 1.3596>
		<0.1990, 0.0000, 1.4018> <0.1990, -0.0457, 1.4018> <0.1730, -0.1084, 1.4018> <0.1407, -0.1407, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1532, -0.1532, 1.2611> <0.1180, -0.1884, 1.2611> <0.0498, -0.2167, 1.2611> <0.0000, -0.2167, 1.2611>
		<0.1496, -0.1496, 1.3033> <0.1144, -0.1848, 1.3033> <0.0498, -0.2116, 1.3033> <0.0000, -0.2116, 1.3033>
		<0.1445, -0.1445, 1.3596> <0.1122, -0.1768, 1.3596> <0.0457, -0.2043, 1.3596> <0.0000, -0.2043, 1.3596>
		<0.1407, -0.1407, 1.4018> <0.1084, -0.1730, 1.4018> <0.0457, -0.1990, 1.4018> <0.0000, -0.1990, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.2167, 1.2611> <-0.0498, -0.2167, 1.2611> <-0.1180, -0.1884, 1.2611> <-0.1532, -0.1532, 1.2611>
		<0.0000, -0.2116, 1.3033> <-0.0498, -0.2116, 1.3033> <-0.1144, -0.1848, 1.3033> <-0.1496, -0.1496, 1.3033>
		<0.0000, -0.2043, 1.3596> <-0.0457, -0.2043, 1.3596> <-0.1122, -0.1768, 1.3596> <-0.1445, -0.1445, 1.3596>
		<0.0000, -0.1990, 1.4018> <-0.0457, -0.1990, 1.4018> <-0.1084, -0.1730, 1.4018> <-0.1407, -0.1407, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1532, -0.1532, 1.2611> <-0.1884, -0.1180, 1.2611> <-0.2167, -0.0498, 1.2611> <-0.2167, 0.0000, 1.2611>
		<-0.1496, -0.1496, 1.3033> <-0.1848, -0.1144, 1.3033> <-0.2116, -0.0498, 1.3033> <-0.2116, 0.0000, 1.3033>
		<-0.1445, -0.1445, 1.3596> <-0.1768, -0.1122, 1.3596> <-0.2043, -0.0457, 1.3596> <-0.2043, 0.0000, 1.3596>
		<-0.1407, -0.1407, 1.4018> <-0.1730, -0.1084, 1.4018> <-0.1990, -0.0457, 1.4018> <-0.1990, 0.0000, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.2167, 0.0000, 1.2611> <-0.2167, 0.0498, 1.2611> <-0.1884, 0.1180, 1.2611> <-0.1532, 0.1532, 1.2611>
		<-0.2116, 0.0000, 1.3033> <-0.2116, 0.0498, 1.3033> <-0.1848, 0.1144, 1.3033> <-0.1496, 0.1496, 1.3033>
		<-0.2043, 0.0000, 1.3596> <-0.2043, 0.0457, 1.3596> <-0.1768, 0.1122, 1.3596> <-0.1445, 0.1445, 1.3596>
		<-0.1990, 0.0000, 1.4018> <-0.1990, 0.0457, 1.4018> <-0.1730, 0.1084, 1.4018> <-0.1407, 0.1407, 1.4018>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1990, 1.4018> <0.0000, 0.1953, 1.4306> <0.0000, 0.1907, 1.4691> <0.0000, 0.1867, 1.4979>
		<-0.0457, 0.1990, 1.4018> <-0.0457, 0.1953, 1.4306> <-0.0429, 0.1907, 1.4691> <-0.0429, 0.1867, 1.4979>
		<-0.1084, 0.1730, 1.4018> <-0.1058, 0.1704, 1.4306> <-0.1045, 0.1651, 1.4691> <-0.1017, 0.1623, 1.4979>
		<-0.1407, 0.1407, 1.4018> <-0.1381, 0.1381, 1.4306> <-0.1348, 0.1348, 1.4691> <-0.1320, 0.1320, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1990, 1.4018> <0.0457, 0.1990, 1.4018> <0.1084, 0.1730, 1.4018> <0.1407, 0.1407, 1.4018>
		<0.0000, 0.1953, 1.4306> <0.0457, 0.1953, 1.4306> <0.1058, 0.1704, 1.4306> <0.1381, 0.1381, 1.4306>
		<0.0000, 0.1907, 1.4691> <0.0429, 0.1907, 1.4691> <0.1045, 0.1651, 1.4691> <0.1348, 0.1348, 1.4691>
		<0.0000, 0.1867, 1.4979> <0.0429, 0.1867, 1.4979> <0.1017, 0.1623, 1.4979> <0.1320, 0.1320, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1407, 0.1407, 1.4018> <0.1730, 0.1084, 1.4018> <0.1990, 0.0457, 1.4018> <0.1990, 0.0000, 1.4018>
		<0.1381, 0.1381, 1.4306> <0.1704, 0.1058, 1.4306> <0.1953, 0.0457, 1.4306> <0.1953, 0.0000, 1.4306>
		<0.1348, 0.1348, 1.4691> <0.1651, 0.1045, 1.4691> <0.1907, 0.0429, 1.4691> <0.1907, 0.0000, 1.4691>
		<0.1320, 0.1320, 1.4979> <0.1623, 0.1017, 1.4979> <0.1867, 0.0429, 1.4979> <0.1867, 0.0000, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1990, 0.0000, 1.4018> <0.1990, -0.0457, 1.4018> <0.1730, -0.1084, 1.4018> <0.1407, -0.1407, 1.4018>
		<0.1953, 0.0000, 1.4306> <0.1953, -0.0457, 1.4306> <0.1704, -0.1058, 1.4306> <0.1381, -0.1381, 1.4306>
		<0.1907, 0.0000, 1.4691> <0.1907, -0.0429, 1.4691> <0.1651, -0.1045, 1.4691> <0.1348, -0.1348, 1.4691>
		<0.1867, 0.0000, 1.4979> <0.1867, -0.0429, 1.4979> <0.1623, -0.1017, 1.4979> <0.1320, -0.1320, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1407, -0.1407, 1.4018> <0.1084, -0.1730, 1.4018> <0.0457, -0.1990, 1.4018> <0.0000, -0.1990, 1.4018>
		<0.1381, -0.1381, 1.4306> <0.1058, -0.1704, 1.4306> <0.0457, -0.1953, 1.4306> <0.0000, -0.1953, 1.4306>
		<0.1348, -0.1348, 1.4691> <0.1045, -0.1651, 1.4691> <0.0429, -0.1907, 1.4691> <0.0000, -0.1907, 1.4691>
		<0.1320, -0.1320, 1.4979> <0.1017, -0.1623, 1.4979> <0.0429, -0.1867, 1.4979> <0.0000, -0.1867, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1990, 1.4018> <-0.0457, -0.1990, 1.4018> <-0.1084, -0.1730, 1.4018> <-0.1407, -0.1407, 1.4018>
		<0.0000, -0.1953, 1.4306> <-0.0457, -0.1953, 1.4306> <-0.1058, -0.1704, 1.4306> <-0.1381, -0.1381, 1.4306>
		<0.0000, -0.1907, 1.4691> <-0.0429, -0.1907, 1.4691> <-0.1045, -0.1651, 1.4691> <-0.1348, -0.1348, 1.4691>
		<0.0000, -0.1867, 1.4979> <-0.0429, -0.1867, 1.4979> <-0.1017, -0.1623, 1.4979> <-0.1320, -0.1320, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1407, -0.1407, 1.4018> <-0.1730, -0.1084, 1.4018> <-0.1990, -0.0457, 1.4018> <-0.1990, 0.0000, 1.4018>
		<-0.1381, -0.1381, 1.4306> <-0.1704, -0.1058, 1.4306> <-0.1953, -0.0457, 1.4306> <-0.1953, 0.0000, 1.4306>
		<-0.1348, -0.1348, 1.4691> <-0.1651, -0.1045, 1.4691> <-0.1907, -0.0429, 1.4691> <-0.1907, 0.0000, 1.4691>
		<-0.1320, -0.1320, 1.4979> <-0.1623, -0.1017, 1.4979> <-0.1867, -0.0429, 1.4979> <-0.1867, 0.0000, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1990, 0.0000, 1.4018> <-0.1990, 0.0457, 1.4018> <-0.1730, 0.1084, 1.4018> <-0.1407, 0.1407, 1.4018>
		<-0.1953, 0.0000, 1.4306> <-0.1953, 0.0457, 1.4306> <-0.1704, 0.1058, 1.4306> <-0.1381, 0.1381, 1.4306>
		<-0.1907, 0.0000, 1.4691> <-0.1907, 0.0429, 1.4691> <-0.1651, 0.1045, 1.4691> <-0.1348, 0.1348, 1.4691>
		<-0.1867, 0.0000, 1.4979> <-0.1867, 0.0429, 1.4979> <-0.1623, 0.1017, 1.4979> <-0.1320, 0.1320, 1.4979>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1867, 1.4979> <0.0000, 0.1839, 1.5186> <0.0000, 0.1797, 1.5460> <0.0000, 0.1763, 1.5666>
		<-0.0429, 0.1867, 1.4979> <-0.0429, 0.1839, 1.5186> <-0.0405, 0.1797, 1.5460> <-0.0405, 0.1763, 1.5666>
		<-0.1017, 0.1623, 1.4979> <-0.0997, 0.1603, 1.5186> <-0.0997, 0.1562, 1.5463> <-0.0960, 0.1532, 1.5666>
		<-0.1320, 0.1320, 1.4979> <-0.1300, 0.1300, 1.5186> <-0.1284, 0.1276, 1.5463> <-0.1246, 0.1246, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1867, 1.4979> <0.0429, 0.1867, 1.4979> <0.1017, 0.1623, 1.4979> <0.1320, 0.1320, 1.4979>
		<0.0000, 0.1839, 1.5186> <0.0429, 0.1839, 1.5186> <0.0997, 0.1603, 1.5186> <0.1300, 0.1300, 1.5186>
		<0.0000, 0.1797, 1.5460> <0.0405, 0.1797, 1.5460> <0.0997, 0.1562, 1.5463> <0.1284, 0.1276, 1.5463>
		<0.0000, 0.1763, 1.5666> <0.0405, 0.1763, 1.5666> <0.0960, 0.1532, 1.5666> <0.1246, 0.1246, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1320, 0.1320, 1.4979> <0.1623, 0.1017, 1.4979> <0.1867, 0.0429, 1.4979> <0.1867, 0.0000, 1.4979>
		<0.1300, 0.1300, 1.5186> <0.1603, 0.0997, 1.5186> <0.1839, 0.0429, 1.5186> <0.1839, 0.0000, 1.5186>
		<0.1284, 0.1276, 1.5463> <0.1570, 0.0990, 1.5463> <0.1794, 0.0405, 1.5460> <0.1794, 0.0000, 1.5460>
		<0.1246, 0.1246, 1.5666> <0.1532, 0.0960, 1.5666> <0.1763, 0.0405, 1.5666> <0.1763, 0.0000, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1867, 0.0000, 1.4979> <0.1867, -0.0429, 1.4979> <0.1623, -0.1017, 1.4979> <0.1320, -0.1320, 1.4979>
		<0.1839, 0.0000, 1.5186> <0.1839, -0.0429, 1.5186> <0.1603, -0.0997, 1.5186> <0.1300, -0.1300, 1.5186>
		<0.1794, 0.0000, 1.5460> <0.1794, -0.0405, 1.5460> <0.1570, -0.0990, 1.5463> <0.1284, -0.1276, 1.5463>
		<0.1763, 0.0000, 1.5666> <0.1763, -0.0405, 1.5666> <0.1532, -0.0960, 1.5666> <0.1246, -0.1246, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1320, -0.1320, 1.4979> <0.1017, -0.1623, 1.4979> <0.0429, -0.1867, 1.4979> <0.0000, -0.1867, 1.4979>
		<0.1300, -0.1300, 1.5186> <0.0997, -0.1603, 1.5186> <0.0429, -0.1839, 1.5186> <0.0000, -0.1839, 1.5186>
		<0.1284, -0.1276, 1.5463> <0.0997, -0.1562, 1.5463> <0.0405, -0.1797, 1.5460> <0.0000, -0.1797, 1.5460>
		<0.1246, -0.1246, 1.5666> <0.0960, -0.1532, 1.5666> <0.0405, -0.1763, 1.5666> <0.0000, -0.1763, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1867, 1.4979> <-0.0429, -0.1867, 1.4979> <-0.1017, -0.1623, 1.4979> <-0.1320, -0.1320, 1.4979>
		<0.0000, -0.1839, 1.5186> <-0.0429, -0.1839, 1.5186> <-0.0997, -0.1603, 1.5186> <-0.1300, -0.1300, 1.5186>
		<0.0000, -0.1797, 1.5460> <-0.0405, -0.1797, 1.5460> <-0.0997, -0.1562, 1.5463> <-0.1284, -0.1276, 1.5463>
		<0.0000, -0.1763, 1.5666> <-0.0405, -0.1763, 1.5666> <-0.0960, -0.1532, 1.5666> <-0.1246, -0.1246, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1320, -0.1320, 1.4979> <-0.1623, -0.1017, 1.4979> <-0.1867, -0.0429, 1.4979> <-0.1867, 0.0000, 1.4979>
		<-0.1300, -0.1300, 1.5186> <-0.1603, -0.0997, 1.5186> <-0.1839, -0.0429, 1.5186> <-0.1839, 0.0000, 1.5186>
		<-0.1284, -0.1276, 1.5463> <-0.1570, -0.0990, 1.5463> <-0.1794, -0.0405, 1.5460> <-0.1794, 0.0000, 1.5460>
		<-0.1246, -0.1246, 1.5666> <-0.1532, -0.0960, 1.5666> <-0.1763, -0.0405, 1.5666> <-0.1763, 0.0000, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1867, 0.0000, 1.4979> <-0.1867, 0.0429, 1.4979> <-0.1623, 0.1017, 1.4979> <-0.1320, 0.1320, 1.4979>
		<-0.1839, 0.0000, 1.5186> <-0.1839, 0.0429, 1.5186> <-0.1603, 0.0997, 1.5186> <-0.1300, 0.1300, 1.5186>
		<-0.1794, 0.0000, 1.5460> <-0.1794, 0.0405, 1.5460> <-0.1570, 0.0990, 1.5463> <-0.1284, 0.1276, 1.5463>
		<-0.1763, 0.0000, 1.5666> <-0.1763, 0.0405, 1.5666> <-0.1532, 0.0960, 1.5666> <-0.1246, 0.1246, 1.5666>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1763, 1.5666> <0.0000, 0.1737, 1.5821> <0.0000, 0.1698, 1.6026> <0.0000, 0.1669, 1.6181>
		<-0.0405, 0.1763, 1.5666> <-0.0405, 0.1737, 1.5821> <-0.0365, 0.1698, 1.6026> <-0.0365, 0.1669, 1.6181>
		<-0.0960, 0.1532, 1.5666> <-0.0931, 0.1509, 1.5825> <-0.0882, 0.1438, 1.6027> <-0.0840, 0.1403, 1.6181>
		<-0.1246, 0.1246, 1.5666> <-0.1217, 0.1223, 1.5825> <-0.1141, 0.1181, 1.6027> <-0.1099, 0.1146, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1763, 1.5666> <0.0405, 0.1763, 1.5666> <0.0960, 0.1532, 1.5666> <0.1246, 0.1246, 1.5666>
		<0.0000, 0.1737, 1.5821> <0.0405, 0.1737, 1.5821> <0.0931, 0.1509, 1.5825> <0.1217, 0.1223, 1.5825>
		<0.0000, 0.1698, 1.6026> <0.0365, 0.1698, 1.6026> <0.0882, 0.1438, 1.6027> <0.1141, 0.1181, 1.6027>
		<0.0000, 0.1669, 1.6181> <0.0365, 0.1669, 1.6181> <0.0840, 0.1403, 1.6181> <0.1099, 0.1146, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1246, 0.1246, 1.5666> <0.1532, 0.0960, 1.5666> <0.1763, 0.0405, 1.5666> <0.1763, 0.0000, 1.5666>
		<0.1217, 0.1223, 1.5825> <0.1503, 0.0937, 1.5825> <0.1739, 0.0405, 1.5820> <0.1739, 0.0000, 1.5820>
		<0.1141, 0.1181, 1.6027> <0.1415, 0.0909, 1.6027> <0.1723, 0.0386, 1.6030> <0.1723, 0.0000, 1.6030>
		<0.1099, 0.1146, 1.6181> <0.1373, 0.0874, 1.6181> <0.1683, 0.0386, 1.6181> <0.1683, 0.0000, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1763, 0.0000, 1.5666> <0.1763, -0.0405, 1.5666> <0.1532, -0.0960, 1.5666> <0.1246, -0.1246, 1.5666>
		<0.1739, 0.0000, 1.5820> <0.1739, -0.0405, 1.5820> <0.1503, -0.0937, 1.5825> <0.1217, -0.1223, 1.5825>
		<0.1723, 0.0000, 1.6030> <0.1723, -0.0386, 1.6030> <0.1415, -0.0909, 1.6027> <0.1141, -0.1181, 1.6027>
		<0.1683, 0.0000, 1.6181> <0.1683, -0.0386, 1.6181> <0.1373, -0.0874, 1.6181> <0.1099, -0.1146, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1246, -0.1246, 1.5666> <0.0960, -0.1532, 1.5666> <0.0405, -0.1763, 1.5666> <0.0000, -0.1763, 1.5666>
		<0.1217, -0.1223, 1.5825> <0.0931, -0.1509, 1.5825> <0.0405, -0.1737, 1.5821> <0.0000, -0.1737, 1.5821>
		<0.1141, -0.1181, 1.6027> <0.0882, -0.1438, 1.6027> <0.0365, -0.1698, 1.6026> <0.0000, -0.1698, 1.6026>
		<0.1099, -0.1146, 1.6181> <0.0840, -0.1403, 1.6181> <0.0365, -0.1669, 1.6181> <0.0000, -0.1669, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1763, 1.5666> <-0.0405, -0.1763, 1.5666> <-0.0960, -0.1532, 1.5666> <-0.1246, -0.1246, 1.5666>
		<0.0000, -0.1737, 1.5821> <-0.0405, -0.1737, 1.5821> <-0.0931, -0.1509, 1.5825> <-0.1217, -0.1223, 1.5825>
		<0.0000, -0.1698, 1.6026> <-0.0365, -0.1698, 1.6026> <-0.0882, -0.1438, 1.6027> <-0.1141, -0.1181, 1.6027>
		<0.0000, -0.1669, 1.6181> <-0.0365, -0.1669, 1.6181> <-0.0840, -0.1403, 1.6181> <-0.1099, -0.1146, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1246, -0.1246, 1.5666> <-0.1532, -0.0960, 1.5666> <-0.1763, -0.0405, 1.5666> <-0.1763, 0.0000, 1.5666>
		<-0.1217, -0.1223, 1.5825> <-0.1503, -0.0937, 1.5825> <-0.1739, -0.0405, 1.5820> <-0.1739, 0.0000, 1.5820>
		<-0.1141, -0.1181, 1.6027> <-0.1415, -0.0909, 1.6027> <-0.1723, -0.0386, 1.6030> <-0.1723, 0.0000, 1.6030>
		<-0.1099, -0.1146, 1.6181> <-0.1373, -0.0874, 1.6181> <-0.1683, -0.0386, 1.6181> <-0.1683, 0.0000, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1763, 0.0000, 1.5666> <-0.1763, 0.0405, 1.5666> <-0.1532, 0.0960, 1.5666> <-0.1246, 0.1246, 1.5666>
		<-0.1739, 0.0000, 1.5820> <-0.1739, 0.0405, 1.5820> <-0.1503, 0.0937, 1.5825> <-0.1217, 0.1223, 1.5825>
		<-0.1723, 0.0000, 1.6030> <-0.1723, 0.0386, 1.6030> <-0.1415, 0.0909, 1.6027> <-0.1141, 0.1181, 1.6027>
		<-0.1683, 0.0000, 1.6181> <-0.1683, 0.0386, 1.6181> <-0.1373, 0.0874, 1.6181> <-0.1099, 0.1146, 1.6181>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1669, 1.6181> <0.0000, 0.1631, 1.6387> <0.0000, 0.1579, 1.6661> <0.0000, 0.1542, 1.6867>
		<-0.0365, 0.1669, 1.6181> <-0.0365, 0.1631, 1.6387> <-0.0324, 0.1579, 1.6661> <-0.0324, 0.1542, 1.6867>
		<-0.0840, 0.1403, 1.6181> <-0.0783, 0.1355, 1.6387> <-0.0762, 0.1254, 1.6663> <-0.0696, 0.1207, 1.6867>
		<-0.1099, 0.1146, 1.6181> <-0.1043, 0.1098, 1.6387> <-0.0984, 0.1018, 1.6663> <-0.0917, 0.0971, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1669, 1.6181> <0.0365, 0.1669, 1.6181> <0.0840, 0.1403, 1.6181> <0.1099, 0.1146, 1.6181>
		<0.0000, 0.1631, 1.6387> <0.0365, 0.1631, 1.6387> <0.0783, 0.1355, 1.6387> <0.1043, 0.1098, 1.6387>
		<0.0000, 0.1579, 1.6661> <0.0324, 0.1579, 1.6661> <0.0762, 0.1254, 1.6663> <0.0984, 0.1018, 1.6663>
		<0.0000, 0.1542, 1.6867> <0.0324, 0.1542, 1.6867> <0.0696, 0.1207, 1.6867> <0.0917, 0.0971, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1099, 0.1146, 1.6181> <0.1373, 0.0874, 1.6181> <0.1683, 0.0386, 1.6181> <0.1683, 0.0000, 1.6181>
		<0.1043, 0.1098, 1.6387> <0.1316, 0.0827, 1.6387> <0.1627, 0.0386, 1.6391> <0.1627, 0.0000, 1.6391>
		<0.0984, 0.1018, 1.6663> <0.1211, 0.0776, 1.6663> <0.1519, 0.0331, 1.6662> <0.1519, 0.0000, 1.6662>
		<0.0917, 0.0971, 1.6867> <0.1144, 0.0729, 1.6867> <0.1445, 0.0331, 1.6867> <0.1445, 0.0000, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1683, 0.0000, 1.6181> <0.1683, -0.0386, 1.6181> <0.1373, -0.0874, 1.6181> <0.1099, -0.1146, 1.6181>
		<0.1627, 0.0000, 1.6391> <0.1627, -0.0386, 1.6391> <0.1316, -0.0827, 1.6387> <0.1043, -0.1098, 1.6387>
		<0.1519, 0.0000, 1.6662> <0.1519, -0.0331, 1.6662> <0.1211, -0.0776, 1.6663> <0.0984, -0.1018, 1.6663>
		<0.1445, 0.0000, 1.6867> <0.1445, -0.0331, 1.6867> <0.1144, -0.0729, 1.6867> <0.0917, -0.0971, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1099, -0.1146, 1.6181> <0.0840, -0.1403, 1.6181> <0.0365, -0.1669, 1.6181> <0.0000, -0.1669, 1.6181>
		<0.1043, -0.1098, 1.6387> <0.0783, -0.1355, 1.6387> <0.0365, -0.1631, 1.6387> <0.0000, -0.1631, 1.6387>
		<0.0984, -0.1018, 1.6663> <0.0762, -0.1254, 1.6663> <0.0324, -0.1579, 1.6661> <0.0000, -0.1579, 1.6661>
		<0.0917, -0.0971, 1.6867> <0.0696, -0.1207, 1.6867> <0.0324, -0.1542, 1.6867> <0.0000, -0.1542, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1669, 1.6181> <-0.0365, -0.1669, 1.6181> <-0.0840, -0.1403, 1.6181> <-0.1099, -0.1146, 1.6181>
		<0.0000, -0.1631, 1.6387> <-0.0365, -0.1631, 1.6387> <-0.0783, -0.1355, 1.6387> <-0.1043, -0.1098, 1.6387>
		<0.0000, -0.1579, 1.6661> <-0.0324, -0.1579, 1.6661> <-0.0762, -0.1254, 1.6663> <-0.0984, -0.1018, 1.6663>
		<0.0000, -0.1542, 1.6867> <-0.0324, -0.1542, 1.6867> <-0.0696, -0.1207, 1.6867> <-0.0917, -0.0971, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1099, -0.1146, 1.6181> <-0.1373, -0.0874, 1.6181> <-0.1683, -0.0386, 1.6181> <-0.1683, 0.0000, 1.6181>
		<-0.1043, -0.1098, 1.6387> <-0.1316, -0.0827, 1.6387> <-0.1627, -0.0386, 1.6391> <-0.1627, 0.0000, 1.6391>
		<-0.0984, -0.1018, 1.6663> <-0.1211, -0.0776, 1.6663> <-0.1519, -0.0331, 1.6662> <-0.1519, 0.0000, 1.6662>
		<-0.0917, -0.0971, 1.6867> <-0.1144, -0.0729, 1.6867> <-0.1445, -0.0331, 1.6867> <-0.1445, 0.0000, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1683, 0.0000, 1.6181> <-0.1683, 0.0386, 1.6181> <-0.1373, 0.0874, 1.6181> <-0.1099, 0.1146, 1.6181>
		<-0.1627, 0.0000, 1.6391> <-0.1627, 0.0386, 1.6391> <-0.1316, 0.0827, 1.6387> <-0.1043, 0.1098, 1.6387>
		<-0.1519, 0.0000, 1.6662> <-0.1519, 0.0331, 1.6662> <-0.1211, 0.0776, 1.6663> <-0.0984, 0.1018, 1.6663>
		<-0.1445, 0.0000, 1.6867> <-0.1445, 0.0331, 1.6867> <-0.1144, 0.0729, 1.6867> <-0.0917, 0.0971, 1.6867>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1542, 1.6867> <0.0000, 0.1509, 1.7045> <0.0000, 0.1471, 1.7284> <0.0000, 0.1437, 1.7462>
		<-0.0324, 0.1542, 1.6867> <-0.0324, 0.1509, 1.7045> <-0.0270, 0.1471, 1.7284> <-0.0270, 0.1437, 1.7462>
		<-0.0696, 0.1207, 1.6867> <-0.0636, 0.1165, 1.7049> <-0.0568, 0.1090, 1.7280> <-0.0506, 0.1055, 1.7462>
		<-0.0917, 0.0971, 1.6867> <-0.0858, 0.0929, 1.7049> <-0.0743, 0.0884, 1.7280> <-0.0680, 0.0849, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1542, 1.6867> <0.0324, 0.1542, 1.6867> <0.0696, 0.1207, 1.6867> <0.0917, 0.0971, 1.6867>
		<0.0000, 0.1509, 1.7045> <0.0324, 0.1509, 1.7045> <0.0636, 0.1165, 1.7049> <0.0858, 0.0929, 1.7049>
		<0.0000, 0.1471, 1.7284> <0.0270, 0.1471, 1.7284> <0.0568, 0.1090, 1.7280> <0.0743, 0.0884, 1.7280>
		<0.0000, 0.1437, 1.7462> <0.0270, 0.1437, 1.7462> <0.0506, 0.1055, 1.7462> <0.0680, 0.0849, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0917, 0.0971, 1.6867> <0.1144, 0.0729, 1.6867> <0.1445, 0.0331, 1.6867> <0.1445, 0.0000, 1.6867>
		<0.0858, 0.0929, 1.7049> <0.1085, 0.0687, 1.7049> <0.1379, 0.0331, 1.7047> <0.1379, 0.0000, 1.7047>
		<0.0743, 0.0884, 1.7280> <0.0937, 0.0654, 1.7280> <0.1280, 0.0301, 1.7282> <0.1280, 0.0000, 1.7282>
		<0.0680, 0.0849, 1.7462> <0.0875, 0.0619, 1.7462> <0.1215, 0.0301, 1.7462> <0.1215, 0.0000, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1445, 0.0000, 1.6867> <0.1445, -0.0331, 1.6867> <0.1144, -0.0729, 1.6867> <0.0917, -0.0971, 1.6867>
		<0.1379, 0.0000, 1.7047> <0.1379, -0.0331, 1.7047> <0.1085, -0.0687, 1.7049> <0.0858, -0.0929, 1.7049>
		<0.1280, 0.0000, 1.7282> <0.1280, -0.0301, 1.7282> <0.0937, -0.0654, 1.7280> <0.0743, -0.0884, 1.7280>
		<0.1215, 0.0000, 1.7462> <0.1215, -0.0301, 1.7462> <0.0875, -0.0619, 1.7462> <0.0680, -0.0849, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0917, -0.0971, 1.6867> <0.0696, -0.1207, 1.6867> <0.0324, -0.1542, 1.6867> <0.0000, -0.1542, 1.6867>
		<0.0858, -0.0929, 1.7049> <0.0636, -0.1165, 1.7049> <0.0324, -0.1509, 1.7045> <0.0000, -0.1509, 1.7045>
		<0.0743, -0.0884, 1.7280> <0.0568, -0.1090, 1.7280> <0.0270, -0.1471, 1.7284> <0.0000, -0.1471, 1.7284>
		<0.0680, -0.0849, 1.7462> <0.0506, -0.1055, 1.7462> <0.0270, -0.1437, 1.7462> <0.0000, -0.1437, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1542, 1.6867> <-0.0324, -0.1542, 1.6867> <-0.0696, -0.1207, 1.6867> <-0.0917, -0.0971, 1.6867>
		<0.0000, -0.1509, 1.7045> <-0.0324, -0.1509, 1.7045> <-0.0636, -0.1165, 1.7049> <-0.0858, -0.0929, 1.7049>
		<0.0000, -0.1471, 1.7284> <-0.0270, -0.1471, 1.7284> <-0.0568, -0.1090, 1.7280> <-0.0743, -0.0884, 1.7280>
		<0.0000, -0.1437, 1.7462> <-0.0270, -0.1437, 1.7462> <-0.0506, -0.1055, 1.7462> <-0.0680, -0.0849, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0917, -0.0971, 1.6867> <-0.1144, -0.0729, 1.6867> <-0.1445, -0.0331, 1.6867> <-0.1445, 0.0000, 1.6867>
		<-0.0858, -0.0929, 1.7049> <-0.1085, -0.0687, 1.7049> <-0.1379, -0.0331, 1.7047> <-0.1379, 0.0000, 1.7047>
		<-0.0743, -0.0884, 1.7280> <-0.0937, -0.0654, 1.7280> <-0.1280, -0.0301, 1.7282> <-0.1280, 0.0000, 1.7282>
		<-0.0680, -0.0849, 1.7462> <-0.0875, -0.0619, 1.7462> <-0.1215, -0.0301, 1.7462> <-0.1215, 0.0000, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1445, 0.0000, 1.6867> <-0.1445, 0.0331, 1.6867> <-0.1144, 0.0729, 1.6867> <-0.0917, 0.0971, 1.6867>
		<-0.1379, 0.0000, 1.7047> <-0.1379, 0.0331, 1.7047> <-0.1085, 0.0687, 1.7049> <-0.0858, 0.0929, 1.7049>
		<-0.1280, 0.0000, 1.7282> <-0.1280, 0.0301, 1.7282> <-0.0937, 0.0654, 1.7280> <-0.0743, 0.0884, 1.7280>
		<-0.1215, 0.0000, 1.7462> <-0.1215, 0.0301, 1.7462> <-0.0875, 0.0619, 1.7462> <-0.0680, 0.0849, 1.7462>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1437, 1.7462> <0.0000, 0.1408, 1.7614> <0.0000, 0.1365, 1.7815> <0.0000, 0.1332, 1.7966>
		<-0.0270, 0.1437, 1.7462> <-0.0270, 0.1408, 1.7614> <-0.0236, 0.1365, 1.7815> <-0.0236, 0.1332, 1.7966>
		<-0.0506, 0.1055, 1.7462> <-0.0455, 0.1027, 1.7610> <-0.0427, 0.0969, 1.7812> <-0.0395, 0.0945, 1.7966>
		<-0.0680, 0.0849, 1.7462> <-0.0630, 0.0821, 1.7610> <-0.0573, 0.0783, 1.7812> <-0.0542, 0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1437, 1.7462> <0.0270, 0.1437, 1.7462> <0.0506, 0.1055, 1.7462> <0.0680, 0.0849, 1.7462>
		<0.0000, 0.1408, 1.7614> <0.0270, 0.1408, 1.7614> <0.0455, 0.1027, 1.7610> <0.0630, 0.0821, 1.7610>
		<0.0000, 0.1365, 1.7815> <0.0236, 0.1365, 1.7815> <0.0427, 0.0969, 1.7812> <0.0573, 0.0783, 1.7812>
		<0.0000, 0.1332, 1.7966> <0.0236, 0.1332, 1.7966> <0.0395, 0.0945, 1.7966> <0.0542, 0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0680, 0.0849, 1.7462> <0.0875, 0.0619, 1.7462> <0.1215, 0.0301, 1.7462> <0.1215, 0.0000, 1.7462>
		<0.0630, 0.0821, 1.7610> <0.0824, 0.0591, 1.7610> <0.1161, 0.0301, 1.7612> <0.1161, 0.0000, 1.7612>
		<0.0573, 0.0783, 1.7812> <0.0743, 0.0568, 1.7812> <0.1102, 0.0274, 1.7816> <0.1102, 0.0000, 1.7816>
		<0.0542, 0.0759, 1.7966> <0.0711, 0.0544, 1.7966> <0.1048, 0.0274, 1.7966> <0.1048, 0.0000, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.1215, 0.0000, 1.7462> <0.1215, -0.0301, 1.7462> <0.0875, -0.0619, 1.7462> <0.0680, -0.0849, 1.7462>
		<0.1161, 0.0000, 1.7612> <0.1161, -0.0301, 1.7612> <0.0824, -0.0591, 1.7610> <0.0630, -0.0821, 1.7610>
		<0.1102, 0.0000, 1.7816> <0.1102, -0.0274, 1.7816> <0.0743, -0.0568, 1.7812> <0.0573, -0.0783, 1.7812>
		<0.1048, 0.0000, 1.7966> <0.1048, -0.0274, 1.7966> <0.0711, -0.0544, 1.7966> <0.0542, -0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0680, -0.0849, 1.7462> <0.0506, -0.1055, 1.7462> <0.0270, -0.1437, 1.7462> <0.0000, -0.1437, 1.7462>
		<0.0630, -0.0821, 1.7610> <0.0455, -0.1027, 1.7610> <0.0270, -0.1408, 1.7614> <0.0000, -0.1408, 1.7614>
		<0.0573, -0.0783, 1.7812> <0.0427, -0.0969, 1.7812> <0.0236, -0.1365, 1.7815> <0.0000, -0.1365, 1.7815>
		<0.0542, -0.0759, 1.7966> <0.0395, -0.0945, 1.7966> <0.0236, -0.1332, 1.7966> <0.0000, -0.1332, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1437, 1.7462> <-0.0270, -0.1437, 1.7462> <-0.0506, -0.1055, 1.7462> <-0.0680, -0.0849, 1.7462>
		<0.0000, -0.1408, 1.7614> <-0.0270, -0.1408, 1.7614> <-0.0455, -0.1027, 1.7610> <-0.0630, -0.0821, 1.7610>
		<0.0000, -0.1365, 1.7815> <-0.0236, -0.1365, 1.7815> <-0.0427, -0.0969, 1.7812> <-0.0573, -0.0783, 1.7812>
		<0.0000, -0.1332, 1.7966> <-0.0236, -0.1332, 1.7966> <-0.0395, -0.0945, 1.7966> <-0.0542, -0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0680, -0.0849, 1.7462> <-0.0875, -0.0619, 1.7462> <-0.1215, -0.0301, 1.7462> <-0.1215, 0.0000, 1.7462>
		<-0.0630, -0.0821, 1.7610> <-0.0824, -0.0591, 1.7610> <-0.1161, -0.0301, 1.7612> <-0.1161, 0.0000, 1.7612>
		<-0.0573, -0.0783, 1.7812> <-0.0743, -0.0568, 1.7812> <-0.1102, -0.0274, 1.7816> <-0.1102, 0.0000, 1.7816>
		<-0.0542, -0.0759, 1.7966> <-0.0711, -0.0544, 1.7966> <-0.1048, -0.0274, 1.7966> <-0.1048, 0.0000, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.1215, 0.0000, 1.7462> <-0.1215, 0.0301, 1.7462> <-0.0875, 0.0619, 1.7462> <-0.0680, 0.0849, 1.7462>
		<-0.1161, 0.0000, 1.7612> <-0.1161, 0.0301, 1.7612> <-0.0824, 0.0591, 1.7610> <-0.0630, 0.0821, 1.7610>
		<-0.1102, 0.0000, 1.7816> <-0.1102, 0.0274, 1.7816> <-0.0743, 0.0568, 1.7812> <-0.0573, 0.0783, 1.7812>
		<-0.1048, 0.0000, 1.7966> <-0.1048, 0.0274, 1.7966> <-0.0711, 0.0544, 1.7966> <-0.0542, 0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1230, 1.8395> <-0.0216, 0.1230, 1.8395> <-0.0363, 0.0877, 1.8395> <-0.0488, 0.0701, 1.8395>
		<0.0000, 0.1260, 1.8266> <-0.0216, 0.1260, 1.8266> <-0.0379, 0.0894, 1.8266> <-0.0504, 0.0718, 1.8266>
		<0.0000, 0.1303, 1.8095> <-0.0236, 0.1303, 1.8095> <-0.0369, 0.0925, 1.8092> <-0.0516, 0.0739, 1.8092>
		<0.0000, 0.1332, 1.7966> <-0.0236, 0.1332, 1.7966> <-0.0395, 0.0945, 1.7966> <-0.0542, 0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, 0.1230, 1.8395> <0.0000, 0.1260, 1.8266> <0.0000, 0.1303, 1.8095> <0.0000, 0.1332, 1.7966>
		<0.0216, 0.1230, 1.8395> <0.0216, 0.1260, 1.8266> <0.0236, 0.1303, 1.8095> <0.0236, 0.1332, 1.7966>
		<0.0363, 0.0877, 1.8395> <0.0379, 0.0894, 1.8266> <0.0369, 0.0925, 1.8092> <0.0395, 0.0945, 1.7966>
		<0.0488, 0.0701, 1.8395> <0.0504, 0.0718, 1.8266> <0.0516, 0.0739, 1.8092> <0.0542, 0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0488, 0.0701, 1.8395> <0.0504, 0.0718, 1.8266> <0.0516, 0.0739, 1.8092> <0.0542, 0.0759, 1.7966>
		<0.0628, 0.0505, 1.8395> <0.0644, 0.0523, 1.8266> <0.0685, 0.0524, 1.8092> <0.0711, 0.0544, 1.7966>
		<0.0876, 0.0240, 1.8395> <0.0927, 0.0240, 1.8266> <0.1000, 0.0274, 1.8096> <0.1048, 0.0274, 1.7966>
		<0.0876, 0.0000, 1.8395> <0.0927, 0.0000, 1.8266> <0.1000, 0.0000, 1.8096> <0.1048, 0.0000, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0876, 0.0000, 1.8395> <0.0927, 0.0000, 1.8266> <0.1000, 0.0000, 1.8096> <0.1048, 0.0000, 1.7966>
		<0.0876, -0.0240, 1.8395> <0.0927, -0.0240, 1.8266> <0.1000, -0.0274, 1.8096> <0.1048, -0.0274, 1.7966>
		<0.0628, -0.0505, 1.8395> <0.0644, -0.0523, 1.8266> <0.0685, -0.0524, 1.8092> <0.0711, -0.0544, 1.7966>
		<0.0488, -0.0701, 1.8395> <0.0504, -0.0718, 1.8266> <0.0516, -0.0739, 1.8092> <0.0542, -0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0488, -0.0701, 1.8395> <0.0504, -0.0718, 1.8266> <0.0516, -0.0739, 1.8092> <0.0542, -0.0759, 1.7966>
		<0.0363, -0.0877, 1.8395> <0.0379, -0.0894, 1.8266> <0.0369, -0.0925, 1.8092> <0.0395, -0.0945, 1.7966>
		<0.0216, -0.1230, 1.8395> <0.0216, -0.1260, 1.8266> <0.0236, -0.1303, 1.8095> <0.0236, -0.1332, 1.7966>
		<0.0000, -0.1230, 1.8395> <0.0000, -0.1260, 1.8266> <0.0000, -0.1303, 1.8095> <0.0000, -0.1332, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<0.0000, -0.1230, 1.8395> <0.0000, -0.1260, 1.8266> <0.0000, -0.1303, 1.8095> <0.0000, -0.1332, 1.7966>
		<-0.0216, -0.1230, 1.8395> <-0.0216, -0.1260, 1.8266> <-0.0236, -0.1303, 1.8095> <-0.0236, -0.1332, 1.7966>
		<-0.0363, -0.0877, 1.8395> <-0.0379, -0.0894, 1.8266> <-0.0369, -0.0925, 1.8092> <-0.0395, -0.0945, 1.7966>
		<-0.0488, -0.0701, 1.8395> <-0.0504, -0.0718, 1.8266> <-0.0516, -0.0739, 1.8092> <-0.0542, -0.0759, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0488, -0.0701, 1.8395> <-0.0504, -0.0718, 1.8266> <-0.0516, -0.0739, 1.8092> <-0.0542, -0.0759, 1.7966>
		<-0.0628, -0.0505, 1.8395> <-0.0644, -0.0523, 1.8266> <-0.0685, -0.0524, 1.8092> <-0.0711, -0.0544, 1.7966>
		<-0.0876, -0.0240, 1.8395> <-0.0927, -0.0240, 1.8266> <-0.1000, -0.0274, 1.8096> <-0.1048, -0.0274, 1.7966>
		<-0.0876, 0.0000, 1.8395> <-0.0927, 0.0000, 1.8266> <-0.1000, 0.0000, 1.8096> <-0.1048, 0.0000, 1.7966>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0876, 0.0000, 1.8395> <-0.0927, 0.0000, 1.8266> <-0.1000, 0.0000, 1.8096> <-0.1048, 0.0000, 1.7966>
		<-0.0876, 0.0240, 1.8395> <-0.0927, 0.0240, 1.8266> <-0.1000, 0.0274, 1.8096> <-0.1048, 0.0274, 1.7966>
		<-0.0628, 0.0505, 1.8395> <-0.0644, 0.0523, 1.8266> <-0.0685, 0.0524, 1.8092> <-0.0711, 0.0544, 1.7966>
		<-0.0488, 0.0701, 1.8395> <-0.0504, 0.0718, 1.8266> <-0.0516, 0.0739, 1.8092> <-0.0542, 0.0759, 1.7966>
	}
	
	
    // Line 2836 ########################################################################
    // u_steps and v_steps are 1 from here to end of file.
    
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, 0.0074, -2.0069> <0.0000, 0.0078, -1.9994> <0.0000, 0.0075, -1.9894> <0.0000, 0.0087, -1.9820>
		<-0.0017, 0.0074, -2.0069> <-0.0017, 0.0078, -1.9994> <-0.0020, 0.0075, -1.9894> <-0.0020, 0.0087, -1.9820>
		<-0.0040, 0.0064, -2.0069> <-0.0043, 0.0067, -1.9994> <-0.0039, 0.0067, -1.9894> <-0.0048, 0.0076, -1.9820>
		<-0.0052, 0.0052, -2.0069> <-0.0055, 0.0055, -1.9994> <-0.0053, 0.0053, -1.9894> <-0.0062, 0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, 0.0074, -2.0069> <0.0017, 0.0074, -2.0069> <0.0040, 0.0064, -2.0069> <0.0052, 0.0052, -2.0069>
		<0.0000, 0.0078, -1.9994> <0.0017, 0.0078, -1.9994> <0.0043, 0.0067, -1.9994> <0.0055, 0.0055, -1.9994>
		<0.0000, 0.0075, -1.9894> <0.0020, 0.0075, -1.9894> <0.0039, 0.0067, -1.9894> <0.0053, 0.0053, -1.9894>
		<0.0000, 0.0087, -1.9820> <0.0020, 0.0087, -1.9820> <0.0048, 0.0076, -1.9820> <0.0062, 0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0052, 0.0052, -2.0069> <0.0064, 0.0040, -2.0069> <0.0074, 0.0017, -2.0069> <0.0074, 0.0000, -2.0069>
		<0.0055, 0.0055, -1.9994> <0.0067, 0.0043, -1.9994> <0.0078, 0.0017, -1.9994> <0.0078, 0.0000, -1.9994>
		<0.0053, 0.0053, -1.9894> <0.0067, 0.0039, -1.9894> <0.0075, 0.0020, -1.9894> <0.0075, 0.0000, -1.9894>
		<0.0062, 0.0062, -1.9820> <0.0076, 0.0048, -1.9820> <0.0087, 0.0020, -1.9820> <0.0087, 0.0000, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0074, 0.0000, -2.0069> <0.0074, -0.0017, -2.0069> <0.0064, -0.0040, -2.0069> <0.0052, -0.0052, -2.0069>
		<0.0078, 0.0000, -1.9994> <0.0078, -0.0017, -1.9994> <0.0067, -0.0043, -1.9994> <0.0055, -0.0055, -1.9994>
		<0.0075, 0.0000, -1.9894> <0.0075, -0.0020, -1.9894> <0.0067, -0.0039, -1.9894> <0.0053, -0.0053, -1.9894>
		<0.0087, 0.0000, -1.9820> <0.0087, -0.0020, -1.9820> <0.0076, -0.0048, -1.9820> <0.0062, -0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0052, -0.0052, -2.0069> <0.0040, -0.0064, -2.0069> <0.0017, -0.0074, -2.0069> <0.0000, -0.0074, -2.0069>
		<0.0055, -0.0055, -1.9994> <0.0043, -0.0067, -1.9994> <0.0017, -0.0078, -1.9994> <0.0000, -0.0078, -1.9994>
		<0.0053, -0.0053, -1.9894> <0.0039, -0.0067, -1.9894> <0.0020, -0.0075, -1.9894> <0.0000, -0.0075, -1.9894>
		<0.0062, -0.0062, -1.9820> <0.0048, -0.0076, -1.9820> <0.0020, -0.0087, -1.9820> <0.0000, -0.0087, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<0.0000, -0.0074, -2.0069> <-0.0017, -0.0074, -2.0069> <-0.0040, -0.0064, -2.0069> <-0.0052, -0.0052, -2.0069>
		<0.0000, -0.0078, -1.9994> <-0.0017, -0.0078, -1.9994> <-0.0043, -0.0067, -1.9994> <-0.0055, -0.0055, -1.9994>
		<0.0000, -0.0075, -1.9894> <-0.0020, -0.0075, -1.9894> <-0.0039, -0.0067, -1.9894> <-0.0053, -0.0053, -1.9894>
		<0.0000, -0.0087, -1.9820> <-0.0020, -0.0087, -1.9820> <-0.0048, -0.0076, -1.9820> <-0.0062, -0.0062, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0052, -0.0052, -2.0069> <-0.0064, -0.0040, -2.0069> <-0.0074, -0.0017, -2.0069> <-0.0074, 0.0000, -2.0069>
		<-0.0055, -0.0055, -1.9994> <-0.0067, -0.0043, -1.9994> <-0.0078, -0.0017, -1.9994> <-0.0078, 0.0000, -1.9994>
		<-0.0053, -0.0053, -1.9894> <-0.0067, -0.0039, -1.9894> <-0.0075, -0.0020, -1.9894> <-0.0075, 0.0000, -1.9894>
		<-0.0062, -0.0062, -1.9820> <-0.0076, -0.0048, -1.9820> <-0.0087, -0.0020, -1.9820> <-0.0087, 0.0000, -1.9820>
	}
	bicubic_patch {
		type 0
		flatness 0
		u_steps 1
		v_steps 1
		<-0.0074, 0.0000, -2.0069> <-0.0074, 0.0017, -2.0069> <-0.0064, 0.0040, -2.0069> <-0.0052, 0.0052, -2.0069>
		<-0.0078, 0.0000, -1.9994> <-0.0078, 0.0017, -1.9994> <-0.0067, 0.0043, -1.9994> <-0.0055, 0.0055, -1.9994>
		<-0.0075, 0.0000, -1.9894> <-0.0075, 0.0020, -1.9894> <-0.0067, 0.0039, -1.9894> <-0.0053, 0.0053, -1.9894>
		<-0.0087, 0.0000, -1.9820> <-0.0087, 0.0020, -1.9820> <-0.0076, 0.0048, -1.9820> <-0.0062, 0.0062, -1.9820>
	}
    }
