  
 //  FILE NAME: x1mach1.pov
 //    Main Scene File Copyright 1998 David C. Hamilton
 
 //  FILE TYPE: .pov - POV-Ray Scene File 
 //    For use with the Persistence of Vision Ray-Tracer (Version 3.1)
 //    Persistence of Vision and POV-Ray are trademarks of the POV-Team
 
 //  SUBJECT: Bell Aircraft X-1 Experimental Rocket Plane (1947) 
 
 //  CREDITS:
 
 //    All scene files and image maps were created by David C. Hamilton
 
 //    Bicubic patches were generated using sPatch (see X-1 Model include file list below)
 //    sPatch is Copyright 1996-1998 by Mike Clifton
 //    Thanks, Mike, for a really slick application. 
 
 //    Many thanks to the POV-Team for creating such a great ray-tracer.
 
 //    And, of course, thanks to Chuck Yeager for flying that plane!
    
 
 /*  NOTES:  This file, and the accompanying files, are provided for study purposes and for personal
             non-commercial, non-distributed use only. Any other use requires the expressed written
             permission of the author.
             
             This file has been modified from the original to accomodate the fact that some of the original
             ancillary files, have been omitted and some substitutions have been made. As a result, the image
             produced by this scene file will not be identical to the original. These changes and omissions,
             however, should not materially affect the study value of this file. All the original code is here,
             but some lines have been commented-out due to the changes. The changes have been noted where
             applicable.
             
             Despite its length, this is a pretty straight forward POV-Ray scene file. Nothing really fancy is
             going on here. The 'include' files are just long lists of bicubic patch objects that define the
             basic shapes of the various aircraft parts. The majority of this scene file involves CSG operations
             on those basic shapes. Most of the operations are commented and additional notes are provided.
             
             For those who have not yet tried clipping bicubic patch objects, the two methods of clipping
             employed in this scene may be of interest. See the notes at the 'Fuselage' declaration (Line 379)
             and the 'LeftWingClipper' declaration (Line 833).
             
             A note on how the canopy framing was done will be found following the 'Canopy' declaration
             (around Line 218). The graphic file, 'explain.gif', also attempts to demonstrate how the framing
             was created.
             
             A note on the application of the image maps will be found at around Line 1250.
             
             The original image was rendered at [800x600, AA 0.2] with image output in TGA format. The render
             time, at this resolution, was just under twenty-five hours on a PC with a Pentium 200mHz CPU.  
             
             For a faster rendering image, reduce 'u-steps' and 'v_steps' in the 'fuselage.inc' file, but be
             sure to read the 'Special Notes' section in that file before doing so.
             
             Commenting out the 'Rocket_Exhaust' and/or the 'Shockwaves' objects (around Lines 1669 & 1671)
             will also help to speed-up rendering. 
             
             The author may be reached via email at: olm@sprynet.com                          
 */
 
 
 //  IMAGE MAPS FOR THIS SCENE:
  
   // insignia.gif  U.S. National insignia              (SUBSTITUTE FILE PROVIDED)
   // noseart.gif   Aircraft name - "Glamorous Glennis" (SUBSTITUTE FILE PROVIDED)
   // belllogo.gif  Bell Aircraft logo                  (SUBSTITUTE FILE PROVIDED)
   // tailno.gif    Aircraft tail number - "6062"
   // mark.gif      Positioning marks
   // release.gif   External hatch release handle and pressure dump valve
   // hatchind.gif  Cockpit hatch lock indicator
   // mwpline.gif   Main wing panel line
   // eline.gif     Horizontal elevator line            (OMITTED)
   

 // OK, here's the action:
    
   #version 3.1;
 
   global_settings { assumed_gamma 1.5
                     max_trace_level 7   // Higher trace level required for
                    }                    // rocket exhaust & shockwaves
                   

 // *** POV-Ray STANDARD INCLUDE FILES ***

   #include "colors.inc"
   #include "textures.inc"
   #include "metals.inc"

 // *** X-1 Model Include Files (bicubic patches) ***

   #include "fuselage.inc"  // Basic fuselage shape
   #include "lmain.inc."    // Left  main wing
   #include "rmain.inc."    // Right main wing
 //#include "mwroots.inc."  // Left & right main wing roots     (OMITTED)
   #include "vtail.inc"     // Vertical tail and dorsal fairing
   #include "vtliner.inc"   // Liner for vertical tail
 //#include "ventral.inc"   // Ventral fairing                  (OMITTED)
   #include "htail.inc"     // Horizontal tail
 //#include "htroots.inc"   // Horizontal tail roots            (OMITTED)
 //#include "hinges.inc"    // Horizontal tail elevator hinges  (OMITTED)
   #include "frames.inc"    // Cockpit canopy panel framing
 //#include "bumpscps.inc"  // Bumps and scoops                 (OMITTED)
   #include "npitot.inc"    // Nose  pitot tube
 //#include "lpitot.inc"    // Left wing pitot tube             (OMITTED)
 //#include "lpitotex.inc"  // Left wing pitot tube extension   (OMITTED)
 //#include "rpitot.inc"    // Right wing pitot tube            (OMITTED)
 //#include "bulb.inc"      // Right wing pitot bulb & vane     (OMITTED)
   #include "sdoors.inc"    // Shackle doors on dorsal fairing
 //#include "chuck.inc"     // A pilot of a sort                (OMITTED)
  

 // *** CAMERA ***

   camera {                          // The approximate center of the aircraft is at the origin.
     location <.001,.001,-8.5>
     look_at <.1,0,0>
     angle 25
    }
 
 
 // *** LIGHTS ***
     
   light_source { <-100,  50, -5> color rgb < 1, 1, 1> }  // The Sun (Main Light)
   light_source { <   0, 100,  0> color rgb <.7,.7,.7> }  // Sky light from above 
   light_source { <-100,   5,-15> color rgb <.6,.6,.6> }  // Sky light from left
   light_source { < 100,   0,  0> color rgb <.6,.6,.6> }  // Sky light from right
   light_source { <  20,-100,  0> color rgb <.4,.4,.4> }  // Sunlight reflected from the ground
   
   // NOTE: An additional light source is located in the 'Rocket_Exhaust' declaration
   //       in the 'Special Effects' Section.
    

 // *** VARIABLES ***
   
   #declare X_AxisRotation = x*-7 ;    // Number of degrees to turn aircraft on X axis
   #declare Y_AxisRotation = y*-28;    // Number of degrees to turn aircraft on Y axis
   #declare Z_AxisRotation = z*32 ;    // Number of degrees to turn aircraft on Z axis
    
   #declare LeftAileronAngle  = x*0;   // Number of degrees to rotate left  aileron up (- value) or down (+ value)
   #declare RightAileronAngle = x*0;   // Number of degrees to rotate right aileron up (- value) or down (+ value)
   #declare FlapAngle         = x*0;   // Number of degrees to lower flaps (use + value)
   #declare RudderAngle       = y*0;   // Number of degrees to turn the rudder right (- value) or left (+ value)
 
   
 // *** COLORs, FINISHES & TEXTURES ***

   #declare X1Color  = color red 0.90  green 0.15  blue 0.10;  // Overall color of the aircraft
   #declare X1rColor = color red 0.85  green 0.10  blue 0.10;  // Color of the cockpit rim & access panels
   #declare Desert1  = color red 0.75  green 0.65  blue 0.75;  // Ground colors used in sky sphere color map
   #declare Desert2  = color red 0.70  green 0.63  blue 0.60;
   #declare Desert3  = color red 0.75  green 0.62  blue 0.65;
   #declare CanopyFrameColor   = Gray20;
   #declare FuselagelinerColor = Gray15; 
   #declare Dull2     = finish  { specular 0.3 roughness 0.05 }
   #declare X1Finish  = texture { pigment { X1Color  } finish { Dull2 } }  // Overall aircraft finish
   #declare X1rFinish = texture { pigment { X1rColor } finish { Dull2 } }  // Finish for cockpit rim and
                                                                           // access panels
   #declare CanopyGlass =
     texture {
       pigment { color rgbt <.6, .6, .6, .5> }
       normal {
         waves .07
         scale 0.06
         frequency .75
         rotate y*45
         translate <0,0,.89>
        }
      finish  { specular 2.5 roughness .0009 reflection .5 ambient 0.0  diffuse 0.0 }  
     }
          
     
 // ############################  CSG TOOLS & SCENE OBJECT DECLARATIONS  ############################

 // *** CANOPY TOOLS ***
 
   #declare BasicCanopyTool =            // This "tool" will be used in various CSG operations
     union {                             // involving the cockpit canopy (windscreen).
       superellipsoid { <0.05, .05>
         scale <.4,.5,.5>
         translate <.105,0,0>
         rotate z*3.0
        }
       superellipsoid { <0.1, 0.1>
         scale .5
         translate <.040,.0228,0>
        }
       superellipsoid { <0.2, 0.2>
         scale <.4,.5,.5>
         translate <-.50,-.0140,0>
        }
       scale <.40,1,2>
      }
 
   #declare CanopyClipper_A =            // This "tool" will be used to create the cockpit canopy shape,
     object { BasicCanopyTool            // the canopy opening in the fuselage and to trim the canopy
       rotate y*-90                      // frame.
       translate <0,.63,-1.24>
      }
      
   #declare CanopyClipper_B =            // This is the same as 'CanopyClipper_B' but scaled differently.
     object { BasicCanopyTool            // It is used below to create the canopy border.
       scale .96
       rotate y*-90
       translate <0,.615,-1.245>
      }
      

 // *** CREATING THE CANOPY AND CANOPY FRAME ***
       
   #declare Canopy =                     // Here, the canopy is created by clipping a section out of
     object { BasicFuselage              // the forward area of the basic fuselage. 
       clipped_by { CanopyClipper_A }
       texture { CanopyGlass }
      }
      
 /* NOTE ON THE CANOPY FRAME: The canopy frame (bracing) was created in sPatch from copies of some of the
                              'formers and stringers' of the fuselage shape. While this took some fiddling,
                              it was easier than fussing for hours trying something like torus shapes. View
                              the 'explain.gif' file for a better idea of what the 'CanopyFrame' declaration
                              is doing.
 */
  
   #declare CanopyFrame =                // Triming the canopy frames. This cuts off the loose ends and
     object { Frames                     // lower portion of the canopy frame structure.
       clipped_by { CanopyClipper_A }
       pigment { CanopyFrameColor }
       finish { Shiny }
      }
 
   #declare CanopyBorder =               // The canopy frame outline. This is the thin black 'outline'
     object { Canopy                     // or border around the edge of the canopy.
       clipped_by { 
         object { CanopyClipper_B inverse }
        }
       pigment { CanopyFrameColor }
       finish { Shiny }
       translate <0,.0009,0>             // The frame needs to be raised slightly
      }
      
      
 // *** CREATING THE FUSELAGE LINER ***
 
   #declare FuselageLiner =                   // This is the basic fuselage shape with a cutout for
     object { BasicFuselage                   // the cockpit canopy opening and is scaled to fit
       clipped_by {                           // snugly inside the finished fuselage. It creates the
         object { CanopyClipper_A inverse }   // dark interior of the aircraft and also prevents 
        }                                     // "Bezier Patch shine-through" or glow.
       pigment { FuselagelinerColor }
       scale <.99,.99,1>
      }
      
 
 // *** CREATING THE COCKPIT HATCH ***
  
   #declare BasicHatch =                 // This is the basic shape for the cockpit hatch.
     difference {
       box { <-.12,.18,.20>,<.12,-.18,-.20> }
       box { <-.14,.16,.24>, <.14,.24,-.20>
         rotate x*-7.0
        }
       }

   #declare CornerClipper =              // Used below to round-off the corners of the hatch
     difference {
       cylinder {
         <-.13,0,0>, <.13,0,0>, .05
         translate <0,-.05,.05>
        }
       cylinder {
         <-.14,0,0>, <.14,0,0>, .05
        }
       }

   #declare CockpitHatchClipper =        // This is where the hatch tool gets its corners rounded. This tool will
     difference {                        // be used in the 'Fuselage' declaration to cut the hatch opening in the
                                         // fuselage side as well as to create the hatch cover itself.
       object { BasicHatch }
         object { CornerClipper          // bottom left corner
           translate <0,-.13,.15>
          }
         object { CornerClipper          // bottom right corner
           rotate x*90
           translate <0,-.13,-.15>
          }
         object { CornerClipper          // upper left corner
           rotate x*-90
           translate <0,.127,.15>
          }
         object { CornerClipper          // upper right corner
           rotate x*-180
           translate <0,.092,-.15>
          }
         }
         
   #declare CockpitHatch =               // The finished cockpit hatch.
     object { BasicFuselage
       clipped_by {
         object { CockpitHatchClipper
           scale <1,.860,.920>
           translate <-.2,-.025,-1.12>
          }
         }
        texture { X1Finish }
        texture {
          pigment {
            image_map {
              gif "hatchind.gif"         // Hatch lock indicator
              map_type 0
              once
              interpolate 2
              transmit 135, 1.0
             }
            translate <-.5,-.5,-.5>
            scale .05
            rotate y*90
            translate <0,0,-1.15>
           }
          }
         }

   #declare CockpitHatchBacker =         // This is just a piece of the fuselage inserted behind the hatch
     object { BasicFuselage              // so that the fuselage liner color will not show around the hatch
       clipped_by {                      // joint line.
         object { CockpitHatchClipper
           scale <1,1.01,1.01>
           translate <-.2,-.025,-1.12>
          }
         }
       texture {
         pigment { X1Color }
        }
       translate <.0025,0,0>
      }

   #declare HatchRelease =               // An area on the fuselage, just forward of the cockpit hatch for
     object { BasicFuselage              // the external hatch release handle and pressure dump valve image
       clipped_by {                      // map. There is a corresponding cutout in the 'Fuselage' declaration
         box { <0,0,0>,<.25,-.14,-.12>   // to accomodate this. 
         translate <-.30,0,-1.325>
         }
        }
      texture { X1Finish }
      texture {
        pigment {
          image_map {
            gif "release.gif"            // Image map representing the external hatch release handle
            map_type 0                   // and pressure dump valve
            once
            interpolate 2
            transmit 135, 1.0
           }
          translate <-.5,-.5,-.5>
          scale .1
          rotate y*90
          translate <0,-.07,-1.37>
         }
        }
       }
       
       
 // *** CREATING THE FUSELAGE ACCESS PANELS ***  
  
   #declare AccessPanels =               // Areas on fuselage, above main wings, representing the port
     object { BasicFuselage              // and starboard fuselage access panels. There is a corresponding
       clipped_by {                      // cutout in the 'Fuselage' declaration to accomodate this.
         box { <-.5,-.5,-.5>, <.5,.5,.5>
           scale <1,.18,.5>
           translate <0,.2,-.05>
          }
         }
       texture { X1rFinish }             // The access panel color is a slightly different shade of the
      }                                  // overall X1 color.
      
      
 // *** PREPARING THE FUSELAGE SHAPE FOR SUBSEQUENT CSG OPERATIONS ***
 
 /* NOTE: The POV docs say that patch primitives are not good candidates for CSG operations. But, while
          bicubic patches cannot clip other objects, they can be clipped. Here,'clipped_by/inverse'
          is used to clip the fuselage shape. Normally, in a clipping operation, any part of the clipped
          object (the Clippee) falling inside the clipping object (the Clipper) is retained, while any part
          of the Clippee lying outside the Clipper is discarded. Use of the 'inverse' keyword, however,
          reverses this. So, instead of winding-up with a bunch of pieces cut from the fuselage shape, we
          get the fuselage with a bunch of openings cut in it.
 */
            
   #declare Fuselage =                         // Creates all the necessary cutouts in the fuselage shape
     object { BasicFuselage   
       clipped_by {
         object { CanopyClipper_A              // Cuts out the canopy opening
           inverse
          }
         }                
       clipped_by {
         box { <-.50,-.50,.50>,<.50,.50,-.50>  // Cutout for the national insignia
           scale <.65,.45,.8>
           translate <0,0,.8>
           inverse
          }
         }          
       clipped_by {
         box { <0,0,0>,<.25,-.17,-.30>         // Cutout for the nose art "Glamorous Glennis"
           translate <-.25,.09,-1.45>
           inverse
          }
         }           
       clipped_by {
         box { <0,0,0>,<.25,.1,-.45>           // Cutout for the Bell logo on the left nose
           translate <0,-.025,-1.41>
           inverse
          }
         }           
       clipped_by {
         box { <0,0,0>,<.25,.1,-.47>           // Cutout for the Bell logo on the right side
           translate <-.39,.012,-.44>
           inverse
          }
         }           
       clipped_by {
         object { CockpitHatchClipper          // Cutout for cockpit hatch
           scale <1,.9,.95>
           translate <-.2,-.020,-1.12>
           inverse
          }
         }           
       clipped_by {
         box { <0,0,0>,<.25,-.14,-.12>         // Cutout for hatch release and pressure dump valve
           translate <-.30,0,-1.325>           // image map
           inverse
          }
         }            
       clipped_by {
         box { <0,0,0>,<.25,-.25,-.35>         // Cutout for forward left positioning mark image map
           scale <1.1,.375,.23>
           translate <.12,.12,-.78>
           inverse
          }
         }           
       clipped_by {
         box { <0,0,0>,<.25,-.25,-.35>         // Cutout for forward right positioning mark image map
           scale <1.1,.375,.23>
           translate <-.39,.21,-.78>
           inverse
          }
         }           
       clipped_by {
         box { <-.5,-.5,-.5>, <.5,.5,.5>       // Cutout for fuselage access panels
           scale <1,.18,.5>
           translate <0,.2,-.05>
           inverse
          }
         }
       texture { X1Finish }
      }


 // *** CREATING THE COCKPIT RIM ***
       
   #declare RimTool =                         // Used below in creating the rim around the
     union {                                  // cockpit canopy area.
       superellipsoid { <0.05, .05>
         scale <.4,.5,.5>
         translate <.105,0,0>
         rotate z*3.0
        }
       superellipsoid { <0.1, 0.1>
         scale .5
         translate <.040,.0228,0>
        }
       superellipsoid { <0.2, 0.2>
         scale <.4,.5,.5>
         translate <-.50,-.0140,0>
        }
       box {
         <-.5,-.5,-.5>, <.5,.5,.5>
         scale <.5,.1,1.1>
         rotate z*4.5
         translate <-.20,-.464,0>
        }
       scale <.45,1.04,2.04>
       rotate y*-90
       translate <0,.625,-1.22>
      }
       
   #declare BasicRim =                        // The basic rim around the cockpit canopy is cut from
     object { Fuselage                        // the fuselage shape.
       clipped_by {
         object { RimTool    
          } 
         }
        scale <1.008,1.008,1>
        texture { X1rFinish }                 // The same is used here as for the access panels.
       }
          
   #declare CockpitRim =                      // The finished cockpit rim
     object { BasicRim   
       clipped_by {
         object { CockpitHatchClipper         // Cuts out a notch in the rim for the hatch
           scale <1,.9,.95>
           translate <-.2,-.020,-1.12>
           inverse
          }
         }
        }
        

 // *** CREATING THE RUDDER ***
   
   #declare RudderClipper =                   // Used below to cut the rudder from the vertical tail shape.
     union {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Rudder
         scale <.1,.75,.18>
         translate <0,.53,1.82>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Top rudder hinge
         scale <.20,.050,.10>
         translate <0,.881,1.75>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Middle rudder hinge
         scale <.20,.042,.10>
         translate <0,.7,1.75>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Bottom rudder hinge
         scale <.20,.030,.10>
         translate <0,.49,1.74>
        }
       }

   #declare BasicRudder =                     // The rudder is clipped from the vertical tail
     object { VTail
       clipped_by {
         object { RudderClipper}
        }
       texture { X1Finish }
      }
 
   #declare RudderLiner =                     // Prevents "Bezier Patch shine-through" (glow)
     object { VTailLiner
       clipped_by {
         object { RudderClipper}
        }
       pigment { Black }
       scale <.999,.999,1>
      }
      
   #declare Rudder =           // The finished rudder
     union {
       object { BasicRudder }
       object { RudderLiner }
       translate <0,0,-1.7>    // Move rudder to the y axis.
       rotate RudderAngle      // Turn it.
       translate <0,0,1.7>     // Move it back into position.
      }
      
 
 // *** COMPLETING THE VERTICAL TAIL ***
      
   #declare TailClipper =           // Cuts space out of the vertical tail for the rudder and hinges
     union {                        // Similar to RudderClipper above but with different scaling
     
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Rudder cutout
         scale <.1,.76,.19>
         translate <0,.53,1.82>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Top rudder hinge cutout
         scale <.20,.06,.110>
         translate <0,.881,1.753>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Middle rudder hinge cutout
         scale <.20,.052,.110>
         translate <0,.7,1.753>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Bottom rudder hinge cutout
         scale <.20,.039,.105>
         translate <0,.49,1.74>
        }
       }
  
   #declare VerticalTail =                      // Vertical stabilizer and dorsal fairing
     object { VTail
       clipped_by {
         object { TailClipper inverse }
        }
       clipped_by {
         box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cutout for tail number - right side
           scale <.05,.11,.30>
          translate <-.025,.625,1.53>
          inverse
         }
        }
       clipped_by {
         box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cutout for tail number - left side
           scale <.05,.11,.30>
           translate <.025,.625,1.53>
           inverse
          }
         }
       texture { X1Finish }
      }
       
   #declare VerticalTailLiner =                 // Prevents "Bezier Patch shine-through" (glow)
     object { VTailLiner
       clipped_by { 
         object { TailClipper inverse }
        } 
       pigment { Black }
       scale <.999,.999,1.001>
      }

   #declare TailNumberClipperLeftside =
     box { <-.50,-.50,.50>,<.50,.50,-.50>       // Cutout for tail number surface
       scale <.05,.12,.30>
       translate <.025,.625,1.53>
      } 

   #declare TailNumberClipperRightside =
     box { <-.50,-.50,.50>,<.50,.50,-.50>       // Cutout for tail number surface
       scale <.05,.12,.30>
       translate <-.025,.625,1.53>
      }
     
   #declare TailNumberLeftside =                // Tail number on left side of vertical tail
     object { VTail
       clipped_by { TailNumberClipperLeftside }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "tailno.gif"                   // 6062
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale <.290,.350,1>
           rotate y*-90
           translate <0,.620,1.53>
          }
         }
        }
     
   #declare TailNumberRightside =               // Tail number 6062 on right side of vertical tail
     object { VTail
       clipped_by { TailNumberClipperRightside }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "tailno.gif"                   // 6062
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale <.290,.350,1>
           rotate y*90
           translate <0,.620,1.53>
          }
         }
        }
        
   #declare VerticalStabilizer =                // The finished vertical tail
     union {
       object { VerticalTail }
       object { VerticalTailLiner }
       object { TailNumberLeftside }
       object { TailNumberRightside }
      }


 // *** COMPLETING THE HORIZONTAL STABILIZER ***

   #declare HorizontalStabilizer =
     object { HTail
       texture { X1Finish }
     /*
       texture {
        pigment {
          image_map {
            gif "eline.gif"     eline.gif file omitted - This is simply a graphic representing
            map_type 0          the elevator hinge line. It was omitted because it is not visible
            once                in this view of the aircraft.
            interpolate 2
            transmit 135, 1.0
           }
          translate <-.5,-.5,0>
          scale <1.5,1,1>
          rotate x*90
          translate <0,0,1.65>
         }
        }
     */
       }


 // *** COMPLETING THE MAIN WINGS ***

   #declare LeftFlapClipper =                 // Clips space for left flap from the wing
     union {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Flap cutout
         scale <.69,.13,.2>
         scale <.97,1,1>
         rotate y*3
         translate <.685,0,.21>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Flap hinge cutout
         scale <.07,.13,.2>
         rotate y*3
         translate <.65,0,.20>
        }
       }

   #declare RightFlapClipper =                // Clips space for right flap from wing
     union {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Flap cutout
         scale <.69,.13,.2>
         scale <.97,1,1>
         rotate y*-3
         translate <-.685,0,.21>                       
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Flap hinge cutout
         scale <.07,.13,.2>
         rotate y*-3
         translate <-.65,0,.20>
        }
       }

   #declare LeftAileronClipper =              // Clips space for left aileron from wing
     union {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Left aileron cutout
         scale <.705,.13,.2>
         rotate y*5
         translate <1.38,0,.19>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Left inboard aileron hinge cutout
         scale <.06,.13,.2>
         rotate y*5
         translate <1.13,0,.17>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Left middle inboard aileron hinge cutout
         scale <.06,.13,.2>
         translate <1.30,0,.16>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Left middle outboard aileron hinge cutout
         scale <.06,.13,.2>
         rotate y*5
         translate <1.46,0,.145>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Left outboard aileron hinge cutout
         scale <.055,.13,.2>
         rotate y*5
         translate <1.625,0,.13>
        }
       }

   #declare RightAileronClipper =             // Clips space for right aileron from right wing
     union {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Right aileron cutout
         scale <.705,.13,.2>
         rotate y*-5
         translate <-1.38,0,.19>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Right inboard aileron hinge cutout
         scale <.06,.13,.2>
         rotate y*-5
         translate <-1.13,0,.17>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Right middle inboard aileron hinge cutout
         scale <.06,.13,.2>
         rotate y*-5
         translate <-1.30,0,.16>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Right middle outboard aileron hinge cutout
         scale <.06,.13,.2>
         rotate y*-5
         translate <-1.46,0,.145>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Right outboard aileron hinge cutout
         scale <.06,.13,.2>
         rotate y*-5
         translate <-1.622,0,.13>
        }
       }

   #declare LeftFlap =
     object { LeftMainWing
       clipped_by { LeftFlapClipper }         // Clips the flap shape from the wing
       texture { X1Finish }
       rotate y*-3                            // Rotate it parallel to the x axis.
       translate <0,0,-.15>                   // Move it to the x axis.
       rotate FlapAngle                       // Rotate it.
       translate <0,0,.156>                   // Move it back to the wing,
       rotate y*3                             // and rotate it back into position.
      }

   #declare RightFlap =                       // Same operations as LeftFlap
     object { RightMainWing
       clipped_by { RightFlapClipper }
       texture { X1Finish }
       rotate y*3
       translate <0,0,-.15>
       rotate FlapAngle
       translate <0,0,.156>
       rotate y*-3
      }
   
  #declare LeftAileron =                      // Clips the aileron shape from the wing
    object { LeftMainWing
      clipped_by { LeftAileronClipper }
      texture { X1Finish }
      rotate y*-5                             // Rotate it parallel to the x axis,
      translate <0,0,-.13>                    // and move it to the x axis.
      rotate LeftAileronAngle                 // Rotate it up or down.
      translate <0,0,.135>                    // Move it back to the wing,
      rotate y*5                              // and rotate it back into position.
     }

   #declare RightAileron =                    // Same operations as left aileron
    object { RightMainWing
      clipped_by { RightAileronClipper }
      texture { X1Finish }
      rotate y*5
      translate <1.37,0,-.13>
      rotate RightAileronAngle
      translate <-1.37,0,.135>
      rotate y*-5
     }
        
      
 /*  NOTE: In some CSG operations in this scene file,'difference' is used indirectly to clip bicubic patches
           instead of 'clipped_by/inverse' ... just for a change of pace. In the following declaration, the
           clipping object (the Clipper) is a box from which other boxes are subtracted creating voids inside
           the first box. These voids are technically, as far as POV-Ray is concerned, outside the first box.
           When the Clipper is applied to the Clippee (the left wing in this case), only those parts of the
           Clippee inside the Clipper remain. Either way, using 'clipped_by/inverse' or the indirect 'difference'
           method, the end result is the same. Although the POV docs say you can't do it, you can probably get away
           with applying 'difference' directly to a bicubic patch in most situations. However, you will get a
           warning that patch objects are 'not allowed in intersection'. Why a warning for 'intersection' and not
           'difference'? As it turns out, 'difference' is actually an 'intersection/inverse' operation. See
           Difference in the POV docs for the explanation.       
 */

   #declare LeftWingClipper =
     difference {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Encompasses all of left wing
         scale <1.6,.3,.9>
         translate <1,0,-.08>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space from left wing top surface for insignia panel
          scale <.75,.13,.42>
          translate <1.25,.06,-.09>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left flap from wing
        scale <.68,.13,.2>
        rotate y*3
        translate <.685,0,.21>
       }
      box { <-.50,-.50,.50>,<.50,.50,-.50>    // Cuts out space for left aileron from wing
        scale <.72,.13,.2>
        rotate y*5
        translate <1.38,0,.19>
       }
      box { <-.50,-.50,.50>,<.50,.50,-.50>    // Cuts out space for left flap hinge
        scale <.075,.13,.2>
        rotate y*3
        translate <.65,0,.20>
       }
      box { <-.50,-.50,.50>,<.50,.50,-.50>    // Cuts out space for left inboard aileron hinge
        scale <.08,.13,.2>
        rotate y*5
        translate <1.13,0,.17>
       }
      box { <-.50,-.50,.50>,<.50,.50,-.50>    // Cuts out space for left middle inboard aileron hinge
        scale <.08,.13,.2>
        rotate y*5
        translate <1.30,0,.16>
       }
      box { <-.50,-.50,.50>,<.50,.50,-.50>    // Cuts out space for left middle outboard aileron hinge
        scale <.08,.13,.2>
        rotate y*5
        translate <1.46,0,.145>
        }
      box { <-.50,-.50,.50>,<.50,.50,-.50>    // Cuts out space for left outboard aileron hinge
        scale <.08,.13,.2>
        rotate y*5
        translate <1.62,0,.13>
       }
      }

   #declare RightWingClipper =                //Same operations as for LeftWingClipper above
     difference {
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <1.6,.3,.9>
         translate <-1,0,-.08>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.75,.13,.42>
         translate <-1.25,-.06,-.09>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.68,.13,.2>
         rotate y*-3
         translate <-.685,0,.21>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.72,.13,.2>
         rotate y*-5
         translate <-1.38,0,.19>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.075,.13,.2>
         rotate y*-3
         translate <-.65,0,.20>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.13,0,.17>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.30,0,.16>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.46,0,.145>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.62,0,.13>
        }
       }

   #declare LeftWingInsigniaClipper =         // Prepares upper left wing surface for National insignia image map
     difference {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Encompasses insignia panel area on left wing
         scale <.75,.13,.42>
         translate <1.25,.06,-.09>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left flap from insignia panel
         scale <.7,.13,.2>
         rotate y*3
         translate <.685,0,.21>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left aileron from insignia panel
         scale <.72,.13,.2>
         rotate y*5
         translate <1.38,0,.19>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left inboard aileron hinge
         scale <.08,.13,.2>
         rotate y*5
         translate <1.13,0,.17>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left middle inboard aileron hinge
         scale <.08,.13,.2>
         rotate y*5
         translate <1.30,0,.16>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left middle outboard aileron hinge
         scale <.08,.13,.2>
         rotate y*5
         translate <1.46,0,.145>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Cuts out space for left outboard aileron hinge
         scale <.06,.13,.2>
         rotate y*5
         translate <1.62,0,.13>
        }
       }

   #declare RightWingInsigniaClipper =        // Prepares lower right wing surface for National insignia image map
     difference {
       box { <-.50,-.50,.50>,<.50,.50,-.50>   // Same operations as for LeftWingInsigniaClipper above
         scale <.75,.13,.42>
         translate <-1.25,-.06,-.09>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>   
         scale <.7,.13,.2>
         rotate y*-3
         translate <-.685,0,.21>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.72,.13,.2>
         rotate y*-5
         translate <-1.38,0,.19>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.13,0,.17>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.30,0,.16>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>
         rotate y*-5
         translate <-1.46,0,.145>
        }
       box { <-.50,-.50,.50>,<.50,.50,-.50>
         scale <.08,.13,.2>                   
         rotate y*-5
         translate <-1.62,0,.13>
        }
       }

   #declare LeftMainWingInsignia =            // Left Wing insignia
     object { LeftMainWing    
       clipped_by { LeftWingInsigniaClipper }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "mwpline.gif"                // Represents wing panel joint line
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale <1.5,1,1>
           rotate x*90
           rotate y*3
           translate <1,0,.015>
          }
         }
       texture {
         pigment {
           image_map {
             gif "mwpline.gif"                // Represents wing panel joint line
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale <1.5,1,1>
           rotate x*90
           rotate y*-5
           translate <1,0,-.28>
          }
         }
       texture {
         pigment {
           image_map {
             gif "insignia.gif"               // U.S. National insignia on left wing upper surface
             map_type 0                       // A substitue image has been provided
             once
             interpolate 2
             transmit 135, 1.0
             transmit 000, 1.0
            }
            translate <-.5,-.5,0>
            scale .65
            rotate x*90
            rotate y*180
           }
           translate <1.25,0,-.12>
          }
         }

   #declare RightMainWingInsignia =           // Right Wing insignia
     object { RightMainWing
       clipped_by { RightWingInsigniaClipper }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "mwpline.gif"                // Represents wing panel joint line
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale <1.5,1,1>
           rotate x*90
           rotate y*-3
           translate <-1,0,.015>
          }
         }
       texture {
         pigment {
           image_map {
             gif "mwpline.gif"                // Represents wing panel joint line
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale <1.5,1,1>
           rotate x*90
           rotate y*5
           translate <-1,0,-.28>
          }
         }
       texture {
         pigment {
           image_map {
             gif "insignia.gif"               // U.S. National insignia on right wing lower surface
             map_type 0                       // A substitue image has been provided
             once
             interpolate 2
             transmit 135, 1.0
             transmit 000, 1.0
            }
           translate <-.5,-.5,0>
           scale .65
           rotate x*90
           rotate y*180
          }
          translate <-1.25,0,-.12>
         }
        }
               
   #declare LeftWing =        
     union {
       object { LeftMainWing
         clipped_by { LeftWingClipper }
         texture { X1Finish }
         texture {
           pigment {
             image_map {
               gif "mwpline.gif"              // Represents wing panel joint line
               map_type 0
               once
               interpolate 2
               transmit 135, 1.0
              }
             translate <-.5,-.5,0>
             scale <1.5,1,1>
             rotate x*90
             rotate y*3
             translate <1,0,.015>
            }
           }
         texture {
           pigment {
             image_map {                      
               gif "mwpline.gif"              
               map_type 0
               once
               interpolate 2
               transmit 135, 1.0
              }
             translate <-.5,-.5,0>
             scale <1.5,1,1>
             rotate x*90
             rotate y*-5
             translate <1,0,-.28>
            }
           }
          }
       object { LeftMainWingInsignia }
       object { LeftFlap }
       object { LeftAileron }
       scale <1.05, 1, 1.05>
       translate <-.02,0,0>
      }                                       //  End of left wing union
      
   #declare RightWing =                       // Same operations as for Left Wing above
     union {
       object { RightMainWing
         clipped_by { RightWingClipper }
         texture { X1Finish }
         texture {
           pigment {
             image_map {
               gif "mwpline.gif"
               map_type 0
               once
               interpolate 2
               transmit 135, 1.0
              }
             translate <-.5,-.5,0>
             scale <1.5,1,1>
             rotate x*90
             rotate y*-3
             translate <-1,0,.015>
            }
           }
         texture {
           pigment {
             image_map {
               gif "mwpline.gif"
               map_type 0
               once
               interpolate 2
               transmit 135, 1.0
              }
             translate <-.5,-.5,0>
             scale <1.5,1,1>
             rotate x*90
             rotate y*5
             translate <-1,0,-.28>
            }
           }
          }
       object { RightMainWingInsignia }
       object { RightFlap }
       object { RightAileron }
       scale <1.05, 1, 1.05>
       translate <.02,0,0>
      }                                       //  End of right wing union


 // *** PREPARING THE PITOT TUBES ***

   #declare Nose_Pitot_Tube =        // Aircraft nose pitot tube
     object { NosePitot
       pigment { Silver }
      }
 /*
   #declare Left_Pitot_Tube =        Left wing pitot tube and extension
     union {
       object { LeftPitot            lpitot.inc file omitted
         pigment { Gray50 }
        }
       object { LeftPitotExtension   lpitotex.inc file omitted
         pigment { Silver }
        }
       translate <.07,0,0>           Translation is required because wings are scaled larger
      }

   #declare Right_Pitot_Tube =       Right wing pitot tube, bulb & vane
     union {
       object { RightPitot           rpitot.inc include file omitted
         pigment { Silver }
        }
       object { PitotBulb            bulb.inc include file omitted
         pigment { Gray20 }
         finish  { Shiny }
        }
       translate <-.07,0,0>          Translation is required because wings are scaled larger
      }
 */
 
 // *** PREPARING THE MAIN FUSELAGE MARKINGS ***
 
 /*  NOTE: What is happening here is more of what has been happening in much of the rest of
           this file. We're cutting and fitting pieces of bicubic patches. But here, we're also
           applying image maps to the pieces. Each of these pieces, cut from the basic fuselage
           shape, will fit into corresponding holes previously cut out of the fuselage in the
           'Fuselage' declaration. The same type of operation was performed on the vertical tail
           in applying the tail number and on the main wings with the National insignia and wing
           panel lines.
 */ 

   #declare NoseArt =                // Aircraft name - "Glamorous Glennis"
     object { BasicFuselage
       clipped_by { box { <0,0,0>, <.25,-.17,-.30>
         translate <-.25,.09,-1.45> }
        }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "noseart.gif"       // A substitue image has been provided
             map_type 0
             once
             interpolate 2
             transmit 17, 1.0
            }
           translate <-.5,-.5,0>
           scale <.3,.25,.3>
           rotate y*90
           translate <0,.007,-1.6>
          }
         }
        }

   #declare Insignia =                // U.S. National insignia on fuselage side
     object { BasicFuselage           // (includes aft positioning marks)
       clipped_by {
         box { <-.50,-.50,.50>,<.50,.50,-.50>
           scale <.65,.45,.8>
           translate <0,0,.8>
          }
         }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "insignia.gif"       // A substitue image has been provided
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale .73
           rotate y*90
          }
          translate <0,0,.85>
         }
        }

   #declare PositionMark_Leftside =    // Forward leftside positioning mark
     object { BasicFuselage
       clipped_by {
         box { <0,0,0>,<.25,-.25,-.35>
          scale <1.1,.375,.23>
          translate <.12,.12,-.78>
         }
        }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "mark.gif"
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,0>
           scale .73
           rotate y*90
          }
          translate <.12,.12,-.78>
         }
        }

   #declare PositionMark_Rightside =   // Forward rightside positioning mark
     object { BasicFuselage
       clipped_by {
         box { <0,0,0>,<.25,-.25,-.35>
         scale <1.1,.375,.23>
         translate <-.39,.21,-.78>
        }
       }
      texture { X1Finish }
      texture {
        pigment {
          image_map {
            gif "mark.gif"
            map_type 0
            once
            interpolate 2
            transmit 135, 1.0
           }
           translate <-.5,-.5,0>
           scale .73
           rotate y*90
          }
          translate <-.39,.21,-.78>
         }
        }    

   #declare BELL_Logo_Left_Nose =    // The Bell logo on left nose
     object { BasicFuselage
       clipped_by { box { <0,0,0>,<.25,.1,-.45>
         translate <0,-.025,-1.41> }
        }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "belllogo.gif"      // A substitue image has been provided
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,-.5>
           scale <.30,.25,1>         // The Bell logo is stretched slightly along the x axis
           rotate y*-90              // before rotation & translation to the final position.
           translate <0,.018,-1.60>
          }
         }
        }

   #declare BELL_Logo_Rightside =   // The Bell logo on the right side of the fuselage aft of cockpit hatch
     object { BasicFuselage
       clipped_by { box { <0,0,0>,<.25,.1,-.47>
         translate <-.39,.012,-.44> }
        }
       texture { X1Finish }
       texture {
         pigment {
           image_map {
             gif "belllogo.gif"     // A substitue image has been provided
             map_type 0
             once
             interpolate 2
             transmit 135, 1.0
            }
           translate <-.5,-.5,-.5>
           scale <.30,.25,1>        // The Bell logo is stretched slightly along the `x' axis
           rotate y*90              // before rotation & translation to the final position.
           translate <0,.068,-.74>
         }
        }
       }
       
       
  // *** "SPECIAL EFFECTS" (Rocket Exhaust and Shockwaves) ***
  
   #declare Rocket_Exhaust =
     union {                        
       cone {                       // Basic shape of exhaust
         <0, 0, 0>, 0.12
         <0, 0, 3>, 0.02
         hollow
           pigment { color rgbt <1,1,1,1> }
           interior {
             media {
               emission <.6,.6,.8>
               scattering {3, .5}
               density {
                 wood
                   color_map {
                     [ 0.0 color RichBlue       ]
                     [ 0.6 color MidnightBlue   ]
                     [ 1.0 color White * 2      ]
                    }
                 scale .2
                }
               }
              }
         no_shadow 
        }
       #local Count=1;
       #local Size=.06;
       #local Move=0.2;
       #while (Count < 9 )    
       superellipsoid {             // Diamond shaped shockwaves in the exhaust
         <0.3, 2.0>
         hollow
         no_shadow
         texture { pigment { color rgbt <1,1,1,.9> } }
           interior {
             media {
               intervals 3
               emission <.4,.4,.7>
               scattering {3, .5}
               density {
                 spherical
                   color_map {
                     [ 0.1 color MidnightBlue   ]
                     [ 1.0 color White * 2      ]
                    }
                   }
                  }
                 }
         scale Size
         translate <0,0,Move>
        }
       #local Size=Size-.005;
       #local Move=Move+.2;
       #local Count=Count+1;
       #end
       light_source {               // This light source is located inside the fuselage 
         <0,0,-.8>                  // and is pointed at the rocket exhaust.
         color SkyBlue
         cylinder
         radius 5
         falloff 6
         tightness 10
         point_at <0,0,100>
        }
       translate <0,0,1.83>         // Locates the exhaust at the tail of the aircraft
      }
      

   #declare Shockwave_1 =           // The large shockwave touching the nose of the aircraft
     difference {
       sphere { <0,0,0>, .5
         scale <1,2,1>
        }
       sphere { <0,0,.25>, .5
         scale <1,2.2,1.3>
        }
       hollow
         no_shadow
         texture { pigment { color rgbt <1,1,1,1> } }
         interior {
           media {
             intervals 4
             emission <.6,.6,2>
             scattering {3, .5}
             density {
               spherical
                 color_map {
                   [ 0.0 color RichBlue     ]
                   [ 0.5 color MidnightBlue ]
                   [ 0.9 color White * 4.0  ]
                  }
                 } 
                }
               }
         scale <.4,1.5,.9>
        }
  
   #declare Shockwave_2 =           // The middle shockwave
     difference {
       sphere { <0,0,0>, .5
         scale <1,2,1>
        }
       sphere { <0,0,.25>, .5
         scale <1,2.2,1.3>
        }
       hollow
         no_shadow
         texture { pigment { color rgbt <1,1,1,1> } }
         interior {
           media {
             intervals 3
             emission <.6,.6,2>
             scattering {3, .5}
             density {
               spherical
                 color_map {
                   [ 0.0 color RichBlue     ]
                   [ 0.5 color MidnightBlue ]
                   [ 0.9 color RichBlue     ]
                  }
                 } 
                }
               }
         scale <.4,1.5,.9>
        }
                                    // The shockwave farthest from the nose of the aircraft
   #declare Shockwave_3 =
     difference {
       sphere { <0,0,0>, .5
         scale <1,2,1>
        }
       sphere { <0,0,.25>, .5
         scale <1,2.2,1.3>
        }
       hollow
         no_shadow
         texture { pigment { color rgbt <1,1,1,1> } }
         interior {
           media {
             intervals 3
             emission 0.75
             scattering {3, .5}
             density {
               spherical
                 color_map {
                   [ 0.0 color RichBlue     ]
                   [ 0.5 color MidnightBlue ]
                   [ 0.9 color RichBlue     ]
                  }
                 } 
                }
               }
         scale <.4,1.5,.9>
        }
        
   #declare Shockwaves =            // The combined shockwaves
     union {
       object { Shockwave_1 
         rotate y*45                // Tweaking the shockwave position
         scale <.13,.69,1.3>
         translate <0,0,-1.50>
        }    
       object { Shockwave_2 
         rotate y*45
         scale <.07,.5,.7>
         translate <0,0,-1.89>
        } 
       object { Shockwave_3 
         rotate y*45
         scale <.05,.4,.5>
         translate <0,0,-2.10>
        }
       rotate x*-20
       translate <0,.62,-.30>       // Final positioning of the shockwaves at the nose of the aircraft
      }


 // #########################################  THE SCENE  #########################################
 
 // This is where it all finally comes together.
 
   union {                     // *** AIRCRAFT UNION ***
     
     object { Fuselage }
     
     object { FuselageLiner }
     
     object { CockpitRim }
     
     object { Canopy }
     
     object { CanopyFrame }
     
     object { CanopyBorder }
    
 /*     
     object { Pilot                 (OMITTED) - It didn't look much like Chuck Yeager anyway.
       pigment { Gray20 }
      }
 */     
     object { CockpitHatch }

     object { CockpitHatchBacker }
     
     object { Insignia }            // National insignia on fuselage
                                    // A substitue image has been provided
                                    
     object { NoseArt }             // Aircraft name - "Glamorous Glennis"
                                    // A substitue image has been provided
     object { BELL_Logo_Left_Nose }
  
     object { BELL_Logo_Rightside }

     object { PositionMark_Leftside }

     object { PositionMark_Rightside }

     object { HatchRelease }
   
     object { VerticalStabilizer }  // Vertical tail and dorsal fairing
     
     object { Rudder }
 /*
     object { Ventral               Ventral fairing (OMITTED)
       texture { X1Finish }
      }

     object { BumpsScoops           Port and starboard bumps on nose 
       texture { X1Finish }         and aft port and starboard scoops (OMITTED)
      }
     
     object { MainWingRoots         (OMITTED)
       texture { X1Finish }
      }
 */      
     object { LeftWing }
     
     object { RightWing }
 
     object { Nose_Pitot_Tube }
 /* 
     object { Left_Pitot_Tube }     (OMITTED)

     object { Right_Pitot_Tube }    (OMITTED)
    
     object { HTRoots               Horizontal tail roots (OMITTED)
       texture { X1Finish }
      }
 */
     object { HorizontalStabilizer }
 /*
     object { Hinges                Elevator hinges (OMITTED)
       texture { X1Finish }          
      }                              
 */
     object { ShackleDoors          // Small doors on top of dorsal fairing
       texture { X1Finish }
      }
     
     object { AccessPanels }
 
     object { Rocket_Exhaust }
           
     object { Shockwaves }
       
    
 // *** AIRCRAFT SCALATION :-), ROTATION & TRANSLATION ***

     scale <1,1,1.1>           // The entire aircraft is stretched slightly along the Z axis

     rotate X_AxisRotation
     rotate Y_AxisRotation
     rotate Z_AxisRotation
    
     translate <0,0,0>
      
   }                           // *** END OF AIRCRAFT UNION  ***
 
 
 // *** SKY AND DESERT BACKGROUND ***
  
   sky_sphere {
     pigment {
       gradient y
       pigment_map {
         [ 0.0   color Desert1            ]
         [ 0.015 color Desert2            ]
         [ 0.02  color Desert3            ]
         [ 0.04  color RichBlue * 2.5     ]
         [ 0.1   color RichBlue * 1.5     ]
         [ 0.3   color MidnightBlue * 1.3 ]
         [ 0.4   color MidnightBlue * 1.0 ]
         [ 1.0   color RichBlue           ]
        }
       }
     rotate x*10
     rotate z*5
    }

    
 // *** IMAGE CAPTION ***
  
   union {
     text { ttf "gothicbi.ttf" "Man & Machine Meet the Supersonic Age" .1, 0
       texture { T_Chrome_5E }  
       scale .22
       rotate x*-25
       translate <-.2,-2,10>
      }
     text { ttf "gothicbi.ttf" "October 14, 1947" .1, 0
       pigment { color rgbt <1,1,1, 0.6> }
       scale .17
       rotate x*-15
       translate <-.2,-2.2,10>
      }
     translate <-.2,-.8,0>
    }
    
     
 // *** IMAGE COPYRIGHT NOTICE ***
    
   text { ttf "tahoma.ttf" " Copyright 1998  David C. Hamilton" .1, 0
     pigment { color rgbt <0.2, 0.2, 0.8, 0.85> }
     scale .1
     translate <2.60,-3.05,10>
    }             
         

 // #########################################  END OF SCENE  #########################################
  
  
 // *** REFERENCE AXES ***

 /*
  
   #declare X_Axis =
     cylinder {                   // x axis
       <50,0,0>, <-50,0,0> .009
       pigment { Red }
      }
   #declare Y_Axis =
     cylinder {                   // y axis
       <0,50,0>, <0,-50,0> .009
       pigment { Green }
      }
   #declare Z_Axis =
     cylinder {                   // z axis
       <0,0,50>, <0,0,-50> .009
       pigment { Blue }
      }
     
   object { X_Axis }
   object { Y_Axis }
 //object { Z_Axis }
  
 */

 
 // *** END OF FILE ***
 
 // Phew!