#declare FireBallEm  = 0.5;
#declare GreenBallEm = 0.3;
#declare RedHaloEm   = 0.12;
#declare BlueMainEm  = 0.3;

#declare fireball =
   object {
      sphere { 0, 1  // Firey interior
        pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission FireBallEm
                 density {
                    spherical                   
                    ramp_wave
                    color_map {
                       [0.0 color rgb <0.5, 0.00, 0> ]
                       [0.1 color rgb <0.5, 0.09, 0> * 3 ]
                       [0.2 color rgb <0.6, 0.09, 0> * 6 ]
                       [0.3 color rgb <0.6, 0.18, 0> * 9 ]
                       [0.4 color rgb <0.7, 0.18, 0> * 12]
                       [0.5 color rgb <0.7, 0.27, 0> * 15]
                       [0.6 color rgb <0.8, 0.27, 0> * 18]
                       [0.7 color rgb <0.8, 0.36, 0> * 21]
                       [0.8 color rgb <0.9, 0.36, 0> * 24]
                       [0.9 color rgb <0.9, 0.45, 0> * 27]
                       [1.0 color rgb <1.0, 0.45, 0> * 30]
                    }
                 }
               }
            }
         hollow
      }
        clipped_by{plane{y,0}}
  }

#declare dome =
   object {
       #version 2.0
       sphere { 0, 1  // glass dome
          pigment {color rgbf 1.0 1.0 1.0 0.99}
          finish{
             reflection 0.2  //was 0.2
             phong 1
             phong_size 20
             crand  .001
          }
          interior{ior 1.0 }
       hollow
      }
      #version 3.0
      clipped_by{plane{y,0}
    }
 }

#declare UFO1 =
  object {
    union {
      torus { 1.5, 0.02
         pigment { Red }
         translate <0,-1.9,0>
         finish {
             ambient 0.3
             diffuse 0.7
             brilliance 6.0
             reflection 0.6
             phong 0.8
             phong_size 120
         }
      }

       torus { 1.5, 0.05   // Red halo around hoop..this took awhile to figure out what would work...
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission RedHaloEm
                 density {
                    planar
                    color_map {
                       [0.0 color Red ]
                       [0.1 color Red * 3]
                       [0.2 color Red * 6]
                       [0.3 color Red * 9]
                       [0.4 color Red * 12]
                       [0.5 color Red * 15]
                       [0.6 color Red * 18]
                       [0.7 color Red * 21]
                       [0.8 color Red * 24]
                       [0.9 color Red * 27]
                       [1.0 color Red * 30]
                    }
                 }
               }
            }
         hollow
         translate <0,-1.9,0>
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <0,-1.5,-0.55>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <-0.5,-1.5,-0.4>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <0.5,-1.5,-0.4>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <0.7,-1.5,0>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <-0.7,-1.5,0>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <0,-1.5,0.55>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <-0.5,-1.5,0.4>
             hollow
             texture { Polished_Chrome }
      }
      sphere {<0,0,0>,
               0.1
             scale <1.5,0.75,1.5>
             translate <0.5,-1.5,0.4>
             hollow
             texture { Polished_Chrome }
      }
      // Here are the glows around the chrome spheres

      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <0,-1.5,-0.55>
      }
      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <-0.5,-1.5,-0.4>
      }
      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <0.5,-1.5,-0.4>
      }
      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <0.7,-1.5,0>
      }
      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <-0.7,-1.5,0>
      }
      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <0,-1.5,0.55>
      }
      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    // ramp_wave
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <-0.5,-1.5,0.4>
      }

      sphere { 0, 1
         pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission GreenBallEm
                 density {
                    spherical
                    color_map {
                       [0.0 color rgb <0.00,1,0> ]
                       [0.1 color rgb <0.09,1,0> * 3 ]
                       [0.2 color rgb <0.18,1,0> * 6 ]
                       [0.3 color rgb <0.27,1,0> * 9 ]
                       [0.4 color rgb <0.36,1,0> * 12]
                       [0.5 color rgb <0.45,1,0> * 15]
                       [0.6 color rgb <0.54,1,0> * 18]
                       [0.7 color rgb <0.63,1,0> * 21]
                       [0.8 color rgb <0.72,1,0> * 24]
                       [0.9 color rgb <0.81,1,0> * 27]
                       [1.0 color rgb <0.90,1,0> * 30]
                    }
                 }
               }
            }
         hollow
         scale 0.2
         translate <0.5,-1.5,0.4>
      }

        object {fireball
         rotate z*180
         scale <0.25,1.15,0.25>
         translate <0,-1.7,0>
      }
      light_source {<0,-1.4,0> color red 8 blue 0 green 2
         fade_power 3
         fade_distance 0.90
      }
      // Big main metal sphere
      difference {
         sphere {<0,0,0>,
                1.0
                scale <1.2,0.25,1.2>
                translate <0,-1.9,0>
                hollow
              texture {Polished_Chrome}
         }
         sphere { 0, 1  // Cutout section for fireball
            texture { Polished_Chrome }
            scale <0.45,0.45,0.45>
            translate <0,-1.5,0>
            hollow
         }
         sphere { 0, 1  // Cutout section for top
            texture { Polished_Chrome }
            scale <0.85,0.2,0.85>
            translate <0,-2.0,0>
            hollow
         }
      }
      // Big main metal sphere blue glow
      difference {
         sphere {<0,0,0>, 1.0
            pigment { color rgbt <1, 1, 1, 1> }
            interior {
               media {
                 emission BlueMainEm
                 density {
                    spherical
                    color_map {
                       [0.0 color Blue ]
                       [0.1 color Blue * 3]
                       [0.2 color Blue * 6]
                       [0.3 color Blue * 9]
                       [0.4 color Blue * 12]
                       [0.5 color Blue * 15]
                       [0.6 color Blue * 18]
                       [0.7 color Blue * 21]
                       [0.8 color Blue * 24]
                       [0.9 color Blue * 27]
                       [1.0 color Blue * 30]
                    }
                 }
               }
            }
            scale <1.4,0.45,1.4>  // 1.6
            translate <0,-1.9,0>
            hollow
         }
         sphere { 0, 1  // Cutout section for blue sphere center
            texture { Polished_Chrome }
            scale <0.40,0.40,0.40>
            translate <0,-1.7,0>
            hollow
         }
      }
      object {dome
        translate <0,-3,0>
        scale <0.85,0.65,0.85>
      }
      cylinder{<0,-2.08,0>,<0,-2.07,0>, 0.8 texture {Polished_Chrome} }
   }
}
