// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: central pillar building
// Date: feb 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998   

// arch texture
#declare T_Centre_Arch =
texture {
	radial
	texture_map {
		[0.0 T_13Stone1]
		[0.5 T_13Stone1]
		[0.5 T_13Stone2]
		[1.0 T_13Stone2]
	}
	rotate <0,0,90>
	frequency 13
}

// CENTRE PANELS
#declare Panel_Frame = 
difference { 
	union {
		box {<-6,-3,0><6,3,-.1> texture{T_13Stone1}}
		box {<-5.75,-2.75,-.1><5.75,2.75,-.2> texture{T_13Stone1}}
	}
	box {<-5.5,-2.5,1><5.5,2.5,-1> texture{T_13Stone1}}
}  

#declare Frieze =
union {
	box {<-7.5,-1,0><7.5,1,-.1> texture{T_13Stone1}}
	box {<-7,-0.5,0><7,.5,-.2> texture{T_13Stone1}}
}

#declare Frame1 =
union {
	object {Panel_Frame}
	box {<0,0,0><1,1,-.01> texture{pigment{image_map{gif "land1.gif"}}} scale <11,5,1> translate <-5.5,-2.5,0>}
} 

#declare Frame2 =
union {
	object {Panel_Frame}
	box {<0,0,0><1,1,-.01> texture{pigment{image_map{gif "logo.gif"}}} scale <11,5,1> translate <-5.5,-2.5,0>}
}

#declare Frame3 =
union {
	object {Panel_Frame}
	box {<0,0,0><1,1,-.01> texture{pigment{image_map{gif "land2.gif"}}} scale <11,5,1> translate <-5.5,-2.5,0>}
}

// SPECIAL DECORATIVE FEATURE
#declare Dec_Feature =
union {
	BOX (<-2,0,-2><2,4,2>,1,1,2,1,0)
	  
	sphere {<-1.5,4.5,-1.5>,.5 texture{T_13Gold1}}
	sphere {<1.5,4.5,-1.5>,.5 texture{T_13Gold1}}
	sphere {<-1.5,4.5,1.5>,.5 texture{T_13Gold1}}
	sphere {<1.5,4.5,1.5>,.5 texture{T_13Gold1}}
	
	difference {
		box {<-2,5,-2><2,15,2> texture{T_13Gold1}}
		
	    box {<0,-20,-10><10,20,10> rotate <0,0,15> translate <2,5,0> texture{T_13Gold1}}  
	    box {<0,-20,-10><-10,20,10> rotate <0,0,-15> translate <-2,5,0> texture{T_13Gold1}} 
	    
	    box {<-10,-20,0><10,20,20> rotate <-15,0,0> translate <0,5,2> texture{T_13Gold1}}
	    box {<-10,-20,0><10,20,-20> rotate <15,0,0> translate <0,5,-2> texture{T_13Gold1}}
	}
}

// SPECIAL COLUMN MACRO
#macro Height_Column (Origin,Size,Height,Type)

	#if (Type = 1)	// circular 
		#local NH = Height;
		Generic_Column (Origin,NH,1,18,2,3,1,Size)
	#else			// square  
		#local NH = (Height / Size);
		S_Generic_Column (Origin,NH,1,20,2,3,1,Size)
	#end

#end
 
 
#declare Col1 = union {Height_Column (<0,0,0>,10,35,2)}     
#declare Col2 = union {Height_Column (<0,0,0>,10,30,2)} 
 
#declare CBuilding =   
union {
	object {Col1 translate <-10,20,0>}
	object {Col1 translate <10,20,0>}
	object {Col1 translate <10,20,30>} 
	
	Height_Column (<10,20,6>,10,35,1)
	Height_Column (<10,20,12>,10,35,1)
	Height_Column (<10,20,18>,10,35,1)
	Height_Column (<10,20,24>,10,35,1)

	box {<-8,-30,0><8,55,30> texture{T_13Stone1}} 
	
	// the entablature
	object {union {E_Length (20,4,10)} translate <-10,55,0>}
	object {union {E_Length (30,4,10)} rotate <0,-90,0> translate <10,55,0>} 
	object {union {E_Base_ICC (0,1,10)} translate <-10,55,0>} 
	object {union {E_Base_ICC (0,1,10)} scale <-1,1,1> translate <10,55,0>}
	object {union {E_Base_ICC (0,1,10)} scale <-1,1,-1> translate <10,55,30>} 
	
	// infill box 
	box {<-10.75,61,-.75><10.75,67,30.75> texture{T_13Stone1}}   
	
	// top pediment
	object {union {Pediment (30,4,10)} rotate <0,-90,0> translate <10,67,0>}
	object {union {Pediment (30,4,10)} rotate <0,90,0> translate <-10,67,30>} 
	object {union {E_Length (20,4,10)} translate <-10,67,0>}  
	
	// BASE
	BOX (<-12,10,-2>,<12,20,32>,0,0,1,.5,0)   // CENTRE PILLAR 
	BOX (<-12.5,9.5,-2.5>,<12.5,10,32.5>,0,0,1,0,0)   // CENTRE PILLAR   
	BOX (<-13,7,-3>,<13,9.5,33>,0,0,1,0,0)   // CENTRE PILLAR   
	BOX (<-13.5,0,-3.5>,<13.5,7,33.5>,0,0,1,1,0)   // CENTRE PILLAR  
	
	// decorative panels
	object {Frame3 translate <0,30,0>}
	object {Frame2 translate <0,40,0>}
	object {Frame1 translate <0,50,0>} 
	object {Frieze translate <0,35,0>}  
	object {Frieze translate <0,45,0>}   
	
	// the weird feature
	object {Weird_Featue translate <2.5,64,-.75>}  
	object {Weird_Featue translate <7.5,64,-.75>}  
	object {Weird_Featue translate <-2.5,64,-.75>}  
	object {Weird_Featue translate <-7.5,64,-.75>}   
	
	object {Weird_Featue rotate <0,-90,0> translate <10.75,64,18.5>}  
	object {Weird_Featue rotate <0,-90,0> translate <10.75,64,25.5>}
	object {Weird_Featue rotate <0,-90,0> translate <10.75,64,11.5>}
	object {Weird_Featue rotate <0,-90,0> translate <10.75,64,4.5>}  
	
	// dec features
	object {Dec_Feature translate <9,73,2>}    
	object {Dec_Feature translate <-9,73,2>}  
	
}  

#declare CArch_Cut =
merge { 
	box {<-4,-1,-2><8.5,.75,2> texture{T_13Stone2}}
	box {<-3,1.1,-1.75><7.5,.5,1.75> texture{T_13Stone1}} 
	box {<-2,1,-1><6.5,1.5,1> texture{T_13Stone2}}
}

#declare CArch =  
union {
	difference { 
		box {<-5,-10,-35><9.5,100,35> texture{T_13Stone1}}
		cylinder {<20,70,0><-20,70,0>,20 texture{T_13Stone1}} 
		box {<20,-20,-20><-20,70,20> texture{T_13Stone1}} 
		
		#local Qty = 25;
		#local Count1 = 0;
		#while (Count1 < Qty)
			object {CArch_Cut translate <0,20,0> rotate <(Count1 * (360 / Qty)),0,0> translate <0,70,0>}
			#local Count1 = (Count1 + 1);
		#end
	}
	
	#local CA_Group =
	union {
		object {union {E_Length (14.5,4,10)} translate <-5,55,21>}
		object {union {E_Base_ICC (0,1,10)} translate <-5,55,21>} 
		object {union {E_Base_ICC (0,1,10)} scale <-1,1,1> translate <9.5,55,21>}   
	
		object {union {E_Length (14.5,4,10)} translate <-5,67,21>} 
		object {union {E_Base_ICC (0,1,10)} translate <-5,67,21>} 
		object {union {E_Base_ICC (0,1,10)} scale <-1,1,1> translate <9.5,67,21>} 
	
		object {union {E_Length (8,4,10)} rotate <0,-90,0> translate <9.5,55,21>}  
		object {union {E_Length (8,4,10)} rotate <0,-90,0> translate <9.5,67,21>} 
	}
	object {CA_Group} 
	object {CA_Group scale <1,1,-1>}
	
	object {Col2 translate <9.5,70,35>}  
	object {Col2 translate <9.5,70,-35>}
	object {Col2 translate <-5,70,-35>}  
	
	object {union {E_Length (70,4,10)} rotate <0,-90,0> translate <9.5,100,-35>}  
	object {union {E_Base_ICC (0,1,10)} scale <-1,1,-1> translate <9.5,100,35>}  
	
	object {union {E_Arch_One (<0,0,0>,19.8,10)} rotate <0,-90,0> translate <9.5,70,0>} 
	
	difference {   
		union {
	    	cylinder {<9,70,0><10,70,0>,28 texture{T_Centre_Arch translate <0,70,0>}}
	    	cylinder {<9,70,0><11,70,0>,26 texture{T_Centre_Arch translate <0,70,0>}} 
	    } 
	    cylinder {<20,70,0><-20,70,0>,23.5 texture{T_Centre_Arch translate <0,70,0>}} 
	    box {<200,70,200><-200,-200,-200> texture{T_Centre_Arch translate <0,70,0>}}
	}
} 

#declare Central_Arch =
union {
	object {CBuilding}
	object {CBuilding translate <0,0,90>}  
	
	object {CArch translate <0,0,60>}
}

