// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 3.1
// Desc: stairs
// Date: feb 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 
                                           
// LOWER STEPS TO THE RIGHT OF THE BRIDGES
#declare Steps_Length = 100;
#declare Steps_Depth = -5;

#local Steps = 20;
#local Count1 = 0;

#local Startx = 8;
#local Starty = 0;
#local Riser = .25;
#local Runner = .75;

#while (Count1 < Steps)
	#local Endx = (Startx + Runner);
	#local Pont1 = <Startx,Starty,-13>;
	#local Pont2 = <Endx,Steps_Depth,Steps_Length>;
	
	BOX (Pont1,Pont2,0,0,1,.5,0) 
	
	#local Starty = (Starty - Riser);
	#local Startx = Endx;
	#local Count1 = (Count1 + 1);
#end  

// STAIRS UNDER THE FIRST ARCH. 
	#local Step1 = union {BOX (<-8,0,13>,<-27,-.25,12.25>,0,0,1,0,0)}
	#local Count1 = 0;
	#local Qty = 20;
	#while (Count1 < Qty)
		object {Step1 translate <0,(Count1 * -.25),(Count1 * -.75)>}
		#local Count1 = (Count1 + 1);
	#end   
	
// stairs behind arch
	#local Step2 = union {BOX(<-27,0,13>,<-27.75,.25,46.5>,0,0,1,0,0)}
	#local Count1 = 0;
	#local Qty = 20;
	#while (Count1 < Qty)
		object {Step2 translate <(Count1 * -.75),(Count1 * .25),0>}
		#local Count1 = (Count1 + 1);
	#end 
	
// stairs in front of end wall	

	#local Step3 = union {BOX(<-44,0,-12>,<-43.25,-.25,-30>,0,0,1,0,0)}
	#local Count1 = 0;
	#local Qty = 20;
	#while (Count1 < Qty)
		object {Step3 translate <(Count1 * .75),(Count1 * -.25),0>}
		#local Count1 = (Count1 + 1);
	#end 	

                                           
// eof