// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Custom BOX macro set
// Date: Jan 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998

#include "T_13box.inc"

// ADVANCED TEXTURE FUNCTION
// AGE 1 = NEW RENDER
// AGE 0 = BRICKS ONLY
#macro BX_TEXTURE (Age,Rtype,Cvalue,Yc1,Yc2)

	#if (Age = 1)				// BRAND NEW
		Render1 (Cvalue)
	#end
	#if (Age = 0)				// VERY OLD
		#if (Rtype = 0)
			texture{Bricks4}
		#else
			texture{Bricks4 rotate <0,90,0>}
		#end
	#end
	#if (Age <= .33)
		#if (Age > 0)			// OLD
			#if (Rtype = 0)
				Bricks7 (.5,.2,1,0)
			#else
				Bricks7 (.5,.2,1,1)
			#end
		#end
	#end
	#if (Age >= .66)
		#if (Age < 1)			// NEW
			Render2 (Cvalue)
			#if (Rtype = 0)
				Render4 (.7,.15,1,0)
			#else
				Render4 (.7,.15,1,1)
			#end
		#end
	#end 
	#if (Age > .33)				// MIDDLE AGE
		#if (Age < .66)
		Render2 (Cvalue)
		Combined1 (.5,.2,1,0)
		Combined3 (.7,.15,1,1)
		#if (Yc1 < Yc2)
			#local Ymax = Yc2; #local Ymin = Yc1;
		#else
			#local Ymax = Yc1; #local Ymin = Yc2;
		#end
		#local Ydist = (Ymax - Ymin);
		#if (Rtype = 0)
			Combined5 (Ydist,Ymin,0)
		#else
			Combined5 (Ydist,Ymin,1)
		#end
		#end
	#end
			

#end

// STANDARD MASONRY BOX
#macro BOX (Point1,Point2,Corner,Capping,Size,Age,Cvalue)

	#local Px1 = Point1.x;
	#local Py1 = Point1.y;
	#local Pz1 = Point1.z;
	#local Px2 = Point2.x;
	#local Py2 = Point2.y;
	#local Pz2 = Point2.z;
	
	#local Np1 = <Px1,Py1,Pz1>;
	#local Np2 = <Px1,Py2,Pz1>;
	#local Np3 = <Px2,Py2,Pz1>;
	#local Np4 = <Px2,Py1,Pz1>;
	#local Np11 = <Px1,Py1,Pz2>;
	#local Np12 = <Px1,Py2,Pz2>;
	#local Np13 = <Px2,Py2,Pz2>;
	#local Np14 = <Px2,Py1,Pz2>;
	
	polygon {5,Np1,Np2,Np3,Np4,Np1 BX_TEXTURE (Age,0,Cvalue,Py1,Py2)}
	polygon {5,Np11,Np12,Np13,Np14,Np11 BX_TEXTURE (Age,0,Cvalue,Py1,Py2)}
	
	polygon {5,Np1,Np2,Np12,Np11,Np1 BX_TEXTURE (Age,1,Cvalue,Py1,Py2)}
	polygon {5,Np3,Np4,Np14,Np13,Np3 BX_TEXTURE (Age,1,Cvalue,Py1,Py2)} 
	
	#if (Capping = 0)		// SIMPLE CAPPING. HIGHER VALUES USE ENTABLATURES
		#local Hminus = .1;
		#if (Px1 < Px2)
			#local Cpx1 = (Px1 - .05); #local Cpx2 = (Px2 + .05);
		#else
			#local Cpx1 = (Px1 + .05); #local Cpx2 = (Px2 - .05);
		#end
		#if (Pz1 < Pz2)
			#local Cpz1 = (Pz1 - .05); #local Cpz2 = (Pz2 + .05);
		#else
			#local Cpz1 = (Pz1 + .05); #local Cpz2 = (Pz2 - .05);
		#end
		#if (Py1 < Py2)
			#local Cpy1 = (Py2 - Hminus); #local Cpy2 = (Py2 + .01);
		#else
			#local Cpy1 = (Py1 - Hminus); #local Cpy2 = (Py1 + .01);
		#end
		box {<Cpx1,Cpy1,Cpz1><Cpx2,Cpy2,Cpz2> texture{T_Boxcap}}	
	#end 
	
	#if (Capping > 0)
	
		#local Hminus = (.6 * Size);
		#if (Px1 < Px2)
			#local Xmax = Px2; #local Xmin = Px1;
		#else
			#local Xmax = Px1; #local Xmin = Px2;
		#end
		#if (Py1 < Py2)
			#local Ymax = Py2; #local Ymin = Py1;
		#else
			#local Ymax = Py1; #local Ymin = Py2;
		#end
		#if (Pz1 < Pz2)
			#local Zmax = Pz2; #local Zmin = Pz1;
		#else
			#local Zmax = Pz1; #local Zmin = Pz2;
		#end
		
		#local Length1 = (Xmax - Xmin);
		#local Length2 = (Zmax - Zmin);
		
		#local Entab_Set1 = union {E_Length (Length1,Capping,Size)}
		#local Entab_Set2 = union {E_Length (Length2,Capping,Size)}
		#if (Capping < 3)
			#local Entab_Set3 = union {E_Base_TD (0,1,Size)}
		#else
			#local Entab_Set3 = union {E_Base_ICC (0,1,Size)}
		#end
		
		#local Entab_Set4 =
		union {
			object {Entab_Set1 translate <Xmin,0,Zmin>}
			object {Entab_Set1 rotate <0,180,0> translate <Xmax,0,Zmax>}
			
			object {Entab_Set2 rotate <0,-90,0> translate <Xmax,0,Zmin>}
			object {Entab_Set2 rotate <0,90,0> translate <Xmin,0,Zmax>} 
			
			object {Entab_Set3 translate <Xmin,0,Zmin>}
			object {Entab_Set3 scale <-1,1,1> translate <Xmax,0,Zmin>} 
			
			object {Entab_Set3 scale <1,1,-1> translate <Xmin,0,Zmax>}
			object {Entab_Set3 scale <-1,1,-1> translate <Xmax,0,Zmin>}
		}  
		
		object {Entab_Set4 translate <0,(Ymax - Hminus),0>}
	#end
         
	// corner stones
	#if (Corner = 1)
		#if (Py1 < Py2)
			#local Ymax = Py2; #local Ymin = Py1;
		#else
			#local Ymax = Py1; #local Ymin = Py2;
		#end
		#local BX_Height = (Ymax - Ymin - Hminus);
		#local BX_Cheight = .3;
		#local Qty = int(BX_Height / BX_Cheight);
		#local BX_Cheight2 = (BX_Height / Qty);
		
		#if (Px1 < Px2)
			#local Xmax = Px2; #local Xmin = Px1;
		#else
			#local Xmax = Px1; #local Xmin = Px2;
		#end
		#if (Pz1 < Pz2)
			#local Zmax = Pz2; #local Zmin = Pz1;
		#else
			#local Zmax = Pz1; #local Zmin = Pz2;
		#end   
		
		#local BX_Ctemplate =
		difference {
			box {<-.35,0,-.05><.35,BX_Cheight2,BX_Cheight2>}
			
			box {<-5,-5,-5><5,5,0> rotate <45,0,0> translate <0,(BX_Cheight2 - .05),-.05>} 
			box {<-5,-5,-5><5,5,0> rotate <-45,0,0> translate <0,.05,-.05>} 
			
			box {<-5,-5,-5><5,5,0> rotate <0,45,0> translate <-.3,0,-.05>}
			box {<-5,-5,-5><5,5,0> rotate <0,-45,0> translate <.3,0,-.05>} 
			
			box {<0,-5,-5><5,5,5> rotate <0,0,45> translate <.35,(BX_Cheight2 - .05),0>}
			box {<0,-5,-5><5,5,5> rotate <0,0,-45> translate <.35,.05,0>}  
			box {<0,-5,-5><5,5,5> rotate <0,-45,0> translate <.35,0,(BX_Cheight2 - .05)>}
			
			box {<0,-5,-5><-5,5,5> rotate <0,0,-45> translate <-.35,(BX_Cheight2 - .05),0>}
			box {<0,-5,-5><-5,5,5> rotate <0,0,45> translate <-.35,.05,0>}  
			box {<0,-5,-5><-5,5,5> rotate <0,45,0> translate <-.35,0,(BX_Cheight2 - .05)>}
		}
		

		#local BX_C1r = object {BX_Ctemplate translate <.3,0,0>}
		#local BX_C1l = object {BX_Ctemplate translate <-.3,0,0>}
		#local BX_C2r = object {BX_Ctemplate rotate <0,180,0> translate <.3,0,0>}
		#local BX_C2l = object {BX_Ctemplate rotate <0,180,0> translate <-.3,0,0>}
		
		#local BX_C3u = object {BX_Ctemplate rotate <0,90,0> translate <0,0,.3>}
		#local BX_C3d = object {BX_Ctemplate rotate <0,90,0> translate <0,0,-.3>}
		#local BX_C4u = object {BX_Ctemplate rotate <0,-90,0> translate <0,0,.3>}
		#local BX_C4d = object {BX_Ctemplate rotate <0,-90,0> translate <0,0,-.3>}
		
		#local Count1 = 0;  
		#local Marker1 = 0;
		#while (Count1 < Qty)     
			
			#if (Marker1 = 0)
				object {BX_C1r translate <Xmin,((Count1 * BX_Cheight2) + Ymin),Zmin> texture{T_BXCstone}}
				object {BX_C1l translate <Xmax,((Count1 * BX_Cheight2) + Ymin),Zmin> texture{T_BXCstone}} 
				
				object {BX_C2r translate <Xmin,((Count1 * BX_Cheight2) + Ymin),Zmax> texture{T_BXCstone}}
				object {BX_C2l translate <Xmax,((Count1 * BX_Cheight2) + Ymin),Zmax> texture{T_BXCstone}}
			#else
				object {BX_C3u translate <Xmin,((Count1 * BX_Cheight2) + Ymin),Zmin> texture{T_BXCstone translate <10,0,10>}}
				object {BX_C3d translate <Xmin,((Count1 * BX_Cheight2) + Ymin),Zmax> texture{T_BXCstone translate <10,0,10>}}
				
				object {BX_C4u translate <Xmax,((Count1 * BX_Cheight2) + Ymin),Zmin> texture{T_BXCstone translate <10,0,10>}}
				object {BX_C4d translate <Xmax,((Count1 * BX_Cheight2) + Ymin),Zmax> texture{T_BXCstone translate <10,0,10>}}
			#end
			
			#if (Marker1 = 0) #local Marker1 = 1; #else #local Marker1 = 0; #end
			#local Count1 = (Count1 + 1);
		#end		
	#end         
         
#end 

