#include "t_13col3.inc"

#macro Col_Base_1 (Origin,Size)

box {((<-0.225,0,-0.225> * Size)+ Origin)((<0.225,0.075,0.225> * Size) + Origin) texture{T_Column8}}
cylinder {((<0,0.075,0> * Size) + Origin)((<0,0.125,0> * Size) + Origin),(0.2  * Size) texture{T_Column7}}
torus {(0.2 * Size),(0.025 * Size) sturm translate ((<0,0.1,0> * Size) + Origin) texture{T_Column7}}
difference {
    cylinder {((<0,0.125,0> * Size) + Origin)((<0,0.175,0> * Size) + Origin),(0.175 * Size) texture{T_Column7}}
    torus {(0.175 * Size),(0.025 * Size) sturm translate ((<0,0.175,0>  * Size) + Origin) texture{T_Column7}}
}
	
#end

#macro Col_Base_2 (Origin,Size)

box {((<-0.225,0,-0.225> * Size) + Origin)((<0.225,0.05,0.225> * Size) + Origin) texture{T_Column8}}
cylinder {((<0,0.05,0> * Size) + Origin)((<0,0.09,0> * Size) + Origin),(0.2 * Size) texture{T_Column7}}
torus {(0.2 * Size),(0.015 * Size) sturm translate ((<0,0.065,0> * Size) + Origin) texture{T_Column7}}
difference {
    cylinder {((<0,0.09,0> * Size) + Origin)((<0,0.14,0> * Size) + Origin),(0.18 * Size) texture{T_Column7}}
    torus {(0.18 * Size),(0.01 * Size) sturm translate ((<0,0.1,0> * Size) + Origin) texture{T_Column7}}
}
torus {(0.18 * Size),(0.01 * Size) sturm translate ((<0,0.13,0> * Size) + Origin) texture{T_Column7}}
difference {
    cylinder {((<0,0.14,0> * Size) + Origin)((<0,0.17,0> * Size) + Origin),(0.17 * Size) texture{T_Column7}}
    torus {(0.17 * Size),(0.02 * Size) sturm translate ((<0,0.17,0> * Size) + Origin) texture{T_Column7}}
}

#end

#macro Col_Horn (Scale,Origin,Size)

difference {
    box {(((<0,0.045,0> * Scale) * Size) + Origin)(((<0.175,0.075,-0.02> * Scale) * Size) + Origin) texture{T_Column4}}
    cylinder {(((<-1,0.06,-0.02> * Scale) * Size) + Origin)(((<1,0.06,-0.02> * Scale) * Size) + Origin),(0.01 * Size) texture{T_Column3}}
}
difference {
    cylinder {(((<0.175,0,0> * Scale) * Size) + Origin)(((<0.175,0,-0.02> * Scale) * Size) + Origin),(0.075 * Size) texture{T_Column4}}
    box {(((<0,-0.1,1> * Scale) * Size) + Origin)(((<0.175,0.1,-1> * Scale) * Size) + Origin) texture{T_Column4}}
    torus {(0.06 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,0,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
    torus {(0.03 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,0,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
    sphere {(((<0.175,0,-0.02> * Scale) * Size) + Origin),(0.01 * Size) texture{T_Column3}}
}
difference {
    cylinder {(((<0.175,-0.015,0> * Scale) * Size) + Origin)(((<0.175,-0.015,-0.02> * Scale) * Size) + Origin),(0.06 * Size) texture{T_Column4}}
    box {(((<0.175,-0.1,1> * Scale) * Size) + Origin)(((<1,1,-1> * Scale) * Size) + Origin) texture{T_Column4}}
    torus {(0.045 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,-0.015,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
    torus {(0.015 * Size),(0.01 * Size) sturm rotate <90,0,0> translate (((<0.175,-0.015,-0.02> * Scale) * Size) + Origin) texture{T_Column3}}
}

#end

#macro Col_Leaf (Type,Size)

	#declare Col_Leaf1 =
	union {
		box {(<-0.03,-0.1,0> * Size)(<0.03,0.115,-0.01> * Size)}
		difference {
		    cylinder {(<-0.03,0.115,-0.025> * Size)(<0.03,0.115,-0.025> * Size),(0.025 * Size)}
		    cylinder {(<-1,0.115,-0.025> * Size)(<1,0.115,-0.025> * Size),(0.015 * Size)}
		    box {(<1,0.115,1> * Size)(<-1,-1,-1> * Size)}
		}
		intersection {
		    box {(<-0.03,0.085,-0.04> * Size)(<0.03,0.115,-0.05> * Size)}
		    cylinder {(<0,0.115,1> * Size)(<0,0.115,-1> * Size),(0.03 * Size)}
		}
	}

#if (Type = 1)
	#declare Col_Leaf2 = object {Col_Leaf1 texture{T_Column4}}
#else	
    #declare Col_Leaf2 =
	union {
		object {Col_Leaf1 scale <.6,1,1> texture{T_Column4}}
		object {Col_Leaf1 scale <.6,.8,1> rotate <0,-5,-10> translate (<.005,.015,.002> * Size) texture{T_Column4a}}
		object {Col_Leaf1 scale <.6,.8,1> rotate <0,5,10> translate (<-.005,.015,.002> * Size) texture{T_Column4a}}
		object {Col_Leaf1 scale .6 rotate <0,-10,-20> translate (<.01,.02,.002> * Size) texture{T_Column4}}
		object {Col_Leaf1 scale .6 rotate <0,10,20> translate (<-.01,.02,.002> * Size) texture{T_Column4}}
	}

#end

#end

#macro Col_Capital_1 (Origin,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.025,0> * Size) + Origin),(0.165 * Size) texture{T_Column4}}
cylinder {((<0,0.025,0> * Size) + Origin)((<0,0.075,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
cylinder {((<0,0.075,0> * Size) + Origin)((<0,0.1,0> * Size) + Origin),(0.165 * Size) texture{T_Column4}}
torus {(0.15 * Size),(0.025 * Size) sturm translate ((<0,0.125,0> * Size) + Origin) texture{T_Column4}}
box {((<-0.19,0.125,-0.19> * Size) + Origin)((<0.19,0.175,0.19> * Size) + Origin) texture{T_Column5}}

#end

#macro Col_Capital_2 (Origin,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.01,0> * Size) + Origin),(0.16 * Size) texture{T_Column4}}
cylinder {((<0,0.01,0> * Size) + Origin)((<0,0.045,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
box {((<-0.175,0.075,-0.175> * Size) + Origin)((<0.175,0.1,0.175> * Size) + Origin) texture{T_Column5}}
#local Count = 0;
#while (Count < 24)
	sphere {(<0,0.025,0.14> * Size),(0.015 * Size) rotate <0,(Count * 15),0> translate Origin texture{T_Column4}}
	#local Count = (Count + 1);
#end

#local HGroup =
union {
Col_Horn (<1,1,1>,(<0,0,-0.16> * Size),Size)
Col_Horn (<-1,1,1>,(<0,0,-0.16> * Size),Size)
Col_Horn (<1,1,-1>,(<0,0,0.16> * Size),Size)
Col_Horn (<-1,1,-1>,(<0,0,0.16> * Size),Size)
}

object {HGroup translate Origin }

// PROBLEM INFILL

#local Col_Infill =
union {
	difference {
		cylinder {(<0.175,0,-0.16> * Size)(<0.175,0,0.16> * Size),(0.075 * Size) texture{T_Column4}}
		box {(<-10,-10,-10> * Size)(<0.175,10,10> * Size) texture{T_Column4}}
	}
	difference {
		cylinder {(<0.175,-0.015,-0.16> * Size)(<0.175,-0.015,0.16> * Size),(0.06 * Size) texture{T_Column4}}
		box {(<0.175,-10,-10> * Size)(<10,10,10> * Size) texture{T_Column4}}
	}
}

object {Col_Infill translate Origin }
object {Col_Infill scale <-1,1,1> translate Origin }



#end

#macro Col_Capital_2r (Origin,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.01,0> * Size) + Origin),(0.16 * Size) texture{T_Column4}}
cylinder {((<0,0.01,0> * Size) + Origin)((<0,0.045,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
box {((<-0.175,0.075,-0.175> * Size) + Origin)((<0.175,0.1,0.175> * Size) + Origin) texture{T_Column5}}
#local Count = 0;
#while (Count < 24)
	sphere {(<0,0.025,0.14> * Size),(0.015 * Size) rotate <0,(Count * 15),0> translate Origin texture{T_Column4}}
	#local Count = (Count + 1);
#end

#local HGroup =
union {
Col_Horn (<1,1,1>,(<0,0,-0.16> * Size),Size)
Col_Horn (<-1,1,1>,(<0,0,-0.16> * Size),Size)
Col_Horn (<1,1,-1>,(<0,0,0.16> * Size),Size)
Col_Horn (<-1,1,-1>,(<0,0,0.16> * Size),Size)
}

object {HGroup rotate <0,90,0> translate Origin }

#local Col_Infill =
union {
	difference {
		cylinder {(<0.175,0,-0.16> * Size)(<0.175,0,0.16> * Size),(0.075 * Size) texture{T_Column4}}
		box {(<-10,-10,-10> * Size)(<0.175,10,10> * Size) texture{T_Column4}}
	}
	difference {
		cylinder {(<0.175,-0.015,-0.16> * Size)(<0.175,-0.015,0.16> * Size),(0.06 * Size) texture{T_Column4}}
		box {(<0.175,-10,-10> * Size)(<10,10,10> * Size) texture{T_Column4}}
	}
}

object {Col_Infill rotate <0,90,0> translate Origin }
object {Col_Infill scale <-1,1,1> rotate <0,90,0> translate Origin }


#end


#macro Col_Capital_3 (Origin,Detail,Size)

cylinder {((<0,0,0> * Size) + Origin)((<0,0.015,0> * Size) + Origin),(0.165 * Size) texture{T_Column4}}
cylinder {((<0,0.015,0> * Size) + Origin)((<0,0.15,0> * Size) + Origin),(0.15 * Size) texture{T_Column3}}
cone {((<0,0.15,0> * Size) + Origin),(0.15 * Size),((<0,0.35,0> * Size) + Origin),(0.2 * Size) texture{T_Column3}}

Col_Leaf (Detail,Size)

#local Count = 0;
#while (Count < 10)
	object {Col_Leaf2 rotate <-7,0,0> translate (<0,0,-0.14> * Size) rotate <0,(Count * 36),0> clipped_by {plane {-y,0}} translate Origin }
	#local Count = (Count + 1);
#end

#local Count = 0;
#while (Count < 10)
	object {Col_Leaf2 rotate <-17,0,0> translate (<0,0.1,-0.14> * Size) rotate <0,((Count * 36) + 18),0> translate Origin }
	#local Count = (Count + 1);
#end

#local Count = 0;
#while (Count < 15)
	object {Col_Leaf2 rotate <-22,0,0> translate (<0,0.22,-0.16> * Size) rotate <0,(Count * 24),0> translate Origin }
	#local Count = (Count + 1);
#end

#local Col_Cut1 =
union {
   	box {(<-0.15,-1,-0.15> * Size)(<0.15,0.36,0.15> * Size) texture{T_Column5}}
   	box {(<-0.14,0.36,-0.14> * Size)(<0.14,0.375,0.14> * Size) texture{T_Column5}}
   	box {(<-0.13,0,-0.13> * Size)(<0.13,0.5,0.13> * Size) texture{T_Column5}}
}

#local Col_Cut2 =
union {
   	object {Col_Cut1 rotate <0,45,0> translate (<0.318,0,0.318> * Size) texture{T_Column5}}
   	cylinder {(<0,-1,0.528> * Size)(<0,0.36,0.528> * Size),(0.319 * Size) texture{T_Column5}}
   	cylinder {(<0,0.36,0.528> * Size)(<0,0.375,0.528> * Size),(0.309 * Size) texture{T_Column5}}
   	cylinder {(<0,-1,0.528> * Size)(<0,0.5,0.528> * Size),(0.299 * Size) texture{T_Column5}}
}

difference {
    box {((<-0.275,0.35,-0.275> * Size) + Origin)((<0.275,0.4,0.275> * Size) + Origin) texture{T_Column5}}
   	object {Col_Cut2 translate Origin }
   	object {Col_Cut2 rotate <0,90,0> translate Origin }
   	object {Col_Cut2 rotate <0,180,0> translate Origin }
   	object {Col_Cut2 rotate <0,-90,0> translate Origin }
}

#local Col_Flower =
union {
	sphere {(<0,0,0> * Size),(.04 * Size) texture{T_Column6}}
	sphere {(<0.015,0,0> * Size),(.03 * Size) texture{T_Column6}}
	sphere {(<0.03,0,0> * Size),(.03 * Size) texture{T_Column6}}
	sphere {(<-0.015,0,0> * Size),(.03 * Size) texture{T_Column6}}
	sphere {(<-0.03,0,0> * Size),(.03 * Size) texture{T_Column6}}
}

object {Col_Flower translate ((<0,0.385,-.21> * Size) + Origin)}
object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,90,0> translate Origin }
object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,180,0> translate Origin }
object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,-90,0> translate Origin }

#end

#macro Col_Capital_4 (Origin,Detail,Size)

Col_Capital_3 (Origin,Detail,Size)

#local Col_Add1 =
union {
	Col_Horn (<1,1,1>,(<.08,0.28,0> * Size),Size)
	Col_Horn (<1,1,-1>,(<.08,0.28,0> * Size),Size)
}

object {Col_Add1 rotate <0,45,0> translate Origin }
object {Col_Add1 rotate <0,135,0> translate Origin }
object {Col_Add1 rotate <0,-45,0> translate Origin }
object {Col_Add1 rotate <0,-135,0> translate Origin }

torus {(.18 * Size),(.02 * Size) sturm translate ((<0,.3,0> * Size) + Origin) texture{T_Column4}}

#end

#macro Col_Shaft (Origin,Height,Fluting,Quantity,Size)

#if (Fluting = 0)
	cylinder {(<0,0,0> + Origin)(<0,Height,0> + Origin),(0.15 * Size) texture{T_Column1}}
#end

#if (Fluting > 0)
	difference {
		cylinder {(<0,0,0> + Origin)(<0,Height,0> + Origin),(0.15 * Size) texture{T_Column1}}
		#local Count1 = 0;
		#while (Count1 < Quantity)
			sphere {<(0.15 * Size),(0.05 * Size),0>,(0.025 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column2}}
			sphere {<(0.15 * Size),(Height - (0.05 * Size)),0>,(0.025 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column2}}
			cylinder {<(0.15 * Size),(0.05 * Size),0><(0.15 * Size),(Height - (0.05 * Size)),0>,(0.025 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column2}}
			#local Count1 = (Count1 + 1);
		#end
	}
#end

#if (Fluting = 2)
	#local Count1 = 0;
	#while (Count1 < Quantity)
		sphere {<(0.12 * Size),0.05,0>,(0.02 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column1}}
		sphere {<(0.12 * Size),(Height * 0.33),0>,(0.02 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column1}}
		cylinder {<(0.12 * Size),0.05,0><(0.12 * Size),(Height * 0.33),0>,(0.02 * Size) rotate <0,(Count1 * (360 / Quantity)),0> translate Origin texture{T_Column1}}
		#local Count1 = (Count1 + 1);
	#end

#end

#end

#macro Generic_Column (Origin,Height,Fluting,Quantity,Base,Capital,Leaf,Size)

#if (Base = 1) Col_Base_1 (Origin,Size) #local Origin2 = (<0,0.175,0> * Size); #local H_Minus1 = (0.175 * Size); #end
#if (Base = 2) Col_Base_2 (Origin,Size) #local Origin2 = (<0,0.17,0> * Size); #local H_Minus1 = (0.17 * Size); #end

#if (Capital = 1) Col_Capital_1 ((<0,(Height - (0.175 * Size)),0> + Origin),Size) #local H_Minus2 = (0.175 * Size); #end
#if (Capital = 2) Col_Capital_2 ((<0,(Height - (0.1 * Size)),0> + Origin),Size) #local H_Minus2 = (0.1 * Size); #end
#if (Capital = 3) Col_Capital_3 ((<0,(Height - (0.4 * Size)),0> + Origin),Leaf,Size) #local H_Minus2 = (0.4 * Size); #end
#if (Capital = 4) Col_Capital_4 ((<0,(Height - (0.4 * Size)),0> + Origin),Leaf,Size) #local H_Minus2 = (0.4 * Size); #end  

#if (Capital = 5) Col_Capital_2r ((<0,(Height - 0.1),0> + Origin),Size) #local H_Minus2 = (0.1 * Size); #end

Col_Shaft ((Origin + Origin2),(Height - H_Minus1 - H_Minus2),Fluting,Quantity,Size)

#end

#macro Classic_Column (Origin,Style,Size)   

#if (Style = 1) #local NH = (2.2 * Size); #end  
#if (Style = 2) #local NH = (2.4 * Size); #end
#if (Style = 3) #local NH = (2.6 * Size); #end
#if (Style = 31) #local NH = (2.6 * Size); #end
#if (Style = 4) #local NH = (2.8 * Size); #end
#if (Style = 5) #local NH = (3.2 * Size); #end

#if (Style = 1) Generic_Column (Origin,NH,0,0,1,1,1,Size) #end
#if (Style = 2) Generic_Column (Origin,NH,1,12,2,1,1,Size) #end
#if (Style = 3) Generic_Column (Origin,NH,1,15,2,2,1,Size) #end 
#if (Style = 31) Generic_Column (Origin,NH,1,15,2,5,1,Size) #end   // Special Ionic with capital rotate 90 degrees
#if (Style = 4) Generic_Column (Origin,NH,1,18,2,3,1,Size) #end
#if (Style = 5) Generic_Column (Origin,NH,2,18,2,4,2,Size) #end

#end

// SQUARE COLUMN DEFINITIONS

// SQUARE BASE 1

#macro S_Col_Base_1 (Origin,Size)

	box {((<-.225,0,-.225> * Size) + Origin)((<.225,.075,.225> * Size) + Origin) texture{T_Column8}} 
	box {((<-.2,.075,-.2> * Size) + Origin)((<.2,.125,.2> * Size) + Origin) texture{T_Column7}}
	box {((<-.175,.125,-.175> * Size) + Origin)((<.175,.15,.175> * Size) + Origin) texture{T_Column7}}
	
	difference {      
	
		box {((<-.175,.15,-.175> * Size) + Origin)((<.175,.175,.175> * Size) + Origin) texture{T_Column7}}
		
		cylinder {((<-.175,.175,-.3> * Size) + Origin)((<-.175,.175,.3> * Size) + Origin),(.025 * Size) texture{T_Column7}}
		cylinder {((<.175,.175,-.3> * Size) + Origin)((<.175,.175,.3> * Size) + Origin),(.025 * Size) texture{T_Column7}}
		cylinder {((<.3,.175,.175> * Size) + Origin)((<-.3,.175,.175> * Size) + Origin),(.025 * Size) texture{T_Column7}}
		cylinder {((<.3,.175,-.175> * Size) + Origin)((<-.3,.175,-.175> * Size) + Origin),(.025 * Size) texture{T_Column7}}
	
	} 
	
	cylinder {((<-.2,.1,-.2> * Size) + Origin)((<-.2,.1,.2> * Size) + Origin),(.025 * Size) texture{T_Column7}}
	cylinder {((<-.2,.1,-.2> * Size) + Origin)((<.2,.1,-.2> * Size) + Origin),(.025 * Size) texture{T_Column7}}
	cylinder {((<.2,.1,.2> * Size) + Origin)((<-.2,.1,.2> * Size) + Origin),(.025 * Size) texture{T_Column7}}
	cylinder {((<.2,.1,.2> * Size) + Origin)((<.2,.1,-.2> * Size) + Origin),(.025 * Size) texture{T_Column7}}  
	
	intersection {  
		union {
		
			cylinder {((<-.2,.1,-.3> * Size) + Origin)((<-.2,.1,.3> * Size) + Origin),(.025 * Size) texture{T_Column7}}
			cylinder {((<.2,.1,.3> * Size) + Origin)((<.2,.1,-.3> * Size) + Origin),(.025 * Size) texture{T_Column7}}
			
		}
		union {
		
			cylinder {((<.3,.1,.2> * Size) + Origin)((<-.3,.1,.2> * Size) + Origin),(.025 * Size) texture{T_Column7}}	
			cylinder {((<-.3,.1,-.2> * Size) + Origin)((<.3,.1,-.2> * Size) + Origin),(.025 * Size) texture{T_Column7}}
			
		}  
	
	}
	
#end

// SQUARE BASE 2

#macro S_Col_Base_2 (Origin,Size)
    
    box {((<-.225,0,-.225> * Size) + Origin)((<.225,.05,.225> * Size) + Origin) texture{T_Column8}}
    
    box {((<-.2,.05,-.2> * Size) + Origin)((<.2,.09,.2> * Size) + Origin) texture{T_Column7}}

	difference {
	    
    	box {((<-.18,.09,-.18> * Size) + Origin)((<.18,.14,.18> * Size) + Origin) texture{T_Column7}}
    	
    	cylinder {((<-.18,.1,-.2> * Size) + Origin)((<-.18,.1,.2> * Size) + Origin),(.01 * Size) texture{T_Column7}}
    	cylinder {((<-.2,.1,-.18> * Size) + Origin)((<.2,.1,-.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}
    	cylinder {((<.18,.1,-.2> * Size) + Origin)((<.18,.1,.2> * Size) + Origin),(.01 * Size) texture{T_Column7}}
    	cylinder {((<-.2,.1,.18> * Size) + Origin)((<.2,.1,.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}
    	
    }
    
    difference {
    
    	box {((<-.17,.14,-.17> * Size) + Origin)((<.17,.17,.17> * Size) + Origin) texture{T_Column7}} 
    	
    	cylinder {((<-.17,.17,-.2> * Size) + Origin)((<-.17,.17,.2> * Size) + Origin),(.02 * Size) texture{T_Column7}}
    	cylinder {((<-.2,.17,-.17> * Size) + Origin)((<.2,.17,-.17> * Size) + Origin),(.02 * Size) texture{T_Column7}}
    	cylinder {((<.17,.17,-.2> * Size) + Origin)((<.17,.17,.2> * Size) + Origin),(.02 * Size) texture{T_Column7}}
    	cylinder {((<-.2,.17,.17> * Size) + Origin)((<.2,.17,.17> * Size) + Origin),(.02 * Size) texture{T_Column7}}
    	
    }

	cylinder {((<-.2,.065,-.2> * Size) + Origin)((<-.2,.065,.2> * Size) + Origin),(.015 * Size) texture{T_Column7}}
	cylinder {((<-.2,.065,-.2> * Size) + Origin)((<.2,.065,-.2> * Size) + Origin),(.015 * Size) texture{T_Column7}}
	cylinder {((<.2,.065,.2> * Size) + Origin)((<-.2,.065,.2> * Size) + Origin),(.015 * Size) texture{T_Column7}}
	cylinder {((<.2,.065,.2> * Size) + Origin)((<.2,.065,-.2> * Size) + Origin),(.015 * Size) texture{T_Column7}}  
	
	intersection {  
		union {
		
			cylinder {((<-.2,.065,-.3> * Size) + Origin)((<-.2,.065,.3> * Size) + Origin),(.015 * Size) texture{T_Column7}}
			cylinder {((<.2,.065,.3> * Size) + Origin)((<.2,.065,-.3> * Size) + Origin),(.015 * Size) texture{T_Column7}}
			
		}
		union {
		
			cylinder {((<.3,.065,.2> * Size) + Origin)((<-.3,.065,.2> * Size) + Origin),(.015 * Size) texture{T_Column7}}	
			cylinder {((<-.3,.065,-.2> * Size) + Origin)((<.3,.065,-.2> * Size) + Origin),(.015 * Size) texture{T_Column7}}
			
		}  
	
	}

	cylinder {((<-.18,.13,-.18> * Size) + Origin)((<-.18,.13,.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}
	cylinder {((<-.18,.13,-.18> * Size) + Origin)((<.18,.13,-.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}
	cylinder {((<.18,.13,.18> * Size) + Origin)((<-.18,.13,.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}
	cylinder {((<.18,.13,.18> * Size) + Origin)((<.18,.13,-.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}  
	
	intersection {  
		union {
		
			cylinder {((<-.18,.13,-.3> * Size) + Origin)((<-.18,.13,.3> * Size) + Origin),(.01 * Size) texture{T_Column7}}
			cylinder {((<.18,.13,.3> * Size) + Origin)((<.18,.13,-.3> * Size) + Origin),(.01 * Size) texture{T_Column7}}
			
		}
		union {
		
			cylinder {((<.3,.13,.18> * Size) + Origin)((<-.3,.13,.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}	
			cylinder {((<-.3,.13,-.18> * Size) + Origin)((<.3,.13,-.18> * Size) + Origin),(.01 * Size) texture{T_Column7}}
			
		}  
	
	}
    
#end 

// SQUARE COLUMN SHAFT
                           
#macro S_Col_Shaft (Origin,Height,Fluting,Quantity,Size)

	#if (Fluting = 0)
		box {((<.15,0,.15> * Size) + Origin)((<-.15,Height,-.15> * Size) + Origin) texture{T_Column1}}
	#end
	
	#if (Fluting > 0)
		difference {
		
			box {((<.15,0,.15> * Size) + Origin)((<-.15,Height,-.15> * Size) + Origin) texture{T_Column1}}
			
			#local Qty = int(Quantity / 4);
			#local Gaps = (.3 / (Qty + .5));
			#local Gstart = (-.15 + (Gaps * .75));
			#local Count1 = 0;
			#local Flutes =
				union {
					#while (Count1 < Qty)
					
						sphere {(<Gstart,.05,-.15> * Size),(.025 * Size) texture{T_Column2}}
						sphere {(<Gstart,(Height - .05),-.15> * Size),(.025 * Size) texture{T_Column2}}
						cylinder {(<Gstart,.05,-.15> * Size)(<Gstart,(Height - .05),-.15> * Size),(.025 * Size) texture{T_Column2}}
					    
					    #local Gstart = (Gstart + Gaps);
					    
						#local Count1 = (Count1 + 1);
					#end
				}
			object {Flutes translate Origin texture{T_Column1}}
			object {Flutes rotate <0,90,0> translate Origin texture{T_Column1}}
			object {Flutes rotate <0,180,0> translate Origin  texture{T_Column1}}
			object {Flutes rotate <0,270,0> translate Origin  texture{T_Column1}}
			
		}
	#end
	
	#if (Fluting = 2)
		#local Qty = int(Quantity / 4);
		#local Gaps = (.3 / (Qty + .5));
		#local Gstart = (-.15 + (Gaps * .75));
		#local Count1 = 0;
		#local Flutes =
			union {
				#while (Count1 < Qty)
				
					sphere {(<Gstart,.05,-.12> * Size),(.02 * Size) texture{T_Column2}}
					sphere {(<Gstart,(Height * .33),-.12> * Size),(.02 * Size) texture{T_Column2}}
					cylinder {(<Gstart,.05,-.12> * Size)(<Gstart,(Height * .33),-.12> * Size),(.02 * Size) texture{T_Column2}}
				    
				    #local Gstart = (Gstart + Gaps);
				    
					#local Count1 = (Count1 + 1);
				#end
			}
		object {Flutes translate Origin texture{T_Column1}}
		object {Flutes rotate <0,90,0> translate Origin texture{T_Column1}}
		object {Flutes rotate <0,180,0> translate Origin  texture{T_Column1}}
		object {Flutes rotate <0,270,0> translate Origin  texture{T_Column1}}
				 
	#end
	
#end

// SQUARE COLUMN CAPITAL TYPE 1
#macro S_Col_Capital_1 (Origin,Size)  

	#local Rad1 = (.15 * Size);
	#local Rad2 = (.025 * Size);
	#local Origin2 = ((<0,0.125,0> * Size) + Origin);
	box {((<-.165,0,-.165> * Size) + Origin)((<.165,.025,.165> * Size) + Origin) texture{T_Column4}}
	box {((<-.15,.025,-.15> * Size) + Origin)((<.15,.075,.15> * Size) + Origin) texture{T_Column3}}
	box {((<-.165,.075,-.165> * Size) + Origin)((<.165,.1,.165> * Size) + Origin) texture{T_Column4}} 
	S_Torus (Rad1,Rad2,Origin2,T_Column4)
	box {((<-.19,.125,-.19> * Size) + Origin)((<.19,.175,.19> * Size) + Origin) texture{T_Column5}}

#end  

// SQUARE COLUMN CAPITAL TYPE 2
#macro S_Col_Capital_2 (Origin,Size)

	box {((<-.16,0,-.16> * Size) + Origin)((<.16,.01,.16> * Size) + Origin) texture{T_Column4}}
	box {((<-.15,.01,-.15> * Size) + Origin)((<.15,.045,.15> * Size) + Origin) texture{T_Column3}}
	box {((<-0.175,0.075,-0.175> * Size) + Origin)((<0.175,0.1,0.175> * Size) + Origin) texture{T_Column5}}
	#local Count1 = 1;
	sphere {(<0,0.025,0.14> * Size),(0.015 * Size) translate Origin texture{T_Column4}}
	sphere {(<0,0.025,-0.14> * Size),(0.015 * Size) translate Origin texture{T_Column4}}
	#while (Count1 < 5)   
		#local Ntrans1 = (<.025,0,0> * Size); 
		#local Ntrans2 = (<-.025,0,0> * Size);
		sphere {(<0,0.025,0.14> * Size),(0.015 * Size) translate (Ntrans1 * Count1) translate Origin texture{T_Column4}} 
		sphere {(<0,0.025,0.14> * Size),(0.015 * Size) translate (Ntrans2 * Count1) translate Origin texture{T_Column4}} 
		sphere {(<0,0.025,-0.14> * Size),(0.015 * Size) translate (Ntrans1 * Count1) translate Origin texture{T_Column4}} 
		sphere {(<0,0.025,-0.14> * Size),(0.015 * Size) translate (Ntrans2 * Count1) translate Origin texture{T_Column4}}
		#local Count1 = (Count1 + 1);
	#end

	#local HGroup =
		union {
			Col_Horn (<1,1,1>,(<0,0,-0.16> * Size),Size)
			Col_Horn (<-1,1,1>,(<0,0,-0.16> * Size),Size)
			Col_Horn (<1,1,-1>,(<0,0,0.16> * Size),Size)
			Col_Horn (<-1,1,-1>,(<0,0,0.16> * Size),Size)
		}
	
	object {HGroup translate Origin }

	#local Col_Infill =
	union {
		difference {
			cylinder {(<0.175,0,-0.16> * Size)(<0.175,0,0.16> * Size),(0.075 * Size) texture{T_Column4}}
			box {(<-10,-10,-10> * Size)(<0.175,10,10> * Size) texture{T_Column4}}
		}
		difference {
			cylinder {(<0.175,-0.015,-0.16> * Size)(<0.175,-0.015,0.16> * Size),(0.06 * Size) texture{T_Column4}}
			box {(<0.175,-10,-10> * Size)(<10,10,10> * Size) texture{T_Column4}}
		}
	}

	object {Col_Infill translate Origin }
	object {Col_Infill scale <-1,1,1> translate Origin }

#end

#macro S_Col_Capital_2r (Origin,Size)

	box {((<-.16,0,-.16> * Size) + Origin)((<.16,.01,.16> * Size) + Origin) texture{T_Column4}}
	box {((<-.15,.01,-.15> * Size) + Origin)((<.15,.045,.15> * Size) + Origin) texture{T_Column3}}
	box {((<-0.175,0.075,-0.175> * Size) + Origin)((<0.175,0.1,0.175> * Size) + Origin) texture{T_Column5}}
	#local Count1 = 1;
	sphere {(<0.14,0.025,0> * Size),(0.015 * Size) translate Origin texture{T_Column4}}
	sphere {(<-0.14,0.025,0> * Size),(0.015 * Size) translate Origin texture{T_Column4}}
	#while (Count1 < 5)   
		#local Ntrans1 = (<0,0,.025> * Size); 
		#local Ntrans2 = (<0,0,-.025> * Size);
		sphere {(<0.14,0.025,0> * Size),(0.015 * Size) translate (Ntrans1 * Count1) translate Origin texture{T_Column4}} 
		sphere {(<0.14,0.025,0> * Size),(0.015 * Size) translate (Ntrans2 * Count1) translate Origin texture{T_Column4}} 
		sphere {(<-0.14,0.025,0> * Size),(0.015 * Size) translate (Ntrans1 * Count1) translate Origin texture{T_Column4}} 
		sphere {(<-0.14,0.025,0> * Size),(0.015 * Size) translate (Ntrans2 * Count1) translate Origin texture{T_Column4}}
		#local Count1 = (Count1 + 1);
	#end

	#local HGroup =
		union {
			Col_Horn (<1,1,1>,(<0,0,-0.16> * Size),Size)
			Col_Horn (<-1,1,1>,(<0,0,-0.16> * Size),Size)
			Col_Horn (<1,1,-1>,(<0,0,0.16> * Size),Size)
			Col_Horn (<-1,1,-1>,(<0,0,0.16> * Size),Size)
		}

	object {HGroup rotate <0,90,0> translate Origin }

	#local Col_Infill =
	union {
		difference {
			cylinder {(<0.175,0,-0.16> * Size)(<0.175,0,0.16> * Size),(0.075 * Size) texture{T_Column4}}
			box {(<-10,-10,-10> * Size)(<0.175,10,10> * Size) texture{T_Column4}}
		}
		difference {
			cylinder {(<0.175,-0.015,-0.16> * Size)(<0.175,-0.015,0.16> * Size),(0.06 * Size) texture{T_Column4}}
			box {(<0.175,-10,-10> * Size)(<10,10,10> * Size) texture{T_Column4}}
		}
	}

	object {Col_Infill rotate <0,90,0> translate Origin }
	object {Col_Infill scale <-1,1,1> rotate <0,90,0> translate Origin }

#end

// SQUARE COLUMN CAPITAL TYPE 3
#macro S_Col_Capital_3 (Origin,Detail,Size)

	box {((<-.165,0,-.165> * Size) + Origin)((<.165,.015,.165> * Size) + Origin) texture{T_Column4}}
	box {((<-.15,.015,-.15> * Size) + Origin)((<.15,.15,.15> * Size) + Origin) texture{T_Column3}}
	#local Npnt1 = ((<0,0.15,0> * Size) + Origin);
	#local Nrad1 = (0.15 * Size);
	#local Npnt2 = ((<0,0.35,0> * Size) + Origin);
	#local Nrad2 = (0.2 * Size);
	S_Cone (Npnt1,Nrad1,Npnt2,Nrad2,T_Column3)

	Col_Leaf (Detail,Size)

	#local Leaf_Group =
	union { 
		// Lower row
		object {Col_Leaf2 rotate <-7,0,0> translate (<0,0,-0.14> * Size) clipped_by {plane {-y,0}} translate Origin }
		#local Count1 = 1;
		#while (Count1 < 2) 
			#local Xtran1 = (<.1,0,0> * Size); 
			#local Xtran2 = (<-.1,0,0> * Size);
			object {Col_Leaf2 rotate <-7,0,0> translate ((<0,0,-0.14> * Size) + (Xtran1 * Count1)) clipped_by {plane {-y,0}} translate Origin }
			object {Col_Leaf2 rotate <-7,0,0> translate ((<0,0,-0.14> * Size) + (Xtran2 * Count1)) clipped_by {plane {-y,0}} translate Origin }
			#local Count1 = (Count1 + 1);
		#end
		// Top row
		object {Col_Leaf2 rotate <-22,0,0> translate (<0,0.22,-0.16> * Size) translate Origin }
		#local Count1 = 1;
		#while (Count1 < 3) 
			#local Xtran1 = (<.06,0,0> * Size); 
			#local Xtran2 = (<-.06,0,0> * Size);
			object {Col_Leaf2 rotate <-22,0,-15> translate ((<0,0.22,-0.16> * Size) + (Xtran1 * Count1)) translate Origin }
			object {Col_Leaf2 rotate <-22,0,15> translate ((<0,0.22,-0.16> * Size) + (Xtran2 * Count1)) translate Origin }
			#local Count1 = (Count1 + 1);
		#end
		// Middle row
		object {Col_Leaf2 rotate <-17,0,0> translate ((<0,0.1,-0.14> * Size) + <.06,0,0>) translate Origin }
		object {Col_Leaf2 rotate <-17,0,0> translate ((<0,0.1,-0.14> * Size) + <-.06,0,0>) translate Origin }
		object {Col_Leaf2 rotate <-17,0,0> translate ((<0,0.1,-0.14> * Size) + <.18,0,0>) translate Origin }
		object {Col_Leaf2 rotate <-17,0,0> translate ((<0,0.1,-0.14> * Size) + <-.18,0,0>) translate Origin }
	}
	
	object {Leaf_Group}
	object {Leaf_Group rotate <0,90,0>}
	object {Leaf_Group rotate <0,180,0>}
	object {Leaf_Group rotate <0,270,0>}

	#local Col_Cut1 =
	union {
   		box {(<-0.15,-1,-0.15> * Size)(<0.15,0.36,0.15> * Size) texture{T_Column5}}
   		box {(<-0.14,0.36,-0.14> * Size)(<0.14,0.375,0.14> * Size) texture{T_Column5}}
   		box {(<-0.13,0,-0.13> * Size)(<0.13,0.5,0.13> * Size) texture{T_Column5}}
	}

	#local Col_Cut2 =
	union {
   		object {Col_Cut1 rotate <0,45,0> translate (<0.318,0,0.318> * Size) texture{T_Column5}}
   		cylinder {(<0,-1,0.528> * Size)(<0,0.36,0.528> * Size),(0.319 * Size) texture{T_Column5}}
   		cylinder {(<0,0.36,0.528> * Size)(<0,0.375,0.528> * Size),(0.309 * Size) texture{T_Column5}}
   		cylinder {(<0,-1,0.528> * Size)(<0,0.5,0.528> * Size),(0.299 * Size) texture{T_Column5}}
	}

	difference {
    	box {((<-0.275,0.35,-0.275> * Size) + Origin)((<0.275,0.4,0.275> * Size) + Origin) texture{T_Column5}}
   		object {Col_Cut2 translate Origin }
   		object {Col_Cut2 rotate <0,90,0> translate Origin }
   		object {Col_Cut2 rotate <0,180,0> translate Origin }
   		object {Col_Cut2 rotate <0,-90,0> translate Origin }
	}

	#local Col_Flower =
	union {
		sphere {(<0,0,0> * Size),(.04 * Size) texture{T_Column6}}
		sphere {(<0.015,0,0> * Size),(.03 * Size) texture{T_Column6}}
		sphere {(<0.03,0,0> * Size),(.03 * Size) texture{T_Column6}}
		sphere {(<-0.015,0,0> * Size),(.03 * Size) texture{T_Column6}}
		sphere {(<-0.03,0,0> * Size),(.03 * Size) texture{T_Column6}}
	}
	
	object {Col_Flower translate ((<0,0.385,-.21> * Size) + Origin)}
	object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,90,0> translate Origin }
	object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,180,0> translate Origin }
	object {Col_Flower translate (<0,0.385,-.21> * Size) rotate <0,-90,0> translate Origin }

#end

// SQUARE COLUMN CAPITAL TYPE 4
#macro S_Col_Capital_4 (Origin,Detail,Size)

	S_Col_Capital_3 (Origin,Detail,Size)

	#local Col_Add1 =
	union {
		Col_Horn (<1,1,1>,(<.08,0.28,0> * Size),Size)
		Col_Horn (<1,1,-1>,(<.08,0.28,0> * Size),Size)
	}

	object {Col_Add1 rotate <0,45,0> translate Origin }
	object {Col_Add1 rotate <0,135,0> translate Origin }
	object {Col_Add1 rotate <0,-45,0> translate Origin }
	object {Col_Add1 rotate <0,-135,0> translate Origin }

    #local Rad1 = (.18 * Size);
	#local Rad2 = (.02 * Size);
	#local Origin2 = ((<0,0.3,0> * Size) + Origin);  
	S_Torus (Rad1,Rad2,Origin2,T_Column4)
	
#end

// BASIC SQUARE COLUMN
#macro S_Generic_Column (Origin,Height,Fluting,Quantity,Base,Capital,Leaf,Size)

	#if (Base = 1) #local Base_Height = .175; #else #local Base_Height = .17; #end
	#if (Capital = 1) #local Capital_Height = .175; #end
	#if (Capital = 2) #local Capital_Height = .1; #end
	#if (Capital = 3) #local Capital_Height = .4; #end
	#if (Capital = 4) #local Capital_Height = .4; #end
	#if (Capital = 5) #local Capital_Height = .1; #end
	
	#local Shaft_Size = (Height - Base_Height - Capital_Height);
	#local Shaft_Base = (Origin + (<0,Base_Height,0> * Size));
	#local Capital_Base = (Origin + (<0,(Height - Capital_Height),0> * Size));

	#if (Base = 1) S_Col_Base_1 (Origin,Size) #end
	#if (Base = 2) S_Col_Base_2 (Origin,Size) #end
	
	S_Col_Shaft (Shaft_Base,Shaft_Size,Fluting,Quantity,Size)

	#if (Capital = 1) S_Col_Capital_1 (Capital_Base,Size) #end
	#if (Capital = 2) S_Col_Capital_2 (Capital_Base,Size) #end
	#if (Capital = 3) S_Col_Capital_3 (Capital_Base,Leaf,Size) #end
	#if (Capital = 4) S_Col_Capital_4 (Capital_Base,Leaf,Size) #end
	#if (Capital = 5) S_Col_Capital_2r (Capital_Base,Size) #end

#end

// CLASSIC SQUARE COLUMN SET
#macro S_Classic_Column (Origin,Style,Size)   

	#if (Style = 1) S_Generic_Column (Origin,2.2,0,0,1,1,1,Size) #end
	#if (Style = 2) S_Generic_Column (Origin,2.4,1,12,2,1,1,Size) #end
	#if (Style = 3) S_Generic_Column (Origin,2.6,1,16,2,2,1,Size) #end 
	#if (Style = 31) S_Generic_Column (Origin,2.6,1,16,2,5,1,Size) #end   // Special Ionic with capital rotate 90 degrees
	#if (Style = 4) S_Generic_Column (Origin,2.8,1,20,2,3,1,Size) #end
	#if (Style = 5) S_Generic_Column (Origin,3.2,2,20,2,4,2,Size) #end

#end
                             
// EOF