// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: DOME MACRO SET
// Date: JAN 99
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998 

// Copper roof texture

#macro Dome_Texture (Rad)
	#declare Copper_Rad = Rad;
	#include "T_Copper.inc"
#end

// DOME TYPE 1

#macro DM_One (Rad,Origin)

	Dome_Texture (Rad)
     
	difference {
		cylinder {(<0,0,0> + Origin)((<0,.1,0> * Rad) + Origin),(1 * Rad) texture{T_Copper_R}}
		torus {(1 * Rad),(.1 * Rad) sturm translate ((<0,.1,0> * Rad) + Origin) texture{T_Copper_R}}
	} 
	
	cylinder {((<0,.1,0> * Rad) + Origin)((<0,.35,0> * Rad) + Origin),(.9 * Rad) texture{T_Copper_R}}
	
	difference {
		sphere {((<0,.35,0> * Rad) + Origin),(.9 * Rad) texture{T_Copper_R}}
		box {((<2,.35,2> * Rad) + Origin)((<-2,-2,-2> * Rad) + Origin) texture{T_Copper_R}}
	}
	   
	#local Over_Band =
	difference {
		union {  
		
			difference {
				cylinder {(<0,0,0> + Origin)((<0,.1,0> * Rad) + Origin),(1.025 * Rad)}
				torus {(1 * Rad),(.075 * Rad) sturm translate ((<0,.1,0> * Rad) + Origin)}
			} 
	
			cylinder {((<0,.1,0> * Rad) + Origin)((<0,.35,0> * Rad) + Origin),(.925 * Rad)}
	
			difference {
				sphere {((<0,.35,0> * Rad) + Origin),(.925 * Rad)}
				box {((<2,.35,2> * Rad) + Origin)((<-2,-2,-2> * Rad) + Origin)}
			}
		}
		
		box {((<0,-2,2> * Rad) + Origin)((<2,2,-2> * Rad) + Origin) rotate <0,10,0>} 
		box {((<0,-2,2> * Rad) + Origin)((<-2,2,-2> * Rad) + Origin) rotate <0,-10,0>}
	}
	
	#local Count1 = 0;
	#while (Count1 < 8)
		object {Over_Band rotate <0,(45 * Count1),0> texture{T_Copper_R}}
		#local Count1 = (Count1 + 1);
	#end
	
#end

// DOME TYPE 2

#macro DM_Two (Rad,Origin)

	Dome_Texture (Rad)
     
	#local Dome_Part1 =
	difference {
		sphere {<0,0,0>,(1 * Rad)}
		box {(<2,0,2> * Rad)(<-2,-2,-2> * Rad)}
	}
	
	#local Dome_Part2 =
	difference {
		sphere {<0,0,0>,(1.025 * Rad)}
		box {(<2,0,2> * Rad)(<-2,-2,-2> * Rad)}
		box {(<0,-2,2> * Rad)(<2,2,-2> * Rad) rotate <0,10,0>} 
		box {(<0,-2,2> * Rad)(<-2,2,-2> * Rad) rotate <0,-10,0>}
	}
	
	#local Dome_Part3 =
	union {
		object {Dome_Part1}
		#local Count1 = 0;
		#while (Count1 < 8)
			object {Dome_Part2 rotate <0,(45 * Count1),0>}
			#local Count1 = (Count1 + 1);
		#end
	}
	
	object {Dome_Part3 scale <1,1.25,1> translate Origin texture{T_Copper_R}}
	
	// first entablature 
	#local E_Rad = (.4 * Rad);
	#local E_Origin = ((<0,1.1456,0> * Rad) + Origin);
	#local E_Size = (.2 * Rad);     
	
	#local E_Cstart = (E_Origin + (<0,.6,0> * E_Size));
	#local E_Origin2 = (E_Cstart + (<0,2.2,0> * E_Size));
	#local E_Dstart = (E_Origin2 + (<0,.6,0> * E_Size));
	
	#local DM_Entab = union {E_Circular (E_Rad,1,E_Size,0,0)}
	
	object {DM_Entab translate E_Origin}
	object {DM_Entab translate E_Origin2}  
	
	#local DM_Col = union {Classic_Column (E_Cstart,1,E_Size)}
	#local Count1 = 0;
	#while (Count1 < 13)
		object {DM_Col translate <E_Rad,0,0> rotate <0,((360 / 13) * Count1),0>}
		#local Count1 = (Count1 + 1);
	#end
	
	#local E_Rad2 = (E_Rad + (.15 * E_Size));
	
	Dome_Texture (E_Rad2)
	
	DM_One (E_Rad2,E_Dstart)	
	
#end

//EOF