// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: Entablature macro set
// Date: Dec 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998  

#include "t_13entab.inc"

// BASE ENTABLATURE FUNCTIONS

#macro E_Make_Point (Point1,Length,Size)
	#local Px = (Length / Size);
	#local Py = Vcom(Point1,1)
	#local Pz = Vcom(Point1,2)
	(<Px,Py,Pz> * Size);
#end

#macro E_Make_Point2 (Point1,Size)
	#local Px = Vcom(Point1,2)
	#local Py = Vcom(Point1,1)
	#local Pz = Vcom(Point1,2)
	(<Px,Py,Pz> * Size);
#end

#macro E_Box_Loop (Array_1,Array_2,Length,Size)

	#local Start_Origin = <0,0,0>;
	#local Loops = dimension_size(Array_1,1);
	#local Count1 = 0;
	#while (Count1 < Loops)
		#local Point1 = Array_1[Count1];
		#local New_Point = E_Make_Point (Point1,Length,Size)
		#local Colour = Array_2[Count1];
		
		box {Start_Origin,New_Point
			#if (Colour = 0)
				texture{T_Entab1}
			#else
				texture{T_Entab2}
			#end
		}
		
		#local NewY = Vcom(Point1,1)
		#local Start_Origin = <0,(NewY * Size),0>;
		
		#local Count1 = (Count1 + 1);
	#end

#end     

#macro E_Box_Loop_Corner (Array_1,Array_2,Size)   

	#local Start_Origin = <0,0,0>;
	#local Loops = dimension_size(Array_1,1);
	#local Count1 = 0;
	#while (Count1 < Loops)
		#local Point1 = Array_1[Count1];
		#local New_Point = E_Make_Point2 (Point1,Size)
		#local Colour = Array_2[Count1];
		
		box {Start_Origin,New_Point
			#if (Colour = 0)
				texture{T_Entab1}
			#else
				texture{T_Entab2}
			#end
		}
		
		#local NewY = Vcom(Point1,1)
		#local Start_Origin = <0,(NewY * Size),0>;
		
		#local Count1 = (Count1 + 1);
	#end
	
#end

// CIRC ENTAB FUNCTIONS
#macro E_Gpoint (Point1,Size) 

	#local New_Y = Vcom(Point1,1)
	(<0,New_Y,0> * Size);

#end

#macro E_Grad (Point1,Rad,Switch1) 

	#local Rad_Dif = Vcom(Point1,2)
	#if (Switch1 = 0)
		#local Rad_Dif = (Rad - (Rad_Dif * Size));
	#else  
		#local Rad_Dif = (Rad + (Rad_Dif * Size));
	#end 
	(Rad_Dif);

#end

// CIRCULAR ENTABLATURE 
#macro E_Circ_Loop (Array_1,Array_2,Rad,Size,Switch1,Switch2)

	#local Start_Origin = <0,0,0>;
	#local Loops = dimension_size(Array_1,1);
	#local Count1 = 0;
	#while (Count1 < Loops)
		#local Point1 = Array_1[Count1];
		#local Colour = Array_2[Count1];
		#local Point2 = E_Gpoint(Point1,Size)
		#local New_Rad = E_Grad(Point1,Rad,Switch1) 
		
		#if (Switch1 = 0)
			#if (Switch2 = 1) difference { #end
			cylinder {Start_Origin,Point2,New_Rad
			#if (Colour = 0)
				texture{T_Entab1}
			#else
				texture{T_Entab2}
			#end
			}
			#if (Switch2 = 1)
				cylinder {(Start_Origin + <0,-10,0>),(Point2 + <0,10,0>),Rad
				#if (Colour = 0)
					texture{T_Entab1}
				#else
					texture{T_Entab2}
				#end
				}
				}
			#end
		#end 
		
		#if (Switch1 = 1)
			difference {
				cylinder {Start_Origin,Point2,Rad
				#if (Colour = 0)
					texture{T_Entab1}
				#else
					texture{T_Entab2}
				#end
				}
				cylinder {(Start_Origin + <0,-10,0>),(Point2 + <0,10,0>),New_Rad
				#if (Colour = 0)
					texture{T_Entab1}
				#else
					texture{T_Entab2}
				#end
				}
			}
		#end
		
		#local Start_Origin = Point2;		
		#local Count1 = (Count1 + 1);
	#end

#end

// BASE TUSCAN AND DORIC ORDER CIRCULAR ENTABLATURE
#macro E_Cbase_TD (Rad,Size,Switch1,Switch2)

	#local Entab1 = array[11]{<0,0.13,-0.15>,<0,0.17,-0.175>,<0,0.39,-0.15>,<0,0.41,-0.17>,<0,0.43,-0.19>,
                           <0,0.45,-0.21>,<0,0.525,-0.23>,<0,0.535,-0.285>,<0,0.55,-0.295>,<0,0.56,-0.305>,<0,0.6,-0.325>}
	#local Entab2 = array[11]{0,0,1,0,0,0,0,0,0,0,0}  
	E_Circ_Loop (Entab1,Entab2,Rad,Size,Switch1,Switch2)

#end

// BASE IONIC, CORINTHIAN & COMPOSITE CIRCULAR ENTABLATURE
#macro E_Cbase_ICC (Rad,Size,Switch1,Switch2)

	#local Entab1 = array[15]{<0,0.04,-0.15>,<0,0.08,-0.165>,<0,0.13,-0.18>,<0,0.15,-0.19>,<0,0.16,-0.2>,
                            <0,0.17,-0.21>,<0,0.39,-0.15>,<0,0.41,-0.17>,<0,0.43,-0.19>,<0,0.45,-0.21>,
                            <0,0.525,-0.23>,<0,0.535,-0.285>,<0,0.55,-0.295>,<0,0.56,-0.305>,<0,0.6,-0.325>}
	#local Entab2 = array[15]{0,0,0,0,0,0,1,0,0,0,0,0,0,0,0}  
	E_Circ_Loop (Entab1,Entab2,Rad,Size,Switch1,Switch2)

#end

// BASE TUSCAN AND DORIC ORDER ENTABLATURE
#macro E_Base_TD (Length,Type,Size)
	#local Entab1 = array[11]{<0,0.13,-0.15>,<0,0.17,-0.175>,<0,0.39,-0.15>,<0,0.41,-0.17>,<0,0.43,-0.19>,
                           <0,0.45,-0.21>,<0,0.525,-0.23>,<0,0.535,-0.285>,<0,0.55,-0.295>,<0,0.56,-0.305>,<0,0.6,-0.325>}
	#local Entab2 = array[11]{0,0,1,0,0,0,0,0,0,0,0}  
	#if (Type = 0)
		E_Box_Loop (Entab1,Entab2,Length,Size)
	#else
		E_Box_Loop_Corner (Entab1,Entab2,Size)
	#end
#end

// BASE IONIC, CORINTHIAN & COMPOSITE ENTABLATURE
#macro E_Base_ICC (Length,Type,Size)
	#local Entab1 = array[15]{<0,0.04,-0.15>,<0,0.08,-0.165>,<0,0.13,-0.18>,<0,0.15,-0.19>,<0,0.16,-0.2>,
                            <0,0.17,-0.21>,<0,0.39,-0.15>,<0,0.41,-0.17>,<0,0.43,-0.19>,<0,0.45,-0.21>,
                            <0,0.525,-0.23>,<0,0.535,-0.285>,<0,0.55,-0.295>,<0,0.56,-0.305>,<0,0.6,-0.325>}
	#local Entab2 = array[15]{0,0,0,0,0,0,1,0,0,0,0,0,0,0,0}  
	#if (Type = 0)
		E_Box_Loop (Entab1,Entab2,Length,Size)
	#else
		E_Box_Loop_Corner (Entab1,Entab2,Size)
	#end
#end

// SQUARE 	ENTABLATURE DETAIL FUNCTIONS

#macro E_Detail_Doric (Length,Size)
	#local Divisions = int(Length / (0.4 * Size));
	#local Dist = (Length / Divisions);
	#local Start = <0,0,0>; 
	#local Newx = Dist;
	#local Count1 = 0;
	#while (Count1 < (Divisions + 1))  
	
		#local Box1 = box{((<-.1,.17,-.15> * Size) + Start),((<-.05,.39,-.165> * Size) + Start)}
		#local Box2 = box{((<-.098,.105,-.15> * Size) + Start),((<-.078,.13,-.165> * Size) + Start)}
		
		#local Count2 = 0;
		#while (Count2 < 3)
			object {Box1 translate <((Count2 * .075) * Size),0,0> texture{T_Entab3}}
			#local Count2 = (Count2 + 1);
		#end
		
		#local Count3 = 0;
		#while (Count3 < 8)
			object {Box2 translate <((Count3 * .025) * Size),0,0> texture{T_Entab3}}
			#local Count3 = (Count3 + 1);
		#end  
		
		box {((<-.085,.45,-.23> * Size) + Start),((<.085,.51,-.275> * Size) + Start) texture{T_Entab3}} 
		box {((<-.1,.51,-.23> * Size) + Start),((<.1,.525,-.295> * Size) + Start) texture{T_Entab3}}
	
		#local Start = <Newx,0,0>;
		#local Newx = (Newx + Dist);
		#local Count1 = (Count1 + 1);
	#end
#end   

#macro E_Detail_Ionic (Length,Size)  
	#local Divisions = int(Length / (.09 * Size));
	#local Dist = (Length / Divisions);
	#local Start = <0,0,0>;
	#local Newx = Dist;
	#local Count1 = 0;
	#while (Count1 < (Divisions + 2)) 
	
		box {((<-.06,.39,-.15> * Size) + Start),((<-.12,.45,-.225> * Size) + Start) texture{T_Entab3}}
		
	    #local Start = <Newx,0,0>;
	    #local Newx = (Newx + Dist);
		#local Count1 = (Count1 + 1);
	#end
#end

#macro E_Detail_Corinth (Length,Size)  
	#local Divisions = int(Length / (.3 * Size));
	#local Dist = (Length / Divisions);
	#local Start = <0,0,0>;
	#local Newx = Dist;
	#local Count1 = 0;
	#while (Count1 < (Divisions + 1)) 
	
		box {((<-.065,.45,-.23> * Size) + Start),((<.065,.51,-.275> * Size) + Start) texture{T_Entab3}} 
		box {((<-.08,.51,-.23> * Size) + Start),((<.08,.525,-.295> * Size) + Start) texture{T_Entab3}}
		
	    #local Start = <Newx,0,0>;
	    #local Newx = (Newx + Dist);
		#local Count1 = (Count1 + 1);
	#end
#end

#macro E_Detail_Comp (Length,Size)  
	#local Divisions = int(Length / (.3 * Size));
	#local Dist = (Length / Divisions);
	#local Start = <0,0,0>;
	#local Newx = Dist;
	#local Count1 = 0;
	#while (Count1 < (Divisions + 1)) 
	
		box {((<-.065,.45,-.23> * Size) + Start),((<.065,.51,-.275> * Size) + Start) texture{T_Entab3}} 
		box {((<-.08,.51,-.23> * Size) + Start),((<.08,.525,-.295> * Size) + Start) texture{T_Entab3}} 
		box {((<-.04,.39,-.15> * Size) + Start),((<.04,.45,-.225> * Size) + Start) texture{T_Entab3}}
		
	    #local Start = <Newx,0,0>;
	    #local Newx = (Newx + Dist);
		#local Count1 = (Count1 + 1);
	#end
#end

// CIRCULAR ENTABLATURE DETAIL FUNCTIONS

#macro E_Cdetail_Doric (Rad,Size,Switch1)

	#local Det_Item = 
	union {
		box {(<-.1,.17,0> * Size)(<-.05,.39,-.015> * Size)}
		box {(<-.025,.17,0> * Size)(<.025,.39,-.015> * Size)}
		box {(<.05,.17,0> * Size)(<.1,.39,-.015> * Size)}
		
		box {(<-.085,.45,0> * Size)(<.085,.51,-.125> * Size)}
		box {(<-.1,.51,0> * Size)(<.1,.525,-.145> * Size)}
		
		box {(<-.098,.105,0> * Size)(<-.078,.13,-.015> * Size)}
		box {(<-.073,.105,0> * Size)(<-.053,.13,-.015> * Size)}
		box {(<-.048,.105,0> * Size)(<-.028,.13,-.015> * Size)}
		box {(<-.022,.105,0> * Size)(<-.003,.13,-.015> * Size)}
		box {(<.003,.105,0> * Size)(<.022,.13,-.015> * Size)}
		box {(<.028,.105,0> * Size)(<.048,.13,-.015> * Size)}
		box {(<.053,.105,0> * Size)(<.073,.13,-.015> * Size)}
		box {(<.078,.105,0> * Size)(<.098,.13,-.015> * Size)}		
		
	}
	
	#if (Switch1 = 0)
		#local Array_Rad = (Rad + (.15 * Size));
	#else 
		#local Array_Rad = (Rad - (.15 * Size));
	#end    
	#if (Switch1 = 0)
		#local Det_Tran = (Array_Rad * -1);
	#else
		#local Det_Tran = Array_Rad;
	#end
	
	#local New_Dia = (Array_Rad * 2 * pi);
	#local Det_Space = (.4 * Size);
	#local Qty = int(New_Dia / Det_Space);
	#local Count1 = 0;
	#while (Count1 < Qty)
		object {Det_Item translate <0,0,Det_Tran> rotate <0,((360 / Qty) * Count1),0> texture{T_Entab3}}
		#local Count1 = (Count1 + 1);
	#end

#end

#macro E_Cdetail_Ionic (Rad,Size,Switch1)

	#local Det_Item = 
	union {
		box {(<-.03,.39,0> * Size)(<.03,.45,-.075> * Size)}
	}
	
	#if (Switch1 = 0)
		#local Array_Rad = (Rad + (.15 * Size));
	#else 
		#local Array_Rad = (Rad - (.15 * Size));
	#end    
	#if (Switch1 = 0)
		#local Det_Tran = (Array_Rad * -1);
	#else
		#local Det_Tran = Array_Rad;
	#end
	
	#local New_Dia = (Array_Rad * 2 * pi);
	#local Det_Space = (.09 * Size);
	#local Qty = int(New_Dia / Det_Space);
	#local Count1 = 0;
	#while (Count1 < Qty)
		object {Det_Item translate <0,0,Det_Tran> rotate <0,((360 / Qty) * Count1),0> texture{T_Entab3}}
		#local Count1 = (Count1 + 1);
	#end

#end

#macro E_Cdetail_Corinth (Rad,Size,Switch1)

	#local Det_Item = 
	union {
		box {(<-.065,.45,0> * Size)(<.065,.51,-.125> * Size)}
		box {(<-.08,.51,0> * Size)(<.05,.525,-.145> * Size)}
	}
	
	#if (Switch1 = 0)
		#local Array_Rad = (Rad + (.15 * Size));
	#else 
		#local Array_Rad = (Rad - (.15 * Size));
	#end    
	#if (Switch1 = 0)
		#local Det_Tran = (Array_Rad * -1);
	#else
		#local Det_Tran = Array_Rad;
	#end
	
	#local New_Dia = (Array_Rad * 2 * pi);
	#local Det_Space = (.3 * Size);
	#local Qty = int(New_Dia / Det_Space);
	#local Count1 = 0;
	#while (Count1 < Qty)
		object {Det_Item translate <0,0,Det_Tran> rotate <0,((360 / Qty) * Count1),0> texture{T_Entab3}}
		#local Count1 = (Count1 + 1);
	#end

#end

#macro E_Cdetail_Comp (Rad,Size,Switch1)

	#local Det_Item = 
	union {
		box {(<-.065,.45,0> * Size)(<.065,.51,-.125> * Size)}
		box {(<-.08,.51,0> * Size)(<.08,.525,-.145> * Size)}
		box {(<-.04,.39,0> * Size)(<.04,.45,-.075> * Size)}
	}
	
	#if (Switch1 = 0)
		#local Array_Rad = (Rad + (.15 * Size));
	#else 
		#local Array_Rad = (Rad - (.15 * Size));
	#end    
	#if (Switch1 = 0)
		#local Det_Tran = (Array_Rad * -1);
	#else
		#local Det_Tran = Array_Rad;
	#end
	
	#local New_Dia = (Array_Rad * 2 * pi);
	#local Det_Space = (.3 * Size);
	#local Qty = int(New_Dia / Det_Space);
	#local Count1 = 0;
	#while (Count1 < Qty)
		object {Det_Item translate <0,0,Det_Tran> rotate <0,((360 / Qty) * Count1),0> texture{T_Entab3}}
		#local Count1 = (Count1 + 1);
	#end

#end

// SIMPLE LENGTH RUN OF ENTABLATURE
#macro E_Length (Length,Type,Size)

	#if (Type = 1)
		E_Base_TD (Length,0,Size)  
	#end
	
	#if (Type = 2)
		E_Base_TD (Length,0,Size)    
		E_Detail_Doric(Length,Size)
	#end
	
	#if (Type = 3) 
		E_Base_ICC (Length,0,Size)     
		E_Detail_Ionic(Length,Size)
	#end
	
	#if (Type = 4) 
		E_Base_ICC (Length,0,Size)    
		E_Detail_Corinth(Length,Size)
	#end
	
	#if (Type = 5) 
		E_Base_ICC (Length,0,Size)    
		E_Detail_Comp(Length,Size)
	#end

#end

// CIRCULAR ENTABLATURE 
#macro E_Circular (Rad,Style,Size,Switch1,Switch2)

	#if (Style =1)
		E_Cbase_TD (Rad,Size,Switch1,Switch2)
	#end
	
	#if (Style = 2)
		E_Cbase_TD (Rad,Size,Switch1,Switch2)
		E_Cdetail_Doric (Rad,Size,Switch1)
	#end 
	
	#if (Style = 3)
		E_Cbase_ICC (Rad,Size,Switch1,Switch2)
		E_Cdetail_Ionic (Rad,Size,Switch1)
	#end 
	
	#if (Style = 4)
		E_Cbase_ICC (Rad,Size,Switch1,Switch2)
		E_Cdetail_Corinth (Rad,Size,Switch1)
	#end 
	
	#if (Style = 5)
		E_Cbase_ICC (Rad,Size,Switch1,Switch2)
		E_Cdetail_Comp (Rad,Size,Switch1)
	#end  
    
#end

// TOP PITCHING ENTABLATURE FOR THE TRIANGULAR PEDIMENT
#macro E_Base_Pediment (Length,Size)
	#local Entab1 = array[8]{<0,0.02,-0.17>,<0,0.04,-0.19>,<0,0.06,-0.21>,<0,0.135,-0.23>,<0,0.145,-0.285>,
	                          <0,0.16,-0.295>,<0,0.17,-0.305>,<0,0.21,-0.325>}
	#local Entab2 = array[8]{0,0,0,0,0,0,0,0}  
	E_Box_Loop (Entab1,Entab2,Length,Size)
#end

// COMPLETED ENTABLATURE PEDIMENT
#macro Pediment (Length,Type,Size)

	#if (Type = 1)
		E_Base_TD (Length,0,Size)
		E_Base_TD (0,1,Size)
		object {union {E_Base_TD (0,1,Size)} scale <-1,1,1> translate <Length,0,0>}     
	#end
	
	#if (Type = 2)
		E_Base_TD (Length,0,Size)
		E_Base_TD (0,1,Size)
		object {union {E_Base_TD (0,1,Size)} scale <-1,1,1> translate <Length,0,0>}     
		E_Detail_Doric(Length,Size)
	#end
	
	#if (Type = 3) 
		E_Base_ICC (Length,0,Size)
		E_Base_ICC (0,1,Size)
		object {union {E_Base_ICC (0,1,Size)} scale <-1,1,1> translate <Length,0,0>}     
		E_Detail_Ionic(Length,Size)
	#end
	
	#if (Type = 4) 
		E_Base_ICC (Length,0,Size)
		E_Base_ICC (0,1,Size)
		object {union {E_Base_ICC (0,1,Size)} scale <-1,1,1> translate <Length,0,0>}     
		E_Detail_Corinth(Length,Size)
	#end
	
	#if (Type = 5) 
		E_Base_ICC (Length,0,Size)
		E_Base_ICC (0,1,Size)
		object {union {E_Base_ICC (0,1,Size)} scale <-1,1,1> translate <Length,0,0>}     
		E_Detail_Comp(Length,Size)
	#end

	#local Top_Ped =
	union {
		E_Base_Pediment (Length,Size) 
		#if (Type = 3)
			object {union {E_Detail_Ionic(Length,Size)} translate (<0,-.39,0> * Size)}
		#end
		#if (Type = 4)
			object {union {E_Detail_Corinth(Length,Size)} translate (<0,-.39,0> * Size)}
		#end
		#if (Type = 5)
			object {union {E_Detail_Comp(Length,Size)} translate (<0,-.39,0> * Size)}
		#end
	}
	
	#local Top_Ped2 =
	difference {
		object {Top_Ped rotate <0,0,25> translate (<-.236,.41,0> * Size)}
		box {(<10,.6,10> * Size),(<-10,-10,-10> * Size)}
		box {<(Length / 2),100,100><100,-100,-100>}
	}
	
	object {Top_Ped2}   
	object {Top_Ped2 scale <-1,1,1> translate <Length,0,0>}
		
    triangle {(<0,.6,-.1> * Size),<(Length / 2),((Length / 4) + (.6 * Size)),(-.1 * Size)>,<Length,(.6 * Size),(-.1 * Size)> texture{T_Entab2}}
    
#end

// entablature arch set

#macro E_Arch_Loop (Entab1,Rad,Size)

	#local Loops = dimension_size(Entab1,1);
	#local Count1 = 0;   
	#local Rad1 = Rad;
	#while (Count1 < Loops)  
	
		#local Point1 = Entab1[Count1];
		#local Zcord = (Point1.y * Size);
		#local Rad2 = (Rad + (-Point1.z * Size));
		
		difference {
			cylinder {<0,0,0><0,0,-Zcord>,Rad2 texture{T_Entab1}}
			cylinder {<0,0,10><0,0,-10>,Rad1 texture{T_Entab1}}
		} 
		
		#local Rad1 = Rad2;
		#local Count1 = (Count1 + 1);
	#end

#end

#macro E_Base_Pediment_Arch (Rad,Size)
	#local Entab1 = array[8]{<0,0.02,-0.17>,<0,0.04,-0.19>,<0,0.06,-0.21>,<0,0.135,-0.23>,<0,0.145,-0.285>,
	                          <0,0.16,-0.295>,<0,0.17,-0.305>,<0,0.21,-0.325>}
	E_Arch_Loop (Entab1,Rad,Size)
#end

// simple arch

#macro E_Arch_One (Origin,Rad,Size)

	object {
		difference { 
			union {
				E_Base_Pediment_Arch (Rad,Size)
			}
			box {<200,0,200><-200,-200,-200> texture{T_Entab1}}
		} 
		translate Origin
	}

#end

// EOF