// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3.1
// Desc: ROUND TEMPLE MACRO
// Date: DEC 98
// Auth: Nathan O'Brien
// Mail: no13@no13.net
// Webp: www.no13.net
// Copyright: (C) Nathan G B O'Brien 1998      

// THE STANDARD ROUND TEMPLE   

#include "T_Temple.inc" 

// The steps

#macro RT_Steps (Rad,Size)

	#local Rad1 = (Rad + (.25 * Size));
	#local Rad2 = (Rad1 + .3);
	#local Rad3 = (Rad2 + .3);
	
	cylinder {<0,0,0><0,.2,0>,Rad3 texture{T_Templ1}}
	cylinder {<0,.2,0><0,.4,0>,Rad2 texture{T_Templ1}}
	cylinder {<0,.4,0><0,.6,0>,Rad1 texture{T_Templ1}}
	
	torus {Rad3,.025 sturm translate <0,.175,0> texture{T_Templ1}}
	torus {Rad2,.025 sturm translate <0,.375,0> texture{T_Templ1}}
	torus {Rad1,.025 sturm translate <0,.575,0> texture{T_Templ1}}

#end

// ARRAY A COLUMN ABOUT A RADIUS

#macro RT_Array (Quantity,Rad,Size,Style,Type,Origin,Offset)

	#if (Type = 1)	// Round Column
		#local Temp_Column = union { Classic_Column (Origin,Style,Size) }
	#end
	#if (Type = 2) // Square Column
		#local Temp_Column = union { S_Classic_Column (Origin,Style,Size) }
	#end
	
	// calculate offset angle
	#local Of_Angle = (360 / ((2 * pi * Rad) / (.5 * Size)));
	// calculate rotate angle
	#local R_Angle = (360 / Quantity);
	
	// array the column
	#local Count1 = 0;
	#while (Count1 < Quantity)
		object {Temp_Column translate <0,0,Rad>
			#if (Offset = 1) rotate <0,Of_Angle,0> #end
			rotate <0,(R_Angle * Count1),0>
		}
		#local Count1 = (Count1 + 1);
	#end

#end

// Round Temple

#macro RT_Main (Quantity,Space,Style,Size,Dome)

	#local Dia = (Size * .5);
	#if (Space = 1)			// standard spacing
		#local Cdist = (Dia * 2.25);
	#end
	#if (Space = 2)  		// wide spacing
		#local Cdist = (Dia * 3);
	#end 
	#if (Space = 3)			// double columns NOT YET IMPLEMENTED
		#local Cdist = (Dia * 4);
	#end
	#local Angle = ((2 * pi) / Quantity);
	#local Main_Rad = ((Cdist / 2) / (sin (Angle / 2)));  
	
	RT_Steps (Main_Rad,Size)
	// lower columns
	RT_Array (Quantity,Main_Rad,Size,Style,1,<0,.6,0>,0) 
	#if (Space = 3) 
		RT_Array (Quantity,Main_Rad,Size,Style,1,<0,.6,0>,1)
	#end
	       
	// lower entablature	       
    #if (Style = 1) #local NH1 = ((2.2 * Size) + .6); #end  
	#if (Style = 2) #local NH1 = ((2.4 * Size) + .6); #end
	#if (Style = 3) #local NH1 = ((2.6 * Size) + .6); #end
	#if (Style = 4) #local NH1 = ((2.8 * Size) + .6); #end
	#if (Style = 5) #local NH1 = ((3.2 * Size) + .6); #end

	#local First_Entab = union {E_Circular (Main_Rad,Style,Size,0,0)}
	object {First_Entab translate <0,NH1,0>}   
	
	// Next level of columns
	
	#local NH2 = (NH1 + (.6 * Size));
	#local Size2 = (Size * .8);
	#local Dia2 = (Size2 * .5);
	#if (Space = 1)			// standard spacing
		#local Cdist2 = (Dia2 * 2.25);
	#end
	#if (Space = 2)  		// wide spacing
		#local Cdist2 = (Dia2 * 3);
	#end 
	#if (Space = 3)			// double columns NOT YET IMPLEMENTED
		#local Cdist2 = (Dia2 * 4);
	#end
	#local Main_Rad2 = ((Cdist2 / 2) / (sin (Angle / 2))); 
	
	#local Style2 = (Style - 1);
	#if (Style2 < 1) #local Style2 = 1; #end
	
	// balustrade ring
	
	BL_Circular (Main_Rad,Style,<0,NH2,0>)
	
	// upper columns
	RT_Array (Quantity,Main_Rad2,Size2,Style2,2,<0,NH2,0>,0) 
	#if (Space = 3) 
		RT_Array (Quantity,Main_Rad2,Size2,Style2,2,<0,NH2,0>,1)
	#end 
	
	#if (Style2 = 1) #local NH3 = ((2.2 * Size2) + NH2); #end  
	#if (Style2 = 2) #local NH3 = ((2.4 * Size2) + NH2); #end
	#if (Style2 = 3) #local NH3 = ((2.6 * Size2) + NH2); #end
	#if (Style2 = 4) #local NH3 = ((2.8 * Size2) + NH2); #end
	
	
	// mid building element
	
	cylinder {<0,.6,0><0,NH3,0>,(Main_Rad2 - .1) texture{T_Templ7}}
	#local Count1 = 0;
	#local Qty2 = int(NH3 / .7);
	#while (Count1 < Qty2)
		cylinder {<0,.6,0><0,1.2,0>,Main_Rad2 translate <0,(.7 * Count1),0> texture{T_Templ6}}
		#local Count1 = (Count1 + 1);
	#end  
	
	// TOP ENTANBLATURE
	
	#local Second_Entab = union {E_Circular (Main_Rad2,Style2,Size2,0,0)}
	object {Second_Entab translate <0,NH3,0>}  
	
	// THE DOME    
	
	#local NH4 = (NH3 + (.6 * Size2));

	#if (Dome = 1)	
		DM_One (Main_Rad2,<0,NH4,0>) 
	#end 
	#if (Dome = 2)	
		DM_Two (Main_Rad2,<0,NH4,0>) 
	#end
	  
#end 

// EOF