/*camera {
location  <0, 10, -20>*.25*.675
look_at <0,0,0>
}

light_source {<500,500,-100> rgb 2}
//background {rgb <.5,.3,.2>}
//Any number 
#declare ERand = 364562;
//How Animated is the Explosion? (How turbulent?)
#declare EAnimate = 3;
//Self explanitory
#declare EClock = clock;
//Leave this alone, unless you know what you're doing.
#declare EIntensity = (1-EClock)*.25;
*/
//The Explosion
#macro Explosion (EX,EY,EZ,ERand,EAnimate,ERadius,EClock,EDetail,EShock)
#declare ERand = seed(ERand)
#declare ERand = rand(ERand)
#local EIntensity = (1-EClock)*.25;
union {
sphere {0, 1 hollow on
pigment { rgbt 1}
interior {
media{
intervals 25*EDetail
samples 1,1
variance 1/100
confidence .9
emission <1,.5,0>*EIntensity/ERadius  
//absorption <0,.5,1>*EIntensity/ERadius*.5
density { spherical
color_map{
[0 rgb 0]
[0.124 rgb 0]
[0.125 rgb 4]
[1.0 rgb 1]
}
translate (-2*EAnimate)*EClock*y
warp {turbulence .5}
translate (2*EAnimate)*EClock*y
rotate ERand+6787
}
density { spherical
color_map{
[0 rgb 0]
[.249 rgb 0]
[0.25 rgb -5*EClock+6]
[1.0 rgb 1]
}
translate (1*EAnimate)*EClock*z
warp {turbulence .5 }
translate (-1*EAnimate)*EClock*z
rotate 323456*ERand+567567
}

density { bozo
color_map{
[0 rgb 0]
[0.2*clock+.0001 rgb 0]
[-.2*clock+.0001 rgb 1]
[1.0 rgb 1]}
scale .125
translate (1*EAnimate)*EClock
warp {turbulence .25 omega .1}
translate (-1*EAnimate)*EClock
rotate 346456*ERand
}

density { bozo
color_map{
[0 rgb 0]            
[0.2*clock+.0001 rgb 0]
[-.2*clock+.0001 rgb 1]
[1.0 rgb 1]
}
scale .125/1.5
translate (-1*EAnimate)*EClock
warp {turbulence .25 omega .125}
translate (1*EAnimate)*EClock
rotate 346456*ERand
}
}

#if (EClock < .5)
media{
emission <1,1,.5>*2*EIntensity/ERadius
//absorption <0,0,.5>*EIntensity/ERadius*.5
density { spherical
color_map{
[0 rgb 0]
[0.5 rgb 5]
[1.0 rgb 15]
}

translate (-5*EAnimate)*EClock*x
warp {turbulence 1 }
translate (5*EAnimate)*EClock*x
rotate ERand-126787
}
scale -.5*EClock+.5
}
#end
}
scale 1.5*EClock+.5
}
//Glow around the explosion
sphere {0, 1 hollow on
pigment { rgbt 1}
interior {
media{
emission <1,.5,0>*EIntensity/ERadius
density { spherical
color_map{
[0 rgb 0]
[1.0 rgb 2]
}
}
}
}
scale 1
scale 1*EClock+1
}
#if (EClock <= .5)
#if (EShock = on)
#local EClock = EClock*2 
disc {<0,0,0>, y, 1.5
pigment {
onion
pigment_map {
[0 color rgbt <1,.5,0,1>]
[.15*EClock+0.5 color rgbt <1,.375,0,1>]
[.95 bozo color_map {[0 rgbt <1,1,0,1*EClock>]
[1 rgbt <1,.5,0,1*EClock>]}
turbulence 1 scale .0675 translate <0,.75*EClock,0>]
[1 color rgbt <1,.5,0,1>]
}
translate <0,-.25*EClock,0>
}
finish {
ambient 3
diffuse 0
}
no_shadow hollow
rotate 43567*ERand
scale 15*EClock+.1
scale .25
}
#end
#end
scale ERadius
translate <EX,EY,EZ>
}
#end
//Explosion (EX,EY,EZ,ERand,EAnimate,ERadius,EClock,EDetail,EShock)
//#declare Clock = pow(clock,.5);
//Explosion (0,0,0,3789789-0907,1,1,.5,1,off)
/*global_settings {
max_trace_level 20
}*/
