#include "colors.inc"
light_source {< -200, 200, -186 >
color rgb 1.5
//area_light <0,30,0>, <30,0,0>,3, 3
//adaptive 1
spotlight
point_at <0,0,0>
radius 500
falloff 750
}
light_source{<500,1500,1000>color rgb <1,.675,0>
//area_light <0,25,0>, <25,0,0>,3, 3
//adaptive 1
spotlight
point_at <0,0,0>
radius 500
falloff 750
}
camera { location <0,50,-90>*5 look_at <0,50,0> angle 80/4}
//camera { location <0,65,-90>*4 look_at <0,65,0> angle 25/4}

#macro Marine (RandM,
               UArmRot1,
               UArmRot2,
               LArmRot1,
               LArmRot2,
               ULegRot1,
               ULegRot2,
               LLegRot1,
               LLegRot2,
               Hight,R,G,B,
               Gender,
               HeadRot,
               GunPos,
               GunFire,
               GunFlame,
               Lights               
               )

#local COLOR = <R,G,B>
/*
#local UArmRot1 = <0,0,20>//<UAR1X,UAR1Y,UAR1Z>
#local UArmRot2 = <0,0,20>//<UAR2X,UAR2Y,UAR2Z>
                     
#local LArmRot1 = <0,0,0>//<LAR1X,LAR1Y,LAR1Z>
#local LArmRot2 = <0,0,0>//<LAR2X,LAR2Y,LAR2Z>


#local ULegRot1 = <0,0,-10>//<ULR1X,ULR1Y,ULR1Z>
#local ULegRot2 = <0,0,-10>//<ULR2X,ULR2Y,ULR2Z>

#local LLegRot1 = <0,0,0>//<LLR1X,LLR1Y,LLR1Z>
#local LLegRot2 = <0,0,0>//<LLR2X,LLR2Y,LLR2Z>
*/



/*
#declare TrooperClock = clock
#declare TrooperWalkingStart = -0.00001
#declare TrooperWalkingEnd = 1
#declare TrooperWalkingLoop = 1

#declare TrooperWalkingClock = mod((TrooperClock - TrooperWalkingStart)*TrooperWalkingLoop/(TrooperWalkingEnd - TrooperWalkingStart), 1)

#declare ULegClock1 = sin((TrooperWalkingClock-.25)*2*pi)//sin(TrooperWalkingClock*2*pi)
#declare ULegClock2 = 1 - sin((TrooperWalkingClock-.25)*2*pi)

#declare ULegRot1 = <10-ULegClock1*20,0,0>
#declare ULegRot2 = <10-ULegClock2*20,0,0>

#declare LLegClock1 = 1-sin((TrooperWalkingClock-.25)*2*pi)
#declare LLegClock2 = sin((TrooperWalkingClock-.25)*2*pi)  

#declare LLegRot1 = <-LLegClock1*20,0,0>
#declare LLegRot2 = <-LLegClock2*20,0,0>
*/


#declare Grip1 = <0,-32,0>
#declare Grip1 = vrotate(Grip1,LArmRot1)
#declare Grip1 = vrotate(Grip1,UArmRot1)
#declare Grip1 = Grip1+<13,8.5,0>

#declare Grip2 = <0,-30,0>
#declare Grip2 = vrotate(Grip2,LArmRot2)
#declare Grip2 = vrotate(Grip2,UArmRot2)
#declare Grip2 = Grip2+<-13,8.5,0>
 
#declare GunAxis = (Grip1-Grip2)//*<1, 1, 1>
#declare GunRotX = degrees(atan2(vlength(GunAxis*<1, 0, 1>),GunAxis.y))
#declare GunRotY = degrees(atan2(GunAxis.x,GunAxis.z))


#declare X_Tex =
texture {
pigment {rgb .125}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25/3 phong_size 1 metallic}
}  
texture {
pigment {bozo color_map {
[0 rgb .35]
[.8 rgb .5]
[.8 rgb .1 transmit 1]
[1 rgb .1 transmit 1]
}
scale <1,4,1> rotate 45}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25/3 phong_size 10 metallic}
translate RandM
}  
texture {
pigment {bozo color_map {
[0 rgb .25 transmit .25]
[1 rgb .75 transmit 1]
}
scale 2.5 rotate 45}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25/3 phong_size 10 metallic}
translate RandM
}
texture {
pigment {bozo color_map {
[0 rgb <.25,.125,0> transmit .5]
[1 rgb .75 transmit 1]
}
scale <2,10,2>*2 rotate -45}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25/3 phong_size 10 metallic}
translate RandM
}  

#declare X_Tex2 =
texture {
pigment {bozo color_map {
[0 rgb COLOR]
[.5 rgb COLOR]
[.9 rgb COLOR*.375]
[.925 rgb .75]
[1 rgb .75]
}
scale 5
}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25 phong_size 10 metallic}
}  

#declare BloodType =
texture {
pigment {image_map {gif "bldtypab" once transmit 1, 1}}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25 phong_size 10 metallic}
scale <8,4,1>
translate <4,2.5,0>
}
#declare MajorLAnders =
texture {
pigment {image_map {gif "mjrladrs" once transmit 1, 1}}
normal {bumps scale .25 bump_size .06125}
finish {ambient .1  diffuse .75 phong .25 phong_size 10 metallic}
scale <8,4,1>
translate <-11.5,2.5,0>
}
#declare B_Tex =
texture {pigment {rgb 0}}
texture {pigment{gradient z color_map{
[0 rgb Clear]
[.5 rgb Clear]
[.5 rgb COLOR]
[1 rgb COLOR]
}
translate -1.675*z
scale 20
scale <1,1,-1>
translate .5
scale <1/11,1/11,1>
translate <-17,-12,0>
}
} 
#declare B_Tex2 =
texture {pigment {rgb 1}}
texture {pigment{gradient z color_map{
[0 rgb Clear]
[.5 rgb Clear]
[.5 rgb COLOR]
[1 rgb COLOR]
}
translate -1.675*z
scale 20
scale <1,1,-1>
translate .5
scale <1/11,1/11,1>
translate <-17,-12,0>
}
}


#declare ClanBird = 
texture {
material_map {gif "idnums" once //transmit 1,1
texture {X_Tex2}
texture {B_Tex}
texture {B_Tex2}
}
translate -.5
scale <10,5,1>
translate <17,11,0>
}
 
#declare IDNumbers =
texture {
material_map {gif "birdopry" once //transmit 1,1
texture {X_Tex2}
texture {B_Tex}
texture {B_Tex2}
}
translate -.5
scale <10,10,1>
translate <-17,11,0>
}


#declare A_Tex =
texture {
pigment {rgb .25}
normal {bumps scale .25 bump_size .125}
finish {ambient .1  diffuse .75 phong .5 phong_size 10 metallic}
translate RandM
}  
texture {
pigment {bozo color_map {
[0 rgb <.15,.15,.125>*.5]
[.9 rgb <.15,.15,.125>]
[.9 rgb <.15,.15,.125> transmit 1]
}
turbulence .5
scale <1,4,1>*2 rotate 45}
normal {bumps scale .375 bump_size .25}
finish {crand .01 ambient .2  diffuse .75 phong 1 phong_size 10 metallic}
translate RandM
}  

#declare H_Tex =
texture {
pigment {rgb <.25,.15,.125>*.5}
normal {bumps scale .25 bump_size .5}
finish {crand .01 ambient .25  diffuse .75 phong .9 phong_size 1 metallic}
}
#declare RBox2 =
superellipsoid {
<.375, .375>
translate <1,1,1>
scale .5
}
#declare DensMap = density {
        radial  rotate y*90 translate z*-5
        translate <0,0,-15*clock>
        warp {turbulence 0.8 octaves 3 lambda 2.5}
        translate <0,0,15*clock>
        scale <1,1,1> 
        colour_map {
                [0.49 rgb 0]
                [0.495 rgb 1]
                [0.5 rgb 4]
                [0.505 rgb 1]
                [0.51 rgb 0]
        }
}
#declare ColMap = density {
        radial rotate y*90 translate z*-5
        translate <0,0,-15*clock>
        warp {turbulence 1.2 octaves 3 lambda 2.5}
        translate <0,0,15*clock>
        scale <1,1,1> 
        colour_map {
                [0.495 Yellow]
                [0.5 White]
                [0.505 Yellow]
        }
}
#declare DensEnding = density {
        spherical scale 10
        colour_map {
                [0 rgb 0*<1,0,0>]
                [0.5 rgb <1,.5,0>*.5]
                [.75 rgb <1,1,0>] 
                [.875 rgb 1] 
                [1 rgb <-1,0,1>]
        }
}

#declare DensMap2 = density {
        radial rotate y*90 translate z*-3
        translate <0,0,-25*clock>
        warp {turbulence 1.3 octaves 3 }
        translate <0,0,25*clock>
        scale <1,1,1>
        colour_map {
                [0.45 rgb 0]
                [0.48 rgb 0.4]
                [0.5 rgb 1]
                [0.52 rgb 0.4]
                [0.55 rgb 0]
        }
}
#declare ColMap2 = density {
        radial rotate y*90 translate z*-3
        translate <0,0,-25*clock>
        warp {turbulence 1.3 octaves 3 }
        translate <0,0,25*clock>
        scale <1,1,1>
        colour_map {
                [0.47 Red]
                [0.5 Orange]
                [0.53 Red]
        }
}
#declare DensEnding2 = density {
        spherical scale <5,5,10>
        translate <0,0,-15*clock>
        warp {turbulence 0.5}
        translate <0,0,15*clock>
        colour_map {
                [0 rgb 0]
                [0.1 rgb 1]
                [.875 rgb 1] 
                [1 rgb <-1,-1,1>]
        }
}

#declare FlameThrower =
union {
cylinder {
        0,z*10,3
                      
        pigment {Clear}
        hollow
        interior {
                media {
                        emission 1/6
                        intervals 20
                        samples 1, 5
                        confidence 0.99
                        variance 1/100
                        density {ColMap}
                        density {DensMap}
                        density {DensMap rotate z*90}
                        density {DensEnding}
                scale .8
                }
                media {
                        emission .75/6
                        intervals 15
                        samples 1,5                        
                        confidence 0.999
                        variance 1/100
                        density {ColMap2}
                        density {DensMap2}
                        density {DensMap2 rotate z*90}
                        density {DensEnding2}
                scale .8
                }
        
        }
        scale <3,3,3>/.8*1.25
}
cylinder {
        0,z*10,3
                      
        pigment {Clear}
        hollow
        interior {
                media {
                        absorption rgb .675/5
                        //scattering { 2, rgb .5 extinction 1 }                        
                        density {bozo
                        translate <0,0,-5*clock>
                        warp {turbulence 0.2 octaves 1 lambda .5}
                        translate <0,0,5*clock> 
                        scale <1,1,1/3>*.75                        
                        color_map {
                        [0 rgb 0]
                        [1 rgb 1]         
                        }
                        }
                        density {
                        spherical scale <5,5,10>
                        translate <0,0,-5*clock>
                        warp {turbulence 0.5}
                        translate <0,0,5*clock>
                        color_map {
                        [0 rgb 0]
                        [1 rgb 1]         
                        }
                        }
                scale .8
                }
        }
        scale <.875,.875,2>/.8*1.25
        rotate -x*10
        translate <0,0,20>
}
#declare R1 = seed(clock)
light_source {<0,0,0+int(rand(R1)*5)> rgb <1,1,0>/1.5 fade_distance 20 fade_power 2}
light_source {<0,0,2.5+int(rand(R1)*5)> rgb <1,.75,0>/1.5 fade_distance 20 fade_power 2}
light_source {<0,0,5+int(rand(R1)*5)> rgb <1,.5,0>/1.5 fade_distance 20 fade_power 2}
light_source {<0,0,7.5+int(rand(R1)*5)> rgb <1,.25,0>/1.5 fade_distance 20 fade_power 2}
light_source {<0,0,10+int(rand(R1)*5)> rgb <1,0,0>/1.5 fade_distance 20 fade_power 2}
light_source {<0,0,12.5+int(rand(R1)*5)> rgb <.5,0,0>/1.5 fade_distance 20 fade_power 2}
light_source {<0,0,15+int(rand(R1)*5)> rgb <.5,.25,.25>/2 fade_distance 20 fade_power 2}
scale 4
}





#declare Helmet =
//Objecttype:Composite
//Name:group#1
object
{
union
{
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Torus
//Name:NoName
object
{
torus{9.375,0.125}

scale<1,5,1>
rotate<95,0,0>
translate<0,12.5,-7>
}
//Objecttype:Box
//Name:NoName
object
{
box{<0,0,0>,<1,1,1>}

scale<2.5,20,4.25>
translate<-1.25,2.75,-9>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<-18.113,0,0>
translate<0,13,-7>
}
}
texture {X_Tex}
}
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Torus
//Name:NoName
object
{
torus{9,0.25}

scale<1,4,1>
rotate<95,0,0>
translate<0,12.5,-7>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<-18.113,0,0>
translate<0,12.5,-7>
}
}
}
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Union
//Name:'or'
object
{
merge
{
//Objecttype:Torus
//Name:NoName
object
{
torus{8.5,0.125}

scale<1,3,1>
rotate<85,0,0>
translate<0,12.5,-7>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{8.5,0.125}

scale<1,3,1>
rotate<75,0,0>
translate<0,12.5,-7>
}
}
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<-18.113,0,0>
translate<0,12.5,-7.25>
}
}
}
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<9,9,12.75>
translate<0,12.75,-7>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<8.75,8.75,11.75>
translate<0,12.75,-7>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<95.012,0,0>
translate<0,18.25,-6.25>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<-41.563,0,0>
translate<0,14.75,-2>
}
}
}
}
scale <1,1.25,1>
texture {A_Tex}
}
#declare BreastPlate =
difference {
blob { threshold .01
sphere{<0,0,0>,1,.5
scale <20,30,20>
}
sphere{<0,0,0>,1,-.6
scale <19.375,29,19>
}
cylinder{<0,0,0>,<0,1,0>,1, -.025
scale <6,47,6>
rotate <90,0,0>
translate <4,12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.025
scale <6,47,6>
rotate <90,0,0>
translate <2,12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.025
scale <6,47,6>
rotate <90,0,0>
translate <0,12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,0,0>
translate <-8.8818e-16,29,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-2.4148e-06,86.861>
translate <29,-1,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,0,-6.2952>
translate <3,-21,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-1.7075e-06,45.833>
translate <25,-12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-2.4148e-06,86.861>
translate <-17,5,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-1.7075e-06,139.97>
translate <25,22,-22>
} 
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<6,47,10>
rotate<90,0,0>
translate<16.5,10,-22>
}
sturm
}
plane {-z,0}
}
#declare BreastPlateB =
difference {
blob { threshold .01
sphere{<0,0,0>,1,.5
scale <20,30,20>
}
sphere{<0,0,0>,1,-.625
scale <19.375,29,19>
}
cylinder{<0,0,0>,<0,1,0>,1, -.025
scale <7,47,7>
rotate <90,0,0>
translate <4,12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.025
scale <7,47,7>
rotate <90,0,0>
translate <2,12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.025
scale <7,47,7>
rotate <90,0,0>
translate <0,12,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,0,0>
translate <0,29,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,0,86.861>
translate <29,-1,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,0,-6.2952>
translate <4,-21,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-1.7075e-06,45.833>
translate <26,-13,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-2.4148e-06,86.861>
translate <-19,5,-22>
}
cylinder{<0,0,0>,<0,1,0>,1, -.25
scale <64,47,17>
rotate <90,-1.7075e-06,139.97>
translate <27,22,-22>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<6,47,10>
rotate<90,0,0>
translate<17,10,-22>
}
texture {A_Tex}
sturm
}
plane {-z,0}
translate <0,0,2>
}

#declare NeckRing=
blob{ threshold .01
sphere{<0,0,0>,1, 1
scale <9,20,8>
translate <0,9,-9>
}
sphere{<0,0,0>,1, 1
scale <10,20,11>
translate <0,9,-6>
}
sphere{<0,0,0>,1, -2
scale <8.5,19,7.5>
translate <0,9,-9>
}
sphere{<0,0,0>,1, -2
scale <9.5,19,10.5>
translate <0,9,-6>
}
cylinder{<0,0,0>,<0,1,0>,1,-1.5
scale <11,24,47.899>
rotate <0,-22.927,-90>
translate <-12,24,-12>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale <11,24,47.899>
rotate <0,-22.927,-90>
translate <-12,24,-12>
}
texture {A_Tex}
sturm
scale <1.1,1.25,1>
}
#declare FrontPlateJunk =
union {
//Objecttype:Composite
//Name:group#1
object
{
union
{
//Objecttype:Intersection
//Name:'and'
object
{
difference 
{
//Objecttype:Paraboloid
//Name:NoName
object
{
object{quadric{<1,0,1>,<0,0,0>,<0,-1,0>,0}clipped_by{plane{<0,1,0>,1}}}

scale<3.5,4,12>
rotate<95.906,0,0>
translate<0,6,-22>
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<35,1,20>
rotate<5.9061+180,0,0>
translate<0,6,-22>
}
}
}
//Objecttype:Paraboloid
//Name:NoName
object
{
object{quadric{<1,0,1>,<0,0,0>,<0,-1,0>,0}clipped_by{plane{<0,1,0>,1}}}

scale<3.5,4,4>
rotate<95.906,0,0>
translate<0,6,-22>
}
}
}
union {
blob{ threshold.1
cylinder{<0,0,0>,<0,1,0>,1,2
scale<1.35,2,1.35>
rotate<90,0,0>
translate<4,1,-18.25>
}
cylinder{<0,0,0>,<0,1,0>,1,-1.25
scale<0.75,3,0.75>
rotate<90,0,0>
translate<3.5,1,-19.75>
}
}
blob{threshold.1
cylinder{<0,0,0>,<0,1,0>,1,2
scale<1.35,2,1.35>
rotate<110.43,-19.654,0>
translate<11.815,7.349,-18.133>
}
cylinder{<0,0,0>,<0,1,0>,1,-1.25
scale<0.75,3,0.75>
rotate<110.43,-19.654,0>
translate<11.973,7.5235,-18.574>
}
translate <-.75,0,4>
}
texture {A_Tex}
}
}
#declare ShoulderPad =
union {
blob { threshold .1
sphere{<0,0,0>,1,1
scale 8.5
translate<19,12.75,-6.5>
} 
sphere{<0,0,0>,1,-4
scale 6.75
translate<19,12.75,-6.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -4
scale<51.75,20,9.75>
rotate<90,0,0>
translate<19,2.25,-16>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<11,24,85.208>
rotate<0,-67.544,-90>
translate<8,24,-20>
}
cylinder{<0,0,0>,<0,1,0>,1, -1
scale<11,24,85.208>
rotate<-180,-79.031,90>
translate<8,20,9>
}
cylinder{<0,0,0>,<0,1,0>,1,-.25
scale<5,20,39.475>
rotate<90,0,-7.5>
translate<10.5,20,-16>
}
cylinder{<0,0,0>,<0,1,0>,1,-.25
scale<5,20,39.475>
rotate<90,0,-7.5>
translate<9.5,20,-16>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<5,20,39.475>
rotate<90,1.2074e-06,-24.824>
translate<29,12.5,-16>
} 
cylinder{<0,0,0>,<0,1,0>,1,-2
scale < 11, 24, 85.208 >
rotate < 180, 0, 90 >
translate < 8, 30, -7 >
}
sturm
translate <-12,-12,0>
rotate -10*z
rotate -5*x
translate <12,12,0>
scale 1.175
translate <-5.5,-3.5,0>
}
blob { threshold .1
sphere{<0,0,0>,1,1
scale 8.5
translate<19,12.75,-6.5>
} 
sphere{<0,0,0>,1,-4
scale 6.75
translate<19,12.75,-6.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -4
scale<51.75,20,9.75>
rotate<90,0,0>
translate<19,2.25,-16>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<11,24,85.208>
rotate<0,-67.544,-90>
translate<8,24,-20>
}
cylinder{<0,0,0>,<0,1,0>,1, -1
scale<11,24,85.208>
rotate<-180,-79.031,90>
translate<8,20,9>
}
cylinder{<0,0,0>,<0,1,0>,1,-.25
scale<5,20,39.475>
rotate<90,0,-7.5>
translate<10.5,20,-16>
}
cylinder{<0,0,0>,<0,1,0>,1,-.25
scale<5,20,39.475>
rotate<90,0,-7.5>
translate<9.5,20,-16>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<5,20,39.475>
rotate<90,1.2074e-06,-24.824>
translate<29,12.5,-16>
} 
cylinder{<0,0,0>,<0,1,0>,1,-2
scale < 11, 24, 85.208 >
rotate < 180, 0, 90 >
translate < 8, 30, -7 >
}
sturm
texture {A_Tex}
translate <-12,-12,0>
rotate -10*z
rotate -5*x
translate <12,12,0>
scale 1.15
translate <-4,-4.75,0>
}
}
#declare WSheath =
blob { threshold .1
sphere{<0,0,0>,1,1
scale<5,30,4>
translate<9.5,11.5,2>
}
sphere{<0,0,0>,1,-.9
scale<4.5,29,3.5>
translate<9.5,14.5,2>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<20,20,20>
rotate<0,0,-90>
translate<1,35,12>
}
sturm   
translate <-9.5,-4,0>
scale <1.5,1,1>
rotate <0,30,0>        
translate <9,0,0>
}

#declare LightA =
union {
torus{1,0.25
scale<1,4,1>
rotate<90,0,0>
translate<0,8.5,-16.5>
texture {A_Tex}
}
sphere{<0,0,0>,1
scale <.875,.875,0.75>
translate <0,8.5,-17>
texture {
pigment { spherical
color_map {
[0 rgb 0]  
[.06125 rgb 0] 
[1 rgb <1,.75,.45>*3]
}
}
#if (Lights = 3)
finish {ambient 0 diffuse .75 phong .5}
#else                                     
finish {ambient .575 diffuse .25 phong .5}
#end
scale 2/2
translate <0,8.5,-17>
}
#if (Lights < 3)
texture {
pigment { radial frequency 10 triangle_wave
color_map {
[0 rgb Clear]  
[.5 rgb Clear] 
[.75 rgb Clear] 
[1 rgb <1,.75,.45>*.25]
}
}
finish {ambient 0 diffuse .25 phong .5}
scale 2/2
rotate 90*x
translate <0,8.5,-17>
}               
#end
}
#if (Lights < 3)
sphere {0, 1 hollow on no_shadow
pigment {rgbt 1 }
interior {
media{
emission .15/Hight/.5
density { spherical
color_map{
[0.0 rgb <1,.75,.45>*0]
[0.675 rgb <1,.75,.45>*.25]
[1.0 rgb <1,.75,.45>*4]
}   
}
} 
}
scale <4,4,6>*.5
translate<0,8.5,-17.5>
}
light_source{<0,8.5,-18> color rgb <1,.75,.45>*.25 fade_power 2 fade_distance 12/.5*.75}
#end
scale <1.375,1.375,1>
translate <0,-2,-1.5>
}

#declare LightB =
union {
torus{1,0.25
scale<1,4,1>
rotate<90,0,0>
translate<0,8.5,-16.5>
texture {A_Tex}
}
sphere{<0,0,0>,1
scale <.875,.875,0.75>
translate <0,8.5,-16>
texture {A_Tex}
}
sphere{<0,0,0>,1
scale <.875,.875,0.75>
translate <0,8.5,-17>
texture {
pigment { spherical
color_map {
[0 rgb 0]  
[.06125 rgb 0] 
[1 rgb <1.5,1,1.25>*3]
}
}
#if (Lights = 3)
finish {ambient 0 diffuse 1 phong .5}
#else                                  
finish {ambient 1 diffuse .25 phong .5}
#end
scale 2/2
translate <0,8.5,-17>
}
#if (Lights < 3)
texture {
pigment { radial frequency 10 triangle_wave
color_map {
[0 rgb Clear]  
[.5 rgb Clear] 
[.75 rgb Clear] 
[1 rgb <1.5,1,1.25>*.25]
}
}
finish {ambient 0 diffuse .25 phong .5}
scale 2/2
rotate 90*x
translate <0,8.5,-17>
}
#end
}

#if (Lights < 3)
sphere {0, 1 hollow on no_shadow
pigment {rgbt 1 }
interior {
media{
emission .45/Hight*2
density { spherical
color_map{
[0.0 rgb <1.5,1,1.25>*0]
[0.5 rgb <1.5,1,1.25>*.06125*.125]
[0.75 rgb .06125*.5]  
[0.875 rgb .06125]
[1.0 rgb 2]
}   
}
} 
}
scale 8
translate<0,8.5,-17.5>
}
light_source{<0,8.5,-18> color rgb <1.5,1,1.125>*.5 fade_power 2 fade_distance 12/.5*.75}
#end
scale <1.375,1.375,1>
translate <0,-2,-1.5>
}






#declare WaistStuff =
union {
object
{
sphere{<0,0,0>,1}
scale<2,1,1>
rotate<0,0,8.1301>
translate<3.5,-4.5,-15>
texture {X_Tex}
}
object
{
sphere{<0,0,0>,1}
scale<2,1,1>
rotate<0,0,8.1301>
translate<3,-7,-13.75>
texture {X_Tex}
}
object
{
cylinder{<0,0,0>,<0,1,0>,1}
scale<0.5,10,0.5>
rotate<0,0,7.7175>
translate<8.5,-10.75,-7.75>
}
object
{
cylinder{<0,0,0>,<0,1,0>,1}
scale<0.5,10,0.5>
rotate<0,0,7.7175>
translate<7.25,-10.75,-7.75>
}

blob { threshold .1
sphere{<0,0,0>,1,1
scale<1.75,1.75,3.8236>
rotate<0,10.247,0>
translate<4.5,-11.75,-19>
}
sphere{<0,0,0>,1,-.5
scale<1,1,5>
translate<4,-11.75,-22.75>
}
}

blob { threshold .1
sphere{<0,0,0>,1,1
scale<1.75,1.75,3.8236>
rotate<0,10.247,0>
translate<4.5,-11.75,-19>
}
sphere{<0,0,0>,1,-.5
scale<1,1,5>
translate<4,-11.75,-22.75>
}
translate -3*y
}

texture {A_Tex}
}






#declare WaistStuffB =
union {
// Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 6.5, 1 >
         rotate < 4.185, 0, 0 >
         translate < -1.5, -15, -22.25 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 3, 3.2596, 2.7332 >
         rotate < -22.38, 0, 0 >
         translate < -1.5, -19, -20.5 >
      }
// Object type: Torus
      // Name: NoName
      object
      {
         torus { 11.25, 1 }

         translate < 0, -11, -7.75 >
      }
      // Object type: Torus
      // Name: NoName
      object
      {
         torus { 11.25, 1 }

         translate < 0, -14, -7.75 >
      }
object
{
RBox2
scale<6,20,4.5>
rotate<12.314,0,0>
translate<-3,-8.25,-2.5>
texture {X_Tex}
}
object
{
cone{<0,0,0>,1,<0,1,0>,0.5}
scale<10,6,10>
translate<0,-11.25,-7.75>
}
difference {
      // Object type: Cylinder
      // Name: NoName
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

         scale < 12.25, 8.5, 12.25 >
         translate < 0, -19.5, -7.75 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 8.5, 5, 27 >
         translate < 7, -19, -21 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 8.5, 5, 27 >
         translate < -15.5, -19, -21 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 11.5, 5, 27 >
         translate < -14, -21, -21 >
      }
      // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 11.5, 5, 27 >
         translate < 2.5, -21, -21 >
    }
   texture {X_Tex}
}
// Object type: Intersection
      // Name: 'and'
      object
      {
         intersection
         {
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 20, 6, 4.75 >
               rotate < 0, 5.5531, -90 >
               translate < -3, -13.5, -17 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 20, 24, 4.75 >
               rotate < -45, 5.5531, -90 >
               translate < -8.4853, -14.321, -8.5545 >
            }
            // Object type: Cylinder
            // Name: NoName
            object
            {
               cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1  }

               scale < 20, 24, 4.75 >
               rotate < 45, 5.5531, -90 >
               translate < -8.4853, -12.679, -25.445 >
            }
            // Object type: Box
            // Name: NoName
            object
            {
               box { < 0, 0, 0 >, < 1, 1, 1 > }

               scale < 20, 9, 15.75 >
               translate < -10, -15.5, -35 >
            }
         }
      }
      #declare Count = 0;
      #while (Count < 360)
       // Object type: Polynomial
      // Name: NoName
      object
      {
         RBox2

         scale < 0.5, 2.5, 2 >
         translate < 12, -13.75, -8.75 >
         translate 7.75*z
         rotate Count*y
         translate -7.75*z 
         texture {A_Tex}
      }
      #declare Count = Count + 20;
      #end
      
texture {X_Tex}      
}

#declare UpperLeg =
union {
object{ RBox2
scale<9.5,20,10>
translate<-12,-20,-6>
}
sphere{<0,0,0>,1
scale<3,6,3>
translate<-11,-20,-6>
}

sphere{<0,0,0>,1
scale<3,8,4>
translate<-4,-12,4>
}
sphere{<0,0,0>,1
scale<5,5,5>
translate<-7,-21,-1>
}

difference {
blob { threshold .1
cylinder{<0,0,0>,<0,1,0>,1, 4
scale<10,25,10>
translate<-8,-22,2.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -4
scale<9.875,62,9.55>            
translate<-8,-26,2.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<8.5,50,63.5>
rotate<-90,1.2074e-06,25.615>
translate<-19.5,-23.5,26.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<8.5,50,80>
rotate<-90,0,0>
translate<-23,-14.5,26.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<8.5,50,63.5>
rotate<-90,0,-8.1366>
translate<-20.5,12.5,26.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<8.5,50,109>
rotate<-90,0,90>
translate<-9,13.5,26.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<8.5,50,200>
rotate<-90,0,0>
translate<-1.5,-15,26.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<8.5,50,200>
rotate<-90,0,5>
translate<-0.5,-14,26.5>
}
cylinder{<0,0,0>,<0,1,0>,1, -2
scale<20,20,20>
rotate<-90,0,0>
translate<-11,-37.5,0>
}
texture {X_Tex}
}
plane {-z,0} 
translate <0,0,-1>
translate <10,0,5.5>
rotate 30*y
translate <-12,0,-5.5>
}
sphere{<0,0,0>,1
scale<4.5,6,6>
translate<-7,0,4>
}
sphere{<0,0,0>,1
scale<4.95,6.6,6.6>
translate<-7.2,0.5,0>
}
texture {A_Tex}
scale <1.1,1.1,1.1>
translate .5
}

#declare LowerLeg =
union {
object { RBox2
scale<11.5,27.5,11.5>
translate<-13,-50,-6>
}
blob { threshold .1
sphere{<0,0,0>,1,1
scale<6,27.5,12>*1.25
translate<-7.25,-50,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-6
scale<72.25,40,20>
rotate<-90,0,0>
translate<-7.25,-68.75,20>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<72.25,40,20>
translate<-7.25,-62.25,27.75>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<5,40,16>
rotate<-90,0,0>
translate<-7.25,-50,20>
}
texture {A_Tex}
}
blob { threshold .1
sphere{<0,0,0>,1,1
scale<5.25,12,17.5>
translate<-7.25,-56.75,-6.5>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<72.25,40,25>
rotate<-90,0,0>
translate<-7.25,-80.25,19.25>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<72.25,40,8.5>
rotate<-129.26,0,0>
translate<-7.25,-32.5,-7>
}
texture {A_Tex}
scale <1,1/1.25,1>
}

texture {X_Tex}
translate 22.6*y
scale <1,1.25,1>
}


#declare UpperArm =
union {
object { torus{3,0.25}
translate<0,-2.5,0>
}
object { torus{3,0.25}
translate<0,-2,0>
}
object { torus{3,0.25}
translate<0,-1.5,0>
}
object { torus{3,0.25}
scale<1,3,1>
translate<0,-0.5,0>
}
sphere{<0,0,0>,1
scale<3,3,3>
translate<0,0.25,0>
}
blob {threshold .1
cylinder{<0,0,0>,<0,1,0>,1, 1
scale<3.75,7.75/1.125,3>*1.125
translate<0,-10.25,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<3.75,14.5,27.25>
translate<-6.5,-12.75,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<3.75,14.5,27.25>
translate<6.5,-12.75,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<22.5,16.5,3.75>
rotate<90,0,0>
translate<0,-16.5,-7.5>
}

texture {X_Tex}
}
sphere{<0,0,0>,1
scale<2.75,2.75,2.75>
translate<0,-12.25,0>
}
texture {A_Tex}
scale 1.25
scale <1,1,1>
}
#declare LowerArm =
union {
blob {threshold .1
cylinder{<0,0,0>,<0,1,0>,1,1
scale<4.25,16.5,3.75>
translate<0,-30.25,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<200,20.718,3.75>
rotate<9.638,0,0>
translate<0,-32.5,4.5>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<200,20.718,3.75>
rotate<-2.0871,0,0>
translate<0,-32,-6.75>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<2,20.718,200>
rotate<0,0,-4.501>
translate<4.5,-32,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<2,20.718,200>
rotate<0,0,4.501>
translate<-4.5,-32,0>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<3.5,20,4.5>
rotate<90,0,0>
translate<-2.2258e-31,-12.75,-10>
}
cylinder{<0,0,0>,<0,1,0>,1,-1
scale<22.5,16.5,7.5>
rotate<90,0,0>
translate<0,-37.5,-7.5>
}
cylinder{<0,0,0>,<0,1,0>,1,-2
scale<2.5,16.5,1.5>
translate<0,-35.5,-1>
}
cylinder{<0,0,0>,<0,1,0>,1, -1
scale<3.75,7.75/1.125,3>*1.125
translate<0,-8,0>
}

}
object {RBox2
scale<2,3.505,1.2749>
rotate<-3.0631,0,0>
translate<-1,-29,-3.5>
}
object {RBox2
scale<2,5.4921,1.2749>
rotate<-3.0631,0,0>
translate<-1,-22.75,-3.75>
}
object {RBox2
scale<4,4.9011,0.76229>
rotate<10.973,0,0>
translate<-2,-31.5,0.5>
}
texture {X_Tex}        
scale <1.1,1,1> 
translate 16.75*y
translate -4*y
}
#declare TrooperGun =
//Objecttype:World
//Name:Root
object
{
union
{
//Objecttype:Cylinder
//Name:NoName
object
{
cylinder{<0,0,0>,<0,1,0>,1 open}

scale<1,55,1>
translate<0,-5,-2>
}
//Objecttype:Cylinder
//Name:NoName
object
{
cylinder{<0,0,0>,<0,1,0>,1 open}

scale<2,53.5,2>
translate<0,-5,1>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{1.75,0.25}

translate<0,48.5,1>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{1.75,0.25}

translate<0,49,1>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{0.75,0.25}

scale<1,4,1>
translate<0,50,-2>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<5,14,7>
translate<-2.5,-5.5,-3.5>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<4,29.5,1>
translate<-2,8.5,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<2,2,2>
translate<4.5,5.5,0>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<2,2,2>
translate<4.5,-3.5,0>
}
//Objecttype:Cylinder
//Name:NoName
object
{
cylinder{<0,0,0>,<0,1,0>,1 open}

scale<2,9,2>
translate<4.5,-3.5,0>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<4,9,1>
translate<-2,-5,3>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<2,4.5,3.5>
translate<-1,-4.5,3.5>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<1,0.23717,2.0555>
rotate<18.435,0,0>
translate<-0.5,2.75,3.75>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<1,0.20218,3.0511>
rotate<53.973,0,0>
translate<-0.5,2.25,5.5>
}
//Objecttype:Polynomial
//Name:NoName
object
{
RBox2

scale<0.75,0.31247,2.0586>
rotate<-17.103,0,0>
translate<-0.375,0.25,3.75>
}
//Objecttype:Composite
//Name:group#1
object
{
union
{
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<1,2,2>
rotate<-10.672,0,0>
translate<0,-0.81477,13.616>
}
//Objecttype:Cylinder
//Name:NoName
object
{
cylinder{<0,0,0>,<0,1,0>,1 open}

scale<1,8,2>
rotate<79.328,0,0>
translate<0,-2.2963,5.7543>
}
}
}
//Objecttype:Composite
//Name:group#1
object
{
union
{
//Objecttype:Difference
//Name:'andnot'
object
{
difference
{
//Objecttype:Union
//Name:'or'
object
{
merge
{
//Objecttype:Torus
//Name:NoName
object
{
torus{1.5,0.5}

scale<1,2,1>
translate<0,20.75,2.5>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{1.5,0.5}

scale<1,2,1>
translate<0,22.75,2.5>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{1.5,0.5}

scale<1,2,1>
translate<0,24.75,2.5>
}
//Objecttype:Torus
//Name:NoName
object
{
torus{1.5,0.5}

scale<1,2,1>
translate<0,26.75,2.5>
}
}
}
//Objecttype:Disc
//Name:NoName
object
{
disc{<0,0,0>,<0,1,0>,1,0}

scale<20,1,20>
rotate<90,0,0>
translate<0,23.75,2.5>
}
}
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<1.5,26.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<1.5,24.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<1.5,22.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<1.5,20.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<-1.5,26.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<-1.5,22.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<-1.5,20.75,2.5>
}
//Objecttype:Sphere
//Name:NoName
object
{
sphere{<0,0,0>,1}

scale<0.5,1,0.5>
translate<-1.5,24.75,2.5>
}
}
texture {
pigment {rgb <.5,.4,.3>}
finish {ambient .1 diffuse 1 phong .125 phong_size 0}
}
translate 2*y
}
#if (GunFire)     
union {
cylinder {0,<0,1,0>,1 hollow on
pigment {Clear}
interior {
media{
intervals 20
emission 1/1.5
density { cylindrical
color_map{
[0.0 rgb <1,0,0>*0]
[.5 rgb <1,.25,0>*.25]
[.875 rgb <1,.75,0>*.375]
[1.0 rgb <1,1,0>*2]
}
}
}
}
scale <1.5,10000,1.5>
rotate -90*x
scale 1.5
}
cylinder {0,<0,1,0>,1 hollow on
pigment {Clear}
interior {
media{
intervals 10
samples 1,10
variance 1/1000
confidence 0.999
emission 1
density { cylindrical
color_map{
[0.0 rgb <1,0,1>*0]
[.5 rgb <1,.5,0>*.25] 
[1 rgb <1,1,0>*.5]
}
translate <0,-200*clock,.5*clock>
warp {turbulence 1.5 lambda 4 }
translate <0,200*clock,-.5*clock> 
scale <1,1/10000,1>
}
}
}
rotate -90*x
scale 2
}
           
sphere {0, 1 hollow on
pigment {Clear}
interior {
media{
emission 1/2.5
density { spherical
color_map{
[0.0 rgb <1,0,0>*0]
[.5 rgb <1,.25,0>*.25]
[.75 rgb <1,.75,0>*.375]
[1.0 rgb <1,1,0>]
}
}
}
}
scale 3
scale 2.5
}      
rotate 90*x
translate <0,52,-2.5>
}
#end
#if (GunFlame)
union{FlameThrower rotate -90*x translate <0,50,1.5>} 
#end
}
texture {
pigment {rgb <.225,.225,.275>*.25}
finish {ambient .1 diffuse 1 phong 5 phong_size 80 metallic}
}
}
union {
union {
#include "Marine's Head.inc"
#include "Marine's Blaster.inc"
union{
#if (Gender = 1)
union{MaleHead scale 2.675 rotate (180+HeadRot)*y translate <0,15,-6.75>}
#end
#if (Gender = 2)
union{FemaleFace scale 2.675 rotate (180+HeadRot)*y translate <0,15,-6.75>}
#end

union{NeckRing translate -2.5*y} 
union{Helmet translate -2.5*y}
union{FrontPlateJunk} 
union{BreastPlate texture {X_Tex} texture {BloodType}}
union{BreastPlate scale <-1,1,1> texture {X_Tex} texture {MajorLAnders}}
union{BreastPlateB}
union{BreastPlateB scale <-1,1,1>}
union{ShoulderPad texture {ClanBird} 
translate <-12,-10,0>
rotate <(UArmRot1.x)/2,(UArmRot1.y)/6,(UArmRot1.z)/4>
translate <12,10,0>
translate -1*y}
union{ShoulderPad scale <-1,1,1> texture {IDNumbers}
translate <-12,-10,0>
rotate <(UArmRot2.x)/2,(UArmRot2.y)/6,(UArmRot2.z)/4>
translate <12,10,0>
translate -1*y}
union{WSheath}
union{WSheath scale <-1,1,1>}
union{LightA rotate 22.5*y translate 5*x}
union{LightA rotate -22.5*y translate -5*x}
#if (Lights = 1)
union{LightA translate <-4,-11.5,-1> scale <1.5,1.5,1>}
#end
#if (Lights = 2)
union{LightB scale <1.5,1.5,1.5> translate<-20,3,18>} 
union{LightB scale <1.5,1.5,1.5> translate<-15,3,18>}
#end
texture {X_Tex}
}
union{WaistStuff}
union{WaistStuff scale <-1,1,1>}
union{WaistStuffB}
//Helmet shield
sphere{<0,0,0>,1
scale <8.5,8.5,8.5>
rotate <-21.81,0,0>
translate <0,14,-8.25>
pigment{rgb (.5+Clear+Clear)/3}
finish{diffuse .5 phong 1 reflection .25 phong_size 25}
}
translate 7.75*z
}
#include "Marine's Hand.inc"
union {
union {UpperArm}
union {union{LowerArm}
#if (GunPos = 2) 
union{HAND rotate <0,-20,0> translate <0,-33+16.75,0>}
//union{FlameThrower rotate 90*x translate <0,-10,-4>}   
//union{Blaster rotate <0,0,0> translate <0,-33+16.75,0>}
union {TrooperGun rotate <0,40,180> translate <3,-38,-7.5> translate 16.75*y
}
#else            
union{HAND #if (GunPos = 1)rotate -90*y#end rotate <0,-60,0> translate <0,-33+16.75,0>}
#end
rotate 45*y rotate LArmRot1 translate -16.75*y}
rotate UArmRot1
scale .9
translate <13,7.5,0>
scale <1,1,1>
}
union { 
union {UpperArm}
union {union{LowerArm} 
union{HAND rotate <0,-60,0> translate <0,-33+16.75,0>}
rotate 45*y rotate LArmRot2 translate -16.75*y}
rotate UArmRot2
scale .9
translate <13,7.5,0>
scale <-1,1,1>
}
#if (GunPos = 1)
union {TrooperGun rotate <0,0,0>
translate -10*y
rotate<GunRotX,GunRotY,0>
translate Grip2 
translate <0,-4,0>
}              
#end
union {
union {UpperLeg}                                  
union {LowerLeg rotate LLegRot1 translate -22.6*y} 
rotate ULegRot1
translate -20*y
translate 2.5*x
}
union {
union {UpperLeg}
union {LowerLeg rotate LLegRot2 translate -22.6*y}
rotate ULegRot2
translate -20*y
translate 2.5*x
scale <-1,1,1>
}
translate 76.75*y
scale Hight
}
#end


union {
Marine (45,
<30,0,15>,    //Upper Arm Rotations
<0,0,10>,    
<30,0,0>,     //Lower Arm Rotations
<30,0,0>, 

<0,0,-10>,   //Upper Leg Rotations
<20,0,-10>,
<0,0,0>,     //Lower Leg Rotations
<-15,0,0>,
1,  //Hight
1,1,1,   //color on the shoulder pads
1, //gender
0, //head rotate
1, //gun position
false, //fire laser?
false,  //fire Flamethrower?
2
)
rotate 360*y*clock
}

global_settings {
max_trace_level 20
}

//background {rgb .125}


