// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1a
// Fichier    : monde06b.pov by  Martial Rameaux
// include.inc to include
//         chaise.inc     
//         cyclo.inc   
//         selle.inc
//  49mm 27"        
// just use tools
// gforge,moray,paint shop pro,tree.inc de Sonya Roberts,pov... 
// mile ;) -> m.r@lemel.fr
//==========================================
#include "colors.inc"
#include "textures.inc"
#include "chaise.inc"
#include "cyclo.inc"

#include "consts.inc"
#declare Rad_Quality = 5;
#include "rad_def.inc"
global_settings 
{ assumed_gamma 1.0
  radiosity { distance_maximum 10 } // dpend de la scene 1/3 de la distance
}


//=================== CAMERA ===========================
#declare C1=	
camera
{ 
 location  <0.0 , 0.0 ,-30.0>
  right x*1.33
  //angle 75
  //up y    
  //direction <0,0,1>
  look_at   <0.0 , 0.5 , 0.0>
}
#declare C2=
camera
{ 
 ultra_wide_angle  
  location  <0.0 , 0.0 ,-50.0>
  //right x*1.33
 // angle 75
  //up y    
  look_at   <0.0 , 0.0 , 0.0>
}

camera { C1 }
//==============================================

//light_source { <0,40,0> color 1} // pour travail
//============== pour illuminer la coccinelle =====
/*light_source { 0*x color rgb 1  
              spotlight  
              translate <-2,1,-18>
              point_at  <-2,1,-15>  
              radius 1  
              tightness 10  
              falloff 100 
              fade_power 1
              fade_distance 0.5
              shadowless
              }
*/
//==================== Media ============================
#declare Media1=
media {
  intervals 10 //40
  scattering {1, rgb 0.003  }
  emission rgb <0.0001,0.0001,0.001> 
  absorption rgb <0.001,0.001,0.0008>
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9
}
#declare Media2=
media {
  intervals 5 //40
  emission rgb 0.5 
  samples 1, 10
  confidence 0.9999
  variance 1/1000
  ratio 0.9
}

#declare Density1=
  density {
    spherical
    scallop_wave
    color_map {
      [0.0 color rgbf <0.0, 0.0, 0.0,0.0>]
      [0.1 color rgbf <0.0, 0.0, 0.1,0.0>]
      [1.0 color rgbf <0.0, 0.0, 0.1,0.0>]
    } 
    turbulence y*0.5
    octaves 10
    lambda 10
    omega 0.5
    
    scale 4
  }
#declare Density2=
  density {
    spherical
    scallop_wave
    color_map {
      [0.0 color rgbf <0.0, 0.0, 0.0,0>]
      [0.5 color rgbf <0.0, 0.0, 0.1,0>]
      [1.0 color rgbf <0.1, 0.0, 0.0,0>]
    } 
    turbulence 0.5
    octaves 20
    lambda 10
    omega 0.8
    
    scale 4
  }

#declare Fog1=
fog { fog_type 1  
        color <0.01,0.0,0.01>
        distance 100
        turbulence <0.5,1.8,0.0> 
        turb_depth 3  
        }

#declare Interior=
interior {    media  { Media2 
                         density { 
                                agate
                                 density_map {
                                  [0.5 Density1]
                                  [0.5 Density2]
                                 }
                         }
                 }
}

//media {Media1 }
//fog { Fog1}

//================== LUMIRES ===========================
/*light_source {0*x color rgb<0.9921,0.8941,0.2235> translate <-20, -50, -5> //   rgb<0.6117,0.6470,0.9607>
  media_interaction off
                      }   
                      */
//=================== TEXTURES ====================================


#declare Pilone_Texture = texture { pigment { color rgb <0.9,0.9,0.5>} 
                         finish { ambient 0.42 diffuse 0.42 reflection 0.32}
                           }
#declare Filament_Texture=texture { pigment { color rgb <2,2,2> }
                                    finish { ambient 10
                                           diffuse 1
                                          brilliance 1
                                          phong 0.9
                                          phong_size 260
                                            specular 1
                                              reflection  White
                                               roughness 1 }
}

 #declare Porte_Filament_Texture=texture {
                                         pigment { color rgb <0.70, 0.55, 0.40> }
                         finish {ambient 1 diffuse 0.8}
 }
 
#declare Ampoule_Texture=texture { pigment {color rgbf <0.95,0.95,0.99,0.95>}
                                   finish {
                                        ambient 0.1000
                                         diffuse 0.00100
                                           reflection 0.0051
                                            specular 0.800
                                          // roughness 0.0093
                                           phong 1.00
                                           phong_size 400
                                           metallic
                                                   }
}

#declare Douille_Texture= texture { pigment
                                  {color rgb <0.5,0.5,0.5>}
                                   }

#declare Globe_Texture =   texture {
                              pigment {
                                        color rgbf <0.9600, 0.990, 0.96000, 0.9>
                                        }
  // normal {  quilted 1 control0 1 control1 1} // a c'est des ptit carreaux

                                        finish {
                                        ambient 0.1000
                                         diffuse 0.100
                                           reflection 0.51
                                            specular 0.800
                                           roughness 0.0093
                                           phong 1.00
                                           phong_size 400
                                                   }
                                          }

//==============================================


#declare Univers_Texture = texture { pigment { agate 
                                              color_map {
                                                  [1.0 color rgb <0,0,0> ]
                                                  [0.1 color rgb <0.9,0.9,1> ]
                                                   }
                                                    frequency 0.1
                                                      turbulence 5.3
                                                      octaves 8
                                                      omega 0.2
                                                      lambda 2
                                                      phase 4
                                             }
                           finish {
                                   ambient 0.1
                                   diffuse 0.1
                           }
                                }


//=======================================================
//======================= PIECE DU REVERBERE =====================

#declare Base_Pilone=merge {
                        cone {<0,0,0>,1.2,<0,5,0>,1  }
                         torus  {1.2000, 0.6
                                       scale <1,0.5,1> translate y*5}
                                       cone {<0,4,0>,0.8,<0,25,0>,0.2 }
                                       sphere {<0,25,0>,0.5}
                                 }
#declare Croisillions=merge {  cylinder {<-1.65,0,0>,<1.65,0,0>,0.15 }
                               sphere {<0,0,0>,0.2 translate <1.65,0,0> }
                               sphere {<0,0,0>,0.2 translate <-1.65,0,0>}
                                cylinder {<0.0,0,-1.65>,<0.0,0,1.65>,0.15 }
                               sphere {<0,0,0>,0.2 translate <0,0,1.65> }
                                sphere {<0,0,0>,0.2 translate <0,0,-1.65> }
                                               }

#declare Bras_Pilone=merge {intersection {
                                      box{ <-3.5,-3.5,-0.3>,<3.5,0.5,0.3> }
                                      torus {  3.00,0.2 rotate x*90}
                                             }
                                                sphere {<0,0,0>,0.20 translate <3.5,0.5,0> }
                                                sphere {<0,0,0>,0.43 translate <-3.0,0.5,0> }
                                                 cylinder {<0,0,0>,<0,0.5,0>,0.35  open translate <-3.0,0.7,0>}
                                             object {Croisillions translate <-3.0,0.5,0>}
                                             }

 #declare Pilone=object {Base_Pilone
                        texture { Pilone_Texture}
                        }


#declare Globe=merge {
                      sphere {<0,0,0>,1.5 scale <1.5,1,1.5>  hollow}
                       cylinder {<0,1.3,0>,<0,1.5,0>,1.5   open  }
                         cylinder {<0,-1.3,0>,<0,-1.5,0>,1.5   open  }
                          torus {1.3,0.1  scale <1,2.5,1> translate y* 1.32}
                           torus {1.3,0.1  scale <1,2.5,1> translate y*-1.32}
                            scale <1,1.52,1> texture {Globe_Texture}
                            interior {   ior 1.45 }
                              // pigment {color rgbf <1,0,0,0.89>}
                            hollow   }

#declare Tungsten= torus { 0.45,0.050
                          texture { Filament_Texture }
                          interior { ior 1.45 }
                             }

 #declare Porte_Filament1= merge {
                         cylinder { <-0.1,-.5,0>,<-0.4,0.310,0>,0.015 }
                         cylinder { < 0.1,-.5,0>,< 0.4,0.310,0>,0.015 }
                         texture {Porte_Filament_Texture}
                           }
 #declare Porte_Filament= union { object {Porte_Filament1}
                          cylinder {<0,-1.0,0>,<0,-0.6,0>,0.3 open
                          texture  { Douille_Texture}
                                    }

                        sphere {<0,0.25,0>,0.7 scale <1,1.2,1>
                         texture {Ampoule_Texture}
                         interior {  ior 1.45 }
                         hollow }
                         }

#declare Filament=union {   object { Porte_Filament translate <-6.25,23,0>}
                            light_source {<-6.25,23.3,0> color rgb<0.9803,0.5176,0.39>*1.5//rgb<0.9843,0.8901,0.7176>*2//<1,0.8,0.8> 
                            looks_like { Tungsten }  
                            
                            media_attenuation on 
                            media_interaction on
                            fade_distance 0.9 fade_power 0.5
                                 } 
                                    }


#declare Globe_PorteGlobe=union { object  {Globe translate <-6.4,23.5,0> }
                        object  {Filament}
                        object  {Bras_Pilone  
                                texture { Pilone_Texture }
                                translate <-3.2,21,0>
                               }
                        hollow  }

#declare Globe3= union {
                        object {Globe_PorteGlobe rotate y*120}
                         object {Globe_PorteGlobe rotate y*240}
                          object {Globe_PorteGlobe rotate y*360}
}


//================== Le REVERBERE ============================
#declare Reverbere = union {  object  {Pilone}
                                  object {Globe3}
                                  scale 0.07
                                  translate y*2
                              scale 2.5   
                              } 

//===================== SATELITE =========================
#declare Satelite=
        sphere { 0,0.5
                texture { 
                        pigment {  bozo
                                color_map {
                                        [ 0.0 0.1 color rgb <0.8,0.6,0.2>         color rgb<0.9176,0.7686,0.5411> ]
                                        [ 0.5 0.9 color rgb<0.9254,0.9294,0.6941> color rgb<0.7215,0.1803,0.470>  ]
                                        [ 1.0 0.2 color rgb<0.9882,0.9411,0.941>  color rgb<0.8882,0.9411,0.841>  ]
                                }
                                turbulence 1.3
                                octaves 7
                                omega 0.8
                                lambda 2
                                
                        }
                        finish { ambient 0.2 diffuse 0.6}
                }
        }
        
//================ Arbre ==============================

#version 2.0;
#declare Arbre=
object {
#declare Tip=1
#declare BarkTexture=0
#declare BaseLen=1
#declare LeafShape=6
#declare LeafTexture=2
#include "trees.inc"
} 
#version 3.0;

//==============================================
#include "coccinel.inc"
//==============================================
#declare Clair=color rgbf 1;
#declare MondeTexture=
                texture {pigment { image_map { png "globe.png" map_type 1 } }  
                         normal { bumps 0.9 scale 0.5}
                        }
               
#declare Montagne= difference  {
                        cone { <0,0,0>1<0,1.3,0>0.35 }
                        sphere { <0,1.3,0>0.3 }
                        translate y*1.5 
                         }

#declare Monde= object {sphere {  0,2 } 
                        texture {MondeTexture rotate x*-0 }
                         }
//====================== NUAGES ========================
 
#declare Nuages=     
                texture {
                 pigment {   
                 agate 
                    turbulence <0.65,0.0,0.65>
                    octaves 2
                    omega 0.5
                    lambda 2
                            color_map {
                                [0.0, 0.3   color rgbf <0.20,0.20,0.90,0.90> color rgbf <0.75,0.75,0.75,0.20>]
                                [0.1, 0.2   color rgbf <0.20,0.20,0.90,0.80> color rgbf <1.00,1.00,1.00,0.80>]
                                //[0.1, 0.5   color rgbf <0.75,0.75,0.90,1.00> color rgbf <1.00,1.00,1.00,1.00>]
                                [0.1, 1.0   color rgbf <1.00,1.00,1.00,1.00> color rgbf <1.00,1.00,1.00,1.00>]
                            }
                scale <6, 1, 6>
                 } 
                 finish {
    ambient 0.9
    diffuse 0.6
  }
        rotate x*200   
        }
//======================= ATMOSPHERE =======================
#declare Atmosph=
        sphere {0,2.5  texture { Nuages  rotate z*-45}  
        interior {  Interior fade_power 2 fade_distance 1  }                       
        scale 4
        hollow
          }   
//================== UNIVERS ============================
#declare NazimHikmet_T= texture {     
                               pigment {
                                 image_map { 
                                        png "nazim"
                                        interpolate 4
                                       // once
                                        map_type 0
                                        filter 34,1
                                        }  
                              translate -0.5*(x+y)
                              scale <2.168,1,1>
                              
                }
              finish { ambient 0.5 diffuse 0.5 }
}


#declare NazimHikmet=
//plane { z,-1      
box {<-2,-2,0>,<2,2,0.001> //<0,0,0>,<1,1,0.01> 
        texture {NazimHikmet_T }
        scale <40,40,0.001>*1.2
        translate <0,20,50>
        hollow
} 

//============== AFFICHAGE ================================

union {
object { Monde scale 2.5}  
object { Reverbere rotate <-60,0,-20>} 
object { Chaise  rotate <-60,-0,20>}  
object { Atmosph }
object { Cyclopede scale 0.2 rotate y*45 translate <0,11,1.2>   rotate z*20 rotate x*-45  }
object { Arbre  translate <0,5,0>  rotate <-10,-20,30>   }//   rotate <-30,0,20> scale 0.5

translate <4,-0.5,0>
}

object { Satelite scale 2  translate x*15 rotate <0,50,150> translate x*3}//translate x*10  rotate <0,10,120>
object { Coccinelle scale 0.3 rotate <-90,0,45> translate <-2,1,-15> }         
object {NazimHikmet scale 0.99 }
//============= Fin de ailleur.inc =================================
