//=========================================================
// Persistence of Vision Ray Tracer Scene			
// Pov-Ray for windows version 3.1a
// Fichier    : coccinel.inc by  Martial Rameaux
// date       : Fevrier 99
// 
// mile ;) -> m.r@lemel.fr
//==============================================

//** La coccinelle est dclar "Coccinelle" ***//

//============DEBUT===========================
//========= TEXTURE===========================
#declare Aile_T=texture {
                        pigment {
                                 leopard 
                                //turbulence 0.001
                                   color_map {
                                                [0.0  color rgb <0.5,0.0,0.0>]
                                                [0.5  color rgb <0.0,0.0,0.0>*10]
                                        }
                          scale 0.13
                          rotate <45,45,45>
                        }   
                        finish { ambient 0.3 diffuse 0.6 specular 1 roughness 0.0001 }
}

#declare Tete_T=texture {
                        pigment {color rgb<0.5098,0.3411,0.1568>/5 }   
                        finish { ambient 0.2 diffuse 0.3 specular 1 roughness 0.001 }

}
#declare Corps_T=texture {
                        pigment {color rgb <0.3,0.1,0.1> }
                          normal {
                            quilted 1
                            control0 0
                            control1 1
                            scale <2,0.5,0.5> 
                            }
                        finish {ambient 0.2 diffuse 0.3 specular 0.05 roughness 0.01 }
                        }

#declare Yeux_T=texture {
                        pigment {color rgb <0.1,0.1,0.2> }
                        finish {ambient 0.2 diffuse 0.3 specular 1 roughness 0.01 }
        }
#declare Antenne_T=texture {
                        pigment {color rgb <0.3,0.1,0.1> }
                        finish {ambient 0.2 diffuse 0.3 specular 1 roughness 0.01 }
}
#declare Patte_T=texture {
                        pigment {color rgb <0.3,0.1,0.1> }
                        finish {ambient 0.2 diffuse 0.3 specular 1 roughness 0.001 }
        }

//============FORME==================================
//----------Tete------
#declare Tete=  sphere { 0,1 texture { Tete_T } scale <0.9,0.7,0.8>  } 
//----------Yeux-----
#declare Yeux= union {
                torus {0.2,0.05 }
                sphere { 0,0.2 }
                        texture {Yeux_T } scale <1,1,1>
                        rotate z*90
                        translate x*1
}
//----------mandibule----
#declare Mandibule=difference { //
                sphere { 0,0.8  scale <1,0.5,1>}
                sphere { 0,0.8  scale <0.9,1.2,0.5> translate x*0.06}  
                        texture { Tete_T } 
                        scale 0.5
                //rotate z*-60
                //translate <2.5,-0.2,0>  
}
//--------Aile et Corp-------
#declare Aile_Corp=union {
                sphere { 0,1 scale <1.03,0.8,0.9> texture {Corps_T}translate y*-0.1}
                sphere { 0,1 clipped_by { box { <-1,-0.2,-1><1,1,-0.05>}rotate z*25} rotate y*-10 }
                sphere { 0,1 clipped_by { box { <-1,-0.2, 1><1,1, 0.05>}rotate z*25} rotate y*+10}
                        texture { Aile_T }
                        scale <1.83,1,1.5>
}
//-------Antenne-------
#declare Antenne_d=
        union {
               torus { 1.5,0.04 clipped_by {box {<-2,-2,-0.5><0.8,1,2>} } rotate x*-90}
               sphere { 0,0.1 translate x*1.5 rotate z*60} 
               texture { Antenne_T}
               scale 0.8
               rotate <-10, 0,0>
               translate z*-0.2
        }
#declare Antenne_g=
        union {
               torus { 1.5,0.04 clipped_by {box {<-2,-2,-0.5><0.8,1,2>} } rotate x*-90}
               sphere { 0,0.1 translate x*1.5 rotate z*60} 
               texture { Antenne_T}  
               scale 0.8             
               rotate < 10, 0,0>
               translate z* 0.2
  }
//-------Pattes---
#declare Patte=union {
                cone {<0,1,0>0.10<0.8,1.2,0>0.09 }
                sphere { <0.8,1.25,0>0.10 }
                cone {<0.8,1.2,0>0.09<0.9,0.5,0>0.05}
                sphere {<0.9,0.5,0>0.06}
                cone { <0.9,0.5,0>0.05<1.1,0.5,-0.1>0.04}
                sphere {<1.1,0.5,-0.1>0.05}
                cone { <1.2,0.5,-0.1>0.04<1.3,0.5,-0.2>0}
                texture { Patte_T }
               // scale 0.5
}   
//========COCCINELLE===================================
#declare Coccinelle=
union {
        object { Aile_Corp }
        object { Tete translate x*1.3} 
        object { Yeux  rotate < 20, 20,20> translate <1.1,0.0,-0.0>}
        object { Yeux  rotate < 20,-20,20> translate <1.1,0.0, 0.0>}
        object { Mandibule scale 0.5 rotate z*-60   translate <2.2,-0.2,0>   }
        object { Antenne_d translate x*3.0 } 
        object { Antenne_g translate x*3.0 }               
               
        object { Patte rotate y*-70  translate < 0.5,-1.5, 0.9>}   //  
        object { Patte rotate y*-90  translate <-0.0,-1.5, 1.0>}   // 
        object { Patte rotate y*-120 translate <-0.8,-1.5, 1.0>}   //
        object { Patte rotate y* 60  translate < 0.5,-1.5,-0.9>}   //  
        object { Patte rotate y* 90  translate <-0.0,-1.5,-1.0>}   // 
        object { Patte rotate y* 90  translate <-0.8,-1.5,-1.0>}   //
translate y*-0.5
rotate y*0
}
//===========FIN===================================
