// POV file adapted from topo example by Russell Towle and Martial Rameaux
//  sol.tga is produce by gforge ...
//==============================================

#include "colors.inc"
#include "textures.inc"

camera
{
  location  <0,  .75,0> 
  direction 1*z              
  up        y              
  right     1.33*x          
  look_at   <0, -0.05, 0> 
}


light_source { <-300, 300, -10> color rgb <0.75,0.5, 0.8> }
light_source { <-300, 210, 5>   color rgb <0.50,0.5, 0.0> }
light_source { <0, 1500, 0>     color rgb <0.50,0.0, 0.1> }


// The heightfield object is in the X-Z plane, centered on the origin, 
// and extends +/- 0.5 units in the X and Z directions

object{
         height_field {tga "sol.tga"  smooth hierarchy 
}
         scale < 1, .1, 1 >      // reduce height
         translate <-.5, 0, -.5>
         texture { 
           pigment {color White} 
           finish {phong 0.1 ambient 0.2} 
         }

       }

