#include "shield.pov"

// *********************************** TEXTURES and OBJECTS
#declare oar = object {
 union {
  cylinder { <-1.5,0,0>,<4,0,0>, 0.05 }
  box      { <3.8, -0.15, -0.01>, <4.4, 0.15, 0.01> }
  cylinder { <3.8, -0.0, -0.01>, <3.8, 0, 0.01>, 0.15 }
  sphere   { <4, 0, 0>,0.05 }
  texture { pigment {DarkWood} finish{phong 0.3}}
  }
};

#declare ship_wood = texture{
                        pigment { wood pigment_map{ [0.08 DarkWood ]
                                                    [0.1  LightWood]}
                                                    scale 0.01
                                                    rotate <0,1,1>}
                        finish {phong 0.3}};

#declare tar = texture {pigment {Black}
                        finish {phong 0.9}};


#declare ship_panel = texture {brick texture{tar}, texture{ship_wood}
                               brick_size <10,0.2,10>
                               mortar 0.01};


#declare eye_tex =  texture {pigment {White} finish {phong 0.2}}
                    texture {pigment {image_map {tga "eye.tga" once
                                 interpolate 2}
                                rotate y*-90
                                translate <0,0.4,-12>}
                            finish {phong 0.2}};


#declare ship_paint = texture {    pigment {color rgb <1.0,0.3,0.3>}
                               finish {phong 0.2}};


#declare galley_tex = texture {gradient y texture_map{
                                          [0.5 ship_panel scale <1,0.1,1>]
                                          [0.5 ship_paint]}
                               scale <1,10,1>
                               translate <0,-3.2,0>};



//**************************************************************
// Layer 1 Hull

union {

union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.482, 0.000, 0.000> <-1.449, -0.232, 0.000> <-1.445, -0.616, 0.000> <-1.250, -0.747, 0.000> 
		<-1.347, 0.023, -3.008> <-1.313, -0.209, -3.008> <-1.330, -0.573, -3.006> <-1.136, -0.704, -3.006> 
		<-0.912, 0.036, -7.004> <-0.898, -0.152, -7.006> <-0.879, -0.517, -7.007> <-0.765, -0.668, -7.007> 
		<-0.626, 0.147, -10.000> <-0.612, -0.041, -10.001> <-0.641, -0.324, -10.000> <-0.527, -0.475, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.482, 0.000, 0.000> <-1.347, 0.023, -3.008> <-0.912, 0.036, -7.004> <-0.626, 0.147, -10.000> 
		<-1.525, 0.297, 0.000> <-1.389, 0.320, -3.008> <-0.930, 0.284, -7.003> <-0.644, 0.395, -9.998> 
		<-1.495, 0.700, 0.000> <-1.235, 0.693, -2.997> <-0.946, 0.738, -7.000> <-0.634, 0.727, -9.992> 
		<-1.500, 1.000, 0.000> <-1.241, 0.993, -2.997> <-0.948, 0.987, -6.998> <-0.636, 0.976, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.482, 0.000, 0.000> <-1.604, -0.021, 2.697> <-1.559, -0.058, 6.302> <-1.482, 0.000, 9.000> 
		<-1.449, -0.232, 0.000> <-1.571, -0.253, 2.697> <-1.525, -0.291, 6.302> <-1.449, -0.232, 9.000> 
		<-1.445, -0.616, 0.000> <-1.547, -0.655, 2.698> <-1.508, -0.720, 6.303> <-1.445, -0.616, 9.000> 
		<-1.250, -0.747, 0.000> <-1.353, -0.786, 2.698> <-1.313, -0.851, 6.303> <-1.250, -0.747, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.482, 0.000, 0.000> <-1.525, 0.297, 0.000> <-1.495, 0.700, 0.000> <-1.500, 1.000, 0.000> 
		<-1.604, -0.021, 2.697> <-1.646, 0.276, 2.697> <-1.495, 0.700, 2.700> <-1.500, 1.000, 2.700> 
		<-1.559, -0.058, 6.302> <-1.601, 0.239, 6.302> <-1.495, 0.700, 6.300> <-1.500, 1.000, 6.300> 
		<-1.482, 0.000, 9.000> <-1.525, 0.297, 9.000> <-1.495, 0.700, 9.000> <-1.500, 1.000, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.250, -0.747, 0.000> <-0.932, -0.961, 0.000> <-0.380, -1.000, 0.000> <0.003, -1.000, 0.000> 
		<-1.136, -0.704, -3.006> <-0.818, -0.918, -3.006> <-0.381, -0.950, -3.001> <0.003, -0.950, -3.001> 
		<-0.765, -0.668, -7.007> <-0.662, -0.805, -7.007> <-0.169, -0.905, -7.007> <0.002, -0.905, -7.007> 
		<-0.527, -0.475, -10.000> <-0.425, -0.612, -10.000> <-0.169, -0.686, -10.000> <0.002, -0.686, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.250, -0.747, 0.000> <-1.353, -0.786, 2.698> <-1.313, -0.851, 6.303> <-1.250, -0.747, 9.000> 
		<-0.932, -0.961, 0.000> <-1.034, -1.000, 2.698> <-0.995, -1.065, 6.303> <-0.932, -0.961, 9.000> 
		<-0.380, -1.000, 0.000> <-0.380, -1.045, 2.700> <-0.380, -1.119, 6.303> <-0.380, -1.000, 9.000> 
		<0.003, -1.000, 0.000> <0.003, -1.045, 2.700> <0.003, -1.119, 6.303> <0.003, -1.000, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, -1.000, 0.000> <0.386, -1.000, 0.000> <0.936, -0.961, 0.000> <1.253, -0.747, 0.000> 
		<0.003, -0.950, -3.001> <0.386, -0.950, -3.001> <0.822, -0.918, -3.006> <1.139, -0.704, -3.006> 
		<0.002, -0.905, -7.007> <0.173, -0.905, -7.007> <0.666, -0.804, -7.007> <0.768, -0.668, -7.007> 
		<0.002, -0.686, -10.000> <0.173, -0.686, -10.000> <0.428, -0.612, -10.000> <0.531, -0.475, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, -1.000, 0.000> <0.003, -1.045, 2.700> <0.003, -1.119, 6.303> <0.003, -1.000, 9.000> 
		<0.386, -1.000, 0.000> <0.386, -1.045, 2.700> <0.386, -1.119, 6.303> <0.386, -1.000, 9.000> 
		<0.936, -0.961, 0.000> <1.038, -1.000, 2.698> <0.999, -1.065, 6.303> <0.936, -0.961, 9.000> 
		<1.253, -0.747, 0.000> <1.356, -0.786, 2.698> <1.316, -0.851, 6.303> <1.253, -0.747, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.253, -0.747, 0.000> <1.356, -0.786, 2.698> <1.316, -0.851, 6.303> <1.253, -0.747, 9.000> 
		<1.448, -0.616, 0.000> <1.550, -0.655, 2.698> <1.511, -0.720, 6.303> <1.448, -0.616, 9.000> 
		<1.452, -0.232, 0.000> <1.574, -0.253, 2.697> <1.528, -0.291, 6.302> <1.452, -0.232, 9.000> 
		<1.485, 0.000, 0.000> <1.607, -0.021, 2.697> <1.562, -0.058, 6.302> <1.485, 0.000, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.253, -0.747, 0.000> <1.448, -0.616, 0.000> <1.452, -0.232, 0.000> <1.485, 0.000, 0.000> 
		<1.139, -0.704, -3.006> <1.333, -0.573, -3.006> <1.317, -0.209, -3.008> <1.350, 0.023, -3.008> 
		<0.768, -0.668, -7.007> <0.882, -0.517, -7.007> <0.901, -0.152, -7.006> <0.914, 0.036, -7.004> 
		<0.531, -0.475, -10.000> <0.644, -0.324, -10.000> <0.615, -0.041, -10.001> <0.629, 0.147, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.485, 0.000, 0.000> <1.607, -0.021, 2.697> <1.562, -0.058, 6.302> <1.485, 0.000, 9.000> 
		<1.528, 0.297, 0.000> <1.649, 0.276, 2.697> <1.604, 0.239, 6.302> <1.528, 0.297, 9.000> 
		<1.498, 0.700, 0.000> <1.498, 0.700, 2.700> <1.498, 0.700, 6.300> <1.498, 0.700, 9.000> 
		<1.503, 1.000, 0.000> <1.503, 1.000, 2.700> <1.503, 1.000, 6.300> <1.503, 1.000, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.485, 0.000, 0.000> <1.528, 0.297, 0.000> <1.498, 0.700, 0.000> <1.503, 1.000, 0.000> 
		<1.350, 0.023, -3.008> <1.392, 0.320, -3.008> <1.238, 0.693, -2.997> <1.243, 0.993, -2.997> 
		<0.914, 0.036, -7.004> <0.932, 0.284, -7.003> <0.947, 0.738, -7.000> <0.948, 0.987, -6.998> 
		<0.629, 0.147, -10.000> <0.647, 0.395, -9.998> <0.634, 0.727, -9.992> <0.636, 0.976, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.626, 0.147, -10.000> <-0.612, -0.041, -10.001> <-0.641, -0.324, -10.000> <-0.527, -0.475, -10.000> 
		<-0.540, 0.180, -10.898> <-0.526, -0.008, -10.900> <-0.561, -0.259, -11.009> <-0.447, -0.410, -11.009> 
		<-0.395, 0.398, -12.081> <-0.393, 0.296, -12.195> <-0.385, -0.038, -12.188> <-0.338, -0.081, -12.327> 
		<-0.243, 0.481, -12.967> <-0.241, 0.379, -13.081> <-0.241, 0.153, -13.174> <-0.193, 0.111, -13.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.626, 0.147, -10.000> <-0.540, 0.180, -10.898> <-0.395, 0.398, -12.081> <-0.243, 0.481, -12.967> 
		<-0.644, 0.395, -9.998> <-0.558, 0.428, -10.897> <-0.399, 0.551, -11.909> <-0.246, 0.634, -12.796> 
		<-0.634, 0.727, -9.992> <-0.559, 0.725, -10.712> <-0.395, 0.784, -11.834> <-0.223, 0.802, -12.536> 
		<-0.636, 0.976, -9.990> <-0.561, 0.973, -10.710> <-0.383, 0.937, -11.662> <-0.211, 0.954, -12.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.531, -0.475, -10.000> <0.644, -0.324, -10.000> <0.615, -0.041, -10.001> <0.629, 0.147, -10.000> 
		<0.451, -0.410, -11.009> <0.564, -0.259, -11.009> <0.530, -0.008, -10.900> <0.543, 0.180, -10.898> 
		<0.333, -0.081, -12.325> <0.376, -0.038, -12.186> <0.396, 0.297, -12.195> <0.398, 0.398, -12.080> 
		<0.196, 0.111, -13.312> <0.240, 0.154, -13.172> <0.249, 0.380, -13.082> <0.251, 0.481, -12.967> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.629, 0.147, -10.000> <0.647, 0.395, -9.998> <0.634, 0.727, -9.992> <0.636, 0.976, -9.990> 
		<0.543, 0.180, -10.898> <0.561, 0.428, -10.897> <0.560, 0.725, -10.708> <0.561, 0.973, -10.706> 
		<0.398, 0.398, -12.080> <0.401, 0.552, -11.905> <0.390, 0.782, -11.825> <0.376, 0.937, -11.651> 
		<0.251, 0.481, -12.967> <0.254, 0.635, -12.792> <0.228, 0.800, -12.526> <0.214, 0.954, -12.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.251, 0.481, -12.967> <0.254, 0.635, -12.792> <0.228, 0.800, -12.526> <0.214, 0.954, -12.352> 
		<0.212, 0.502, -13.200> <0.216, 0.656, -13.025> <0.203, 0.802, -12.636> <0.189, 0.957, -12.462> 
		<0.250, 0.494, -13.720> <0.250, 0.709, -13.434> <0.134, 0.874, -12.973> <0.130, 1.042, -12.657> 
		<0.013, 0.494, -13.720> <0.013, 0.709, -13.434> <0.021, 0.874, -12.976> <0.018, 1.042, -12.660> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.251, 0.481, -12.967> <0.212, 0.502, -13.200> <0.250, 0.494, -13.720> <0.013, 0.494, -13.720> 
		<0.249, 0.380, -13.082> <0.210, 0.402, -13.315> <0.250, 0.450, -13.779> <0.013, 0.450, -13.779> 
		<0.240, 0.154, -13.172> <0.221, 0.180, -13.308> <0.159, 0.312, -13.757> <0.019, 0.312, -13.757> 
		<0.196, 0.111, -13.312> <0.178, 0.137, -13.448> <0.157, 0.247, -13.720> <0.018, 0.247, -13.720> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, 0.494, -13.720> <-0.225, 0.494, -13.720> <-0.203, 0.502, -13.202> <-0.243, 0.481, -12.967> 
		<0.013, 0.450, -13.779> <-0.225, 0.450, -13.779> <-0.201, 0.401, -13.315> <-0.241, 0.379, -13.081> 
		<0.019, 0.312, -13.757> <-0.125, 0.312, -13.757> <-0.221, 0.180, -13.313> <-0.241, 0.153, -13.174> 
		<0.018, 0.247, -13.720> <-0.126, 0.247, -13.720> <-0.173, 0.138, -13.451> <-0.193, 0.111, -13.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, 0.494, -13.720> <-0.225, 0.494, -13.720> <-0.203, 0.502, -13.202> <-0.243, 0.481, -12.967> 
		<0.013, 0.450, -13.779> <-0.225, 0.450, -13.779> <-0.201, 0.401, -13.315> <-0.241, 0.379, -13.081> 
		<0.019, 0.312, -13.757> <-0.125, 0.312, -13.757> <-0.196, 0.113, -13.304> <-0.241, 0.153, -13.174> 
		<0.018, 0.247, -13.720> <-0.126, 0.247, -13.720> <-0.148, 0.070, -13.442> <-0.193, 0.111, -13.312> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.013, 0.494, -13.720> <0.013, 0.709, -13.434> <0.021, 0.874, -12.976> <0.018, 1.042, -12.660> 
		<-0.225, 0.494, -13.720> <-0.225, 0.709, -13.434> <-0.094, 0.874, -12.980> <-0.097, 1.042, -12.664> 
		<-0.203, 0.502, -13.202> <-0.206, 0.656, -13.030> <-0.196, 0.804, -12.648> <-0.183, 0.957, -12.476> 
		<-0.243, 0.481, -12.967> <-0.246, 0.634, -12.796> <-0.223, 0.802, -12.536> <-0.211, 0.954, -12.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.647, -12.110> <0.073, 1.647, -12.110> <0.099, 1.688, -11.974> <0.119, 1.694, -11.904> 
		<-0.073, 1.647, -12.110> <0.000, 1.647, -12.110> <0.062, 1.699, -11.892> <0.083, 1.704, -11.822> 
		<-0.099, 1.688, -11.974> <-0.063, 1.699, -11.892> <-0.002, 1.728, -11.631> <0.088, 1.728, -11.631> 
		<-0.119, 1.694, -11.904> <-0.084, 1.704, -11.822> <-0.092, 1.728, -11.631> <-0.002, 1.728, -11.631> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.647, -12.110> <-0.073, 1.647, -12.110> <-0.099, 1.688, -11.974> <-0.119, 1.694, -11.904> 
		<0.000, 1.508, -12.056> <-0.073, 1.508, -12.056> <-0.104, 1.531, -11.915> <-0.125, 1.537, -11.845> 
		<-0.003, 1.327, -12.261> <-0.086, 1.327, -12.261> <-0.147, 1.333, -12.150> <-0.168, 1.342, -12.071> 
		<0.000, 1.216, -12.362> <-0.083, 1.216, -12.362> <-0.165, 1.191, -12.238> <-0.186, 1.200, -12.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.647, -12.110> <-0.073, 1.647, -12.110> <-0.099, 1.688, -11.974> <-0.119, 1.694, -11.904> 
		<0.000, 2.016, -12.256> <-0.073, 2.016, -12.256> <-0.086, 2.060, -12.113> <-0.107, 2.066, -12.044> 
		<0.000, 2.316, -12.777> <-0.075, 2.316, -12.777> <-0.152, 2.343, -12.626> <-0.152, 2.371, -12.556> 
		<0.000, 2.679, -12.938> <-0.075, 2.679, -12.938> <-0.135, 2.698, -12.802> <-0.135, 2.726, -12.732> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.647, -12.110> <0.000, 2.016, -12.256> <0.000, 2.316, -12.777> <0.000, 2.679, -12.938> 
		<0.073, 1.647, -12.110> <0.073, 2.016, -12.256> <0.075, 2.316, -12.777> <0.075, 2.679, -12.938> 
		<0.099, 1.688, -11.974> <0.086, 2.060, -12.113> <0.152, 2.343, -12.626> <0.136, 2.698, -12.802> 
		<0.119, 1.694, -11.904> <0.107, 2.066, -12.044> <0.152, 2.371, -12.556> <0.135, 2.726, -12.732> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.647, -12.110> <0.000, 1.508, -12.056> <-0.003, 1.327, -12.261> <0.000, 1.216, -12.362> 
		<0.073, 1.647, -12.110> <0.073, 1.508, -12.056> <0.079, 1.327, -12.261> <0.083, 1.216, -12.362> 
		<0.099, 1.688, -11.974> <0.104, 1.531, -11.915> <0.146, 1.334, -12.152> <0.165, 1.191, -12.238> 
		<0.119, 1.694, -11.904> <0.125, 1.537, -11.845> <0.168, 1.343, -12.072> <0.186, 1.200, -12.159> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.679, -12.938> <0.000, 2.871, -13.023> <0.000, 3.175, -12.935> <0.000, 3.378, -12.877> 
		<0.075, 2.679, -12.938> <0.075, 2.871, -13.023> <0.044, 3.175, -12.935> <0.044, 3.378, -12.877> 
		<0.136, 2.698, -12.802> <0.127, 2.875, -12.889> <0.059, 3.179, -12.806> <0.040, 3.374, -12.780> 
		<0.135, 2.726, -12.732> <0.127, 2.903, -12.819> <0.059, 3.183, -12.762> <0.041, 3.378, -12.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.679, -12.938> <-0.075, 2.679, -12.938> <-0.135, 2.698, -12.802> <-0.135, 2.726, -12.732> 
		<0.000, 2.871, -13.023> <-0.075, 2.871, -13.023> <-0.127, 2.875, -12.889> <-0.127, 2.903, -12.819> 
		<0.000, 3.175, -12.935> <-0.044, 3.175, -12.935> <-0.060, 3.179, -12.806> <-0.059, 3.183, -12.762> 
		<0.000, 3.378, -12.877> <-0.044, 3.378, -12.877> <-0.041, 3.374, -12.780> <-0.041, 3.378, -12.736> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.482, 0.000, 9.000> <-1.525, 0.297, 9.000> <-1.495, 0.700, 9.000> <-1.500, 1.000, 9.000> 
		<-1.457, 0.019, 9.902> <-1.499, 0.316, 9.902> <-1.392, 0.692, 9.807> <-1.397, 0.992, 9.807> 
		<-1.262, 0.093, 11.100> <-1.295, 0.306, 11.014> <-1.256, 0.767, 10.970> <-1.260, 0.982, 10.884> 
		<-1.144, 0.258, 11.980> <-1.177, 0.471, 11.894> <-1.154, 0.759, 11.778> <-1.158, 0.974, 11.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.482, 0.000, 9.000> <-1.457, 0.019, 9.902> <-1.262, 0.093, 11.100> <-1.144, 0.258, 11.980> 
		<-1.449, -0.232, 9.000> <-1.424, -0.213, 9.902> <-1.236, -0.073, 11.167> <-1.119, 0.092, 12.047> 
		<-1.445, -0.616, 9.000> <-1.422, -0.579, 9.972> <-1.214, -0.438, 11.224> <-1.115, -0.183, 12.157> 
		<-1.250, -0.747, 9.000> <-1.227, -0.710, 9.972> <-1.064, -0.532, 11.262> <-0.965, -0.277, 12.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.250, -0.747, 9.000> <-1.227, -0.710, 9.972> <-1.064, -0.532, 11.262> <-0.965, -0.277, 12.195> 
		<-0.932, -0.961, 9.000> <-0.909, -0.924, 9.972> <-0.818, -0.685, 11.323> <-0.719, -0.431, 12.257> 
		<-0.380, -1.000, 9.000> <-0.380, -0.956, 9.993> <-0.287, -0.743, 11.316> <-0.293, -0.458, 12.268> 
		<0.003, -1.000, 9.000> <0.003, -0.956, 9.993> <0.009, -0.743, 11.316> <0.003, -0.458, 12.268> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, -1.000, 9.000> <0.003, -0.956, 9.993> <0.009, -0.743, 11.316> <0.003, -0.458, 12.268> 
		<0.386, -1.000, 9.000> <0.386, -0.956, 9.993> <0.305, -0.743, 11.316> <0.298, -0.458, 12.268> 
		<0.936, -0.961, 9.000> <0.913, -0.924, 9.972> <0.835, -0.684, 11.325> <0.723, -0.430, 12.257> 
		<1.253, -0.747, 9.000> <1.230, -0.710, 9.972> <1.079, -0.531, 11.263> <0.968, -0.277, 12.195> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.253, -0.747, 9.000> <1.230, -0.710, 9.972> <1.079, -0.531, 11.263> <0.968, -0.277, 12.195> 
		<1.448, -0.616, 9.000> <1.425, -0.578, 9.972> <1.230, -0.437, 11.225> <1.118, -0.183, 12.157> 
		<1.452, -0.232, 9.000> <1.427, -0.213, 9.902> <1.252, -0.073, 11.168> <1.122, 0.092, 12.047> 
		<1.485, 0.000, 9.000> <1.460, 0.019, 9.902> <1.277, 0.093, 11.101> <1.147, 0.258, 11.980> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.485, 0.000, 9.000> <1.460, 0.019, 9.902> <1.277, 0.093, 11.101> <1.147, 0.258, 11.980> 
		<1.528, 0.297, 9.000> <1.502, 0.316, 9.902> <1.310, 0.306, 11.016> <1.180, 0.471, 11.894> 
		<1.498, 0.700, 9.000> <1.395, 0.692, 9.807> <1.260, 0.767, 10.970> <1.157, 0.759, 11.778> 
		<1.503, 1.000, 9.000> <1.400, 0.992, 9.807> <1.264, 0.982, 10.884> <1.161, 0.974, 11.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.144, 0.258, 11.980> <-1.177, 0.471, 11.894> <-1.154, 0.759, 11.778> <-1.158, 0.974, 11.691> 
		<-1.061, 0.375, 12.603> <-1.094, 0.588, 12.517> <-1.054, 0.848, 12.355> <-1.058, 1.063, 12.269> 
		<-0.960, 0.668, 13.411> <-0.983, 0.768, 13.304> <-1.104, 1.091, 13.091> <-0.963, 1.121, 13.059> 
		<-0.816, 0.933, 13.975> <-0.838, 1.033, 13.868> <-0.966, 1.240, 13.648> <-0.825, 1.270, 13.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.144, 0.258, 11.980> <-1.061, 0.375, 12.603> <-0.960, 0.668, 13.411> <-0.816, 0.933, 13.975> 
		<-1.119, 0.092, 12.047> <-1.035, 0.209, 12.670> <-0.943, 0.590, 13.495> <-0.798, 0.854, 14.058> 
		<-1.115, -0.183, 12.157> <-1.046, -0.005, 12.813> <-0.918, 0.364, 13.631> <-0.792, 0.724, 14.198> 
		<-0.965, -0.277, 12.195> <-0.895, -0.098, 12.851> <-0.820, 0.322, 13.676> <-0.693, 0.681, 14.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.965, -0.277, 12.195> <-0.895, -0.098, 12.851> <-0.820, 0.322, 13.676> <-0.693, 0.681, 14.243> 
		<-0.719, -0.431, 12.257> <-0.650, -0.252, 12.913> <-0.649, 0.248, 13.754> <-0.523, 0.608, 14.321> 
		<-0.293, -0.458, 12.268> <-0.298, -0.259, 12.935> <-0.229, 0.200, 13.762> <-0.234, 0.596, 14.334> 
		<0.003, -0.458, 12.268> <-0.002, -0.259, 12.935> <-0.027, 0.200, 13.762> <-0.033, 0.596, 14.334> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.003, -0.458, 12.268> <-0.002, -0.259, 12.935> <-0.027, 0.200, 13.762> <-0.033, 0.596, 14.334> 
		<0.298, -0.458, 12.268> <0.294, -0.259, 12.935> <0.174, 0.200, 13.762> <0.168, 0.596, 14.334> 
		<0.723, -0.430, 12.257> <0.644, -0.251, 12.914> <0.594, 0.248, 13.754> <0.456, 0.608, 14.321> 
		<0.968, -0.277, 12.195> <0.889, -0.098, 12.853> <0.764, 0.321, 13.676> <0.626, 0.681, 14.243> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.968, -0.277, 12.195> <0.889, -0.098, 12.853> <0.764, 0.321, 13.676> <0.626, 0.681, 14.243> 
		<1.118, -0.183, 12.157> <1.040, -0.004, 12.815> <0.862, 0.364, 13.630> <0.724, 0.724, 14.198> 
		<1.122, 0.092, 12.047> <1.029, 0.209, 12.672> <0.886, 0.589, 13.494> <0.731, 0.854, 14.058> 
		<1.147, 0.258, 11.980> <1.055, 0.375, 12.605> <0.904, 0.668, 13.410> <0.748, 0.933, 13.975> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.147, 0.258, 11.980> <1.055, 0.375, 12.605> <0.904, 0.668, 13.410> <0.748, 0.933, 13.975> 
		<1.180, 0.471, 11.894> <1.087, 0.588, 12.519> <0.926, 0.768, 13.303> <0.771, 1.033, 13.868> 
		<1.157, 0.759, 11.778> <1.036, 0.848, 12.355> <1.047, 1.091, 13.090> <0.899, 1.240, 13.648> 
		<1.161, 0.974, 11.691> <1.040, 1.063, 12.269> <0.906, 1.121, 13.057> <0.758, 1.270, 13.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.816, 0.933, 13.975> <-0.838, 1.033, 13.868> <-0.966, 1.240, 13.648> <-0.825, 1.270, 13.616> 
		<-0.676, 1.189, 14.520> <-0.698, 1.289, 14.414> <-0.816, 1.402, 14.254> <-0.675, 1.432, 14.221> 
		<-0.309, 1.472, 15.305> <-0.314, 1.479, 15.274> <-0.351, 1.519, 15.135> <-0.320, 1.521, 15.126> 
		<-0.204, 1.979, 15.643> <-0.209, 1.986, 15.612> <-0.237, 2.001, 15.548> <-0.206, 2.003, 15.539> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.816, 0.933, 13.975> <-0.676, 1.189, 14.520> <-0.309, 1.472, 15.305> <-0.204, 1.979, 15.643> 
		<-0.798, 0.854, 14.058> <-0.658, 1.111, 14.604> <-0.305, 1.466, 15.329> <-0.200, 1.973, 15.668> 
		<-0.792, 0.724, 14.198> <-0.679, 1.043, 14.701> <-0.283, 1.438, 15.417> <-0.199, 1.964, 15.708> 
		<-0.693, 0.681, 14.243> <-0.581, 1.001, 14.746> <-0.262, 1.435, 15.431> <-0.177, 1.961, 15.721> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.693, 0.681, 14.243> <-0.581, 1.001, 14.746> <-0.262, 1.435, 15.431> <-0.177, 1.961, 15.721> 
		<-0.523, 0.608, 14.321> <-0.410, 0.927, 14.825> <-0.225, 1.430, 15.453> <-0.140, 1.956, 15.744> 
		<-0.234, 0.596, 14.334> <-0.240, 0.931, 14.817> <-0.077, 1.433, 15.477> <-0.077, 1.955, 15.748> 
		<-0.033, 0.596, 14.334> <-0.038, 0.931, 14.817> <-0.033, 1.433, 15.477> <-0.033, 1.955, 15.748> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.033, 0.596, 14.334> <-0.038, 0.931, 14.817> <-0.033, 1.433, 15.477> <-0.033, 1.955, 15.748> 
		<0.168, 0.596, 14.334> <0.163, 0.931, 14.817> <0.010, 1.433, 15.477> <0.010, 1.955, 15.748> 
		<0.456, 0.608, 14.321> <0.334, 0.926, 14.823> <0.158, 1.430, 15.453> <0.073, 1.956, 15.744> 
		<0.626, 0.681, 14.243> <0.504, 1.000, 14.745> <0.195, 1.435, 15.431> <0.110, 1.961, 15.721> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.626, 0.681, 14.243> <0.504, 1.000, 14.745> <0.195, 1.435, 15.431> <0.110, 1.961, 15.721> 
		<0.724, 0.724, 14.198> <0.602, 1.042, 14.699> <0.216, 1.438, 15.417> <0.131, 1.964, 15.708> 
		<0.731, 0.854, 14.058> <0.581, 1.110, 14.602> <0.238, 1.466, 15.329> <0.133, 1.973, 15.668> 
		<0.748, 0.933, 13.975> <0.598, 1.188, 14.518> <0.242, 1.472, 15.305> <0.137, 1.979, 15.643> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.748, 0.933, 13.975> <0.598, 1.188, 14.518> <0.242, 1.472, 15.305> <0.137, 1.979, 15.643> 
		<0.771, 1.033, 13.868> <0.621, 1.288, 14.411> <0.247, 1.479, 15.274> <0.142, 1.986, 15.612> 
		<0.899, 1.240, 13.648> <0.738, 1.401, 14.251> <0.284, 1.519, 15.135> <0.169, 2.001, 15.548> 
		<0.758, 1.270, 13.616> <0.597, 1.431, 14.219> <0.253, 1.521, 15.126> <0.139, 2.003, 15.539> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.204, 1.979, 15.643> <-0.083, 2.559, 16.031> <-0.157, 3.579, 16.354> <-0.123, 4.270, 16.203> 
		<-0.200, 1.973, 15.668> <-0.080, 2.554, 16.055> <-0.155, 3.591, 16.368> <-0.121, 4.282, 16.217> 
		<-0.199, 1.964, 15.708> <-0.098, 2.590, 16.054> <-0.146, 3.611, 16.452> <-0.123, 4.300, 16.239> 
		<-0.177, 1.961, 15.721> <-0.076, 2.587, 16.067> <-0.132, 3.619, 16.461> <-0.109, 4.308, 16.249> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.204, 1.979, 15.643> <-0.209, 1.986, 15.612> <-0.237, 2.001, 15.548> <-0.206, 2.003, 15.539> 
		<-0.083, 2.559, 16.031> <-0.088, 2.566, 16.000> <-0.114, 2.516, 15.989> <-0.083, 2.518, 15.980> 
		<-0.157, 3.579, 16.354> <-0.160, 3.564, 16.336> <-0.181, 3.572, 16.365> <-0.159, 3.565, 16.358> 
		<-0.123, 4.270, 16.203> <-0.125, 4.254, 16.184> <-0.146, 4.225, 16.148> <-0.124, 4.218, 16.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.177, 1.961, 15.721> <-0.076, 2.587, 16.067> <-0.132, 3.619, 16.461> <-0.109, 4.308, 16.249> 
		<-0.140, 1.956, 15.744> <-0.039, 2.581, 16.090> <-0.115, 3.629, 16.473> <-0.091, 4.318, 16.261> 
		<-0.077, 1.955, 15.748> <-0.077, 2.600, 16.082> <-0.057, 3.626, 16.477> <-0.057, 4.321, 16.265> 
		<-0.033, 1.955, 15.748> <-0.034, 2.600, 16.082> <-0.033, 3.626, 16.477> <-0.034, 4.321, 16.265> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.033, 1.955, 15.748> <-0.034, 2.600, 16.082> <-0.033, 3.626, 16.477> <-0.034, 4.321, 16.265> 
		<0.010, 1.955, 15.748> <0.010, 2.600, 16.082> <-0.010, 3.626, 16.477> <-0.010, 4.321, 16.265> 
		<0.073, 1.956, 15.744> <-0.028, 2.581, 16.090> <0.048, 3.629, 16.473> <0.024, 4.318, 16.261> 
		<0.110, 1.961, 15.721> <0.009, 2.587, 16.067> <0.065, 3.619, 16.461> <0.042, 4.308, 16.249> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.110, 1.961, 15.721> <0.009, 2.587, 16.067> <0.065, 3.619, 16.461> <0.042, 4.308, 16.249> 
		<0.131, 1.964, 15.708> <0.031, 2.590, 16.054> <0.079, 3.611, 16.452> <0.055, 4.300, 16.239> 
		<0.133, 1.973, 15.668> <0.012, 2.554, 16.055> <0.088, 3.591, 16.368> <0.054, 4.282, 16.217> 
		<0.137, 1.979, 15.643> <0.016, 2.559, 16.031> <0.090, 3.579, 16.354> <0.056, 4.270, 16.203> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.137, 1.979, 15.643> <0.016, 2.559, 16.031> <0.090, 3.579, 16.354> <0.056, 4.270, 16.203> 
		<0.142, 1.986, 15.612> <0.021, 2.566, 16.000> <0.093, 3.564, 16.336> <0.058, 4.254, 16.184> 
		<0.169, 2.001, 15.548> <0.047, 2.516, 15.989> <0.114, 3.572, 16.365> <0.079, 4.225, 16.148> 
		<0.139, 2.003, 15.539> <0.016, 2.518, 15.980> <0.092, 3.565, 16.358> <0.057, 4.218, 16.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 5.859, 14.555> <-0.034, 5.398, 15.068> <-0.034, 4.981, 16.063> <-0.034, 4.321, 16.265> 
		<-0.070, 5.859, 14.555> <-0.070, 5.398, 15.068> <-0.057, 4.981, 16.063> <-0.057, 4.321, 16.265> 
		<-0.048, 5.771, 14.541> <-0.075, 5.342, 15.048> <-0.070, 4.953, 16.065> <-0.091, 4.318, 16.261> 
		<-0.048, 5.738, 14.558> <-0.075, 5.309, 15.065> <-0.087, 4.943, 16.053> <-0.109, 4.308, 16.249> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 5.859, 14.555> <-0.034, 5.859, 14.555> <-0.034, 5.859, 14.555> <-0.034, 5.859, 14.555> 
		<0.003, 5.859, 14.555> <-0.034, 5.859, 14.555> <-0.034, 5.859, 14.555> <-0.070, 5.859, 14.555> 
		<-0.020, 5.771, 14.541> <-0.020, 5.776, 14.534> <-0.047, 5.776, 14.534> <-0.048, 5.771, 14.541> 
		<-0.019, 5.738, 14.558> <-0.019, 5.743, 14.551> <-0.048, 5.743, 14.551> <-0.048, 5.738, 14.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.034, 5.859, 14.555> <0.003, 5.859, 14.555> <-0.020, 5.771, 14.541> <-0.019, 5.738, 14.558> 
		<-0.034, 5.398, 15.068> <0.003, 5.398, 15.068> <0.007, 5.342, 15.048> <0.008, 5.309, 15.065> 
		<-0.034, 4.981, 16.063> <-0.010, 4.981, 16.063> <0.003, 4.953, 16.065> <0.020, 4.943, 16.053> 
		<-0.034, 4.321, 16.265> <-0.010, 4.321, 16.265> <0.024, 4.318, 16.261> <0.042, 4.308, 16.249> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.123, 4.270, 16.203> <-0.125, 4.254, 16.184> <-0.146, 4.225, 16.148> <-0.124, 4.218, 16.141> 
		<-0.102, 4.696, 16.109> <-0.104, 4.680, 16.091> <-0.120, 4.710, 15.987> <-0.098, 4.703, 15.979> 
		<-0.083, 4.810, 15.340> <-0.083, 4.684, 15.343> <-0.084, 4.737, 15.164> <-0.084, 4.694, 15.045> 
		<-0.051, 5.041, 14.971> <-0.051, 4.915, 14.974> <-0.051, 4.940, 14.695> <-0.051, 4.897, 14.577> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.123, 4.270, 16.203> <-0.102, 4.696, 16.109> <-0.083, 4.810, 15.340> <-0.051, 5.041, 14.971> 
		<-0.121, 4.282, 16.217> <-0.100, 4.707, 16.123> <-0.082, 5.053, 15.334> <-0.050, 5.284, 14.965> 
		<-0.123, 4.300, 16.239> <-0.101, 4.935, 16.044> <-0.080, 5.092, 15.175> <-0.053, 5.521, 14.668> 
		<-0.109, 4.308, 16.249> <-0.087, 4.943, 16.053> <-0.075, 5.309, 15.065> <-0.048, 5.738, 14.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 4.308, 16.249> <0.020, 4.943, 16.053> <0.008, 5.309, 15.065> <-0.019, 5.738, 14.558> 
		<0.055, 4.300, 16.239> <0.034, 4.935, 16.044> <0.013, 5.092, 15.175> <-0.014, 5.521, 14.668> 
		<0.054, 4.282, 16.217> <0.032, 4.707, 16.123> <0.015, 5.053, 15.334> <-0.017, 5.284, 14.965> 
		<0.056, 4.270, 16.203> <0.034, 4.696, 16.109> <0.016, 4.810, 15.340> <-0.016, 5.041, 14.971> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.056, 4.270, 16.203> <0.034, 4.696, 16.109> <0.016, 4.810, 15.340> <-0.016, 5.041, 14.971> 
		<0.058, 4.254, 16.184> <0.037, 4.680, 16.091> <0.016, 4.684, 15.343> <-0.016, 4.915, 14.974> 
		<0.079, 4.225, 16.148> <0.053, 4.710, 15.987> <0.016, 4.736, 15.164> <-0.005, 4.940, 14.695> 
		<0.057, 4.218, 16.141> <0.031, 4.703, 15.979> <0.006, 4.693, 15.046> <-0.016, 4.897, 14.577> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 3.378, -12.736> <-0.059, 3.183, -12.762> <-0.127, 2.903, -12.819> <-0.135, 2.726, -12.732> 
		<-0.041, 3.379, -12.722> <-0.059, 3.184, -12.748> <-0.127, 2.919, -12.778> <-0.136, 2.742, -12.690> 
		<-0.013, 3.393, -12.725> <-0.013, 3.208, -12.745> <-0.045, 2.930, -12.796> <-0.045, 2.775, -12.694> 
		<0.001, 3.393, -12.725> <0.001, 3.208, -12.745> <-0.000, 2.930, -12.796> <-0.001, 2.775, -12.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 3.378, -12.736> <-0.041, 3.379, -12.722> <-0.013, 3.393, -12.725> <0.001, 3.393, -12.725> 
		<-0.027, 3.526, -12.716> <-0.026, 3.527, -12.702> <-0.013, 3.540, -12.708> <0.001, 3.540, -12.708> 
		<-0.032, 3.709, -12.626> <-0.032, 3.712, -12.618> <-0.009, 3.718, -12.612> <0.000, 3.718, -12.611> 
		<-0.028, 3.851, -12.579> <-0.028, 3.854, -12.571> <-0.009, 3.861, -12.573> <-0.000, 3.861, -12.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 3.378, -12.736> <-0.027, 3.526, -12.716> <-0.032, 3.709, -12.626> <-0.028, 3.851, -12.579> 
		<-0.041, 3.374, -12.780> <-0.027, 3.521, -12.760> <-0.032, 3.706, -12.636> <-0.028, 3.848, -12.589> 
		<-0.044, 3.378, -12.877> <-0.044, 3.536, -12.832> <-0.011, 3.712, -12.690> <-0.011, 3.851, -12.602> 
		<0.000, 3.378, -12.877> <0.000, 3.536, -12.832> <0.000, 3.712, -12.689> <0.000, 3.851, -12.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 3.378, -12.877> <0.000, 3.536, -12.832> <0.000, 3.712, -12.689> <0.000, 3.851, -12.602> 
		<0.044, 3.378, -12.877> <0.044, 3.536, -12.832> <0.011, 3.712, -12.689> <0.011, 3.851, -12.602> 
		<0.040, 3.374, -12.780> <0.026, 3.521, -12.759> <0.033, 3.706, -12.636> <0.029, 3.848, -12.589> 
		<0.041, 3.378, -12.736> <0.027, 3.526, -12.716> <0.033, 3.709, -12.625> <0.029, 3.851, -12.578> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.051, 4.897, 14.577> <-0.051, 4.901, 14.567> <-0.017, 4.893, 14.567> <-0.016, 4.897, 14.577> 
		<-0.051, 4.940, 14.695> <-0.051, 4.944, 14.685> <-0.006, 4.936, 14.685> <-0.005, 4.940, 14.695> 
		<-0.051, 4.915, 14.974> <-0.051, 4.920, 14.965> <-0.016, 4.920, 14.965> <-0.016, 4.915, 14.974> 
		<-0.051, 5.041, 14.971> <-0.050, 5.046, 14.962> <-0.017, 5.046, 14.962> <-0.016, 5.041, 14.971> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.051, 4.897, 14.577> <-0.084, 4.694, 15.045> <-0.098, 4.703, 15.979> <-0.124, 4.218, 16.141> 
		<-0.051, 4.901, 14.567> <-0.083, 4.698, 15.036> <-0.049, 4.689, 15.962> <-0.074, 4.204, 16.123> 
		<-0.017, 4.893, 14.567> <0.005, 4.690, 15.036> <-0.019, 4.689, 15.962> <0.007, 4.204, 16.123> 
		<-0.016, 4.897, 14.577> <0.006, 4.693, 15.046> <0.031, 4.703, 15.979> <0.057, 4.218, 16.141> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.051, 5.041, 14.971> <-0.050, 5.046, 14.962> <-0.017, 5.046, 14.962> <-0.016, 5.041, 14.971> 
		<-0.050, 5.284, 14.965> <-0.049, 5.289, 14.957> <-0.018, 5.289, 14.957> <-0.017, 5.284, 14.965> 
		<-0.053, 5.521, 14.668> <-0.053, 5.527, 14.661> <-0.015, 5.527, 14.661> <-0.014, 5.521, 14.668> 
		<-0.048, 5.738, 14.558> <-0.048, 5.743, 14.551> <-0.019, 5.743, 14.551> <-0.019, 5.738, 14.558> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.124, 4.218, 16.141> <-0.159, 3.565, 16.358> <-0.083, 2.518, 15.980> <-0.206, 2.003, 15.539> 
		<-0.074, 4.204, 16.123> <-0.109, 3.551, 16.341> <0.015, 2.525, 15.950> <-0.107, 2.010, 15.509> 
		<0.007, 4.204, 16.123> <0.042, 3.551, 16.341> <-0.082, 2.525, 15.950> <0.040, 2.010, 15.509> 
		<0.057, 4.218, 16.141> <0.092, 3.565, 16.358> <0.016, 2.518, 15.980> <0.139, 2.003, 15.539> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.216, -12.362> <-0.083, 1.216, -12.362> <-0.165, 1.191, -12.238> <-0.186, 1.200, -12.159> 
		<0.002, 1.139, -12.431> <-0.080, 1.139, -12.431> <-0.175, 1.110, -12.289> <-0.196, 1.118, -12.209> 
		<0.017, 1.091, -12.569> <-0.098, 1.091, -12.572> <-0.178, 1.021, -12.405> <-0.206, 1.018, -12.293> 
		<0.018, 1.042, -12.660> <-0.097, 1.042, -12.664> <-0.183, 0.957, -12.476> <-0.211, 0.954, -12.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.216, -12.362> <0.002, 1.139, -12.431> <0.017, 1.091, -12.569> <0.018, 1.042, -12.660> 
		<0.083, 1.216, -12.362> <0.085, 1.139, -12.431> <0.130, 1.091, -12.565> <0.130, 1.042, -12.657> 
		<0.165, 1.191, -12.238> <0.175, 1.112, -12.287> <0.183, 1.020, -12.392> <0.189, 0.957, -12.462> 
		<0.186, 1.200, -12.159> <0.196, 1.120, -12.207> <0.209, 1.017, -12.282> <0.214, 0.954, -12.352> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 1.216, -12.362> <-0.083, 1.216, -12.362> <-0.165, 1.191, -12.238> <-0.186, 1.200, -12.159> 
		<0.083, 1.216, -12.362> <0.000, 1.216, -12.362> <-0.108, 1.201, -12.166> <-0.130, 1.210, -12.087> 
		<0.165, 1.191, -12.238> <0.109, 1.201, -12.166> <0.001, 1.233, -11.919> <-0.091, 1.233, -11.919> 
		<0.186, 1.200, -12.159> <0.131, 1.210, -12.087> <0.093, 1.233, -11.919> <0.001, 1.233, -11.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.214, 0.954, -12.352> <0.376, 0.937, -11.651> <0.561, 0.973, -10.706> <0.636, 0.976, -9.990> 
		<0.209, 1.017, -12.282> <0.371, 0.999, -11.581> <0.562, 1.120, -10.705> <0.637, 1.122, -9.989> 
		<0.196, 1.120, -12.207> <0.369, 1.187, -11.564> <0.501, 1.238, -10.641> <0.636, 1.317, -9.990> 
		<0.186, 1.200, -12.159> <0.358, 1.267, -11.516> <0.501, 1.384, -10.641> <0.636, 1.464, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.211, 0.954, -12.365> <-0.206, 1.018, -12.293> <-0.196, 1.118, -12.209> <-0.186, 1.200, -12.159> 
		<-0.383, 0.937, -11.662> <-0.378, 1.001, -11.590> <-0.368, 1.186, -11.566> <-0.358, 1.267, -11.516> 
		<-0.561, 0.973, -10.710> <-0.562, 1.119, -10.709> <-0.501, 1.238, -10.641> <-0.501, 1.384, -10.641> 
		<-0.636, 0.976, -9.990> <-0.637, 1.122, -9.989> <-0.636, 1.317, -9.990> <-0.636, 1.464, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.119, 1.694, -11.904> <0.125, 1.537, -11.845> <0.168, 1.343, -12.072> <0.186, 1.200, -12.159> 
		<0.083, 1.704, -11.822> <0.088, 1.547, -11.763> <0.112, 1.353, -12.000> <0.131, 1.210, -12.087> 
		<0.088, 1.728, -11.631> <0.089, 1.574, -11.553> <0.092, 1.381, -11.832> <0.093, 1.233, -11.919> 
		<-0.002, 1.728, -11.631> <-0.002, 1.574, -11.553> <0.000, 1.381, -11.832> <0.001, 1.233, -11.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.119, 1.694, -11.904> <0.107, 2.066, -12.044> <0.152, 2.371, -12.556> <0.135, 2.726, -12.732> 
		<0.083, 1.704, -11.822> <0.071, 2.076, -11.962> <0.152, 2.387, -12.514> <0.135, 2.742, -12.690> 
		<0.088, 1.728, -11.631> <0.088, 2.128, -11.832> <0.043, 2.400, -12.448> <0.044, 2.775, -12.694> 
		<-0.002, 1.728, -11.631> <-0.003, 2.128, -11.832> <-0.001, 2.400, -12.448> <-0.001, 2.775, -12.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.119, 1.694, -11.904> <0.125, 1.537, -11.845> <0.168, 1.343, -12.072> <0.186, 1.200, -12.159> 
		<0.290, 1.742, -11.335> <0.295, 1.585, -11.276> <0.340, 1.410, -11.429> <0.358, 1.267, -11.516> 
		<0.481, 1.785, -10.564> <0.481, 1.677, -10.564> <0.501, 1.493, -10.641> <0.501, 1.384, -10.641> 
		<0.636, 1.824, -9.990> <0.636, 1.716, -9.990> <0.636, 1.572, -9.990> <0.636, 1.464, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 1.694, -11.904> <-0.084, 1.704, -11.822> <-0.092, 1.728, -11.631> <-0.002, 1.728, -11.631> 
		<-0.125, 1.537, -11.845> <-0.089, 1.547, -11.763> <-0.092, 1.574, -11.553> <-0.002, 1.574, -11.553> 
		<-0.168, 1.342, -12.071> <-0.112, 1.352, -11.999> <-0.092, 1.381, -11.832> <0.000, 1.381, -11.832> 
		<-0.186, 1.200, -12.159> <-0.130, 1.210, -12.087> <-0.091, 1.233, -11.919> <0.001, 1.233, -11.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 1.694, -11.904> <-0.084, 1.704, -11.822> <-0.092, 1.728, -11.631> <-0.002, 1.728, -11.631> 
		<-0.107, 2.066, -12.044> <-0.072, 2.076, -11.962> <-0.092, 2.128, -11.832> <-0.003, 2.128, -11.832> 
		<-0.152, 2.371, -12.556> <-0.152, 2.387, -12.515> <-0.046, 2.400, -12.448> <-0.001, 2.400, -12.448> 
		<-0.135, 2.726, -12.732> <-0.136, 2.742, -12.690> <-0.045, 2.775, -12.694> <-0.001, 2.775, -12.694> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.119, 1.694, -11.904> <-0.290, 1.742, -11.335> <-0.481, 1.785, -10.564> <-0.636, 1.824, -9.990> 
		<-0.125, 1.537, -11.845> <-0.295, 1.585, -11.276> <-0.481, 1.677, -10.564> <-0.636, 1.716, -9.990> 
		<-0.168, 1.342, -12.071> <-0.341, 1.409, -11.428> <-0.501, 1.493, -10.641> <-0.636, 1.572, -9.990> 
		<-0.186, 1.200, -12.159> <-0.358, 1.267, -11.516> <-0.501, 1.384, -10.641> <-0.636, 1.464, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.135, 2.726, -12.732> <0.127, 2.903, -12.819> <0.059, 3.183, -12.762> <0.041, 3.378, -12.736> 
		<0.135, 2.742, -12.690> <0.127, 2.919, -12.777> <0.059, 3.184, -12.749> <0.041, 3.379, -12.723> 
		<0.044, 2.775, -12.694> <0.044, 2.930, -12.796> <0.014, 3.208, -12.745> <0.014, 3.393, -12.725> 
		<-0.001, 2.775, -12.694> <-0.000, 2.930, -12.796> <0.001, 3.208, -12.745> <0.001, 3.393, -12.725> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.041, 3.378, -12.736> <0.027, 3.526, -12.716> <0.033, 3.709, -12.625> <0.029, 3.851, -12.578> 
		<0.041, 3.379, -12.723> <0.027, 3.527, -12.702> <0.033, 3.712, -12.617> <0.029, 3.854, -12.569> 
		<0.014, 3.393, -12.725> <0.014, 3.540, -12.708> <0.010, 3.718, -12.611> <0.009, 3.861, -12.573> 
		<0.001, 3.393, -12.725> <0.001, 3.540, -12.708> <0.000, 3.718, -12.611> <-0.000, 3.861, -12.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.028, 3.851, -12.579> <-0.028, 3.851, -12.579> <-0.028, 3.851, -12.579> <-0.028, 3.851, -12.579> 
		<-0.028, 3.848, -12.589> <-0.028, 3.851, -12.581> <-0.028, 3.851, -12.581> <-0.028, 3.854, -12.571> 
		<-0.011, 3.851, -12.602> <-0.011, 3.859, -12.597> <-0.009, 3.870, -12.571> <-0.009, 3.861, -12.573> 
		<0.000, 3.851, -12.602> <-0.000, 3.859, -12.597> <-0.000, 3.870, -12.571> <-0.000, 3.861, -12.573> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.029, 3.851, -12.578> <0.029, 3.851, -12.578> <0.029, 3.851, -12.578> <0.029, 3.851, -12.578> 
		<0.029, 3.854, -12.569> <0.029, 3.851, -12.580> <0.029, 3.851, -12.580> <0.029, 3.848, -12.589> 
		<0.009, 3.861, -12.573> <0.009, 3.870, -12.571> <0.011, 3.859, -12.597> <0.011, 3.851, -12.602> 
		<-0.000, 3.861, -12.573> <-0.000, 3.870, -12.571> <-0.000, 3.859, -12.597> <0.000, 3.851, -12.602> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.139, 2.003, 15.539> <0.040, 2.010, 15.509> <-0.107, 2.010, 15.509> <-0.206, 2.003, 15.539> 
		<0.253, 1.521, 15.126> <0.155, 1.528, 15.096> <-0.222, 1.528, 15.096> <-0.320, 1.521, 15.126> 
		<0.597, 1.431, 14.219> <0.144, 1.528, 14.116> <-0.222, 1.529, 14.118> <-0.675, 1.432, 14.221> 
		<0.758, 1.270, 13.616> <0.304, 1.367, 13.512> <-0.372, 1.367, 13.512> <-0.825, 1.270, 13.616> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.758, 1.270, 13.616> <0.304, 1.367, 13.512> <-0.372, 1.367, 13.512> <-0.825, 1.270, 13.616> 
		<0.906, 1.121, 13.057> <0.453, 1.218, 12.954> <-0.510, 1.218, 12.955> <-0.963, 1.121, 13.059> 
		<1.040, 1.063, 12.269> <0.344, 1.063, 12.269> <-0.362, 1.063, 12.269> <-1.058, 1.063, 12.269> 
		<1.161, 0.974, 11.691> <0.465, 0.974, 11.691> <-0.462, 0.974, 11.691> <-1.158, 0.974, 11.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.161, 0.974, 11.691> <0.465, 0.974, 11.691> <-0.462, 0.974, 11.691> <-1.158, 0.974, 11.691> 
		<1.264, 0.982, 10.884> <0.568, 0.982, 10.884> <-0.565, 0.982, 10.884> <-1.260, 0.982, 10.884> 
		<1.400, 0.992, 9.807> <0.500, 0.992, 9.807> <-0.496, 0.992, 9.807> <-1.397, 0.992, 9.807> 
		<1.503, 1.000, 9.000> <0.602, 1.000, 9.000> <-0.599, 1.000, 9.000> <-1.500, 1.000, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.500, 1.000, 9.000> <-1.500, 1.000, 6.300> <-1.500, 1.000, 2.700> <-1.500, 1.000, 0.000> 
		<-0.599, 1.000, 9.000> <-0.599, 1.000, 6.300> <-0.599, 1.000, 2.700> <-0.599, 1.000, 0.000> 
		<0.602, 1.000, 9.000> <0.602, 1.000, 6.300> <0.602, 1.000, 2.700> <0.602, 1.000, 0.000> 
		<1.503, 1.000, 9.000> <1.503, 1.000, 6.300> <1.503, 1.000, 2.700> <1.503, 1.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.500, 1.000, 0.000> <-1.241, 0.993, -2.997> <-0.948, 0.987, -6.998> <-0.636, 0.976, -9.990> 
		<-0.599, 1.000, 0.000> <-0.340, 0.993, -2.997> <-0.566, 0.987, -6.998> <-0.254, 0.976, -9.990> 
		<0.602, 1.000, 0.000> <0.342, 0.993, -2.997> <0.567, 0.987, -6.998> <0.254, 0.976, -9.990> 
		<1.503, 1.000, 0.000> <1.243, 0.993, -2.997> <0.948, 0.987, -6.998> <0.636, 0.976, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.636, 0.976, -9.990> <-0.637, 1.122, -9.989> <-0.636, 1.317, -9.990> <-0.636, 1.464, -9.990> 
		<-0.254, 0.976, -9.990> <-0.255, 1.122, -9.989> <-0.254, 1.317, -9.990> <-0.254, 1.464, -9.990> 
		<0.254, 0.976, -9.990> <0.255, 1.122, -9.989> <0.254, 1.317, -9.990> <0.254, 1.464, -9.990> 
		<0.636, 0.976, -9.990> <0.637, 1.122, -9.989> <0.636, 1.317, -9.990> <0.636, 1.464, -9.990> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.636, 1.464, -9.990> <-0.636, 1.572, -9.990> <-0.636, 1.716, -9.990> <-0.636, 1.824, -9.990> 
		<-0.254, 1.464, -9.990> <-0.254, 1.572, -9.990> <-0.254, 1.716, -9.990> <-0.254, 1.824, -9.990> 
		<0.254, 1.464, -9.990> <0.254, 1.572, -9.990> <0.254, 1.716, -9.990> <0.254, 1.824, -9.990> 
		<0.636, 1.464, -9.990> <0.636, 1.572, -9.990> <0.636, 1.716, -9.990> <0.636, 1.824, -9.990> 
	}
    texture {eye_tex}

}
// Layer 2  oarboxes
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.642, 0.954, -10.048> <0.781, 1.038, -9.932> <1.004, 1.087, -9.747> <1.107, 1.236, -9.661> 
		<0.641, 1.213, -10.052> <0.780, 1.298, -9.935> <0.996, 1.193, -9.754> <1.099, 1.342, -9.668> 
		<0.639, 1.559, -10.056> <0.772, 1.491, -9.943> <0.984, 1.612, -9.765> <1.088, 1.483, -9.677> 
		<0.638, 1.819, -10.059> <0.770, 1.750, -9.947> <0.976, 1.718, -9.772> <1.080, 1.589, -9.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.642, 0.954, -10.048> <0.641, 1.213, -10.052> <0.639, 1.559, -10.056> <0.638, 1.819, -10.059> 
		<0.904, 0.947, -7.032> <0.902, 1.207, -7.036> <0.897, 1.553, -7.037> <0.895, 1.812, -7.040> 
		<1.379, 0.939, -3.020> <1.373, 1.199, -3.020> <1.368, 1.545, -3.023> <1.363, 1.805, -3.023> 
		<1.515, 0.932, 0.004> <1.509, 1.191, 0.004> <1.502, 1.537, 0.004> <1.497, 1.797, 0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.642, 0.954, -10.048> <0.904, 0.947, -7.032> <1.379, 0.939, -3.020> <1.515, 0.932, 0.004> 
		<0.781, 1.038, -9.932> <1.043, 1.032, -6.916> <1.557, 1.024, -3.020> <1.693, 1.016, 0.004> 
		<1.004, 1.087, -9.747> <1.305, 1.080, -6.847> <1.826, 1.073, -2.907> <1.980, 1.066, 0.004> 
		<1.107, 1.236, -9.661> <1.408, 1.230, -6.762> <1.956, 1.222, -2.907> <2.110, 1.214, 0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.515, 0.932, 0.004> <1.509, 1.191, 0.004> <1.502, 1.537, 0.004> <1.497, 1.797, 0.004> 
		<1.636, 0.925, 2.704> <1.631, 1.185, 2.704> <1.622, 1.531, 2.704> <1.616, 1.790, 2.704> 
		<1.575, 0.901, 6.312> <1.570, 1.161, 6.312> <1.564, 1.514, 6.312> <1.559, 1.774, 6.312> 
		<1.499, 0.906, 9.014> <1.493, 1.166, 9.014> <1.486, 1.512, 9.014> <1.481, 1.771, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.515, 0.932, 0.004> <1.636, 0.925, 2.704> <1.575, 0.901, 6.312> <1.499, 0.906, 9.014> 
		<1.693, 1.016, 0.004> <1.815, 1.010, 2.704> <1.754, 0.986, 6.312> <1.677, 0.991, 9.014> 
		<1.980, 1.066, 0.004> <2.122, 1.059, 2.703> <2.057, 1.055, 6.312> <1.964, 1.040, 9.014> 
		<2.110, 1.214, 0.004> <2.253, 1.207, 2.703> <2.188, 1.203, 6.312> <2.094, 1.189, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.110, 1.214, 0.004> <2.181, 1.294, 0.004> <2.153, 1.494, 0.004> <2.075, 1.567, 0.004> 
		<1.956, 1.222, -2.907> <2.027, 1.302, -2.907> <2.000, 1.502, -2.914> <1.923, 1.575, -2.914> 
		<1.408, 1.230, -6.762> <1.463, 1.309, -6.716> <1.438, 1.510, -6.728> <1.379, 1.583, -6.778> 
		<1.107, 1.236, -9.661> <1.161, 1.316, -9.616> <1.139, 1.516, -9.634> <1.080, 1.589, -9.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.110, 1.214, 0.004> <2.181, 1.294, 0.004> <2.153, 1.494, 0.004> <2.075, 1.567, 0.004> 
		<1.956, 1.222, -2.907> <2.027, 1.302, -2.907> <2.000, 1.502, -2.914> <1.923, 1.575, -2.914> 
		<1.408, 1.230, -6.762> <1.400, 1.336, -6.769> <1.387, 1.477, -6.771> <1.379, 1.583, -6.778> 
		<1.107, 1.236, -9.661> <1.099, 1.342, -9.668> <1.088, 1.483, -9.677> <1.080, 1.589, -9.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.110, 1.214, 0.004> <2.253, 1.207, 2.703> <2.188, 1.203, 6.312> <2.094, 1.189, 9.014> 
		<2.181, 1.294, 0.004> <2.324, 1.287, 2.703> <2.259, 1.283, 6.312> <2.165, 1.269, 9.014> 
		<2.153, 1.494, 0.004> <2.294, 1.487, 2.703> <2.230, 1.485, 6.312> <2.137, 1.469, 9.014> 
		<2.075, 1.567, 0.004> <2.217, 1.561, 2.703> <2.153, 1.558, 6.312> <2.059, 1.542, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.075, 1.567, 0.004> <2.217, 1.561, 2.703> <2.153, 1.558, 6.312> <2.059, 1.542, 9.014> 
		<1.940, 1.696, 0.004> <2.081, 1.689, 2.703> <2.018, 1.687, 6.312> <1.924, 1.670, 9.014> 
		<1.671, 1.728, 0.004> <1.790, 1.721, 2.704> <1.732, 1.705, 6.312> <1.655, 1.703, 9.014> 
		<1.497, 1.797, 0.004> <1.616, 1.790, 2.704> <1.559, 1.774, 6.312> <1.481, 1.771, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.075, 1.567, 0.004> <1.940, 1.696, 0.004> <1.671, 1.728, 0.004> <1.497, 1.797, 0.004> 
		<1.923, 1.575, -2.914> <1.787, 1.703, -2.914> <1.537, 1.736, -3.023> <1.363, 1.805, -3.023> 
		<1.379, 1.583, -6.778> <1.275, 1.712, -6.866> <1.028, 1.744, -6.928> <0.895, 1.812, -7.040> 
		<1.080, 1.589, -9.684> <0.976, 1.718, -9.772> <0.770, 1.750, -9.947> <0.638, 1.819, -10.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.165, 1.788, 11.530> <1.260, 1.783, 10.775> <1.459, 1.771, 9.774> <1.481, 1.771, 9.014> 
		<1.320, 1.701, 11.473> <1.415, 1.696, 10.718> <1.633, 1.702, 9.774> <1.655, 1.703, 9.014> 
		<1.561, 1.638, 11.365> <1.674, 1.652, 10.667> <1.900, 1.666, 9.720> <1.924, 1.670, 9.014> 
		<1.683, 1.498, 11.341> <1.796, 1.511, 10.643> <2.035, 1.538, 9.720> <2.059, 1.542, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.165, 1.788, 11.530> <1.320, 1.701, 11.473> <1.561, 1.638, 11.365> <1.683, 1.498, 11.341> 
		<1.169, 1.538, 11.597> <1.325, 1.450, 11.540> <1.571, 1.535, 11.389> <1.692, 1.395, 11.364> 
		<1.176, 1.203, 11.685> <1.336, 1.263, 11.585> <1.587, 1.129, 11.492> <1.705, 1.257, 11.396> 
		<1.180, 0.952, 11.752> <1.340, 1.012, 11.652> <1.597, 1.026, 11.515> <1.714, 1.154, 11.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.165, 1.788, 11.530> <1.169, 1.538, 11.597> <1.176, 1.203, 11.685> <1.180, 0.952, 11.752> 
		<1.260, 1.783, 10.775> <1.264, 1.532, 10.842> <1.271, 1.189, 10.864> <1.276, 0.938, 10.930> 
		<1.459, 1.771, 9.774> <1.464, 1.511, 9.774> <1.470, 1.167, 9.840> <1.475, 0.908, 9.840> 
		<1.481, 1.771, 9.014> <1.486, 1.512, 9.014> <1.493, 1.166, 9.014> <1.499, 0.906, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.180, 0.952, 11.752> <1.340, 1.012, 11.652> <1.597, 1.026, 11.515> <1.714, 1.154, 11.419> 
		<1.276, 0.938, 10.930> <1.436, 0.999, 10.831> <1.711, 1.037, 10.794> <1.828, 1.164, 10.698> 
		<1.475, 0.908, 9.840> <1.654, 0.992, 9.840> <1.938, 1.036, 9.744> <2.069, 1.185, 9.744> 
		<1.499, 0.906, 9.014> <1.677, 0.991, 9.014> <1.964, 1.040, 9.014> <2.094, 1.189, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.094, 1.189, 9.014> <2.069, 1.185, 9.744> <1.828, 1.164, 10.698> <1.714, 1.154, 11.419> 
		<2.165, 1.269, 9.014> <2.140, 1.265, 9.744> <1.891, 1.233, 10.646> <1.777, 1.222, 11.368> 
		<2.137, 1.469, 9.014> <2.112, 1.464, 9.720> <1.865, 1.432, 10.629> <1.752, 1.418, 11.327> 
		<2.059, 1.542, 9.014> <2.035, 1.538, 9.720> <1.796, 1.511, 10.643> <1.683, 1.498, 11.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<2.094, 1.189, 9.014> <2.069, 1.185, 9.744> <1.828, 1.164, 10.698> <1.714, 1.154, 11.419> 
		<2.165, 1.269, 9.014> <2.140, 1.265, 9.744> <1.819, 1.268, 10.674> <1.705, 1.257, 11.396> 
		<2.137, 1.469, 9.014> <2.112, 1.464, 9.720> <1.805, 1.408, 10.666> <1.692, 1.395, 11.364> 
		<2.059, 1.542, 9.014> <2.035, 1.538, 9.720> <1.796, 1.511, 10.643> <1.683, 1.498, 11.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.634, 0.954, -10.048> <-0.771, 1.038, -9.932> <-0.990, 1.088, -9.746> <-1.090, 1.236, -9.661> 
		<-0.630, 1.213, -10.052> <-0.767, 1.298, -9.935> <-0.982, 1.194, -9.753> <-1.082, 1.342, -9.668> 
		<-0.625, 1.559, -10.056> <-0.758, 1.491, -9.943> <-0.968, 1.612, -9.765> <-1.071, 1.483, -9.677> 
		<-0.621, 1.819, -10.059> <-0.754, 1.750, -9.947> <-0.960, 1.718, -9.772> <-1.063, 1.589, -9.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.634, 0.954, -10.048> <-0.630, 1.213, -10.052> <-0.625, 1.559, -10.056> <-0.621, 1.819, -10.059> 
		<-0.893, 0.947, -7.032> <-0.889, 1.207, -7.036> <-0.883, 1.553, -7.037> <-0.879, 1.812, -7.040> 
		<-1.363, 0.939, -3.020> <-1.358, 1.199, -3.020> <-1.352, 1.545, -3.023> <-1.347, 1.805, -3.023> 
		<-1.498, 0.932, 0.004> <-1.493, 1.191, 0.004> <-1.486, 1.537, 0.004> <-1.480, 1.797, 0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.634, 0.954, -10.048> <-0.893, 0.947, -7.032> <-1.363, 0.939, -3.020> <-1.498, 0.932, 0.004> 
		<-0.771, 1.038, -9.932> <-1.030, 1.032, -6.916> <-1.542, 1.024, -3.020> <-1.677, 1.016, 0.004> 
		<-0.990, 1.088, -9.746> <-1.291, 1.081, -6.847> <-1.809, 1.073, -2.907> <-1.963, 1.066, 0.004> 
		<-1.090, 1.236, -9.661> <-1.391, 1.230, -6.762> <-1.940, 1.222, -2.907> <-2.094, 1.214, 0.004> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.498, 0.932, 0.004> <-1.493, 1.191, 0.004> <-1.486, 1.537, 0.004> <-1.480, 1.797, 0.004> 
		<-1.618, 0.925, 2.704> <-1.613, 1.185, 2.704> <-1.605, 1.531, 2.704> <-1.600, 1.790, 2.704> 
		<-1.559, 0.901, 6.312> <-1.554, 1.161, 6.312> <-1.548, 1.514, 6.312> <-1.542, 1.774, 6.312> 
		<-1.482, 0.906, 9.014> <-1.477, 1.166, 9.014> <-1.470, 1.512, 9.014> <-1.464, 1.771, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.498, 0.932, 0.004> <-1.618, 0.925, 2.704> <-1.559, 0.901, 6.312> <-1.482, 0.906, 9.014> 
		<-1.677, 1.016, 0.004> <-1.797, 1.010, 2.704> <-1.738, 0.986, 6.312> <-1.661, 0.991, 9.014> 
		<-1.963, 1.066, 0.004> <-2.106, 1.059, 2.703> <-2.041, 1.055, 6.312> <-1.947, 1.040, 9.014> 
		<-2.094, 1.214, 0.004> <-2.237, 1.207, 2.703> <-2.172, 1.203, 6.312> <-2.078, 1.189, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.094, 1.214, 0.004> <-2.164, 1.294, 0.004> <-2.136, 1.494, 0.004> <-2.059, 1.567, 0.004> 
		<-1.940, 1.222, -2.907> <-2.010, 1.302, -2.907> <-1.983, 1.502, -2.914> <-1.906, 1.575, -2.914> 
		<-1.391, 1.230, -6.762> <-1.445, 1.309, -6.716> <-1.421, 1.510, -6.728> <-1.362, 1.583, -6.778> 
		<-1.090, 1.236, -9.661> <-1.144, 1.316, -9.616> <-1.122, 1.516, -9.634> <-1.063, 1.589, -9.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.094, 1.214, 0.004> <-2.164, 1.294, 0.004> <-2.136, 1.494, 0.004> <-2.059, 1.567, 0.004> 
		<-1.940, 1.222, -2.907> <-2.010, 1.302, -2.907> <-1.983, 1.502, -2.914> <-1.906, 1.575, -2.914> 
		<-1.391, 1.230, -6.762> <-1.383, 1.336, -6.769> <-1.370, 1.477, -6.771> <-1.362, 1.583, -6.778> 
		<-1.090, 1.236, -9.661> <-1.082, 1.342, -9.668> <-1.071, 1.483, -9.677> <-1.063, 1.589, -9.684> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.094, 1.214, 0.004> <-2.237, 1.207, 2.703> <-2.172, 1.203, 6.312> <-2.078, 1.189, 9.014> 
		<-2.164, 1.294, 0.004> <-2.307, 1.287, 2.703> <-2.242, 1.283, 6.312> <-2.148, 1.269, 9.014> 
		<-2.136, 1.494, 0.004> <-2.277, 1.487, 2.703> <-2.214, 1.485, 6.312> <-2.120, 1.469, 9.014> 
		<-2.059, 1.567, 0.004> <-2.200, 1.561, 2.703> <-2.136, 1.558, 6.312> <-2.043, 1.542, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.059, 1.567, 0.004> <-1.923, 1.696, 0.004> <-1.654, 1.728, 0.004> <-1.480, 1.797, 0.004> 
		<-1.906, 1.575, -2.914> <-1.771, 1.703, -2.914> <-1.520, 1.736, -3.023> <-1.347, 1.805, -3.023> 
		<-1.362, 1.583, -6.778> <-1.258, 1.712, -6.866> <-1.011, 1.744, -6.928> <-0.879, 1.812, -7.040> 
		<-1.063, 1.589, -9.684> <-0.960, 1.718, -9.772> <-0.754, 1.750, -9.947> <-0.621, 1.819, -10.059> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.059, 1.567, 0.004> <-2.200, 1.561, 2.703> <-2.136, 1.558, 6.312> <-2.043, 1.542, 9.014> 
		<-1.923, 1.696, 0.004> <-2.065, 1.689, 2.703> <-2.001, 1.687, 6.312> <-1.907, 1.670, 9.014> 
		<-1.654, 1.728, 0.004> <-1.773, 1.721, 2.704> <-1.716, 1.705, 6.312> <-1.638, 1.703, 9.014> 
		<-1.480, 1.797, 0.004> <-1.600, 1.790, 2.704> <-1.542, 1.774, 6.312> <-1.464, 1.771, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.148, 1.788, 11.530> <-1.243, 1.783, 10.775> <-1.442, 1.771, 9.774> <-1.464, 1.771, 9.014> 
		<-1.303, 1.701, 11.473> <-1.398, 1.696, 10.718> <-1.616, 1.702, 9.774> <-1.638, 1.703, 9.014> 
		<-1.545, 1.638, 11.365> <-1.658, 1.652, 10.667> <-1.883, 1.666, 9.720> <-1.907, 1.670, 9.014> 
		<-1.666, 1.498, 11.341> <-1.779, 1.511, 10.643> <-2.018, 1.538, 9.720> <-2.043, 1.542, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.148, 1.788, 11.530> <-1.303, 1.701, 11.473> <-1.545, 1.638, 11.365> <-1.666, 1.498, 11.341> 
		<-1.153, 1.538, 11.597> <-1.308, 1.450, 11.540> <-1.554, 1.535, 11.389> <-1.675, 1.395, 11.364> 
		<-1.159, 1.203, 11.685> <-1.319, 1.263, 11.585> <-1.571, 1.129, 11.492> <-1.688, 1.257, 11.396> 
		<-1.164, 0.952, 11.752> <-1.324, 1.012, 11.652> <-1.580, 1.026, 11.515> <-1.697, 1.154, 11.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.148, 1.788, 11.530> <-1.153, 1.538, 11.597> <-1.159, 1.203, 11.685> <-1.164, 0.952, 11.752> 
		<-1.243, 1.783, 10.775> <-1.248, 1.532, 10.842> <-1.254, 1.189, 10.864> <-1.259, 0.938, 10.930> 
		<-1.442, 1.771, 9.774> <-1.448, 1.511, 9.774> <-1.453, 1.167, 9.840> <-1.458, 0.908, 9.840> 
		<-1.464, 1.771, 9.014> <-1.470, 1.512, 9.014> <-1.477, 1.166, 9.014> <-1.482, 0.906, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.164, 0.952, 11.752> <-1.324, 1.012, 11.652> <-1.580, 1.026, 11.515> <-1.697, 1.154, 11.419> 
		<-1.259, 0.938, 10.930> <-1.419, 0.999, 10.831> <-1.694, 1.037, 10.794> <-1.811, 1.164, 10.698> 
		<-1.458, 0.908, 9.840> <-1.637, 0.992, 9.840> <-1.922, 1.036, 9.744> <-2.052, 1.185, 9.744> 
		<-1.482, 0.906, 9.014> <-1.661, 0.991, 9.014> <-1.947, 1.040, 9.014> <-2.078, 1.189, 9.014> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.078, 1.189, 9.014> <-2.052, 1.185, 9.744> <-1.811, 1.164, 10.698> <-1.697, 1.154, 11.419> 
		<-2.148, 1.269, 9.014> <-2.123, 1.265, 9.744> <-1.875, 1.233, 10.646> <-1.760, 1.222, 11.368> 
		<-2.120, 1.469, 9.014> <-2.095, 1.464, 9.720> <-1.848, 1.432, 10.629> <-1.735, 1.418, 11.327> 
		<-2.043, 1.542, 9.014> <-2.018, 1.538, 9.720> <-1.779, 1.511, 10.643> <-1.666, 1.498, 11.341> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-2.078, 1.189, 9.014> <-2.052, 1.185, 9.744> <-1.811, 1.164, 10.698> <-1.697, 1.154, 11.419> 
		<-2.148, 1.269, 9.014> <-2.123, 1.265, 9.744> <-1.802, 1.268, 10.674> <-1.688, 1.257, 11.396> 
		<-2.120, 1.469, 9.014> <-2.095, 1.464, 9.720> <-1.788, 1.408, 10.666> <-1.675, 1.395, 11.364> 
		<-2.043, 1.542, 9.014> <-2.018, 1.538, 9.720> <-1.779, 1.511, 10.643> <-1.666, 1.498, 11.341> 
	}
	#ifndef (IMPORT_SPATCH)
	texture {ship_panel}
	#end
}
// Layer 3 deck
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.750, 9.000> <-0.465, 2.750, 9.900> <-0.414, 2.750, 11.100> <-0.368, 2.750, 12.000> 
		<-0.339, 2.750, 9.000> <-0.320, 2.750, 9.900> <-0.303, 2.750, 11.100> <-0.257, 2.750, 12.000> 
		<-0.145, 2.750, 9.000> <-0.145, 2.750, 9.900> <-0.110, 2.750, 11.100> <-0.110, 2.750, 12.000> 
		<0.000, 2.750, 9.000> <0.000, 2.750, 9.900> <0.000, 2.750, 11.100> <0.000, 2.750, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.750, 9.000> <-0.339, 2.750, 9.000> <-0.145, 2.750, 9.000> <0.000, 2.750, 9.000> 
		<-0.505, 2.750, 8.100> <-0.359, 2.750, 8.100> <-0.145, 2.750, 8.100> <0.000, 2.750, 8.100> 
		<-0.497, 2.750, 6.900> <-0.347, 2.750, 6.900> <-0.150, 2.750, 6.900> <0.000, 2.750, 6.900> 
		<-0.500, 2.750, 6.000> <-0.350, 2.750, 6.000> <-0.150, 2.750, 6.000> <0.000, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.750, 9.000> <-0.848, 2.750, 9.000> <-1.333, 2.750, 9.000> <-1.697, 2.750, 9.000> 
		<-0.465, 2.750, 9.900> <-0.829, 2.750, 9.900> <-1.263, 2.750, 9.906> <-1.627, 2.750, 9.906> 
		<-0.414, 2.750, 11.100> <-0.689, 2.750, 11.100> <-1.171, 2.750, 11.106> <-1.447, 2.750, 11.106> 
		<-0.368, 2.750, 12.000> <-0.643, 2.750, 12.000> <-1.011, 2.750, 12.000> <-1.287, 2.750, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.750, 9.000> <-0.505, 2.750, 8.100> <-0.497, 2.750, 6.900> <-0.500, 2.750, 6.000> 
		<-0.848, 2.750, 9.000> <-0.868, 2.750, 8.100> <-0.872, 2.750, 6.900> <-0.875, 2.750, 6.000> 
		<-1.333, 2.750, 9.000> <-1.403, 2.750, 8.103> <-1.363, 2.750, 6.900> <-1.375, 2.750, 6.000> 
		<-1.697, 2.750, 9.000> <-1.766, 2.750, 8.103> <-1.738, 2.750, 6.900> <-1.750, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, 9.000> <0.000, 2.750, 9.900> <0.000, 2.750, 11.100> <0.000, 2.750, 12.000> 
		<0.145, 2.750, 9.000> <0.145, 2.750, 9.900> <0.110, 2.750, 11.100> <0.110, 2.750, 12.000> 
		<0.339, 2.750, 9.000> <0.320, 2.750, 9.900> <0.303, 2.750, 11.100> <0.257, 2.750, 12.000> 
		<0.485, 2.750, 9.000> <0.465, 2.750, 9.900> <0.414, 2.750, 11.100> <0.368, 2.750, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, 9.000> <0.145, 2.750, 9.000> <0.339, 2.750, 9.000> <0.485, 2.750, 9.000> 
		<0.000, 2.750, 8.100> <0.145, 2.750, 8.100> <0.359, 2.750, 8.100> <0.505, 2.750, 8.100> 
		<0.000, 2.750, 6.900> <0.150, 2.750, 6.900> <0.347, 2.750, 6.900> <0.497, 2.750, 6.900> 
		<0.000, 2.750, 6.000> <0.150, 2.750, 6.000> <0.350, 2.750, 6.000> <0.500, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.485, 2.750, 9.000> <0.848, 2.750, 9.000> <1.333, 2.750, 9.000> <1.697, 2.750, 9.000> 
		<0.505, 2.750, 8.100> <0.868, 2.750, 8.100> <1.403, 2.750, 8.103> <1.766, 2.750, 8.103> 
		<0.497, 2.750, 6.900> <0.872, 2.750, 6.900> <1.363, 2.750, 6.900> <1.738, 2.750, 6.900> 
		<0.500, 2.750, 6.000> <0.875, 2.750, 6.000> <1.375, 2.750, 6.000> <1.750, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.485, 2.750, 9.000> <0.465, 2.750, 9.900> <0.414, 2.750, 11.100> <0.368, 2.750, 12.000> 
		<0.848, 2.750, 9.000> <0.829, 2.750, 9.900> <0.689, 2.750, 11.100> <0.643, 2.750, 12.000> 
		<1.333, 2.750, 9.000> <1.263, 2.750, 9.906> <1.171, 2.750, 11.106> <1.011, 2.750, 12.000> 
		<1.697, 2.750, 9.000> <1.627, 2.750, 9.906> <1.447, 2.750, 11.106> <1.287, 2.750, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, 2.750, 12.000> <-0.337, 2.750, 12.601> <-0.271, 2.750, 13.400> <-0.229, 2.750, 14.000> 
		<-0.257, 2.750, 12.000> <-0.227, 2.750, 12.601> <-0.202, 2.750, 13.400> <-0.160, 2.750, 14.000> 
		<-0.110, 2.750, 12.000> <-0.110, 2.750, 12.600> <-0.061, 2.750, 13.400> <-0.069, 2.750, 14.000> 
		<0.000, 2.750, 12.000> <0.000, 2.750, 12.600> <0.008, 2.750, 13.400> <0.000, 2.750, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, 2.750, 12.000> <-0.643, 2.750, 12.000> <-1.011, 2.750, 12.000> <-1.287, 2.750, 12.000> 
		<-0.337, 2.750, 12.601> <-0.613, 2.750, 12.601> <-0.902, 2.750, 12.608> <-1.178, 2.750, 12.608> 
		<-0.271, 2.750, 13.400> <-0.442, 2.750, 13.400> <-0.793, 2.750, 13.405> <-0.965, 2.750, 13.405> 
		<-0.229, 2.750, 14.000> <-0.400, 2.750, 14.000> <-0.629, 2.750, 14.000> <-0.800, 2.750, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, 12.000> <0.000, 2.750, 12.600> <0.008, 2.750, 13.400> <0.000, 2.750, 14.000> 
		<0.110, 2.750, 12.000> <0.110, 2.750, 12.600> <0.076, 2.750, 13.400> <0.069, 2.750, 14.000> 
		<0.257, 2.750, 12.000> <0.227, 2.750, 12.601> <0.217, 2.750, 13.401> <0.160, 2.750, 14.000> 
		<0.368, 2.750, 12.000> <0.337, 2.750, 12.601> <0.286, 2.750, 13.401> <0.229, 2.750, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 2.750, 12.000> <0.337, 2.750, 12.601> <0.286, 2.750, 13.401> <0.229, 2.750, 14.000> 
		<0.643, 2.750, 12.000> <0.613, 2.750, 12.601> <0.457, 2.750, 13.401> <0.400, 2.750, 14.000> 
		<1.011, 2.750, 12.000> <0.902, 2.750, 12.608> <0.807, 2.750, 13.409> <0.629, 2.750, 14.000> 
		<1.287, 2.750, 12.000> <1.178, 2.750, 12.608> <0.979, 2.750, 13.409> <0.800, 2.750, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.750, 0.000> <-0.529, 2.750, 1.500> <-0.500, 2.750, 3.500> <-0.500, 2.750, 5.000> 
		<-0.350, 2.750, 0.000> <-0.379, 2.750, 1.500> <-0.350, 2.750, 3.500> <-0.350, 2.750, 5.000> 
		<-0.150, 2.750, 0.000> <-0.150, 2.750, 1.500> <-0.150, 2.750, 3.500> <-0.150, 2.750, 5.000> 
		<0.000, 2.750, 0.000> <0.000, 2.750, 1.500> <0.000, 2.750, 3.500> <0.000, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.750, 0.000> <-0.350, 2.750, 0.000> <-0.150, 2.750, 0.000> <0.000, 2.750, 0.000> 
		<-0.443, 2.750, -3.001> <-0.293, 2.750, -3.001> <-0.150, 2.750, -3.000> <0.000, 2.750, -3.000> 
		<-0.308, 2.750, -7.000> <-0.245, 2.750, -7.000> <-0.064, 2.750, -7.000> <0.000, 2.750, -7.000> 
		<-0.213, 2.750, -10.000> <-0.149, 2.750, -10.000> <-0.064, 2.750, -10.000> <0.000, 2.750, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.750, 0.000> <-0.875, 2.750, 0.000> <-1.375, 2.750, 0.000> <-1.750, 2.750, 0.000> 
		<-0.529, 2.750, 1.500> <-0.904, 2.750, 1.500> <-1.475, 2.750, 1.497> <-1.850, 2.750, 1.497> 
		<-0.500, 2.750, 3.500> <-0.875, 2.750, 3.500> <-1.375, 2.750, 3.500> <-1.750, 2.750, 3.500> 
		<-0.500, 2.750, 5.000> <-0.875, 2.750, 5.000> <-1.375, 2.750, 5.000> <-1.750, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.750, 0.000> <-0.443, 2.750, -3.001> <-0.308, 2.750, -7.000> <-0.213, 2.750, -10.000> 
		<-0.875, 2.750, 0.000> <-0.818, 2.750, -3.001> <-0.468, 2.750, -7.000> <-0.372, 2.750, -10.000> 
		<-1.375, 2.750, 0.000> <-1.173, 2.750, -3.008> <-0.920, 2.750, -7.004> <-0.585, 2.750, -10.000> 
		<-1.750, 2.750, 0.000> <-1.548, 2.750, -3.008> <-1.080, 2.750, -7.004> <-0.744, 2.750, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, 0.000> <0.000, 2.750, 1.500> <0.000, 2.750, 3.500> <0.000, 2.750, 5.000> 
		<0.150, 2.750, 0.000> <0.150, 2.750, 1.500> <0.150, 2.750, 3.500> <0.150, 2.750, 5.000> 
		<0.350, 2.750, 0.000> <0.379, 2.750, 1.500> <0.350, 2.750, 3.500> <0.350, 2.750, 5.000> 
		<0.500, 2.750, 0.000> <0.529, 2.750, 1.500> <0.500, 2.750, 3.500> <0.500, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, 0.000> <0.150, 2.750, 0.000> <0.350, 2.750, 0.000> <0.500, 2.750, 0.000> 
		<0.000, 2.750, -3.000> <0.150, 2.750, -3.000> <0.293, 2.750, -3.001> <0.443, 2.750, -3.001> 
		<0.000, 2.750, -7.000> <0.064, 2.750, -7.000> <0.245, 2.750, -7.000> <0.309, 2.750, -7.000> 
		<0.000, 2.750, -10.000> <0.064, 2.750, -10.000> <0.149, 2.750, -10.000> <0.213, 2.750, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.750, 0.000> <0.875, 2.750, 0.000> <1.375, 2.750, 0.000> <1.750, 2.750, 0.000> 
		<0.443, 2.750, -3.001> <0.818, 2.750, -3.001> <1.173, 2.750, -3.008> <1.548, 2.750, -3.008> 
		<0.309, 2.750, -7.000> <0.468, 2.750, -7.000> <0.921, 2.750, -7.004> <1.080, 2.750, -7.004> 
		<0.213, 2.750, -10.000> <0.372, 2.750, -10.000> <0.585, 2.750, -10.000> <0.744, 2.750, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.750, 0.000> <0.529, 2.750, 1.500> <0.500, 2.750, 3.500> <0.500, 2.750, 5.000> 
		<0.875, 2.750, 0.000> <0.904, 2.750, 1.500> <0.875, 2.750, 3.500> <0.875, 2.750, 5.000> 
		<1.375, 2.750, 0.000> <1.475, 2.750, 1.497> <1.375, 2.750, 3.500> <1.375, 2.750, 5.000> 
		<1.750, 2.750, 0.000> <1.850, 2.750, 1.497> <1.750, 2.750, 3.500> <1.750, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.213, 2.750, -10.000> <-0.201, 2.750, -10.375> <-0.167, 2.750, -10.875> <-0.141, 2.750, -11.250> 
		<-0.372, 2.750, -10.000> <-0.360, 2.750, -10.375> <-0.272, 2.750, -10.875> <-0.245, 2.750, -11.250> 
		<-0.585, 2.750, -10.000> <-0.542, 2.750, -10.380> <-0.471, 2.750, -10.877> <-0.385, 2.750, -11.250> 
		<-0.744, 2.750, -10.000> <-0.702, 2.750, -10.380> <-0.576, 2.750, -10.877> <-0.490, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.213, 2.750, -10.000> <-0.149, 2.750, -10.000> <-0.064, 2.750, -10.000> <0.000, 2.750, -10.000> 
		<-0.201, 2.750, -10.375> <-0.137, 2.750, -10.375> <-0.064, 2.750, -10.375> <-0.000, 2.750, -10.375> 
		<-0.167, 2.750, -10.875> <-0.125, 2.750, -10.875> <-0.045, 2.750, -10.875> <-0.003, 2.750, -10.875> 
		<-0.141, 2.750, -11.250> <-0.099, 2.750, -11.250> <-0.043, 2.750, -11.250> <-0.001, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, -10.000> <0.064, 2.750, -10.000> <0.149, 2.750, -10.000> <0.213, 2.750, -10.000> 
		<-0.000, 2.750, -10.375> <0.064, 2.750, -10.375> <0.137, 2.750, -10.375> <0.201, 2.750, -10.375> 
		<-0.003, 2.750, -10.875> <0.039, 2.750, -10.875> <0.119, 2.750, -10.875> <0.161, 2.750, -10.875> 
		<-0.001, 2.750, -11.250> <0.041, 2.750, -11.250> <0.097, 2.750, -11.250> <0.139, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.213, 2.750, -10.000> <0.372, 2.750, -10.000> <0.585, 2.750, -10.000> <0.744, 2.750, -10.000> 
		<0.201, 2.750, -10.375> <0.360, 2.750, -10.375> <0.542, 2.750, -10.380> <0.702, 2.750, -10.380> 
		<0.161, 2.750, -10.875> <0.265, 2.750, -10.875> <0.465, 2.750, -10.876> <0.570, 2.750, -10.876> 
		<0.139, 2.750, -11.250> <0.244, 2.750, -11.250> <0.383, 2.750, -11.250> <0.488, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.750, -11.750> <-0.166, 2.750, -11.750> <-0.267, 2.750, -11.750> <-0.342, 2.750, -11.750> 
		<-0.097, 2.750, -11.599> <-0.173, 2.750, -11.599> <-0.307, 2.750, -11.599> <-0.383, 2.750, -11.599> 
		<-0.130, 2.750, -11.400> <-0.235, 2.750, -11.400> <-0.350, 2.750, -11.402> <-0.455, 2.750, -11.402> 
		<-0.141, 2.750, -11.250> <-0.245, 2.750, -11.250> <-0.385, 2.750, -11.250> <-0.490, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.750, -11.750> <-0.090, 2.750, -11.750> <-0.090, 2.750, -11.750> <-0.090, 2.750, -11.750> 
		<-0.166, 2.750, -11.750> <-0.151, 2.750, -12.073> <-0.151, 2.750, -12.073> <-0.075, 2.750, -12.073> 
		<-0.267, 2.750, -11.750> <-0.180, 2.750, -12.072> <-0.171, 2.750, -12.184> <-0.074, 2.750, -12.503> 
		<-0.342, 2.750, -11.750> <-0.256, 2.750, -12.072> <-0.164, 2.750, -12.507> <-0.067, 2.750, -12.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.750, -11.750> <-0.097, 2.750, -11.599> <-0.130, 2.750, -11.400> <-0.141, 2.750, -11.250> 
		<-0.060, 2.750, -11.750> <-0.067, 2.750, -11.599> <-0.088, 2.750, -11.400> <-0.099, 2.750, -11.250> 
		<-0.020, 2.750, -11.750> <-0.021, 2.750, -11.600> <-0.042, 2.750, -11.400> <-0.043, 2.750, -11.250> 
		<0.011, 2.750, -11.750> <0.010, 2.750, -11.600> <0.000, 2.750, -11.400> <-0.001, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.750, -11.750> <-0.060, 2.750, -11.750> <-0.020, 2.750, -11.750> <0.011, 2.750, -11.750> 
		<-0.075, 2.750, -12.073> <-0.045, 2.750, -12.073> <-0.017, 2.750, -12.099> <0.013, 2.750, -12.099> 
		<-0.074, 2.750, -12.503> <-0.063, 2.750, -12.537> <-0.024, 2.750, -12.563> <0.012, 2.750, -12.565> 
		<-0.067, 2.750, -12.826> <-0.056, 2.750, -12.860> <-0.023, 2.750, -12.912> <0.012, 2.750, -12.915> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 2.750, -11.750> <0.010, 2.750, -11.600> <0.000, 2.750, -11.400> <-0.001, 2.750, -11.250> 
		<0.041, 2.750, -11.750> <0.040, 2.750, -11.600> <0.042, 2.750, -11.400> <0.041, 2.750, -11.250> 
		<0.081, 2.750, -11.750> <0.085, 2.750, -11.600> <0.088, 2.750, -11.400> <0.097, 2.750, -11.250> 
		<0.112, 2.750, -11.750> <0.115, 2.750, -11.600> <0.130, 2.750, -11.400> <0.139, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 2.750, -11.750> <0.041, 2.750, -11.750> <0.081, 2.750, -11.750> <0.112, 2.750, -11.750> 
		<0.013, 2.750, -12.099> <0.044, 2.750, -12.099> <0.073, 2.750, -12.076> <0.104, 2.750, -12.076> 
		<0.012, 2.750, -12.565> <0.047, 2.750, -12.567> <0.094, 2.750, -12.544> <0.104, 2.750, -12.510> 
		<0.012, 2.750, -12.915> <0.047, 2.750, -12.917> <0.090, 2.750, -12.870> <0.100, 2.750, -12.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.112, 2.750, -11.750> <0.112, 2.750, -11.750> <0.112, 2.750, -11.750> <0.112, 2.750, -11.750> 
		<0.104, 2.750, -12.076> <0.179, 2.750, -12.076> <0.179, 2.750, -12.076> <0.187, 2.750, -11.750> 
		<0.104, 2.750, -12.510> <0.201, 2.750, -12.189> <0.208, 2.750, -12.076> <0.288, 2.750, -11.750> 
		<0.100, 2.750, -12.836> <0.197, 2.750, -12.515> <0.284, 2.750, -12.076> <0.364, 2.750, -11.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.112, 2.750, -11.750> <0.115, 2.750, -11.600> <0.130, 2.750, -11.400> <0.139, 2.750, -11.250> 
		<0.187, 2.750, -11.750> <0.191, 2.750, -11.600> <0.235, 2.750, -11.400> <0.244, 2.750, -11.250> 
		<0.288, 2.750, -11.750> <0.325, 2.750, -11.600> <0.351, 2.750, -11.401> <0.383, 2.750, -11.250> 
		<0.364, 2.750, -11.750> <0.400, 2.750, -11.600> <0.455, 2.750, -11.401> <0.488, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 2.750, 14.000> <-0.201, 2.750, 14.390> <-0.169, 2.715, 14.911> <-0.137, 2.750, 15.299> 
		<-0.160, 2.750, 14.000> <-0.133, 2.750, 14.390> <-0.140, 2.715, 14.911> <-0.108, 2.750, 15.299> 
		<-0.069, 2.750, 14.000> <-0.074, 2.750, 14.390> <-0.065, 2.715, 14.911> <-0.070, 2.750, 15.299> 
		<0.000, 2.750, 14.000> <-0.005, 2.750, 14.390> <-0.036, 2.715, 14.911> <-0.041, 2.750, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 2.750, 14.000> <-0.400, 2.750, 14.000> <-0.629, 2.750, 14.000> <-0.800, 2.750, 14.000> 
		<-0.201, 2.750, 14.390> <-0.373, 2.750, 14.390> <-0.520, 2.750, 14.395> <-0.691, 2.750, 14.395> 
		<-0.169, 2.715, 14.911> <-0.241, 2.715, 14.911> <-0.430, 2.715, 14.910> <-0.501, 2.715, 14.910> 
		<-0.137, 2.750, 15.299> <-0.208, 2.750, 15.299> <-0.304, 2.750, 15.299> <-0.376, 2.750, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.750, 14.000> <-0.005, 2.750, 14.390> <-0.036, 2.715, 14.911> <-0.041, 2.750, 15.299> 
		<0.069, 2.750, 14.000> <0.064, 2.750, 14.390> <-0.008, 2.715, 14.911> <-0.013, 2.750, 15.299> 
		<0.160, 2.750, 14.000> <0.123, 2.750, 14.391> <0.068, 2.715, 14.910> <0.025, 2.750, 15.299> 
		<0.229, 2.750, 14.000> <0.191, 2.750, 14.391> <0.097, 2.715, 14.910> <0.054, 2.750, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.229, 2.750, 14.000> <0.191, 2.750, 14.391> <0.097, 2.715, 14.910> <0.054, 2.750, 15.299> 
		<0.400, 2.750, 14.000> <0.363, 2.750, 14.391> <0.168, 2.715, 14.910> <0.126, 2.750, 15.299> 
		<0.629, 2.750, 14.000> <0.508, 2.750, 14.401> <0.359, 2.715, 14.905> <0.221, 2.750, 15.299> 
		<0.800, 2.750, 14.000> <0.680, 2.750, 14.401> <0.430, 2.715, 14.905> <0.293, 2.750, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 2.750, 15.299> <-0.123, 2.765, 15.472> <-0.088, 2.808, 15.715> <-0.075, 2.916, 15.852> 
		<-0.108, 2.750, 15.299> <-0.094, 2.765, 15.472> <-0.073, 2.808, 15.715> <-0.060, 2.916, 15.852> 
		<-0.070, 2.750, 15.299> <-0.072, 2.765, 15.471> <-0.042, 2.809, 15.715> <-0.040, 2.916, 15.852> 
		<-0.041, 2.750, 15.299> <-0.044, 2.765, 15.471> <-0.027, 2.809, 15.715> <-0.025, 2.916, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 2.750, 15.299> <-0.208, 2.750, 15.299> <-0.304, 2.750, 15.299> <-0.376, 2.750, 15.299> 
		<-0.123, 2.765, 15.472> <-0.194, 2.765, 15.472> <-0.248, 2.765, 15.470> <-0.320, 2.765, 15.470> 
		<-0.088, 2.808, 15.715> <-0.126, 2.808, 15.715> <-0.204, 2.807, 15.713> <-0.241, 2.807, 15.713> 
		<-0.075, 2.916, 15.852> <-0.113, 2.916, 15.852> <-0.164, 2.916, 15.852> <-0.201, 2.916, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 2.750, 15.299> <-0.044, 2.765, 15.471> <-0.027, 2.809, 15.715> <-0.025, 2.916, 15.852> 
		<-0.013, 2.750, 15.299> <-0.015, 2.765, 15.471> <-0.012, 2.809, 15.715> <-0.010, 2.916, 15.852> 
		<0.025, 2.750, 15.299> <0.007, 2.765, 15.470> <0.018, 2.809, 15.716> <0.010, 2.916, 15.852> 
		<0.054, 2.750, 15.299> <0.035, 2.765, 15.470> <0.034, 2.809, 15.716> <0.026, 2.916, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.054, 2.750, 15.299> <0.035, 2.765, 15.470> <0.034, 2.809, 15.716> <0.026, 2.916, 15.852> 
		<0.126, 2.750, 15.299> <0.107, 2.765, 15.470> <0.071, 2.809, 15.716> <0.063, 2.916, 15.852> 
		<0.221, 2.750, 15.299> <0.162, 2.765, 15.466> <0.148, 2.808, 15.714> <0.114, 2.916, 15.852> 
		<0.293, 2.750, 15.299> <0.234, 2.765, 15.466> <0.186, 2.808, 15.714> <0.152, 2.916, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 2.916, 15.852> <-0.060, 3.038, 16.007> <-0.057, 3.303, 16.103> <-0.050, 3.468, 16.211> 
		<-0.060, 2.916, 15.852> <-0.045, 3.038, 16.007> <-0.050, 3.303, 16.103> <-0.042, 3.468, 16.211> 
		<-0.040, 2.916, 15.852> <-0.037, 3.038, 16.007> <-0.018, 3.309, 16.107> <-0.025, 3.475, 16.215> 
		<-0.025, 2.916, 15.852> <-0.022, 3.038, 16.007> <-0.017, 3.303, 16.103> <-0.025, 3.468, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 2.916, 15.852> <-0.113, 2.916, 15.852> <-0.164, 2.916, 15.852> <-0.201, 2.916, 15.852> 
		<-0.060, 3.038, 16.007> <-0.098, 3.038, 16.007> <-0.119, 3.036, 16.004> <-0.157, 3.036, 16.004> 
		<-0.057, 3.303, 16.103> <-0.076, 3.303, 16.103> <-0.120, 3.303, 16.103> <-0.139, 3.303, 16.103> 
		<-0.050, 3.468, 16.211> <-0.068, 3.468, 16.211> <-0.093, 3.468, 16.211> <-0.112, 3.468, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 2.916, 15.852> <-0.022, 3.038, 16.007> <-0.017, 3.303, 16.103> <-0.025, 3.468, 16.211> 
		<-0.010, 2.916, 15.852> <-0.007, 3.038, 16.007> <-0.010, 3.303, 16.103> <-0.017, 3.468, 16.211> 
		<0.010, 2.916, 15.852> <0.001, 3.038, 16.007> <0.000, 3.303, 16.103> <-0.007, 3.468, 16.211> 
		<0.026, 2.916, 15.852> <0.016, 3.038, 16.007> <0.008, 3.303, 16.103> <0.000, 3.468, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.026, 2.916, 15.852> <0.016, 3.038, 16.007> <0.008, 3.303, 16.103> <0.000, 3.468, 16.211> 
		<0.063, 2.916, 15.852> <0.054, 3.038, 16.007> <0.026, 3.303, 16.103> <0.019, 3.468, 16.211> 
		<0.114, 2.916, 15.852> <0.075, 3.037, 16.005> <0.070, 3.303, 16.103> <0.044, 3.468, 16.211> 
		<0.152, 2.916, 15.852> <0.113, 3.037, 16.005> <0.089, 3.303, 16.103> <0.062, 3.468, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.518, 9.000> <-0.505, 2.518, 8.100> <-0.497, 2.518, 6.900> <-0.500, 2.518, 6.000> 
		<-0.848, 2.518, 9.000> <-0.868, 2.518, 8.100> <-0.872, 2.518, 6.900> <-0.875, 2.518, 6.000> 
		<-1.333, 2.518, 9.000> <-1.403, 2.518, 8.103> <-1.363, 2.518, 6.900> <-1.375, 2.518, 6.000> 
		<-1.697, 2.518, 9.000> <-1.766, 2.518, 8.103> <-1.738, 2.518, 6.900> <-1.750, 2.518, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.518, 9.000> <-0.848, 2.518, 9.000> <-1.333, 2.518, 9.000> <-1.697, 2.518, 9.000> 
		<-0.465, 2.518, 9.900> <-0.829, 2.518, 9.900> <-1.263, 2.518, 9.906> <-1.627, 2.518, 9.906> 
		<-0.414, 2.518, 11.100> <-0.689, 2.518, 11.100> <-1.171, 2.518, 11.106> <-1.447, 2.518, 11.106> 
		<-0.368, 2.518, 12.000> <-0.643, 2.518, 12.000> <-1.011, 2.518, 12.000> <-1.287, 2.518, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.518, 9.000> <-0.339, 2.518, 9.000> <-0.145, 2.518, 9.000> <0.000, 2.518, 9.000> 
		<-0.505, 2.518, 8.100> <-0.359, 2.518, 8.100> <-0.145, 2.518, 8.100> <0.000, 2.518, 8.100> 
		<-0.497, 2.518, 6.900> <-0.347, 2.518, 6.900> <-0.150, 2.518, 6.900> <0.000, 2.518, 6.900> 
		<-0.500, 2.518, 6.000> <-0.350, 2.518, 6.000> <-0.150, 2.518, 6.000> <0.000, 2.518, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.485, 2.518, 9.000> <-0.465, 2.518, 9.900> <-0.414, 2.518, 11.100> <-0.368, 2.518, 12.000> 
		<-0.339, 2.518, 9.000> <-0.320, 2.518, 9.900> <-0.303, 2.518, 11.100> <-0.257, 2.518, 12.000> 
		<-0.145, 2.518, 9.000> <-0.145, 2.518, 9.900> <-0.110, 2.518, 11.100> <-0.110, 2.518, 12.000> 
		<0.000, 2.518, 9.000> <0.000, 2.518, 9.900> <0.000, 2.518, 11.100> <0.000, 2.518, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 9.000> <0.145, 2.518, 9.000> <0.339, 2.518, 9.000> <0.485, 2.518, 9.000> 
		<0.000, 2.518, 8.100> <0.145, 2.518, 8.100> <0.359, 2.518, 8.101> <0.505, 2.518, 8.100> 
		<0.000, 2.518, 6.900> <0.150, 2.518, 6.900> <0.345, 2.518, 6.900> <0.495, 2.518, 6.900> 
		<0.000, 2.518, 6.000> <0.150, 2.518, 6.000> <0.350, 2.518, 6.000> <0.500, 2.518, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 9.000> <0.000, 2.518, 9.900> <0.000, 2.518, 11.100> <0.000, 2.518, 12.000> 
		<0.145, 2.518, 9.000> <0.145, 2.518, 9.900> <0.110, 2.518, 11.100> <0.110, 2.518, 12.000> 
		<0.339, 2.518, 9.000> <0.320, 2.518, 9.901> <0.303, 2.518, 11.100> <0.257, 2.518, 12.000> 
		<0.485, 2.518, 9.000> <0.465, 2.518, 9.900> <0.414, 2.518, 11.100> <0.368, 2.518, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.485, 2.518, 9.000> <0.465, 2.518, 9.900> <0.414, 2.518, 11.100> <0.368, 2.518, 12.000> 
		<0.850, 2.518, 8.999> <0.830, 2.518, 9.900> <0.689, 2.518, 11.100> <0.643, 2.518, 12.000> 
		<1.338, 2.518, 8.997> <1.268, 2.518, 9.904> <1.173, 2.518, 11.104> <1.011, 2.518, 12.000> 
		<1.703, 2.518, 8.996> <1.633, 2.518, 9.903> <1.448, 2.518, 11.104> <1.287, 2.518, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.485, 2.518, 9.000> <0.850, 2.518, 8.999> <1.338, 2.518, 8.997> <1.703, 2.518, 8.996> 
		<0.505, 2.518, 8.100> <0.870, 2.518, 8.099> <1.407, 2.518, 8.101> <1.772, 2.518, 8.099> 
		<0.495, 2.518, 6.900> <0.870, 2.518, 6.900> <1.364, 2.518, 6.899> <1.739, 2.518, 6.899> 
		<0.500, 2.518, 6.000> <0.875, 2.518, 6.000> <1.375, 2.518, 6.000> <1.750, 2.518, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, 2.518, 12.000> <-0.643, 2.518, 12.000> <-1.011, 2.518, 12.000> <-1.287, 2.518, 12.000> 
		<-0.337, 2.518, 12.601> <-0.613, 2.518, 12.601> <-0.902, 2.518, 12.608> <-1.178, 2.518, 12.608> 
		<-0.271, 2.518, 13.400> <-0.442, 2.518, 13.400> <-0.793, 2.518, 13.405> <-0.965, 2.518, 13.405> 
		<-0.229, 2.518, 14.000> <-0.400, 2.518, 14.000> <-0.629, 2.518, 14.000> <-0.800, 2.518, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.368, 2.518, 12.000> <-0.337, 2.518, 12.601> <-0.271, 2.518, 13.400> <-0.229, 2.518, 14.000> 
		<-0.257, 2.518, 12.000> <-0.227, 2.518, 12.601> <-0.202, 2.518, 13.400> <-0.160, 2.518, 14.000> 
		<-0.110, 2.518, 12.000> <-0.110, 2.518, 12.600> <-0.061, 2.518, 13.400> <-0.069, 2.518, 14.000> 
		<0.000, 2.518, 12.000> <0.000, 2.518, 12.600> <0.008, 2.518, 13.400> <0.000, 2.518, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 12.000> <0.000, 2.518, 12.600> <0.008, 2.518, 13.400> <0.000, 2.518, 14.000> 
		<0.110, 2.518, 12.000> <0.110, 2.518, 12.600> <0.076, 2.518, 13.400> <0.069, 2.518, 14.000> 
		<0.257, 2.518, 12.000> <0.227, 2.518, 12.601> <0.217, 2.518, 13.401> <0.160, 2.518, 14.000> 
		<0.368, 2.518, 12.000> <0.337, 2.518, 12.601> <0.286, 2.518, 13.401> <0.229, 2.518, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 2.518, 12.000> <0.337, 2.518, 12.601> <0.286, 2.518, 13.401> <0.229, 2.518, 14.000> 
		<0.643, 2.518, 12.000> <0.613, 2.518, 12.601> <0.457, 2.518, 13.401> <0.400, 2.518, 14.000> 
		<1.011, 2.518, 12.000> <0.901, 2.518, 12.608> <0.807, 2.518, 13.409> <0.629, 2.518, 14.000> 
		<1.287, 2.518, 12.000> <1.177, 2.518, 12.608> <0.979, 2.518, 13.409> <0.800, 2.518, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 0.000> <-0.443, 2.518, -3.001> <-0.308, 2.518, -7.000> <-0.213, 2.518, -10.000> 
		<-0.875, 2.518, 0.000> <-0.818, 2.518, -3.001> <-0.468, 2.518, -7.000> <-0.372, 2.518, -10.000> 
		<-1.375, 2.518, 0.000> <-1.173, 2.518, -3.008> <-0.920, 2.518, -7.004> <-0.585, 2.518, -10.000> 
		<-1.750, 2.518, 0.000> <-1.548, 2.518, -3.008> <-1.080, 2.518, -7.004> <-0.744, 2.518, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 0.000> <-0.875, 2.518, 0.000> <-1.375, 2.518, 0.000> <-1.750, 2.518, 0.000> 
		<-0.529, 2.518, 1.500> <-0.904, 2.518, 1.500> <-1.475, 2.518, 1.497> <-1.850, 2.518, 1.497> 
		<-0.500, 2.518, 3.500> <-0.875, 2.518, 3.500> <-1.375, 2.518, 3.500> <-1.750, 2.518, 3.500> 
		<-0.500, 2.518, 5.000> <-0.875, 2.518, 5.000> <-1.375, 2.518, 5.000> <-1.750, 2.518, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 0.000> <-0.350, 2.518, 0.000> <-0.150, 2.518, 0.000> <0.000, 2.518, 0.000> 
		<-0.443, 2.518, -3.001> <-0.293, 2.518, -3.001> <-0.150, 2.518, -3.000> <0.000, 2.518, -3.000> 
		<-0.308, 2.518, -7.000> <-0.245, 2.518, -7.000> <-0.064, 2.518, -7.000> <0.000, 2.518, -7.000> 
		<-0.213, 2.518, -10.000> <-0.149, 2.518, -10.000> <-0.064, 2.518, -10.000> <0.000, 2.518, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 0.000> <-0.529, 2.518, 1.500> <-0.500, 2.518, 3.500> <-0.500, 2.518, 5.000> 
		<-0.350, 2.518, 0.000> <-0.379, 2.518, 1.500> <-0.350, 2.518, 3.500> <-0.350, 2.518, 5.000> 
		<-0.150, 2.518, 0.000> <-0.150, 2.518, 1.500> <-0.150, 2.518, 3.500> <-0.150, 2.518, 5.000> 
		<0.000, 2.518, 0.000> <0.000, 2.518, 1.500> <0.000, 2.518, 3.500> <0.000, 2.518, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 0.000> <0.150, 2.518, 0.000> <0.350, 2.518, 0.000> <0.500, 2.518, 0.000> 
		<0.000, 2.518, -3.000> <0.150, 2.518, -3.000> <0.293, 2.518, -3.001> <0.443, 2.518, -3.001> 
		<0.000, 2.518, -7.000> <0.064, 2.518, -7.000> <0.245, 2.518, -7.000> <0.309, 2.518, -7.000> 
		<0.000, 2.518, -10.000> <0.064, 2.518, -10.000> <0.149, 2.518, -10.000> <0.213, 2.518, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 0.000> <0.000, 2.518, 1.500> <0.000, 2.518, 3.500> <0.000, 2.518, 5.000> 
		<0.150, 2.518, 0.000> <0.150, 2.518, 1.500> <0.150, 2.518, 3.500> <0.150, 2.518, 5.000> 
		<0.350, 2.518, 0.000> <0.379, 2.518, 1.500> <0.350, 2.518, 3.500> <0.350, 2.518, 5.000> 
		<0.500, 2.518, 0.000> <0.529, 2.518, 1.500> <0.500, 2.518, 3.500> <0.500, 2.518, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.518, 0.000> <0.529, 2.518, 1.500> <0.500, 2.518, 3.500> <0.500, 2.518, 5.000> 
		<0.875, 2.518, 0.000> <0.904, 2.518, 1.500> <0.875, 2.518, 3.500> <0.875, 2.518, 5.000> 
		<1.375, 2.518, 0.000> <1.475, 2.518, 1.497> <1.375, 2.518, 3.500> <1.375, 2.518, 5.000> 
		<1.750, 2.518, 0.000> <1.850, 2.518, 1.497> <1.750, 2.518, 3.500> <1.750, 2.518, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.518, 0.000> <0.875, 2.518, 0.000> <1.375, 2.518, 0.000> <1.750, 2.518, 0.000> 
		<0.443, 2.518, -3.001> <0.818, 2.518, -3.001> <1.173, 2.518, -3.008> <1.548, 2.518, -3.008> 
		<0.309, 2.518, -7.000> <0.468, 2.518, -7.000> <0.921, 2.518, -7.004> <1.080, 2.518, -7.004> 
		<0.213, 2.518, -10.000> <0.372, 2.518, -10.000> <0.585, 2.518, -10.000> <0.744, 2.518, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.213, 2.518, -10.000> <-0.149, 2.518, -10.000> <-0.064, 2.518, -10.000> <0.000, 2.518, -10.000> 
		<-0.201, 2.518, -10.375> <-0.137, 2.518, -10.375> <-0.064, 2.518, -10.375> <-0.000, 2.518, -10.375> 
		<-0.167, 2.518, -10.875> <-0.125, 2.518, -10.875> <-0.045, 2.518, -10.875> <-0.003, 2.518, -10.875> 
		<-0.141, 2.518, -11.250> <-0.099, 2.518, -11.250> <-0.043, 2.518, -11.250> <-0.001, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.213, 2.518, -10.000> <-0.201, 2.518, -10.375> <-0.167, 2.518, -10.875> <-0.141, 2.518, -11.250> 
		<-0.372, 2.518, -10.000> <-0.360, 2.518, -10.375> <-0.272, 2.518, -10.875> <-0.245, 2.518, -11.250> 
		<-0.585, 2.518, -10.000> <-0.542, 2.518, -10.380> <-0.471, 2.518, -10.877> <-0.385, 2.518, -11.250> 
		<-0.744, 2.518, -10.000> <-0.702, 2.518, -10.380> <-0.576, 2.518, -10.877> <-0.490, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, -10.000> <0.064, 2.518, -10.000> <0.149, 2.518, -10.000> <0.213, 2.518, -10.000> 
		<-0.000, 2.518, -10.375> <0.064, 2.518, -10.375> <0.137, 2.518, -10.375> <0.201, 2.518, -10.375> 
		<-0.003, 2.518, -10.875> <0.039, 2.518, -10.875> <0.119, 2.518, -10.875> <0.161, 2.518, -10.875> 
		<-0.001, 2.518, -11.250> <0.041, 2.518, -11.250> <0.097, 2.518, -11.250> <0.139, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.213, 2.518, -10.000> <0.372, 2.518, -10.000> <0.585, 2.518, -10.000> <0.744, 2.518, -10.000> 
		<0.201, 2.518, -10.375> <0.360, 2.518, -10.375> <0.542, 2.518, -10.380> <0.702, 2.518, -10.380> 
		<0.161, 2.518, -10.875> <0.265, 2.518, -10.875> <0.465, 2.518, -10.876> <0.570, 2.518, -10.876> 
		<0.139, 2.518, -11.250> <0.244, 2.518, -11.250> <0.383, 2.518, -11.250> <0.488, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.518, -11.750> <-0.075, 2.518, -12.044> <-0.071, 2.518, -12.438> <-0.062, 2.518, -12.732> 
		<-0.060, 2.518, -11.750> <-0.044, 2.518, -12.044> <-0.060, 2.518, -12.470> <-0.052, 2.518, -12.764> 
		<-0.020, 2.518, -11.750> <-0.017, 2.518, -12.070> <-0.022, 2.518, -12.495> <-0.022, 2.518, -12.815> 
		<0.011, 2.518, -11.750> <0.013, 2.518, -12.070> <0.012, 2.518, -12.497> <0.012, 2.518, -12.817> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.518, -11.750> <-0.060, 2.518, -11.750> <-0.020, 2.518, -11.750> <0.011, 2.518, -11.750> 
		<-0.098, 2.518, -11.599> <-0.068, 2.518, -11.599> <-0.021, 2.518, -11.600> <0.009, 2.518, -11.600> 
		<-0.130, 2.518, -11.400> <-0.088, 2.518, -11.400> <-0.042, 2.518, -11.400> <0.000, 2.518, -11.400> 
		<-0.141, 2.518, -11.250> <-0.099, 2.518, -11.250> <-0.043, 2.518, -11.250> <-0.001, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.518, -11.750> <-0.090, 2.518, -11.750> <-0.090, 2.518, -11.750> <-0.090, 2.518, -11.750> 
		<-0.075, 2.518, -12.044> <-0.150, 2.518, -12.044> <-0.150, 2.518, -12.044> <-0.166, 2.518, -11.750> 
		<-0.071, 2.518, -12.438> <-0.167, 2.518, -12.147> <-0.182, 2.518, -12.044> <-0.267, 2.518, -11.750> 
		<-0.062, 2.518, -12.732> <-0.159, 2.518, -12.441> <-0.257, 2.518, -12.044> <-0.342, 2.518, -11.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 2.518, -11.750> <-0.166, 2.518, -11.750> <-0.267, 2.518, -11.750> <-0.342, 2.518, -11.750> 
		<-0.098, 2.518, -11.599> <-0.174, 2.518, -11.599> <-0.310, 2.518, -11.600> <-0.386, 2.518, -11.600> 
		<-0.130, 2.518, -11.400> <-0.235, 2.518, -11.400> <-0.350, 2.518, -11.402> <-0.455, 2.518, -11.402> 
		<-0.141, 2.518, -11.250> <-0.245, 2.518, -11.250> <-0.385, 2.518, -11.250> <-0.490, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 2.518, -11.750> <0.013, 2.518, -12.070> <0.012, 2.518, -12.497> <0.012, 2.518, -12.817> 
		<0.041, 2.518, -11.750> <0.044, 2.518, -12.070> <0.047, 2.518, -12.498> <0.048, 2.518, -12.818> 
		<0.081, 2.518, -11.750> <0.074, 2.518, -12.046> <0.093, 2.518, -12.475> <0.089, 2.518, -12.772> 
		<0.112, 2.518, -11.750> <0.104, 2.518, -12.046> <0.104, 2.518, -12.442> <0.100, 2.518, -12.738> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.011, 2.518, -11.750> <0.041, 2.518, -11.750> <0.081, 2.518, -11.750> <0.112, 2.518, -11.750> 
		<0.009, 2.518, -11.600> <0.040, 2.518, -11.600> <0.085, 2.518, -11.600> <0.115, 2.518, -11.600> 
		<0.000, 2.518, -11.400> <0.042, 2.518, -11.400> <0.088, 2.518, -11.400> <0.130, 2.518, -11.400> 
		<-0.001, 2.518, -11.250> <0.041, 2.518, -11.250> <0.097, 2.518, -11.250> <0.139, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.112, 2.518, -11.750> <0.187, 2.518, -11.750> <0.288, 2.518, -11.750> <0.364, 2.518, -11.750> 
		<0.115, 2.518, -11.600> <0.191, 2.518, -11.600> <0.327, 2.518, -11.600> <0.403, 2.518, -11.600> 
		<0.130, 2.518, -11.400> <0.235, 2.518, -11.400> <0.351, 2.518, -11.401> <0.455, 2.518, -11.401> 
		<0.139, 2.518, -11.250> <0.244, 2.518, -11.250> <0.383, 2.518, -11.250> <0.488, 2.518, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.112, 2.518, -11.750> <0.112, 2.518, -11.750> <0.112, 2.518, -11.750> <0.112, 2.518, -11.750> 
		<0.187, 2.518, -11.750> <0.179, 2.518, -12.046> <0.179, 2.518, -12.046> <0.104, 2.518, -12.046> 
		<0.288, 2.518, -11.750> <0.211, 2.518, -12.047> <0.200, 2.518, -12.150> <0.104, 2.518, -12.442> 
		<0.364, 2.518, -11.750> <0.286, 2.518, -12.047> <0.196, 2.518, -12.447> <0.100, 2.518, -12.738> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 2.518, 14.000> <-0.400, 2.518, 14.000> <-0.629, 2.518, 14.000> <-0.800, 2.518, 14.000> 
		<-0.201, 2.518, 14.390> <-0.373, 2.518, 14.390> <-0.520, 2.518, 14.395> <-0.691, 2.518, 14.395> 
		<-0.169, 2.483, 14.911> <-0.241, 2.483, 14.911> <-0.430, 2.483, 14.910> <-0.501, 2.483, 14.910> 
		<-0.137, 2.518, 15.299> <-0.208, 2.518, 15.299> <-0.304, 2.518, 15.299> <-0.376, 2.518, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.229, 2.518, 14.000> <-0.201, 2.518, 14.390> <-0.169, 2.483, 14.911> <-0.137, 2.518, 15.299> 
		<-0.160, 2.518, 14.000> <-0.133, 2.518, 14.390> <-0.140, 2.483, 14.911> <-0.108, 2.518, 15.299> 
		<-0.069, 2.518, 14.000> <-0.074, 2.518, 14.390> <-0.065, 2.483, 14.911> <-0.070, 2.518, 15.299> 
		<0.000, 2.518, 14.000> <-0.005, 2.518, 14.390> <-0.036, 2.483, 14.911> <-0.041, 2.518, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 14.000> <-0.005, 2.518, 14.390> <-0.036, 2.483, 14.911> <-0.041, 2.518, 15.299> 
		<0.069, 2.518, 14.000> <0.064, 2.518, 14.390> <-0.008, 2.483, 14.911> <-0.013, 2.518, 15.299> 
		<0.160, 2.518, 14.000> <0.123, 2.518, 14.391> <0.068, 2.483, 14.910> <0.025, 2.518, 15.299> 
		<0.229, 2.518, 14.000> <0.191, 2.518, 14.391> <0.097, 2.483, 14.910> <0.054, 2.518, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.229, 2.518, 14.000> <0.191, 2.518, 14.391> <0.097, 2.483, 14.910> <0.054, 2.518, 15.299> 
		<0.400, 2.518, 14.000> <0.363, 2.518, 14.391> <0.168, 2.483, 14.910> <0.126, 2.518, 15.299> 
		<0.629, 2.518, 14.000> <0.508, 2.518, 14.401> <0.359, 2.482, 14.905> <0.221, 2.518, 15.299> 
		<0.800, 2.518, 14.000> <0.680, 2.518, 14.401> <0.430, 2.482, 14.905> <0.293, 2.518, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 2.518, 15.299> <-0.208, 2.518, 15.299> <-0.304, 2.518, 15.299> <-0.376, 2.518, 15.299> 
		<-0.123, 2.533, 15.472> <-0.194, 2.533, 15.472> <-0.248, 2.533, 15.470> <-0.320, 2.533, 15.470> 
		<-0.088, 2.576, 15.715> <-0.126, 2.576, 15.715> <-0.205, 2.574, 15.713> <-0.242, 2.574, 15.713> 
		<-0.075, 2.683, 15.852> <-0.113, 2.683, 15.852> <-0.164, 2.683, 15.852> <-0.201, 2.683, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.137, 2.518, 15.299> <-0.123, 2.533, 15.472> <-0.088, 2.576, 15.715> <-0.075, 2.683, 15.852> 
		<-0.108, 2.518, 15.299> <-0.094, 2.533, 15.472> <-0.073, 2.576, 15.715> <-0.060, 2.683, 15.852> 
		<-0.070, 2.518, 15.299> <-0.072, 2.533, 15.471> <-0.042, 2.576, 15.715> <-0.040, 2.683, 15.852> 
		<-0.041, 2.518, 15.299> <-0.044, 2.533, 15.471> <-0.027, 2.576, 15.715> <-0.025, 2.683, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.041, 2.518, 15.299> <-0.044, 2.533, 15.471> <-0.027, 2.576, 15.715> <-0.025, 2.683, 15.852> 
		<-0.013, 2.518, 15.299> <-0.015, 2.533, 15.471> <-0.012, 2.576, 15.715> <-0.010, 2.683, 15.852> 
		<0.025, 2.518, 15.299> <0.007, 2.533, 15.470> <0.018, 2.576, 15.716> <0.010, 2.683, 15.852> 
		<0.054, 2.518, 15.299> <0.035, 2.533, 15.470> <0.034, 2.576, 15.716> <0.026, 2.683, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.054, 2.518, 15.299> <0.035, 2.533, 15.470> <0.034, 2.576, 15.716> <0.026, 2.683, 15.852> 
		<0.126, 2.518, 15.299> <0.107, 2.533, 15.470> <0.071, 2.576, 15.716> <0.063, 2.683, 15.852> 
		<0.221, 2.518, 15.299> <0.162, 2.533, 15.466> <0.148, 2.575, 15.714> <0.114, 2.683, 15.852> 
		<0.293, 2.518, 15.299> <0.234, 2.533, 15.466> <0.186, 2.575, 15.714> <0.152, 2.683, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 2.683, 15.852> <-0.113, 2.683, 15.852> <-0.164, 2.683, 15.852> <-0.201, 2.683, 15.852> 
		<-0.060, 2.806, 16.007> <-0.098, 2.806, 16.007> <-0.118, 2.804, 16.004> <-0.156, 2.804, 16.004> 
		<-0.057, 3.070, 16.103> <-0.074, 3.070, 16.102> <-0.118, 3.070, 16.101> <-0.134, 3.070, 16.100> 
		<-0.050, 3.236, 16.211> <-0.067, 3.236, 16.210> <-0.089, 3.236, 16.208> <-0.106, 3.236, 16.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 2.683, 15.852> <-0.113, 2.683, 15.852> <-0.164, 2.683, 15.852> <-0.201, 2.683, 15.852> 
		<-0.060, 2.806, 16.007> <-0.098, 2.806, 16.007> <-0.118, 2.804, 16.004> <-0.156, 2.804, 16.004> 
		<-0.057, 3.070, 16.103> <-0.074, 3.070, 16.102> <-0.118, 3.070, 16.101> <-0.134, 3.070, 16.100> 
		<-0.050, 3.236, 16.211> <-0.067, 3.236, 16.209> <-0.089, 3.236, 16.208> <-0.106, 3.236, 16.206> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.075, 2.683, 15.852> <-0.060, 2.806, 16.007> <-0.057, 3.070, 16.103> <-0.050, 3.236, 16.211> 
		<-0.060, 2.683, 15.852> <-0.045, 2.806, 16.007> <-0.050, 3.070, 16.103> <-0.042, 3.236, 16.211> 
		<-0.040, 2.683, 15.852> <-0.037, 2.806, 16.007> <-0.032, 3.070, 16.103> <-0.032, 3.236, 16.211> 
		<-0.025, 2.683, 15.852> <-0.022, 2.806, 16.007> <-0.025, 3.070, 16.103> <-0.025, 3.236, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 2.683, 15.852> <-0.022, 2.806, 16.007> <-0.025, 3.070, 16.103> <-0.025, 3.236, 16.211> 
		<-0.010, 2.683, 15.852> <-0.007, 2.806, 16.007> <-0.017, 3.070, 16.103> <-0.017, 3.236, 16.211> 
		<0.010, 2.683, 15.852> <0.001, 2.806, 16.007> <0.000, 3.070, 16.103> <-0.007, 3.236, 16.211> 
		<0.026, 2.683, 15.852> <0.016, 2.806, 16.007> <0.008, 3.070, 16.103> <0.000, 3.236, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.050, 3.236, 16.211> <-0.050, 3.236, 16.211> <-0.050, 3.236, 16.211> <-0.050, 3.236, 16.211> 
		<-0.042, 3.236, 16.211> <-0.035, 3.236, 16.211> <-0.035, 3.236, 16.211> <-0.042, 3.236, 16.211> 
		<-0.032, 3.236, 16.211> <-0.032, 3.236, 16.211> <-0.032, 3.236, 16.211> <-0.032, 3.236, 16.211> 
		<-0.025, 3.236, 16.211> <-0.025, 3.236, 16.211> <-0.025, 3.236, 16.211> <-0.025, 3.236, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.025, 3.236, 16.211> <-0.017, 3.236, 16.211> <-0.007, 3.236, 16.211> <0.000, 3.236, 16.211> 
		<-0.025, 3.236, 16.211> <-0.017, 3.236, 16.211> <-0.007, 3.236, 16.211> <0.000, 3.236, 16.211> 
		<-0.025, 3.236, 16.211> <-0.017, 3.236, 16.211> <-0.007, 3.236, 16.211> <0.000, 3.236, 16.211> 
		<-0.025, 3.236, 16.211> <-0.017, 3.236, 16.211> <-0.007, 3.236, 16.211> <0.000, 3.236, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.744, 2.518, -10.000> <0.744, 2.587, -10.000> <0.744, 2.680, -10.000> <0.744, 2.750, -10.000> 
		<0.702, 2.518, -10.380> <0.702, 2.587, -10.380> <0.702, 2.680, -10.380> <0.702, 2.750, -10.380> 
		<0.570, 2.518, -10.876> <0.570, 2.587, -10.876> <0.570, 2.680, -10.876> <0.570, 2.750, -10.876> 
		<0.488, 2.518, -11.250> <0.488, 2.587, -11.250> <0.488, 2.680, -11.250> <0.488, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.744, 2.518, -10.000> <0.744, 2.587, -10.000> <0.744, 2.680, -10.000> <0.744, 2.750, -10.000> 
		<1.080, 2.518, -7.004> <1.080, 2.587, -7.004> <1.080, 2.680, -7.004> <1.080, 2.750, -7.004> 
		<1.548, 2.518, -3.008> <1.548, 2.587, -3.008> <1.548, 2.680, -3.008> <1.548, 2.750, -3.008> 
		<1.750, 2.518, 0.000> <1.750, 2.587, 0.000> <1.750, 2.680, 0.000> <1.750, 2.750, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.488, 2.518, -11.250> <0.488, 2.587, -11.250> <0.488, 2.680, -11.250> <0.488, 2.750, -11.250> 
		<0.455, 2.518, -11.401> <0.455, 2.587, -11.401> <0.455, 2.680, -11.401> <0.455, 2.750, -11.401> 
		<0.403, 2.518, -11.600> <0.403, 2.587, -11.600> <0.400, 2.680, -11.600> <0.400, 2.750, -11.600> 
		<0.364, 2.518, -11.750> <0.364, 2.587, -11.750> <0.364, 2.680, -11.750> <0.364, 2.750, -11.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.364, 2.518, -11.750> <0.364, 2.587, -11.750> <0.364, 2.680, -11.750> <0.364, 2.750, -11.750> 
		<0.286, 2.518, -12.047> <0.286, 2.587, -12.047> <0.284, 2.680, -12.076> <0.284, 2.750, -12.076> 
		<0.196, 2.518, -12.447> <0.196, 2.587, -12.476> <0.197, 2.680, -12.486> <0.197, 2.750, -12.515> 
		<0.100, 2.518, -12.738> <0.100, 2.587, -12.767> <0.100, 2.680, -12.807> <0.100, 2.750, -12.836> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.100, 2.518, -12.738> <0.089, 2.518, -12.772> <0.048, 2.518, -12.818> <0.012, 2.518, -12.817> 
		<0.100, 2.587, -12.767> <0.089, 2.587, -12.801> <0.048, 2.587, -12.847> <0.012, 2.587, -12.846> 
		<0.100, 2.680, -12.807> <0.090, 2.680, -12.841> <0.047, 2.680, -12.887> <0.012, 2.680, -12.885> 
		<0.100, 2.750, -12.836> <0.090, 2.750, -12.870> <0.047, 2.750, -12.917> <0.012, 2.750, -12.915> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.012, 2.518, -12.817> <-0.022, 2.518, -12.815> <-0.052, 2.518, -12.764> <-0.062, 2.518, -12.732> 
		<0.012, 2.587, -12.846> <-0.022, 2.587, -12.845> <-0.053, 2.587, -12.792> <-0.064, 2.587, -12.760> 
		<0.012, 2.680, -12.885> <-0.023, 2.680, -12.883> <-0.055, 2.680, -12.832> <-0.065, 2.680, -12.798> 
		<0.012, 2.750, -12.915> <-0.023, 2.750, -12.912> <-0.056, 2.750, -12.860> <-0.067, 2.750, -12.826> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.062, 2.518, -12.732> <-0.159, 2.518, -12.441> <-0.257, 2.518, -12.044> <-0.342, 2.518, -11.750> 
		<-0.064, 2.587, -12.760> <-0.160, 2.587, -12.470> <-0.257, 2.587, -12.044> <-0.342, 2.587, -11.750> 
		<-0.065, 2.680, -12.798> <-0.162, 2.680, -12.479> <-0.256, 2.680, -12.072> <-0.342, 2.680, -11.750> 
		<-0.067, 2.750, -12.826> <-0.164, 2.750, -12.507> <-0.256, 2.750, -12.072> <-0.342, 2.750, -11.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.342, 2.518, -11.750> <-0.342, 2.587, -11.750> <-0.342, 2.680, -11.750> <-0.342, 2.750, -11.750> 
		<-0.386, 2.518, -11.600> <-0.386, 2.587, -11.600> <-0.383, 2.680, -11.599> <-0.383, 2.750, -11.599> 
		<-0.455, 2.518, -11.402> <-0.455, 2.587, -11.402> <-0.455, 2.680, -11.402> <-0.455, 2.750, -11.402> 
		<-0.490, 2.518, -11.250> <-0.490, 2.587, -11.250> <-0.490, 2.680, -11.250> <-0.490, 2.750, -11.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.490, 2.518, -11.250> <-0.490, 2.587, -11.250> <-0.490, 2.680, -11.250> <-0.490, 2.750, -11.250> 
		<-0.576, 2.518, -10.877> <-0.576, 2.587, -10.877> <-0.576, 2.680, -10.877> <-0.576, 2.750, -10.877> 
		<-0.702, 2.518, -10.380> <-0.702, 2.587, -10.380> <-0.702, 2.680, -10.380> <-0.702, 2.750, -10.380> 
		<-0.744, 2.518, -10.000> <-0.744, 2.587, -10.000> <-0.744, 2.680, -10.000> <-0.744, 2.750, -10.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.744, 2.518, -10.000> <-0.744, 2.587, -10.000> <-0.744, 2.680, -10.000> <-0.744, 2.750, -10.000> 
		<-1.080, 2.518, -7.004> <-1.080, 2.587, -7.004> <-1.080, 2.680, -7.004> <-1.080, 2.750, -7.004> 
		<-1.548, 2.518, -3.008> <-1.548, 2.587, -3.008> <-1.548, 2.680, -3.008> <-1.548, 2.750, -3.008> 
		<-1.750, 2.518, 0.000> <-1.750, 2.587, 0.000> <-1.750, 2.680, 0.000> <-1.750, 2.750, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.518, 0.000> <-1.750, 2.587, 0.000> <-1.750, 2.680, 0.000> <-1.750, 2.750, 0.000> 
		<-1.850, 2.518, 1.497> <-1.850, 2.587, 1.497> <-1.850, 2.680, 1.497> <-1.850, 2.750, 1.497> 
		<-1.750, 2.518, 3.500> <-1.750, 2.587, 3.500> <-1.750, 2.680, 3.500> <-1.750, 2.750, 3.500> 
		<-1.750, 2.518, 5.000> <-1.750, 2.587, 5.000> <-1.750, 2.680, 5.000> <-1.750, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.518, 5.000> <-1.750, 2.587, 5.000> <-1.750, 2.680, 5.000> <-1.750, 2.750, 5.000> 
		<-1.375, 2.518, 5.000> <-1.375, 2.587, 5.000> <-1.375, 2.680, 5.000> <-1.375, 2.750, 5.000> 
		<-0.875, 2.518, 5.000> <-0.875, 2.587, 5.000> <-0.875, 2.680, 5.000> <-0.875, 2.750, 5.000> 
		<-0.500, 2.518, 5.000> <-0.500, 2.587, 5.000> <-0.500, 2.680, 5.000> <-0.500, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.518, 5.000> <-1.750, 2.587, 5.000> <-1.750, 2.680, 5.000> <-1.750, 2.750, 5.000> 
		<-1.750, 2.518, 5.300> <-1.750, 2.587, 5.300> <-1.750, 2.680, 5.300> <-1.750, 2.750, 5.300> 
		<-1.754, 2.518, 5.700> <-1.754, 2.587, 5.700> <-1.754, 2.680, 5.700> <-1.754, 2.750, 5.700> 
		<-1.750, 2.518, 6.000> <-1.750, 2.587, 6.000> <-1.750, 2.680, 6.000> <-1.750, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.518, 5.000> <-1.750, 2.518, 5.300> <-1.754, 2.518, 5.700> <-1.750, 2.518, 6.000> 
		<-1.375, 2.518, 5.000> <-1.375, 2.518, 5.300> <-1.379, 2.518, 5.700> <-1.375, 2.518, 6.000> 
		<-0.875, 2.518, 5.000> <-0.875, 2.518, 5.300> <-0.876, 2.518, 5.700> <-0.875, 2.518, 6.000> 
		<-0.500, 2.518, 5.000> <-0.500, 2.518, 5.300> <-0.501, 2.518, 5.700> <-0.500, 2.518, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.750, 5.000> <-1.375, 2.750, 5.000> <-0.875, 2.750, 5.000> <-0.500, 2.750, 5.000> 
		<-1.750, 2.750, 5.300> <-1.375, 2.750, 5.300> <-0.875, 2.750, 5.300> <-0.500, 2.750, 5.300> 
		<-1.754, 2.750, 5.700> <-1.379, 2.750, 5.700> <-0.876, 2.750, 5.700> <-0.501, 2.750, 5.700> 
		<-1.750, 2.750, 6.000> <-1.375, 2.750, 6.000> <-0.875, 2.750, 6.000> <-0.500, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.518, 6.000> <-1.750, 2.587, 6.000> <-1.750, 2.680, 6.000> <-1.750, 2.750, 6.000> 
		<-1.375, 2.518, 6.000> <-1.375, 2.587, 6.000> <-1.375, 2.680, 6.000> <-1.375, 2.750, 6.000> 
		<-0.875, 2.518, 6.000> <-0.875, 2.587, 6.000> <-0.875, 2.680, 6.000> <-0.875, 2.750, 6.000> 
		<-0.500, 2.518, 6.000> <-0.500, 2.587, 6.000> <-0.500, 2.680, 6.000> <-0.500, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.750, 2.518, 6.000> <-1.750, 2.587, 6.000> <-1.750, 2.680, 6.000> <-1.750, 2.750, 6.000> 
		<-1.738, 2.518, 6.900> <-1.738, 2.587, 6.900> <-1.738, 2.680, 6.900> <-1.738, 2.750, 6.900> 
		<-1.766, 2.518, 8.103> <-1.766, 2.587, 8.103> <-1.766, 2.680, 8.103> <-1.766, 2.750, 8.103> 
		<-1.697, 2.518, 9.000> <-1.697, 2.587, 9.000> <-1.697, 2.680, 9.000> <-1.697, 2.750, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 6.000> <-0.500, 2.587, 6.000> <-0.500, 2.680, 6.000> <-0.500, 2.750, 6.000> 
		<-0.350, 2.518, 6.000> <-0.350, 2.587, 6.000> <-0.350, 2.680, 6.000> <-0.350, 2.750, 6.000> 
		<-0.150, 2.518, 6.000> <-0.150, 2.587, 6.000> <-0.150, 2.680, 6.000> <-0.150, 2.750, 6.000> 
		<0.000, 2.518, 6.000> <0.000, 2.587, 6.000> <0.000, 2.680, 6.000> <0.000, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 6.000> <-0.500, 2.587, 6.000> <-0.500, 2.680, 6.000> <-0.500, 2.750, 6.000> 
		<-0.501, 2.518, 5.700> <-0.501, 2.587, 5.700> <-0.501, 2.680, 5.700> <-0.501, 2.750, 5.700> 
		<-0.500, 2.518, 5.300> <-0.500, 2.587, 5.300> <-0.500, 2.680, 5.300> <-0.500, 2.750, 5.300> 
		<-0.500, 2.518, 5.000> <-0.500, 2.587, 5.000> <-0.500, 2.680, 5.000> <-0.500, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 6.000> <0.150, 2.518, 6.000> <0.350, 2.518, 6.000> <0.500, 2.518, 6.000> 
		<0.000, 2.587, 6.000> <0.150, 2.587, 6.000> <0.350, 2.587, 6.000> <0.500, 2.587, 6.000> 
		<0.000, 2.680, 6.000> <0.150, 2.680, 6.000> <0.350, 2.680, 6.000> <0.500, 2.680, 6.000> 
		<0.000, 2.750, 6.000> <0.150, 2.750, 6.000> <0.350, 2.750, 6.000> <0.500, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.518, 6.000> <0.500, 2.587, 6.000> <0.500, 2.680, 6.000> <0.500, 2.750, 6.000> 
		<0.875, 2.518, 6.000> <0.875, 2.587, 6.000> <0.875, 2.680, 6.000> <0.875, 2.750, 6.000> 
		<1.375, 2.518, 6.000> <1.375, 2.587, 6.000> <1.375, 2.680, 6.000> <1.375, 2.750, 6.000> 
		<1.750, 2.518, 6.000> <1.750, 2.587, 6.000> <1.750, 2.680, 6.000> <1.750, 2.750, 6.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.518, 6.000> <0.500, 2.518, 5.700> <0.500, 2.518, 5.300> <0.500, 2.518, 5.000> 
		<0.500, 2.587, 6.000> <0.500, 2.587, 5.700> <0.500, 2.587, 5.300> <0.500, 2.587, 5.000> 
		<0.500, 2.680, 6.000> <0.501, 2.680, 5.700> <0.500, 2.680, 5.300> <0.500, 2.680, 5.000> 
		<0.500, 2.750, 6.000> <0.501, 2.750, 5.700> <0.500, 2.750, 5.300> <0.500, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.518, 6.000> <0.875, 2.518, 6.000> <1.375, 2.518, 6.000> <1.750, 2.518, 6.000> 
		<0.500, 2.518, 5.700> <0.875, 2.518, 5.700> <1.379, 2.518, 5.700> <1.754, 2.518, 5.700> 
		<0.500, 2.518, 5.300> <0.875, 2.518, 5.300> <1.375, 2.518, 5.300> <1.750, 2.518, 5.300> 
		<0.500, 2.518, 5.000> <0.875, 2.518, 5.000> <1.375, 2.518, 5.000> <1.750, 2.518, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.750, 6.000> <0.875, 2.750, 6.000> <1.375, 2.750, 6.000> <1.750, 2.750, 6.000> 
		<0.501, 2.750, 5.700> <0.876, 2.750, 5.700> <1.379, 2.750, 5.700> <1.754, 2.750, 5.700> 
		<0.500, 2.750, 5.300> <0.875, 2.750, 5.300> <1.375, 2.750, 5.300> <1.750, 2.750, 5.300> 
		<0.500, 2.750, 5.000> <0.875, 2.750, 5.000> <1.375, 2.750, 5.000> <1.750, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 2.518, 5.000> <-0.500, 2.587, 5.000> <-0.500, 2.680, 5.000> <-0.500, 2.750, 5.000> 
		<-0.350, 2.518, 5.000> <-0.350, 2.587, 5.000> <-0.350, 2.680, 5.000> <-0.350, 2.750, 5.000> 
		<-0.150, 2.518, 5.000> <-0.150, 2.587, 5.000> <-0.150, 2.680, 5.000> <-0.150, 2.750, 5.000> 
		<0.000, 2.518, 5.000> <0.000, 2.587, 5.000> <0.000, 2.680, 5.000> <0.000, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 2.518, 5.000> <0.000, 2.587, 5.000> <0.000, 2.680, 5.000> <0.000, 2.750, 5.000> 
		<0.150, 2.518, 5.000> <0.150, 2.587, 5.000> <0.150, 2.680, 5.000> <0.150, 2.750, 5.000> 
		<0.350, 2.518, 5.000> <0.350, 2.587, 5.000> <0.350, 2.680, 5.000> <0.350, 2.750, 5.000> 
		<0.500, 2.518, 5.000> <0.500, 2.587, 5.000> <0.500, 2.680, 5.000> <0.500, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.500, 2.518, 5.000> <0.500, 2.587, 5.000> <0.500, 2.680, 5.000> <0.500, 2.750, 5.000> 
		<0.875, 2.518, 5.000> <0.875, 2.587, 5.000> <0.875, 2.680, 5.000> <0.875, 2.750, 5.000> 
		<1.375, 2.518, 5.000> <1.375, 2.587, 5.000> <1.375, 2.680, 5.000> <1.375, 2.750, 5.000> 
		<1.750, 2.518, 5.000> <1.750, 2.587, 5.000> <1.750, 2.680, 5.000> <1.750, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.750, 2.518, 6.000> <1.750, 2.587, 6.000> <1.750, 2.680, 6.000> <1.750, 2.750, 6.000> 
		<1.754, 2.518, 5.700> <1.754, 2.587, 5.700> <1.754, 2.680, 5.700> <1.754, 2.750, 5.700> 
		<1.750, 2.518, 5.300> <1.750, 2.587, 5.300> <1.750, 2.680, 5.300> <1.750, 2.750, 5.300> 
		<1.750, 2.518, 5.000> <1.750, 2.587, 5.000> <1.750, 2.680, 5.000> <1.750, 2.750, 5.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.750, 2.518, 6.000> <1.750, 2.587, 6.000> <1.750, 2.680, 6.000> <1.750, 2.750, 6.000> 
		<1.739, 2.518, 6.899> <1.739, 2.587, 6.899> <1.738, 2.680, 6.900> <1.738, 2.750, 6.900> 
		<1.772, 2.518, 8.099> <1.771, 2.587, 8.101> <1.768, 2.680, 8.101> <1.766, 2.750, 8.103> 
		<1.703, 2.518, 8.996> <1.701, 2.587, 8.997> <1.699, 2.680, 8.999> <1.697, 2.750, 9.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.750, 2.518, 5.000> <1.750, 2.587, 5.000> <1.750, 2.680, 5.000> <1.750, 2.750, 5.000> 
		<1.750, 2.518, 3.500> <1.750, 2.587, 3.500> <1.750, 2.680, 3.500> <1.750, 2.750, 3.500> 
		<1.850, 2.518, 1.497> <1.850, 2.587, 1.497> <1.850, 2.680, 1.497> <1.850, 2.750, 1.497> 
		<1.750, 2.518, 0.000> <1.750, 2.587, 0.000> <1.750, 2.680, 0.000> <1.750, 2.750, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.697, 2.518, 9.000> <-1.697, 2.587, 9.000> <-1.697, 2.680, 9.000> <-1.697, 2.750, 9.000> 
		<-1.627, 2.518, 9.906> <-1.627, 2.587, 9.906> <-1.627, 2.680, 9.906> <-1.627, 2.750, 9.906> 
		<-1.447, 2.518, 11.106> <-1.447, 2.587, 11.106> <-1.447, 2.680, 11.106> <-1.447, 2.750, 11.106> 
		<-1.287, 2.518, 12.000> <-1.287, 2.587, 12.000> <-1.287, 2.680, 12.000> <-1.287, 2.750, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.703, 2.518, 8.996> <1.701, 2.587, 8.997> <1.699, 2.680, 8.999> <1.697, 2.750, 9.000> 
		<1.633, 2.518, 9.903> <1.631, 2.587, 9.904> <1.629, 2.680, 9.904> <1.627, 2.750, 9.906> 
		<1.448, 2.518, 11.104> <1.448, 2.587, 11.104> <1.447, 2.680, 11.106> <1.447, 2.750, 11.106> 
		<1.287, 2.518, 12.000> <1.287, 2.587, 12.000> <1.287, 2.680, 12.000> <1.287, 2.750, 12.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.287, 2.518, 12.000> <-1.287, 2.587, 12.000> <-1.287, 2.680, 12.000> <-1.287, 2.750, 12.000> 
		<-1.178, 2.518, 12.608> <-1.178, 2.587, 12.608> <-1.178, 2.680, 12.608> <-1.178, 2.750, 12.608> 
		<-0.965, 2.518, 13.405> <-0.965, 2.587, 13.405> <-0.965, 2.680, 13.405> <-0.965, 2.750, 13.405> 
		<-0.800, 2.518, 14.000> <-0.800, 2.587, 14.000> <-0.800, 2.680, 14.000> <-0.800, 2.750, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.287, 2.518, 12.000> <1.287, 2.587, 12.000> <1.287, 2.680, 12.000> <1.287, 2.750, 12.000> 
		<1.177, 2.518, 12.608> <1.177, 2.587, 12.608> <1.178, 2.680, 12.608> <1.178, 2.750, 12.608> 
		<0.979, 2.518, 13.409> <0.979, 2.587, 13.409> <0.979, 2.680, 13.409> <0.979, 2.750, 13.409> 
		<0.800, 2.518, 14.000> <0.800, 2.587, 14.000> <0.800, 2.680, 14.000> <0.800, 2.750, 14.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.800, 2.518, 14.000> <-0.800, 2.587, 14.000> <-0.800, 2.680, 14.000> <-0.800, 2.750, 14.000> 
		<-0.691, 2.518, 14.395> <-0.691, 2.587, 14.395> <-0.691, 2.680, 14.395> <-0.691, 2.750, 14.395> 
		<-0.501, 2.483, 14.910> <-0.501, 2.553, 14.910> <-0.501, 2.645, 14.910> <-0.501, 2.715, 14.910> 
		<-0.376, 2.518, 15.299> <-0.376, 2.587, 15.299> <-0.376, 2.680, 15.299> <-0.376, 2.750, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.800, 2.518, 14.000> <0.800, 2.587, 14.000> <0.800, 2.680, 14.000> <0.800, 2.750, 14.000> 
		<0.680, 2.518, 14.401> <0.680, 2.587, 14.401> <0.680, 2.680, 14.401> <0.680, 2.750, 14.401> 
		<0.430, 2.482, 14.905> <0.430, 2.552, 14.905> <0.430, 2.645, 14.905> <0.430, 2.715, 14.905> 
		<0.293, 2.518, 15.299> <0.293, 2.587, 15.299> <0.293, 2.680, 15.299> <0.293, 2.750, 15.299> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.376, 2.518, 15.299> <-0.376, 2.587, 15.299> <-0.376, 2.680, 15.299> <-0.376, 2.750, 15.299> 
		<-0.320, 2.533, 15.470> <-0.320, 2.603, 15.470> <-0.320, 2.696, 15.470> <-0.320, 2.765, 15.470> 
		<-0.242, 2.574, 15.713> <-0.242, 2.644, 15.713> <-0.241, 2.737, 15.713> <-0.241, 2.807, 15.713> 
		<-0.201, 2.683, 15.852> <-0.201, 2.753, 15.852> <-0.201, 2.846, 15.852> <-0.201, 2.916, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.293, 2.518, 15.299> <0.293, 2.587, 15.299> <0.293, 2.680, 15.299> <0.293, 2.750, 15.299> 
		<0.234, 2.533, 15.466> <0.234, 2.602, 15.466> <0.234, 2.695, 15.466> <0.234, 2.765, 15.466> 
		<0.186, 2.575, 15.714> <0.186, 2.645, 15.714> <0.186, 2.738, 15.714> <0.186, 2.808, 15.714> 
		<0.152, 2.683, 15.852> <0.152, 2.753, 15.852> <0.152, 2.846, 15.852> <0.152, 2.916, 15.852> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.201, 2.683, 15.852> <-0.201, 2.753, 15.852> <-0.201, 2.846, 15.852> <-0.201, 2.916, 15.852> 
		<-0.156, 2.804, 16.004> <-0.156, 2.874, 16.004> <-0.157, 2.967, 16.004> <-0.157, 3.036, 16.004> 
		<-0.134, 3.070, 16.100> <-0.136, 3.140, 16.101> <-0.137, 3.233, 16.102> <-0.139, 3.303, 16.103> 
		<-0.106, 3.236, 16.206> <-0.108, 3.306, 16.208> <-0.110, 3.399, 16.209> <-0.112, 3.468, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 2.683, 15.852> <0.152, 2.753, 15.852> <0.152, 2.846, 15.852> <0.152, 2.916, 15.852> 
		<0.113, 2.805, 16.005> <0.113, 2.874, 16.005> <0.113, 2.967, 16.005> <0.113, 3.037, 16.005> 
		<0.089, 3.070, 16.103> <0.089, 3.140, 16.103> <0.089, 3.233, 16.103> <0.089, 3.303, 16.103> 
		<0.062, 3.236, 16.211> <0.062, 3.306, 16.211> <0.062, 3.399, 16.211> <0.062, 3.468, 16.211> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.152, 2.683, 15.852> <0.152, 2.753, 15.852> <0.152, 2.846, 15.852> <0.152, 2.916, 15.852> 
		<0.113, 2.805, 16.005> <0.113, 2.874, 16.005> <0.113, 2.967, 16.005> <0.113, 3.037, 16.005> 
		<0.089, 3.070, 16.103> <0.089, 3.140, 16.103> <0.089, 3.233, 16.103> <0.089, 3.303, 16.103> 
		<0.062, 3.236, 16.211> <0.062, 3.306, 16.211> <0.062, 3.399, 16.211> <0.062, 3.468, 16.211> 
	}
	#ifndef (IMPORT_SPATCH)
    texture {brick texture{tar}, texture{ship_wood}
                               brick_size <0.2,1,10>
                               mortar 0.01};
	#end
}
// Layer 4 ram
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 0.000, -13.459> <-0.193, 0.015, -13.522> <-0.131, 0.000, -13.603> <-0.111, 0.000, -13.666> 
		<-0.193, 0.056, -13.459> <-0.201, 0.071, -13.522> <-0.143, 0.056, -13.576> <-0.122, 0.056, -13.639> 
		<-0.206, 0.131, -13.459> <-0.195, 0.131, -13.497> <-0.158, 0.125, -13.541> <-0.139, 0.125, -13.576> 
		<-0.212, 0.187, -13.459> <-0.201, 0.187, -13.497> <-0.168, 0.187, -13.541> <-0.149, 0.187, -13.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 0.000, -13.459> <-0.193, 0.056, -13.459> <-0.206, 0.131, -13.459> <-0.212, 0.187, -13.459> 
		<-0.171, -0.029, -13.333> <-0.179, 0.027, -13.333> <-0.224, 0.131, -13.395> <-0.231, 0.187, -13.395> 
		<-0.084, -0.097, -13.190> <-0.165, -0.011, -13.233> <-0.260, 0.071, -13.286> <-0.305, 0.187, -13.268> 
		<-0.041, -0.138, -13.074> <-0.122, -0.052, -13.118> <-0.200, 0.071, -13.258> <-0.245, 0.187, -13.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.111, 0.000, -13.666> <-0.098, 0.000, -13.703> <-0.088, 0.000, -13.755> <-0.076, 0.000, -13.792> 
		<-0.122, 0.056, -13.639> <-0.110, 0.056, -13.676> <-0.097, 0.056, -13.714> <-0.084, 0.056, -13.751> 
		<-0.139, 0.125, -13.576> <-0.125, 0.125, -13.600> <-0.109, 0.117, -13.629> <-0.101, 0.117, -13.655> 
		<-0.149, 0.187, -13.576> <-0.136, 0.187, -13.600> <-0.112, 0.187, -13.629> <-0.103, 0.187, -13.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.076, 0.000, -13.792> <-0.062, 0.000, -13.834> <-0.052, 0.000, -13.896> <-0.023, 0.000, -13.930> 
		<-0.084, 0.056, -13.751> <-0.070, 0.056, -13.793> <-0.074, 0.056, -13.840> <-0.045, 0.056, -13.874> 
		<-0.101, 0.117, -13.655> <-0.093, 0.117, -13.680> <-0.119, 0.105, -13.732> <-0.095, 0.105, -13.742> 
		<-0.103, 0.187, -13.655> <-0.096, 0.187, -13.680> <-0.120, 0.187, -13.732> <-0.096, 0.187, -13.742> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.023, 0.000, -13.930> <-0.010, 0.000, -13.945> <0.029, 0.000, -13.945> <0.042, 0.000, -13.930> 
		<-0.045, 0.056, -13.874> <-0.032, 0.056, -13.888> <0.051, 0.056, -13.888> <0.064, 0.056, -13.874> 
		<-0.095, 0.105, -13.742> <-0.036, 0.105, -13.765> <0.055, 0.105, -13.765> <0.114, 0.105, -13.742> 
		<-0.096, 0.187, -13.742> <-0.037, 0.187, -13.765> <0.056, 0.187, -13.765> <0.115, 0.187, -13.742> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 0.000, -13.930> <0.071, 0.000, -13.896> <0.081, 0.000, -13.834> <0.095, 0.000, -13.792> 
		<0.064, 0.056, -13.874> <0.093, 0.056, -13.840> <0.089, 0.056, -13.793> <0.103, 0.056, -13.751> 
		<0.114, 0.105, -13.742> <0.138, 0.105, -13.732> <0.112, 0.117, -13.680> <0.120, 0.117, -13.655> 
		<0.115, 0.187, -13.742> <0.139, 0.187, -13.732> <0.115, 0.187, -13.680> <0.122, 0.187, -13.655> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.095, 0.000, -13.792> <0.107, 0.000, -13.755> <0.117, 0.000, -13.703> <0.130, 0.000, -13.666> 
		<0.103, 0.056, -13.751> <0.116, 0.056, -13.714> <0.129, 0.056, -13.676> <0.141, 0.056, -13.639> 
		<0.120, 0.117, -13.655> <0.128, 0.117, -13.629> <0.149, 0.124, -13.600> <0.162, 0.124, -13.576> 
		<0.122, 0.187, -13.655> <0.131, 0.187, -13.629> <0.155, 0.187, -13.600> <0.168, 0.187, -13.576> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.130, 0.000, -13.666> <0.150, 0.000, -13.603> <0.212, 0.015, -13.522> <0.204, 0.000, -13.459> 
		<0.141, 0.056, -13.639> <0.162, 0.056, -13.576> <0.220, 0.071, -13.522> <0.212, 0.056, -13.459> 
		<0.162, 0.124, -13.576> <0.181, 0.124, -13.541> <0.214, 0.131, -13.497> <0.225, 0.131, -13.459> 
		<0.168, 0.187, -13.576> <0.187, 0.187, -13.541> <0.220, 0.187, -13.497> <0.231, 0.187, -13.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.204, 0.000, -13.459> <0.190, -0.029, -13.333> <0.127, -0.101, -13.179> <0.060, -0.138, -13.074> 
		<0.212, 0.056, -13.459> <0.198, 0.027, -13.333> <0.188, -0.003, -13.229> <0.121, -0.041, -13.124> 
		<0.225, 0.131, -13.459> <0.243, 0.131, -13.395> <0.279, 0.071, -13.286> <0.219, 0.071, -13.258> 
		<0.231, 0.187, -13.459> <0.250, 0.187, -13.395> <0.324, 0.187, -13.268> <0.264, 0.187, -13.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.212, 0.187, -13.459> <-0.201, 0.187, -13.497> <-0.168, 0.187, -13.541> <-0.149, 0.187, -13.576> 
		<-0.220, 0.250, -13.459> <-0.209, 0.250, -13.497> <-0.180, 0.255, -13.541> <-0.160, 0.255, -13.576> 
		<-0.228, 0.334, -13.459> <-0.222, 0.334, -13.522> <-0.211, 0.329, -13.603> <-0.186, 0.329, -13.662> 
		<-0.231, 0.398, -13.459> <-0.224, 0.398, -13.522> <-0.202, 0.398, -13.606> <-0.177, 0.398, -13.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.212, 0.187, -13.459> <-0.220, 0.250, -13.459> <-0.228, 0.334, -13.459> <-0.231, 0.398, -13.459> 
		<-0.231, 0.187, -13.395> <-0.238, 0.250, -13.395> <-0.243, 0.334, -13.319> <-0.246, 0.398, -13.319> 
		<-0.305, 0.187, -13.268> <-0.340, 0.277, -13.254> <-0.358, 0.300, -13.087> <-0.351, 0.398, -13.087> 
		<-0.245, 0.187, -13.240> <-0.280, 0.277, -13.226> <-0.256, 0.300, -12.991> <-0.249, 0.398, -12.991> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.149, 0.187, -13.576> <-0.136, 0.187, -13.600> <-0.112, 0.187, -13.629> <-0.103, 0.187, -13.655> 
		<-0.160, 0.255, -13.576> <-0.147, 0.255, -13.600> <-0.114, 0.262, -13.629> <-0.106, 0.262, -13.655> 
		<-0.186, 0.329, -13.662> <-0.168, 0.329, -13.705> <-0.120, 0.323, -13.747> <-0.097, 0.323, -13.787> 
		<-0.177, 0.398, -13.666> <-0.159, 0.398, -13.708> <-0.113, 0.398, -13.752> <-0.090, 0.398, -13.792> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.103, 0.187, -13.655> <-0.096, 0.187, -13.680> <-0.120, 0.187, -13.732> <-0.096, 0.187, -13.742> 
		<-0.106, 0.262, -13.655> <-0.098, 0.262, -13.680> <-0.121, 0.274, -13.732> <-0.097, 0.274, -13.742> 
		<-0.097, 0.323, -13.787> <-0.075, 0.323, -13.827> <-0.068, 0.311, -13.891> <-0.036, 0.311, -13.923> 
		<-0.090, 0.398, -13.792> <-0.068, 0.398, -13.832> <-0.061, 0.398, -13.898> <-0.029, 0.398, -13.930> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.096, 0.187, -13.742> <-0.037, 0.187, -13.765> <0.056, 0.187, -13.765> <0.115, 0.187, -13.742> 
		<-0.097, 0.274, -13.742> <-0.038, 0.274, -13.765> <0.057, 0.274, -13.765> <0.116, 0.274, -13.742> 
		<-0.036, 0.311, -13.923> <-0.020, 0.311, -13.939> <0.039, 0.311, -13.939> <0.055, 0.311, -13.923> 
		<-0.029, 0.398, -13.930> <-0.012, 0.398, -13.946> <0.032, 0.398, -13.946> <0.048, 0.398, -13.930> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.115, 0.187, -13.742> <0.139, 0.187, -13.732> <0.115, 0.187, -13.680> <0.122, 0.187, -13.655> 
		<0.116, 0.274, -13.742> <0.140, 0.274, -13.732> <0.117, 0.262, -13.680> <0.125, 0.262, -13.655> 
		<0.055, 0.311, -13.923> <0.088, 0.311, -13.891> <0.093, 0.322, -13.828> <0.112, 0.322, -13.787> 
		<0.048, 0.398, -13.930> <0.080, 0.398, -13.898> <0.090, 0.398, -13.833> <0.109, 0.398, -13.792> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.122, 0.187, -13.655> <0.131, 0.187, -13.629> <0.155, 0.187, -13.600> <0.168, 0.187, -13.576> 
		<0.125, 0.262, -13.655> <0.133, 0.262, -13.629> <0.161, 0.255, -13.600> <0.175, 0.255, -13.576> 
		<0.112, 0.322, -13.787> <0.129, 0.322, -13.749> <0.161, 0.330, -13.701> <0.178, 0.330, -13.662> 
		<0.109, 0.398, -13.792> <0.127, 0.398, -13.754> <0.152, 0.398, -13.704> <0.169, 0.398, -13.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.168, 0.187, -13.576> <0.187, 0.187, -13.541> <0.220, 0.187, -13.497> <0.231, 0.187, -13.459> 
		<0.175, 0.255, -13.576> <0.194, 0.255, -13.541> <0.228, 0.250, -13.497> <0.239, 0.250, -13.459> 
		<0.178, 0.330, -13.662> <0.204, 0.330, -13.601> <0.238, 0.334, -13.525> <0.247, 0.334, -13.459> 
		<0.169, 0.398, -13.666> <0.194, 0.398, -13.604> <0.240, 0.398, -13.525> <0.250, 0.398, -13.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.231, 0.187, -13.459> <0.250, 0.187, -13.395> <0.324, 0.187, -13.268> <0.264, 0.187, -13.240> 
		<0.239, 0.250, -13.459> <0.257, 0.250, -13.395> <0.359, 0.277, -13.254> <0.299, 0.277, -13.226> 
		<0.247, 0.334, -13.459> <0.268, 0.334, -13.320> <0.377, 0.300, -13.087> <0.275, 0.300, -12.991> 
		<0.250, 0.398, -13.459> <0.271, 0.398, -13.320> <0.370, 0.398, -13.087> <0.268, 0.398, -12.991> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.398, -13.459> <-0.224, 0.398, -13.522> <-0.202, 0.398, -13.606> <-0.177, 0.398, -13.666> 
		<-0.234, 0.461, -13.459> <-0.227, 0.461, -13.522> <-0.192, 0.468, -13.610> <-0.168, 0.468, -13.669> 
		<-0.237, 0.545, -13.459> <-0.218, 0.545, -13.514> <-0.138, 0.538, -13.549> <-0.103, 0.538, -13.596> 
		<-0.230, 0.608, -13.459> <-0.212, 0.608, -13.514> <-0.127, 0.608, -13.549> <-0.092, 0.608, -13.596> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.231, 0.398, -13.459> <-0.234, 0.461, -13.459> <-0.237, 0.545, -13.459> <-0.230, 0.608, -13.459> 
		<-0.246, 0.398, -13.319> <-0.249, 0.461, -13.319> <-0.258, 0.545, -13.396> <-0.252, 0.608, -13.396> 
		<-0.351, 0.398, -13.087> <-0.344, 0.496, -13.087> <-0.295, 0.513, -13.279> <-0.274, 0.608, -13.268> 
		<-0.249, 0.398, -12.991> <-0.242, 0.496, -12.991> <-0.236, 0.513, -13.251> <-0.214, 0.608, -13.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.177, 0.398, -13.666> <-0.159, 0.398, -13.708> <-0.113, 0.398, -13.752> <-0.090, 0.398, -13.792> 
		<-0.168, 0.468, -13.669> <-0.150, 0.468, -13.711> <-0.106, 0.469, -13.757> <-0.083, 0.469, -13.797> 
		<-0.103, 0.538, -13.596> <-0.087, 0.538, -13.618> <-0.071, 0.536, -13.655> <-0.066, 0.536, -13.682> 
		<-0.092, 0.608, -13.596> <-0.076, 0.608, -13.618> <-0.068, 0.608, -13.656> <-0.063, 0.608, -13.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.090, 0.398, -13.792> <-0.068, 0.398, -13.832> <-0.061, 0.398, -13.898> <-0.029, 0.398, -13.930> 
		<-0.083, 0.469, -13.797> <-0.061, 0.469, -13.836> <-0.054, 0.475, -13.905> <-0.022, 0.475, -13.937> 
		<-0.066, 0.536, -13.682> <-0.061, 0.536, -13.710> <-0.083, 0.530, -13.762> <-0.059, 0.530, -13.778> 
		<-0.063, 0.608, -13.683> <-0.058, 0.608, -13.711> <-0.082, 0.608, -13.762> <-0.058, 0.608, -13.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.029, 0.398, -13.930> <-0.012, 0.398, -13.946> <0.032, 0.398, -13.946> <0.048, 0.398, -13.930> 
		<-0.022, 0.475, -13.937> <-0.006, 0.475, -13.953> <0.025, 0.475, -13.953> <0.041, 0.475, -13.937> 
		<-0.059, 0.530, -13.778> <-0.026, 0.530, -13.800> <0.043, 0.530, -13.798> <0.078, 0.530, -13.778> 
		<-0.058, 0.608, -13.778> <-0.025, 0.608, -13.800> <0.042, 0.608, -13.798> <0.077, 0.608, -13.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.048, 0.398, -13.930> <0.080, 0.398, -13.898> <0.090, 0.398, -13.833> <0.109, 0.398, -13.792> 
		<0.041, 0.475, -13.937> <0.073, 0.475, -13.905> <0.088, 0.469, -13.838> <0.107, 0.469, -13.797> 
		<0.078, 0.530, -13.778> <0.104, 0.530, -13.763> <0.106, 0.537, -13.712> <0.112, 0.537, -13.683> 
		<0.077, 0.608, -13.778> <0.103, 0.608, -13.763> <0.104, 0.608, -13.712> <0.110, 0.608, -13.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.109, 0.398, -13.792> <0.127, 0.398, -13.754> <0.152, 0.398, -13.704> <0.169, 0.398, -13.666> 
		<0.107, 0.469, -13.797> <0.124, 0.469, -13.759> <0.143, 0.466, -13.707> <0.159, 0.466, -13.669> 
		<0.112, 0.537, -13.683> <0.117, 0.537, -13.657> <0.104, 0.540, -13.618> <0.117, 0.540, -13.596> 
		<0.110, 0.608, -13.683> <0.114, 0.608, -13.657> <0.097, 0.608, -13.618> <0.111, 0.608, -13.596> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.169, 0.398, -13.666> <0.194, 0.398, -13.604> <0.240, 0.398, -13.525> <0.250, 0.398, -13.459> 
		<0.159, 0.466, -13.669> <0.185, 0.466, -13.607> <0.243, 0.461, -13.525> <0.253, 0.461, -13.459> 
		<0.117, 0.540, -13.596> <0.148, 0.540, -13.546> <0.237, 0.545, -13.514> <0.256, 0.545, -13.459> 
		<0.111, 0.608, -13.596> <0.142, 0.608, -13.546> <0.231, 0.608, -13.514> <0.249, 0.608, -13.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.398, -13.459> <0.271, 0.398, -13.320> <0.370, 0.398, -13.087> <0.268, 0.398, -12.991> 
		<0.253, 0.461, -13.459> <0.273, 0.461, -13.320> <0.363, 0.496, -13.087> <0.261, 0.496, -12.991> 
		<0.256, 0.545, -13.459> <0.277, 0.545, -13.396> <0.314, 0.513, -13.279> <0.255, 0.513, -13.251> 
		<0.249, 0.608, -13.459> <0.271, 0.608, -13.396> <0.293, 0.608, -13.268> <0.233, 0.608, -13.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.023, 0.829, -13.930> <-0.034, 0.763, -13.884> <-0.057, 0.689, -13.778> <-0.058, 0.608, -13.778> 
		<-0.010, 0.829, -13.945> <-0.021, 0.763, -13.899> <-0.024, 0.689, -13.800> <-0.025, 0.608, -13.800> 
		<0.029, 0.829, -13.945> <0.040, 0.763, -13.899> <0.041, 0.689, -13.798> <0.042, 0.608, -13.798> 
		<0.042, 0.829, -13.930> <0.053, 0.763, -13.884> <0.076, 0.689, -13.778> <0.077, 0.608, -13.778> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.023, 0.829, -13.930> <-0.051, 0.829, -13.898> <-0.058, 0.829, -13.837> <-0.073, 0.829, -13.797> 
		<-0.034, 0.763, -13.884> <-0.062, 0.763, -13.852> <-0.055, 0.763, -13.803> <-0.070, 0.763, -13.763> 
		<-0.057, 0.689, -13.778> <-0.081, 0.689, -13.762> <-0.055, 0.683, -13.712> <-0.060, 0.683, -13.684> 
		<-0.058, 0.608, -13.778> <-0.082, 0.608, -13.762> <-0.058, 0.608, -13.711> <-0.063, 0.608, -13.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.023, 0.829, -13.930> <-0.010, 0.829, -13.945> <0.029, 0.829, -13.945> <0.042, 0.829, -13.930> 
		<-0.051, 0.829, -13.898> <-0.038, 0.829, -13.913> <0.058, 0.829, -13.911> <0.071, 0.829, -13.896> 
		<-0.058, 0.829, -13.837> <-0.007, 0.829, -13.835> <0.029, 0.829, -13.835> <0.079, 0.829, -13.833> 
		<-0.073, 0.829, -13.797> <-0.022, 0.829, -13.795> <0.045, 0.829, -13.794> <0.095, 0.829, -13.792> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.042, 0.829, -13.930> <0.053, 0.763, -13.884> <0.076, 0.689, -13.778> <0.077, 0.608, -13.778> 
		<0.071, 0.829, -13.896> <0.082, 0.763, -13.851> <0.102, 0.689, -13.763> <0.103, 0.608, -13.763> 
		<0.079, 0.829, -13.833> <0.084, 0.763, -13.801> <0.102, 0.682, -13.712> <0.104, 0.608, -13.712> 
		<0.095, 0.829, -13.792> <0.099, 0.763, -13.759> <0.107, 0.682, -13.683> <0.110, 0.608, -13.683> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, 0.608, -13.459> <-0.212, 0.608, -13.514> <-0.127, 0.608, -13.549> <-0.092, 0.608, -13.596> 
		<-0.223, 0.675, -13.459> <-0.204, 0.675, -13.514> <-0.117, 0.677, -13.549> <-0.082, 0.677, -13.596> 
		<-0.246, 0.799, -13.459> <-0.243, 0.795, -13.524> <-0.128, 0.763, -13.583> <-0.105, 0.763, -13.645> 
		<-0.185, 0.829, -13.459> <-0.182, 0.826, -13.524> <-0.133, 0.829, -13.603> <-0.111, 0.829, -13.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.230, 0.608, -13.459> <-0.223, 0.675, -13.459> <-0.246, 0.799, -13.459> <-0.185, 0.829, -13.459> 
		<-0.252, 0.608, -13.396> <-0.245, 0.675, -13.396> <-0.253, 0.807, -13.301> <-0.192, 0.838, -13.301> 
		<-0.274, 0.608, -13.268> <-0.247, 0.726, -13.254> <-0.177, 0.779, -13.184> <-0.156, 0.857, -13.093> 
		<-0.214, 0.608, -13.240> <-0.188, 0.726, -13.226> <-0.164, 0.791, -13.027> <-0.143, 0.869, -12.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.092, 0.608, -13.596> <-0.076, 0.608, -13.618> <-0.068, 0.608, -13.656> <-0.063, 0.608, -13.683> 
		<-0.082, 0.677, -13.596> <-0.065, 0.677, -13.618> <-0.065, 0.683, -13.657> <-0.060, 0.683, -13.684> 
		<-0.105, 0.763, -13.645> <-0.094, 0.763, -13.684> <-0.081, 0.763, -13.723> <-0.070, 0.763, -13.763> 
		<-0.111, 0.829, -13.666> <-0.099, 0.829, -13.705> <-0.084, 0.829, -13.758> <-0.073, 0.829, -13.797> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.110, 0.608, -13.683> <0.114, 0.608, -13.657> <0.097, 0.608, -13.618> <0.111, 0.608, -13.596> 
		<0.107, 0.682, -13.683> <0.112, 0.682, -13.657> <0.091, 0.678, -13.618> <0.105, 0.678, -13.596> 
		<0.099, 0.763, -13.759> <0.110, 0.763, -13.721> <0.114, 0.763, -13.683> <0.124, 0.763, -13.645> 
		<0.095, 0.829, -13.792> <0.106, 0.829, -13.754> <0.119, 0.829, -13.704> <0.130, 0.829, -13.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.111, 0.608, -13.596> <0.142, 0.608, -13.546> <0.231, 0.608, -13.514> <0.249, 0.608, -13.459> 
		<0.105, 0.678, -13.596> <0.136, 0.678, -13.546> <0.224, 0.675, -13.514> <0.243, 0.675, -13.459> 
		<0.124, 0.763, -13.645> <0.147, 0.763, -13.583> <0.263, 0.795, -13.525> <0.266, 0.798, -13.459> 
		<0.130, 0.829, -13.666> <0.153, 0.829, -13.603> <0.203, 0.826, -13.525> <0.206, 0.829, -13.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.249, 0.608, -13.459> <0.271, 0.608, -13.396> <0.293, 0.608, -13.268> <0.233, 0.608, -13.240> 
		<0.243, 0.675, -13.459> <0.264, 0.675, -13.396> <0.266, 0.726, -13.254> <0.207, 0.726, -13.226> 
		<0.266, 0.798, -13.459> <0.273, 0.807, -13.301> <0.197, 0.779, -13.184> <0.183, 0.791, -13.027> 
		<0.206, 0.829, -13.459> <0.213, 0.838, -13.301> <0.175, 0.857, -13.093> <0.162, 0.869, -12.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.073, 0.829, -13.797> <-0.022, 0.829, -13.795> <0.045, 0.829, -13.794> <0.095, 0.829, -13.792> 
		<-0.084, 0.829, -13.758> <-0.034, 0.829, -13.756> <0.055, 0.829, -13.756> <0.106, 0.829, -13.754> 
		<-0.099, 0.829, -13.705> <-0.027, 0.829, -13.705> <0.047, 0.829, -13.704> <0.119, 0.829, -13.704> 
		<-0.111, 0.829, -13.666> <-0.039, 0.829, -13.666> <0.058, 0.829, -13.666> <0.130, 0.829, -13.666> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.111, 0.829, -13.666> <-0.039, 0.829, -13.666> <0.058, 0.829, -13.666> <0.130, 0.829, -13.666> 
		<-0.133, 0.829, -13.603> <-0.061, 0.829, -13.603> <0.080, 0.829, -13.603> <0.153, 0.829, -13.603> 
		<-0.182, 0.826, -13.524> <-0.078, 0.879, -13.524> <0.098, 0.879, -13.525> <0.203, 0.826, -13.525> 
		<-0.185, 0.829, -13.459> <-0.081, 0.882, -13.459> <0.101, 0.882, -13.459> <0.206, 0.829, -13.459> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.185, 0.829, -13.459> <-0.081, 0.882, -13.459> <0.101, 0.882, -13.459> <0.206, 0.829, -13.459> 
		<-0.192, 0.838, -13.301> <-0.088, 0.891, -13.301> <0.108, 0.891, -13.301> <0.213, 0.838, -13.301> 
		<-0.156, 0.857, -13.093> <-0.064, 0.857, -13.093> <0.084, 0.857, -13.093> <0.175, 0.857, -13.093> 
		<-0.143, 0.869, -12.936> <-0.051, 0.869, -12.936> <0.070, 0.869, -12.936> <0.162, 0.869, -12.936> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.143, 0.869, -12.936> <-0.051, 0.869, -12.936> <0.070, 0.869, -12.936> <0.162, 0.869, -12.936> 
		<-0.164, 0.791, -13.027> <-0.073, 0.791, -13.027> <0.092, 0.791, -13.027> <0.183, 0.791, -13.027> 
		<-0.188, 0.726, -13.226> <-0.066, 0.726, -13.169> <0.085, 0.726, -13.169> <0.207, 0.726, -13.226> 
		<-0.214, 0.608, -13.240> <-0.093, 0.608, -13.183> <0.112, 0.608, -13.183> <0.233, 0.608, -13.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.214, 0.608, -13.240> <-0.093, 0.608, -13.183> <0.112, 0.608, -13.183> <0.233, 0.608, -13.240> 
		<-0.236, 0.513, -13.251> <-0.114, 0.513, -13.194> <0.133, 0.513, -13.194> <0.255, 0.513, -13.251> 
		<-0.242, 0.496, -12.991> <-0.128, 0.496, -12.885> <0.148, 0.496, -12.885> <0.261, 0.496, -12.991> 
		<-0.249, 0.398, -12.991> <-0.136, 0.398, -12.885> <0.155, 0.398, -12.885> <0.268, 0.398, -12.991> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.249, 0.398, -12.991> <-0.136, 0.398, -12.885> <0.155, 0.398, -12.885> <0.268, 0.398, -12.991> 
		<-0.256, 0.300, -12.991> <-0.143, 0.300, -12.885> <0.162, 0.300, -12.885> <0.275, 0.300, -12.991> 
		<-0.280, 0.277, -13.226> <-0.141, 0.277, -13.163> <0.160, 0.277, -13.163> <0.299, 0.277, -13.226> 
		<-0.245, 0.187, -13.240> <-0.106, 0.187, -13.176> <0.125, 0.187, -13.176> <0.264, 0.187, -13.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.245, 0.187, -13.240> <-0.106, 0.187, -13.176> <0.125, 0.187, -13.176> <0.264, 0.187, -13.240> 
		<-0.200, 0.071, -13.258> <-0.061, 0.071, -13.194> <0.080, 0.071, -13.194> <0.219, 0.071, -13.258> 
		<-0.122, -0.052, -13.118> <-0.102, -0.073, -13.107> <0.106, -0.049, -13.100> <0.121, -0.041, -13.124> 
		<-0.041, -0.138, -13.074> <-0.022, -0.159, -13.064> <0.045, -0.147, -13.050> <0.060, -0.138, -13.074> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment { Gold }
	finish { phong 0.9 }
	#end
}
// Layer 5   rudder
union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.404, 1.624, 13.194> <-1.404, 2.738, 12.704> <-1.404, 3.574, 12.336> 
		<-1.385, 0.780, 13.545> <-1.385, 1.616, 13.178> <-1.385, 2.731, 12.687> <-1.385, 3.567, 12.319> 
		<-1.361, 0.770, 13.523> <-1.361, 1.606, 13.155> <-1.361, 2.721, 12.665> <-1.361, 3.557, 12.297> 
		<-1.343, 0.763, 13.507> <-1.343, 1.599, 13.139> <-1.343, 2.714, 12.648> <-1.343, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.385, 0.780, 13.545> <-1.361, 0.770, 13.523> <-1.343, 0.763, 13.507> 
		<-1.422, 0.780, 13.545> <-1.404, 0.773, 13.529> <-1.379, 0.742, 13.536> <-1.361, 0.735, 13.519> 
		<-1.446, 0.770, 13.523> <-1.428, 0.742, 13.536> <-1.404, 0.725, 13.523> <-1.385, 0.697, 13.536> 
		<-1.464, 0.763, 13.507> <-1.446, 0.735, 13.519> <-1.422, 0.697, 13.536> <-1.404, 0.668, 13.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.404, 0.788, 13.562> <-1.404, 0.788, 13.562> <-1.404, 0.788, 13.562> 
		<-1.404, 0.752, 13.558> <-1.385, 0.744, 13.541> <-1.385, 0.744, 13.541> <-1.385, 0.780, 13.545> 
		<-1.404, 0.704, 13.553> <-1.385, 0.733, 13.540> <-1.379, 0.742, 13.536> <-1.361, 0.770, 13.523> 
		<-1.404, 0.668, 13.548> <-1.385, 0.697, 13.536> <-1.361, 0.735, 13.519> <-1.343, 0.763, 13.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.385, 0.780, 13.545> <-1.361, 0.770, 13.523> <-1.343, 0.763, 13.507> 
		<-1.404, 0.752, 13.558> <-1.385, 0.744, 13.541> <-1.379, 0.763, 13.507> <-1.361, 0.756, 13.490> 
		<-1.404, 0.704, 13.553> <-1.404, 0.725, 13.523> <-1.385, 0.725, 13.497> <-1.385, 0.746, 13.468> 
		<-1.404, 0.668, 13.548> <-1.404, 0.689, 13.519> <-1.404, 0.718, 13.480> <-1.404, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.422, 0.780, 13.545> <-1.446, 0.770, 13.523> <-1.464, 0.763, 13.507> 
		<-1.404, 0.752, 13.558> <-1.422, 0.744, 13.541> <-1.428, 0.763, 13.507> <-1.446, 0.756, 13.490> 
		<-1.404, 0.704, 13.553> <-1.404, 0.725, 13.523> <-1.422, 0.725, 13.497> <-1.422, 0.746, 13.468> 
		<-1.404, 0.668, 13.548> <-1.404, 0.689, 13.519> <-1.404, 0.718, 13.480> <-1.404, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.404, 0.788, 13.562> <-1.404, 0.788, 13.562> <-1.404, 0.788, 13.562> 
		<-1.404, 0.752, 13.558> <-1.422, 0.744, 13.541> <-1.422, 0.744, 13.541> <-1.422, 0.780, 13.545> 
		<-1.404, 0.704, 13.553> <-1.422, 0.733, 13.540> <-1.428, 0.742, 13.536> <-1.446, 0.770, 13.523> 
		<-1.404, 0.668, 13.548> <-1.422, 0.697, 13.536> <-1.446, 0.735, 13.519> <-1.464, 0.763, 13.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.788, 13.562> <-1.422, 0.780, 13.545> <-1.446, 0.770, 13.523> <-1.464, 0.763, 13.507> 
		<-1.404, 1.624, 13.194> <-1.422, 1.616, 13.178> <-1.446, 1.606, 13.155> <-1.464, 1.599, 13.139> 
		<-1.404, 2.738, 12.704> <-1.422, 2.731, 12.687> <-1.446, 2.721, 12.665> <-1.464, 2.714, 12.648> 
		<-1.404, 3.574, 12.336> <-1.422, 3.567, 12.319> <-1.446, 3.557, 12.297> <-1.464, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.464, 3.550, 12.280> <-1.446, 3.566, 12.273> <-1.429, 3.605, 12.256> <-1.404, 3.605, 12.256> 
		<-1.446, 3.557, 12.297> <-1.428, 3.574, 12.289> <-1.404, 3.605, 12.256> <-1.378, 3.605, 12.256> 
		<-1.422, 3.567, 12.319> <-1.404, 3.559, 12.302> <-1.379, 3.574, 12.289> <-1.361, 3.566, 12.273> 
		<-1.404, 3.574, 12.336> <-1.385, 3.567, 12.319> <-1.361, 3.557, 12.297> <-1.343, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.464, 3.550, 12.280> <-1.446, 3.542, 12.263> <-1.422, 3.533, 12.241> <-1.404, 3.525, 12.225> 
		<-1.446, 3.557, 12.297> <-1.428, 3.550, 12.280> <-1.422, 3.557, 12.251> <-1.404, 3.549, 12.234> 
		<-1.422, 3.567, 12.319> <-1.422, 3.576, 12.295> <-1.404, 3.605, 12.256> <-1.404, 3.595, 12.232> 
		<-1.404, 3.574, 12.336> <-1.404, 3.583, 12.312> <-1.404, 3.616, 12.279> <-1.404, 3.605, 12.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.464, 3.550, 12.280> <-1.464, 3.550, 12.280> <-1.464, 3.550, 12.280> <-1.464, 3.550, 12.280> 
		<-1.446, 3.566, 12.273> <-1.428, 3.574, 12.289> <-1.428, 3.574, 12.289> <-1.446, 3.557, 12.297> 
		<-1.429, 3.605, 12.256> <-1.429, 3.616, 12.279> <-1.422, 3.576, 12.295> <-1.422, 3.567, 12.319> 
		<-1.404, 3.605, 12.256> <-1.404, 3.616, 12.279> <-1.404, 3.583, 12.312> <-1.404, 3.574, 12.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.464, 3.550, 12.280> <-1.446, 3.542, 12.263> <-1.422, 3.533, 12.241> <-1.404, 3.525, 12.225> 
		<-1.446, 3.566, 12.273> <-1.428, 3.559, 12.256> <-1.404, 3.540, 12.258> <-1.385, 3.533, 12.241> 
		<-1.429, 3.605, 12.256> <-1.404, 3.605, 12.256> <-1.379, 3.559, 12.256> <-1.361, 3.542, 12.263> 
		<-1.404, 3.605, 12.256> <-1.378, 3.605, 12.256> <-1.361, 3.566, 12.273> <-1.343, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.464, 3.550, 12.280> <-1.464, 3.550, 12.280> <-1.464, 3.550, 12.280> <-1.464, 3.550, 12.280> 
		<-1.446, 3.566, 12.273> <-1.428, 3.559, 12.256> <-1.428, 3.559, 12.256> <-1.446, 3.542, 12.263> 
		<-1.429, 3.605, 12.256> <-1.429, 3.595, 12.232> <-1.422, 3.557, 12.251> <-1.422, 3.533, 12.241> 
		<-1.404, 3.605, 12.256> <-1.404, 3.595, 12.232> <-1.404, 3.549, 12.234> <-1.404, 3.525, 12.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.464, 3.550, 12.280> <-1.446, 3.542, 12.263> <-1.422, 3.533, 12.241> <-1.404, 3.525, 12.225> 
		<-1.464, 2.714, 12.648> <-1.446, 2.706, 12.631> <-1.422, 2.697, 12.609> <-1.404, 2.689, 12.592> 
		<-1.464, 1.599, 13.139> <-1.446, 1.592, 13.122> <-1.422, 1.582, 13.100> <-1.404, 1.575, 13.083> 
		<-1.464, 0.763, 13.507> <-1.446, 0.756, 13.490> <-1.422, 0.746, 13.468> <-1.404, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 3.574, 12.336> <-1.385, 3.567, 12.319> <-1.361, 3.557, 12.297> <-1.343, 3.550, 12.280> 
		<-1.404, 3.583, 12.312> <-1.385, 3.576, 12.295> <-1.379, 3.550, 12.280> <-1.361, 3.542, 12.263> 
		<-1.404, 3.616, 12.279> <-1.404, 3.605, 12.256> <-1.385, 3.557, 12.251> <-1.385, 3.533, 12.241> 
		<-1.404, 3.605, 12.256> <-1.404, 3.595, 12.232> <-1.404, 3.549, 12.234> <-1.404, 3.525, 12.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 3.574, 12.336> <-1.404, 3.574, 12.336> <-1.404, 3.574, 12.336> <-1.404, 3.574, 12.336> 
		<-1.404, 3.583, 12.312> <-1.385, 3.576, 12.295> <-1.385, 3.576, 12.295> <-1.385, 3.567, 12.319> 
		<-1.404, 3.616, 12.279> <-1.378, 3.616, 12.279> <-1.379, 3.574, 12.289> <-1.361, 3.557, 12.297> 
		<-1.404, 3.605, 12.256> <-1.378, 3.605, 12.256> <-1.361, 3.566, 12.273> <-1.343, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 3.605, 12.256> <-1.404, 3.605, 12.256> <-1.404, 3.605, 12.256> <-1.404, 3.605, 12.256> 
		<-1.378, 3.605, 12.256> <-1.378, 3.595, 12.232> <-1.378, 3.595, 12.232> <-1.404, 3.595, 12.232> 
		<-1.361, 3.566, 12.273> <-1.379, 3.559, 12.256> <-1.385, 3.557, 12.251> <-1.404, 3.549, 12.234> 
		<-1.343, 3.550, 12.280> <-1.361, 3.542, 12.263> <-1.385, 3.533, 12.241> <-1.404, 3.525, 12.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.343, 3.550, 12.280> <-1.361, 3.542, 12.263> <-1.385, 3.533, 12.241> <-1.404, 3.525, 12.225> 
		<-1.343, 2.714, 12.648> <-1.361, 2.706, 12.631> <-1.385, 2.697, 12.609> <-1.404, 2.689, 12.592> 
		<-1.343, 1.599, 13.139> <-1.361, 1.592, 13.122> <-1.385, 1.582, 13.100> <-1.404, 1.575, 13.083> 
		<-1.343, 0.763, 13.507> <-1.361, 0.756, 13.490> <-1.385, 0.746, 13.468> <-1.404, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.396, 3.402, 12.345> <-1.155, 3.402, 12.345> <-0.834, 3.402, 12.345> <-0.593, 3.402, 12.345> 
		<-1.396, 3.409, 12.361> <-1.155, 3.409, 12.361> <-0.834, 3.409, 12.361> <-0.593, 3.409, 12.361> 
		<-1.396, 3.397, 12.392> <-1.155, 3.397, 12.392> <-0.835, 3.397, 12.392> <-0.594, 3.397, 12.392> 
		<-1.396, 3.381, 12.399> <-1.155, 3.381, 12.399> <-0.834, 3.381, 12.399> <-0.593, 3.381, 12.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.396, 3.402, 12.345> <-1.396, 3.395, 12.329> <-1.396, 3.364, 12.317> <-1.396, 3.349, 12.324> 
		<-1.155, 3.402, 12.345> <-1.155, 3.395, 12.329> <-1.155, 3.364, 12.317> <-1.155, 3.349, 12.324> 
		<-0.834, 3.402, 12.345> <-0.834, 3.395, 12.329> <-0.834, 3.365, 12.330> <-0.834, 3.349, 12.324> 
		<-0.593, 3.402, 12.345> <-0.593, 3.395, 12.329> <-0.593, 3.365, 12.330> <-0.593, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.396, 3.349, 12.324> <-1.396, 3.333, 12.331> <-1.396, 3.321, 12.362> <-1.396, 3.328, 12.378> 
		<-1.155, 3.349, 12.324> <-1.155, 3.333, 12.331> <-1.155, 3.321, 12.362> <-1.155, 3.328, 12.378> 
		<-0.834, 3.349, 12.324> <-0.834, 3.342, 12.340> <-0.833, 3.321, 12.362> <-0.833, 3.328, 12.378> 
		<-0.593, 3.349, 12.324> <-0.593, 3.342, 12.340> <-0.591, 3.321, 12.362> <-0.591, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.396, 3.328, 12.378> <-1.396, 3.335, 12.394> <-1.396, 3.366, 12.406> <-1.396, 3.381, 12.399> 
		<-1.155, 3.328, 12.378> <-1.155, 3.335, 12.394> <-1.155, 3.366, 12.406> <-1.155, 3.381, 12.399> 
		<-0.833, 3.328, 12.378> <-0.833, 3.335, 12.394> <-0.834, 3.366, 12.406> <-0.834, 3.381, 12.399> 
		<-0.591, 3.328, 12.378> <-0.591, 3.335, 12.394> <-0.593, 3.366, 12.406> <-0.593, 3.381, 12.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.402, 12.345> <-0.581, 3.391, 12.350> <-0.553, 3.381, 12.354> <-0.553, 3.365, 12.361> 
		<-0.593, 3.409, 12.361> <-0.581, 3.398, 12.366> <-0.553, 3.365, 12.361> <-0.552, 3.350, 12.368> 
		<-0.594, 3.397, 12.392> <-0.593, 3.381, 12.399> <-0.580, 3.346, 12.389> <-0.580, 3.339, 12.373> 
		<-0.593, 3.381, 12.399> <-0.593, 3.366, 12.406> <-0.591, 3.335, 12.394> <-0.591, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.402, 12.345> <-0.593, 3.402, 12.345> <-0.593, 3.402, 12.345> <-0.593, 3.402, 12.345> 
		<-0.581, 3.391, 12.350> <-0.581, 3.398, 12.366> <-0.581, 3.398, 12.366> <-0.593, 3.409, 12.361> 
		<-0.553, 3.381, 12.354> <-0.553, 3.388, 12.370> <-0.582, 3.392, 12.380> <-0.594, 3.397, 12.392> 
		<-0.553, 3.365, 12.361> <-0.553, 3.372, 12.377> <-0.581, 3.376, 12.387> <-0.593, 3.381, 12.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.402, 12.345> <-0.593, 3.395, 12.329> <-0.593, 3.365, 12.330> <-0.593, 3.349, 12.324> 
		<-0.593, 3.409, 12.361> <-0.593, 3.402, 12.345> <-0.581, 3.370, 12.341> <-0.581, 3.354, 12.335> 
		<-0.594, 3.397, 12.392> <-0.582, 3.392, 12.380> <-0.553, 3.365, 12.361> <-0.553, 3.358, 12.346> 
		<-0.593, 3.381, 12.399> <-0.581, 3.376, 12.387> <-0.553, 3.372, 12.377> <-0.553, 3.365, 12.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.402, 12.345> <-0.593, 3.395, 12.329> <-0.593, 3.365, 12.330> <-0.593, 3.349, 12.324> 
		<-0.581, 3.391, 12.350> <-0.581, 3.384, 12.334> <-0.593, 3.358, 12.346> <-0.593, 3.342, 12.340> 
		<-0.553, 3.381, 12.354> <-0.553, 3.365, 12.361> <-0.580, 3.332, 12.357> <-0.591, 3.321, 12.362> 
		<-0.553, 3.365, 12.361> <-0.552, 3.350, 12.368> <-0.580, 3.339, 12.373> <-0.591, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.402, 12.345> <-0.593, 3.402, 12.345> <-0.593, 3.402, 12.345> <-0.593, 3.402, 12.345> 
		<-0.581, 3.391, 12.350> <-0.581, 3.384, 12.334> <-0.581, 3.384, 12.334> <-0.593, 3.395, 12.329> 
		<-0.553, 3.381, 12.354> <-0.553, 3.374, 12.339> <-0.581, 3.370, 12.341> <-0.593, 3.365, 12.330> 
		<-0.553, 3.365, 12.361> <-0.553, 3.358, 12.346> <-0.581, 3.354, 12.335> <-0.593, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.381, 12.399> <-0.593, 3.366, 12.406> <-0.591, 3.335, 12.394> <-0.591, 3.328, 12.378> 
		<-0.581, 3.376, 12.387> <-0.581, 3.361, 12.394> <-0.591, 3.328, 12.378> <-0.591, 3.321, 12.362> 
		<-0.553, 3.372, 12.377> <-0.553, 3.365, 12.361> <-0.581, 3.347, 12.351> <-0.593, 3.342, 12.340> 
		<-0.553, 3.365, 12.361> <-0.553, 3.358, 12.346> <-0.581, 3.354, 12.335> <-0.593, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.593, 3.381, 12.399> <-0.593, 3.381, 12.399> <-0.593, 3.381, 12.399> <-0.593, 3.381, 12.399> 
		<-0.581, 3.376, 12.387> <-0.581, 3.361, 12.394> <-0.581, 3.361, 12.394> <-0.593, 3.366, 12.406> 
		<-0.553, 3.372, 12.377> <-0.552, 3.357, 12.384> <-0.580, 3.346, 12.389> <-0.591, 3.335, 12.394> 
		<-0.553, 3.365, 12.361> <-0.552, 3.350, 12.368> <-0.580, 3.339, 12.373> <-0.591, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.553, 3.365, 12.361> <-0.553, 3.365, 12.361> <-0.553, 3.365, 12.361> <-0.553, 3.365, 12.361> 
		<-0.552, 3.350, 12.368> <-0.552, 3.343, 12.352> <-0.552, 3.343, 12.352> <-0.553, 3.358, 12.346> 
		<-0.580, 3.339, 12.373> <-0.580, 3.332, 12.357> <-0.581, 3.347, 12.351> <-0.581, 3.354, 12.335> 
		<-0.591, 3.328, 12.378> <-0.591, 3.321, 12.362> <-0.593, 3.342, 12.340> <-0.593, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.739, 13.451> <-1.404, 0.739, 13.451> <-1.404, 0.739, 13.451> <-1.404, 0.739, 13.451> 
		<-1.385, 0.746, 13.468> <-1.385, 0.725, 13.497> <-1.385, 0.725, 13.497> <-1.404, 0.718, 13.480> 
		<-1.361, 0.756, 13.490> <-1.379, 0.727, 13.502> <-1.385, 0.718, 13.507> <-1.404, 0.689, 13.519> 
		<-1.343, 0.763, 13.507> <-1.361, 0.735, 13.519> <-1.385, 0.697, 13.536> <-1.404, 0.668, 13.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.739, 13.451> <-1.404, 0.739, 13.451> <-1.404, 0.739, 13.451> <-1.404, 0.739, 13.451> 
		<-1.404, 0.718, 13.480> <-1.422, 0.725, 13.497> <-1.422, 0.725, 13.497> <-1.422, 0.746, 13.468> 
		<-1.404, 0.689, 13.519> <-1.422, 0.718, 13.507> <-1.428, 0.727, 13.502> <-1.446, 0.756, 13.490> 
		<-1.404, 0.668, 13.548> <-1.422, 0.697, 13.536> <-1.446, 0.735, 13.519> <-1.464, 0.763, 13.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.404, 0.739, 13.451> <-1.422, 0.746, 13.468> <-1.446, 0.756, 13.490> <-1.464, 0.763, 13.507> 
		<-1.385, 0.746, 13.468> <-1.404, 0.753, 13.484> <-1.428, 0.727, 13.502> <-1.446, 0.735, 13.519> 
		<-1.361, 0.756, 13.490> <-1.379, 0.727, 13.502> <-1.404, 0.725, 13.523> <-1.422, 0.697, 13.536> 
		<-1.343, 0.763, 13.507> <-1.361, 0.735, 13.519> <-1.385, 0.697, 13.536> <-1.404, 0.668, 13.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 0.258, 13.679> <-1.363, 0.241, 13.630> <-1.404, 0.240, 13.566> <-1.404, 0.231, 13.515> 
		<-1.364, 0.936, 13.353> <-1.364, 0.919, 13.305> <-1.404, 0.798, 13.321> <-1.404, 0.790, 13.271> 
		<-1.395, 1.870, 12.984> <-1.393, 1.716, 12.960> <-1.405, 1.658, 12.903> <-1.404, 1.504, 12.879> 
		<-1.408, 2.561, 12.686> <-1.407, 2.407, 12.662> <-1.405, 2.203, 12.630> <-1.404, 2.050, 12.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 0.258, 13.679> <-1.364, 0.936, 13.353> <-1.395, 1.870, 12.984> <-1.408, 2.561, 12.686> 
		<-1.363, 0.287, 13.763> <-1.364, 0.966, 13.438> <-1.393, 1.720, 13.159> <-1.407, 2.411, 12.861> 
		<-1.404, 0.345, 13.866> <-1.404, 0.833, 13.627> <-1.405, 1.708, 13.297> <-1.405, 2.211, 13.094> 
		<-1.404, 0.383, 13.947> <-1.404, 0.871, 13.708> <-1.404, 1.558, 13.472> <-1.404, 2.062, 13.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 0.258, 13.679> <-1.363, 0.287, 13.763> <-1.404, 0.345, 13.866> <-1.404, 0.383, 13.947> 
		<-1.363, -0.033, 13.818> <-1.363, -0.003, 13.903> <-1.404, -0.025, 14.046> <-1.404, 0.012, 14.128> 
		<-1.404, -0.386, 14.066> <-1.404, -0.383, 14.200> <-1.404, -0.400, 14.318> <-1.404, -0.438, 14.448> 
		<-1.404, -0.662, 14.232> <-1.404, -0.659, 14.367> <-1.404, -0.751, 14.533> <-1.404, -0.789, 14.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 0.258, 13.679> <-1.363, -0.033, 13.818> <-1.404, -0.386, 14.066> <-1.404, -0.662, 14.232> 
		<-1.363, 0.241, 13.630> <-1.363, -0.050, 13.770> <-1.404, -0.388, 13.945> <-1.404, -0.664, 14.111> 
		<-1.404, 0.240, 13.566> <-1.404, -0.060, 13.697> <-1.404, -0.451, 13.866> <-1.404, -0.762, 13.968> 
		<-1.404, 0.231, 13.515> <-1.404, -0.068, 13.646> <-1.404, -0.494, 13.753> <-1.404, -0.805, 13.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, -0.789, 14.662> <-1.375, -0.789, 14.662> <-1.392, -0.789, 14.662> <-1.404, -0.789, 14.662> 
		<-1.363, -0.438, 14.448> <-1.375, -0.438, 14.448> <-1.392, -0.438, 14.448> <-1.404, -0.438, 14.448> 
		<-1.363, 0.012, 14.128> <-1.375, 0.012, 14.128> <-1.404, 0.018, 14.139> <-1.404, 0.012, 14.128> 
		<-1.363, 0.383, 13.947> <-1.375, 0.383, 13.947> <-1.404, 0.388, 13.958> <-1.404, 0.383, 13.947> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, -0.789, 14.662> <-1.363, -0.751, 14.533> <-1.363, -0.659, 14.367> <-1.363, -0.662, 14.232> 
		<-1.375, -0.789, 14.662> <-1.375, -0.751, 14.533> <-1.375, -0.659, 14.367> <-1.375, -0.662, 14.232> 
		<-1.392, -0.789, 14.662> <-1.392, -0.751, 14.533> <-1.404, -0.670, 14.373> <-1.404, -0.672, 14.238> 
		<-1.404, -0.789, 14.662> <-1.404, -0.751, 14.533> <-1.404, -0.659, 14.367> <-1.404, -0.662, 14.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, -0.662, 14.232> <-1.363, -0.664, 14.111> <-1.363, -0.762, 13.968> <-1.363, -0.805, 13.855> 
		<-1.375, -0.662, 14.232> <-1.375, -0.664, 14.111> <-1.375, -0.762, 13.968> <-1.375, -0.805, 13.855> 
		<-1.404, -0.672, 14.238> <-1.404, -0.674, 14.117> <-1.392, -0.762, 13.968> <-1.392, -0.805, 13.855> 
		<-1.404, -0.662, 14.232> <-1.404, -0.664, 14.111> <-1.404, -0.762, 13.968> <-1.404, -0.805, 13.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, -0.805, 13.855> <-1.363, -0.494, 13.753> <-1.363, -0.068, 13.646> <-1.363, 0.231, 13.515> 
		<-1.375, -0.805, 13.855> <-1.375, -0.494, 13.753> <-1.375, -0.068, 13.646> <-1.375, 0.231, 13.515> 
		<-1.392, -0.805, 13.855> <-1.392, -0.494, 13.753> <-1.404, -0.070, 13.634> <-1.404, 0.229, 13.503> 
		<-1.404, -0.805, 13.855> <-1.404, -0.494, 13.753> <-1.404, -0.068, 13.646> <-1.404, 0.231, 13.515> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 0.231, 13.515> <-1.363, 0.790, 13.271> <-1.363, 1.504, 12.879> <-1.363, 2.050, 12.606> 
		<-1.375, 0.231, 13.515> <-1.375, 0.790, 13.271> <-1.375, 1.504, 12.879> <-1.375, 2.050, 12.606> 
		<-1.404, 0.229, 13.503> <-1.404, 0.788, 13.259> <-1.392, 1.504, 12.879> <-1.392, 2.050, 12.606> 
		<-1.404, 0.231, 13.515> <-1.404, 0.790, 13.271> <-1.404, 1.504, 12.879> <-1.404, 2.050, 12.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 2.050, 12.606> <-1.365, 2.203, 12.630> <-1.366, 2.407, 12.662> <-1.368, 2.561, 12.686> 
		<-1.375, 2.050, 12.606> <-1.377, 2.203, 12.630> <-1.378, 2.407, 12.662> <-1.380, 2.561, 12.686> 
		<-1.392, 2.050, 12.606> <-1.393, 2.203, 12.630> <-1.395, 2.407, 12.662> <-1.396, 2.561, 12.686> 
		<-1.404, 2.050, 12.606> <-1.405, 2.203, 12.630> <-1.407, 2.407, 12.662> <-1.408, 2.561, 12.686> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.368, 2.561, 12.686> <-1.366, 2.411, 12.861> <-1.365, 2.211, 13.094> <-1.363, 2.062, 13.269> 
		<-1.380, 2.561, 12.686> <-1.378, 2.411, 12.861> <-1.377, 2.211, 13.094> <-1.375, 2.062, 13.269> 
		<-1.396, 2.561, 12.686> <-1.395, 2.411, 12.861> <-1.393, 2.211, 13.094> <-1.392, 2.062, 13.269> 
		<-1.408, 2.561, 12.686> <-1.407, 2.411, 12.861> <-1.405, 2.211, 13.094> <-1.404, 2.062, 13.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.363, 2.062, 13.269> <-1.363, 1.558, 13.472> <-1.363, 0.871, 13.708> <-1.363, 0.383, 13.947> 
		<-1.375, 2.062, 13.269> <-1.375, 1.558, 13.472> <-1.375, 0.871, 13.708> <-1.375, 0.383, 13.947> 
		<-1.392, 2.062, 13.269> <-1.392, 1.558, 13.472> <-1.404, 0.876, 13.719> <-1.404, 0.388, 13.958> 
		<-1.404, 2.062, 13.269> <-1.404, 1.558, 13.472> <-1.404, 0.871, 13.708> <-1.404, 0.383, 13.947> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.423, 1.624, 13.194> <1.423, 2.738, 12.704> <1.423, 3.574, 12.336> 
		<1.405, 0.780, 13.545> <1.405, 1.616, 13.178> <1.405, 2.731, 12.687> <1.405, 3.567, 12.319> 
		<1.381, 0.770, 13.523> <1.381, 1.606, 13.155> <1.381, 2.721, 12.665> <1.381, 3.557, 12.297> 
		<1.363, 0.763, 13.507> <1.363, 1.599, 13.139> <1.363, 2.714, 12.648> <1.363, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.405, 0.780, 13.545> <1.381, 0.770, 13.523> <1.363, 0.763, 13.507> 
		<1.442, 0.780, 13.545> <1.423, 0.773, 13.529> <1.399, 0.742, 13.536> <1.381, 0.735, 13.519> 
		<1.466, 0.770, 13.523> <1.448, 0.742, 13.536> <1.423, 0.725, 13.523> <1.405, 0.697, 13.536> 
		<1.484, 0.763, 13.507> <1.466, 0.735, 13.519> <1.442, 0.697, 13.536> <1.423, 0.668, 13.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.423, 0.788, 13.562> <1.423, 0.788, 13.562> <1.423, 0.788, 13.562> 
		<1.423, 0.752, 13.558> <1.405, 0.744, 13.541> <1.405, 0.744, 13.541> <1.405, 0.780, 13.545> 
		<1.423, 0.704, 13.553> <1.405, 0.733, 13.540> <1.399, 0.742, 13.536> <1.381, 0.770, 13.523> 
		<1.423, 0.668, 13.548> <1.405, 0.697, 13.536> <1.381, 0.735, 13.519> <1.363, 0.763, 13.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.405, 0.780, 13.545> <1.381, 0.770, 13.523> <1.363, 0.763, 13.507> 
		<1.423, 0.752, 13.558> <1.405, 0.744, 13.541> <1.399, 0.763, 13.507> <1.381, 0.756, 13.490> 
		<1.423, 0.704, 13.553> <1.423, 0.725, 13.523> <1.405, 0.725, 13.497> <1.405, 0.746, 13.468> 
		<1.423, 0.668, 13.548> <1.423, 0.689, 13.519> <1.423, 0.718, 13.480> <1.423, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.442, 0.780, 13.545> <1.466, 0.770, 13.523> <1.484, 0.763, 13.507> 
		<1.423, 0.752, 13.558> <1.442, 0.744, 13.541> <1.448, 0.763, 13.507> <1.466, 0.756, 13.490> 
		<1.423, 0.704, 13.553> <1.423, 0.725, 13.523> <1.442, 0.725, 13.497> <1.442, 0.746, 13.468> 
		<1.423, 0.668, 13.548> <1.423, 0.689, 13.519> <1.423, 0.718, 13.480> <1.423, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.423, 0.788, 13.562> <1.423, 0.788, 13.562> <1.423, 0.788, 13.562> 
		<1.423, 0.752, 13.558> <1.442, 0.744, 13.541> <1.442, 0.744, 13.541> <1.442, 0.780, 13.545> 
		<1.423, 0.704, 13.553> <1.442, 0.733, 13.540> <1.448, 0.742, 13.536> <1.466, 0.770, 13.523> 
		<1.423, 0.668, 13.548> <1.442, 0.697, 13.536> <1.466, 0.735, 13.519> <1.484, 0.763, 13.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.788, 13.562> <1.442, 0.780, 13.545> <1.466, 0.770, 13.523> <1.484, 0.763, 13.507> 
		<1.423, 1.624, 13.194> <1.442, 1.616, 13.178> <1.466, 1.606, 13.155> <1.484, 1.599, 13.139> 
		<1.423, 2.738, 12.704> <1.442, 2.731, 12.687> <1.466, 2.721, 12.665> <1.484, 2.714, 12.648> 
		<1.423, 3.574, 12.336> <1.442, 3.567, 12.319> <1.466, 3.557, 12.297> <1.484, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.484, 3.550, 12.280> <1.466, 3.566, 12.273> <1.449, 3.605, 12.256> <1.423, 3.605, 12.256> 
		<1.466, 3.557, 12.297> <1.448, 3.574, 12.289> <1.423, 3.605, 12.256> <1.398, 3.605, 12.256> 
		<1.442, 3.567, 12.319> <1.423, 3.559, 12.302> <1.399, 3.574, 12.289> <1.381, 3.566, 12.273> 
		<1.423, 3.574, 12.336> <1.405, 3.567, 12.319> <1.381, 3.557, 12.297> <1.363, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.484, 3.550, 12.280> <1.466, 3.542, 12.263> <1.442, 3.533, 12.241> <1.423, 3.525, 12.225> 
		<1.466, 3.557, 12.297> <1.448, 3.550, 12.280> <1.442, 3.557, 12.251> <1.423, 3.549, 12.234> 
		<1.442, 3.567, 12.319> <1.442, 3.576, 12.295> <1.423, 3.605, 12.256> <1.423, 3.595, 12.232> 
		<1.423, 3.574, 12.336> <1.423, 3.583, 12.312> <1.423, 3.616, 12.279> <1.423, 3.605, 12.256> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.484, 3.550, 12.280> <1.484, 3.550, 12.280> <1.484, 3.550, 12.280> <1.484, 3.550, 12.280> 
		<1.466, 3.566, 12.273> <1.448, 3.574, 12.289> <1.448, 3.574, 12.289> <1.466, 3.557, 12.297> 
		<1.449, 3.605, 12.256> <1.449, 3.616, 12.279> <1.442, 3.576, 12.295> <1.442, 3.567, 12.319> 
		<1.423, 3.605, 12.256> <1.423, 3.616, 12.279> <1.423, 3.583, 12.312> <1.423, 3.574, 12.336> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.484, 3.550, 12.280> <1.466, 3.542, 12.263> <1.442, 3.533, 12.241> <1.423, 3.525, 12.225> 
		<1.466, 3.566, 12.273> <1.448, 3.559, 12.256> <1.423, 3.540, 12.258> <1.405, 3.533, 12.241> 
		<1.449, 3.605, 12.256> <1.423, 3.605, 12.256> <1.399, 3.559, 12.256> <1.381, 3.542, 12.263> 
		<1.423, 3.605, 12.256> <1.398, 3.605, 12.256> <1.381, 3.566, 12.273> <1.363, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.484, 3.550, 12.280> <1.484, 3.550, 12.280> <1.484, 3.550, 12.280> <1.484, 3.550, 12.280> 
		<1.466, 3.566, 12.273> <1.448, 3.559, 12.256> <1.448, 3.559, 12.256> <1.466, 3.542, 12.263> 
		<1.449, 3.605, 12.256> <1.449, 3.595, 12.232> <1.442, 3.557, 12.251> <1.442, 3.533, 12.241> 
		<1.423, 3.605, 12.256> <1.423, 3.595, 12.232> <1.423, 3.549, 12.234> <1.423, 3.525, 12.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.484, 3.550, 12.280> <1.466, 3.542, 12.263> <1.442, 3.533, 12.241> <1.423, 3.525, 12.225> 
		<1.484, 2.714, 12.648> <1.466, 2.706, 12.631> <1.442, 2.697, 12.609> <1.423, 2.689, 12.592> 
		<1.484, 1.599, 13.139> <1.466, 1.592, 13.122> <1.442, 1.582, 13.100> <1.423, 1.575, 13.083> 
		<1.484, 0.763, 13.507> <1.466, 0.756, 13.490> <1.442, 0.746, 13.468> <1.423, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 3.574, 12.336> <1.405, 3.567, 12.319> <1.381, 3.557, 12.297> <1.363, 3.550, 12.280> 
		<1.423, 3.583, 12.312> <1.405, 3.576, 12.295> <1.399, 3.550, 12.280> <1.381, 3.542, 12.263> 
		<1.423, 3.616, 12.279> <1.423, 3.605, 12.256> <1.405, 3.557, 12.251> <1.405, 3.533, 12.241> 
		<1.423, 3.605, 12.256> <1.423, 3.595, 12.232> <1.423, 3.549, 12.234> <1.423, 3.525, 12.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 3.574, 12.336> <1.423, 3.574, 12.336> <1.423, 3.574, 12.336> <1.423, 3.574, 12.336> 
		<1.423, 3.583, 12.312> <1.405, 3.576, 12.295> <1.405, 3.576, 12.295> <1.405, 3.567, 12.319> 
		<1.423, 3.616, 12.279> <1.398, 3.616, 12.279> <1.399, 3.574, 12.289> <1.381, 3.557, 12.297> 
		<1.423, 3.605, 12.256> <1.398, 3.605, 12.256> <1.381, 3.566, 12.273> <1.363, 3.550, 12.280> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 3.605, 12.256> <1.423, 3.605, 12.256> <1.423, 3.605, 12.256> <1.423, 3.605, 12.256> 
		<1.398, 3.605, 12.256> <1.398, 3.595, 12.232> <1.398, 3.595, 12.232> <1.423, 3.595, 12.232> 
		<1.381, 3.566, 12.273> <1.399, 3.559, 12.256> <1.405, 3.557, 12.251> <1.423, 3.549, 12.234> 
		<1.363, 3.550, 12.280> <1.381, 3.542, 12.263> <1.405, 3.533, 12.241> <1.423, 3.525, 12.225> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.363, 3.550, 12.280> <1.381, 3.542, 12.263> <1.405, 3.533, 12.241> <1.423, 3.525, 12.225> 
		<1.363, 2.714, 12.648> <1.381, 2.706, 12.631> <1.405, 2.697, 12.609> <1.423, 2.689, 12.592> 
		<1.363, 1.599, 13.139> <1.381, 1.592, 13.122> <1.405, 1.582, 13.100> <1.423, 1.575, 13.083> 
		<1.363, 0.763, 13.507> <1.381, 0.756, 13.490> <1.405, 0.746, 13.468> <1.423, 0.739, 13.451> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.416, 3.402, 12.345> <1.175, 3.402, 12.345> <0.854, 3.402, 12.345> <0.613, 3.402, 12.345> 
		<1.416, 3.409, 12.361> <1.175, 3.409, 12.361> <0.854, 3.409, 12.361> <0.613, 3.409, 12.361> 
		<1.416, 3.397, 12.392> <1.175, 3.397, 12.392> <0.854, 3.397, 12.392> <0.614, 3.397, 12.392> 
		<1.416, 3.381, 12.399> <1.175, 3.381, 12.399> <0.854, 3.381, 12.399> <0.613, 3.381, 12.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.416, 3.402, 12.345> <1.416, 3.395, 12.329> <1.416, 3.364, 12.317> <1.416, 3.349, 12.324> 
		<1.175, 3.402, 12.345> <1.175, 3.395, 12.329> <1.175, 3.364, 12.317> <1.175, 3.349, 12.324> 
		<0.854, 3.402, 12.345> <0.854, 3.395, 12.329> <0.854, 3.365, 12.330> <0.854, 3.349, 12.324> 
		<0.613, 3.402, 12.345> <0.613, 3.395, 12.329> <0.613, 3.365, 12.330> <0.613, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.416, 3.349, 12.324> <1.416, 3.333, 12.331> <1.416, 3.321, 12.362> <1.416, 3.328, 12.378> 
		<1.175, 3.349, 12.324> <1.175, 3.333, 12.331> <1.175, 3.321, 12.362> <1.175, 3.328, 12.378> 
		<0.854, 3.349, 12.324> <0.853, 3.342, 12.340> <0.853, 3.321, 12.362> <0.853, 3.328, 12.378> 
		<0.613, 3.349, 12.324> <0.613, 3.342, 12.340> <0.611, 3.321, 12.362> <0.611, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.416, 3.328, 12.378> <1.416, 3.335, 12.394> <1.416, 3.366, 12.406> <1.416, 3.381, 12.399> 
		<1.175, 3.328, 12.378> <1.175, 3.335, 12.394> <1.175, 3.366, 12.406> <1.175, 3.381, 12.399> 
		<0.853, 3.328, 12.378> <0.853, 3.335, 12.394> <0.854, 3.366, 12.406> <0.854, 3.381, 12.399> 
		<0.611, 3.328, 12.378> <0.611, 3.335, 12.394> <0.613, 3.366, 12.406> <0.613, 3.381, 12.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.402, 12.345> <0.601, 3.391, 12.350> <0.573, 3.381, 12.354> <0.572, 3.365, 12.361> 
		<0.613, 3.409, 12.361> <0.601, 3.398, 12.366> <0.572, 3.365, 12.361> <0.572, 3.350, 12.368> 
		<0.614, 3.397, 12.392> <0.613, 3.381, 12.399> <0.600, 3.346, 12.389> <0.600, 3.339, 12.373> 
		<0.613, 3.381, 12.399> <0.613, 3.366, 12.406> <0.611, 3.335, 12.394> <0.611, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.402, 12.345> <0.613, 3.402, 12.345> <0.613, 3.402, 12.345> <0.613, 3.402, 12.345> 
		<0.601, 3.391, 12.350> <0.601, 3.398, 12.366> <0.601, 3.398, 12.366> <0.613, 3.409, 12.361> 
		<0.573, 3.381, 12.354> <0.573, 3.388, 12.370> <0.601, 3.392, 12.380> <0.614, 3.397, 12.392> 
		<0.572, 3.365, 12.361> <0.572, 3.372, 12.377> <0.601, 3.376, 12.387> <0.613, 3.381, 12.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.402, 12.345> <0.613, 3.395, 12.329> <0.613, 3.365, 12.330> <0.613, 3.349, 12.324> 
		<0.613, 3.409, 12.361> <0.613, 3.402, 12.345> <0.601, 3.370, 12.341> <0.601, 3.354, 12.335> 
		<0.614, 3.397, 12.392> <0.601, 3.392, 12.380> <0.572, 3.365, 12.361> <0.572, 3.358, 12.346> 
		<0.613, 3.381, 12.399> <0.601, 3.376, 12.387> <0.572, 3.372, 12.377> <0.572, 3.365, 12.361> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.402, 12.345> <0.613, 3.395, 12.329> <0.613, 3.365, 12.330> <0.613, 3.349, 12.324> 
		<0.601, 3.391, 12.350> <0.601, 3.384, 12.334> <0.613, 3.358, 12.346> <0.613, 3.342, 12.340> 
		<0.573, 3.381, 12.354> <0.572, 3.365, 12.361> <0.600, 3.332, 12.357> <0.611, 3.321, 12.362> 
		<0.572, 3.365, 12.361> <0.572, 3.350, 12.368> <0.600, 3.339, 12.373> <0.611, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.402, 12.345> <0.613, 3.402, 12.345> <0.613, 3.402, 12.345> <0.613, 3.402, 12.345> 
		<0.601, 3.391, 12.350> <0.601, 3.384, 12.334> <0.601, 3.384, 12.334> <0.613, 3.395, 12.329> 
		<0.573, 3.381, 12.354> <0.573, 3.374, 12.339> <0.601, 3.370, 12.341> <0.613, 3.365, 12.330> 
		<0.572, 3.365, 12.361> <0.572, 3.358, 12.346> <0.601, 3.354, 12.335> <0.613, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.381, 12.399> <0.613, 3.366, 12.406> <0.611, 3.335, 12.394> <0.611, 3.328, 12.378> 
		<0.601, 3.376, 12.387> <0.601, 3.361, 12.394> <0.611, 3.328, 12.378> <0.611, 3.321, 12.362> 
		<0.572, 3.372, 12.377> <0.572, 3.365, 12.361> <0.600, 3.347, 12.351> <0.613, 3.342, 12.340> 
		<0.572, 3.365, 12.361> <0.572, 3.358, 12.346> <0.601, 3.354, 12.335> <0.613, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.613, 3.381, 12.399> <0.613, 3.381, 12.399> <0.613, 3.381, 12.399> <0.613, 3.381, 12.399> 
		<0.601, 3.376, 12.387> <0.601, 3.361, 12.394> <0.601, 3.361, 12.394> <0.613, 3.366, 12.406> 
		<0.572, 3.372, 12.377> <0.572, 3.357, 12.384> <0.600, 3.346, 12.389> <0.611, 3.335, 12.394> 
		<0.572, 3.365, 12.361> <0.572, 3.350, 12.368> <0.600, 3.339, 12.373> <0.611, 3.328, 12.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.572, 3.365, 12.361> <0.572, 3.365, 12.361> <0.572, 3.365, 12.361> <0.572, 3.365, 12.361> 
		<0.572, 3.350, 12.368> <0.572, 3.343, 12.352> <0.572, 3.343, 12.352> <0.572, 3.358, 12.346> 
		<0.600, 3.339, 12.373> <0.600, 3.332, 12.357> <0.600, 3.347, 12.351> <0.601, 3.354, 12.335> 
		<0.611, 3.328, 12.378> <0.611, 3.321, 12.362> <0.613, 3.342, 12.340> <0.613, 3.349, 12.324> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.739, 13.451> <1.423, 0.739, 13.451> <1.423, 0.739, 13.451> <1.423, 0.739, 13.451> 
		<1.405, 0.746, 13.468> <1.405, 0.725, 13.497> <1.405, 0.725, 13.497> <1.423, 0.718, 13.480> 
		<1.381, 0.756, 13.490> <1.399, 0.727, 13.502> <1.405, 0.718, 13.507> <1.423, 0.689, 13.519> 
		<1.363, 0.763, 13.507> <1.381, 0.735, 13.519> <1.405, 0.697, 13.536> <1.423, 0.668, 13.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.739, 13.451> <1.423, 0.739, 13.451> <1.423, 0.739, 13.451> <1.423, 0.739, 13.451> 
		<1.423, 0.718, 13.480> <1.442, 0.725, 13.497> <1.442, 0.725, 13.497> <1.442, 0.746, 13.468> 
		<1.423, 0.689, 13.519> <1.442, 0.718, 13.507> <1.448, 0.727, 13.502> <1.466, 0.756, 13.490> 
		<1.423, 0.668, 13.548> <1.442, 0.697, 13.536> <1.466, 0.735, 13.519> <1.484, 0.763, 13.507> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.423, 0.739, 13.451> <1.442, 0.746, 13.468> <1.466, 0.756, 13.490> <1.484, 0.763, 13.507> 
		<1.405, 0.746, 13.468> <1.423, 0.753, 13.484> <1.448, 0.727, 13.502> <1.466, 0.735, 13.519> 
		<1.381, 0.756, 13.490> <1.399, 0.727, 13.502> <1.423, 0.725, 13.523> <1.442, 0.697, 13.536> 
		<1.363, 0.763, 13.507> <1.381, 0.735, 13.519> <1.405, 0.697, 13.536> <1.423, 0.668, 13.548> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 0.258, 13.679> <1.383, 0.241, 13.630> <1.423, 0.240, 13.566> <1.423, 0.231, 13.515> 
		<1.384, 0.936, 13.353> <1.384, 0.919, 13.305> <1.423, 0.798, 13.321> <1.423, 0.790, 13.271> 
		<1.414, 1.870, 12.984> <1.413, 1.716, 12.960> <1.425, 1.658, 12.903> <1.423, 1.504, 12.879> 
		<1.428, 2.561, 12.686> <1.427, 2.407, 12.662> <1.425, 2.203, 12.630> <1.423, 2.050, 12.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 0.258, 13.679> <1.384, 0.936, 13.353> <1.414, 1.870, 12.984> <1.428, 2.561, 12.686> 
		<1.383, 0.287, 13.763> <1.384, 0.966, 13.438> <1.413, 1.720, 13.159> <1.427, 2.411, 12.861> 
		<1.423, 0.345, 13.866> <1.423, 0.833, 13.627> <1.425, 1.708, 13.297> <1.425, 2.211, 13.094> 
		<1.423, 0.383, 13.947> <1.423, 0.871, 13.708> <1.423, 1.558, 13.472> <1.423, 2.062, 13.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 0.258, 13.679> <1.383, 0.287, 13.763> <1.423, 0.345, 13.866> <1.423, 0.383, 13.947> 
		<1.383, -0.033, 13.818> <1.383, -0.003, 13.903> <1.423, -0.025, 14.046> <1.423, 0.012, 14.128> 
		<1.423, -0.386, 14.066> <1.423, -0.383, 14.200> <1.423, -0.400, 14.318> <1.423, -0.438, 14.448> 
		<1.423, -0.662, 14.232> <1.423, -0.659, 14.367> <1.423, -0.751, 14.533> <1.423, -0.789, 14.662> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 0.258, 13.679> <1.383, -0.033, 13.818> <1.423, -0.386, 14.066> <1.423, -0.662, 14.232> 
		<1.383, 0.241, 13.630> <1.383, -0.050, 13.770> <1.423, -0.388, 13.945> <1.423, -0.664, 14.111> 
		<1.423, 0.240, 13.566> <1.423, -0.060, 13.697> <1.423, -0.451, 13.866> <1.423, -0.762, 13.968> 
		<1.423, 0.231, 13.515> <1.423, -0.068, 13.646> <1.423, -0.494, 13.753> <1.423, -0.805, 13.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, -0.789, 14.662> <1.395, -0.789, 14.662> <1.411, -0.789, 14.662> <1.423, -0.789, 14.662> 
		<1.383, -0.438, 14.448> <1.395, -0.438, 14.448> <1.411, -0.438, 14.448> <1.423, -0.438, 14.448> 
		<1.383, 0.012, 14.128> <1.395, 0.012, 14.128> <1.423, 0.018, 14.139> <1.423, 0.012, 14.128> 
		<1.383, 0.383, 13.947> <1.395, 0.383, 13.947> <1.423, 0.388, 13.958> <1.423, 0.383, 13.947> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, -0.789, 14.662> <1.383, -0.751, 14.533> <1.383, -0.659, 14.367> <1.383, -0.662, 14.232> 
		<1.395, -0.789, 14.662> <1.395, -0.751, 14.533> <1.395, -0.659, 14.367> <1.395, -0.662, 14.232> 
		<1.411, -0.789, 14.662> <1.411, -0.751, 14.533> <1.423, -0.670, 14.373> <1.423, -0.672, 14.238> 
		<1.423, -0.789, 14.662> <1.423, -0.751, 14.533> <1.423, -0.659, 14.367> <1.423, -0.662, 14.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, -0.662, 14.232> <1.383, -0.664, 14.111> <1.383, -0.762, 13.968> <1.383, -0.805, 13.855> 
		<1.395, -0.662, 14.232> <1.395, -0.664, 14.111> <1.395, -0.762, 13.968> <1.395, -0.805, 13.855> 
		<1.423, -0.672, 14.238> <1.423, -0.674, 14.117> <1.411, -0.762, 13.968> <1.411, -0.805, 13.855> 
		<1.423, -0.662, 14.232> <1.423, -0.664, 14.111> <1.423, -0.762, 13.968> <1.423, -0.805, 13.855> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, -0.805, 13.855> <1.383, -0.494, 13.753> <1.383, -0.068, 13.646> <1.383, 0.231, 13.515> 
		<1.395, -0.805, 13.855> <1.395, -0.494, 13.753> <1.395, -0.068, 13.646> <1.395, 0.231, 13.515> 
		<1.411, -0.805, 13.855> <1.411, -0.494, 13.753> <1.423, -0.070, 13.634> <1.423, 0.229, 13.503> 
		<1.423, -0.805, 13.855> <1.423, -0.494, 13.753> <1.423, -0.068, 13.646> <1.423, 0.231, 13.515> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 0.231, 13.515> <1.383, 0.790, 13.271> <1.383, 1.504, 12.879> <1.383, 2.050, 12.606> 
		<1.395, 0.231, 13.515> <1.395, 0.790, 13.271> <1.395, 1.504, 12.879> <1.395, 2.050, 12.606> 
		<1.423, 0.229, 13.503> <1.423, 0.788, 13.259> <1.411, 1.504, 12.879> <1.411, 2.050, 12.606> 
		<1.423, 0.231, 13.515> <1.423, 0.790, 13.271> <1.423, 1.504, 12.879> <1.423, 2.050, 12.606> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 2.050, 12.606> <1.384, 2.203, 12.630> <1.386, 2.407, 12.662> <1.388, 2.561, 12.686> 
		<1.395, 2.050, 12.606> <1.397, 2.203, 12.630> <1.398, 2.407, 12.662> <1.400, 2.561, 12.686> 
		<1.411, 2.050, 12.606> <1.413, 2.203, 12.630> <1.414, 2.407, 12.662> <1.416, 2.561, 12.686> 
		<1.423, 2.050, 12.606> <1.425, 2.203, 12.630> <1.427, 2.407, 12.662> <1.428, 2.561, 12.686> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.388, 2.561, 12.686> <1.386, 2.411, 12.861> <1.384, 2.211, 13.094> <1.383, 2.062, 13.269> 
		<1.400, 2.561, 12.686> <1.398, 2.411, 12.861> <1.397, 2.211, 13.094> <1.395, 2.062, 13.269> 
		<1.416, 2.561, 12.686> <1.414, 2.411, 12.861> <1.413, 2.211, 13.094> <1.411, 2.062, 13.269> 
		<1.428, 2.561, 12.686> <1.427, 2.411, 12.861> <1.425, 2.211, 13.094> <1.423, 2.062, 13.269> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.383, 2.062, 13.269> <1.383, 1.558, 13.472> <1.383, 0.871, 13.708> <1.383, 0.383, 13.947> 
		<1.395, 2.062, 13.269> <1.395, 1.558, 13.472> <1.395, 0.871, 13.708> <1.395, 0.383, 13.947> 
		<1.411, 2.062, 13.269> <1.411, 1.558, 13.472> <1.423, 0.876, 13.719> <1.423, 0.388, 13.958> 
		<1.423, 2.062, 13.269> <1.423, 1.558, 13.472> <1.423, 0.871, 13.708> <1.423, 0.383, 13.947> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment { DarkWood }
	finish { phong 0.3 }
	#end
}
// Layer 6 pillars
 union {
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 2.375, 12.617> <-1.666, 2.375, 12.617> <-1.666, 2.375, 12.617> <-1.666, 2.375, 12.617> 
		<-1.666, 2.375, 12.576> <-1.666, 2.375, 12.617> <-1.666, 2.375, 12.617> <-1.666, 2.375, 12.657> 
		<-1.666, 2.409, 12.542> <-1.666, 2.409, 12.587> <-1.666, 2.409, 12.647> <-1.666, 2.409, 12.691> 
		<-1.666, 2.449, 12.542> <-1.666, 2.449, 12.587> <-1.666, 2.449, 12.647> <-1.666, 2.449, 12.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 2.375, 12.617> <-1.666, 2.375, 12.576> <-1.666, 2.409, 12.542> <-1.666, 2.449, 12.542> 
		<-0.667, 2.375, 12.617> <-0.667, 2.375, 12.576> <-0.667, 2.409, 12.542> <-0.667, 2.449, 12.542> 
		<0.667, 2.375, 12.617> <0.667, 2.375, 12.576> <0.667, 2.409, 12.542> <0.667, 2.449, 12.542> 
		<1.666, 2.375, 12.617> <1.666, 2.375, 12.576> <1.666, 2.409, 12.542> <1.666, 2.449, 12.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 2.375, 12.617> <-0.667, 2.375, 12.617> <0.667, 2.375, 12.617> <1.666, 2.375, 12.617> 
		<-1.666, 2.375, 12.657> <-0.667, 2.375, 12.657> <0.667, 2.375, 12.657> <1.666, 2.375, 12.657> 
		<-1.666, 2.409, 12.691> <-0.667, 2.409, 12.691> <0.667, 2.409, 12.691> <1.666, 2.409, 12.691> 
		<-1.666, 2.449, 12.691> <-0.667, 2.449, 12.691> <0.667, 2.449, 12.691> <1.666, 2.449, 12.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 2.524, 12.617> <-1.666, 2.524, 12.657> <-1.666, 2.490, 12.691> <-1.666, 2.449, 12.691> 
		<-0.667, 2.524, 12.617> <-0.667, 2.524, 12.657> <-0.667, 2.490, 12.691> <-0.667, 2.449, 12.691> 
		<0.667, 2.524, 12.617> <0.667, 2.524, 12.657> <0.667, 2.490, 12.691> <0.667, 2.449, 12.691> 
		<1.666, 2.524, 12.617> <1.666, 2.524, 12.657> <1.666, 2.490, 12.691> <1.666, 2.449, 12.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 2.524, 12.617> <-1.666, 2.524, 12.617> <-1.666, 2.524, 12.617> <-1.666, 2.524, 12.617> 
		<-1.666, 2.524, 12.657> <-1.666, 2.524, 12.617> <-1.666, 2.524, 12.617> <-1.666, 2.524, 12.576> 
		<-1.666, 2.490, 12.691> <-1.666, 2.490, 12.647> <-1.666, 2.490, 12.587> <-1.666, 2.490, 12.542> 
		<-1.666, 2.449, 12.691> <-1.666, 2.449, 12.647> <-1.666, 2.449, 12.587> <-1.666, 2.449, 12.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-1.666, 2.524, 12.617> <-0.667, 2.524, 12.617> <0.667, 2.524, 12.617> <1.666, 2.524, 12.617> 
		<-1.666, 2.524, 12.576> <-0.667, 2.524, 12.576> <0.667, 2.524, 12.576> <1.666, 2.524, 12.576> 
		<-1.666, 2.490, 12.542> <-0.667, 2.490, 12.542> <0.667, 2.490, 12.542> <1.666, 2.490, 12.542> 
		<-1.666, 2.449, 12.542> <-0.667, 2.449, 12.542> <0.667, 2.449, 12.542> <1.666, 2.449, 12.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.666, 2.375, 12.617> <1.666, 2.375, 12.617> <1.666, 2.375, 12.617> <1.666, 2.375, 12.617> 
		<1.666, 2.375, 12.657> <1.666, 2.375, 12.617> <1.666, 2.375, 12.617> <1.666, 2.375, 12.576> 
		<1.666, 2.409, 12.691> <1.666, 2.409, 12.647> <1.666, 2.409, 12.587> <1.666, 2.409, 12.542> 
		<1.666, 2.449, 12.691> <1.666, 2.449, 12.647> <1.666, 2.449, 12.587> <1.666, 2.449, 12.542> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<1.666, 2.524, 12.617> <1.666, 2.524, 12.617> <1.666, 2.524, 12.617> <1.666, 2.524, 12.617> 
		<1.666, 2.524, 12.576> <1.666, 2.524, 12.617> <1.666, 2.524, 12.617> <1.666, 2.524, 12.657> 
		<1.666, 2.490, 12.542> <1.666, 2.490, 12.587> <1.666, 2.490, 12.647> <1.666, 2.490, 12.691> 
		<1.666, 2.449, 12.542> <1.666, 2.449, 12.587> <1.666, 2.449, 12.647> <1.666, 2.449, 12.691> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.870, 2.616, 11.977> <0.870, 2.616, 11.977> <0.870, 2.616, 11.977> <0.870, 2.616, 11.977> 
		<0.870, 2.616, 11.946> <0.902, 2.616, 11.946> <0.902, 2.616, 11.946> <0.902, 2.616, 11.977> 
		<0.870, 2.616, 11.903> <0.902, 2.616, 11.935> <0.912, 2.616, 11.946> <0.944, 2.616, 11.977> 
		<0.870, 2.616, 11.872> <0.902, 2.616, 11.903> <0.944, 2.616, 11.946> <0.976, 2.616, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.870, 2.616, 11.977> <0.870, 2.616, 11.946> <0.870, 2.616, 11.903> <0.870, 2.616, 11.872> 
		<0.870, 2.008, 11.977> <0.870, 2.008, 11.946> <0.870, 2.008, 11.903> <0.870, 2.008, 11.872> 
		<0.870, 1.198, 11.977> <0.870, 1.198, 11.946> <0.870, 1.198, 11.903> <0.870, 1.198, 11.872> 
		<0.870, 0.590, 11.977> <0.870, 0.590, 11.946> <0.870, 0.590, 11.903> <0.870, 0.590, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.870, 2.616, 11.977> <0.870, 2.008, 11.977> <0.870, 1.198, 11.977> <0.870, 0.590, 11.977> 
		<0.902, 2.616, 11.977> <0.902, 2.008, 11.977> <0.902, 1.198, 11.977> <0.902, 0.590, 11.977> 
		<0.944, 2.616, 11.977> <0.944, 2.008, 11.977> <0.944, 1.198, 11.977> <0.944, 0.590, 11.977> 
		<0.976, 2.616, 11.977> <0.976, 2.008, 11.977> <0.976, 1.198, 11.977> <0.976, 0.590, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, 2.616, 11.872> <0.976, 2.616, 11.903> <0.976, 2.616, 11.946> <0.976, 2.616, 11.977> 
		<0.976, 2.008, 11.872> <0.976, 2.008, 11.903> <0.976, 2.008, 11.946> <0.976, 2.008, 11.977> 
		<0.976, 1.198, 11.872> <0.976, 1.198, 11.903> <0.976, 1.198, 11.946> <0.976, 1.198, 11.977> 
		<0.976, 0.590, 11.872> <0.976, 0.590, 11.903> <0.976, 0.590, 11.946> <0.976, 0.590, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, 2.616, 11.872> <0.976, 2.616, 11.872> <0.976, 2.616, 11.872> <0.976, 2.616, 11.872> 
		<0.976, 2.616, 11.903> <0.944, 2.616, 11.903> <0.944, 2.616, 11.903> <0.944, 2.616, 11.872> 
		<0.976, 2.616, 11.946> <0.944, 2.616, 11.914> <0.934, 2.616, 11.903> <0.902, 2.616, 11.872> 
		<0.976, 2.616, 11.977> <0.944, 2.616, 11.946> <0.902, 2.616, 11.903> <0.870, 2.616, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, 2.616, 11.872> <0.976, 2.008, 11.872> <0.976, 1.198, 11.872> <0.976, 0.590, 11.872> 
		<0.944, 2.616, 11.872> <0.944, 2.008, 11.872> <0.944, 1.198, 11.872> <0.944, 0.590, 11.872> 
		<0.902, 2.616, 11.872> <0.902, 2.008, 11.872> <0.902, 1.198, 11.872> <0.902, 0.590, 11.872> 
		<0.870, 2.616, 11.872> <0.870, 2.008, 11.872> <0.870, 1.198, 11.872> <0.870, 0.590, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.870, 0.590, 11.977> <0.870, 0.590, 11.977> <0.870, 0.590, 11.977> <0.870, 0.590, 11.977> 
		<0.902, 0.590, 11.977> <0.902, 0.590, 11.946> <0.902, 0.590, 11.946> <0.870, 0.590, 11.946> 
		<0.944, 0.590, 11.977> <0.912, 0.590, 11.946> <0.902, 0.590, 11.935> <0.870, 0.590, 11.903> 
		<0.976, 0.590, 11.977> <0.944, 0.590, 11.946> <0.902, 0.590, 11.903> <0.870, 0.590, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.976, 0.590, 11.872> <0.976, 0.590, 11.872> <0.976, 0.590, 11.872> <0.976, 0.590, 11.872> 
		<0.944, 0.590, 11.872> <0.944, 0.590, 11.903> <0.944, 0.590, 11.903> <0.976, 0.590, 11.903> 
		<0.902, 0.590, 11.872> <0.934, 0.590, 11.903> <0.944, 0.590, 11.914> <0.976, 0.590, 11.946> 
		<0.870, 0.590, 11.872> <0.902, 0.590, 11.903> <0.944, 0.590, 11.946> <0.976, 0.590, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.946, 2.616, 11.977> <-0.946, 2.616, 11.977> <-0.946, 2.616, 11.977> <-0.946, 2.616, 11.977> 
		<-0.946, 2.616, 11.946> <-0.915, 2.616, 11.946> <-0.915, 2.616, 11.946> <-0.915, 2.616, 11.977> 
		<-0.946, 2.616, 11.903> <-0.915, 2.616, 11.935> <-0.904, 2.616, 11.946> <-0.873, 2.616, 11.977> 
		<-0.946, 2.616, 11.872> <-0.915, 2.616, 11.903> <-0.873, 2.616, 11.946> <-0.841, 2.616, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.946, 2.616, 11.977> <-0.946, 2.616, 11.946> <-0.946, 2.616, 11.903> <-0.946, 2.616, 11.872> 
		<-0.946, 2.008, 11.977> <-0.946, 2.008, 11.946> <-0.946, 2.008, 11.903> <-0.946, 2.008, 11.872> 
		<-0.946, 1.198, 11.977> <-0.946, 1.198, 11.946> <-0.946, 1.198, 11.903> <-0.946, 1.198, 11.872> 
		<-0.946, 0.590, 11.977> <-0.946, 0.590, 11.946> <-0.946, 0.590, 11.903> <-0.946, 0.590, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.946, 2.616, 11.977> <-0.946, 2.008, 11.977> <-0.946, 1.198, 11.977> <-0.946, 0.590, 11.977> 
		<-0.915, 2.616, 11.977> <-0.915, 2.008, 11.977> <-0.915, 1.198, 11.977> <-0.915, 0.590, 11.977> 
		<-0.873, 2.616, 11.977> <-0.873, 2.008, 11.977> <-0.873, 1.198, 11.977> <-0.873, 0.590, 11.977> 
		<-0.841, 2.616, 11.977> <-0.841, 2.008, 11.977> <-0.841, 1.198, 11.977> <-0.841, 0.590, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.841, 2.616, 11.872> <-0.841, 2.616, 11.903> <-0.841, 2.616, 11.946> <-0.841, 2.616, 11.977> 
		<-0.841, 2.008, 11.872> <-0.841, 2.008, 11.903> <-0.841, 2.008, 11.946> <-0.841, 2.008, 11.977> 
		<-0.841, 1.198, 11.872> <-0.841, 1.198, 11.903> <-0.841, 1.198, 11.946> <-0.841, 1.198, 11.977> 
		<-0.841, 0.590, 11.872> <-0.841, 0.590, 11.903> <-0.841, 0.590, 11.946> <-0.841, 0.590, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.841, 2.616, 11.872> <-0.841, 2.616, 11.872> <-0.841, 2.616, 11.872> <-0.841, 2.616, 11.872> 
		<-0.841, 2.616, 11.903> <-0.873, 2.616, 11.903> <-0.873, 2.616, 11.903> <-0.873, 2.616, 11.872> 
		<-0.841, 2.616, 11.946> <-0.873, 2.616, 11.914> <-0.883, 2.616, 11.903> <-0.915, 2.616, 11.872> 
		<-0.841, 2.616, 11.977> <-0.873, 2.616, 11.946> <-0.915, 2.616, 11.903> <-0.946, 2.616, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.841, 2.616, 11.872> <-0.841, 2.008, 11.872> <-0.841, 1.198, 11.872> <-0.841, 0.590, 11.872> 
		<-0.873, 2.616, 11.872> <-0.873, 2.008, 11.872> <-0.873, 1.198, 11.872> <-0.873, 0.590, 11.872> 
		<-0.915, 2.616, 11.872> <-0.915, 2.008, 11.872> <-0.915, 1.198, 11.872> <-0.915, 0.590, 11.872> 
		<-0.946, 2.616, 11.872> <-0.946, 2.008, 11.872> <-0.946, 1.198, 11.872> <-0.946, 0.590, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.946, 0.590, 11.977> <-0.946, 0.590, 11.977> <-0.946, 0.590, 11.977> <-0.946, 0.590, 11.977> 
		<-0.915, 0.590, 11.977> <-0.915, 0.590, 11.946> <-0.915, 0.590, 11.946> <-0.946, 0.590, 11.946> 
		<-0.873, 0.590, 11.977> <-0.904, 0.590, 11.946> <-0.915, 0.590, 11.935> <-0.946, 0.590, 11.903> 
		<-0.841, 0.590, 11.977> <-0.873, 0.590, 11.946> <-0.915, 0.590, 11.903> <-0.946, 0.590, 11.872> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.841, 0.590, 11.872> <-0.841, 0.590, 11.872> <-0.841, 0.590, 11.872> <-0.841, 0.590, 11.872> 
		<-0.873, 0.590, 11.872> <-0.873, 0.590, 11.903> <-0.873, 0.590, 11.903> <-0.841, 0.590, 11.903> 
		<-0.915, 0.590, 11.872> <-0.883, 0.590, 11.903> <-0.873, 0.590, 11.914> <-0.841, 0.590, 11.946> 
		<-0.946, 0.590, 11.872> <-0.915, 0.590, 11.903> <-0.873, 0.590, 11.946> <-0.841, 0.590, 11.977> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.444, 2.616, 14.024> <0.444, 2.616, 14.024> <0.444, 2.616, 14.024> <0.444, 2.616, 14.024> 
		<0.444, 2.616, 13.993> <0.465, 2.616, 13.993> <0.465, 2.616, 13.993> <0.465, 2.616, 14.024> 
		<0.444, 2.616, 13.951> <0.465, 2.616, 13.982> <0.472, 2.616, 13.993> <0.493, 2.616, 14.024> 
		<0.444, 2.616, 13.919> <0.465, 2.616, 13.951> <0.493, 2.616, 13.993> <0.513, 2.616, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.444, 2.616, 14.024> <0.444, 2.616, 13.993> <0.444, 2.616, 13.951> <0.444, 2.616, 13.919> 
		<0.444, 2.144, 14.024> <0.444, 2.144, 13.993> <0.444, 2.144, 13.951> <0.444, 2.144, 13.919> 
		<0.444, 1.515, 14.024> <0.444, 1.515, 13.993> <0.444, 1.515, 13.951> <0.444, 1.515, 13.919> 
		<0.444, 1.044, 14.024> <0.444, 1.044, 13.993> <0.444, 1.044, 13.951> <0.444, 1.044, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.444, 2.616, 14.024> <0.444, 2.144, 14.024> <0.444, 1.515, 14.024> <0.444, 1.044, 14.024> 
		<0.465, 2.616, 14.024> <0.465, 2.144, 14.024> <0.465, 1.515, 14.024> <0.465, 1.044, 14.024> 
		<0.493, 2.616, 14.024> <0.493, 2.144, 14.024> <0.493, 1.515, 14.024> <0.493, 1.044, 14.024> 
		<0.513, 2.616, 14.024> <0.513, 2.144, 14.024> <0.513, 1.515, 14.024> <0.513, 1.044, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, 2.616, 13.919> <0.513, 2.616, 13.951> <0.513, 2.616, 13.993> <0.513, 2.616, 14.024> 
		<0.513, 2.144, 13.919> <0.513, 2.144, 13.951> <0.513, 2.144, 13.993> <0.513, 2.144, 14.024> 
		<0.513, 1.515, 13.919> <0.513, 1.515, 13.951> <0.513, 1.515, 13.993> <0.513, 1.515, 14.024> 
		<0.513, 1.044, 13.919> <0.513, 1.044, 13.951> <0.513, 1.044, 13.993> <0.513, 1.044, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, 2.616, 13.919> <0.513, 2.616, 13.919> <0.513, 2.616, 13.919> <0.513, 2.616, 13.919> 
		<0.513, 2.616, 13.951> <0.493, 2.616, 13.951> <0.493, 2.616, 13.951> <0.493, 2.616, 13.919> 
		<0.513, 2.616, 13.993> <0.493, 2.616, 13.961> <0.486, 2.616, 13.951> <0.465, 2.616, 13.919> 
		<0.513, 2.616, 14.024> <0.493, 2.616, 13.993> <0.465, 2.616, 13.951> <0.444, 2.616, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, 2.616, 13.919> <0.513, 2.144, 13.919> <0.513, 1.515, 13.919> <0.513, 1.044, 13.919> 
		<0.493, 2.616, 13.919> <0.493, 2.144, 13.919> <0.493, 1.515, 13.919> <0.493, 1.044, 13.919> 
		<0.465, 2.616, 13.919> <0.465, 2.144, 13.919> <0.465, 1.515, 13.919> <0.465, 1.044, 13.919> 
		<0.444, 2.616, 13.919> <0.444, 2.144, 13.919> <0.444, 1.515, 13.919> <0.444, 1.044, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.444, 1.044, 14.024> <0.444, 1.044, 14.024> <0.444, 1.044, 14.024> <0.444, 1.044, 14.024> 
		<0.465, 1.044, 14.024> <0.465, 1.044, 13.993> <0.465, 1.044, 13.993> <0.444, 1.044, 13.993> 
		<0.493, 1.044, 14.024> <0.472, 1.044, 13.993> <0.465, 1.044, 13.982> <0.444, 1.044, 13.951> 
		<0.513, 1.044, 14.024> <0.493, 1.044, 13.993> <0.465, 1.044, 13.951> <0.444, 1.044, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.513, 1.044, 13.919> <0.513, 1.044, 13.919> <0.513, 1.044, 13.919> <0.513, 1.044, 13.919> 
		<0.493, 1.044, 13.919> <0.493, 1.044, 13.951> <0.493, 1.044, 13.951> <0.513, 1.044, 13.951> 
		<0.465, 1.044, 13.919> <0.486, 1.044, 13.951> <0.493, 1.044, 13.961> <0.513, 1.044, 13.993> 
		<0.444, 1.044, 13.919> <0.465, 1.044, 13.951> <0.493, 1.044, 13.993> <0.513, 1.044, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.527, 2.616, 14.024> <-0.527, 2.616, 14.024> <-0.527, 2.616, 14.024> <-0.527, 2.616, 14.024> 
		<-0.527, 2.616, 13.993> <-0.506, 2.616, 13.993> <-0.506, 2.616, 13.993> <-0.506, 2.616, 14.024> 
		<-0.527, 2.616, 13.951> <-0.506, 2.616, 13.982> <-0.500, 2.616, 13.993> <-0.479, 2.616, 14.024> 
		<-0.527, 2.616, 13.919> <-0.506, 2.616, 13.951> <-0.479, 2.616, 13.993> <-0.458, 2.616, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.527, 2.616, 14.024> <-0.527, 2.616, 13.993> <-0.527, 2.616, 13.951> <-0.527, 2.616, 13.919> 
		<-0.527, 2.144, 14.024> <-0.527, 2.144, 13.993> <-0.527, 2.144, 13.951> <-0.527, 2.144, 13.919> 
		<-0.527, 1.515, 14.024> <-0.527, 1.515, 13.993> <-0.527, 1.515, 13.951> <-0.527, 1.515, 13.919> 
		<-0.527, 1.044, 14.024> <-0.527, 1.044, 13.993> <-0.527, 1.044, 13.951> <-0.527, 1.044, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.527, 2.616, 14.024> <-0.527, 2.144, 14.024> <-0.527, 1.515, 14.024> <-0.527, 1.044, 14.024> 
		<-0.506, 2.616, 14.024> <-0.506, 2.144, 14.024> <-0.506, 1.515, 14.024> <-0.506, 1.044, 14.024> 
		<-0.479, 2.616, 14.024> <-0.479, 2.144, 14.024> <-0.479, 1.515, 14.024> <-0.479, 1.044, 14.024> 
		<-0.458, 2.616, 14.024> <-0.458, 2.144, 14.024> <-0.458, 1.515, 14.024> <-0.458, 1.044, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, 2.616, 13.919> <-0.458, 2.616, 13.951> <-0.458, 2.616, 13.993> <-0.458, 2.616, 14.024> 
		<-0.458, 2.144, 13.919> <-0.458, 2.144, 13.951> <-0.458, 2.144, 13.993> <-0.458, 2.144, 14.024> 
		<-0.458, 1.515, 13.919> <-0.458, 1.515, 13.951> <-0.458, 1.515, 13.993> <-0.458, 1.515, 14.024> 
		<-0.458, 1.044, 13.919> <-0.458, 1.044, 13.951> <-0.458, 1.044, 13.993> <-0.458, 1.044, 14.024> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, 2.616, 13.919> <-0.458, 2.616, 13.919> <-0.458, 2.616, 13.919> <-0.458, 2.616, 13.919> 
		<-0.458, 2.616, 13.951> <-0.479, 2.616, 13.951> <-0.479, 2.616, 13.951> <-0.479, 2.616, 13.919> 
		<-0.458, 2.616, 13.993> <-0.479, 2.616, 13.961> <-0.486, 2.616, 13.951> <-0.506, 2.616, 13.919> 
		<-0.458, 2.616, 14.024> <-0.479, 2.616, 13.993> <-0.506, 2.616, 13.951> <-0.527, 2.616, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, 2.616, 13.919> <-0.458, 2.144, 13.919> <-0.458, 1.515, 13.919> <-0.458, 1.044, 13.919> 
		<-0.479, 2.616, 13.919> <-0.479, 2.144, 13.919> <-0.479, 1.515, 13.919> <-0.479, 1.044, 13.919> 
		<-0.506, 2.616, 13.919> <-0.506, 2.144, 13.919> <-0.506, 1.515, 13.919> <-0.506, 1.044, 13.919> 
		<-0.527, 2.616, 13.919> <-0.527, 2.144, 13.919> <-0.527, 1.515, 13.919> <-0.527, 1.044, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.527, 1.044, 14.024> <-0.527, 1.044, 14.024> <-0.527, 1.044, 14.024> <-0.527, 1.044, 14.024> 
		<-0.506, 1.044, 14.024> <-0.506, 1.044, 13.993> <-0.506, 1.044, 13.993> <-0.527, 1.044, 13.993> 
		<-0.479, 1.044, 14.024> <-0.500, 1.044, 13.993> <-0.506, 1.044, 13.982> <-0.527, 1.044, 13.951> 
		<-0.458, 1.044, 14.024> <-0.479, 1.044, 13.993> <-0.506, 1.044, 13.951> <-0.527, 1.044, 13.919> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.458, 1.044, 13.919> <-0.458, 1.044, 13.919> <-0.458, 1.044, 13.919> <-0.458, 1.044, 13.919> 
		<-0.479, 1.044, 13.919> <-0.479, 1.044, 13.951> <-0.479, 1.044, 13.951> <-0.458, 1.044, 13.951> 
		<-0.506, 1.044, 13.919> <-0.486, 1.044, 13.951> <-0.479, 1.044, 13.961> <-0.458, 1.044, 13.993> 
		<-0.527, 1.044, 13.919> <-0.506, 1.044, 13.951> <-0.479, 1.044, 13.993> <-0.458, 1.044, 14.024> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment { color DarkWood }
	finish { phong 0.3 }
	#end
}

// ***************************** Shields from here

#declare i = 0;
#while (i < 6)
 object {shield rotate <0,-90,0> translate <1.8,2.5,i*1.55>}
 object {shield rotate <0,90,0> translate <-1.8,2.5,i*1.55>}

 #declare i = i + 1;
#end 

 object {shield rotate <0,-85,0> translate <1.75,2.5,-1*1.55>}
 object {shield rotate <0,85,0> translate <-1.75,2.5,-1*1.55>}

 object {shield rotate <0,-80,0> translate <1.63,2.5,-2*1.55>}
 object {shield rotate <0,80,0> translate <-1.63,2.5,-2*1.55>}

 object {shield rotate <0,-77,0> translate <1.5,2.5,-3*1.55>}
 object {shield rotate <0,77,0> translate <-1.5,2.5,-3*1.55>}

 object {shield rotate <0,-77,0> translate <1.27,2.5,-4*1.55>}
 object {shield rotate <0,77,0> translate <-1.27,2.5,-4*1.55>}

 object {shield rotate <0,-82,0> translate <1.05,2.5,-5*1.55>}
 object {shield rotate <0,82,0> translate <-1.05,2.5,-5*1.55>}

 object {shield rotate <0,-82,0> translate <0.85,2.5,-6*1.55>}
 object {shield rotate <0,82,0> translate <-0.85,2.5,-6*1.55>}

 object {shield rotate <0,-77,0> translate <0.55,2.5,-7*1.55>}
 object {shield rotate <0,77,0> translate <-0.55,2.5,-7*1.55>}

 object {shield rotate <0,-93,0> translate <1.7,2.5,6*1.55>}
 object {shield rotate <0,93,0> translate <-1.7,2.5,6*1.55>}

 object {shield rotate <0,-97,0> translate <1.5,2.5,7*1.55>}
 object {shield rotate <0,97,0> translate <-1.5,2.5,7*1.55>}

// ****************************************++ oars from here





object { oar rotate <0,0,-15> translate <1.5,2,0.775>}
object { oar rotate <0,180,15> translate <-1.5,2,0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5,0>}
object { oar rotate <0,180,7> translate <-1.5,1.5,0>}

// 2. row

object { oar rotate <0,0,-15> translate <1.5,2, 1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, 1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, 1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, 1.55>}

// 3. row

object { oar rotate <0,0,-15> translate <1.5,2, 2*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, 2*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, 2*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, 2*1.55>}

// 4. row

object { oar rotate <0,0,-15> translate <1.5,2, 3*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, 3*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, 3*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, 3*1.55>}

// 5. row

object { oar rotate <0,0,-15> translate <1.5,2, 4*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, 4*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, 4*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, 4*1.55>}

// 6. row

object { oar rotate <0,0,-15> translate <1.5,2, 5*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, 5*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, 5*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, 5*1.55>}

// 7. row

object { oar rotate <0,0,-15> translate <1.5,2, 6*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, 6*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, 6*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, 6*1.55>}

// A row

object { oar rotate <0,0,-15> translate <1.5,2, -1*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -1*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -1*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -1*1.55>}

// B row

object { oar rotate <0,0,-15> translate <1.5,2, -2*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -2*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -2*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -2*1.55>}

// C row

object { oar rotate <0,0,-15> translate <1.5,2, -3*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -3*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -3*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -3*1.55>}

// D row

object { oar rotate <0,0,-15> translate <1.5,2, -3*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -3*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -3*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -3*1.55>}

// E row

object { oar rotate <0,0,-15> translate <1.5,2, -3*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -3*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -3*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -3*1.55>}

// F row

object { oar rotate <0,0,-15> translate <1.5,2, -3*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -3*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -3*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -3*1.55>}

// G row

object { oar rotate <0,0,-15> translate <1.5,2, -3*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -3*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -3*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -3*1.55>}

// H row

object { oar rotate <0,0,-15> translate <1.5,2, -4*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -4*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -4*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -4*1.55>}

// I row

object { oar rotate <0,0,-15> translate <1.5,2, -5*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -5*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -5*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -5*1.55>}

// J row

object { oar rotate <0,0,-15> translate <1.5,2, -6*1.55+0.775>}
object { oar rotate <0,180,15> translate <-1.5,2, -6*1.55+0.775>}

object { oar rotate <0,0,-7> translate <1.5,1.5, -6*1.55>}
object { oar rotate <0,180,7> translate <-1.5,1.5, -6*1.55>}

rotate <0,-70,0>
translate <45,5,10>
  }