#declare PENTAGRAM = union
{
cylinder { <-5.25, 0.5, 2.4>, <5.25, 0.5, 2.4>, 0.25 }
cylinder { <-5.25, 0.5, 2.4>, <3.75, 0.5, -4.25>, 0.25 }
cylinder { <3.84, 0.5, -4.34>, <0.0, 0.5, 5.75>, 0.25 }
cylinder { <0.0, 0.5, 5.75>, <-3.75, 0.5, -4.25>, 0.25 }
cylinder { <-3.84, 0.5, -4.34>, <5.25, 0.5, 2.4>, 0.25 }
torus { 6.0, 0.25 translate 0.5*y }
//pigment { Yellow }
}

/****************************/

#declare CarreauW = box
{
    <-1.0, 0.0, -1.0> <1.0, -0.5, 1.0>
    texture { T_Stone15 finish { reflection 0.5 } }
}
#declare CarreauB = box
{
    <-1.0, 0.0, -1.0> <1.0, -0.5, 1.0>
    texture { T_Stone6 finish { reflection 0.5 } }
}

#declare SerieCarreau = union {
#declare Nmax = 10.0
#declare Count = 1.0
#while (Count < Nmax)
       object { CarreauW translate -20.0*x translate 4*Count*x }
       object { CarreauB translate -22.0*x translate 4*Count*x }
       object { CarreauW translate -22.0*x translate 2*z translate 4*Count*x }
       object { CarreauB translate -20.0*x translate 2*z translate 4*Count*x }
#declare Count = Count + 1.0
#end
}

#declare Sol = union
{
#declare Zmax = 10.0
#declare COUNT = 1.0
#while (COUNT < Zmax)
       object { SerieCarreau translate 4*COUNT*z }
#declare COUNT = COUNT + 1.0
#end
}
/*********************/

#declare Marches = union
{
    difference
    {
        cylinder { <0.0, 0.0, 0.0>, <0.0, 0.25, 0.0>, 10.0 texture { T_Stone15 finish { reflection 0.5 } }}
        torus { 10.0, 0.1 translate 0.25*y texture { T_Stone6 finish { reflection 0.5 } }}
    }
    difference
    {
        cylinder { <0.0, 0.25, 0.0>, <0.0, 0.5, 0.0>, 8.0 texture { T_Stone15 finish { reflection 0.5 } }}
        torus { 8.0, 0.1 translate 0.5*y texture { T_Stone6 finish { reflection 0.5 } }}
        object { PENTAGRAM texture { T_Stone6 finish { reflection 0.5 } }}
    }
    cylinder { <0.0, 0.3, 0.0>, <0.0, 0.45, 0.0>, 6.5
           texture
           {
                pigment { color rgbt <1.0, 0.0, 0.0, 0.5> }
                normal { bumps 1.5 }
           }
         }
}

/*********************/

object { Sol translate -20.0*z translate 1.0*x }
object { Marches }
