// Persistence of Vision Ray Tracer Scene Description File
// File: imaginaire.pov
// Vers: 3.02
// Desc: Une Ame prisonnire
// Date: 22 Fevrier 1999
// Auth: Arnaud V avec la DeadGirl de Helene
///////////////////////////////////////////////////////////////
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "glass.inc"

//____INCLUDING SERIAL FILES TO RENDER____//

#include "Sol.inc"
#include "Decors.inc"
#include "Murs.inc"
//#include "BigHalo.inc"
#include "Energies.inc"
#include "DeadGirl.inc" //Photo conu par Helene
//________________________________________//

background { Blue }

camera
{
    //up <0.0, 1.0, 0.0>
    //right <16.0/9.0, 0.0, 0.0>
    //location <0.0, 20.0, -50.0>
    location <0.0, 5.0, -17.5>
    look_at <0.0, 0.0, 0.0>
    /*aperture 1.0
    blur_samples 50
    focal_point <0.0, 0.0, 0.0>*/
}

//light_source { <0.0, 5.0, -15.0> White }

#default
{
    finish
    {
        specular 0.35
        roughness 0.005
    }
}

/*fog
{
  distance 5
  fog_type 2
  fog_offset -1.20
  fog_alt 0.5
  turbulence 0.1
  turb_depth 0.2
  color <0.8, 0.0, 0.2>
}

fog
{
  distance 4
  fog_type 2
  fog_offset -1.20
  fog_alt 0.15
  turbulence 0.1
  turb_depth 0.2
  color <0.5, 0.5, 0.5>
}*/

/********************/

#declare Feu1 = cylinder { <0.0, 5.5, 0.0>, <0.0, 12.0, 0.0>, 3.0
    pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <1, 0, 0,  1> ]
        [ 0.5 color rgbt <1, 1, 0, -1> ]
        [ 1.0 color rgbt <1, 0, 0,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    scale <1.5, 0.75, 1.5>
    //pigment { Yellow }
             }

#declare Feu2 = cylinder { <0.0, 5.5, 0.0>, <0.0, 12.0, 0.0>, 3.0
               pigment { color rgbt <1, 1, 1, 1> }
    halo {
      emitting
      cylindrical_mapping
      linear
      turbulence 1.5
      color_map {
        [ 0.0 color rgbt <0, 0, 1,  1> ]
        [ 0.5 color rgbt <0, 0, 1, -1> ]
        [ 1.0 color rgbt <0, 0, 1,  1> ]
      }
      frequency 2
      samples 20
      scale 0.5
    }
    hollow
    scale <1.5, 0.75, 1.5>
             }

//light_source { <-16.0, 7.0, -15.0> color rgb <0.25, 0.25, 0.25> looks_like { object { Feu1 }}}
light_source { <-16.0, 7.0, 15.0> color rgb <0.25, 0.25, 0.0> looks_like { object { Feu1 }}}
light_source { <16.0, 7.0, -15.0> color rgb <0.25, 0.25, 0.25> looks_like { object { Feu1 }}}
light_source { <16.0, 7.0, 15.0> color rgb <0.0, 0.0, 0.25> looks_like { object { Feu2 }}}


