// Persistence of Vision Ray Tracer Scene Description File
// File: belong.pov
// Titl: I Really Don't Belong Here
// Vers: 3.1
// Desc: Competition image to IRTC. Topic: "Imaginary Worlds". See belong.txt for more info. 
// Date: 02/28/99 
// Auth: Tero Lindeman (xtmb@solutions.fi)



#include "colors.inc"
#include "tentacle.inc"
               
              
#declare tex2=texture {
                pigment {Orange}
                normal { granite 0.8 scale 1.0}
                finish {phong 1.0 phong_size 5 ambient 0}
                }               

#declare tex3=texture {
                pigment {color rgb <0.6,0.25,1> }
                normal { granite 0.6 scale 0.85}
                finish {phong 0.92 phong_size 8 ambient 0}
                }               

#declare tex3s=texture {
                pigment {color rgb <0.6,0.25,1> }
                normal { granite 0.6 scale 0.85}
                finish {phong 0.334 phong_size 8 ambient 0}
                }               


#declare tex3t=texture {
                pigment {color rgb <0.6,0.25,1>*0.5 }
                normal { granite 0.6 scale 0.85}
                finish {phong 0.4 phong_size 15 ambient 0 reflection 0.1}
                }               

#declare tex3tt=texture {
                pigment {color rgb <0.6,0.25,1>*0.15 }
                normal { granite 0.6 scale 0.85}
                finish {phong .6 phong_size 15 ambient 0 reflection 0.4}
                }               

#declare tex2b=texture {
                pigment {color rgb (<1,0.5,0>*5+<0.6,0.25,1>)/6}
                normal { granite 0.5 scale 1.5}
                finish {phong 1.0 phong_size 5 ambient 0}
                }               

#declare tex3b=texture {
                pigment {color rgb (<1,0.5,0>+<0.6,0.25,1>*5)/6 }
                normal { granite 0.6 scale 0.85}
                finish {phong 1.0 phong_size 5 ambient 0}
                }               

#declare levytexa=texture {
                
                pigment {onion
                  color_map { [0     rgbt <0.8,0.8,1,1  >] 
                              [0.6   rgbt <1.0,0.95,0.5,1  >]
                              [0.8  rgbt <1.0, .85, .4,0.15>]
                              [1     rgbt <1.0,0.8,0.5,1  >] 
                            }     
                    
                                  
                }
                
                pigment {onion
                  color_map { [0     rgbt <0.8,0.8,1,1  >] 
                              [0.6   rgbt <1.0,0.0,0.75,1  >]
                              [0.8  rgbt <.9, .4, 1.0,0.2>]
                              [1     rgbt <1.0,0.0,1.0,1  >] 
                            }
                            
                  turbulence <0,0.1,0>         
                  translate <0,0.05,0>
                                                    
                }
                
                normal { bumps 0.3 scale 0.015 translate <0,0.05,0>}
                finish {phong 0.85 phong_size 6 ambient 0}
                }               
#declare levytexb=texture {
                
                pigment {onion
                  color_map { [0     rgbt <0.8,0.8,1,1  >] 
                              [0.6   rgbt <1.0,0.95,0.5,1  >]
                              [0.8  rgbt <1.0, .85, .4,0.15>]
                              [1     rgbt <1.0,0.8,0.5,1  >] 
                            }     
                    
                                  
                }
                
                pigment {onion
                  color_map { [0     rgbt <0.8,0.8,1,1  >] 
                              [0.6   rgbt <1.0,0.0,0.75,1  >]
                              [0.8  rgbt <.9, .4, 1.0,0.2>]
                              [1     rgbt <1.0,0.0,1.0,1  >] 
                            }
                            
                  turbulence <0,0.1,0>         
                  translate <0,0.05,0>
                                                    
                }
                
                normal { bumps 0.3 scale 0.015 translate <0,0.05,0>}
                finish {phong 0.0 phong_size 6 ambient 0}
                }               

#declare levytex=texture{
    onion
    texture_map {
      [0 levytexb]
      [0.6 levytexb]
      [0.8 levytexa]
      [1 levytexb]
     }
}

#declare R1=seed(42);
#declare cam_loc=<-5,1,15>;

#declare particle=box {-0.25,0.25 texture {tex3b}}
#declare particle2=box {-0.25,0.25 texture {tex2b}}
                                                
#declare planet=union{
        disc{0,y,1,0.5 texture{levytex}scale 14 hollow}
                  
          
        union {
        sphere {0,2 texture { tex2 }}
            
                     
         
        /* spikes */
        #declare R1=seed(42);
        #declare i=0;
        #while (i<40)
          #declare i=i+1;
         
          #declare pos=vnormalize(<rand(R1)-0.5,rand(R1)-0.5,rand(R1)-0.5>)*2*(3+rand(R1)*0.667);
          #declare pos=<int(pos.x)/2,int(pos.y)/2,int(pos.z)/2>;
          cone {0,0.75+rand(R1)*0.5,pos,0 texture { tex3 }}
                           
        #end
                 
        /* rocks */
        #declare i=0;
        #while (i<250)
          #declare i=i+1;
         
          #declare pos=vnormalize(<rand(R1)-0.5,rand(R1)-0.5,rand(R1)-0.5>)*2;
          object  {particle scale (0.15+rand(R1)*0.2)*.8 rotate<rand(R1)*360,rand(R1)*360,rand(R1)*360>translate pos}
          
        #end
       
        #declare i=0;
        #while (i<400)
          #declare i=i+1;
         
          #declare pos=vnormalize(<rand(R1)-0.5,rand(R1)-0.5,rand(R1)-0.5>)*2;
          object  {particle2 scale (0.25+rand(R1)*0.2)*.8 rotate<rand(R1)*360,rand(R1)*360,rand(R1)*360>translate pos}
          
        #end
        
            
        }   
        

}
         
                
        
sky_sphere {

    pigment {   
      granite
      color_map {
        [   0 color rgb <0,0,0>]
        [  .8 color rgb <0,0,0>]
        [  .9 color rgb <1,1,1>]
        [ 1.0 color rgb <1,1,1>]
      }
      scale 0.025 
      
     }
    
    pigment {
      crackle
      color_map {
        [ 0 color rgb <0.541,0.008,0.871>*0.015*4 filter 0.99]
        [ 1.0 color rgb <0.541,0.008,0.871>*0.15*4 filter 0.5]
      }
      scale <0.6,0.15,0.6>
      turbulence 0.6     
      rotate <0,0,15>
    }
    pigment {
      gradient y
      color_map {
        [ 0 color rgb <0,0,0>*0.015*4 filter 0.99]
        [ 1 color rgb Orange*0.15*4 filter 0.35]   // Gives a warning?
      }      
      translate <0,0.20,0>
      scale 2.5
      turbulence 0.6     
      rotate <0,0,15+90>
    } 
    
    pigment {   
      radial
      color_map {
        [   0  color rgbf <1,0,1,1>]
        [  .96 color rgbf <1,0,1,1>]
        [  .98 color rgbf <1,0,1,0.85>]
        [ 1.0  color rgbf <1,0,1,1>]
      }
      frequency 20
       
      scale 0.2
      rotate <0,0,90>
      
     }
    
    pigment {   
      radial
      color_map {
        [   0  color rgbf <1,0,1,1>]
        [  .95 color rgbf <1,0,1,1>]
        [  .975 color rgbf <1,0,1,0.90>]
        [ 1.0  color rgbf <1,0,1,1>]
      }
      frequency 100
       
      scale 0.2
      rotate <0,0,90>
      
     }
    
    pigment {   
      radial
      color_map {
        [   0  color rgbf <1,0,1,1>]
        [  .95 color rgbf <1,0,1,1>]
        [  .975 color rgbf <1,0,1,0.90>]
        [ 1.0  color rgbf <1,0,1,1>]
      }
      frequency 100
       
      scale 0.2
      rotate <0,0,0>
      
     }
    
    
    pigment {   
      radial
      color_map {
        [   0  color rgbf <1,0,1,1>]
        [  .96 color rgbf <1,0,1,1>]
        [  .98 color rgbf <1,0,1,0.85>]
        [ 1.0  color rgbf <1,0,1,1>]
      }     
      frequency 20
               
      scale 0.2
      
     }

    
      
} 
              
   
   // Note: Lnsefcts.inc is modified to give 2:1 aspect ratio (it sets the camera). (Not included)
                       
   #declare effect_type="Sun"
   #declare options_only = true; #include "Lens.inc"
   #declare camera_location = cam_loc;
   #declare camera_look_at = <0, 0, 0>; 
   #declare effect_location = <16,6,0>;  
   #declare effect_color = <1,.5,.767>;  
   #declare glow_scale = <2.5,2.5,2.5>;  
   #declare rays_scale = <8,8,8>;  
   #declare rays_type = 5;         
   #declare source_color = <1,1,1>*1.5;         
                      
   #include "lnsefcts.inc"
   
                  
                      
     


/*camera {    // 2:1 aspect ratio
    location cam_loc
    right <2,0,0>
    up <0,1,0>
    look_at <0,0,0>    
    
} */
                                                                  
        
object { planet scale 1.25 rotate <0,-25,-10> translate <-9,-4,-8> }
                                           
uglyblob(<30,-7.5,-20>,4,tex2,tex3s,42,0,60,2,0.25)
uglyblob(<-20,4.5,-60>,4,tex3t,tex3tt,69,1,60,3,0.1)
uglyblob(<15,4.5,-70>,3,tex3,tex3tt,342,0.6,80,3,0.1)

light_source {<50,40,100>*100 color rgb <1,1,1> }
light_source {vnormalize(effect_location-cam_loc)*10000+cam_loc color rgb <.3,.1,0> }
  

