// tentacle.inc for belong.pov

#declare dens=1; // Change this for speed                     

#macro w(i)
  sin(radians(i))*cos(90-radians(i)*.85)*sin(-radians(i)*3.5)
#end

#macro tentacle(start,sdir,ql,obj,ofs,g,m,m2)
  #local pos=start;
  #local dir=sdir;          
  #local l=ql;
  #local fdir=vnormalize(<0.5,-0.3,-0.7>);
  #local sl=l;
  #local Q=5.0; // quantum curvature of space
  
  #while (l>0)
    #local l=l-dens;                       
    #local k=(sl*0.75-vlength(pos-start))/(sl*0.75);
    #if (k<0) #local k=0; #end
    #if (k>1) #local k=1; #end
    #local k2=1-((sl-l)/sl);
    #if (k2<0) #local k2=0; #end
    #if (k2>1) #local k2=1; #end
    #local k3=k2*k2;
    
    #local dir=vrotate(dir,<w(i+pos.y*Q+ofs),w(pos.x*Q-i+ofs),w(pos.z*Q+i+ofs)>*dens*15);
    #local epos=pos;
    #local pos=pos+dir*<1,(1-k3)*g+k3,1>;
    cylinder{pos,epos,m2+k3*m,1}
  #end
                                               
  
#end

#macro uglyblob(pos,tentacles,tex,tex2,s,g,l,m,m2)
blob {
  threshold 0.75
  #local R=seed(s);
  #local tt=tentacles;
  #while (tentacles>0) 
    #local tentacles=tentacles-1;                    
    #local dir=vnormalize(<rand(R)-0.5,rand(R)-0.5,rand(R)-0.5>)*dens;
    #debug concat("Tentacles left: ",str(tentacles,0,0),"\r")
    tentacle(pos,dir,l,sphere{0,0.5},tentacles/tt*80*15,g,m,m2)
  #end                                                           
  #debug concat("\r\n")
    
  
  sphere{pos,2.5,1}                  
  
  texture {
    bozo
    texture_map {
      [0 tex]
      [0.5 tex2]
      [1 tex]
    }         
  scale 5
  }
    
}
#end
