#local rad=.5;
#local fac=.02;
#local sl=.01;
#local ys=.05; 
#local steps=46;
#local bas=360/steps;
#local as=bas/3;

#if (capdetail)                   

  #local cap_part=union {
    #local i=0;
    #while (i<steps)  
      #local ang=i*bas;
      bicubic_patch {
        type 1
        u_steps 4 v_steps 4
        #local X=0;
        #while (X<4)
          #local Y=0;
          #while (Y<4)   
            #local lrad=rad+sl*Y;
            
            #if ((X=1 | X=2)&(Y>0))
              #if ( mod(i,2) ) 
                #local lrad=lrad+fac*(Y-1);
              #else
                #local lrad=lrad-fac*(Y-1);
              #end 
            #end
            
            vrotate (lrad*x, (ang+as*X)*y)+ys*Y*y
            #local Y=Y+1;
          #end
          #local X=X+1;
        #end
      }  
      
      bicubic_patch {
        type 1
        u_steps 3 v_steps 3
        #local X=0;
        #while (X<4)
          #local Y=0;
          #while (Y<4)   
            #if ((Y<2))
              vrotate ((rad-(2.5-Y)*sl)*x, (ang+as*X)*y) -ys*y
            #else
              #local lrad=rad+sl*.5*(Y-3);
              vrotate (lrad*x, (ang+as*X)*y)+(ys*.5*(Y-3))*y
            #end
            
            #local Y=Y+1;
          #end
          #local X=X+1;
        #end
      }
      
      bicubic_patch {
        type 1
        u_steps 3 v_steps 3
        #local X=0;
        #while (X<4)
          #local Y=0;
          #while (Y<4)   
            #local lrad=(rad-2.5*sl)*((Y+.001)/3.001);
            vrotate (lrad*x, (ang+as*X)*y)-ys*y
           
            #local Y=Y+1;
          #end
          #local X=X+1;
        #end
      }
        
      #local i=i+1;
    #end
  }  
#else
  #local cap_part=lathe{
     3,
     -ys*y,
     (rad-1.5*sl)*x-ys*y,
     (rad+3*sl)*x+3*ys*y

  }
#end

#macro pea(sd)
  blob{
    threshold 0.01
    sphere {0, .15, 1}
    #if (capdetail)
      #local i=0;
      #while (i<20)
        #local lg=rand(sd)*360;
        #local lt=rand(sd)*180-90;
        sphere { vrotate( .25*z, <lt,lg,0>), .15,-.4 }
        #local i=i+1;
      #end   
    #end
    texture {pigment {color rgb <.5,1,.2>} finish {ambient .2 specular .2 roughness .02}}
  } 
#end

#declare cap=union {
  union {
    object {
      cap_part
      texture {
        pigment {color rgbt <1,.1,0,.1>}
        #if (capdetail)
          finish {ambient .2 specular .4 roughness .02 phong .2 diffuse .3}
        #end
      }
    }
    object {
      cap_part 
      scale .99
      texture {
        pigment {color rgb <1,1,.5>} 
        #if (capdetail)
          finish {ambient .2 reflection .3*<1,1,.5> specular .3 roughness .1 phong .4 diffuse .1}
        #end
      }
    }
    rotate (as/3)*y 
    translate ys*y
  }
  #local sd=seed(25132);
  object {pea(sd) translate <.15,.15,.15>}
  object {pea(sd) translate <.05,.15,-.15>}
  object {pea(sd) translate <.30,.15,0>}
}

/*
plane {y,0 texture {pigment {checker rgb 0, rgb 1} scale .1}}
object {cap}
camera {location y-z look_at 0}  
light_source {<-12,12,-12> rgb 1}
*/