
#local RoughWood=texture {
  #if (roofdetail)
    pigment {gradient x 
           color_map {
             [0 rgb <80,30,10>/255]
             [1 rgb <80,50,10>/255]
           }
          turbulence .1
          }
    finish {ambient .1 diffuse .8 phong .1 specular 0}
    normal {gradient x .5 turbulence .1}
    rotate 45*z scale .4
  #else
    pigment {color rgb <80,30,10>/255}
  #end
}                   

#local floorboards=union {
  #if (roofdetail)
    #declare C=0;
    #while (C<20)
      box {
        <-100,20,42> <100,20.4,38>
        texture {RoughWood scale .7 rotate 90*y translate 100*C*(y+z)}
        translate -4.2*z*C 
      }
      #declare C=C+1;
    #end
  #else
    box {<-100,20,42> <100,21,-42> texture {RoughWood}}
  #end
}  
  
#local joists=union {
  #declare C=-3;
  #while (C<4)
    box { <-1,10,-40>, <1,20,40> translate 16*x*C}
    #declare C=C+1;
  #end
  
  texture {RoughWood}
}

#local roof=union {
  object {floorboards}
  object {joists}
  //beam                                
  box {<-100,10,40> <100,20,42> texture {RoughWood rotate 90*y} }
}

#local Cardboard=texture {
  pigment {color rgb <179,113,64>/255 }
  #if (floordetail)
    finish {ambient .3 diffuse .8 phong .1 specular 0}
    normal {gradient x .1 sine_wave scale .6}
  #end
}

#local littlefloor=union {
  box {<-100,-1,400> <3,0,-400>}
  box {<3.5,-1,400> <100,0,-400>}
  #if (floordetail) 
    cylinder {<3,-.2,400> <3,-.2,-400> .2}
    cylinder {<3.5,-.2,400> <3.5,-.2,-400> .2}
    difference {
      plane {y, -.2*(1-sqrt(2)/2) }
      cylinder {<3.25,.05,400> <3.25,.05,-400> .25*sqrt(2)-.2 }
    }
  #end
  texture {Cardboard}
}

#local wallpart=difference {
  box {
    <-100,-2,-1> <100,10,0> 
    texture {
      pigment {color rgb <.7,.7,.8>}
      #if (walldetail)
        normal {bozo .2 
          slope_map { 
            [ 0 <.5, .2>]
            [ .1 <1, 0>]
            [.9 <1, 0>]
            [1 <.5, -.2>]
          }
          scale .125
        }
      #end
    }
  }
  #if (walldetail) 
    cylinder {<-100,4,.4><100,4,.4> .5}
    #declare C=-5;
    #while (C<5)
      cylinder {<12*C,4,.4> <12*C,10,.4> .5}
      cylinder {<6+12*C,4,.4> <6+12*C,-2,.4> .5}
      #declare C=C+1;
    #end
  #end
  texture {pigment {color rgb <.7,.7,.8>}}
}

#local wall=union {
  object {wallpart rotate 180*y translate 40.5*z translate 47.5*x}
  object {wallpart rotate -90*y translate 47.5*x translate 46.5*z}
}

#declare room=union {
  object {roof translate <-40,-3,-28>}
  object {wall translate <-40,-3,-28>}
  object {littlefloor}
}