#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <-25,6,20>
	look_at <-25,6,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end



#local nBooks = 32;

// height, width, fontSize
#local Dimensions = array[nBooks][3] {
	{8, 3, 0.4}	// POV-Ray
	{9, 2, 0.1}	// MacOS Guide
	{8.5, 2, 0.1}	// BBEdit User's Guide

	{12, 2, 0.4}	// Incunabula of Mazarin
	{10, 4, 0.5}	// Tome of Power

	{12, 1.5, 0.4}	// Spell Law
	{12, 1.5, 0.4}	// Arms Law
	{12, 1.5, 0.4}	// Rolemaster Standard Rules
	{12, 1.5, 0.4}	// GM Law
	{12, 1.5, 0.4}	// Black Ops
	{12, 1.5, 0.4}	// Pulp Adventures
	{12, 1.5, 0.4}	// Shades of Darkness
	{12, 1.5, 0.4}	// Essence Companion
	{12, 1.5, 0.4}	// Channelling Companion
	{12, 1.5, 0.4}	// Mentalism Companion
	{12, 1.5, 0.4}	// Arcane Companion
	{12, 1.5, 0.4}	// Martial Arts Companion
	{12, 1.5, 0.4}	// Weapon Law
	{12, 1.5, 0.4}	// Treasure Companion
	{12, 1.5, 0.4}	// Castles & Ruins
	{12, 1.5, 0.4}	// Creatures & Monsters

	{13, 3, 0.5}	// Care and Feeding of Goblins
	{11, 4, 0.5}	// 1999 Uniform Tax Code
	{9, 3, 0.3}	// Loremaster Annual
	{10, 3, 0.3}	// Felines Unlimited
	{8.5, 2, 0.4}	// Why Me?
	{14, 5, 0.4}	// Spells For Dummies
	{13, 2, 0.1}	// Playboy's Gnomes of Summer
	{10, 3, 0.3}	// Flora of Kulthea
	{10, 3, 0.3}	// Fauna of Kulthea
	{10, 3, 0.3}	// Faera of Kulthea
	{12, 4, 0.6}	// RMFRP
}

// cover texture, title + band texture
#local Textures = array[nBooks][2] {
	{texture{T_darkblueleather}, texture {pigment{Black}} }
	{texture{T_darkbrownleather}, texture {pigment{Black}} }
	{texture{T_verydarkblueleather}, texture {pigment{Black}} }

	{texture{T_bloodleather}, texture {T_Gold_1A} }
	{texture{T_darkgreenleather1}, texture {pigment{Black}} }

	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
	{texture{T_ironcrown}, texture {pigment{White}} }

	{texture{T_bloodleather}, texture {pigment{Black}} }
	{texture{T_darkgreenleather}, texture {pigment{Magenta}} }
	{texture{T_aqualeather}, texture {pigment{Black}} }
	{texture{T_blueleather}, texture {pigment{Black}} }
	{texture{T_grayleather}, texture {pigment{Black}} }
	{texture{T_bloodleather}, texture {T_Gold_1A} }
	{texture{T_blueleather}, texture {pigment{Blue}} }
	{texture{T_darkgreenleather}, texture {pigment{Black}} }
	{texture{T_darkgreenleather}, texture {pigment{Black}} }
	{texture{T_darkgreenleather}, texture {pigment{Black}} }
	{texture{T_ironcrown}, texture {pigment{White}} }
}

// book title, font
#local Titles = array[nBooks][2] {
	{"POV-Ray", "CYRVETIC.TTF"}
	{"MacOS", "CYRVETIC.TTF"}
	{"BBEdit", "TIMROM.TTF"}

	{"Incunabula", "MERO_DEM.TTF"}
	{"Tome Of Power", "TIMROM.TTF"}

	// Iron Crown Enterprises Rolemaster rulebooks.
	{"Spell Law", "CRYSTAL.TTF"}
	{"Arms Law", "CRYSTAL.TTF"}
	{"Rolemaster", "CRYSTAL.TTF"}
	{"GM Law", "CRYSTAL.TTF"}
	{"Black Ops", "CRYSTAL.TTF"}
	{"Pulp Adventures", "CRYSTAL.TTF"}
	{"Shades of Darkness", "CRYSTAL.TTF"}
	{"Essence", "CRYSTAL.TTF"}
	{"Channelling", "CRYSTAL.TTF"}
	{"Mentalism", "CRYSTAL.TTF"}
	{"Arcane", "CRYSTAL.TTF"}
	{"Martial Arts", "CRYSTAL.TTF"}
	{"Weapon Law", "CRYSTAL.TTF"}
	{"Treasure", "CRYSTAL.TTF"}
	{"Castles & Ruins", "CRYSTAL.TTF"}
	{"Creatures & Monsters", "CRYSTAL.TTF"}

	// nonsense works
	{"Care and Feeding of Goblins", "klang.ttf"}
	{"Uniform Tax Code", "CRYSTAL.TTF"}
	{"Loremaster Annual", "klang.ttf"}
	{"Felines Unlimited", "klang.ttf"}
	{"Why me?", "CYRVETIC.TTF"}
	{"Spells For Dummies", "MERO_DEM.TTF"}
	{"Playboy's Gnomes of Summer", "klang.ttf"}
	{"Flora of Kulthea", "CRYSTAL.TTF"}
	{"Fauna of Kulthea", "CRYSTAL.TTF"}
	{"Faera of Kulthea", "CRYSTAL.TTF"}

	{"RMFRP", "CYRVETIC.TTF"}
}

// translation for the titles
#local TitleTrans = array[nBooks] {
	<0.3, 6, 0.5>		// POV-Ray
	<0.2, 6, 0.5>		// MacOS Guide
	<0.2, 6.1, 0.5>		// BBEdit User's Guide

	<0.4, 9.5, 0.5>		// Incunabula of Mazarin
	<0.5, 8, 0.51>		// Tome of Power

	<0.15, 8, 0.51>		// Spell Law
	<0.15, 7.7, 0.51>	// Arms Law
	<0.15, 8.2, 0.51>	// Rolemaster Standard Rules
	<0.15, 7.2, 0.51>	// GM Law
	<0.15, 7.7, 0.51>	// Black Ops
	<0.15, 9.2, 0.51>	// Pulp Adventures
	<0.15, 9.9, 0.51>	// Shades of Darkness
	<0.15, 7.3, 0.51>	// Essence Companion
	<0.15, 8.2, 0.51>	// Channelling Companion
	<0.15, 7.8, 0.51>	// Mentalism Companion
	<0.15, 7.0, 0.51>	// Arcane Companion
	<0.15, 8.6, 0.51>	// Martial Arts Companion
	<0.15, 7.7, 0.51>	// Weapon Law
	<0.15, 7.3, 0.51>	// Treasure Companion
	<0.15, 9.0, 0.51>	// Castles & Ruins
	<0.15, 11.0, 0.51>	// Creatures & Monsters

	<0.3, 12.0, 0.51>	// Care and Feeding of Goblins
	<0.3, 9.5, 0.51>	// 1999 Uniform Tax Code
	<0.2, 8.2, 0.51>	// Loremaster Annual
	<0.2, 8.2, 0.51>	// Felines Unlimited
	<0.2, 5.9, 0.51>	// Why Me?
	<0.4, 13.0, 0.51>	// Spells For Dummies
	<0.15, 12.6, 0.51>	// Playboy's Gnomes of Summer
	<0.2, 9.0, 0.52>	// Flora of Kulthea
	<0.2, 9.0, 0.52>	// Fauna of Kulthea
	<0.2, 9.0, 0.52>	// Faera of Kulthea
	<0.15, 7.2, 0.51>	// RMFRP
}


#declare Books1 = union {

#local X = 36;
#local N = 0;

#while ( N < nBooks )
	#local Height = Dimensions[N][0];
	#local Width = Dimensions[N][1];
	#local Width2 = Width/2;
	#local Length = 10.0;
	#local T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#local T_title = Textures[N][1]
		#local Title = Titles[N][0]
		#local Font = Titles[N][1]
		#local Trans = TitleTrans[N];
		#local FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title FontSize, 0
			rotate <0,180,90>
			translate Trans
			texture { T_title }
		}

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#local N = N + 1;
	#local X = X - Width;
#end

}

#if (TestRender)
object { Books1 }
#end

#version Temp_Vers;
