#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 * A Loremaster secret: the Time/Life Books of Forgotten Lore series.
 * Just $19.95 per book!
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <-25,9,23>
	look_at <-25,9,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end



#local nBooks = 24;

// height, width, fontSize
#local Dimensions = array[nBooks][3] {
	{16, 3, 0.8}	// A
	{16, 3, 0.8}	// B
	{16, 3, 0.8}	// C
	{16, 3, 0.8}	// D
	{16, 3, 0.8}	// E
	{16, 3, 0.8}	// F
	{16, 3, 0.8}	// G
	{16, 3, 0.8}	// H
	{16, 3, 0.8}	// I
	{16, 3, 0.8}	// J
	{16, 3, 0.4}	// K
	{16, 3, 0.4}	// L
	{16, 3, 0.4}	// M
	{16, 3, 0.4}	// N
	{16, 3, 0.4}	// O
	{16, 3, 0.4}	// P
	{16, 3, 0.4}	// QR
	{16, 3, 0.4}	// S
	{16, 3, 0.4}	// T
	{16, 3, 0.4}	// UV
	{16, 3, 0.4}	// W
	{16, 3, 0.4}	// X
	{16, 3, 0.4}	// Y
	{16, 3, 0.4}	// Z
}

// cover texture, title + band texture
#local Textures = array[nBooks][2] {
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
	{texture{T_agedleather}, texture {T_Gold_1A} }
}

// book title, font
#local Titles = array[nBooks][2] {
	{"Forgotton Lore: A", "CRYSTAL.TTF"}
	{"Forgotton Lore: B", "CRYSTAL.TTF"}
	{"Forgotton Lore: C", "CRYSTAL.TTF"}
	{"Forgotton Lore: D", "CRYSTAL.TTF"}
	{"Forgotton Lore: E", "CRYSTAL.TTF"}
	{"Forgotton Lore: F", "CRYSTAL.TTF"}
	{"Forgotton Lore: G", "CRYSTAL.TTF"}
	{"Forgotton Lore: H", "CRYSTAL.TTF"}
	{"Forgotton Lore: I", "CRYSTAL.TTF"}
	{"Forgotton Lore: J", "CRYSTAL.TTF"}
	{"Forgotton Lore: K", "CRYSTAL.TTF"}
	{"Forgotton Lore: L", "CRYSTAL.TTF"}
	{"Forgotton Lore: M", "CRYSTAL.TTF"}
	{"Forgotton Lore: N", "CRYSTAL.TTF"}
	{"Forgotton Lore: O", "CRYSTAL.TTF"}
	{"Forgotton Lore: P", "CRYSTAL.TTF"}
	{"Forgotton Lore: QR", "CRYSTAL.TTF"}
	{"Forgotton Lore: S", "CRYSTAL.TTF"}
	{"Forgotton Lore: T", "CRYSTAL.TTF"}
	{"Forgotton Lore: UV", "CRYSTAL.TTF"}
	{"Forgotton Lore: W", "CRYSTAL.TTF"}
	{"Forgotton Lore: X", "CRYSTAL.TTF"}
	{"Forgotton Lore: Y", "CRYSTAL.TTF"}
	{"Forgotton Lore: Z", "CRYSTAL.TTF"}
}

// translation for the titles
#local TitleTrans = array[nBooks] {
	<0.3, 14, 0.56>		// A
	<0.3, 14, 0.55>		// B
	<0.3, 14, 0.55>		// C
	<0.3, 14, 0.55>		// D
	<0.3, 14, 0.55>		// E
	<0.3, 14, 0.55>		// F
	<0.3, 14, 0.55>		// G
	<0.3, 14, 0.55>		// H
	<0.3, 14, 0.55>		// I
	<0.3, 14, 0.55>		// J
	<0.3, 14, 0.55>		// K
	<0.3, 14, 0.55>		// L
	<0.3, 14, 0.55>		// M
	<0.3, 14, 0.55>		// N
	<0.3, 14, 0.55>		// O
	<0.3, 14, 0.55>		// P
	<0.3, 14.4, 0.55>		// QR
	<0.3, 14, 0.55>		// S
	<0.3, 14, 0.55>		// T
	<0.3, 14.4, 0.55>		// UV
	<0.3, 14, 0.55>		// W
	<0.3, 14, 0.55>		// X
	<0.3, 14, 0.55>		// Y
	<0.3, 14, 0.55>		// Z
}


#declare Books2 = union {

#local X = 36;
#local N = 0;

#while ( N < nBooks )
	#local Height = Dimensions[N][0];
	#local Width = Dimensions[N][1];
	#local Width2 = Width/2;
	#local Length = 10.0;
	#local T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#local T_title = Textures[N][1]
		#local Title = Titles[N][0]
		#local Font = Titles[N][1]
		#local Trans = TitleTrans[N];
		#local FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title FontSize, 0
			scale 1.4
			rotate <0,180,90>
			translate Trans
			texture { T_title }
		}

		torus { Width2, 0.1
			translate <0,1,0>
			scale <1,1,0.5>
			texture { T_title }
		}
		torus { Width2, 0.1
			translate <0,Height-1,0>
			scale <1,1,0.5>
			texture { T_title }
		}

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#local N = N + 1;
	#local X = X - Width;
#end

}

#if (TestRender)
object { Books2 }
#end

#version Temp_Vers;
