#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 * As it happens, Edwin is a huge SciFi fan.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <-22,7,25>
	look_at <-22,7,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end


#local nBooks = 24;

// height, width, fontSize
#local Dimensions = array[nBooks][3] {
	{18,   2, 0.2}		// The Cat Who Walks Through Walls
	{17,   3, 0.25}		// The Moon is a Harsh Mistress
	{18,   4, 0.2}		// The Notebooks of Lazarus Long
	{12,   2, 0.2}		// Revolt in 2100
	{13,   3, 0.2}		// Methuselah's Children
	{10,   2, 0.2}		// Between Planets
	{15,   3, 0.2}		// Citizen of the Galaxy
	{14,   2, 0.2}		// Farmer in the Sky
	{9,    3, 0.2}		// Friday
	{15,   2, 0.2}		// Have Spacesuit Will Travel
	{14,   4, 0.2}		// I Will Fear No Evil
	{17,   3, 0.2}		// The Number of the Beast
	{14,   3, 0.2}		// The Puppet Masters
	{15,   2, 0.2}		// Red Planet
	{12,   2, 0.2}		// Space Cadet
	{14,   2, 0.2}		// Starship Troopers
	{16,   5, 0.2}		// Stranger in a Strange Land
	{14,   3, 0.2}		// Time Enough for Love
	{15,   4, 0.2}		// Magic, Inc
	{13,   2, 0.2}		// The Menace from Earth
	{15,   4, 0.2}		// 2001: A Space Odyssey
	{15,   4, 0.2}		// 2010: Odyssey Two
	{15,   4, 0.2}		// 2061: Odyssey Three
	{15,   4, 0.2}		// 3001: The Final Odyssey
}

// cover texture, title + band texture
#local Textures = array[nBooks][2] {
	{texture{T_brownleather}, texture {T_Gold_3B} } // The Cat ... Walls
	{texture{T_darkredleather}, texture {T_Gold_1B} } // The Moon ... Mistress
	{texture{T_brownleather}, texture {T_Gold_1A} } // The Notebooks ... Long
	{texture{T_agedleather}, texture {T_Gold_1A} } // Revolt in 2100
	{texture{T_agedleather}, texture {T_Gold_5C} } // Methuselah's Children
	{texture{T_ironcrown}, texture {T_Gold_4C} } // Between Planets
	{texture{T_blackleather}, texture {T_Gold_1A} } // Citizen of the Galaxy
	{texture{T_redleather}, texture {T_Gold_1A} } // Farmer in the Sky
	{texture{T_darkblueleather}, texture {pigment {Black}} } // Friday
	{texture{T_brownleather}, texture {T_Gold_1A} } // Have Spacesuit Will Travel
	{texture{T_agedleather}, texture {T_Gold_1A} } // I Will Fear No Evil
	{texture{T_blackleather}, texture {T_Gold_5A} } // The Number of the Beast
	{texture{T_darkredleather}, texture {T_Gold_1A} } // The Puppet Masters
	{texture{T_redleather}, texture {T_Gold_1A} } // Red Planet
	{texture{T_agedleather}, texture {T_Gold_2C} } // Space Cadet
	{texture{T_darkredleather}, texture {pigment{Black}} } // ... Troopers
	{texture{T_darkredleather}, texture {T_Gold_1A} } // Stranger ... Land
	{texture{T_bloodleather}, texture {pigment{Brown}} } // Time Enough for Love
	{texture{T_blackleather}, texture {T_Gold_1A} } // Magic, Inc
	{texture{T_blueleather}, texture {T_Gold_1A} } // The Menace from Earth
	{texture{T_blackleather}, texture {T_Gold_1A} } // 2001: A Space Odyssey
	{texture{T_blackleather}, texture {T_Gold_1A} } // 2010: Odyssey Two
	{texture{T_blackleather}, texture {T_Gold_1A} } // 2061: Odyssey Three
	{texture{T_blackleather}, texture {T_Gold_1A} } // 3001: The Final Odyssey
}

// book title, font
#local Titles = array[nBooks][2] {
	{"The Cat Who Walks Through Walls", "CRYSTAL.TTF"}
	{"The Moon is a Harsh Mistress", "CRYSTAL.TTF"}
	{"The Notebooks of Lazarus Long", "CRYSTAL.TTF"}
	{"Revolt in 2100", "CRYSTAL.TTF"}
	{"Methuselahs Children", "CRYSTAL.TTF"}
	{"Between Planets", "CRYSTAL.TTF"}
	{"Citizen of the Galaxy", "CRYSTAL.TTF"}
	{"Farmer in the Sky", "CRYSTAL.TTF"}
	{"Friday", "CRYSTAL.TTF"}
	{"Have Spacesuit Will Travel", "CRYSTAL.TTF"}
	{"I Will Fear No Evil", "CRYSTAL.TTF"}
	{"The Number of the Beast", "CRYSTAL.TTF"}
	{"The Puppet Masters", "CRYSTAL.TTF"}
	{"Red Planet", "CRYSTAL.TTF"}
	{"Space Cadet", "CRYSTAL.TTF"}
	{"Starship Troopers", "CRYSTAL.TTF"}
	{"Stranger in a Strange Land", "CRYSTAL.TTF"}
	{"Time Enough for Love", "CRYSTAL.TTF"}
	{"Magic, Inc", "CRYSTAL.TTF"}
	{"The Menace from Earth", "CRYSTAL.TTF"}
	{"2001: A Space Odyssey", "CRYSTAL.TTF"}
	{"2010: Odyssey Two", "CRYSTAL.TTF"}
	{"2061: Odyssey Three", "CRYSTAL.TTF"}
	{"3001: The Final Odyssey", "CRYSTAL.TTF"}
}

// translation for the titles
#local TitleTrans = array[nBooks] {
	<0.3, 17.0, 0.55>	// The Cat Who Walks Through Walls
	<0.3, 15.5, 0.55>	// The Moon is a Harsh Mistress
	<0.3, 16.5, 0.55>	// The Notebooks of Lazarus Long
	<0.3, 9, 0.55>		// Revolt in 2100
	<0.3, 11.5, 0.55>	// Methuselah's Children
	<0.3, 8.9, 0.55>	// Between Planets
	<0.3, 13, 0.55>		// Citizen of the Galaxy
	<0.3, 11, 0.55>		// Farmer in the Sky
	<0.3, 6, 0.55>		// Friday
	<0.3, 14, 0.55>		// Have Spacesuit Will Travel
	<0.3, 11.5, 0.55>	// I Will Fear No Evil
	<0.3, 14, 0.55>		// The Number of the Beast
	<0.3, 11.5, 0.55>	// The Puppet Masters
	<0.3, 9.5, 0.55>	// Red Planet
	<0.3, 8.5, 0.55>	// Space Cadet
	<0.3, 11.4, 0.55>	// Starship Troopers
	<0.3, 14.6, 0.55>	// Stranger in a Strange Land
	<0.3, 12, 0.55>		// Time Enough for Love
	<0.3, 9.5, 0.55>	// Magic, Inc
	<0.3, 12, 0.55>		// The Menace From Earth
	<0.3, 12.5, 0.55>	// 2001: A Space Odyssey
	<0.3, 11.5, 0.55>	// 2010: Odyssey Two
	<0.3, 12, 0.55>		// 2061: Odyssey Three
	<0.3, 13.5, 0.55>	// 3001: The Final Odyssey
}


#declare Books4 = union {

#local X = 36;
#local N = 0;

#while ( N < nBooks )
	#local Height = Dimensions[N][0];
	#local Width = Dimensions[N][1];
	#local Width2 = Width/2;
	#local Length = 10.0;
	#local T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#local T_title = Textures[N][1]
		#local Title = Titles[N][0]
		#local Font = Titles[N][1]
		#local Trans = TitleTrans[N];
		#local FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title FontSize, 0
			rotate <0,180,90>
			translate Trans
			texture { T_title }
		}

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#local N = N + 1;
	#local X = X - Width;
#end

}

#if (TestRender)
object { Books4 }
#end

#version Temp_Vers;
