#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A row of books, suitable for use with the Bookshelf model.
 * These are Edwin's references on topics magical.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "golds.inc"
#include "booktextures.inc"

camera {
	location <-22,7,25>
	look_at <-22,7,0>
}

light_source {
	<0, 5, 20>
	color Gray50
}
light_source {
	<-10, 5, 10>
	color Gray50
}
light_source {
	< 10, 5, 10>
	color Gray50
}
light_source {
	< 36, 50, 0>
	color Gray50
}
light_source {
	< 18, 50, 0>
	color Gray50
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end


#local nBooks = 20;

// height, width, fontSize
#local Dimensions = array[nBooks][3] {
	{18,   3, 1.0}		// Bubble, Bubble, Toil and Trouble
	{17,   5, 1.0}		// 101 Uses for a Dead Henchman
	{18,   4, 1.1}		// Spell Components For Less
	{14,   3, 1.0}		// Martha Stewart On Potions
	{15,   3, 1.5}		// Of Newts
	{12,   5, 1.5}		// Pyromancy
	{15,   3, 1.0}		// The Forging of Stormbringer
	{14,   3, 1.0}		// Residual Mana
	{13,   3, 1.0}		// Purify and Cleanse Thyself
	{15,   4.5, 1.0}	// Rituals for Everyday Living
	{14,   3.5, 1.0}	// Death Of A Sorceror
	{15,   3, 1.0}		// Derivative Securities
	{14,   3, 1.0}		// The Healing Properties of Clay
	{17,   4, 1.0}		// Renovating Extradimensional Spaces
	{18,   3, 1.0}		// Zen and the Art of Spellcasting
	{14,   4, 1.2}		// To Serve Man
	{16,   5, 1.5}		// Temporal Stability
	{15,   3, 1.0}		// Divination
	{15,   4, 1.2}		// Evocation
	{18,   3, 1.0}		// Witches Brew Is Good For You
}

// cover texture, title + band texture
#local Textures = array[nBooks][2] {
	{texture{T_brownleather}, texture {T_Gold_3B} } // Bubble, Bubble, Toil and Trouble
	{texture{T_darkredleather}, texture {T_Gold_1B} } // 101 Uses for a Dead Henchman
	{texture{T_brownleather}, texture {T_Gold_1A} } // Spell Components For Less
	{texture{T_agedleather}, texture {T_Gold_1A} } // Martha Stewart On Potions
	{texture{T_agedleather}, texture {T_Gold_5C} } // Of Newts
	{texture{T_ironcrown}, texture {T_Gold_4C} } // Pyromancy
	{texture{T_blackleather}, texture {T_Gold_1A} } // The Forging of Stormbringer
	{texture{T_redleather}, texture {T_Gold_1A} } // Residual Mana
	{texture{T_darkgreenleather}, texture {T_Gold_2C} } // Purify and Cleanse Thyself
	{texture{T_brownleather}, texture {T_Gold_1A} } // Rituals for Everyday Living
	{texture{T_agedleather}, texture {T_Gold_1A} } // Death Of A Sorceror
	{texture{T_blackleather}, texture {T_Gold_5A} } // Derivative Securities
	{texture{T_darkredleather}, texture {T_Gold_1A} } // The Healing Properties of Clay
	{texture{T_redleather}, texture {T_Gold_1A} } // Renovating Extradimensional Spaces
	{texture{T_agedleather}, texture {T_Gold_2C} } // Zen and the Art of Spellcasting
	{texture{T_darkredleather}, texture {T_Gold_2C} } // To Serve Man
	{texture{T_darkredleather}, texture {T_Gold_1A} } // Temporal Stability
	{texture{T_bloodleather}, texture {T_Gold_1A} } // Divination
	{texture{T_blackleather}, texture {T_Gold_1A} } // Evocation
	{texture{T_darkbrownleather}, texture {T_Gold_1A} } // Witches Brew Is Good For You
}

// book title, font
#local Titles = array[nBooks][2] {
	{"Bubble, Bubble, Toil and Trouble", "TIMROM.TTF"}
	{"101 Uses for a Dead Henchman", "TIMROM.TTF"}
	{"Spell Components For Less", "TIMROM.TTF"}
	{"Martha Stewart On Potions", "TIMROM.TTF"}
	{"Of Newts", "TIMROM.TTF"}
	{"Pyromancy", "TIMROM.TTF"}
	{"The Forging of Stormbringer", "TIMROM.TTF"}
	{"Residual Mana", "TIMROM.TTF"}
	{"Purify and Cleanse Thyself", "TIMROM.TTF"}
	{"Rituals for Everyday Living", "TIMROM.TTF"}
	{"Death Of A Sorceror", "TIMROM.TTF"}
	{"Derivative Securities", "TIMROM.TTF"}
	{"The Healing Properties of Clay", "TIMROM.TTF"}
	{"Renovating Extradimensional Spaces", "TIMROM.TTF"}
	{"Zen and the Art of Spellcasting", "TIMROM.TTF"}
	{"To Serve Man", "CRYSTAL.TTF"}
	{"Temporal Stability", "TIMROM.TTF"}
	{"Divination", "MERO_DEM.TTF"}
	{"Evocation", "MERO_DEM.TTF"}
	{"Witches Brew Is Good For You", "TIMROM.TTF"}
}

// translation for the titles
#local TitleTrans = array[nBooks] {
	<0.3, 16, 0.55>		// Bubble, Bubble, Toil and Trouble
	<0.3, 15, 0.55>		// 101 Uses for a Dead Henchman
	<0.3, 15, 0.55>		// Spell Components For Less
	<0.3, 12.7, 0.55>	// Martha Stewart On Potions
	<0.3, 10, 0.55>		// Of Newts
	<0.3, 9, 0.55>		// Pyromancy
	<0.3, 13.5, 0.55>	// The Forging of Stormbringer
	<0.3, 10, 0.55>		// Residual Mana
	<0.3, 12, 0.55>		// Purify and Cleanse Thyself
	<0.3, 13, 0.55>		// Rituals for Everyday Living
	<0.3, 11, 0.55>		// Death Of A Sorceror
	<0.3, 11.5, 0.55>	// Derivative Securities
	<0.3, 13.3, 0.55>	// The Healing Properties of Clay
	<0.3, 16, 0.55>		// Renovating Extradimensional Spaces
	<0.3, 15.5, 0.55>	// Zen and the Art of Spellcasting
	<0.3, 10.5, 0.59>	// To Serve Man
	<0.3, 13.7, 0.56>	// Temporal Stability
	<0.3, 11.5, 0.55>	// Divination
	<0.3, 11.5, 0.55>	// Evocation
	<0.3, 15.5, 0.55>	// Witches Brew Is Good For You
}

// decoration
#local Decorations = array[nBooks][4] {
	{17.0, 1.0, 0, 0}	// Bubble, Bubble, Toil and Trouble
	{0, 0, 0, 0}		// 101 Uses for a Dead Henchman
	{0, 0, 0, 0}		// Spell Components For Less
	{0, 0, 0, 0}		// Martha Stewart On Potions
	{14.0, 13.6, 1.0, 1.4}	// Of Newts
	{0, 0, 0, 0}		// Pyromancy
	{0, 0, 0, 0}		// The Forging of Stormbringer
	{12.5, 11.5, 2.5, 1.5}	// Residual Mana
	{0, 0, 0, 0}		// Purify and Cleanse Thyself
	{0, 0, 0, 0}		// Rituals for Everyday Living
	{0, 0, 0, 0}		// Death Of A Sorceror
	{0, 0, 0, 0}		// Derivative Securities
	{0, 0, 0, 0}		// The Healing Properties of Clay
	{0, 0, 0, 0}		// Renovating Extradimensional Spaces
	{0, 0, 0, 0}		// Zen and the Art of Spellcasting
	{13.1, 13.0, 1.0, 1.1}	// To Serve Man
	{0, 0, 0, 0}		// Temporal Stability
	{0, 0, 0, 0}		// Divination
	{0, 0, 0, 0}		// Evocation
	{0, 0, 0, 0}		// Witches Brew Is Good For You
}

#declare Books5 = union {

#local X = 36;
#local N = 0;

#while ( N < nBooks )
	#local Height = Dimensions[N][0];
	#local Width = Dimensions[N][1];
	#local Width2 = Width/2;
	#local Length = 10.0;
	#local T_cover = Textures[N][0]

	union {
		difference {	// the spine
			cylinder {<0,0,0>, <0,Height,0>, (Width2) }
			cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2) }
			box { <-Width,-1,-Width>, <Width,Height+1,0> }
			scale <1, 1, 0.5/Width2>
		}
		difference {
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25 }
			cylinder {<-Width,-1,-0.1>, <-Width,Height+1,-0.1>, 0.15}
			box { <-Width-1,-1,-Width>, <-Width,Height+1,Width> }
			scale <0.5,1,1>
		}
		difference {
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25}
			cylinder {<Width,-1,-0.1>, <Width,Height+1,-0.1>, 0.15}
			box { <Width,-1,-Width>, <Width+1,Height+1,Width> }
			scale <0.5,1,1>
		}

		// the covers
		box {<-Width2,0,-Length>,<-Width2+0.1,Height,-0.2>}
		box {<Width2,0,-Length>,<Width2-0.1,Height,-0.2>}

		// the paper
		difference {
			box { <-Width2+0.01, 0.25, -Length+0.25>,
					<Width2-0.01, Height-0.25, 1>
			}
			difference {
				box { <-Width, -1, 0>, <Width, Height+1, 3> }
				cylinder {<0,-1,0>, <0,Height+1,0>, ((Width-0.25)/2)
					scale <1,1,0.5/Width2>
				}
			}
			cylinder {<0,-1,2*(-Length+0.25)>, <0,Height+1,2*(-Length+0.25)>,
				((Width-0.25)/2)
				scale <1,1, 0.5>
			}
			cylinder {<-Width,0,-0.1>, <-Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			cylinder {<Width,0,-0.1>, <Width,Height,-0.1>, 0.25
				scale <0.5,1,1>
			}
			texture { T_paper }
		}

		#local T_title = Textures[N][1]
		#local Title = Titles[N][0]
		#local Font = Titles[N][1]
		#local Trans = TitleTrans[N];
		#local FontSize = Dimensions[N][2];

		// the title
		text { ttf Font Title 0.2, 0
			rotate <0,180,90>
			scale <FontSize, FontSize, 1.0>
			translate Trans
			texture { T_title }
		}

		#if ( Decorations[N][0] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][0],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][1] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][1],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][2] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][2],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end
		#if ( Decorations[N][3] > 0 )
			torus { Width2, 0.1
				translate <0,Decorations[N][3],0>
				scale <1,1,0.5/Width2>
				texture { T_title }
			}
		#end

		texture { T_cover }

		translate <-Width2, 0, 0>	// left edge against Y axis

		translate <X, 0, 0>
	}

	#local N = N + 1;
	#local X = X - Width;
#end

}

#if (TestRender)
object { Books5 }
#end

#version Temp_Vers;
