#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A heavy oak bookshelf, darkened with age. It stands 8 1/2 feet
 * tall, and has shelves which are 6 feet wide and 2 feet deep. It
 * is created standing on the XZ plane, centered about the Y axis.
 *
 * Scale is 1 POVunit == 1 foot.
 */

#if (TestRender)
#include "colors.inc"
#include "woods.inc"

camera {
	location <0,4.25,-12>
	look_at <0,4.25,0>
}

light_source {
	<0, 5, -20>
	color White
}
light_source {
	<-10, 5, -10>
	color White
}
light_source {
	< 10, 5, -10>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }
#end

#declare T_Cabinet = texture { T_Wood2 }

#declare Bookshelf1 = union {
	// left and right cabinet panels are 3" thick to support
	// the heavy weight of the books, with grooves for the shelves
	difference {
		box { <-1, -0.15, 0>, <1, 0.10, 8.5> }

		// cut grooves for the shelves
		box { <-2, 0, 0.50>, <2, 1, 0.62> }
		box { <-2, 0, 2.50>, <2, 1, 2.62> }
		box { <-2, 0, 4.50>, <2, 1, 4.62> }
		box { <-2, 0, 6.50>, <2, 1, 6.62> }

		texture { T_Cabinet }

		rotate <0, 90, 0>
		rotate <0, 0, 90>
		translate <3.1, 0, 0>
	}
	difference {
		box { <-1, -0.15, 0>, <1, 0.10, 8.5> }

		// cut grooves for the shelves
		box { <-2, 0, 0.50>, <2, 1, 0.62> }
		box { <-2, 0, 2.50>, <2, 1, 2.62> }
		box { <-2, 0, 4.50>, <2, 1, 4.62> }
		box { <-2, 0, 6.50>, <2, 1, 6.62> }

		texture { T_Cabinet }

		rotate <0, -90, 0>
		rotate <0, 0, -90>
		translate <-3.1, 0, 0>
	}

	// the shelves are just over 1" thick, and 6 feet wide
	union {
		box { <-3.08, 0.50, -1>, <3.08, 0.60, 0.979> }
		box { <-3.08, 2.50, -1>, <3.08, 2.60, 0.979> }
		box { <-3.08, 4.50, -1>, <3.08, 4.60, 0.979> }
		box { <-3.08, 6.50, -1>, <3.08, 6.60, 0.979> }

		// the top
		box { <-3.25, 8.50, -1.000>, <3.25, 8.60, 1> }

		texture { T_Cabinet }
	}

	// the toe kick is slightly recessed from the front
	box { <-3.00, -0.02, 0.00>, <3.00, 0.00, 0.50>
		texture { T_Cabinet }
		rotate <-90, 0, 0>
		translate <0, 0, -0.8>
	}

	// the back is a 1/4" thick panel
	box { <-3.25, 0.00, 0.00>, <3.25, 0.02, 8.50>
		texture { T_Cabinet }
		rotate <-90, 0, 0>
		translate <0, 0, 1.00>
	}
}

#if (TestRender)
object { Bookshelf1 }
#end

#version Temp_Vers;
