#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A candle with dripping wax.
 *
 * Scale is 1 POVunit == 1 inch.
 * Candle base is centered in XZ plane, Y=0
 * You should copy the first light_source for the candlelight
 */

#if (TestRender)

#include "colors.inc"
#include "metals.inc"


// Copy out this light_source to whatever file you include the candle in.
light_source {
	<0,6.5,0>
	color Yellow
	area_light <0,0,0.04>, <0.04,0,0>, 2, 2
	adaptive 1
//	don't use jitter. Candlelight looks better without it

	fade_distance 10
	fade_power 1
}

camera {
	location <0,6,-2>
	look_at <0,6,0>
}

light_source {
	<0, 2, -20>
	color White
}

light_source {
	<0, 5, -15>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

background { White }

#end

#declare T_candlewax = texture {
	pigment { color rgbf <0.44, 0.86, 0.58, 0.01> }
	finish {
		ambient 0.1
		diffuse 0.5
		reflection 0.05
		irid {	0.2
			thickness 0.1
		}
	}
}

#declare T_candlewick = texture {
	pigment {
		gradient y
		color_map {
		[0.00 color rgb <1.00,1.00,1.00>]
		[1.00 color rgb <0.00,0.00,0.00>]
		}
		frequency 3
	}
	finish {
		ambient 0.4
		diffuse 0.4
		crand 0.6
		brilliance 1.2
		specular 0.2
		roughness 0.05
	}
}

#declare T_litcandlewick = texture {
	pigment { rgb <1,0,0> }
	finish {
		ambient 0.6
		diffuse 0.6
		crand 0.6
		brilliance 10.0
		specular 0.2
		roughness 0.05
	}
}

#declare T_moltenwax = texture {
	pigment { color rgbf < 0.44, 0.86, 0.58, 0.9> }
	finish {
		ambient 0.7
		diffuse 0.7
		reflection 0.4
		irid {	0.4
			thickness 0.1
		}
		brilliance 1.0
	}
}

#declare CandleFlame = merge {
	sphere { <0, 0.8, 0>, 0.02 }
	cone { <0,0,0>, 0.1
		<0,0.8,0>, 0.02
	}
	sphere { <0,0,0>, 0.1 }

	texture {
		pigment {
			onion
			color_map {
				[0.00 rgbft <0.5, 0.5, 1.0, 0.2, 0.4> ]
				[0.20 rgbft <1.0, 1.0, 0.1, 0.1, 0.5> ]
				[0.60 rgbft <1.0, 1.0, 0.1, 0.8, 0.0> ]
				[0.90 rgbft <1.0, 1.0, 0.1, 0.2, 0.2> ]
				[1.00 rgbft <1.0, 1.0, 0.1, 0.2, 0.4> ]
			}
		}

		finish {
			ambient 1.0
			diffuse 1.0
			brilliance 200.0
		}
	}

	no_shadow
}

#declare CandleStick = merge {
	// Candle Body
	blob {
		threshold 0.6

		cylinder { <0,0,0>, <0,4,0>, 0.5, 1}
		sphere { <0,4,0>, 0.35, -20}

		// a drip
		cylinder { <0.21,4,0>, <0.21,2,0>, 0.1, 1}
		sphere { <0.21,2,0>, .11, 1.9}

		texture { T_candlewax }
	}

	// wick
	cylinder {
		<0,0,0>, <0,4.0,0>, 0.03
		texture { T_candlewick }
	}
	// lit end of wick
	cylinder {
		<0,4.0,0>, <0,4.05,0>, 0.03
		texture { T_litcandlewick }
	}

	// molten wax
	sphere {
		<0,0,0>, 0.2
		scale <1,0.25,1>
		translate <0,3.74,0>
		texture { T_moltenwax }
	}
}

#declare CandleBase = intersection {
	lathe {
		cubic_spline
		11,
		<2.00, -1.00>,
		<1.00,  0.00>,
		<0.50,  0.25>,
		<0.25,  0.50>,
		<0.25,  0.60>,
		<0.35,  0.75>,
		<0.25,  1.00>,
		<0.25,  1.50>,
		<0.35,  1.75>,
		<0.34,  2.00>,
		<0.33,  3.00>
	}

	// a hexagon
	prism {
		conic_sweep
		linear_spline
		0, 1, 7
		<cos(( 0/6)*2*pi), sin(( 0/6)*2*pi)>,
		<cos(( 1/6)*2*pi), sin(( 1/6)*2*pi)>,
		<cos(( 2/6)*2*pi), sin(( 2/6)*2*pi)>,
		<cos(( 3/6)*2*pi), sin(( 3/6)*2*pi)>,
		<cos(( 4/6)*2*pi), sin(( 4/6)*2*pi)>,
		<cos(( 5/6)*2*pi), sin(( 5/6)*2*pi)>,
		<cos(( 6/6)*2*pi), sin(( 6/6)*2*pi)>

		scale <1, 3, 1>
		rotate <180,0,0>
		translate <0,3,0>
	}

	texture { T_Copper_1C }
}

#declare Candle = union {
	object { CandleBase }
	object { CandleStick
		translate <0,2,0>
	}
	object { CandleFlame
		translate <0,6.00,0>
	}
}

#if (TestRender)
object { Candle }
#end

#version Temp_Vers;
