#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A candle snuffer, made of silver. Roughly 1 1/2 feet long,
 * the cone is centered at the origin, sitting on the XZ plane.
 * The handle extends down the positive Z axis.
 *
 * Scale is 1 POVunit == 1 inch.
 */

#if (TestRender)
#include "colors.inc"
#include "metals.inc"

camera {
	location <-15,1,-9>
	look_at <0,0,-9>
}

light_source { <0, 10,  -10> color White}
light_source { <0, 10,   10> color White}
light_source { <-10, 10, 0>  color White}
light_source { < 10, 10, 0>  color White}
light_source { <0, 10,   0>  color White}
light_source { <-10, 0,  0>  color White}
light_source { < 10, 0,  0>  color White}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}
#end

#local T_CandleSnuffer = texture { T_Brass_2A }

#local T_CandleSnuffer = texture {
	pigment { color rgb <0.93, 0.94, 0.75> }
	finish {
		ambient 0.35
		diffuse 0.4
		brilliance 1.2
		metallic
		specular 0.4
		roughness 1/40
	}
}

#declare CandleSnuffer = merge {
	cone { <0,0,0>, 1, <0, 2, 0> 0.125 }
	sphere { <0, 2, 0>, 0.20 }
	cylinder { <0, 2, 0>, <0, 0, -18>, 0.16 }
	sphere { <0, 0, -18>, 0.16 }

	texture { T_CandleSnuffer }
}

#if (TestRender)
object { CandleSnuffer }
#end

#version Temp_Vers;
