#version 3.1;
#include "colors.inc"
#include "metals.inc"
#include "woods.inc"
#include "stones.inc"

/*
 * Edwin's shop. curious goods.
 * scale is 1 POVunit == 1 foot.
 */

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

camera {
	location <25,4,1>
	look_at <30,2,10>
}

// illuminate the front and top of the desk
light_source {
	<27.75, 10, 0>
	color Gray30
	fade_distance 7
	fade_power 10
}

// bright light from computer room, casts shadows on the floor
light_source {
	<22, 14, 50>
	color White
	fade_distance 50
	fade_power 1
}

#declare T_plaster = texture {
	pigment { color rgb <1.0,1.0, 0.9> }
	finish {
		specular 0.1
		roughness 0.3
		crand 0.05
	}
}

// define the main walls
union {
	// left wall
	box {<-0.3,0,0>, <0, 20, 40> }

	// close back wall
	difference {
		box {<0,0,40>, <50, 20, 40.5> }
		box {<24,-1,39>, <28, 8, 41>}
		box {<32,-1,39>, <36, 8, 41>}
	}

	// far back wall
	box {<0,0,80>, <100, 20, 80.3> }

	// ceiling
	box {<0,14,0>, <100,14.3,80> }

	// partition wall in back
	box {<31, 0, 40.5>, <31.3, 20, 80> }

	// right wall
	box {<99.7,0,0>, <100, 20, 80> }

	texture { T_plaster }
}

#include "floor.inc"
// the floor
box {<0,-0.3,0>, <50,0,80>
	texture { T_FloorTile }
}

// The frame around the doorway to the computer room
merge {
        box { <23.6, 0.00, 39.9>, <24.1, 8.00, 40.6>
                texture { T_Wood1 rotate <90, 0, 0> }
        }
        box { <27.6, 0.00, 39.9>, <28.1, 8.00, 40.6>
                texture { T_Wood1 rotate <90, 0, 0> }
        }
        box { <23.6, 8.01, 39.9>, <28.1, 8.40, 40.6>
                texture { T_Wood1 rotate <90, 0, 90> }
        }
}

// The frame around the doorway to the stacks
merge {
	box { <31.6, 0.00, 39.9>, <32.1, 8.00, 40.6>
		texture { T_Wood1 rotate <90, 0, 0> }
	}
	box { <35.6, 0.00, 39.9>, <36.1, 8.00, 40.6>
		texture { T_Wood1 rotate <90, 0, 0> }
	}
	box { <31.6, 8.01, 39.9>, <36.1, 8.40, 40.6>
		texture { T_Wood1 rotate <90, 0, 90> }
	}
}


// "The Loremaster is OUT"
#declare LoremasterIn=0;
#include "inoutsign.inc"
object {
	InOutSign
	rotate <0,90,0>
	scale 1/12
	translate <-0.15, 0, 0>

	translate <29.9,4.5,4.2>
}
light_source { <29, 4.5, 3.7> color Gray10 fade_distance 2 fade_power 3 }

// Edwin's desk
#include "desk.inc"
object {
	EdwinDesk
	rotate <0,-90,0>
	scale 1/12

	translate <27.75,0,4>
}

#include "stool.inc"
object {
	EdwinStool
	scale 0.9
	translate <25.6, 0, 7>
}

/*
 * Some items on Edwin's desk
 * The desk is 4 feet wide and 3 feet deep
 */

/*
 * The Mana compass.
 */
#include "compass.inc"
object {
	Mana_Compass
	scale 1/12	// convert inches -> feet
	rotate <0,16,0>

//	translate <25.9, 3, 4.75>
	translate <27.2, 3, 4.85>
}

/*
 * Palm computer Edwin has been using to access a Coalition
 * tactical database.
 */
#include "palmcomp.inc"
object {
	Pocket_Comp
	scale 1/12
	rotate <90, 0, 0>
	rotate <0, 27, 0>
	translate <27.1, 3, 2.70>
}

/*
 * A candle to see by.
 */
#include "candle.inc"
object {
	Candle
	scale 1/6	// don't scale it down too much
	translate <26.5, 3, 4.75>
}

// Candle light
light_source { <26.5, 4.25, 4.75>
	color rgb <1, 1, 0>
	area_light <0,0,0.04>, <0.04,0,0>, 2, 2
	adaptive 1
//	don't use jitter. Candlelight looks better without it

	fade_distance 4
	fade_power 1
}

/*
 * some notes Edwin was working on.
 */
#include "tomeofpower.inc"
#include "paper.inc"
merge {
	object { Chronicle
		rotate x*-0.9
	}
	object { TomeOfPower
		scale <0.5, 1, 1>
		rotate z*-90
		rotate x*90
		translate <0, 11.54, -1>
	}

	scale 1/12
	rotate <90, 0, 0>
	rotate <0, 32, 0>

	translate <25.5, 3, 2.65>
}

#include "glasses.inc"
object {
	Glasses
	rotate <3, 0, 0>
	translate <0, 0.782, 0>
//	translate <0, 0.085, 0>
	scale 1/12
	rotate <0, 25, 0>
	translate <25.8, 3, 2.6>
}

#include "incunabula.inc"
object {
	Incunabula
	rotate <0, 0, -90>
	rotate <0, -57, 0>
	translate <0, 1.5, 0>
	scale 1/12
	
	translate <28.5, 3, 4.25>
}

// Edwin's pipe and pipe bowl.
#include "pipe.inc"
object {
	PipeAndBowl
	scale 1/12
	rotate <0, -120, 0>
	translate <27.8, 3, 4.45>
}

// An ancient Elvish flute Edwin is examining
#include "flute.inc"
object {
	Flute
	translate <0, 0.5, 0>
	rotate <-45, 0, 0>
	scale 1/12
	rotate <0, 76, 0>
	translate <28.5, 3, 3.15>
}

/*
 * Edwin's hats sit on a dressing table in the side room.
 */
#include "longvanity.inc"
object {
	LongVanity
	translate <30, 0, 39>
}
#include "gnomehat.inc"
object { Hat_Stand
	translate <29, 2.00, 39>
}
object { Gnome_Hat
	translate <29, 2.75, 39>
}
object { Hat_Stand
	translate <30, 2.00, 39>
}
object { Gnome_Hat
	rotate <0, 0, 2>
	translate <30, 2.75, 39>
}
object { Hat_Stand
	translate <31, 2.00, 39>
}
// illuminate the hats gently
light_source { <30, 2.5, 38> color Gray05 fade_distance 5 fade_power 3 }
light_source { <30, 2.5, 39.5> color Gray05 fade_distance 5 fade_power 3 }


// Bookshelves!
#include "bookshelf1.inc"
object {
	Bookshelf1
	translate <33, 0, 4>
}

object {
	Bookshelf1
	translate <33, 0, 11>
}
// illuminate the front of the bookshelf
light_source { <33, 1.5, 7.5> color Gray10 fade_distance 8 fade_power 3 }
light_source { <33, 3.5, 7.5> color Gray10 fade_distance 8 fade_power 3 }
light_source { <33, 5.5, 7.5> color Gray10 fade_distance 8 fade_power 3 }
light_source { <33, 7.5, 7.5> color Gray10 fade_distance 8 fade_power 3 }

#include "booktextures.inc"

#include "books10.inc"
object { Books10	// Technical books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 6.6, 10.1>
}

#include "books5.inc"
object { Books5		// Magic books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 4.6, 10.1>
}

#include "books6.inc"
object { Books6		// More Magic books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 2.6, 10.1>
}
#include "books8.inc"
object { Books8		// junk, only barely visible.
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 0.6, 10.1>
}

object {
	Bookshelf1
	translate <33, 0, 22>
}
// illuminate the front of the bookshelf
light_source { <33, 1.5, 16.5> color Gray10 fade_distance 8 fade_power 3 }
light_source { <33, 3.5, 16.5> color Gray10 fade_distance 8 fade_power 3 }
light_source { <33, 5.5, 16.5> color Gray10 fade_distance 8 fade_power 3 }
light_source { <33, 7.5, 16.5> color Gray10 fade_distance 8 fade_power 3 }

#include "books4.inc"
object { Books4		// Science Fiction
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 6.6, 21.1>
}

#include "books1.inc"
object { Books1		// Rolemaster. Lots and lots of Rolemaster.
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 4.6, 21.1>
}
#include "books3.inc"
object { Books3		// a tribute to the players and characters
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 2.6, 21.1>
}
#include "books9.inc"
object { Books9		// science books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <33, 0.6, 21.1>
}

// Another row of bookshelves
object {
	Bookshelf1
	translate <20.6, 0, 4>
}
object {
	Bookshelf1
	translate <20.6, 0, 11>
}
object {
	Bookshelf1
	translate <20.6, 0, 22>
}
#include "books7.inc"
object { Books7		// technical books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <20.6, 0.6, 21.1>
}
#include "books2.inc"
object { Books2		// Time/Life "Forgotten Lore" series
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <20.6, 2.6, 21.1>
}


// Edwin's Cray, in the back room.
#include "cray.inc"
object {
	Cray1
	rotate <0, -9, 0>
	translate <26.9,0,50>
	no_shadow
}
// illuminate the front of the cray more clearly
light_source { <26.9, 1, 40> color Gray20 fade_distance 10 fade_power 3 }

// Mathilda
#include "mathilda.inc"
#include "candlesnuff.inc"
merge {
	object { Mathilda }
	object {
		CandleSnuffer
		translate <0, 0, 18>
		rotate y*90
		rotate z*-17.8
		scale 1/12	// convert inches->feet
		translate <0.8, 3.33, -0.01>
		rotate z*20
	}

	rotate y*35
	translate <25.2, 0, 12>
}

// The stacks, in the far back room
light_source { <32, 14, 41> color Gray30 fade_distance 10 fade_power 1 }

object {
	Bookshelf1
	translate <41, 0, 45>
}
light_source { <39, 1.5, 41.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 3.5, 41.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 5.5, 41.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 7.5, 41.5> color Gray10 fade_distance 8 fade_power 2 }

/* Cheat and re-use some books */
object { Books7		// technical books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 0.6, 44.1>
}
object { Books8
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 2.6, 44.1>
}
object { Books2		// Time/Life "Forgotten Lore" series
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 4.6, 44.1>
}
#include "books11.inc"
object { Books11
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 6.6, 44.1>
}

object {
	Bookshelf1
	translate <41, 0, 52>
}
light_source { <39, 1.5, 48.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 3.5, 48.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 5.5, 48.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 7.5, 48.5> color Gray10 fade_distance 8 fade_power 2 }

object { Books8
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 0.6, 51.1>
}
object { Books11
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 2.6, 51.1>
}
object { Books7		// technical books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 4.6, 51.1>
}
object { Books2		// Time/Life "Forgotten Lore" series
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 6.6, 51.1>
}


object {
	Bookshelf1
	translate <41, 0, 59>
}
light_source { <39, 1.5, 55.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 3.5, 55.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 5.5, 55.5> color Gray10 fade_distance 8 fade_power 2 }
light_source { <39, 7.5, 55.5> color Gray10 fade_distance 8 fade_power 2 }
object { Books2
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 0.6, 58.1>
}
object { Books11
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 2.6, 58.1>
}
object { Books7		// technical books
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 4.6, 58.1>
}
object { Books8
	scale 1/12	// convert inches -> feet
	rotate <0, 180, 0>
	translate <41, 6.6, 58.1>
}

// more bookshelves extending off into infinity.
object {
	Bookshelf1
	translate <41, 0, 66>
}
object {
	Bookshelf1
	translate <41, 0, 73>
}
