#declare Temp_Vers = version;
#version 3.1;


// Edwin's desk. Scale is 1 POVunit == 1 inch
// desk is 4 feet wide, 3 feet high, and 3 feet deep



#declare TestRender = 0;

#if (TestRender)
#include "colors.inc"

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

camera {
//	location <30,46,-40>
//	look_at <0,30,12>
	location <30, 35.5, 27>
	look_at <0, 35.5, 26>
}

light_source {
	<-30, 0, -15*12>
	color White
}

light_source {
	<30, 0, -15*12>
	color White
}

light_source {
	<0, 72, 0>
	color White
}

light_source {
	<30, 21, 0>
	color White
}

#end


/* "Eureka_Wood" texture declaration. A dark, somewhat reddish brown wood
	with very tiny, delicate grain, augmented by a nearly subliminal 2nd
	layer consisting of faint black speckles elongated along the grain.
	Created by Charles Fusner 12/29/97... donated for use in derivative
	works. 
*/
#declare Eureka_Wood = texture {
	pigment {
		wood
		color_map {
		[ 0.00 color rgb <0.53, 0.23, 0.13> ]
		[ 0.45 color rgb <0.53, 0.23, 0.13> ]
		[ 0.55 color rgb <0.58, 0.28, 0.18> ]
		[ 1.00 color rgb <0.58, 0.28, 0.18> ]
		}
		scallop_wave
		scale .1
		warp { turbulence < .04, .04, 0 > lambda 1.8 omega .375 }
	}
	finish {
		specular .05 roughness 1.0
		crand .1
	}
}
texture {
	pigment {
		granite
		color_map {
		[ 0.00 rgbt<0.25, 0.15, 0.15, 0.25> ]
		[ 0.05 rgbt<.58, .23, .13, 0.25> ]
		[ 0.10 rgbt<.58, .23, .13, 1.0> ]
		[ 1.00 rgbt<.58, .23, .13, 1.0> ]
		}
		frequency 6
		scale <1,1,100>
	}
	finish {
		specular .05 roughness 1.0
		crand .1
	}
}


#declare EdwinDesk = union {
        // the legs
        cylinder { <-18,0,-24>, <-18,35.5,-24>, 1
                texture { Eureka_Wood }
        }
        cylinder { <+18,0,-24>, <+18,35.5,-24>, 1
                texture { Eureka_Wood }
        }
        cylinder { <-18,0,+24>, <-18,35.5,+24>, 1
                texture { Eureka_Wood }
        }
        cylinder { <+18,0,+24>, <+18,35.5,+24>, 1
                texture { Eureka_Wood }
        }

        // the desk top
        intersection {
        	merge {
			box { <-20.00,35.5,-26>, <-15,36,26>
				texture { Eureka_Wood rotate y*2 }
			}
			box { <-14.95,35.5,-26>, <-10,36,26>
				texture { Eureka_Wood rotate y*3 }
			}
			box { < -9.95,35.5,-26>, < -5,36,26>
				texture { Eureka_Wood
					translate <-20, 0, 0>
					rotate y*-1
				}
			}
			box { < -4.95,35.5,-26>, <  0,36,26>
				texture { Eureka_Wood
					translate <-15, 0, 0>
				}
			}
			box { < +0.05,35.5,-26>, < +5,36,26>
				texture { Eureka_Wood
					translate <17, 0, 0>
					rotate y*-2
				}
			}
			box { < +5.05,35.5,-26>, <+10,36,26>
				texture { Eureka_Wood
					translate <20, 0, 0>
					rotate y*3
				}
			}
			box { <+10.05,35.5,-26>, <+15,36,26>
				texture { Eureka_Wood rotate y*-2 }
			}
			box { <+15.05,35.5,-26>, <+20,36,26>
				texture { Eureka_Wood }
			}
		}
		cylinder { <-30, 71.5, 0>, <30, 71.5, 0>, 26
			scale <1, 0.5, 1>
			texture { Eureka_Wood }
		}
		cylinder { <0, 71.5, -30>, <0, 71.5, 30>, 20
			scale <1, 0.5, 1>
			texture { Eureka_Wood }
		}
	}

        // Desk sides
        box { <-17.5,18,-24.25>, <17.5,35.5,-23.75>
                texture { Eureka_Wood }
        }
        box { <-17.5,18,+23.75>, <17.5,35.5,+24.25>
                texture { Eureka_Wood }
        }
        box { <-18.25,18,-24>, <-17.75,35.5,+24>
                texture { Eureka_Wood }
        }
        difference {
                box { <+17.75,32,-24>, <+18.25,35.5,+24> }
                box { <17.5,32.5,-11.5>, <18.5,35.0,+11.5> }
                texture { Eureka_Wood }
        }

        // drawer
        union {
                box { <18.25,32.5,-12>, <18.5,35.1,+12> }       // front
                box { <18.25,32.5,-11.5>, <6.25,35.0,-11.375> } // left
                box { <18.25,32.5,+11.375>, <6.25,35.0,+11.5> } // right
                box { <6.125,32.5,-12>, <6.25,35.0,+12> }       // back
                box { <6.125,32.5,-11.5>, <18.25,32.625,+11.5> } // bottom
                texture { Eureka_Wood }
        }
}


#if (TestRender)
	object { EdwinDesk }
#end
