#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 * A gnomish hat, slightly crumpled.
 *
 * Brim of hat is centered at the origin, peak
 * of hat is up the Y axis. The hat is 1 1/2 feet
 * high.
 *
 * The "foot" of the hat stand rests on the XZ
 * plane. The hat stand is a sphere of steel bands,
 * supported by a round base. The hat stand is
 * just over a foot from base to tip. The make the hat
 * rest on the hat stand, translate it 0.75 units
 * up the Y axis.
 *
 * Scale is 1 POVunit == 1 foot.
 *
 * by Denton Gentry.
 * last modified 1/4/99
 */

#if (TestRender)
#include "colors.inc"
#include "metals.inc"

camera {
	location <-0.1,0.5,-3>
	look_at <0,0,0>
}

light_source {
	<0, 20, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

light_source {
	<0, 10, 0>
	color White
}

light_source {
	<0, -10, 0>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb <1, 1, 1>
}

background { White }
#end

// "Felt" is a bit of a misnomer. It is closer to velvet.
#local Red_Felt = texture {
	pigment {
		crackle
		colour_map {
			[ 0.00 color rgb <0.95, 0.16, 0> ]
			[ 0.95 color rgb <0.98, 0.2, 0> ]
			[ 1.00 color rgb <0, 0, 0> ]
		}
	}
	finish {
		ambient 0.1
		diffuse 0.7
		reflection 0.05
		irid { 0.05
			thickness 0.2
		}
		phong 0.1
		phong_size 40.0
	}
}

#declare Gnome_Hat = union {
	cone { <0,0,0>, 0.4
		<0,1.5,0>, 0.02
		open
	}

	sphere { <0,1.5,0>, 0.02 }

	texture { Red_Felt }
}

#declare Hat_Stand = union {
	difference {
		union {
			torus { 0.39, 0.01
				rotate <90,0,0>
			}
			torus { 0.39, 0.01
				rotate <90,45,0>
			}
			torus { 0.39, 0.01
				rotate <90,90,0>
			}
			torus { 0.39, 0.01
				rotate <90,135,0>
			}
		}
		cylinder { <0, -1, 0>, <0,0.1, 0>, 0.1 }
	}

	torus { 0.1, 0.01
		translate <0, -0.39, 0>
	}

	torus { 0.25, 0.01
		translate <0, -0.69, 0>
	}

	cylinder { <0.25, -0.69, 0>, <0.1, -0.39, 0>, 0.01
		rotate <0, 0, 0>
	}
	cylinder { <0.25, -0.69, 0>, <0.1, -0.39, 0>, 0.01
		rotate <0, 60, 0>
	}
	cylinder { <0.25, -0.69, 0>, <0.1, -0.39, 0>, 0.01
		rotate <0, 120, 0>
	}
	cylinder { <0.25, -0.69, 0>, <0.1, -0.39, 0>, 0.01
		rotate <0, 180, 0>
	}
	cylinder { <0.25, -0.69, 0>, <0.1, -0.39, 0>, 0.01
		rotate <0, 240, 0>
	}
	cylinder { <0.25, -0.69, 0>, <0.1, -0.39, 0>, 0.01
		rotate <0, 300, 0>
	}

	texture { T_Chrome_2A }
	translate <0, 0.70, 0>
}

#if (TestRender)
object { Gnome_Hat
	translate <0, 0.75, 0>
}
object { Hat_Stand }
#end

#version Temp_Vers;
