#declare Temp_Vers = version;
#version 3.1;

#declare TestRender = 0;

/*
 *    The Loremaster is:
 *           IN
 *
 * A wooden sign darkened with age, nailed to the
 * wall, painted with "The Loremaster is:"
 * A smaller sign hangs from a peg, and is
 * reversible to say "IN" or "OUT". The
 * default is "OUT", by #declaring LoremasterIn=1
 * the sign will read "IN".
 *
 * The sign is 8x12 inches, 1/2 inch thick. The IN/OUT
 * tag hangs from a peg which sticks out another 1/2
 * inch. The back of the sign is flush with the XY plane.
 *
 * Scale for this model is 1 POVunit == 1 inch.
 */

#if (TestRender)

#include "colors.inc"
#include "metals.inc"
#include "woods.inc"

camera {
	location <0,0,-10>
	look_at <0,0,0>
}

light_source {
	<0, 2, -20>
	color White
}

light_source {
	<-10, 4, -10>
	color White
}

global_settings {
	assumed_gamma 1.8
	ambient_light rgb<1, 1, 1>
}

plane {
	<0,0,-1>,
	-2
	pigment { Green }
}
#end

#ifndef (LoremasterIn)		#declare LoremasterIn=0;	#end

#declare T_signwood = texture {
	T_Wood11
}
texture {	// the second texture is a layer of grime
	pigment {
		bumps
		color_map {
		[0.00  color rgbf <0.20,0.16,0.16,0.75>]
		[0.25  color rgbf <0.10,0.10,0.10,0.80>]
		[0.50  color rgbf <0.20,0.20,0.20,0.90>]
		[1.00  color rgbf <0.20,0.20,0.20,0.90>]
		}

		turbulence 0.3
	}
	finish {
		crand 0.4
		roughness 0.8
	}
	normal { dents .5 }
}

#declare T_tagwood = texture {
	T_Wood3
}
texture {	// the second texture is a layer of grime
	pigment {
		bumps
		color_map {
		[0.00  color rgbf <0.32,0.16,0.16,0.85>]
		[0.15  color rgbf <0.10,0.10,0.10,0.80>]
		[0.50  color rgbf <0.20,0.20,0.20,0.90>]
		[1.00  color rgbf <0.20,0.20,0.20,0.90>]
		}

		turbulence 0.3
	}
	finish {
		crand 0.4
		roughness 0.8
	}
	normal { dents .5 }
}

#declare T_fingerprint = texture {
	T_tagwood
}
texture {	// the top texture is the fingerprint
	pigment {
		wood
		color_map {
		[0.00, 0.15	color rgbf <0.32,0.16,0.16,0.70>
				color rgbf <0.32,0.16,0.16,0.70>]
		[0.15, 0.50 color rgbf <0.32,0.16,0.16,0.70>
				color rgbf <0.20,0.20,0.20,0.80>]
		[0.50, 1.00 color rgbf <0.20,0.20,0.20,0.80>
				color rgbf <0.20,0.20,0.20,0.80>]
		}
	}
	finish {
		crand 0.1
		roughness 0.1
		diffuse 0.9
		brilliance 0.6
	}
	normal { ripples .1 }
}




#declare InOutSign = union {
	// the sign backing
	union {
		// sign is made of two boards glued together
		difference {
			box {
				<-0.25,0.003,-6>, <0.25,4,6>
				texture { T_signwood }
				rotate <0,90,0>
			}

			// countersink for nails
			sphere {
				<5.25,3.25,-0.3>, 0.15
				texture { T_signwood }
			}

			sphere {
				<-5.25,3.25,-0.3>, 0.15
				texture { T_signwood }
			}
		}

		difference {
			box {
				<-0.25,-4,-6>, <0.25,0,6>
				texture { T_signwood }
				rotate <0,90,0>
			}

			// countersink for nails
			sphere {
				<5.25,-3.25,-0.3>, 0.15
				texture { T_signwood }
			}

			sphere {
				<-5.25,-3.25,-0.3>, 0.15
				texture { T_signwood }
			}
		}

		// four steel nails in the corners
		cylinder { <5.25,3.25,-0.21>, <5.25,3.25,0>, 0.1
			texture { T_Chrome_2A }
		}
		cylinder { <-5.25,3.25,-0.21>, <-5.25,3.25,0>, 0.1
			texture { T_Chrome_2A }
		}
		cylinder { <5.25,-3.25,-0.21>, <5.25,-3.25,0>, 0.1
			texture { T_Chrome_2A }
		}
		cylinder { <-5.25,-3.25,-0.21>, <-5.25,-3.25,0>, 0.1
			texture { T_Chrome_2A }
		}

		// a peg to hang the IN/OUT sign on.
		cylinder {
			<0,0,-0.5>, <0,0,0.5>, 0.1
			rotate <15, 0, 0>
			translate <0, 0.5, -0.7>

			texture { T_Wood13 }
		}

		text { ttf "klang.ttf" "The Loremaster is" 0.1, 0
			translate <-3.75,1.75,-0.26>
			pigment { Black }

			scale <1.25,1.25,1>
		}
	}

	// the reversible IN/OUT sign, hanging from the peg
	union {
		difference {
			box {
				<-0.1,-2,-2>, <0.1,2,2>
				texture { T_tagwood }
				rotate <0,90,0>
			}

			// a hole in the tag to hang it
			cylinder {
				<0,1,-1>, <0,1,1>, 0.5
				texture { T_Wood3 }
			}
		}

		// a smudged fingerprint
		cylinder {
			<0,0,-0.1001>, <0,0,0.10001>, 0.75
			texture { T_fingerprint }
	
			scale <0.6,1,1>
			rotate <0,0,30>
			translate <1,-1,0>
		}

	#if (LoremasterIn=1)
		text { ttf "CRYSTAL.TTF" "IN" 0.1, 0
			scale <1.9,1.9,1>
			translate <-0.75,-1.4,-0.1001>
			pigment { Black }
		}
	#else
		text { ttf "CRYSTAL.TTF" "OUT" 0.1, 0
			scale <1.9,1.9,1>
			translate <-1.3,-1.4,-0.1001>
			pigment { Black }
		}
	#end

		rotate <3,0,0>
		rotate <0,0,5>
		rotate <0,3,0>
		translate <0,-0.92,-0.57>
	}
	
	translate <0,0,-0.25>
}

#if (TestRender)
	object { InOutSign }
#end

#version Temp_Vers;
